#!/bin/bash
#CimProviderBuildRepository

cimserverBasePath="/var/lib/pegasus"
rebuildRepFile="${cimserverBasePath}/rebuildRepository"
restoreSubscriptionFile="${cimserverBasePath}/subscription-bakup.tar.gz"
cimprovidercmd="/usr/bin/cimprovider"
errorlog="${cimserverBasePath}/rebuildError.log"
cimserverStartStop="/etc/init.d/tog-pegasus"
debug=1
rebuildlog=${errorlog}
#rebuildlog=/dev/null
CIMSERVER_BIN=/usr/sbin/cimserver

debugPrint() {
    if [[ $debug == 1 ]] ; then
        echo $1
    fi

    return 0
}

usage() 
{
    echo "Usage: $0 <option> [option-parameter]"
    echo " <option>: rebuild, subbackup, subrestore"
    echo " the parameter for rebuild: [-f] [-b]"
    echo "   -f: force to rebuild the repository"
    echo "   -b: backup the indication subscription before rebuilding repository and restore them after the rebuild." 
    echo ""
}

backupOrRestoreIndicationSubscription()
{
    TMPDIR=/tmp/pegasus/subscriptonbakup
    if [ -d ${TMPDIR} ]; then
       TMPDIR=/tmp/pegasus/subscriptonbakup-`date  +m%d9/19/08M%S`
    fi
    mkdir -p ${TMPDIR} >> ${rebuildlog} 2>>${errorlog}
    if [[ $? == 1 ]]; then
        echo "can not create directory in /tmp, please check the free space in /tmp"
        exit 1;
    fi

    if [[ $1 == *restore* ]]; then
    if [ ! -f ${restoreSubscriptionFile} ]; then
        echo "The indication subscription back up file ${restoreSubscriptionFile} does not exist. No need to restore."
        exit 0;
    fi
    fi

    backupLogFile=${TMPDIR}/subscription.log
    oldpath=`pwd`
    cd ${TMPDIR}/

    if [[ $1 == *backup* ]]; then
        debugPrint "backuping"
        # record current cimserver version and indication mof version
        echo "archive-time `date +m%d9/19/08M%S`" > ${backupLogFile}
        echo "cimserver " `cimserver --version` >> ${backupLogFile}
        echo "CIM_IndicationFilter 2.16.0" >> ${backupLogFile}
        echo "CIM_IndicationHandlerCIMXML 2.8.0" >> ${backupLogFile}
        echo "CIM_IndicationSubscription 2.16.0" >> ${backupLogFile}

        cp ${cimserverBasePath}/repository/root#ibmsd/instances/* ${TMPDIR}/ 2>>${errorlog}
        tar -czf indsubscript.tar.gz * 2>>${errorlog}
        mv indsubscript.tar.gz ${restoreSubscriptionFile}
    fi

    if [[ $1 == *restore* ]]; then
        debugPrint "restoring"
        cp ${restoreSubscriptionFile} ${TMPDIR} 2>>${errorlog}
        tar -zxf ${restoreSubscriptionFile} 2>>${errorlog}

        #need check the pegasus version and indication mof versoin first, since we can not get indication mof version, we can not check the compatibility of archived indication subscription mof version and current schema
        #should be enhanced in future release, 
        #here, just support the same indication mof version
        rm -rf subscription.log 2>>${errorlog}
        rm -rf `basename ${restoreSubscriptionFile}` 2>>${errorlog}

        cp * ${cimserverBasePath}/repository/root#ibmsd/instances/ 2>>${errorlog}

        rm -rf ${restoreSubscriptionFile} 2>>${errorlog}
    fi

    cd ${oldpath}
    rm -rf ${TMPDIR} 2>>${errorlog}
}

removeOldRepository()
{
    debugPrint "begin to removeOldRepository"
    optionbak=${CIMSERVER_OPTIONS}

    # if the pegasus is running, stop it first
    pid=`pidofproc $CIMSERVER_BIN`
    if [ $? -eq 0 ]; then
        ${cimserverStartStop} stop >> ${rebuildlog} 2>>${errorlog}
    fi

    # The removal of the files in root#ibmsd should be done before start the cimserver again
    # this  will avoid calling to ccfw when there is indication subscription in root#ibmsd

    #1. remove the files in root#ibmsd
    rm -rf ${cimserverBasePath}/repository/root#ibmsd/* 2>>${errorlog}

    #since we did not know the basic Pegasus shipped providers and the Pegasus shipped PG_InterOp, 
    #here we have to use cimprovider to delete all IBM shipped providers.
    export CIMSERVER_OPTIONS="enableHttpsConnection=false enableHttpConnection=false"
    ${cimserverStartStop} start >> ${rebuildlog} 2>>${errorlog}
    
    #2. disable all IBM shipped modules and delete them
    ${cimprovidercmd} -l | grep ^POWER | while read i; do { echo "  PROVIDER: ${i}"; ${cimprovidercmd} -dm ${i}; ${cimprovidercmd}  -rm ${i}; } done >>  ${rebuildlog} 2>>${errorlog}
    ${cimprovidercmd} -l | grep ^IBM | while read i; do { echo "  PROVIDER: ${i}"; ${cimprovidercmd} -dm ${i}; ${cimprovidercmd}  -rm ${i}; } done  >> ${rebuildlog} 2>>${errorlog}
    ${cimserverStartStop} stop  >> ${rebuildlog} 2>>${errorlog}
    export CIMSERVER_OPTIONS=${optionbak}
    debugPrint "removeOldRepository completed"
}

rebuildRepository()
{
    debugPrint "rebuildRepository"

    # should restore the directory layout before calling cimmofl, 
    # even the directory exists, the command does not fail
    mkdir -p ${cimserverBasePath}/repository/root#ibmsd/classes  2>>${errorlog}
    mkdir -p ${cimserverBasePath}/repository/root#ibmsd/instances  2>>${errorlog}
    mkdir -p ${cimserverBasePath}/repository/root#ibmsd/qualifiers  2>>${errorlog}

    oldpath=`pwd`
    #1. base, pegasus-ECL
    echo "installing mof of hmc_pegasus"
    cd /opt/hsc/pegasus/codebase/mof/
    /opt/hsc/pegasus/codebase/mof/installmof_hmc.sh >> ${rebuildlog} 2>>${errorlog}
    #2. hmc_vsm
    echo "installing mof of hmc_vsm"
    cd /opt/hsc/pegasus/codebase/vsm/mof/
    /opt/hsc/pegasus/codebase/vsm/mof/installvsmmof_hmc.sh >> ${rebuildlog} 2>>${errorlog}
    #3. other?
    cd ${oldpath}
}

doRebuildRepositoryWithSubscriptionKept()
{
    debugPrint "doRebuildRepositoryWithSubscriptionKept"

    if [[ ${backupIndicationSub} == 1 ]]; then
        echo "backuping the pegasus indication subscriptions"
        backupOrRestoreIndicationSubscription "backup"
    fi

    doRebuildRepository

    if [ -f ${restoreSubscriptionFile} ]; then
        echo "restoring the pegasus indication subscriptions"
        backupOrRestoreIndicationSubscription "restore"
    fi
    mv /opt/hsc/pegasus/codebase/hmcprovVersion /opt/hsc/pegasus/codebase/hmcprovVersion_updated 2>/dev/null
}

doRebuildRepository()
{
    if [[ ${forceReBuild} == 0 ]]; then
        # do not reuild forcely, need check the existence of  $rebuildRepFile
        dorebuild=0

        # Find out if we need to rebuild the repository
        ls $rebuildRepFile >> ${rebuildlog} 2>>${errorlog}
        if [ $? -eq 0 ]
        then
            debugPrint "Provider request to build repository: Need to rebuild"
            dorebuild=1
        fi

        # Check if the repository exists
        if [[ ! -a "$cimserverBasePath/repository/root#ibmsd/classes/CIM_ManagedElement.#" ]]
        then
            debugPrint "Repository does not exist: Need to rebuild"
            dorebuild=1
        fi

        if [[ ${dorebuild} == 0 ]];
        then
            debugPrint "No need to rebuild"
            return 0
        fi
    fi

    echo "Removing existence repository."
    removeOldRepository

    echo "Rebuilding cimserver repository, please wait"
    rebuildRepository

    # Now remove the file since we are done rebuilding
    rm -f $rebuildRepFile >> ${rebuildlog} 2>>${errorlog}
    if [ $? -ne 0 ]
    then
        debugPrint "Delete $rebuildRepFile failed"
    fi

    return 0;
}

# begin
forceReBuild=0
backupIndicationSub=0

case $1 in
    rebuild ) 
        for para in $@; do
            case $para in
                -f) forceReBuild=1 ;;
                -b) backupIndicationSub=1 ;;
            esac
        done
        #echo "forceReBuild " ${forceReBuild} " backupIndicationSub " ${backupIndicationSub}
        > ${rebuildlog}
        doRebuildRepositoryWithSubscriptionKept
        echo "Pegasus repository is rebuilt completed" ;;
    subbackup ) 
        echo "begin to back up pegasus indication subscription"; 
        backupOrRestoreIndicationSubscription "backup";
        echo "back up pegasus indication subscription completed" ;;
    subrestore ) 
        echo "begin to restore pegasus indication subscription"; 
        backupOrRestoreIndicationSubscription "restore" ;
        echo "restore pegasus indication subscription completed" ;;
    * )
        usage
        exit 1;
esac
#rm ${rebuildlog} > /dev/null
exit $?
