/* IBM_PROLOG_BEGIN_TAG                                                   */
/* This is an automatically generated prolog.                             */
/*                                                                        */
/*                                                                        */
/*                                                                        */
/* Licensed Materials - Property of IBM                                   */
/*                                                                        */
/* (C) COPYRIGHT International Business Machines Corp. 1998,2008          */
/* All Rights Reserved                                                    */
/*                                                                        */
/* US Government Users Restricted Rights - Use, duplication or            */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.      */
/*                                                                        */
/* IBM_PROLOG_END_TAG                                                     */
#ifndef _SAMPLE_FRAMETABLE_H
#define _SAMPLE_FRAMETABLE_H

static char *Sample_FrameTable_sccsid = "@(#)47   1.3   src/rsct/pgs/samples/Sample_FrameTable.h, gssamples, rsct_rfos, rfos0838a 5/14/01 09:43:37";

#if !defined(_HAGSD_COPYRIGHT_H)
#define _HAGSD_COPYRIGHT_H
static char copyright[] = "Licensed Materials - Property of IBM\n\
(C) COPYRIGHT International Business Machines Corp. 1998,2001.\n\
All Rights Reserved.\n\
US Government Users Restricted Rights - Use, duplication or \n\
disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n";
#endif


/*********************************************************************/
/*
 * Name:  Sample_FrameTable.h
 *
 * Used to build a table of frame/node pairs for displaying the list
 * of providers in a group.
 *
 * See Sample_Subscribe.C for more info.
 */
 /*********************************************************************/

#include "Sample_Subscribe.h"           // Standard includes.

class   Frame;

#define MAX_FRAMES      256

class   FrameTable {
  public:

    FrameTable(void);

    virtual ~FrameTable(void);

  public:
    // Add a provider into the correct frame.  Return number of providers
    // in table.
    int         Add(short _instance,
                    short _node,
                    unsigned int *_IPaddr,
                    ha_gs_adapter_death_t *_death);

    // Print out the table.
    void        Print(void);

  private:
    // Use node number to calculate frame/slot numbers.
    static      void        GetFrameNumber(short    _node,
                                           int     *_frame,
                                           int     *_slot);

    Frame      *frameTable[MAX_FRAMES + 1]; // Array of frames.
    int         frameProvCount[MAX_FRAMES + 1]; // Number providers per frame.

    int         count;                  // Total number of providers.
    int         highestFrameNumber;     // Highest frame number seen.
    int         highestProvCount;       // Frame with most providers.
};

#endif  /* _SAMPLE_FRAMETABLE_H */
