/* IBM_PROLOG_BEGIN_TAG                                                   */
/* This is an automatically generated prolog.                             */
/*                                                                        */
/*                                                                        */
/*                                                                        */
/* Licensed Materials - Property of IBM                                   */
/*                                                                        */
/* (C) COPYRIGHT International Business Machines Corp. 1998,2008          */
/* All Rights Reserved                                                    */
/*                                                                        */
/* US Government Users Restricted Rights - Use, duplication or            */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.      */
/*                                                                        */
/* IBM_PROLOG_END_TAG                                                     */
#ifndef _SAMPLE_NODE_H
#define _SAMPLE_NODE_H

static char *Sample_Node_sccsid = "@(#)49   1.3   src/rsct/pgs/samples/Sample_Node.h, gssamples, rsct_rfos, rfos0838a 5/14/01 09:43:40";

#if !defined(_HAGSD_COPYRIGHT_H)
#define _HAGSD_COPYRIGHT_H
static char copyright[] = "Licensed Materials - Property of IBM\n\
(C) COPYRIGHT International Business Machines Corp. 1998,2001.\n\
All Rights Reserved.\n\
US Government Users Restricted Rights - Use, duplication or \n\
disclosure restricted by GSA ADP Schedule Contract with IBM Corp.\n";
#endif

/*********************************************************************/
/*
 * Name:  Sample_Node.h
 *
 * Build the sorted list of providers in the system, sorted by node
 * number.
 *
 * See Sample_Subscribe.C for more info.
 */
 /*********************************************************************/

#include "Sample_Subscribe.h"           // Standard includes.

#define MAX_PROVIDERS   32              // Arbitrary count for now.

class   Node {
  public:

    Node(short _myNum)
    	{myNodeNumber = _myNum; count = 0; haveDeath = 0; haveAliases = 0;}

    Node(short _myNum,
         short _instance,
         unsigned int *_IPaddr,
         ha_gs_adapter_death_t *_death)
    	{myNodeNumber = _myNum; instances[0] = _instance; count = 1;
         if (NULL != _IPaddr) {
             haveAliases = 1;
             IPaddress[0] = *_IPaddr;
         }
         if (NULL != _death) {
             haveDeath = 1;
             deathArray[0] = *_death;
         }
     }

    virtual ~Node(void)
    	{count = 0;}

  public:
    // Add a provider into the correct frame.  Return number of providers
    // on node.
    int         Add(short _instance,
                    unsigned int *_IPaddr,
                    ha_gs_adapter_death_t *_death)
    	{instances[count] = _instance;
         if (NULL != _IPaddr) {
             haveAliases = 1;
             IPaddress[0] = *_IPaddr;
         }
         if (NULL != _death) {
             haveDeath = 1;
             deathArray[0] = *_death;
         }
         return(++count);
     }

    // Print out the table.  Return number of chars if partial line.
    int         PrintSimple(int _numPrinted);
    int         PrintSpecialIP(int _numPrinted);
    int         PrintSpecialDeath(int _numPrinted);
    int         PrintFancy(int _index, int _space);

  private:

    short       instances[MAX_PROVIDERS]; // Map of provider numbers.

    int         haveDeath;              // Have death entries?
    ha_gs_adapter_death_t deathArray[MAX_PROVIDERS]; // Map of provider death reasons.

    int         haveAliases;            // Have alias entries?
    unsigned int          IPaddress[MAX_PROVIDERS]; // Map of provider IP aliases.

    int         count;                  // Total number of providers.
    short       myNodeNumber;           // Node number I represent.
};

#endif  /* _SAMPLE_NODE_H */
