#!/usr/bin/perl
# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2005,2008 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
# @(#)53   1.76   src/csm/core/pm/DCAPI.pm.perl, setup, csm_rgar2h, rgar2hs001a 12/11/07 21:04:24
#--------------------------------------------------------------------------------

package DCAPI;
use strict;

use locale;

use Fcntl qw(:flock);
use File::Glob ':glob';
use File::Basename;
use File::Find;
use File::Copy;
use File::Path;    # Provides mkpath() and rmtree()
use Getopt::Long;

umask(0022);

require DCUtils;
require ServerUtils;
require ArchiveUtils;
require CSMDefs;

my $csmroot;
my ($MSGCAT, $MSGMAPPATH, $MSGSET);
my $csmdefault = "/csminstall";
my $infopath   = "$csmdefault/csm/config";
my $rc;

BEGIN
{
    # Override with itself so it can be overridden at run-time later.
    # Syntax of exit: exit EXPR. So, we should return a scalar
    *CORE::GLOBAL::exit = sub { CORE::exit $_[0];};
    *CORE::GLOBAL::die  = sub { CORE::die @_;};
    #    This enables us to redirect where it looks for other CSM files during development
    $csmroot = $ENV{'CSM_ROOT'} ? $ENV{'CSM_ROOT'} : '/opt/csm';
    $MSGCAT = 'csmInstall.cat';
    if (defined $::MSGMAPPATH)
    {
        $MSGMAPPATH = $ENV{'CSM_ROOT'} ? "$csmroot/msgmaps" : $::MSGMAPPATH;
    }
    else
    {
        $MSGMAPPATH = "$csmroot/msgmaps";
    }
    $MSGSET = 'csminstall';
	if($ENV{'DC_ENVIRONMENT'} ne "CSM")
	{
		$::MSGCAT     = 'csmInstall.cat';
		$::MSGMAPPATH = $ENV{'CSM_MSGMAPS'} ? $ENV{'CSM_MSGMAPS'} : '/opt/csm/msgmaps';
		$::MSGSET     = 'csminstall';
	}
}

#--------------------------------------------------------------------------------

=head3  DCcopycds

        Copies Linux distributions and service levels from CDs to the management server
        /csminstall directory

    Arguments:
        $cluster_info_hash_ref
            Reference to a hash of the clusterinfo attributes.  Optional.
            Default values will be used for the missing attributes.
        $node_info_hash_ref
            Reference to a hash containing attributes. The attributes in the hash
            will be used to determine the Linux distribution to be copied.

        $skip_file_load_flag
            Skip reloading clusterinfo and nodeinfo files.  This flag can be used to
            improve performance when calling multiple functions in the deployment component
            perl API from the same process with the identical set of files.  The deployment
            component loads these files into internal global hash variables, and will not
            reload them if this flag is set.

        $verbose_flag
            Display verbose messages to stdout if set to anything other than 0 or blank.

        $copy_all_rpms_flag
            Copy all RPMs from all distribution CDs.  If this parameter is set to blank or 0,
            only the subset of distribution CDs required by the deployment component are copied.

        @paths
            Array containing the pathnames to be copied from.  This overrides the
            InstallOSOriginalSource nodeinfo attribute.

    Returns:
        0:        successful
        non-zero: failed

    Globals:
        @::PKGPATH (used by ArchiveUtils->copyDistroPkgs)
        $::VERBOSE
        %::OSDefs
        %::pkgdefs
        $::NO_MOUNT_CD (No prompt for mounting CDs)

    Error:
        see returns

    Example:
        DCAPI->DCcopycds($cluster_info_hash_ref, $node_info_hash_ref, $skip_file_load_flag,
        		 $verbose_flag, $copy_all_rpms_flag, @paths)
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub DCcopycds
{
    my ($class, $cluster_info_hash_ref, $node_info_hash_ref, $skip_file_load_flag,
        $verbose_flag, $copy_all_rpms_flag, @paths)
      = @_;
        
	my $nomountcd = $::NO_MOUNT_CD;
	my $un_set=0;
    # Declare overridden built-in routine.
    # Note: use "local" to make sure recover built-in routine when exiting from API itself.
    # If DCAPI is called nested, built-in overridden is declared many times,
    #   it maybe brings potential performance issues. 
    # But CSM only call DCAPI at most nested by two layers in codes, 
    #   it is safe right now. 
    local *CORE::GLOBAL::exit;
    # Override the built-in exit with our version.
    # This override exit will not be valid after exiting from the outermost DCAPI.
    *CORE::GLOBAL::exit = \&DCUtils::__CSM_exit;
    
    local *CORE::GLOBAL::die;
    # Override the built-in die with our version.
    # This override die will not be valid after exiting from the outermost DCAPI.
    *CORE::GLOBAL::die = \&DCUtils::__CSM_die;

    if(!$ENV{'DC_ENVIRONMENT'})
	{
    	$ENV{'DC_ENVIRONMENT'}=1;
		$un_set=1;
	}
    else
    {
        # Register exit point if DC environment
        if (  (!$::__DC_RETURN_ANCHOR)
           && ($ENV{'DC_ENVIRONMENT'} ne 'CSM')
           )  
        {
            # Set return flag label
            $::__DC_RETURN_ANCHOR = 'copycd_done' ;
            # Set current process pid
            $::__DC_PID = $$;
        }
    }
	my $ret_code=0;
    # Get the $::VERBOSE global variable from exploiter
    my $verbose_passed = $::VERBOSE;
    local $::VERBOSE;
	$::VERBOSE = $verbose_passed || $verbose_flag;
    my ($cluster_info_hash_ref, $node_info_hash_ref) =
      DCUtils->get_all_info_from_hash( $cluster_info_hash_ref, $node_info_hash_ref,
                                       {},  $skip_file_load_flag);

	my @req_node_attrs=("Hostname","InstallOSName","InstallDistributionName","InstallDistributionVersion",
						"InstallPkgArchitecture","InstallServiceLevel","ManagementServer");
   
	DCUtils->check_req_attrs($node_info_hash_ref,\@req_node_attrs,undef,undef,$skip_file_load_flag);		   	
	
	DCUtils->start_logging($$cluster_info_hash_ref{'logfile_DCcopycds'});

    my %node_hash    = %$node_info_hash_ref;
    my ($InstallDistributionName);
    my ($InstallDistributionVersion);
    my ($InstallPkgArchitecture);
    my ($InstallServiceLevel);
    my %AttrHash;

    # go through each node and put their attributes into %AttrHash.
    foreach my $hostname (keys %node_hash)
    {
        $InstallDistributionName =
          $node_hash{$hostname}{'InstallDistributionName'};
        $InstallDistributionVersion =
          $node_hash{$hostname}{'InstallDistributionVersion'};
        $InstallPkgArchitecture =
          $node_hash{$hostname}{'InstallPkgArchitecture'};
        $InstallServiceLevel = $node_hash{$hostname}{'InstallServiceLevel'};

        my $distro_id =
            $InstallDistributionName . ":"
          . $InstallDistributionVersion . ":"
          . $InstallPkgArchitecture . ":"
          . $InstallServiceLevel;

        push @{$AttrHash{$distro_id}}, $hostname;
    }


    foreach my $attr (keys %AttrHash)
    {
        (
         $InstallDistributionName, $InstallDistributionVersion,
         $InstallPkgArchitecture,  $InstallServiceLevel
        )
          = split(":", $attr);

        my @path_info;
        foreach my $node (@{$AttrHash{$attr}})
        {
            my @path_for_node =
              split(/:/, $node_hash{$node}{'InstallOSOriginalSource'});
            foreach my $path (@path_for_node)
            {
                if (!grep /^\Q$path\E$/, @path_info)
                {
                    push(@path_info, $path);
                }
            }
        }

        #Argument @paths overwirte the InstallOSOriginalSource nodeinfo attribute
        @::PKGPATH = @paths ? @paths : @path_info;

        %::OSDefs  = ServerUtils->get_OSDefs();
        %::pkgdefs =
          ServerUtils->get_pkgdefs(
                                   'Linux',
                                   $InstallDistributionName,
                                   $InstallDistributionVersion,
                                   $InstallPkgArchitecture,
                                  );
        #Check the value of InstallServiceLevel
        my %distroID =
          NodeUtils->getDistroID(
                                 $InstallDistributionName,
                                 $InstallDistributionVersion,
                                 $InstallServiceLevel,
                                 $InstallPkgArchitecture
                                );
        if (!%distroID)
        {
            MessageUtils->messageFromCat(
                           'csmInstall.cat',         $::MSGMAPPATH,
                           'csminstall',             "E1",
                           'EMsgBadSvcLevel',        $InstallServiceLevel,
                           $InstallDistributionName, $InstallDistributionVersion
                                        );
        }

        #setup directory structure
        ArchiveUtils->createRPMSdir(
                                    'Linux',
                                    $InstallDistributionName,
                                    $InstallDistributionVersion,
                                    $InstallPkgArchitecture,
                                    $InstallServiceLevel,
                                   );

        #Set the TOP to /csminstall/Linux/<SuSE or SLES>/<version>/<arch>
        my $top_dir =
          ServerUtils->getBaseDir('Linux', $InstallDistributionName,
                                  $InstallDistributionVersion,
                                  $InstallPkgArchitecture,);
        my $rc =
          ArchiveUtils->copyDistroPkgs(
                          'Linux',                     $InstallPkgArchitecture,
                          $top_dir,                    $InstallDistributionName,
                          $InstallDistributionVersion, $InstallServiceLevel,
                          $copy_all_rpms_flag,         $nomountcd,
                                      );
        if (!$rc)
        {

            # error copying CD contents.
            $ret_code = 1;
            goto copycd_done;
        }

        $rc =
          ArchiveUtils->setupBootOrder(
                                       $InstallPkgArchitecture,
                                       $top_dir,
                                       $InstallDistributionName,
                                       $InstallDistributionVersion,
                                       $InstallServiceLevel,
                                      );
        if (!$rc)
        {

            # error setting up boot order
            $ret_code = 1;
            goto copycd_done;
        }
    }
# DCcopycds exit label
copycd_done:
    $ret_code |= DCUtils->checkDCRetCode('copycd_done');

    # display a success or failure message according to $ret_code
    if ($ret_code)
    {
    	MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                     'csminstall', 'E', 'EMsgFailedCopycds');
    }
    else
    {
    	MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                     'csminstall', 'I', 'IMsgCopycdsComplete');
    }
    
    DCUtils->stop_logging($$cluster_info_hash_ref{'logfile_DCcopycds'});
	if($un_set)  
	{
    	undef $ENV{'DC_ENVIRONMENT'};
	}	
    return $ret_code;

}

#-------------------------------------------------------------------------------

=head3    DCsetupinstaller

        Arguments:
        $cluster_info_hash
            Reference to a hash of the clusterinfo attributes.  Optional.
            Default values will be used for the missing attributes.
        $nodeinfo_hash
            Reference to a hash containing attributes of each node.
        $ISinfo_hash
            Reference to a hash containing attributes of the install servers.
            This parameter is only required if separate install servers are used by nodes in nodeinfo_hash.
        $skip_file_load_flag
            Skip reloading clusterinfo, nodeinfo, and install server nodeinfo files.
        $verbose_flag
            Display verbose messages to stdout if set to anything other than 0 or blank.

        Returns:
            0:        successful
            non-zero: failed
        Globals:
                None
        Errors:
            see returns
        Example:
                 DCAPI->DCsetupinstaller(\%cluster_info_hash, $nodeinfo_hash, $ISinfo_hash, $skip_file_load_flag, $verbose_flag);

=cut

#-------------------------------------------------------------------------------

sub DCsetupinstaller
{
    my $routine = "DCsetupinstaller";
    print "ENTERING: $routine\n" if $::DEBUG;
    # Declare overridden built-in routine.
    # Note: use "local" to make sure recover built-in routine when exiting from API itself.
    # If DCAPI is called nested, built-in overridden is declared many times,
    #   it maybe brings potential performance issues. 
    # But CSM only call DCAPI at most nested by two layers in codes, 
    #   it is safe right now. 
    local *CORE::GLOBAL::exit;
    # Override the built-in exit with our version.
    # This override exit will not be valid after exiting from the outermost DCAPI.
    *CORE::GLOBAL::exit = \&DCUtils::__CSM_exit;
    
    local *CORE::GLOBAL::die;
    # Override the built-in die with our version.
    # This override die will not be valid after exiting from the outermost DCAPI.
    *CORE::GLOBAL::die = \&DCUtils::__CSM_die;
	my $rc=0;
	my $un_set=0;  
	my $un_set_CSM_NO_SETUP_DHCP = 0;
	if(!$ENV{'DC_ENVIRONMENT'})
	{
    	$ENV{'DC_ENVIRONMENT'}=1;
		$un_set=1;
	}
    else
    {
        # Register exit point if DC environment
        if ( (!$::__DC_RETURN_ANCHOR)
          && ($ENV{'DC_ENVIRONMENT'} ne 'CSM')
        ) 
        {

            # Set return flag label
            $::__DC_RETURN_ANCHOR = 'DCsetupinstaller_exit';
            # Set current process pid
            $::__DC_PID = $$;
            # Don't configure DHCP service on HMC for P6 machines.
            # Because it will make conflicts if CSM and HMC use dhcp service 
            # at the same time.
            if ( NodeUtils->isHMC() 
               && (! defined $ENV{CSM_NO_SETUP_DHCP} )
               )
            {
                $un_set_CSM_NO_SETUP_DHCP = 1;
                $ENV{CSM_NO_SETUP_DHCP} = 1;
            }
        }
    }

    my ($class, $cluster_info_hash, $nodeinfo_hash, $ISinfo_hash,
        $skip_file_load_flag, $verbose_flag)
      = @_;
      
    # Get the $::VERBOSE global variable from exploiter
    my $verbose_passed = $::VERBOSE;
    local $::VERBOSE;
	$::VERBOSE = $verbose_passed || $verbose_flag;
    my ($cluster_hash, $ref_nodehash, $ref_ishash) =
      DCUtils->get_all_info_from_hash($cluster_info_hash, $nodeinfo_hash,
                                      $ISinfo_hash, $skip_file_load_flag);

    DCUtils->start_logging($::__CLUSTER_INFO_HASH{'logfile_DCsetupinstaller'});
	my @req_node_attrs=("Hostname","InstallOSName","InstallDistributionName","InstallDistributionVersion",
						"InstallPkgArchitecture","InstallAdapterMacaddr","UUID","ManagementServer");
   
	my @req_server_attrs=("Hostname","InstallOSName","InstallDistributionName","InstallDistributionVersion",
						"InstallPkgArchitecture","InstallServiceLevel");
				
	DCUtils->check_req_attrs($ref_nodehash,\@req_node_attrs,$ref_ishash,\@req_server_attrs,$skip_file_load_flag);		   	
	
    # update the InstallMethod according to the csmsetupinstall -m flag
    if ($::METHOD)
    {
        foreach my $node (keys %$ref_nodehash)
        {
            $$ref_nodehash{$node}{'InstallMethod'} = $::METHOD;
        }
    }

    my %nodehash_bak = %::NODEHASH;
    %::NODEHASH = %$ref_nodehash;
    %::ISHASH   = %$ref_ishash;
    @::NODELIST = keys %::NODEHASH;

    # check the deployment attributes
    DCUtils->check_deploy_attrs($ref_nodehash,$skip_file_load_flag,$ref_ishash);


    ServerUtils->copyBinaries;	
    # generate list of customization scripts to be put into config info files.
    if (ServerUtils->make_script_lists(@::NODELIST))
    {
        MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                                     'csminstall', "E", 'EMsgNoCustScripts');
    }

    my ($InstallDistributionName);
    my ($InstallDistributionVersion);
    my ($InstallPkgArchitecture);
    my ($InstallCSMVersion);
    my %AttrHash;

    # go through each node and put their attributes into %AttrHash.
    foreach my $hostname (keys %::NODEHASH)
    {
        $InstallDistributionName =
          $::NODEHASH{$hostname}{'InstallDistributionName'};
        $InstallDistributionVersion =
          $::NODEHASH{$hostname}{'InstallDistributionVersion'};
        $InstallPkgArchitecture =
          $::NODEHASH{$hostname}{'InstallPkgArchitecture'};
        $InstallCSMVersion = $::NODEHASH{$hostname}{'InstallCSMVersion'};

        my $distro_id =
            $InstallDistributionName . ":"
          . $InstallDistributionVersion . ":"
          . $InstallPkgArchitecture . ":"
          . $InstallCSMVersion;

        push @{$AttrHash{$distro_id}}, $hostname;
    }

    foreach my $attr (keys %AttrHash)
    {
        %::NODEHASH = ();
        ($::DISTRO_NAME, $::DISTRO_VERSION, $::ARCH, $::CSM_VERSION) =
          split(":", $attr);
    	if(!$::CSM_VERSION)
		{
			$::CSM_VERSION= NodeUtils->get_CSMVersion("csm.core");    #requires RPMCMD and LSLPP
		}    
        my $inst_method;

        # regenerate the global variables which might be only a subset of the whole.
        my @nodelist = @{$AttrHash{$attr}};
        foreach my $node (@nodelist)
        {
            $::NODEHASH{$node} = $$ref_nodehash{$node};
        }
        @::NODELIST = keys %::NODEHASH;
        my ($effective_distro_name) = NodeUtils->getEffectiveDistro($::DISTRO_NAME);
		# Set the default install method.  If another install method (such as 
		# warewulf, you or kickstart-upgrade) is provided, the $inst_method 
		# variable will be overridden (below).
        if (($effective_distro_name =~ /RHEL/) || ($effective_distro_name =~ /RedHat/))
        {
            $inst_method = "kickstart";
        }
        else
        {
            $inst_method = "autoyast";
        }

        # get the packages definitions for this set of attributes
        %::mypkgdefs =
          ServerUtils->get_pkgdefs('Linux', $::DISTRO_NAME, $::DISTRO_VERSION,
                                   $::ARCH, "MgdNode", $::CSM_VERSION);

        # set the distro top
        if (($inst_method eq "kickstart") && (!$::REDHAT_TOP))
        {
            $::REDHAT_TOP =
              ServerUtils->getBaseDir("Linux", $::DISTRO_NAME,
                                      $::DISTRO_VERSION, $::ARCH);
        }
        elsif (($inst_method eq "autoyast") && (!$::SUSE_TOP))
        {
            $::SUSE_TOP =
              ServerUtils->getBaseDir("Linux", $::DISTRO_NAME,
                                      $::DISTRO_VERSION, $::ARCH);
        }

        # now write the attributes to the config info files.
		# have to generate the config info files before setupInstall so that the files can be used by setupInstall.
        DCUtils->set_config_info();
	
        # sync node config files into Install Servers if there are any.
        if (keys %$ref_ishash)
        {

            # Only node config files will be synced.
            my $old_skip_isvr = $ENV{CSM_SKIP_ISVR};
            $ENV{CSM_SKIP_ISVR} = 1;
            $::DEPLOY_ATTR_CHECKED = 1;
            DCAPI->DCsyncServers($cluster_info_hash, $nodeinfo_hash,
                                 $ISinfo_hash, 1, 0);
            $ENV{CSM_SKIP_ISVR} = $old_skip_isvr;
        }
	
		# If the METHOD was set (by csmsetupinstall), override $inst_method.
		if($::METHOD)
		{
			$inst_method=$::METHOD;
		}		
   		#if($inst_method eq "warewulf")
		#{
		#	DCUtils->embed_is_info(\%::NODEHASH,"makedisklessnode");
		#}
        # do the installation setup
        $rc = NodesetUtils->setupInstall($inst_method);
        if ($rc)
        {
            print "LEAVING: $routine\n" if $::DEBUG;
            MessageUtils->message("E$rc", 'EMsgSETUPKS_ERROR_KS');
        }

        # copy the iprdd driver for pRHEL 3 GA and QU1
        if( ($::ARCH eq "ppc64") && ($::DISTRO_NAME =~ /RedHat/) 
		        && ($::DISTRO_VERSION eq "3") )
        {
            foreach my $node (keys %::NODEHASH)
            {
                my $svclevel=$::NODEHASH{$node}{'InstallServiceLevel'};
                if($svclevel eq "GA")
                {
                    ServerUtils->copy_iprdd_driver("GA");
                    $::GA_DONE=1;
                }
                elsif($svclevel eq "QU1")
                {
                    ServerUtils->copy_iprdd_driver("QU1");
                    $::QU1_DONE=1;
                }
            }
        }

    }
    %::NODEHASH = %nodehash_bak;
    @::NODELIST = keys %::NODEHASH;

# DCsetupinstaller exit label
DCsetupinstaller_exit:
    $rc |= DCUtils->checkDCRetCode('DCsetupinstaller_exit');
    DCUtils->stop_logging($::__CLUSTER_INFO_HASH{'logfile_DCsetupinstaller'});
    if($un_set)  
	{
    	undef $ENV{'DC_ENVIRONMENT'};
	}	
	if ($un_set_CSM_NO_SETUP_DHCP)
	{
		undef $ENV{CSM_NO_SETUP_DHCP};
	}	
    print "LEAVING: $routine\n" if $::DEBUG;

	return($rc);

}

#------------------------------------------------------------------------------------------------------------------

=head3  DCsyncserver

        Copy files from the management server to the install server

        Arguments:
        $cluster_info_hash
            Reference to a hash of the clusterinfo attributes.  Optional.
            Default values will be used for the missing attributes.
        $node_info_hash
            Reference to a hash containing attributes of each node.
        $server_info_hash
            Reference to a hash containing attributes of the install servers.
            This parameter is only required if separate install servers are used by nodes in node_info_hash.
        $skip_file_load_flag
            Skip reloading clusterinfo, nodeinfo, and install server nodeinfo files.  
        $verbose_flag
            Display verbose messages to stdout if set to anything other than 0 or blank.
        $exclude_ref
            Reference to a array containing a list of directories to be excluded from the update.  
            The default is to update all directories controlled by the deployment component.  

        Returns:
            0:        successful
            non-zero: failed
        Errors:
            see returns
        Examples:
        DCAPI->DCsyncserver( $cluster_info_hash, $node_info_hash, $server_info_hash,
		             $skip_file_load_flag, $verbose_flag, $exclude_ref, $special_ref)
=cut

#------------------------------------------------------------------------------------------------------------------
sub DCsyncServers
{

    #use CFM -- all commands that call this function need to use CFM
    my $routine = "syncServers";
    print "ENTERING: $routine\n" if $::DEBUG;
    # Declare overridden built-in routine.
    # Note: use "local" to make sure recover built-in routine when exiting from API itself.
    # If DCAPI is called nested, built-in overridden is declared many times,
    #   it maybe brings potential performance issues. 
    # But CSM only call DCAPI at most nested by two layers in codes, 
    #   it is safe right now. 
    local *CORE::GLOBAL::exit;
    # Override the built-in exit with our version.
    # This override exit will not be valid after exiting from the outermost DCAPI.
    *CORE::GLOBAL::exit = \&DCUtils::__CSM_exit;
    
    local *CORE::GLOBAL::die;
    # Override the built-in die with our version.
    # This override die will not be valid after exiting from the outermost DCAPI.
    *CORE::GLOBAL::die = \&DCUtils::__CSM_die;
    my ($pkg, $cluster_info_hash, $node_info_hash, $server_info_hash,
        $skip_file_load_flag, $verbose_flag, $exclude_ref, $special_ref)
      = @_;

    # Get the $::VERBOSE global variable from exploiter
    my $verbose_passed = $::VERBOSE;
    local $::VERBOSE;
	$::VERBOSE = $verbose_passed || $verbose_flag;
	my $un_set=0;  
	if(!$ENV{'DC_ENVIRONMENT'})
	{
    	$ENV{'DC_ENVIRONMENT'}=1;
		$un_set=1;
	}		
    else
    {
        # Register exit point if DC environment
        if (  (!$::__DC_RETURN_ANCHOR)
           && ($ENV{'DC_ENVIRONMENT'} ne 'CSM')
        )
        {

            # Set return flag label
            $::__DC_RETURN_ANCHOR = 'DCsyncServers_exit';
            # Set current process pid
            $::__DC_PID = $$;
        }
    }
    my ($cluster_hash, $ref_nodehash, $ref_ishash) =
      DCUtils->get_all_info_from_hash(   $cluster_info_hash, $node_info_hash,
                            $server_info_hash,  $skip_file_load_flag);
							
	my @req_node_attrs=("Hostname","InstallOSName","InstallDistributionName","InstallDistributionVersion",
						"InstallPkgArchitecture","ManagementServer");
   
	my @req_server_attrs=("Hostname","InstallOSName","InstallDistributionName","InstallDistributionVersion",
						"InstallPkgArchitecture","InstallServiceLevel");
				
	DCUtils->check_req_attrs($ref_nodehash,\@req_node_attrs,$ref_ishash,\@req_server_attrs,$skip_file_load_flag);		   	
    
	# check the deployment attributes							
    DCUtils->check_deploy_attrs($ref_nodehash,$skip_file_load_flag,$ref_ishash);
	
    DCUtils->start_logging(
                                $::__CLUSTER_INFO_HASH{'logfile_DCsyncserver'});
    my (@exclude_dirs, $dir_str, @ex_dirs);

    my @is = keys %$ref_ishash;
    if (!@is)
    {    # no install servers
        print "LEAVING: $routine\n" if $::DEBUG;
        DCUtils->checkDCRetCode('DCsyncServers_exit');
        return 0;
    }

	require CFM;
    # Check InstallServer's reachability
    $ENV{'DSH_REMOTE_CMD'} = DCUtils->getRemoteShell;
    my $unreachable = NetworkUtils->checkRSReachability(\@is);
    if ($unreachable != 0)
    {
        if (scalar @$unreachable >= 1)
        {

            #there are unreachable InstallServers
            my $isvrs = join ",", @$unreachable;
            MessageUtils->messageFromCat('csmInstall.cat', $MSGMAPPATH,
                                      'csminstall', 'E1', 'EMsgISDown', $isvrs);
        }
    }

    my $sHash = DCUtils->makeSyncHash($ref_nodehash, $ref_ishash, $special_ref);

    # Allow the user to set the CSM_SKIP_ISVR environment variable
    # in order to skip the transfer of files to the install server.
    if (!defined $ENV{'CSM_SKIP_ISVR'})
    {

        # Exclude the autoyast and kickstart config file and their links
        my $ref_ex_dirs = ServerUtils->exclude_config_dir();
        if ($ref_ex_dirs)
        {
            push @exclude_dirs, @$ref_ex_dirs;
        }

        # Exclude the dir passed in
        if ($exclude_ref) { push @exclude_dirs, @$exclude_ref; }
    }
        my $ref_ex_dirs = DCUtils->exclude_dev_dirs($ref_nodehash);
        if(@$ref_ex_dirs)
        {
		push @exclude_dirs, @$ref_ex_dirs;
        }

    # For pRedHat, there might have a link "/csminstall/csm/RedHatEL-AS*-drivers"
    # Exclude them but create the link in syncServer.client
    if (-l "/csminstall/csm/RedHatEL-AS3-drivers")
    {
        push @exclude_dirs, "/csminstall/csm/RedHatEL-AS3-drivers";
    }
    if (-l "/csminstall/csm/RedHatEL-AS4-drivers")
    {
        push @exclude_dirs, "/csminstall/csm/RedHatEL-AS4-drivers";
    }

    my $distro       = NodeUtils->get_DistributionName();
    my $distlocation = "/tmp/csm_servers";
    CFM->createGenDistfile($sHash, $distlocation, \@exclude_dirs);
    CFM->distGenDistfile($distlocation);
    unlink $distlocation;

# DCsyncServers exit label
DCsyncServers_exit:
    my $rc = 0;
    $rc |= DCUtils->checkDCRetCode('DCsyncServers_exit');
    DCUtils->stop_logging($::__CLUSTER_INFO_HASH{'logfile_DCsyncserver'});
	if($un_set)  
	{
    	undef $ENV{'DC_ENVIRONMENT'};
	}		
    print "LEAVING: $routine\n" if $::DEBUG;
    return $rc;
}

#==============================================================================

=head3  DCenableservices

        Install and start OS network deployment services such as DHCP, TFTP, 
		BOOTP, PXE, and NFS.  
        (also configure RDM if it is in use)

        Arguments:
        $cluster_info_hash
            Reference to a hash of the clusterinfo attributes.  Optional.
            Default values will be used for the missing attributes.
        $node_info_hash
            Reference to a hash containing attributes of each node.
        $server_info_hash
            Reference to a hash containing attributes of the install servers.
            This parameter is only required if separate install servers are 
			used by nodes in node_info_hash.
        $skip_file_load_flag
            Skip reloading clusterinfo, nodeinfo, and install server nodeinfo 
			files.  
        $verbose_flag
            Display verbose messages to stdout if set to anything other than 0 
			or blank.

        Returns:
            0:        successful
            non-zero: failed
        Errors:
            see returns
        Examples:
        DCAPI->DCenableservices($cluster_info_hash, $node_info_hash, 
						$server_info_hash, $skip_file_load_flag, $verbose_flag)
=cut

#==============================================================================

sub DCenableservices
{
    my $routine = "enable_services";
    print "ENTERING: $routine\n" if $::DEBUG;
    # Declare overridden built-in routine.
    # Note: use "local" to make sure recover built-in routine when exiting from API itself.
    # If DCAPI is called nested, built-in overridden is declared many times,
    #   it maybe brings potential performance issues. 
    # But CSM only call DCAPI at most nested by two layers in codes, 
    #   it is safe right now. 
    local *CORE::GLOBAL::exit;
    # Override the built-in exit with our version.
    # This override exit will not be valid after exiting from the outermost DCAPI.
    *CORE::GLOBAL::exit = \&DCUtils::__CSM_exit;
    
    local *CORE::GLOBAL::die;
    # Override the built-in die with our version.
    # This override die will not be valid after exiting from the outermost DCAPI.
    *CORE::GLOBAL::die = \&DCUtils::__CSM_die;
    my ($pkg, $cluster_info_hash, $node_info_hash, $server_info_hash,
        $skip_file_load_flag, $verbose_flag)
      = @_;
	my $un_set=0;  

    # Get the $::VERBOSE global variable from exploiter
    my $verbose_passed = $::VERBOSE;
    local $::VERBOSE;
	$::VERBOSE = $verbose_passed || $verbose_flag;
	if(!$ENV{'DC_ENVIRONMENT'})
	{
    	$ENV{'DC_ENVIRONMENT'}=1;
		$un_set=1;
	}		
    else
    {
        # Register exit point if DC environment
        if (  (!$::__DC_RETURN_ANCHOR)
           && ($ENV{'DC_ENVIRONMENT'} ne 'CSM')
        )
        {

            # Set return flag label
            $::__DC_RETURN_ANCHOR = 'DCenableservices_exit';
            # Set current process pid
            $::__DC_PID = $$;
        }
    }
    my ($cluster_hash, $ref_nodehash, $ref_ishash) =
      DCUtils->get_all_info_from_hash($cluster_info_hash, $node_info_hash,
                            $server_info_hash,$skip_file_load_flag);

	my @req_node_attrs=("Hostname","InstallOSName","InstallDistributionName","InstallDistributionVersion",
						"InstallPkgArchitecture","ManagementServer");
   
	my @req_server_attrs=("Hostname","InstallOSName","InstallDistributionName","InstallDistributionVersion",
						"InstallPkgArchitecture","InstallServiceLevel");
				
	DCUtils->check_req_attrs($ref_nodehash,\@req_node_attrs,$ref_ishash,\@req_server_attrs,$skip_file_load_flag);		   	
    # check the deployment attributes
    DCUtils->check_deploy_attrs($ref_nodehash,$skip_file_load_flag,$ref_ishash);

    DCUtils->start_logging(
                                $::__CLUSTER_INFO_HASH{'logfile_DCenableservices'});
    my %nodehash = %$ref_nodehash;
    my %ishash   = %$ref_ishash;

    my @AIX_servers;
    my @Linux_servers;
    my @PXE_servers;
    my @BOOTP_servers;
    my @InstallServers = keys %ishash;

    if ($::DEBUG)
    {
        foreach my $s (@InstallServers)
        {
            print "INSTALL SERVER: $s\n";
        }
    }

    # for SIS, the IS must install the systemimager boot packages with the same architecture as target nodes.
    my $target_node_arch;
    if ($::METHOD =~ /sis/)
    {
        my @nodes  = keys %nodehash;
        my $node = $nodes[0];
        $target_node_arch = $nodehash{$node}{'InstallPkgArchitecture'};
    }

    # is it possible that we have multiple mgmtsvr? Migration?
    my @mgmtsvr_hostnames;
    my $non_isnode = DCUtils->get_nodes_with_no_is;
    if (@$non_isnode)
    {
        foreach my $node (@$non_isnode)
        {
            my $mgmtsvr = $nodehash{$node}{'ManagementServer'};
            if (!grep /^$mgmtsvr/, @mgmtsvr_hostnames)
            {
                push(@mgmtsvr_hostnames, $mgmtsvr);
            }
        }
    }
    my $server_hash = DCUtils->get_install_servers;
    $ENV{'DSH_REMOTE_CMD'} = DCUtils->getRemoteShell;

    # If there are install servers other than the management server,
    # add them to the appropriate *_servers list(s).
    if ((keys %$server_hash) or @$non_isnode)
    {
        @Linux_servers = keys %$server_hash;

        # Check if any GPL code needs to be installed on the Linux install
        # servers.  If so, display a license and prompt the user to accept it.
#        my @check_servers = @Linux_servers;
#        if (@mgmtsvr_hostnames)
#	{
#            ArchiveUtils->check_for_display_opensrcLicense;
#        }
#	if (scalar(@check_servers) > 0)
#        {
#            ArchiveUtils->check_for_display_opensrcLicense(\@check_servers);
#        }

        # Determine the value of the TFTPpackage attribute
        my $mgmtsvr;
        my $dir;
        my $TFTPpackage = $::__CLUSTER_INFO_HASH{'TFTPPackage'};

        # Determine whether an HTTP server should be set up on the
        # install servers.  Set $SETUP_HTTP_SERVER_FLAG if
        # SetupNetworkInstallProtocol=1 and NetworkInstallProtocol=HTTP
        my $SETUP_HTTP_SERVER_FLAG = "";
        if (    (DCUtils->get_NetworkInstallProtocol =~ /http/i)
            and (DCUtils->get_SetupNetworkInstallProtocol =~ /1|yes/i))
        {
            $SETUP_HTTP_SERVER_FLAG = "-H";
        }

        # Determine whether YUM , createrepo and warewulf utilities should be
        # set up on the install servers. Set $SETUP_YUM_FLAG,
        # $SETUP_CREATEREPO_FLAG and $SETUP_WAREWULF_FLAG if InstallMethod=warewulf
        # if InstallMethod=yum_upgrade ?
		my ($SETUP_YUM_FLAG, $SETUP_CREATEREPO_FLAG, $SETUP_WAREWULF_FLAG);
		$SETUP_YUM_FLAG = $SETUP_CREATEREPO_FLAG = $SETUP_WAREWULF_FLAG = "";
		if ($::METHOD =~ /warewulf/ )
		{
			$SETUP_YUM_FLAG = "-Y";
			$SETUP_CREATEREPO_FLAG = "-C";
			$SETUP_WAREWULF_FLAG = "-W";
		}

        # Determine whether SIS rpm packages should be set up on the
        # install servers. Set $SETUP_SIS_FLAG if InstallMethod = sis.
        my $SETUP_SIS_FLAG = "";
        if ($::METHOD =~ /sis/)
        {
            $SETUP_SIS_FLAG = "-S $target_node_arch";
        }
		# Merge all flags
		my $SETUP_ALL_FLAG = join(" ", $SETUP_HTTP_SERVER_FLAG 
									 , $SETUP_YUM_FLAG
									 , $SETUP_CREATEREPO_FLAG
									 , $SETUP_WAREWULF_FLAG);
        # Set the verbose flag depending on how this command was called
        my $verboseflag = "";
        $verboseflag = "-v" if ($::VERBOSE);

        # Call syncServers.client on the management server if the MS is
        # an install server.
        if (@mgmtsvr_hostnames)
        {

            # The management server might be known by different hostnames
            # on different nodes.
            foreach my $mgmtsvr (@mgmtsvr_hostnames)
            {
                $dir = $::CSMINSTDIR;
				#If undefined $TFTPpackage attribute, it means its value is blank.
				#Remove this attribute from command string
                my $cmd;
				if (!(defined $TFTPpackage) || ($TFTPpackage eq ""))
				{
	           	   $cmd =
                  "LANG=C $::SYNCSERVERS_CLIENT -m $mgmtsvr -i $mgmtsvr -p $dir $SETUP_ALL_FLAG $verboseflag $SETUP_SIS_FLAG";
				
				} 
				else
				{
                	$cmd =
                  "LANG=C $::SYNCSERVERS_CLIENT -m $mgmtsvr -i $mgmtsvr -p $dir -t $TFTPpackage $SETUP_ALL_FLAG $verboseflag $SETUP_SIS_FLAG";
				}
                MessageUtils->messageFromCat('nodecmds.cat', $::MSGMAPPATH,
                                             'NodeUtils', 'V', 'IMsgCMD', $cmd);
                open(DSHCMD, "$cmd|")
                  || MessageUtils->messageFromCat('csmInstall.cat',
                          $::MSGMAPPATH, 'csminstall', 'E2', 'EMsgCANT_RUN_CMD',
                          $cmd);

                while (<DSHCMD>)
                {
                    print $_;
                }
                close(DSHCMD);
 	#Extract pxelinux.0 from ISO and copy it to /tftpboot/csm/
 		$::arch = NodeUtils->get_PkgArchitecture;
 	    	if ($::arch eq "ppc64") {
     			my ($InstallDistributionName);
     			my ($InstallDistributionVersion);
 			my ($InstallServiceLevel);
 			my ($InstallPkgArchitecture);
 			my ($InstallCSMVersion);
 			my ($InstallMethod);
 			my ($InstallServiceLevel);
 			my %distro_group_hash;
 			foreach my $hostname (keys %::NODEHASH)
     			{
         			$InstallDistributionName =
 		        	$::NODEHASH{$hostname}{'InstallDistributionName'};
 		        	$InstallDistributionVersion =
 		        	$::NODEHASH{$hostname}{'InstallDistributionVersion'};
 		        	$InstallPkgArchitecture =
           			$::NODEHASH{$hostname}{'InstallPkgArchitecture'};
 		        	$InstallCSMVersion = $::NODEHASH{$hostname}{'InstallCSMVersion'};
 				$InstallServiceLevel = $::NODEHASH{$hostname}{'InstallServiceLevel'};
 			}
 	        	my $undef;
 			my %nodehash = %::NODEHASH;
 			my $MSOS = NodeUtils->get_OSName;
 			my $CSMV = NodeUtils->get_CSMVersion("csm\.core");
 
 	        	%::mndefs =
           		ServerUtils->get_pkgdefs(
                                                         $MSOS,
                                                         $InstallDistributionName,
                                                         $InstallDistributionVersion,
                                                         $InstallPkgArchitecture,
                                                         "InstallServer",
                                                         $CSMV
                                                           );
 			if ($InstallPkgArchitecture =~ /i.86/ || $InstallPkgArchitecture =~ /x86_64/) {
 				ServerUtils->populate_tftpboot(\%::mndefs,$InstallServiceLevel); 
 			}
 	     	}
            }
        }

        # Call syncServers.client on the Linux install servers
        foreach my $installsvr (@Linux_servers)
        {
            chomp $installsvr;

            # Get the hostname of the management server as known by
            # the install server.
            if ($ishash{$installsvr}{'ManagementServer'})
            {
                $mgmtsvr = $ishash{$installsvr}{'ManagementServer'};
            }
            else
            {

                # Determine the name of the management server as known by the
                # install server.
                $mgmtsvr = NetworkUtils->get_management_server($installsvr);
            }
            chomp $mgmtsvr;
            my $dir = $$server_hash{$installsvr}{"InstallDir"};

			#If undefined $TFTPpackage attribute, it means its value is blank.
			#Remove this attribute from command string
            my $cmd;
			if (!(defined $TFTPpackage) || ($TFTPpackage eq ""))
			{
               $cmd =
              "LANG=C $::DSH -s -n $installsvr \"$::SYNCSERVERS_CLIENT -m $mgmtsvr -i $installsvr -p $dir $SETUP_ALL_FLAG $verboseflag $SETUP_SIS_FLAG\"";
	
			}
			else
			{
               $cmd =
              "LANG=C $::DSH -s -n $installsvr \"$::SYNCSERVERS_CLIENT -m $mgmtsvr -i $installsvr -p $dir -t $TFTPpackage $SETUP_ALL_FLAG $verboseflag $SETUP_SIS_FLAG\"";
			}            $cmd .= ' 2>&1';
            MessageUtils->messageFromCat('nodecmds.cat', $::MSGMAPPATH,
                                         'NodeUtils', 'V', 'IMsgCMD', $cmd);
            open(DSHCMD, "$cmd|") || die "Cannot run command: $cmd\n";

            while (<DSHCMD>)
            {
                print $_;
            }
            close(DSHCMD);
        }
    }

# DCenableservices exit label
DCenableservices_exit:
    my $rc = 0;
    $rc |= DCUtils->checkDCRetCode('DCenableservices_exit');
    DCUtils->stop_logging($::__CLUSTER_INFO_HASH{'logfile_DCenableservices'});
	if($un_set)  
	{
    	undef $ENV{'DC_ENVIRONMENT'};
	}		
    print "LEAVING: $routine\n" if $::DEBUG;
    return $rc;
}

#==============================================================================

=head3  DCinstallnode
        
        Perform final setup to install a set of nodes, but do not actually 
		reboot the node.

        Arguments:
        $cluster_info_hash
            Reference to a hash of the clusterinfo attributes.  Optional.
            Default values will be used for the missing attributes.
        $node_info_hash
            Reference to a hash containing attributes of each node.
        $server_info_hash
            Reference to a hash containing attributes of the install servers.
            This parameter is only required if separate install servers are 
			used by nodes in node_info_hash.
        $skip_file_load_flag
            Skip reloading clusterinfo, nodeinfo, and install server nodeinfo 
			files. 
        $verbose_flag
            Display verbose messages to stdout if set to anything other than 0 
			or blank.
        \@bootparams
            A reference to an array that will get filled in with the boot 
			parameters that are needed to boot each ppc node.
        $timeout
            Overrides node_install_timeout in clusterinfo or the default of 60 
			minutes if set to anything other than blank.
        $skip_isvr
            Do not run DCsyncserver if this parameter is set to 1.  
        
        Returns:
            0:        successful
            non-zero: failed
        Errors:
            see returns
        Examples:
        DCAPI->DCinstallnode($cluster_info_hash, $node_info_hash, 
					 $server_info_hash, $skipFileLoadFlag,  
		             $verboseFlag, $bootParams, $timeOut, $skipServer)
=cut 

#==============================================================================
sub DCinstallnode
{
    my (
        $pkg,              $cluster_info_hash, $node_info_hash,
        $server_info_hash, $skip_file_load_flag,  $verboseFlag,
        $bootParams,       $timeOut,           $skipServer
       )
      = @_;
    my $rc = 0;
    # Declare overridden built-in routine.
    # Note: use "local" to make sure recover built-in routine when exiting from API itself.
    # If DCAPI is called nested, built-in overridden is declared many times,
    #   it maybe brings potential performance issues. 
    # But CSM only call DCAPI at most nested by two layers in codes, 
    #   it is safe right now. 
    local *CORE::GLOBAL::exit;
    # Override the built-in exit with our version.
    # This override exit will not be valid after exiting from the outermost DCAPI.
    *CORE::GLOBAL::exit = \&DCUtils::__CSM_exit;
    
    local *CORE::GLOBAL::die;
    # Override the built-in die with our version.
    # This override die will not be valid after exiting from the outermost DCAPI.
    *CORE::GLOBAL::die = \&DCUtils::__CSM_die;
	my $un_set=0;  
	my $un_set_CSM_NO_SETUP_DHCP = 0;

    # Get the $::VERBOSE global variable from exploiter
    my $verbose_passed = $::VERBOSE;
    local $::VERBOSE;
	$::VERBOSE = $verbose_passed || $verboseFlag;
	if(!$ENV{'DC_ENVIRONMENT'})
	{
    	$ENV{'DC_ENVIRONMENT'}=1;
		$un_set=1;
	}		
    else
    {
        # Register exit point if DC environment
        if (  (!$::__DC_RETURN_ANCHOR)
            && ($ENV{'DC_ENVIRONMENT'} ne 'CSM')
        )
        {

            # Set return flag label
            $::__DC_RETURN_ANCHOR = 'DCinstallnode_exit';
            # Set current process pid
            $::__DC_PID = $$;

            # Don't configure DHCP service on HMC for P6 machines.
            # Because it will make conflicts if CSM and HMC use dhcp service 
            # at the same time.
            if ( NodeUtils->isHMC()
                && (! defined $ENV{CSM_NO_SETUP_DHCP} )
            )
            {
                $un_set_CSM_NO_SETUP_DHCP = 1;
                $ENV{CSM_NO_SETUP_DHCP} = 1;
            }
        }
    }
	my ($cluster_hash, $ref_nodehash, $ref_ishash) =
      DCUtils->get_all_info_from_hash($cluster_info_hash, $node_info_hash,
                            $server_info_hash);

	DCUtils->start_logging($::__CLUSTER_INFO_HASH{'logfile_DCinstallnode'});
	my @req_node_attrs=("Hostname","InstallOSName","InstallDistributionName",
						"InstallDistributionVersion", "InstallPkgArchitecture",
						"InstallAdapterMacaddr","UUID","ManagementServer");
   
	my @req_server_attrs=("Hostname","InstallOSName","InstallDistributionName",
						"InstallDistributionVersion",
						"InstallPkgArchitecture","InstallServiceLevel");
				
	DCUtils->check_req_attrs($ref_nodehash,\@req_node_attrs,$ref_ishash,
							 \@req_server_attrs,$skip_file_load_flag);		   	
    DCUtils->check_deploy_attrs($ref_nodehash,$skip_file_load_flag,$ref_ishash);
    

    if($ENV{'DC_ENVIRONMENT'} ne "CSM")
    {
        ServerUtils->get_OSDefs;
    }    
    if (DCUtils->make_osprereboot_script($ref_nodehash) != 0)
    {

        # Could not create osprereboot script
        #  msg was displayed by subroutine
        $::GLOBAL_EXIT = 1;
        exit $::GLOBAL_EXIT;
    }
    
    $ENV{'DSH_REMOTE_CMD'} = DCUtils->getRemoteShell;
    $ENV{'DCP_COPY_CMD'} = DCUtils->getRemoteCopyCmd;
   
    my $ms_port = DCUtils->setInstallMsgPort($ref_nodehash);

    DCUtils->merge_config_info;
    
    if (keys %$ref_ishash)
    {
        $::DEPLOY_ATTR_CHECKED = 1;
        DCAPI->DCsyncServers($cluster_info_hash, $node_info_hash,
                             $server_info_hash, 1, $verboseFlag);
    }
    
    DCUtils->remove_reboot_ready_file($ref_nodehash);

    #
    # setup nfs
    #
    $rc |= NetworkUtils->start_nfs($ref_nodehash, $ref_ishash);

    if (NetworkUtils->export_csminstall($ref_nodehash, $ref_ishash) != 0)
    {

        # Could not export.
        MessageUtils->message('E', 'EMsgNO_EXPORT');
        $::GLOBAL_EXIT = 1;
        exit $::GLOBAL_EXIT;
    }

    if (NodeUtils->isLinux)
    {

        # check DHCP daemon on MS if any IS different than MS is being used.
        # This check can be skipped by users.
        if (!defined $ENV{'CSM_SKIP_COMMON_SUBNET_CHECK'}
            || $ENV{'CSM_SKIP_COMMON_SUBNET_CHECK'} == 0)
        {
			# Only verify DHCP for install methods that actually require dhcp
			foreach my $hostname (keys %$ref_nodehash)
			{
				my $InstallMethod = $$ref_nodehash{$hostname}{'InstallMethod'};
				if ($InstallMethod =~ /kickstart|kickstart-upgrade|autoyast|warewulf|sis/)
				{
					DCUtils->verify_ms_dhcpd($ref_nodehash, $ref_ishash);
					last;	# Do it for all nodes, but only do it once.
				}
			}
        }
    }

    my ($InstallDistributionName);
    my ($InstallDistributionVersion);
    my ($InstallServiceLevel);
    my ($InstallPkgArchitecture);
    my ($InstallCSMVersion);
    my ($InstallMethod);
    my %distro_group_hash;

    # go through each node and divide them into different distro group 
    foreach my $hostname (keys %$ref_nodehash)
    {
        $InstallDistributionName =
          $$ref_nodehash{$hostname}{'InstallDistributionName'};
        $InstallDistributionVersion =
          $$ref_nodehash{$hostname}{'InstallDistributionVersion'};
        $InstallServiceLevel =
          $$ref_nodehash{$hostname}{'InstallServiceLevel'};
        $InstallPkgArchitecture =
          $$ref_nodehash{$hostname}{'InstallPkgArchitecture'};
        $InstallCSMVersion = $$ref_nodehash{$hostname}{'InstallCSMVersion'};
        $InstallMethod = $$ref_nodehash{$hostname}{'InstallMethod'};

        my $distro_group =
            $InstallDistributionName . ":"
          . $InstallDistributionVersion . ":"
          . $InstallServiceLevel . ":"
          . $InstallPkgArchitecture . ":"
          . $InstallCSMVersion . ":"
          . $InstallMethod;

        push @{$distro_group_hash{$distro_group}}, $hostname;
    }

    my %nodehash_bak = %::NODEHASH;    
    foreach my $distro_group (keys %distro_group_hash)
    {
        ($::DISTRO_NAME, 
		 $::DISTRO_VERSION, 
		 $::SERVICE_LEVEL,
		 $::ARCH, 
		 $::CSM_VERSION, 
		 $::INSTALL_METHOD) = split(":", $distro_group);

        my @target_node_list = @{$distro_group_hash{$distro_group}};

        %::NODEHASH = ();
        foreach my $node (@target_node_list)
        {
            $::NODEHASH{$node} = $ref_nodehash->{$node};
        }    
        
        # InstallMethod attribute must be common in each cycle.
		# The INSTALL_METHOD is already the same for all the nodes in this group
		#$::INSTALL_METHOD = DCUtils->common_install_method($ref_nodehash,\@target_node_list);

        # get the pkgDefs for these attributes
        %::lnxpkgdefs =
            ServerUtils->get_pkgdefs('Linux', $::DISTRO_NAME, $::DISTRO_VERSION,
                               $::ARCH, "MgdNode", $::CSM_VERSION);
        
        # Make sure all nodes have valid InstallMethod
        DCUtils->validate_install_method($ref_nodehash,\@target_node_list);           
		my $rc = MessageUtils->initialize_status(\@target_node_list);
		($rc) && MessageUtils->message('E2', 'EMsgINIT_STATUS_ERROR');
        
		if ($::INSTALL_METHOD =~ /kickstart|kickstart-upgrade|autoyast|warewulf|sis/)
		{
			DCUtils->full_install(\%::NODEHASH, $ref_ishash,\@target_node_list,$bootParams);
		}
		elsif ($::INSTALL_METHOD =~ /you/)
		{
			DCUtils->you_upgrade(\%::NODEHASH, $ref_ishash,\@target_node_list);
		}
    }
    %::NODEHASH = %nodehash_bak;

    my @node_list=keys %$ref_nodehash;
            
    # Add node entry in AllowNodeMsgs file
    DCUtils->setAllowNodeMsgs($ref_nodehash);

    # Start nodestatusd daemon
    DCUtils->start_nodestatusd($ref_nodehash, $ms_port);
	
	if($ENV{'DC_ENVIRONMENT'} ne "CSM")
	{
   		#Need to write status in non-CSM senario
		#In CSM,this will be done in installnode
		my $msg = MessageUtils->getMessage('IMsgFULL_INSTALL_INITATED');

    	foreach my $node (@node_list)
    	{
        	MessageUtils->write_status($node, $msg);
    	}
	}	
	
# DCinstallnode exit label
DCinstallnode_exit:
    $rc |= DCUtils->checkDCRetCode('DCinstallnode_exit');
    DCUtils->stop_logging($::__CLUSTER_INFO_HASH{'logfile_DCinstallnode'});
    if($un_set)
	{
    	undef $ENV{'DC_ENVIRONMENT'};
	}

	if ($un_set_CSM_NO_SETUP_DHCP)
	{
		undef $ENV{CSM_NO_SETUP_DHCP};
	}	
    return $rc;
}
#--------------------------------------------------------------------------------

=head3  DCcleanupFailedInstall
            Clean up installation files on the management server after a failed installation

    Arguments:
        $cluster_info_hash_ref
            Reference to a hash of the clusterinfo attributes.  Optional.
            Default values will be used for the missing attributes.
        $node_info_hash_ref
            Reference to a hash containing attributes of each node.
        $IS_nodeinfo_hash_ref
            Reference to a hash containing attributes of the install servers.
            This parameter is only required if separate install servers are used by nodes in node_info_hash.
        $skip_file_load_flag
            Skip reloading clusterinfo and nodeinfo files.  This flag can be used to
            improve performance when calling multiple functions in the deployment component
            perl API from the same process with the identical set of files.  The deployment
            component loads these files into internal global hash variables, and will not
            reload them if this flag is set.

        $verbose_flag
            Display verbose messages to stdout if set to anything other than 0 or blank.

    Returns:
        0:        successful
        non-zero: failed

    Globals:
        $::VERBOSE

    Error:
        see returns

    Example:
        DCAPI->DCcleanupFailedInstall($clusterinfo_hash_ref, $node_info_hash_ref,
                                      $IS_nodeinfo_hash_ref, $skip_file_load_flag, $verbose_flag)
    Comments:
        none

=cut

#--------------------------------------------------------------------------------
sub DCcleanupFailedInstall{
    my ($class, $clusterinfo_hash_ref, $node_info_hash_ref, 
        $IS_nodeinfo_hash_ref, $skip_file_load_flag, $verbose_flag) = @_;
	my $un_set=0;  
    # Declare overridden built-in routine.
    # Note: use "local" to make sure recover built-in routine when exiting from API itself.
    # If DCAPI is called nested, built-in overridden is declared many times,
    #   it maybe brings potential performance issues. 
    # But CSM only call DCAPI at most nested by two layers in codes, 
    #   it is safe right now. 
    local *CORE::GLOBAL::exit;
    # Override the built-in exit with our version.
    # This override exit will not be valid after exiting from the outermost DCAPI.
    *CORE::GLOBAL::exit = \&DCUtils::__CSM_exit;
    
    local *CORE::GLOBAL::die;
    # Override the built-in die with our version.
    # This override die will not be valid after exiting from the outermost DCAPI.
    *CORE::GLOBAL::die = \&DCUtils::__CSM_die;

    # Get the $::VERBOSE global variable from exploiter
    my $verbose_passed = $::VERBOSE;
    local $::VERBOSE;
	$::VERBOSE = $verbose_passed || $verbose_flag;
	if(!$ENV{'DC_ENVIRONMENT'})
	{
    	$ENV{'DC_ENVIRONMENT'}=1;
		$un_set=1;
	}	
    else
    {
        # Register exit point if DC environment
        if (  (!$::__DC_RETURN_ANCHOR)
           && ($ENV{'DC_ENVIRONMENT'} ne 'CSM')
        )
        {

            # Set return flag label
            $::__DC_RETURN_ANCHOR = 'DCcleanupFailedInstall_exit';
            # Set current process pid
            $::__DC_PID = $$;
        }
    }
    my ($cluster_info_hash_ref,$node_info_hash_ref,$IS_info_hash_ref) = 
        DCUtils->get_all_info_from_hash($clusterinfo_hash_ref, $node_info_hash_ref, $IS_nodeinfo_hash_ref,
                              $skip_file_load_flag);
	my @req_node_attrs=("Hostname","InstallOSName","InstallDistributionName","InstallDistributionVersion",
						"InstallPkgArchitecture","ManagementServer");
   
	DCUtils->check_req_attrs($node_info_hash_ref,\@req_node_attrs,undef,undef,$skip_file_load_flag);		   	
    DCUtils->merge_config_info();
    DCUtils->start_logging($$cluster_info_hash_ref{'logfile_DCcleanupFailedInstall'});
    ServerUtils->nodestatus_stop_logging($node_info_hash_ref);

# DCcleanupFailedInstall exit label
DCcleanupFailedInstall_exit:
    my $rc = 0;
    $rc |= DCUtils->checkDCRetCode('DCcleanupFailedInstall_exit');
    DCUtils->stop_logging($::__CLUSTER_INFO_HASH{'logfile_DCcleanupFailedInstall'});
	if($un_set)  
	{
    	undef $ENV{'DC_ENVIRONMENT'};
	}		
    return $rc;
}

#--------------------------------------------------------------------------------

=head3  DCmakedhcp
           Add or delete entries from the dhcp configuration file on the install server. 

    Arguments:
        $cluster_info_hash
            Reference to a hash of the clusterinfo attributes.  Optional.
            Default values will be used for the missing attributes.

        $nodeinfo_hash
            Reference to a hash containing attributes of each node.

        $ISinfo_hash
            Reference to a hash containing attributes of the install servers.
            This parameter is only required if separate install servers are used by nodes in nodeinfo_hash.

        $skip_file_load_flag
            Skip reloading clusterinfo and nodeinfo files.  This flag can be used to
            improve performance when calling multiple functions in the deployment component
            perl API from the same process with the identical set of files.  The deployment
            component loads these files into internal global hash variables, and will not
            reload them if this flag is set.

        $verbose_flag
		    Display verbose messages to stdout if set to anything other than 0 or blank.

		$makechcp_options
            Display verbose messages to stdout if set to anything other than 0 or blank.
		    A single string that contains all the command-line parameters needed to run the 
			makedhcp command, except for the node list.  These parameters will be used to 
			generate the call to makedhcp on the install server. 

    Returns:
        0:        successful
        non-zero: failed
    Globals:
        $::VERBOSE

    Error:
        see returns

    Example:
        DCAPI->DCmakedhcp(\%cluster_info_hash, $nodeinfo_hash, $ISinfo_hash,
                         $skip_file_load_flag, $verbose_flag, $makedhcp_options)
    Comments:
        none

=cut

#--------------------------------------------------------------------------------
sub DCmakedhcp
{
    my $routine = "DCmakedhcp";
    print "ENTERING: $routine\n" if $::DEBUG;
    # Declare overridden built-in routine.
    # Note: use "local" to make sure recover built-in routine when exiting from API itself.
    # If DCAPI is called nested, built-in overridden is declared many times,
    #   it maybe brings potential performance issues. 
    # But CSM only call DCAPI at most nested by two layers in codes, 
    #   it is safe right now. 
    local *CORE::GLOBAL::exit;
    # Override the built-in exit with our version.
    # This override exit will not be valid after exiting from the outermost DCAPI.
    *CORE::GLOBAL::exit = \&DCUtils::__CSM_exit;
    
    local *CORE::GLOBAL::die;
    # Override the built-in die with our version.
    # This override die will not be valid after exiting from the outermost DCAPI.
    *CORE::GLOBAL::die = \&DCUtils::__CSM_die;
    @::VALID_ATTRS  = ("Netmask", "Gateway", "Nameservers");
    $::MAKEDHCP     = "/opt/csm/csmbin/makedhcp";
    $::RUN_FOR_NODE = 0;
    my ($cmd, $opt_string);

    my ($pkg, $cluster_info_hash, $nodeinfo_hash, $ISinfo_hash,
        $skip_file_load_flag, $verbose_flag, $makedhcp_options)
      = @_;
	my $un_set=0;  

    # Get the $::VERBOSE global variable from exploiter
    my $verbose_passed = $::VERBOSE;
    local $::VERBOSE;
	$::VERBOSE = $verbose_passed || $verbose_flag;
	if(!$ENV{'DC_ENVIRONMENT'})
	{
    	$ENV{'DC_ENVIRONMENT'}=1;
		$un_set=1;
	}	
    else
    {
        # Register exit point if DC environment
        if (  (!$::__DC_RETURN_ANCHOR)
           && ($ENV{'DC_ENVIRONMENT'} ne 'CSM')
        )
        {

            # Set return flag label
            $::__DC_RETURN_ANCHOR = 'DCmakedhcp_exit';
            # Set current process pid
            $::__DC_PID = $$;
        }
    }
    my ($cluster_hash, $ref_nodehash, $ref_ishash) =
      DCUtils->get_all_info_from_hash($cluster_info_hash, $nodeinfo_hash,
                                      $ISinfo_hash, $skip_file_load_flag);
	my @req_node_attrs=("Hostname","InstallOSName","InstallDistributionName","InstallDistributionVersion",
						"InstallPkgArchitecture","InstallAdapterMacaddr","UUID","ManagementServer");
   
	my @req_server_attrs=("Hostname","InstallOSName","InstallDistributionName","InstallDistributionVersion",
						"InstallPkgArchitecture","InstallServiceLevel");
				
	DCUtils->check_req_attrs($ref_nodehash,\@req_node_attrs,$ref_ishash,\@req_server_attrs,$skip_file_load_flag);		   	
    %::nodehash = %$ref_nodehash;
    %::ishash   = %$ref_ishash;
    if (keys %::nodehash)
    {
        $::RUN_FOR_NODE = 1;
    }

    DCUtils->start_logging(
        $::__CLUSTER_INFO_HASH{'logfile_DCmakedhcp'} );

    # On HMC platform, we should not configure DHCP since it has possibility that conflicts 
    # DHCP setting configed by HMC. 
    # Instead, CSM use bootp procotol to substitute it.
    if (  NodeUtils->isHMC()
       && defined $ENV{'DC_ENVIRONMENT'}
       && ($ENV{'DC_ENVIRONMENT'} ne 'CSM')
       )
    {
        MessageUtils->messageFromCat(
                                    'csmInstall.cat',         $::MSGMAPPATH,
                                    'csminstall',             "L",
                                    'EMsgNoSupportDCmakedhcp'
                                    );
        return $::NOK;
    }
    # checks case in GetOptions
    $Getopt::Long::ignorecase = 0;
    # Allows opts to be grouped (e.g. -avx)
    Getopt::Long::Configure("bundling");

    local @ARGV = split(/\s+/, $makedhcp_options);

    if (
        !GetOptions(
                    'd=s'        => \$::DYN_LIST,
                    'k=s'        => \$::SHARED_NETWORK,
                    's=s'        => \$::SUBNET,
                    'v'          => \$::VERBOSE,
                    'V'          => \$::VERBOSE,
                    'new'        => \$::NEWCONFIG,
                    'add'        => \$::ADDOBJ,
                    'del|delete' => \$::DELOBJ,
                    'uuid|UUID'  => \$::UUID,
                    'mac|MAC'    => \$::MAC,
                    'setupcsm'   => \$::SETUPCSM,
                    'o=s'        => \$::OPTIONS,
                   )
       )
    {
        exit 1;
    }

    if (($::MAC) && ($::UUID))
    {
        MessageUtils->message('E1', 'EMsg_UUID_MAC_together');
    }

    # Handle attr=value arguments

    if (scalar(@ARGV) > 0)
    {
        foreach my $a (@ARGV)
        {

            # Note:  we allow a null value
            my ($attr, $value) = $a =~ /^\s*(\S+?)\s*=\s*(\S*.*)$/;

            if (!defined($attr))
            {
                MessageUtils->message('E1', 'EMsgBAD_ATTR_VAL_FORM');
            }
            my $found = 0;
            foreach my $va (@::VALID_ATTRS)
            {
                if ($attr =~ /\b$va\b/i)
                {

                    # Put quotes around the value to protect spaces or weird chars
                    $::ATTRS{$va} = $value;
                    $found = 1;
                }
            }
            if (!$found)
            {
                MessageUtils->message('E1', 'EMsgBAD_ATTR', $attr);
            }
        }

    }

    if (!$::SETUPCSM)
    {
        $::ONLYLEASE = "--only-lease";
    }

    if ($::NEWCONFIG)
    {
        $cmd = "$::MAKEDHCP --new";
        DCUtils->run_rmtCMD($cmd);
    }
    elsif ($::SHARED_NETWORK)
    {
        if ($::ADDOBJ)
        {
            $cmd = "$::MAKEDHCP --add-network $::SHARED_NETWORK";
        }
        else
        {
            $cmd = "$::MAKEDHCP --delete-network $::SHARED_NETWORK";
        }
        DCUtils->run_rmtCMD($cmd);
    }
    elsif ($::SUBNET)
    {
        my $attrs;
        foreach my $attr (keys %::ATTRS)
        {
            if ($attr eq "Netmask")
            {
                $::SUBNET .= "/$::ATTRS{$attr}";
                next;
            }
            $attrs .= " $attr=$::ATTRS{$attr}";
        }
        if ($::OPTIONS)
        {
            $opt_string = "-o \"$::OPTIONS\"";
        }
        if ($::ADDOBJ)
        {
            $cmd = "$::MAKEDHCP --add-subnet $::SUBNET $attrs $opt_string";
        }
        else
        {
            $cmd = "$::MAKEDHCP --delete-subnet $::SUBNET";
        }
        DCUtils->run_rmtCMD($cmd);
    }
    elsif ($::DYN_LIST)
    {
        my $attrs;
        foreach my $attr (keys %::ATTRS)
        {
            $attrs .= " $attr=$::ATTRS{$attr}";
        }
        if ($::OPTIONS)
        {
            $opt_string = "-o \"$::OPTIONS\"";
        }

        if ($::ADDOBJ)
        {
            $cmd =
              "$::MAKEDHCP --add-dynamic $::ONLYLEASE $::DYN_LIST $attrs $opt_string";
        }
        else
        {
            $cmd = "$::MAKEDHCP --delete-dynamic $::DYN_LIST";
        }
        DCUtils->run_rmtCMD($cmd);
    }
    else
    {

        # now do static nodes.
        if (!keys %::nodehash)
        {
            MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                    'csminstall', 'E1', 'EMsgNoNodesGiven');
        }

		my @nodelist = keys(%::nodehash);
		my $nl = join(',', @nodelist);

        # generate the config info files.
        DCUtils->set_config_info();

        # sync node config files into Install Servers if there are any.
        if (keys %$ref_ishash)
        {
            # Only node config files will be synced.
            my $old_skip_isvr = $ENV{CSM_SKIP_ISVR};
            $ENV{CSM_SKIP_ISVR} = 1;
            $::DEPLOY_ATTR_CHECKED = 1;
            DCAPI->DCsyncServers($cluster_info_hash, $nodeinfo_hash,
                                 $ISinfo_hash, 1, 0);
            $ENV{CSM_SKIP_ISVR} = $old_skip_isvr;
        }

        my $attrs;
        foreach my $attr (keys %::ATTRS)
        {
            $attrs .= " $attr=$::ATTRS{$attr}";
        }

        if ($::OPTIONS)
        {
            $opt_string = "-o \"$::OPTIONS\"";
        }

        if ($::DELOBJ)
        {
			$cmd = "$::MAKEDHCP --delete";
        }
        else
        {
			$cmd = "$::MAKEDHCP $::ONLYLEASE $attrs $opt_string";
        }
        DCUtils->run_rmtCMD($cmd);
    }
    print "LEAVING: $routine\n" if $::DEBUG;
    DCUtils->stop_logging($::__CLUSTER_INFO_HASH{'logfile_DCmakedhcp'});

# DCmakedhcp exit label
DCmakedhcp_exit:
    my $rc = 0;
    $rc |= DCUtils->checkDCRetCode('DCmakedhcp_exit');
	if($un_set)  
	{
    	undef $ENV{'DC_ENVIRONMENT'};
	}		
    return $rc;
}

#--------------------------------------------------------------------------------

=head3  DCmonitorinstall
        
    Returns the current installation status of nodes.
    
    Arguments:
        $cluster_info_hash
            Reference to a hash of the clusterinfo attributes.  Optional.
            Default values will be used for the missing attributes.
        $node_info_hash
            Reference to a hash containing attributes of each node.
        $ref_server_hash
            Reference to a hash containing attributes of the install servers.
            This parameter is only required if separate install servers are used by nodes in node_info_hash.
        $verbose_flag
		    Display verbose messages to stdout if set to anything other than 0 or blank.
        $skip_file_load_flag
            Skip reloading clusterinfo and nodeinfo files.  This flag can be used to
            improve performance when calling multiple functions in the deployment component
            perl API from the same process with the identical set of files.  The deployment
            component loads these files into internal global hash variables, and will not
            reload them if this flag is set.

        $skip_server_info

    Returns:
            0:        successful
            non-zero: failed
    Error:
            see returns
    Example:
        DCAPI->DCmonotorinstall($cluster_info_hash,$node_info_hash,$server_info_hash, $verbose_flag);
    Comments:
        none

=cut

#--------------------------------------------------------------------------------
sub DCmonitorinstall
{
    my ($pkg,$cluster_info_hash,$node_info_hash,$server_info_hash,
        $skip_file_load_flag,$verbose_flag,$current_status,$status_history,$skip_server_info)=@_;
	my $un_set=0;  
    # Declare overridden built-in routine.
    # Note: use "local" to make sure recover built-in routine when exiting from API itself.
    # If DCAPI is called nested, built-in overridden is declared many times,
    #   it maybe brings potential performance issues. 
    # But CSM only call DCAPI at most nested by two layers in codes, 
    #   it is safe right now. 
    local *CORE::GLOBAL::exit;
    # Override the built-in exit with our version.
    # This override exit will not be valid after exiting from the outermost DCAPI.
    *CORE::GLOBAL::exit = \&DCUtils::__CSM_exit;
    
    local *CORE::GLOBAL::die;
    # Override the built-in die with our version.
    # This override die will not be valid after exiting from the outermost DCAPI.
    *CORE::GLOBAL::die = \&DCUtils::__CSM_die;

    # Get the $::VERBOSE global variable from exploiter
    my $verbose_passed = $::VERBOSE;
    local $::VERBOSE;
	$::VERBOSE = $verbose_passed || $verbose_flag;
	if(!$ENV{'DC_ENVIRONMENT'})
	{
    	$ENV{'DC_ENVIRONMENT'}=1;
		$un_set=1;
	}		
    else
    {
        # Register exit point if DC environment
        if (  (!$::__DC_RETURN_ANCHOR)
           && ($ENV{'DC_ENVIRONMENT'} ne 'CSM')
        )
        {

            # Set return flag label
            $::__DC_RETURN_ANCHOR = 'DCmonitorinstall_exit';
            # Set current process pid
            $::__DC_PID = $$;
        }
    }
    my ($cluster_info_hash,$ref_node_hash,$ref_server_hash)=
        DCUtils->get_all_info_from_hash($cluster_info_hash,$node_info_hash,$server_info_hash,$skip_file_load_flag,1);    
	my @req_node_attrs=("Hostname","InstallOSName","InstallDistributionName","InstallDistributionVersion",
						"InstallPkgArchitecture","ManagementServer");
				
	DCUtils->check_req_attrs($ref_node_hash,\@req_node_attrs,undef,undef,$skip_file_load_flag);		   	
   
    DCUtils->start_logging(
        $::__CLUSTER_INFO_HASH{'logfile_DCmonitorinstall'}) ;

    $ENV{'DSH_REMOTE_CMD'} = DCUtils->getRemoteShell;
    $ENV{'DCP_COPY_CMD'} = DCUtils->getRemoteCopyCmd;
    
    if ($::RT_STAT)
    {
        DCUtils->getNodeRealTimeStatus($ref_node_hash, 1);

        #display the node real time status and then exit
        exit 0;
    }

    if ($::RT_STAT_LONG)
    {
        DCUtils->getNodeRealTimeStatus($ref_node_hash);
    }

    # copy status file from IS
	DCUtils->copyStatus($ref_node_hash);

	# debug
	# foreach(keys %$nodes){ print "Nodes: $_\n"; }

	# get the status for the nodes
	DCUtils->getStatus($ref_node_hash);

	
	foreach my $node (keys %$ref_node_hash)
	{
		$$current_status{$node}{"IStatus"}=$$ref_node_hash{$node}{"IStatus"};
		$$current_status{$node}{"Mode"}=$$ref_node_hash{$node}{"Mode"};

		if (exists $::ErrorNodes{$node})
		{
			if($::ErrorNodes{$node}{"Error"} eq  "true")
			{
				$$current_status{$node}{"Error"} = 1;
			}	
			else
			{
				$$current_status{$node}{"Error"} = 0;
			}	
		}
		if(defined($$ref_node_hash{$node}{"History"}))
		{	
			@{ $$status_history{$node} }=@{ $$ref_node_hash{$node}{"History"} };
		}
	}		
    
    DCUtils->stop_logging(
        $::__CLUSTER_INFO_HASH{'logfile_DCmonitorinstall'}) ;

# DCmonitorinstall exit label
DCmonitorinstall_exit:
    my $rc = 0;
    $rc |= DCUtils->checkDCRetCode('DCmonitorinstall_exit');
	if($un_set)  
	{
    	undef $ENV{'DC_ENVIRONMENT'};
	}
    return $rc;    
}
#--------------------------------------------------------------------------------

=head3  DCrmnode
            Remove all the files related to a specific node

    Arguments:
        $cluster_info_hash_ref
            Reference to a hash of the clusterinfo attributes.  Optional.
            Default values will be used for the missing attributes.
        $node_info_hash_ref
            Reference to a hash containing attributes of each node.
        $IS_nodeinfo_hash_ref
            Reference to a hash containing attributes of the install servers.
            This parameter is only required if separate install servers are used by nodes in node_info_hash.
        $skip_file_load_flag
            Skip reloading clusterinfo and nodeinfo files.  This flag can be used to
            improve performance when calling multiple functions in the deployment component
            perl API from the same process with the identical set of files.  The deployment
            component loads these files into internal global hash variables, and will not
            reload them if this flag is set.

        $verbose_flag
            Display verbose messages to stdout if set to anything other than 0 or blank.

    Returns:
        0:        successful
        non-zero: failed

    Globals:
        $::VERBOSE
    Error:
        see returns

    Example:
        DCAPI->DCrmnode($cluster_info_hash_ref, $node_info_hash_ref, $IS_nodeinfo_hash_ref, 
                        $skip_file_load_flag, $verbose_flag)
    Comments:
        none

=cut

#--------------------------------------------------------------------------------
sub DCrmnode{
    my ($class, $org_cluster_info_hash_ref, $node_info_hash_ref,
        $org_IS_nodeinfo_hash_ref, $skip_file_load_flag, $verbose_flag) = @_;
	my $un_set=0;  

    # Get the $::VERBOSE global variable from exploiter
    my $verbose_passed = $::VERBOSE;
    local $::VERBOSE;
	$::VERBOSE = $verbose_passed || $verbose_flag;
    # Declare overridden built-in routine.
    # Note: use "local" to make sure recover built-in routine when exiting from API itself.
    # If DCAPI is called nested, built-in overridden is declared many times,
    #   it maybe brings potential performance issues. 
    # But CSM only call DCAPI at most nested by two layers in codes, 
    #   it is safe right now. 
    local *CORE::GLOBAL::exit;
    # Override the built-in exit with our version.
    # This override exit will not be valid after exiting from the outermost DCAPI.
    *CORE::GLOBAL::exit = \&DCUtils::__CSM_exit;
    
    local *CORE::GLOBAL::die;
    # Override the built-in die with our version.
    # This override die will not be valid after exiting from the outermost DCAPI.
    *CORE::GLOBAL::die = \&DCUtils::__CSM_die;
	if(!$ENV{'DC_ENVIRONMENT'})
	{
    	$ENV{'DC_ENVIRONMENT'}=1;
		$un_set=1;
	}
    else
    {
        # Register exit point if DC environment
        if (  (!$::__DC_RETURN_ANCHOR)
           && ($ENV{'DC_ENVIRONMENT'} ne 'CSM')
        )
        {

            # Set return flag label
            $::__DC_RETURN_ANCHOR = 'DCrmnode_exit';
            # Set current process pid
            $::__DC_PID = $$;
        }
    }
    my $check_reachbility = 1;
    my $skip_server_info = 1;
    ($node_info_hash_ref,$org_IS_nodeinfo_hash_ref) = 
             DCUtils->dealwith_IS_attr($node_info_hash_ref,$org_IS_nodeinfo_hash_ref,$check_reachbility);  
    my ($cluster_info_hash_ref,$node_info_hash_ref,$IS_info_hash_ref) =
        DCUtils->get_all_info_from_hash($org_cluster_info_hash_ref, $node_info_hash_ref, 
                                        $org_IS_nodeinfo_hash_ref, $skip_file_load_flag,$skip_server_info);
    my @req_node_attrs=("Hostname","InstallOSName","InstallDistributionName","InstallDistributionVersion",
                        "InstallPkgArchitecture","ManagementServer");
    my @req_server_attrs=("Hostname","InstallOSName","InstallDistributionName","InstallDistributionVersion",
                          "InstallPkgArchitecture","InstallServiceLevel");
    DCUtils->check_req_attrs($node_info_hash_ref,\@req_node_attrs,$IS_info_hash_ref,\@req_server_attrs,$skip_file_load_flag);		   	
    DCUtils->start_logging($$cluster_info_hash_ref{'logfile_DCrmnode'});
    my @node_list = keys %$node_info_hash_ref;

    # Co-existence: should not run makedhcp on Install Servers with CSM lower than 1.5.0.
    my %makedhcp_node_hash;
    foreach my $node (@node_list)
    {   my $invalid_IS;
        my @IS_array = @{$$node_info_hash_ref{$node}{ISArrayRef}};
        foreach my $is_name (@IS_array){
            my $csmversion=$$IS_info_hash_ref{$is_name}{InstallCSMVersion};
            if($csmversion)
            {
                $csmversion =~ /^(\d+\.\d+)/;
                if ($1 < 1.5){
                    $invalid_IS = 1;
                    last;
                }
            }
        }
        $makedhcp_node_hash{$node}=$$node_info_hash_ref{$node} if !$invalid_IS;
    }
    # now call makedhcp to remove the DHCP entries.
    # note that we should not config dhcp service on HMC platform.
    if(scalar (keys %makedhcp_node_hash) 
      && ! NodeUtils->isHMC())
    {
        my $makechcp_options = '--delete';
        $ENV{'SILENCE'} = 1;
        DCAPI->DCmakedhcp($org_cluster_info_hash_ref, \%makedhcp_node_hash, $org_IS_nodeinfo_hash_ref,
                          $skip_file_load_flag ,$verbose_flag,$makechcp_options);
        $ENV{'SILENCE'} = 0;
    }

    NodesetUtils->remove_SMSentry(@node_list);
    my $pid;
    my @children;
    my $pid_count;
    # Limit the number of sub processes that will be started at one time.
    my $threshold = 64;
    foreach my $node (@node_list)
    {
        if ( $pid = fork)
        {
            #parent, store children pid
            push @children, $pid;
            $pid_count++;
        }
        elsif( defined $pid)
        {
            #children, do remove_trace
            NodesetUtils->remove_trace_on_MS($node, $node_info_hash_ref);
            NodesetUtils->remove_trace_on_IS($node, $node_info_hash_ref);
            exit;
        }
        else
        {
            #cant fork. cant use msg catalog because no sub process is available.
            printf "rmnode: Unable to fork child process. \n";
        }

        if ( $pid_count == $threshold)
        {
            foreach $pid (@children)
            {
                waitpid( $pid, 0);
            }
            undef @children;
            $pid_count = 0;
        }
    }
    # Wait for that trace of the last node is removed
    foreach $pid (@children)
    {
        waitpid( $pid, 0);
    }

# DCrmnode exit label
DCrmnode_exit:
    my $rc = 0;
    $rc |= DCUtils->checkDCRetCode('DCrmnode_exit');
    DCUtils->stop_logging($::__CLUSTER_INFO_HASH{'logfile_DCrmnode'});
	if($un_set)  
	{
    	undef $ENV{'DC_ENVIRONMENT'};
	}		
    return $rc;
}

#--------------------------------------------------------------------------------

=head3  DCrmOSInstallImage
           Remove all the files related to an operating system install image.

    Arguments:
        $cluster_info_hash
            Reference to a hash of the clusterinfo attributes.  Optional.
            Default values will be used for the missing attributes.

        $nodeinfo_hash
            Reference to a hash containing attributes of each node.

        $ISinfo_hash
            Reference to a hash containing attributes of the install servers.
            This parameter is only required if separate install servers are used by nodes in nodeinfo_hash.

        $skip_file_load_flag
            Skip reloading clusterinfo and nodeinfo files.  This flag can be used to
            improve performance when calling multiple functions in the deployment component
            perl API from the same process with the identical set of files.  The deployment
            component loads these files into internal global hash variables, and will not
            reload them if this flag is set.

        $verbose_flag
            Display verbose messages to stdout if set to anything other than 0 or blank.

    Returns:
        0:        successful
        non-zero: failed
    Globals:
        $::VERBOSE

    Error:
        see returns

    Example:
        DCAPI->DCrmOSInstallImage(\%cluster_info_hash, $nodeinfo_hash, $ISinfo_hash,
                         $skip_file_load_flag, $verbose_flag)
    Comments:
        none

=cut

#--------------------------------------------------------------------------------
sub DCrmOSInstallImage
{
    my $routine = "DCrmOSInstallImage";
    print "ENTERING: $routine\n" if $::DEBUG;
    # Declare overridden built-in routine.
    # Note: use "local" to make sure recover built-in routine when exiting from API itself.
    # If DCAPI is called nested, built-in overridden is declared many times,
    #   it maybe brings potential performance issues. 
    # But CSM only call DCAPI at most nested by two layers in codes, 
    #   it is safe right now. 
    local *CORE::GLOBAL::exit;
    # Override the built-in exit with our version.
    # This override exit will not be valid after exiting from the outermost DCAPI.
    *CORE::GLOBAL::exit = \&DCUtils::__CSM_exit;
    
    local *CORE::GLOBAL::die;
    # Override the built-in die with our version.
    # This override die will not be valid after exiting from the outermost DCAPI.
    *CORE::GLOBAL::die = \&DCUtils::__CSM_die;
    my ($pkg, $cluster_info_hash, $nodeinfo_hash, $ISinfo_hash,
        $skip_file_load_flag, $verbose_flag)
      = @_;
	my $un_set=0;  

    # Get the $::VERBOSE global variable from exploiter
    my $verbose_passed = $::VERBOSE;
    local $::VERBOSE;
	$::VERBOSE = $verbose_passed || $verbose_flag;
	if(!$ENV{'DC_ENVIRONMENT'})
	{
    	$ENV{'DC_ENVIRONMENT'}=1;
		$un_set=1;
	}		
    else
    {
        # Register exit point if DC environment
        if (  (!$::__DC_RETURN_ANCHOR)
           && ($ENV{'DC_ENVIRONMENT'} ne 'CSM')
        )
        {

            # Set return flag label
            $::__DC_RETURN_ANCHOR = 'DCrmOSInstallImage_exit';
            # Set current process pid
            $::__DC_PID = $$;
        }
    }
    my ($cluster_hash, $ref_nodehash, $ref_ishash) =
      DCUtils->get_all_info_from_hash($cluster_info_hash, $nodeinfo_hash,
                                      $ISinfo_hash, $skip_file_load_flag);

	my @req_node_attrs=("Hostname","InstallOSName","InstallDistributionName","InstallDistributionVersion",
						"InstallPkgArchitecture","InstallServiceLevel","ManagementServer");
				
	DCUtils->check_req_attrs($ref_nodehash,\@req_node_attrs,undef,undef,$skip_file_load_flag);		   	
    DCUtils->start_logging(
                                $::__CLUSTER_INFO_HASH{'logfile_DCrmOSInstallImage'});

    my $ref_MgtNodes       = DCUtils->get_nodes_with_no_is;
    my @MgtNodes           = @$ref_MgtNodes;
    my $ref_InstallServers = DCUtils->get_install_servers;
    my %InstallServers     = %$ref_InstallServers;
    my $os_img_dir;

    if (@MgtNodes)
    {
        foreach my $hostname (@MgtNodes)
        {
            $os_img_dir = DCUtils->get_os_img_dirname($hostname, "/csminstall");
            if ($os_img_dir)
            {
                my $cmd = "/bin/rm -rf $os_img_dir";
                my $output = NodeUtils->runcmd($cmd, 1);
                $::BOOT_EXIT = 1 if $::RUNCMD_RC;
                MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                                 'csminstall', 'I', 'IMsgShow_Output', $output);
            }
        }
    }

    $ENV{DSH_LIST} = '';    #clear dsh env.

    # >>> check reachability to the Install Servers >>>
    $ENV{'DSH_REMOTE_CMD'} = DCUtils->getRemoteShell;
    my @installServers    = keys %InstallServers;
    my $refISNotReachable = NetworkUtils->checkRSReachability(\@installServers);
    if ($refISNotReachable != 0)
    {
        if (scalar @$refISNotReachable > 0)
        {
            my $isvrs = join ",", @$refISNotReachable;
            MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                                      'csminstall', 'E1', 'EMsgISDown', $isvrs);
        }
    }

    foreach my $is (keys %InstallServers)
    {
        my $dir      = $InstallServers{$is}{"InstallDir"};
        my @nodelist = @{$InstallServers{$is}{"NodesToBeInstalled"}};

        foreach my $hostname (@nodelist)
        {
            $os_img_dir = DCUtils->get_os_img_dirname($hostname, $dir);
            if ($os_img_dir)
            {
                my $command = "/bin/rm -rf $os_img_dir";
		my %options_api = ();
		$options_api{'nodes'} = $is;
		$options_api{'command'} = $command;
                my $output  = NodeUtils->runDsh(\%options_api, 1);
                $::BOOT_EXIT = 1 if $::RUNCMD_RC;
                MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                                 'csminstall', 'I', 'IMsgShow_Output', $output);
            }
        }

    }

# DCrmOSInstallImage exit label
DCrmOSInstallImage_exit:
    my $rc = 0;
    $rc |= DCUtils->checkDCRetCode('DCrmOSInstallImage_exit');
    DCUtils->stop_logging($::__CLUSTER_INFO_HASH{'logfile_DCrmOSInstallImage'});
	if($un_set)  
	{
    	undef $ENV{'DC_ENVIRONMENT'};
	}
    return $rc;    
}

#--------------------------------------------------------------------------------

=head3  DCbackupenv
           Backup the environment and service configurations
           This API is only supported on HMC
    Arguments:
           NONE
    Returns:
        0:        successful
        non-zero: failed
    Globals:
        $::VERBOSE

    Error:
        see returns

    Example:
        DCAPI->DCbackupenv();
    Comments:
        This API will gather status and configurations of service 
    NFS, TFTP and nimol_bootreplyd (bootp), and will put them in 
    a directory named 'precsmenv'  under /var/opt/csm/. 
    DCrestoreenv will use this file to recover environment. 
    
    This API is only supported on HMC.
    Note: If /var/opt/csm/precsm directory has already existed, 
          this API will overwrite it.


=cut

#--------------------------------------------------------------------------------
sub DCbackupenv
{
    my $routine = "DCbackupenv";
    print "ENTERING: $routine\n" if $::DEBUG;
    # Declare overridden built-in routine.
    # Note: use "local" to make sure recover built-in routine when exiting from API itself.
    # If DCAPI is called nested, built-in overridden is declared many times,
    #   it maybe brings potential performance issues. 
    # But CSM only call DCAPI at most nested by two layers in codes, 
    #   it is safe right now. 
    local *CORE::GLOBAL::exit;
    # Override the built-in exit with our version.
    # This override exit will not be valid after exiting from the outermost DCAPI.
    *CORE::GLOBAL::exit = \&DCUtils::__CSM_exit;
    
    local *CORE::GLOBAL::die;
    # Override the built-in die with our version.
    # This override die will not be valid after exiting from the outermost DCAPI.
    *CORE::GLOBAL::die = \&DCUtils::__CSM_die;
	my $un_set=0;  

	if(!$ENV{'DC_ENVIRONMENT'})
	{
    	$ENV{'DC_ENVIRONMENT'}=1;
		$un_set=1;
	}		
    else
    {
        # Register exit point if DC environment
        if (  (!$::__DC_RETURN_ANCHOR)
           && ($ENV{'DC_ENVIRONMENT'} ne 'CSM')
        )
        {

            # Set return flag label
            $::__DC_RETURN_ANCHOR = 'DCbackupenv_exit';
            # Set current process pid
            $::__DC_PID = $$;
        }
    }
    my $logfile = $::__CLUSTER_INFO_HASH{'logfile_DCbackupenv'};
    if (!$logfile)
    {
        $logfile = '/var/log/csm/DCbackupenv.log';
    }
    DCUtils->start_logging($logfile);
    if (! NodeUtils->isHMC())
    {
        return $::NOK;
    }
    # Get backup directory
    my $backup_dir;
    if (! $::__CLUSTER_INFO_HASH{'backup_dir'})
    {
        $backup_dir = $::DEFAULT_DCBACKUP_DIR;
    }
    else
    {
        $backup_dir = $::__CLUSTER_INFO_HASH{'backup_dir'}
    }
    # Create directory in case it doesn't exist
    mkpath($backup_dir, $::VERBOSE, 0755);
    # Clean up precsmenv config file
    if (-e "$backup_dir/precsm.conf")
    {
        MessageUtils->messageFromCat('csmInstall.cat', $MSGMAPPATH,
                                     'csminstall', 'L', 'IMsgShow_Output', "Warning: $backup_dir/precsm.conf exists. In normal situation, it should be removed by DCrestoreenv");   
    }
    NodeUtils->runcmd("$::RM -f $backup_dir/precsm.conf");
    my $rc = 0;
    # Backup tftp service and related configurations.
    $rc |= DCUtils->backupTFTP($backup_dir);
    # Backup nimol_bootpreplyd daemon
    $rc |= DCUtils->backupBOOTP($backup_dir);
    # Backup mfs server
    $rc |= DCUtils->backupNFS($backup_dir);

# DCbackupenv exit label
DCbackupenv_exit:
    $rc |= DCUtils->checkDCRetCode('DCbackupenv_exit');
    DCUtils->stop_logging($::__CLUSTER_INFO_HASH{'logfile_DCbackupenv'});
	if($un_set)  
	{
    	undef $ENV{'DC_ENVIRONMENT'};
	}
    return $rc;    
}

#--------------------------------------------------------------------------------

=head3  DCrestoreenv
           Restore the environment and service configurations
           This API is only supported on HMC platform.
    Arguments:
           NONE
    Returns:
        0:        successful
        non-zero: failed
    Globals:
        $::VERBOSE

    Error:
        see returns

    Example:
        DCAPI->DCrestoreenv();
    Comments:
        This API will read original service status and configurations
    from the directory /var/opt/csm/precsmenv in default and recover
    them as before DCbackupenv invoked.
    Right now, this API can restore TFTP, NFS, BOOTP services.


=cut

#--------------------------------------------------------------------------------
sub DCrestoreenv
{
    my $routine = "DCrestoreenv";
    print "ENTERING: $routine\n" if $::DEBUG;
    # Declare overridden built-in routine.
    # Note: use "local" to make sure recover built-in routine when exiting from API itself.
    # If DCAPI is called nested, built-in overridden is declared many times,
    #   it maybe brings potential performance issues. 
    # But CSM only call DCAPI at most nested by two layers in codes, 
    #   it is safe right now. 
    local *CORE::GLOBAL::exit;
    # Override the built-in exit with our version.
    # This override exit will not be valid after exiting from the outermost DCAPI.
    *CORE::GLOBAL::exit = \&DCUtils::__CSM_exit;
    
    local *CORE::GLOBAL::die;
    # Override the built-in die with our version.
    # This override die will not be valid after exiting from the outermost DCAPI.
    *CORE::GLOBAL::die = \&DCUtils::__CSM_die;
	my $un_set=0;  

	if(!$ENV{'DC_ENVIRONMENT'})
	{
    	$ENV{'DC_ENVIRONMENT'}=1;
		$un_set=1;
	}		
    else
    {
        # Register exit point if DC environment
        if (  (!$::__DC_RETURN_ANCHOR)
           && ($ENV{'DC_ENVIRONMENT'} ne 'CSM')
        )
        {

            # Set return flag label
            $::__DC_RETURN_ANCHOR = 'DCrestoreenv_exit';
            # Set current process pid
            $::__DC_PID = $$;
        }
    }
    my $logfile = $::__CLUSTER_INFO_HASH{'logfile_DCrestoreenv'};
    if (! $logfile)
    {
        $logfile = '/var/log/csm/DCrestoreenv.log';
    }
    DCUtils->start_logging($logfile);
    if (! NodeUtils->isHMC())
    {
        return $::NOK;
    }
    # Get backup directory
    my $backup_dir;
    if (! $::__CLUSTER_INFO_HASH{'backup_dir'})
    {
        $backup_dir = $::DEFAULT_DCBACKUP_DIR;
    }
    else
    {
        $backup_dir = $::__CLUSTER_INFO_HASH{'backup_dir'}
    }
    my $precsm_conf = undef;
    if (-e "$backup_dir/precsm.conf")
    {
        $precsm_conf = NodeUtils->get_config("$backup_dir/precsm.conf");
    }
    my $rc = 0;
    # Resotre nimol_bootpreplyd daemon status
    $rc |= DCUtils->restoreBOOTP($backup_dir, $precsm_conf);
    # Restore tftp service
    $rc |= DCUtils->restoreTFTP($backup_dir, $precsm_conf);
    # Restore nfs service
    $rc |= DCUtils->restoreNFS($backup_dir, $precsm_conf);
    # Remove precsm.conf
    unlink "$backup_dir/precsm.conf";
    #if (-d $backup_dir)
    #{
    #    NodeUtils->runcmd("$::RM -rf $backup_dir/*");
    #}   
# DCrestoreenv exit label
DCrestoreenv_exit:
    $rc |= DCUtils->checkDCRetCode('DCrestoreenv_exit');
    DCUtils->stop_logging($::__CLUSTER_INFO_HASH{'logfile_DCrestoreenv'});
	if($un_set)  
	{
    	undef $ENV{'DC_ENVIRONMENT'};
	}
    return $rc;    
}
1;
