#!/bin/awk -f
# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2006,2008 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 

# @(#)02   1.1   src/csm/install/noderpminstallstatus.awk, setup, csm_rgar2h, rgar2hs001a 12/11/06 01:45:19
# This script allows you to get the realtime status on the node while it is
# installing.  There is a "pre" script inside the kickstart and autoyast config
# file that listens on the 3001 port for requests.  The available requests
# are "stat" and "sh".  The "stat" request is for displaying current install
# status (which rpm is currently being installed).  The "sh" request is for
# running a shell command on the node.
#
# Usage:
#      nodertstat.cmd <hostname> <port>
# The <command> must be enclosed in quotes if it has spaces or special chars
#
BEGIN {
	node = ARGV[1]
	port = ARGV[2] 
	ns = "/inet/tcp/0/" node "/" port

	print "stat" |& ns

	while((ns |& getline) > 0)
		print $0

	close(ns)

	exit 0
}

