# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2003,2008 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
#
#
# @(#)68   1.14.1.10   src/csm/install/pkgdefs/AIX-5.1.0.pm.perl, setup, csm_rgar2h, rgar2hs001a 4/14/06 03:52:16

#--------------------------------------------------------------------------------

=head3  AIX-5.1.0.pm.perl

        Package Definition File:  AIX 5.1.0

        Notes:

        The following global variables must be initalized before including
        this file:

                $::mgmt_type    = [MgmtServer | MgdNode ]
                $::csm_version  = [1.3.0 | 1.3.1 | 1.3.2 | ... ]


        EXCEPTIONS:
        This file has been rewritten for csm 1.3.4 to rely on default values
        with support for release-specific exceptions.  This makes it much
        simpler to maintain the package defs across releases.

	The approach uses $::csm_version to set default values for both server and
	node defines.  It allows for execptions to these default values by defining
	specific csm versions assignments which overwrite the defaults when
	$::csm_version is equal to the execption's version number.

	ORDER IS IMPORTANT:
	As noted in the code, any excptions must follow the default assignments,
	otherwise the execption assignment will be overwriten by the default.

=cut

#--------------------------------------------------------------------------------

# houskeeping

package AIX510;

do "/opt/csm/install/pkgdefs/AIX.pm";

my $_server_  = 'MgmtServer';
my $_node_    = 'MgdNode';
my $_iserver_ = 'InstallServer';

MessageUtils->messageFromCat(
							 'csmInstall.cat',
							 $::MSGMAPPATH,
							 'csminstall',
							 'V',
							 'IMsgLoading',
							 "/opt/csm/install/pkgdefs/AIX-5.1.0.pm"
							);

#--------------------------------------------------------------------------------

=head3	opensrc_prereqs - Open Source Prereqs to Install

	Notes :

=cut

#--------------------------------------------------------------------------------
{
	my %op_ref;

	# DEFAULTS
	$op_ref{'MgmtServer'}{$::csm_version} = [];
	$op_ref{'InstallServer'}              = [];
	$op_ref{'MgdNode'}{$::csm_version}    = [];

	# EXCEPTIONS  - must follow the default assignments.
	# none

	$::pkgdefs{opensrc_prereqs} = $op_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	opensrc_prereqs_optional - Open Source Prereqs optional

	Notes :

=cut

#--------------------------------------------------------------------------------
{
	my %op_ref;

	# DEFAULTS
	$op_ref{'MgmtServer'}{$::csm_version} = [];
	$op_ref{'InstallServer'}              = [];
	$op_ref{'MgdNode'}{$::csm_version}    = [];

	# EXCEPTIONS  - must follow the default assignments.
	# none

	$::pkgdefs{opensrc_prereqs_optional} =
	  $op_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	rsct_packages - RSCT Packages to Install

        Notes:

=cut

#--------------------------------------------------------------------------------
{
	my %rp_ref;

	# DEFAULTS
	$rp_ref{'MgmtServer'}{$::csm_version} = [];
	$rp_ref{'InstallServer'}              = [];
	$rp_ref{'MgdNode'}{$::csm_version}    = [];

	# EXCEPTIONS  - must follow the default assignments.
	# none

	$::pkgdefs{rsct_packages} = $rp_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	csm_packages - CSM Packages to Install

        Notes:

=cut

#--------------------------------------------------------------------------------
{
	my %cp_ref;

	# DEFAULTS
	$cp_ref{'MgmtServer'}{$::csm_version}    = [];
	$cp_ref{'InstallServer'}{$::csm_version} = [];
	$cp_ref{'MgdNode'}{$::csm_version}       =
	  ['csm.core*', 'csm.client*', 'csm.diagnostics*'];

	# EXCEPTIONS  - must follow the default assignments.
	# none

	$::pkgdefs{csm_packages} = $cp_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	rsct_unpackages - RSCT Packages to uninstall

        Notes:

=cut

#--------------------------------------------------------------------------------
{
	my %rup_ref;

	# DEFAULTS
	$rup_ref{'MgmtServer'}{$::csm_version}    = [];
	$rup_ref{'InstallServer'}{$::csm_version} = [];
	$rup_ref{'MgdNode'}{$::csm_version}       = [];

	# EXCEPTIONS  - must follow the default assignments.
	# none

	$::pkgdefs{rsct_unpackages} = $rup_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	csm_unpackages - CSM Packages to uninstall	

        Notes:

=cut

#--------------------------------------------------------------------------------
{
	my %cu_ref;

	# DEFAULTS
	$cu_ref{'MgmtServer'}{$::csm_version} =
	  ['csm.essl', 'csm.gpfs', 'csm.ll', 'csm.pe', 'csm.pessl'];
	$cu_ref{'InstallServer'}{$::csm_version} = [];
	$cu_ref{'MgdNode'}{$::csm_version}       = [];

	# EXCEPTIONS  - must follow the default assignments.
	# none

	$::pkgdefs{csm_unpackages} = $cu_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	csm_uninstall_dirs - Directories to uninstall from the management server

        Notes:

=cut

#--------------------------------------------------------------------------------
{
	my %cud_ref;

	# DEFAULTS
	$cud_ref{'MgmtServer'}{$::csm_version}    = [];
	$cud_ref{'InstallServer'}{$::csm_version} = [];
	$cud_ref{'MgdNode'}{$::csm_version}       = [];

	# EXCEPTIONS  - must follow the default assignments.
	# none

	$::pkgdefs{csm_uninstall_dirs} = $cud_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	csm_nouninstall_pkgs - Packages to NOT uninstall

        Notes:

=cut

#--------------------------------------------------------------------------------
{
	my %cnp_ref;

	# DEFAULTS
	$cnp_ref{'MgmtServer'}{$::csm_version}    = [];
	$cnp_ref{'InstallServer'}{$::csm_version} = [];
	$cnp_ref{'MgdNode'}{$::csm_version}       = ['csm.core', 'csm.client'];

	# EXCEPTIONS  - must follow the default assignments.
	# none

	$::pkgdefs{csm_nouninstall_pkgs} = $cnp_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	os_prereqs - Operating System pre-requisites

        Notes:

=cut

#--------------------------------------------------------------------------------
{
	my %op_ref;

	$op_ref{'MgmtServer'}    = [];
	$op_ref{'InstallServer'} = [];
	$op_ref{'MgdNode'}       = [];

	$::pkgdefs{os_prereqs} = $op_ref{$::mgmt_type};
}

#--------------------------------------------------------------------------------
{

	# DEFAULT
	my $a_ref = [
				 # files
				 '/opt/csm/csmbin/updatenode.client',
				 '/opt/csm/csmbin/write_status',
				 '/opt/csm/msgmaps/csmInstall.csminstall.map',
				 '/opt/csm/pm/MessageUtils.pm',
				 '/opt/csm/pm/NodeUtils.pm',
				 '/opt/csm/pm/ApacheUtils.pm',
				 '/opt/csm/pm/ArchiveUtils.pm',
				 '/opt/csm/pm/InstallKRB5Utils.pm',
				 '/opt/csm/msgmaps/csmKRB5p.csmKRB5p_msg.map',
				 '/opt/csm/pm/NetworkUtils.pm',
				 '/opt/csm/pm/ServerUtils.pm',
				 '/opt/csm/pm/CSMDefs.pm',
				 '/opt/csm/msgmaps/nodecmds.NodeUtils.map',
				 '/opt/csm/csmbin/rmnode_client',
				 '/opt/csm/bin/setupconsole',
				 '/opt/csm/csmbin/makenode',
				 '/opt/csm/csmbin/csmprereboot',
				 '/opt/csm/csmbin/csmfirstboot',
				 '/opt/csm/csmbin/osfirstboot',

				 # directories
				 '/opt/csm/install/defs',
				 '/opt/csm/install/pkgdefs',
				 '/opt/csm/pm/Rpm'
				];
	my $b_ref = [
				 # files
				 '/opt/csm/csmbin/nodestatus.client',
				 '/opt/csm/csmbin/nodestat.awk',
				 '/opt/csm/csmbin/syncServers.client',
				 '/opt/csm/csmbin/updateRDMdserver',
				 '/opt/csm/csmbin/get_RDMdserver_config',
				 '/opt/csm/csmbin/write_status',
				 '/opt/csm/msgmaps/csmInstall.csminstall.map',
				 '/opt/csm/pm/MessageUtils.pm',
				 '/opt/csm/pm/NodeUtils.pm',
				 '/opt/csm/pm/ApacheUtils.pm',
				 '/opt/csm/pm/ArchiveUtils.pm',
				 '/opt/csm/pm/InstallKRB5Utils.pm',
				 '/opt/csm/msgmaps/csmKRB5p.csmKRB5p_msg.map',
				 '/opt/csm/pm/NetworkUtils.pm',
				 '/opt/csm/pm/ServerUtils.pm',
				 '/opt/csm/pm/CSMDefs.pm',
				 '/opt/csm/msgmaps/nodecmds.NodeUtils.map',
				 '/opt/csm/csmbin/rmnode_client',
				 '/opt/csm/bin/setupconsole',
				 '/opt/csm/csmbin/csmprereboot',
				 '/opt/csm/csmbin/csmfirstboot',
				 '/opt/csm/csmbin/osfirstboot',
				 '/opt/csm/csmbin/setbootdisk',

				 # directories
				 '/opt/csm/install/defs',
				 '/opt/csm/install/pkgdefs',
				 '/opt/csm/pm/Rpm'
				];
	if (!defined($ENV{'DC_ENVIRONMENT'}) || $ENV{'DC_ENVIRONMENT'} eq "CSM")
	{
		$::pkgdefs{csm_bin_copy_csm} = $a_ref;
	}
	else
	{
		$::pkgdefs{csm_bin_copy_csm} = $b_ref;
	}

}

#-------------------------------------------------------------------------------

=head3	gpl_packages

        Notes:	List of GPL packages that are required on this platform.
		These are the packages for which a license agreement must
		be displayed.

=cut

#-------------------------------------------------------------------------------
{
	my $gpl_ref = [];

	$::pkgdefs{gpl_packages} = $gpl_ref;
}

#-------------------------------------------------------------------------------

1;    # end
