# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2003,2008 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
#
#
# @(#)59   1.33.1.50   src/csm/install/pkgdefs/Linux-RedHatEL-ES3.pm.perl, setup, csm_rgar2h, rgar2hs001a 4/10/06 01:14:02

#--------------------------------------------------------------------------------

=head3	Linux-RedHatEL-ES3.pm.perl

        Package Definition File:    RedHatEL 3

        Notes:

        The following global variables must be initalized before including
        this file:

                $::mgmt_type    = [ MgmtServer | MgdNode ]
                $::csm_version  = [ 1.3.0 | 1.3.1 | 1.3.2 | ... ]


        exceptionns:
        This file has been rewritten for csm 1.3.4 to rely on default values
        with support for release-specific exceptions.  This makes it much
        simpler to maintain the package defs across releases.

	The approach uses $::csm_version to set default values for both server and
	node defines.  It allows for execptions to these default values by defining
	specific csm versions assignments which overwrite the defaults when
	$::csm_version is equal to the execption's version number.

	ORDER IS IMPORTANT:
	As noted in the code, any excptions must follow the default assignments,

	OTHER DOCUMENTATION - see pkgdefs/Linux.pm

=cut

#--------------------------------------------------------------------------------

# houskeeping

package RedHatELES3;

#do "/opt/csm/install/pkgdefs/Linux.pm";
my $progdir = $0;
$progdir =~ s/\/[^\/]*$/\//g;
if (-e "$progdir/pkgdefs/Linux-RedHatEL3.pm")
{
	do "$progdir/pkgdefs/Linux-RedHatEL3.pm";
}
else
{
	do "/opt/csm/install/pkgdefs/Linux-RedHatEL3.pm";
}

MessageUtils->messageFromCat(
							 'csmInstall.cat',
							 $::MSGMAPPATH,
							 'csminstall',
							 'V',
							 'IMsgLoading',
							 "/opt/csm/install/pkgdefs/Linux-RedHatEL-ES3.pm"
							);

my $_server_  = 'MgmtServer';
my $_node_    = 'MgdNode';
my $_iserver_ = 'InstallServer';
$::pkgdefs{'where_supported'} = ['MgdNode'];

#--------------------------------------------------------------------------------

=head3	DISTRO Defintions

	Notes :

=cut

#--------------------------------------------------------------------------------
{

	$::pkgdefs{DISTRO_NAME} = "Red Hat Enterprise Linux ES 3";
	$::pkgdefs{DISTRO_DISKLIST} = "1 2 3 4";       # TO BE REMOVED
	$::pkgdefs{DISTRO_RPMDIR}   = "RedHat/RPMS";

}

#--------------------------------------------------------------------------------

=head3  distro_disks - Distribution Disk Defines

        Distribution Disk descriptions used to prompt for the CD-ROMs
        during installation.

        One stanza per CDROM:

                num                     = the number on the CD-ROM's label
                name                    = the text string describing the CD-ROM
                diskid_filename         = the filename to search to identify the disk
                                          - supportsw shell wildcards.
                diskid_searchstring     = the string to search for in diskid_filename
                                          - supports perl regular expressions


=cut

#--------------------------------------------------------------------------------
{
	my $dd_ref = [
		{
		 num               => '1',
		 name              => $::pkgdefs{DISTRO_NAME},
		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '1',
							   arch => 'i386',
							   key  => '1065565780.808209',
							   rpm  => 'SRPMS/comps-3es-0.20031007.src.rpm',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-ES3-i386',
		},
		{
		 num               => '2',
		 name              => $::pkgdefs{DISTRO_NAME},
		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '2',
							   arch => 'i386',
							   key  => '1065565780.808209',
							   rpm  => '',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-ES3-i386',
		},
		{
		 num  => '3',
		 name => $::pkgdefs{DISTRO_NAME},

		 #diskid_filename     => '.discinfo',
		 #diskid_searchstring => '^3$',
		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '3',
							   arch => 'i386',
							   key  => '1065565780.808209',
							   rpm  => '',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-ES3-i386',
		},
		{
		 num               => '4',
		 name              => $::pkgdefs{DISTRO_NAME},
		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '4',
							   arch => 'i386',
							   key  => '1065565780.808209',
							   rpm  => '',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-ES3-i386',
		}
	];

	$::pkgdefs{distro_disks} = $dd_ref;
}

#--------------------------------------------------------------------------------

=head3	Service Pack disks defination

        Notes:

=cut

#--------------------------------------------------------------------------------
{
	my $qu1_ref = [
		{
		 num               => '1',
		 name              => $::pkgdefs{DISTRO_NAME} . " QU1",
		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '1',
							   arch => 'i386',
							   key  => '1065565780.808209',
							   rpm  => 'RedHat/Updates/redhat-release-3ES*',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-ES3-QU1',
		},
		{
		 num               => '2',
		 name              => $::pkgdefs{DISTRO_NAME} . " QU1",
		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '2',
							   arch => 'i386',
							   key  => '1065565780.808209',
							   rpm  => '',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-ES3-QU1',
		},
		{
		 num  => '3',
		 name => $::pkgdefs{DISTRO_NAME} . " QU1",

		 #diskid_filename     => '.discinfo',
		 #diskid_searchstring => '^3$',
		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '3',
							   arch => 'i386',
							   key  => '1065565780.808209',
							   rpm  => '',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-ES3-QU1',
		},
		{
		 num               => '4',
		 name              => $::pkgdefs{DISTRO_NAME} . " QU1",
		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '4',
							   arch => 'i386',
							   key  => '1065565780.808209',
							   rpm  => '',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-ES3-QU1',
		}
	];

	$::pkgdefs{sp_disks}{QU1} = $qu1_ref;
}

#--------------------------------------------------------------------------------

{
	my $qu2_ref = [
				   {
					num               => '1',
					name              => $::pkgdefs{DISTRO_NAME} . " QU2",
					diskid_searchargs => {
									file => '.discinfo',
									num  => '1',
									arch => 'i386',
									key  => '1083794425.140447',
									rpm => 'SRPMS/comps-3ES-0.20040505.src.rpm',
					},
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-ES3-QU2',
				   },
				   {
					num               => '2',
					name              => $::pkgdefs{DISTRO_NAME} . " QU2",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '2',
										  key  => '1083794425.140447',
										  arch => 'i386',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-ES3-QU2',
				   },
				   {
					num               => '3',
					name              => $::pkgdefs{DISTRO_NAME} . " QU2",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '3',
										  key  => '1083794425.140447',
										  arch => 'i386',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-ES3-QU2',
				   },
				   {
					num               => '4',
					name              => $::pkgdefs{DISTRO_NAME} . " QU2",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '4',
										  key  => '1083794425.140447',
										  arch => 'i386',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-ES3-QU2',
				   }
				  ];

	$::pkgdefs{sp_disks}{QU2} = $qu2_ref;
}

#--------------------------------------------------------------------------------

{
	my $qu3_ref = [
				   {
					num               => '1',
					name              => $::pkgdefs{DISTRO_NAME} . " QU3",
					diskid_searchargs => {
									file => '.discinfo',
									num  => '1',
									arch => 'i386',
									key  => '1094154388.137024',
									rpm => 'SRPMS/comps-3ES-0.20040902.src.rpm',
					},
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-ES3-QU3',
				   },
				   {
					num               => '2',
					name              => $::pkgdefs{DISTRO_NAME} . " QU3",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '2',
										  key  => '1094154388.137024',
										  arch => 'i386',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-ES3-QU3',
				   },
				   {
					num               => '3',
					name              => $::pkgdefs{DISTRO_NAME} . " QU3",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '3',
										  key  => '1094154388.137024',
										  arch => 'i386',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-ES3-QU3',
				   },
				   {
					num               => '4',
					name              => $::pkgdefs{DISTRO_NAME} . " QU3",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '4',
										  key  => '1094154388.137024',
										  arch => 'i386',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-ES3-QU3',
				   }
				  ];

	$::pkgdefs{sp_disks}{QU3} = $qu3_ref;
}

#--------------------------------------------------------------------------------

{
	my $qu4_ref = [
				   {
					num               => '1',
					name              => $::pkgdefs{DISTRO_NAME} . " QU4",
					diskid_searchargs => {
									file => '.discinfo',
									num  => '1',
									arch => 'i386',
									key  => '103224706.300559',
									rpm => 'SRPMS/comps-3ES-0.20041216.src.rpm',
					},
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-ES3-QU4',
				   },
				   {
					num               => '2',
					name              => $::pkgdefs{DISTRO_NAME} . " QU4",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '2',
										  key  => '103224706.300559',
										  arch => 'i386',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-ES3-QU4',
				   },
				   {
					num               => '3',
					name              => $::pkgdefs{DISTRO_NAME} . " QU4",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '3',
										  key  => '103224706.300559',
										  arch => 'i386',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-ES3-QU4',
				   },
				   {
					num               => '4',
					name              => $::pkgdefs{DISTRO_NAME} . " QU4",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '4',
										  key  => '103224706.300559',
										  arch => 'i386',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-ES3-QU4',
				   }
				  ];

	$::pkgdefs{sp_disks}{QU4} = $qu4_ref;
}

#--------------------------------------------------------------------------------

{
	my $qu5_ref = [
				   {
					num               => '1',
					name              => $::pkgdefs{DISTRO_NAME} . " QU5",
					diskid_searchargs => {
									file => '.discinfo',
									num  => '1',
									arch => 'i386',
									key  => '1115874580.003298',
									rpm => 'SRPMS/comps-3ES-0.20050512.src.rpm',
					},
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-ES3-QU5',
				   },
				   {
					num               => '2',
					name              => $::pkgdefs{DISTRO_NAME} . " QU5",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '2',
										  key  => '1115874580.003298',
										  arch => 'i386',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-ES3-QU5',
				   },
				   {
					num               => '3',
					name              => $::pkgdefs{DISTRO_NAME} . " QU5",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '3',
										  key  => '1115874580.003298',
										  arch => 'i386',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-ES3-QU5',
				   },
				   {
					num               => '4',
					name              => $::pkgdefs{DISTRO_NAME} . " QU5",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '4',
										  key  => '1115874580.003298',
										  arch => 'i386',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-ES3-QU5',
				   }
				  ];

	$::pkgdefs{sp_disks}{QU5} = $qu5_ref;
}

#--------------------------------------------------------------------------------

{
	my $qu6_ref = [
				   {
					num               => '1',
					name              => $::pkgdefs{DISTRO_NAME} . " QU6",
					diskid_searchargs => {
									file => '.discinfo',
									num  => '1',
									arch => 'i386',
									key  => '1127323691.616555',
									rpm => 'SRPMS/comps-3ES-0.20050921.src.rpm',
					},
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-ES3-QU6',
				   },
				   {
					num               => '2',
					name              => $::pkgdefs{DISTRO_NAME} . " QU6",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '2',
										  key  => '1127323691.616555',
										  arch => 'i386',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-ES3-QU6',
				   },
				   {
					num               => '3',
					name              => $::pkgdefs{DISTRO_NAME} . " QU6",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '3',
										  key  => '1127323691.616555',
										  arch => 'i386',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-ES3-QU6',
				   },
				   {
					num               => '4',
					name              => $::pkgdefs{DISTRO_NAME} . " QU6",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '4',
										  key  => '1127323691.616555',
										  arch => 'i386',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-ES3-QU6',
				   }
				  ];

	$::pkgdefs{sp_disks}{QU6} = $qu6_ref;
}
#--------------------------------------------------------------------------------

{
	my $qu7_ref = [
				   {
					num               => '1',
					name              => $::pkgdefs{DISTRO_NAME} . " QU7",
					diskid_searchargs => {
									file => '.discinfo',
									num  => '1',
									arch => 'i386',
									key  => '1141679045.364586',
									rpm => 'SRPMS/comps-3ES-0.20060306.src.rpm',
					},
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-ES3-QU7',
				   },
				   {
					num               => '2',
					name              => $::pkgdefs{DISTRO_NAME} . " QU7",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '2',
										  key  => '1141679045.364586',
										  arch => 'i386',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-ES3-QU7',
				   },
				   {
					num               => '3',
					name              => $::pkgdefs{DISTRO_NAME} . " QU7",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '3',
										  key  => '1141679045.364586',
										  arch => 'i386',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-ES3-QU7',
				   },
				   {
					num               => '4',
					name              => $::pkgdefs{DISTRO_NAME} . " QU7",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '4',
										  key  => '1141679045.364586',
										  arch => 'i386',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-ES3-QU7',
				   }
				  ];

	$::pkgdefs{sp_disks}{QU7} = $qu7_ref;
}

1;    # end
