# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2004,2008 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
#
# @(#)73   1.25.1.13   src/csm/install/pkgdefs/Linux-RedHatEL-WS4-x86_64.pm.perl, setup, csm_rgar2h, rgar2hs001a 8/25/06 05:10:25
#--------------------------------------------------------------------------------

=head3	Linux-RedHatEL-WS4-x86_64.pm.perl

        Package Definition File:     RedHatEL 4

        Notes:  - no server support for WS distros.

        The following global variables must be initalized before including
        this file:

                $::mgmt_type    = [ MgmtServer | MgdNode ]
                $::csm_version  = [ 1.3.0 | 1.3.1 | 1.3.2 | ... ]


        exceptions:
        This file has been rewritten for csm 1.3.4 to rely on default values
        with support for release-specific exceptions.  This makes it much
        simpler to maintain the package defs across releases.

	The approach uses $::csm_version to set default values for both server and
	node defines.  It allows for execptions to these default values by defining
	specific csm versions assignments which overwrite the defaults when
	$::csm_version is equal to the execption's version number.

	ORDER IS IMPORTANT:
	As noted in the code, any excptions must follow the default assignments,
	otherwise the execption assignment will be overwriten by the default.

	OTHER DOCUMENTATION - see pkgdefs/Linux.pm

=cut

#--------------------------------------------------------------------------------

# houskeeping

package RedHatELWS4;

my $progdir = $0;
$progdir =~ s/\/[^\/]*$/\//g;
if (-e "$progdir/pkgdefs/Linux-RedHatEL4-x86_64.pm")
{
	do "$progdir/pkgdefs/Linux-RedHatEL4-x86_64.pm";
}
else
{
	do "/opt/csm/install/pkgdefs/Linux-RedHatEL4-x86_64.pm";
}

MessageUtils->messageFromCat(
						 'csmInstall.cat',
						 $::MSGMAPPATH,
						 'csminstall',
						 'V',
						 'IMsgLoading',
						 "/opt/csm/install/pkgdefs/Linux-RedHatEL-WS4-x86_64.pm"
);

my $_server_  = 'MgmtServer';
my $_node_    = 'MgdNode';
my $_iserver_ = 'InstallServer';
$::pkgdefs{'where_supported'} = ['MgdNode'];

#--------------------------------------------------------------------------------

=head3	DISTRO Defintions

	Notes :

=cut

#--------------------------------------------------------------------------------
{

	$::pkgdefs{DISTRO_NAME} = "Red Hat Enterprise Linux WS 4 x86_64";
	$::pkgdefs{DISTRO_DISKLIST} = "1 2 3 4 5";     # TO BE REMOVED
	$::pkgdefs{DISTRO_RPMDIR}   = "RedHat/RPMS";

}

#--------------------------------------------------------------------------------

=head3  distro_disks - Distribution Disk Defines

        Distribution Disk descriptions used to prompt for the CD-ROMs
        during installation.

        One stanza per CDROM:

                num                     = the number on the CD-ROM's label
                name                    = the text string describing the CD-ROM
                diskid_filename         = the filename to search to identify the disk
                                          - supportsw shell wildcards.
                diskid_searchstring     = the string to search for in diskid_filename
                                          - supports perl regular expressions


=cut

#--------------------------------------------------------------------------------
{
	my $dd_ref = [
				  {
				   num               => '1',
				   name              => $::pkgdefs{DISTRO_NAME},
				   diskid_searchargs => {
									   file => '.discinfo',
									   num  => '1',
									   arch => 'x86_64',
									   key  => '1105117716.138343',
									   rpm => 'RedHat/RPMS/redhat-release-4WS*',
				   },
				   diskid_searchprog => \&Linux::rhel_diskid_match_prog,
				   diskid_target     => 'RedHatEL-WS4-x86_64',
				  },
				  {
				   num               => '2',
				   name              => $::pkgdefs{DISTRO_NAME},
				   diskid_searchargs => {
										 file => '.discinfo',
										 num  => '2',
										 arch => 'x86_64',
										 key  => '1105117716.138343',
										 rpm  => '',
										},
				   diskid_searchprog => \&Linux::rhel_diskid_match_prog,
				   diskid_target     => 'RedHatEL-WS4-x86_64',
				  },
				  {
				   num               => '3',
				   name              => $::pkgdefs{DISTRO_NAME},
				   diskid_searchargs => {
										 file => '.discinfo',
										 num  => '3',
										 arch => 'x86_64',
										 key  => '1105117716.138343',
										 rpm  => '',
										},
				   diskid_searchprog => \&Linux::rhel_diskid_match_prog,
				   diskid_target     => 'RedHatEL-WS4-x86_64',
				  },
				  {
				   num               => '4',
				   name              => $::pkgdefs{DISTRO_NAME},
				   diskid_searchargs => {
										 file => '.discinfo',
										 num  => '4',
										 arch => 'x86_64',
										 key  => '1105117716.138343',
										 rpm  => '',
										},
				   diskid_searchprog => \&Linux::rhel_diskid_match_prog,
				   diskid_target     => 'RedHatEL-WS4-x86_64',
				  },
				  {
				   num               => '5',
				   name              => $::pkgdefs{DISTRO_NAME},
				   diskid_searchargs => {
										 file => '.discinfo',
										 num  => '5',
										 arch => 'x86_64',
										 key  => '1105117716.138343',
										 rpm  => '',
										},
				   diskid_searchprog => \&Linux::rhel_diskid_match_prog,
				   diskid_target     => 'RedHatEL-WS4-x86_64',
				  }
				 ];

	$::pkgdefs{distro_disks} = $dd_ref;
}

#--------------------------------------------------------------------------------
{
	my $qu1_ref = [
				   {
					num               => '1',
					name              => $::pkgdefs{DISTRO_NAME} . " QU1",
					diskid_searchargs => {
									   file => '.discinfo',
									   num  => '1',
									   arch => 'x86_64',
									   key  => '1117037693.576233',
									   rpm => 'RedHat/RPMS/redhat-release-4WS*',
					},
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-WS4-QU1',
				   },
				   {
					num               => '2',
					name              => $::pkgdefs{DISTRO_NAME} . " QU1",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '2',
										  arch => 'x86_64',
										  key  => '1117037693.576233',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-WS4-QU1',
				   },
				   {
					num               => '3',
					name              => $::pkgdefs{DISTRO_NAME} . " QU1",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '3',
										  arch => 'x86_64',
										  key  => '1117037693.576233',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-WS4-QU1',
				   },
				   {
					num               => '4',
					name              => $::pkgdefs{DISTRO_NAME} . " QU1",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '4',
										  arch => 'x86_64',
										  key  => '1117037693.576233',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-WS4-QU1',
				   },
				   {
					num               => '5',
					name              => $::pkgdefs{DISTRO_NAME} . " QU1",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '5',
										  arch => 'x86_64',
										  key  => '1117037693.576233',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-WS4-QU1',
				   }
				  ];

	$::pkgdefs{sp_disks}{QU1} = $qu1_ref;
}

#--------------------------------------------------------------------------------
{
	my $qu2_ref = [
				   {
					num               => '1',
					name              => $::pkgdefs{DISTRO_NAME} . " QU2",
					diskid_searchargs => {
									   file => '.discinfo',
									   num  => '1',
									   arch => 'x86_64',
									   key  => '1128193362.766911',
									   rpm => 'RedHat/RPMS/redhat-release-4WS*',
					},
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-WS4-QU2',
				   },
				   {
					num               => '2',
					name              => $::pkgdefs{DISTRO_NAME} . " QU2",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '2',
										  arch => 'x86_64',
										  key  => '1128193362.766911',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-WS4-QU2',
				   },
				   {
					num               => '3',
					name              => $::pkgdefs{DISTRO_NAME} . " QU2",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '3',
										  arch => 'x86_64',
										  key  => '1128193362.766911',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-WS4-QU2',
				   },
				   {
					num               => '4',
					name              => $::pkgdefs{DISTRO_NAME} . " QU2",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '4',
										  arch => 'x86_64',
										  key  => '1128193362.766911',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-WS4-QU2',
				   },
				   {
					num               => '5',
					name              => $::pkgdefs{DISTRO_NAME} . " QU2",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '5',
										  arch => 'x86_64',
										  key  => '1128193362.766911',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-WS4-QU2',
				   }
				  ];

	$::pkgdefs{sp_disks}{QU2} = $qu2_ref;
}
#--------------------------------------------------------------------------------
{
	my $qu3_ref = [
				   {
					num               => '1',
					name              => $::pkgdefs{DISTRO_NAME} . " QU3",
					diskid_searchargs => {
									   file => '.discinfo',
									   num  => '1',
									   arch => 'x86_64',
									   key  => '1141419065.978713',
									   rpm => 'RedHat/RPMS/redhat-release-4WS*',
					},
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-WS4-QU3',
				   },
				   {
					num               => '2',
					name              => $::pkgdefs{DISTRO_NAME} . " QU3",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '2',
										  arch => 'x86_64',
										  key  => '1141419065.978713',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-WS4-QU3',
				   },
				   {
					num               => '3',
					name              => $::pkgdefs{DISTRO_NAME} . " QU3",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '3',
										  arch => 'x86_64',
										  key  => '1141419065.978713',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-WS4-QU3',
				   },
				   {
					num               => '4',
					name              => $::pkgdefs{DISTRO_NAME} . " QU3",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '4',
										  arch => 'x86_64',
										  key  => '1141419065.978713',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-WS4-QU3',
				   },
				   {
					num               => '5',
					name              => $::pkgdefs{DISTRO_NAME} . " QU3",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '5',
										  arch => 'x86_64',
										  key  => '1141419065.978713',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-WS4-QU3',
				   }
				  ];

	$::pkgdefs{sp_disks}{QU3} = $qu3_ref;
}
#--------------------------------------------------------------------------------
{
	my $qu4_ref = [
				   {
					num               => '1',
					name              => $::pkgdefs{DISTRO_NAME} . " QU4",
					diskid_searchargs => {
									   file => '.discinfo',
									   num  => '1',
									   arch => 'x86_64',
									   key  => '1154571873.955774',
									   rpm => 'RedHat/RPMS/redhat-release-4WS*',
					},
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-WS4-QU4',
				   },
				   {
					num               => '2',
					name              => $::pkgdefs{DISTRO_NAME} . " QU4",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '2',
										  arch => 'x86_64',
										  key  => '1154571873.955774',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-WS4-QU4',
				   },
				   {
					num               => '3',
					name              => $::pkgdefs{DISTRO_NAME} . " QU4",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '3',
										  arch => 'x86_64',
										  key  => '1154571873.955774',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-WS4-QU4',
				   },
				   {
					num               => '4',
					name              => $::pkgdefs{DISTRO_NAME} . " QU4",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '4',
										  arch => 'x86_64',
										  key  => '1154571873.955774',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-WS4-QU4',
				   },
				   {
					num               => '5',
					name              => $::pkgdefs{DISTRO_NAME} . " QU4",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '5',
										  arch => 'x86_64',
										  key  => '1154571873.955774',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-WS4-QU4',
				   }
				  ];

	$::pkgdefs{sp_disks}{QU4} = $qu4_ref;
}

for my $pkgs ( keys %{$::pkgdefs{'pkgs'}{$_server_}})
{
        $::pkgdefs{'pkgs'}{$_server_}{$pkgs} = undef;
        $::pkgdefs{'pkgs'}{$_iserver_}{$pkgs} = undef;
}

#-------------------------------------------------------------------------------

=head3	rdm_packages - RDM Packages to Install

        Notes:

=cut

#-------------------------------------------------------------------------------
{
	my %rdmpkgs_ref;

	# defaults
	$rdmpkgs_ref{$_server_}{$::csm_version} = [];

	$rdmpkgs_ref{$_iserver_}{$::csm_version} = ['rdm-dserver', 'rdm-jre'];

	$rdmpkgs_ref{$_node_}{$::csm_version} = [];

	# exceptions  - must follow the default assignments.
	# none

	$::pkgdefs{rdm_packages} = $rdmpkgs_ref{$::mgmt_type}{$::csm_version};
}

#-------------------------------------------------------------------------------

=head3	rdm_unpackages - RDM Packages to Uninstall

        Notes:

=cut

#-------------------------------------------------------------------------------
{
	my %rdmunpkgs_ref;

	# defaults
	$rdmunpkgs_ref{$_server_}{$::csm_version} = [];

	$rdmunpkgs_ref{$_iserver_}{$::csm_version} = ['rdm-dserver', 'rdm-jre'];

	$rdmunpkgs_ref{$_node_}{$::csm_version} = [];

	# exceptions  - must follow the default assignments.
	# none

	$::pkgdefs{rdm_unpackages} = $rdmunpkgs_ref{$::mgmt_type}{$::csm_version};
}

1;    # end
