# @(#)62   1.7   src/csm/install/pkgdefs/Linux-RedHatEL3.pm.perl, setup, csm_rgar2h, rgar2hs001a 10/26/06 09:37:44
# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2006,2008 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
#--------------------------------------------------------------------------------

=head3	Linux-RedHatEL3.pm.perl

        Package Definition File:    RedHatEL 3 i386

        Notes:

        The following global variables must be initalized before including
        this file:

                $::mgmt_type    = [ MgmtServer | MgdNode ]
                $::csm_version  = [ 1.3.0 | 1.3.1 | 1.3.2 | ... ]


        exceptions:
        This file has been rewritten for csm 1.3.4 to rely on default values
        with support for release-specific exceptions.  This makes it much
        simpler to maintain the package defs across releases.

	The approach uses $::csm_version to set default values for both server and
	node defines.  It allows for execptions to these default values by defining
	specific csm versions assignments which overwrite the defaults when
	$::csm_version is equal to the execption's version number.

	ORDER IS IMPORTANT:
	As noted in the code, any excptions must follow the default assignments,
	otherwise the execption assignment will be overwriten by the default.

	OTHER DOCUMENTATION - see pkgdefs/Linux.pm

=cut

#--------------------------------------------------------------------------------

package RedHatEL3;

#--------------------------------------------------------------------------------

=head3  simple common attributes	

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    # install package architecture
    $::pkgdefs{'arch'} = 'i386';
    
    # the directory where kernel and initrd (or zImage) is placed is CD
    $::pkgdefs{'install_image_dir'} = "isolinux";
    
    # the file name of kernel in CD
    $::pkgdefs{'kernel_file_name'} = "vmlinuz";
    
    # the file name of initrd (or zImage) in CD
    $::pkgdefs{'initrd_file_name'} = "initrd.img";

    # the network installation method
    $::pkgdefs{'install_method'} = 'kickstart';
}

my $progdir = $0;
$progdir =~ s/\/[^\/]*$/\//g;
if (-e "$progdir/pkgdefs/Linux.pm")
{
	do "$progdir/pkgdefs/Linux.pm";
}
else
{
	do "/opt/csm/install/pkgdefs/Linux.pm";
}

MessageUtils->messageFromCat(
							 'csmInstall.cat',
							 $::MSGMAPPATH,
							 'csminstall',
							 'V',
							 'IMsgLoading',
							 "/opt/csm/install/pkgdefs/Linux-RedHatEL3.pm"
							);

my $_server_  = 'MgmtServer';
my $_node_    = 'MgdNode';
my $_iserver_ = 'InstallServer';

#--------------------------------------------------------------------------------

=head3	os_prereqs - Operating System pre-requisites

        Notes:
            Packages of the OS that needed to install CSM. There are three classes:
            for CSM installed on MS, for CSM installed on IS and for CSM installed
            on MN. These packages will always get copied, but will only be installed
             in corresponding conditions. 

            The stepes to add a operating system pre-requisites:
            1. Create a Rpm object of the rpm package, such as:
                my $kernel_pkg = new Rpm('kernel', '2.8');
            2. Add this Rpm object to the corresponding RpmList object:
                $ospr_ref{$_server_} = new RpmList(
                        'Management Server Operating System Prerequisites Packages',
                        $perl_pkg,
                        $ksh_pkg,
                        .....
                        $kernel_pkg
                        );
            You must ensure the rpm package be added consisting in the 
            distribution's CD.

=cut

#--------------------------------------------------------------------------------
{
	my %ospr_ref;
	
	my $perl_pkg = new Rpm( 'perl', '5');
	my $pdksh_pkg = new Rpm( 'pdksh');
	my $nfs_utils_pkg = new Rpm( 'nfs-utils');
	my $rdist_pkg = new Rpm( 'rdist', '6');
	my $tcl_pkg = new Rpm( 'tcl', '8.3');
	my $tk_pkg = new Rpm( 'tk', '8.3');
	my $expect_pkg = new Rpm( 'expect', '5.38');
	my $freetype_pkg = new Rpm( 'freetype', '2.1');
	my $xfree86_libs_pkg = new Rpm( 'XFree86-libs', '4.3');
	my $compat_libstdc_pkg = new Rpm( 'compat-libstdc++', '7');

	my $syslinux_pkg = new Rpm( 'syslinux');
	my $dhcp_pkg = new Rpm( 'dhcp', '3');
	my $gtk_pkg = new Rpm( 'gtk+', '1.2');
	my $gdk_pixbuf_pkg = new Rpm( 'gdk-pixbuf');
	
	my $perl_db_file_pkg = new Rpm( 'perl-DB_File');
	my $snmp_pkg = new Rpm( 'net-snmp');
	my $snmp_utils_pkg = new Rpm( 'net-snmp-utils');

	$ospr_ref{$_server_} = new RpmList(
		'Management Server Operating System Prerequisites Packages',
		$perl_pkg,
		$pdksh_pkg,
		$rdist_pkg,
		$tcl_pkg,
		$tk_pkg,
		$expect_pkg,
		$xfree86_libs_pkg,
		$freetype_pkg,
		$compat_libstdc_pkg,
		$nfs_utils_pkg
	);
	
	$ospr_ref{$_iserver_} = new RpmList(
			'Install Server Operating System Prerequisites Packages',
			$syslinux_pkg,
			$nfs_utils_pkg,
			$dhcp_pkg,
			$gtk_pkg,
			$snmp_pkg,
			$snmp_utils_pkg,
			$gdk_pixbuf_pkg
	);
	

	$ospr_ref{$_node_} = new RpmList(
			'Managed Node Operating System Prerequisites Packages',
			$perl_pkg,
			$nfs_utils_pkg,
			$pdksh_pkg,
			$rdist_pkg,
			$compat_libstdc_pkg,
			$syslinux_pkg,
			$perl_db_file_pkg
	);
	
	$ospr_ref{$_server_}->setContainedInCds(1);
	$ospr_ref{$_iserver_}->setContainedInCds(1);
	$ospr_ref{$_node_}->setContainedInCds(1);

	$::pkgdefs{'pkgs'}{$_server_}{$::OS_PREREQ_PKGS} = $ospr_ref{$_server_};
	$::pkgdefs{'pkgs'}{$_iserver_}{$::OS_PREREQ_PKGS} = $ospr_ref{$_iserver_};
	$::pkgdefs{'pkgs'}{$_node_}{$::OS_PREREQ_PKGS} = $ospr_ref{$_node_};
						
}

#-------------------------------------------------------------------------------

=head3	apache_packages

        Notes:	List of packages that comprise the Apache http server.
                These packages will always get copied, but will only be 
                installed if SetupNetworkInstallProtocol=1.

=cut

#-------------------------------------------------------------------------------
{
	my $apache_ref = new RpmList(
			'Install Server HTTP Server Packages',
			new Rpm( 'httpd', '2')
	);
	$apache_ref->setContainedInCds(1);

	$::pkgdefs{'pkgs'}{$_iserver_}{$::HTTP_SERVER_PKGS} = $apache_ref;
}

#-------------------------------------------------------------------------------

=head3	getmacs_Exec

        Notes:  The extra programes needed when CSM try to get MAC address of
            the node's network devices. Those programs would be put into a 
            new ramdisk which be used to boots up nodes and get their MAC address.

=cut

#--------------------------------------------------------------------------------
{
	my $ge_ref = [
				  'usr/bin/grep', 'usr/sbin/ifconfig',
				  'usr/bin/sed',  'usr/bin/sleep',
				  'usr/bin/bash', 'usr/bin/busybox'
				 ];

	$::pkgdefs{getmacs_Exec} = $ge_ref;
}

#--------------------------------------------------------------------------------

=head3 getmacs_RamDiskSize

	Nodes: if this attributes defined, it will replace the value given by
               getGetmacsRAMDiskSize

=cut

#--------------------------------------------------------------------------------
{
	$::pkgdefs{'getmacs_RamDiskSize'} = 18432;
}

#--------------------------------------------------------------------------------

=head3	getmacs_Lib

        Notes:  The lib path will be created in the new ramdisk for containing the
            libs that needed by the extra programs for getting MAC address.

=cut

#--------------------------------------------------------------------------------
{
	my $gl_ref = '/lib';

	$::pkgdefs{getmacs_Lib} = $gl_ref;
}

#--------------------------------------------------------------------------------

=head3	getmacs_ReqLibs

            Notes:  The libs needed by the extra programs that be used to get node's
            MAC address. They also would be copied from the preinstall ramdisk 
            into the new ramdisk.

=cut

#--------------------------------------------------------------------------------
{
	my $gr_ref = [
				  '/lib/ld-linux.so.2', '/lib/libc.so.6',
				  '/lib/libdl.so.2',    '/lib/libtermcap.so.2'
				 ];

	$::pkgdefs{getmacs_ReqLibs} = $gr_ref;
}

#--------------------------------------------------------------------------------

=head3	getmacs_DirStructure

        Notes:	Directories must be created in the new ramdisk for getting MAC
            address from nodes. They will be copied from the preinstall ramdisk 
            of the distribution.

=cut

#--------------------------------------------------------------------------------
{
	my $gd_ref = [
				  "bin",  "etc",      "linuxrc", "modules",
				  "proc", ".profile", "sbin",    "tmp",
				  "var"
				 ];

	$::pkgdefs{getmacs_DirStructure} = $gd_ref;
}

#-------------------------------------------------------------------------------

=head3 kernel_arch_dir

        Notes: the architecture directory for drivers

=cut

#--------------------------------------------------------------------------------
{
	my $kernel_arch_dir = {
						   'default'  => 'i386',
						  };
	$::pkgdefs{'kernel_arch_dir'} = $kernel_arch_dir;
}

#--------------------------------------------------------------------------------

=head3 ramdisk_size

        Notes: the ramdisk size

=cut

#---------------------------------------------------------------------------------
{
	$::pkgdefs{'ramdisk_size'} = 18432;
}

#--------------------------------------------------------------------------------


=head3  hwmaint_Exec

        Notes:  Prerequisite exec utilities for hwmaint. Will be copied to preinstall
		ramdisk:/bin.

=cut

#--------------------------------------------------------------------------------
{
	my $he_ref = [
					'/usr/bin/gzip',
					'/usr/bin/tar',
					'/usr/sbin/ifconfig',
                    '/usr/bin/mount',
					'/usr/bin/mkdir',
					'/usr/bin/tail',
					'/usr/bin/rm',
					'/usr/bin/gunzip',
					'/usr/bin/chmod',
					'/usr/bin/uname',
					'/usr/bin/ls',
					'/usr/bin/cp',
					'/usr/bin/ln'
				 ];

	$::pkgdefs{hwmaint_Exec} = $he_ref;

}

#--------------------------------------------------------------------------------

=head3  hwmaint_ReqLibs

        Notes:  Prerequisite libs for hwmaint. Will be copied to preinstall
		ramdisk:/lib.

=cut

#--------------------------------------------------------------------------------
{
	my $hl_ref = [
					'/lib/libc.so.6',
                    '/usr/lib/libstdc++.so.5',
                    '/lib/libm.so.6',
                    '/lib/libgcc_s.so.1',
					'/lib/librt.so.1',
					'/lib/libpthread.so.0',
					'/lib/libacl.so.1',
					'/lib/libattr.so.1',
					'/lib/libnsl.so.1',
                    '/lib/libdl.so.2',
				 ];

	$::pkgdefs{hwmaint_ReqLibs} = $hl_ref;

}

#--------------------------------------------------------------------------------

=head3  preinstall_libs

    files needed for the nodes during pre-install


    Notes :

=cut
#--------------------------------------------------------------------------------
{
    my $hl_ref = [
                    '/lib/libc.so.6',
                    '/lib/libNoVersion.so.1',
                    '/usr/lib/libstdc++.so.5',
                    '/lib/libm.so.6',
                    '/lib/libdl.so.2',
                    '/lib/libgcc_s.so.1',
                    '/usr/lib/libstdc++-libc6.1-1.so.2',
                    '/usr/lib/libstdc++-libc6.2-2.so.3',
                 ];

    $::pkgdefs{preinstall_libs} = $hl_ref;

}

#--------------------------------------------------------------------------------

=head3  hwmaint_ReqLibsFromRPM

        Notes: These are required libraries for hwmaint operations, but are not
        in the initrd used to build the hwmaint ramdisk.  They must be extracted
        from the rpm files and manually copied to the ramdisk.

        This hash contains the needed libraries and the RPMs where they are packaged.

 $::pkgdefs{'hwmaint_ReqLibsFromRPM'}{'/usr/lib64/libstdc++.so.5'} = "compat-libstdc++-33*.x86_64";
                      ^                       ^                                ^
                      |                       |                                |
                  hash name             required library                 source rpm

=cut

#--------------------------------------------------------------------------------
{
    $::pkgdefs{'hwmaint_ReqLibsFromRPM'}{'/lib/libNoVersion.so.1'} = "glibc-2*.i386";
    $::pkgdefs{'hwmaint_ReqLibsFromRPM'}{'/usr/lib/libstdc++-libc6.2-2.so.3'} = "compat-libstdc++-7*.i386";
}



#--------------------------------------------------------------------------------

=head3  install_kernel_parameter

        Notes:  For some specific machines, installing some specific service 
            levels need adding some specific kernel parameters into the PXE config
            file. This parameter of %::pkgdefs be used for this purpose.

            The last three indices be used to specify for what machine and what
            sevice level you want to insert a string into the PXE config file.
            Their means is:

$::pkgdefs{'install_kernel_parameter'}{'8850'}{'all_models'}{'GA'} = "barrier=off";
                                         ^          ^         ^             ^
                                         |          |         |             |
                                        (1)        (2)       (3)           (4)
            (1) 'HWType' of the nodes, such as '8850'. 'all_types' means for all 
                hardware types.
            (2) 'HWModel' of the nodes, such as '61x'. 'all_models' means for all
                hardware models.
            (3) InstallServiceLevel of the nodes, such as 'GA' 'SP3'.'all_svclevels'
                means for all sevice levels.
            (4) The string will be inserted into pxe file

            For example, you want to install RedHatEL-AS 3 GA on a new machine, 
            but the usb driver has some problems, and you want to disable usb 
            device in the installation. The machine's HWType is '7283', then 
            you could add a new one like this (suppose for all models of this 
            machine):

$::pkgdefs{'install_kernel_parameter'}{'7283'}{'all_models'}{'GA'} = "nousb";

=cut

#--------------------------------------------------------------------------------
{
    $::pkgdefs{'install_kernel_parameter'}{'e326'}{'46Z'}{'GA'} = 'blank';
    $::pkgdefs{'install_kernel_parameter'}{'8835'}{'all_models'}{'GA'} = 'hpet=disable acpi=noirq';
    $::pkgdefs{'install_kernel_parameter'}{'8848'}{'all_models'}{'GA'} = 'hpet=disable acpi=noirq';
    $::pkgdefs{'install_kernel_parameter'}{'e325'}{'all_models'}{'GA'} = 'hpet=disable acpi=noirq';
    $::pkgdefs{'install_kernel_parameter'}{'e326'}{'all_models'}{'GA'} = 'hpet=disable acpi=noirq';
    $::pkgdefs{'install_kernel_parameter'}{'8843'}{'all_models'}{'all_svclevels'} = 'n8r acpi=noirq';
}

#--------------------------------------------------------------------------------

=head3  hwmaintain_kernel_parameter

        Notes:  the strings used by hardware maintainance

=cut

#--------------------------------------------------------------------------------
{
    $::pkgdefs{'hwmaintain_kernel_parameter'}{'e326'}{'46Z'}{'GA'} = 'blank';
    $::pkgdefs{'hwmaintain_kernel_parameter'}{'8835'}{'all_models'}{'GA'} = 'hpet=disable acpi=noirq';
    $::pkgdefs{'hwmaintain_kernel_parameter'}{'8848'}{'all_models'}{'GA'} = 'hpet=disable acpi=noirq';
    $::pkgdefs{'hwmaintain_kernel_parameter'}{'e325'}{'all_models'}{'GA'} = 'hpet=disable acpi=noirq';
    $::pkgdefs{'hwmaintain_kernel_parameter'}{'e326'}{'all_models'}{'GA'} = 'hpet=disable acpi=noirq';
}

1;    # end
