# @(#)43   1.1   src/csm/install/pkgdefs/Linux-RedHatEL4.6-x86_64.pm.perl, setup, csm_rgar2h, rgar2hs001a 10/8/07 22:51:18
# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2007,2008 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
#--------------------------------------------------------------------------------

=head3	Linux-RedHatEL4.5-x86_64.pm.perl

        Package Definition File:    RedHatEL 4.5 x86_64

        Notes:

        The following global variables must be initalized before including
        this file:

                $::mgmt_type    = [MgmtServer | MgdNode ]
                $::csm_version  = [1.3.0 | 1.3.1 | 1.3.2 | ... ]


        exceptions:
        This file has been rewritten for csm 1.3.4 to rely on default values
        with support for release-specific exceptions.  This makes it much
        simpler to maintain the package defs across releases.

	The approach uses $::csm_version to set default values for both server and
	node defines.  It allows for execptions to these default values by defining
	specific csm versions assignments which overwrite the defaults when
	$::csm_version is equal to the execption's version number.

	ORDER IS IMPORTANT:
	As noted in the code, any excptions must follow the default assignments,
	otherwise the execption assignment will be overwriten by the default.

	OTHER DOCUMENTATION - see pkgdefs/Linux.pm

=cut

#--------------------------------------------------------------------------------

package RedHatEL45;

#--------------------------------------------------------------------------------

=head3  simple common attributes

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    # install package architecture
    $::pkgdefs{'arch'} = 'x86_64';

    # the directory where kernel and initrd (or zImage) is placed is CD
    $::pkgdefs{'install_image_dir'} = "isolinux";

    # the file name of kernel in CD
    $::pkgdefs{'kernel_file_name'} = "vmlinuz";

    # the file name of initrd (or zImage) in CD
    $::pkgdefs{'initrd_file_name'} = "initrd.img";

    # the network installation method
    $::pkgdefs{'install_method'} = 'kickstart';

    # additional options for "rpm" command
    $::pkgdefs{'additionalRpmCmdOptions'} = '--nosignature';    
}

my $progdir = $0;
$progdir =~ s/\/[^\/]*$/\//g;
if (-e "$progdir/pkgdefs/Linux-RedHatEL4.5-x86_64.pm")
{
	do "$progdir/pkgdefs/Linux-RedHatEL4.5-x86_64.pm";
}
else
{
	do "/opt/csm/install/pkgdefs/Linux-RedHatEL4.5-x86_64.pm";
}

MessageUtils->messageFromCat(
						 'csmInstall.cat',
						 $::MSGMAPPATH,
						 'csminstall',
						 'V',
						 'IMsgLoading',
						 "/opt/csm/install/pkgdefs/Linux-RedHatEL4.6-x86_64.pm"
                         );

my $_server_  = 'MgmtServer';
my $_node_    = 'MgdNode';
my $_iserver_ = 'InstallServer';

1; #end
