# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2003,2008 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
#
#
# @(#)83   1.60.1.41   src/csm/install/pkgdefs/Linux-SLES8.1.pm.perl, setup, csm_rgar2h, rgar2hs001a 8/22/06 05:01:46

#--------------------------------------------------------------------------------

=head3	Linux-SLES8.1.pm.perl  

        Package Definition File:    SLES 8.1

        Notes:

        The following global variables must be initalized before including
        this file:

                $::mgmt_type    = [ MgmtServer | MgdNode ]
                $::csm_version  = [ 1.3.0 | 1.3.1 | 1.3.2 | ... ]


        exceptions:
        This file has been rewritten for csm 1.3.4 to rely on default values
        with support for release-specific exceptions.  This makes it much
        simpler to maintain the package defs across releases.

	The approach uses $::csm_version to set default values for both server and
	node defines.  It allows for execptions to these default values by defining
	specific csm versions assignments which overwrite the defaults when
	$::csm_version is equal to the execption's version number.

	ORDER IS IMPORTANT:
	As noted in the code, any excptions must follow the default assignments,
	otherwise the execption assignment will be overwriten by the default.

	OTHER DOCUMENTATION - see pkgdefs/Linux.pm

=cut

#--------------------------------------------------------------------------------

# houskeeping

package  SLES81;

#--------------------------------------------------------------------------------

=head3  simple common attributes

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    # install package architecture
    $::pkgdefs{'arch'} = 'i386';

    # the directory where kernel and initrd (or zImage) is placed is CD
    $::pkgdefs{'install_image_dir'} = "boot/loader";

    # the file name of kernel in CD
    $::pkgdefs{'kernel_file_name'} = "linux";

    # the file name of initrd (or zImage) in CD
    $::pkgdefs{'initrd_file_name'} = "initrd";

    # the installing ramdisk format
    $::pkgdefs{'ramdisk_format'} = 'minix';

    # the network installation method
    $::pkgdefs{'install_method'} = 'autoyast';

    # where this distribution is supported
    $::pkgdefs{'where_supported'} = ['MgdNode'];
}

#  Load base Linux definitions:
my $progdir = $0;
$progdir =~ s/\/[^\/]*$/\//g;
if (-e "$progdir/pkgdefs/Linux.pm")
{
	do "$progdir/pkgdefs/Linux.pm";
}
else
{
	do "/opt/csm/install/pkgdefs/Linux.pm";
}

MessageUtils->messageFromCat(
							 'csmInstall.cat',
							 $::MSGMAPPATH,
							 'csminstall',
							 'V',
							 'IMsgLoading',
							 "/opt/csm/install/pkgdefs/Linux-SLES8.1.pm"
							);

my $_server_  = 'MgmtServer';
my $_node_    = 'MgdNode';
my $_iserver_ = 'InstallServer';

#--------------------------------------------------------------------------------

=head3	DISTRO Defintions

	Notes :

=cut

#--------------------------------------------------------------------------------
{

	$::pkgdefs{DISTRO_NAME}     = "SuSE SLES 8.1";
	$::pkgdefs{DISTRO_DISKLIST} = "1 4";             # TO BE REMOVED
	$::pkgdefs{DISTRO_RPMDIR}   = "";
}

#--------------------------------------------------------------------------------

=head3  distro_disks - Distribution Disk Defines

        Distribution Disk descriptions used to prompt for the CD-ROMs
        during installation.

        One stanza per CDROM:

                num                     = the number on the CD-ROM's label
                name                    = the text string describing the CD-ROM
                diskid_filename         = the filename to search to identify the disk
                                          - supportsw shell wildcards.
                diskid_searchstring     = the string to search for in diskid_filename
                                          - supports perl regular expressions


=cut

#--------------------------------------------------------------------------------
{
	my $dd_ref = [
		{
		 num  => '1',
		 name => $::pkgdefs{DISTRO_NAME},

		 #	    diskid_filename     => 'media.1/products',
		 #	    diskid_searchstring => '/ SuSE-Linux-SLES-i386 8',
		 diskid_searchargs => {
							   file => 'media.1/products',
							   key  => '/ SuSE-Linux-SLES-i386 8',
							  },
		 diskid_searchprog => \&Linux::linux_diskid_match_prog,
		 diskid_target     => "sles8-i386",
		},
		{
		 num  => '1',
		 name => "UnitedLinux 1.0",

		 #	    diskid_filename     => 'media.1/products',
		 #	    diskid_searchstring => '/ UnitedLinux-i386 1.0',
		 diskid_searchargs => {
							   file => 'media.1/products',
							   key  => '/ UnitedLinux-i386 1.0',
							  },
		 diskid_searchprog => \&Linux::linux_diskid_match_prog,
		 diskid_target     => "unitedlinux-i386",
		},
		{
		 num  => '2',
		 name => "UnitedLinux 1.0",

		 #	    diskid_filename     => 'media.2/products',
		 #	    diskid_searchstring => '/ UnitedLinux-i386 1.0',
		 diskid_searchargs => {
							   file => 'media.2/products',
							   key  => '/ UnitedLinux-i386 1.0',
							  },
		 diskid_searchprog => \&Linux::linux_diskid_match_prog,
		 diskid_target     => "unitedlinux-i386",
		},
		{
		 num        => '3',
		 name       => "UnitedLinux 1.0",
		 is_extracd => '1',

		 #	    diskid_filename     => 'media.2/products',
		 #	    diskid_searchstring => '/ UnitedLinux-i386 1.0',
		 diskid_searchargs => {
							   file => 'media.3/products',
							   key  => '/ UnitedLinux-i386 1.0',
							  },
		 diskid_searchprog => \&Linux::linux_diskid_match_prog,
		 diskid_target     => "unitedlinux-i386",
		},
	];

	$::pkgdefs{distro_disks} = $dd_ref;
}

#--------------------------------------------------------------------------------

=head3	Service Pack disks defination

        Notes:

=cut

#--------------------------------------------------------------------------------
{
	my $sp3_ref = [
				   {
					num               => '1',
					name              => "SuSE SLES 8.1 SP3",
					diskid_searchargs => {
										  file => 'media.1/products',
										  key  => '/ UnitedLinux-i386 3',
										 },
					diskid_searchprog => \&Linux::linux_diskid_match_prog,
					diskid_target     => "unitedlinux-sp3",
				   },
				   {
					num               => '2',
					name              => "SuSE SLES 8.1 SP3",
					is_extracd        => '1',
					diskid_searchargs => {
										  file => 'media.2/products',
										  key  => '/ UnitedLinux-i386 3',
										 },
					diskid_searchprog => \&Linux::linux_diskid_match_prog,
					diskid_target     => "unitedlinux-sp3",
				   },
				  ];

	$::pkgdefs{sp_disks}{SP3} = $sp3_ref;
}

#------------------------------------------------------------------------------
{
	my $sp4_ref = [
				   {
					num               => '1',
					name              => "SuSE SLES 8.1 SP4",
					diskid_searchargs => {
										  file => 'media.1/products',
										  key  => '/ UnitedLinux-i386 4',
										 },
					diskid_searchprog => \&Linux::linux_diskid_match_prog,
					diskid_target     => "unitedlinux-sp4",
				   },
				   {
					num               => '2',
					name              => "SuSE SLES 8.1 SP4",
					is_extracd        => '1',
					diskid_searchargs => {
										  file => 'media.2/products',
										  key  => '/ UnitedLinux-i386 4',
										 },
					diskid_searchprog => \&Linux::linux_diskid_match_prog,
					diskid_target     => "unitedlinux-sp4",
				   },
				  ];

	$::pkgdefs{sp_disks}{SP4} = $sp4_ref;
}

#--------------------------------------------------------------------------------

=head3	os_prereqs - Operating System pre-requisites

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    my $svlLevel = $::ATTRS{"InstallServiceLevel"};
    if ($svlLevel eq "")
    {
        my $disable_warning_msg = 1;
        # disable waring msg from subroutine get_ServiceLevel 
        $svlLevel = NodeUtils->get_ServiceLevel($disable_warning_msg);
    }
	
	my %ospr_ref;
	my $perl_pkg = new Rpm( 'perl','5');
	my $pdksh_pkg = new Rpm( 'pdksh');
	my $nfs_utils_pkg = new Rpm( 'nfs-utils');
	my $rdist_pkg = new Rpm( 'rdist','6.1.5-543');
	my $tcl_pkg = new Rpm( 'tcl','8');
	my $tk_pkg = new Rpm( 'tk','8');
	my $expect_pkg = new Rpm( 'expect','5.34-192');
	my $xf86_pkg=  new Rpm( 'xf86');
	my $freetype2_pkg = new Rpm( 'freetype2');
	my $termcap_pkg = new Rpm( 'termcap');
	my $expat_pkg = new Rpm( 'expat');
	my $perl_xml_parse_pkg = new Rpm( 'perl-XML-Parser');
	my $perl_xml_dom_pkg = new Rpm( 'perl-XML-DOM');
	my $perl_html_target_pkg = new Rpm( 'perl-HTML-Tagset');
	my $perl_html_parse_pkg = new Rpm( 'perl-HTML-Parser');
	my $perl_uri_pkg = new Rpm( 'perl-URI');
	my $perl_libwww_perl_pkg = new Rpm( 'perl-libwww-perl');
	
	my $dhcp_base_pkg = new Rpm( 'dhcp-base');
	my $dhcp_server_pkg = new Rpm( 'dhcp-server');

	my $rsh_server_pkg = new Rpm( 'rsh-server');

	$ospr_ref{$_server_} = new RpmList(
			'Management Server Operating System Prerequisites Packages',
			$perl_pkg,
			$pdksh_pkg,
			$nfs_utils_pkg,
			$rdist_pkg,
			$tcl_pkg,
			$tk_pkg,
			$expect_pkg,
			$xf86_pkg,
			$freetype2_pkg,
			$expat_pkg,
			$termcap_pkg,
			$perl_xml_parse_pkg,
			$perl_xml_dom_pkg,
			$perl_html_target_pkg,
			$perl_html_parse_pkg,
			$perl_uri_pkg,
			$perl_libwww_perl_pkg
	);

	$ospr_ref{$_iserver_} = new RpmList(
			'Install Server Operating System Prerequisites Packages',
			$nfs_utils_pkg,
			$dhcp_base_pkg,
			$dhcp_server_pkg,
			$termcap_pkg,
			$expat_pkg,
			$perl_xml_parse_pkg,
			$perl_xml_dom_pkg,
			$perl_html_target_pkg,
			$perl_html_parse_pkg,
			$perl_uri_pkg,
			$perl_libwww_perl_pkg
	);

	$ospr_ref{$_node_} = new RpmList(
			'Managed Node Operating System Prerequisites Packages',
			$perl_pkg,
			$nfs_utils_pkg,
			$pdksh_pkg,
			$dhcp_base_pkg,
			$dhcp_server_pkg,
			$rdist_pkg,
			$tcl_pkg,
			$tk_pkg,
			$expect_pkg,
			$xf86_pkg,
			$freetype2_pkg,
			$rsh_server_pkg
	);

	my $perl_xml_regexp_pkg = new Rpm( 'perl-XML-RegExp');
	# Add perl-XML-RegExp to os_prereqs since
	# it has been shipped with SP3
	if (($svlLevel eq "SP3" || $svlLevel eq "SP4")
		&& $::mgmt_type ne "MgdNode")
	{
		$ospr_ref{$_server_}->addRpm( $perl_xml_regexp_pkg);
		$ospr_ref{$_iserver_}->addRpm( $perl_xml_regexp_pkg);
	}

	$ospr_ref{$_server_}->setContainedInCds(1);
	$ospr_ref{$_iserver_}->setContainedInCds(1);
	$ospr_ref{$_node_}->setContainedInCds(1);

	$::pkgdefs{'pkgs'}{$_server_}{$::OS_PREREQ_PKGS} = $ospr_ref{$_server_};
	$::pkgdefs{'pkgs'}{$_iserver_}{$::OS_PREREQ_PKGS} = $ospr_ref{$_iserver_};
	$::pkgdefs{'pkgs'}{$_node_}{$::OS_PREREQ_PKGS} = $ospr_ref{$_node_};

}

#--------------------------------------------------------------------------------

=head3	getmacs_Exec

        Notes:	non-eth0 support

=cut

#--------------------------------------------------------------------------------
{
	my $ge_ref =
	  ['bin/grep', 'sbin/ifconfig', 'bin/sed', 'bin/sleep', 'bin/bash'];

	$::pkgdefs{getmacs_Exec} = $ge_ref;
}

#--------------------------------------------------------------------------------

=head3	getmacs_Lib

        Notes:	non-eth0 support

=cut

#--------------------------------------------------------------------------------
{
	my $gl_str = '/lib';

	$::pkgdefs{getmacs_Lib} = $gl_str;
}

#--------------------------------------------------------------------------------

=head3	getmacs_ReqLibs

        Notes:	non-eth0 support

=cut

#--------------------------------------------------------------------------------
{
	my $gr_ref = [
				  '/lib/ld-linux.so.2',   '/lib/libc.so.6',
				  '/lib/libdl.so.2',      '/lib/libreadline.so.4',
				  '/lib/libhistory.so.4', '/lib/libncurses.so.5'
				 ];

	$::pkgdefs{getmacs_ReqLibs} = $gr_ref;
}

#--------------------------------------------------------------------------------

=head3	getmacs_DirStructure

        Notes:	non-eth0 support

=cut

#--------------------------------------------------------------------------------
{
	my $gd_ref = [
				  "bin",  "etc",            "linuxrc", "modules",
				  "proc", "linuxrc.config", "kbd",     "tmp",
				  "var",  "root",           "mounts",  "mnt",
				  "info"
				 ];

	$::pkgdefs{getmacs_DirStructure} = $gd_ref;
}

#--------------------------------------------------------------------------------

=head3  hwmaint_Exec

        Notes:  Prerequisite exec utilities for hwmaint. Will be copied to preinstall
		ramdisk:/bin.

=cut

#--------------------------------------------------------------------------------
{
	my $he_ref = [
					'/bin/gzip',
					'/bin/tar',
					'/sbin/ifconfig',
                    '/bin/mount',
                    '/bin/uname'
				 ];

	$::pkgdefs{hwmaint_Exec} = $he_ref;

}

#--------------------------------------------------------------------------------

=head3  hwmaint_ReqLibs

        Notes:  Prerequisite libs for hwmaint. Will be copied to preinstall
		ramdisk:/lib.

=cut

#--------------------------------------------------------------------------------
{
	my $hl_ref = [
					'/lib/libc.so.6',
                    '/usr/lib/libstdc++.so.5',
                    '/lib/libm.so.6',
                    '/lib/libgcc_s.so.1',
				 ];

	$::pkgdefs{hwmaint_ReqLibs} = $hl_ref;

}

#--------------------------------------------------------------------------------

=head3  install_kernel_parameter

        Notes:  the strings used to be inserted into PXE config file

=cut

#--------------------------------------------------------------------------------
{
    # Append kernel parameters "acpi=oldboot" for SLES8 i386 nodes
    $::pkgdefs{'install_kernel_parameter'}{'all_types'}{'all_models'}{'all_svclevels'} = 'acpi=oldboot';
}

1;    # end
