# @(#)60   1.32.1.80   src/csm/install/pkgdefs/Linux.pm.perl, setup, csm_rgar2h, rgar2hs001a 10/10/07 01:17:32
# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2003,2008 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 

package Linux;

#--------------------------------------------------------------------------------

=head3  Linux.pm.perl

        Package Definition File:   Linux

	Top level definition file for Linux platforms

        Notes:

        The following global variables must be initalized before including
        this file:

                $::mgmt_type    = [MgmtServer | InstallServer | MgdNode ]
                $::csm_version  = [1.4.0 | 1.4.1 | 1.4.2 | ... ]


        EXCEPTIONS:
        This file has been rewritten for csm 1.3.4 to rely on default values
        with support for release-specific exceptions.  This makes it much
        simpler to maintain the package defs across releases.

	The approach uses $::csm_version to set default values for both server and
	node defines.  It allows for execptions to these default values by defining
	specific csm versions assignments which overwrite the defaults when
	$::csm_version is equal to the execption's version number.

	ORDER IS IMPORTANT:
	As noted in the code, any excptions must follow the default assignments,
	otherwise the execption assignment will be overwriten by the default.


	NOTES on the PKGDEFS DESIGN:

	This isn't very well documented, so here are some notes to make
	working with these files eaiser the first few times.

	1. The first thing to recognize is that the data is just a lot 
	   of references to arrays.  The data is always an array; there
	   are no exceptions to this.  It may be an array of hashes but
	   its still just an array.

        2. Unfortunately, the names for these references need to be
	   unique.  This is most true for a pattern like:

		$ref{x}{y} = ['z'].

	   when it is processed by the "do" command more than once,
	   (e.g. an application tries to create both a node and server
	   registry for the same distro).  The explination for this
	   restiction is buried in the "do" file loader and perl
	   interpreter.  A good perl programmer probably knows why,
	   but so far this behavior is a bit of a mystery.

	3. $::mgmt_type has the value 'MgdNode', 'InstallServer' or 'MgmtServer'
	   $::csm_version is as one would expect.  When an aray ref
	   is assigned to the global $::pkgdefs hash either the sever
	   or node type is selected for the assignment by the clever
	   way that the assignment statement is constructed.  This
	   assignment trick is a critical element of the design.
	
	FILES:

	The package defs files are loaded into the running process in the
	get_pkgdefs_files subroutine (or whatever it is called these days)
	usng the perl "do" command.  "do" reloads files with every invocation.
	The strategy is to find the correct distribution file, such as
	"Linux-RedHat7.3.pm" which also runs do to load Linux.pm.  That's
	pretty much it.


	SUGGESTIONS:

	DON'T PUT GLOBALS IN THE PKGDEFS FILE - just a suggestion. 
	Globals in these files makes things overly complex and can have
	weird side effects that are hard to find.   "do" has some error
	checking but it just ain't that good.  The point is that these
	files are simple; you don't need to get tricky - just assign
	an array reference to %::pkgdefs.


	PATTERNS:

	# 1
	my $a_ref	   = [ 'a', 'b' ];
	$::pkgdefs{ name } = $a_ref;

	# 2
	my %a_ref;
	$a_ref { $_server_ }	= [ 'a', 'b' ];
	$a_ref { $_node_   }	= [ 'b', 'c' ];
	$::pkgdefs{  name }	= $a_ref { $::mgmt_type };

	# 3 - reference name must be unique 
	my %b_ref;
	$b_ref { $_server_ }{$::csm_version} = [ 'a', 'b' ];
	$b_ref { $_node_   }{$::csm_version} = [ 'c', 'd' ];
	$::pkgdefs{ name }	
	    = $b_ref { $::mgmt_type } {$::csm_version};

	# 4 - hash array
	my $h_ref;
	$h_ref = [
		    { w => 'a'},
		    { x => 'b'},
		    { y => 'c'},
                 ];
	$::pkgdefs{ name } = $h_ref;

=cut

#--------------------------------------------------------------------------------

use POSIX;

# housekeeping

MessageUtils->messageFromCat(
							 'csmInstall.cat',
							 $::MSGMAPPATH,
							 'csminstall',
							 'V',
							 'IMsgLoading',
							 "/opt/csm/install/pkgdefs/Linux.pm"
							);

# wipe out pkgdefs global
#%::pkgdefs = ();

# set for easy reading and typing
my $_server_  = 'MgmtServer';
my $_node_    = 'MgdNode';
my $_iserver_ = 'InstallServer';
$::pkgdefs{'OS'} = 'linux';

#RpmList installing squence definition
$::OS_PREREQ_PKGS = 10;
$::HTTP_SERVER_PKGS = 20;
$::OPEN_SRC_PKGS = 30;
$::RSCT_PKGS = 40;
$::CSM_PKGS = 50;
$::HAMS_PKGS = 60;
$::OPTIONAL_PKGS = 70;
$::OPTIONAL_WEBSM_PKGS = 75;
$::UPDATE_ONLY_PKGS = 80;
$::CREATEREPO_PKGS = 90;
$::YUM_PKGS = 100;
$::WAREWULF_PKGS = 110;


#--------------------------------------------------------------------------------

=head3	opensrc_prereqs - Open Source Prereqs to Install

        Notes: List of open source packages needed to install CSM

=cut

#--------------------------------------------------------------------------------
{
	my %opr_ref;
	my ($java_ver, $consvr_ver);
    if ( $::csm_version eq '1.4.0')
    {
        $java_ver   = undef;
        $consvr_ver = undef;
    }
    elsif( $::csm_version eq '1.3.3')
    {
        $java_ver   = '1.4.1';
        $consvr_ver = '7.2';
    }
    elsif( $::csm_version eq '1.3.2')
    {
        $java_ver   = '1.3.1';
        $consvr_ver = '7.2';
    }
    elsif( $::csm_version eq '1.3.0')
    {
        $java_ver   = '1.3';
        $consvr_ver = '7.2';
    }
    else
    {
        $java_ver   = '1.4.2';
        $consvr_ver = '8.1';
    }
	
	my $java_pkg;
	if ($::pkgdefs{'arch'} eq 'ppc64')
	{
		$java_pkg = new Rpm( 'IBMJava2-JRE-ppc', $java_ver);
	}else
	{
		$java_pkg = new Rpm( 'IBMJava2-JRE', $java_ver);
	}

	$opr_ref{$_server_}{$::csm_version} = new RpmList(
        'Management Server Open Source Packages',    
	    $java_pkg, 
	    new Rpm( 'conserver', $consvr_ver)
	);

	$opr_ref{$_iserver_}{$::csm_version} = new RpmList(
        'Install Server Open Source Packages',    
	    $java_pkg
	);

	$opr_ref{$_node_}{$::csm_version} = undef;

	# exceptions  - must follow the default assignments.
	# none

	$::pkgdefs{'pkgs'}{$_server_}{$::OPEN_SRC_PKGS} = $opr_ref{$_server_}{$::csm_version};
	$::pkgdefs{'pkgs'}{$_iserver_}{$::OPEN_SRC_PKGS} = $opr_ref{$_iserver_}{$::csm_version};
    
}

#--------------------------------------------------------------------------------

=head3	rsct_packages - RSCT Packages to Install

        Notes:  List of RSCT packages that needed to install CSM.

=cut

#--------------------------------------------------------------------------------
{
	my $rp_ref;

	# defaults
	my $src_pkg = new Rpm( 'src');
	my $rsct_core_pkg = new Rpm( 'rsct.core');
	my $rsct_core_utils_pkg = new Rpm( 'rsct.core.utils');
	my $rsct_core_cimrm_pkg = new Rpm( 'rsct.core.cimrm');
    
	$rp_ref{$_server_}{$::csm_version} = new RsctRpmList(
        'Management Server RSCT Packages',    
	    $src_pkg,
	    $rsct_core_pkg,
	    $rsct_core_utils_pkg,
	    $rsct_core_cimrm_pkg,
	);

	$rp_ref{$_iserver_}{$::csm_version} = undef;

	$rp_ref{$_node_}{$::csm_version} = new RsctRpmList(
        'Managed Node RSCT Packages',    
	    $src_pkg,
	    $rsct_core_pkg,
	    $rsct_core_utils_pkg,
	    $rsct_core_cimrm_pkg,
    );

	# exceptions  - must follow the default assignments.
	# none
	$rp_ref{$_node_}{'1.2.0'} = $rp_ref{$_node_}{'1.3.0'} = $rp_ref{$_node_}{'1.3.1'} =
	    $rp_ref{$_node_}{'1.3.2'} = new RpmList(
            'Managed Node RSCT Packages',    
    	    $src_pkg,
    	    $rsct_core_pkg,
    	    $rsct_core_utils_pkg
        );

    my $rsct_opt_storagerm_pkg = new Rpm( 'rsct.opt.storagerm');
    my $rsct_basic_pkg = new Rpm( 'rsct.basic');
    $rsct_opt_storagerm_pkg->setPostinstall( \&NodeUtils::waitForCTRMC);
                
	$::pkgdefs{'pkgs'}{$_server_}{$::RSCT_PKGS} = $rp_ref{$_server_}{$::csm_version};
	$::pkgdefs{'pkgs'}{$_node_}{$::RSCT_PKGS} = $rp_ref{$_node_}{$::csm_version};
    $::pkgdefs{'pkgs'}{$_server_}{$::RSCT_PKGS}->setToBeUninstall( $::TRUE);
    $::pkgdefs{'pkgs'}{$_node_}{$::RSCT_PKGS}->setToBeUninstall( $::TRUE);
    $::pkgdefs{'pkgs'}{$_server_}{$::RSCT_PKGS}->setNeedCompareVersionWithDest( $::TRUE);
    $::pkgdefs{'pkgs'}{$_node_}{$::RSCT_PKGS}->setNeedCompareVersionWithDest( $::TRUE);
    $::pkgdefs{'pkgs'}{$_server_}{$::RSCT_PKGS}->addRsctUpdateOnlyRpm( $rsct_basic_pkg);
    $::pkgdefs{'pkgs'}{$_server_}{$::RSCT_PKGS}->addRsctUpdateOnlyRpm( $rsct_opt_storagerm_pkg);
    $::pkgdefs{'pkgs'}{$_node_}{$::RSCT_PKGS}->addRsctUpdateOnlyRpm( $rsct_basic_pkg);
    $::pkgdefs{'pkgs'}{$_node_}{$::RSCT_PKGS}->addRsctUpdateOnlyRpm( $rsct_opt_storagerm_pkg);
    $::pkgdefs{'pkgs'}{$_server_}{$::RSCT_PKGS}->setFastParsing( $::TRUE);
    $::pkgdefs{'pkgs'}{$_node_}{$::RSCT_PKGS}->setFastParsing( $::TRUE);
}

#--------------------------------------------------------------------------------

=head3	csm_packages - CSM Packages to Install

        Notes:  List of all CSM packages.

=cut

#--------------------------------------------------------------------------------
{
	my %cp_ref;

	# defaults
	my $csm_core_pkg = new Rpm( 'csm.core',"$::csm_version,$::csm_version");
    my $csm_dsh_pkg  = new Rpm( 'csm.dsh',"$::csm_version,$::csm_version");
    my $csm_svr_pkg  = new Rpm( 'csm.server',"$::csm_version,$::csm_version");
    my $csm_clnt_pkg = new Rpm( 'csm.client',"$::csm_version,$::csm_version");
    my $csm_diag_pkg = new Rpm( 'csm.diagnostics',"$::csm_version,$::csm_version");
    my $csm_gui_pkg  = new Rpm( 'csm.gui.dcem',"$::csm_version,$::csm_version");
    my $csm_deploy_pkg = new Rpm( 'csm.deploy',"$::csm_version,$::csm_version");
    my $csm_hc_utils_pkg = new Rpm( 'csm.hc_utils',"$::csm_version,$::csm_version");
    $cp_ref{$_server_}{$::csm_version} = new RpmList(
        'Management Server CSM Packages',    
        $csm_dsh_pkg,
        $csm_svr_pkg, 
        $csm_diag_pkg,
        $csm_gui_pkg,
        $csm_deploy_pkg,
        $csm_hc_utils_pkg
	);

	$cp_ref{$_iserver_}{$::csm_version} = undef;

	$cp_ref{$_node_}{$::csm_version} = new RpmList(
        'Managed Node CSM Packages',    
        $csm_core_pkg,
        $csm_dsh_pkg,
        $csm_clnt_pkg, 
        $csm_diag_pkg
	);

	$cp_ref{$_node_}{'1.4.0'} = $cp_ref{$_node_}{'1.3.3'} = $cp_ref{$_node_}{'1.3.2'} = 
        $cp_ref{$_node_}{'1.3.1'} = $cp_ref{$_node_}{'1.3.0'} = new RpmList(
            'Managed Node CSM Packages',    
            $csm_core_pkg,
            $csm_clnt_pkg, 
            $csm_diag_pkg
        );

	# exceptions  - must follow the default assignments.
	$cp_ref{$_node_}{'1.2.0'} = new RpmList( 
	        'Managed Node CSM Packages', 
            $csm_core_pkg,
            $csm_clnt_pkg
	);

	$::pkgdefs{'pkgs'}{$_server_}{$::CSM_PKGS} = $cp_ref{$_server_}{$::csm_version};
	$::pkgdefs{'pkgs'}{$_node_}{$::CSM_PKGS} = $cp_ref{$_node_}{$::csm_version};
    $::pkgdefs{'pkgs'}{$_server_}{$::CSM_PKGS}->setToBeUninstall( $::TRUE);
    $::pkgdefs{'pkgs'}{$_node_}{$::CSM_PKGS}->setToBeUninstall( $::TRUE);
    $::pkgdefs{'pkgs'}{$_server_}{$::CSM_PKGS}->setNeedCompareVersionWithDest( $::TRUE);
    $::pkgdefs{'pkgs'}{$_node_}{$::CSM_PKGS}->setNeedCompareVersionWithDest( $::TRUE);
    $::pkgdefs{'pkgs'}{$_server_}{$::CSM_PKGS}->setFastParsing( $::TRUE);
    $::pkgdefs{'pkgs'}{$_node_}{$::CSM_PKGS}->setFastParsing( $::TRUE);
}

#-------------------------------------------------------------------------------

=head3	optional_packages - Optional packages to copy and install.  

        Notes:

=cut

#-------------------------------------------------------------------------------
{
    my $_server_op_pkgs= new RpmList(
	'Management Server Optional Packages',     
	new Rpm( 'fping'),
	new StrictVerOpRpm( 'openCIMOM', '0.8-1'),
	new Rpm( 'xcsm'),
	new Rpm( 'xcsm.web'),
	new Rpm( 'webmin')
    );

    $_node_op_pkgs = new RpmList( 
	'Managed Node Optional Packages',
	new Rpm( 'autoupdate'),
	new Rpm( 'perl-RPM2')
    );

    $_server_op_pkgs->setSearchingStyle( 'OPTIONAL');
    $_server_op_pkgs->setUpdatingStyle( 'UPDATE_OR_INSTALL', 'INDIVIDUAL');
    $_node_op_pkgs->setSearchingStyle( 'OPTIONAL');
    $_node_op_pkgs->setUpdatingStyle( 'UPDATE_OR_INSTALL', 'INDIVIDUAL');

    $::pkgdefs{'pkgs'}{$_server_}{$::OPTIONAL_PKGS} = $_server_op_pkgs;

    $::pkgdefs{'pkgs'}{$_node_}{$::OPTIONAL_PKGS} = $_node_op_pkgs;

}
#-------------------------------------------------------------------------------

=head3	optional_packages for ppc64 - Optional packages to copy and install.  

        Notes:

=cut

#-------------------------------------------------------------------------------
{
    my $_ppc64_server_op_websm_pkgs= new RpmList(
	'Management Server Optional Websm Packages',    
	new Rpm('sysmgt.websm.framework'),
	new Rpm('sysmgt.websm.apps'),
	new Rpm('sysmgt.websm.help'),
	new Rpm('sysmgt.websm.webaccess'),
	new Rpm('csm.gui.websm'),
	new Rpm('rsct.core.gui')
    );

    $_ppc64_server_op_websm_pkgs->setSearchingStyle( 'OPTIONAL');
    $::pkgdefs{'pkgs'}{$_server_}{$::OPTIONAL_WEBSM_PKGS} = $_ppc64_server_op_websm_pkgs if($::pkgdefs{'arch'} eq 'ppc64');
    $::pkgdefs{'pkgs'}{$_server_}{$::OPTIONAL_WEBSM_PKGS}->setToBeUninstall($::TRUE) if ($::pkgdefs{'arch'} eq 'ppc64');
    $::pkgdefs{'pkgs'}{$_server_}{$::OPTIONAL_WEBSM_PKGS}->setFastParsing( $::TRUE) if ($::pkgdefs{'arch'} eq 'ppc64');
}

#-------------------------------------------------------------------------------
{
    my $hams_pkgs = new RpmList(
        'Management Server HAMS Packages',    
        new Rpm( 'sam'),
        new Rpm( 'csm.hams',"$::csm_version,$::csm_version")
    );
        
    $hams_pkgs->setSearchingStyle( 'OPTIONAL');
    $hams_pkgs->setUpdatingStyle( 'UPDATE_ONLY', 'INDIVIDUAL');
    $::pkgdefs{'pkgs'}{$_server_}{$::HAMS_PKGS} = $hams_pkgs;
    $::pkgdefs{'pkgs'}{$_server_}{$::HAMS_PKGS}->setToBeUninstall( $::TRUE);
    $::pkgdefs{'pkgs'}{$_server_}{$::HAMS_PKGS}->setFastParsing( $::TRUE);
}
#-------------------------------------------------------------------------------
{
    my $csm_essl_pkg = new Rpm( 'csm.essl' ,"$::csm_version,$::csm_version");
    my $csm_gpfs_pkg = new Rpm( 'csm.gpfs',"$::csm_version,$::csm_version");
    my $csm_ll_pkg   = new Rpm( 'csm.ll',"$::csm_version,$::csm_version");
    my $csm_pessl_pkg= new Rpm( 'csm.pessl',"$::csm_version,$::csm_version");
    my $csm_pe_pkg   = new Rpm( 'csm.pe',"$::csm_version,$::csm_version");
    my $csm_bluegen_pkg = new Rpm( 'csm.bluegene',"$::csm_version,$::csm_version");
    my $rsct_64bit_pkg;
    # on i386, the arch of rsct.64bit is x86_64
    if ($::pkgdefs{"arch"} =~ /i.86/)
    {
        $rsct_64bit_pkg = new Rpm( 'rsct.64bit','','x86_64');
    }
    else
    {
        $rsct_64bit_pkg = new Rpm( 'rsct.64bit');
    }
    
    my $ms_update_only_pkgs = new RpmList(
        'Management Server Update Only Packages',    
        $csm_essl_pkg,
        $csm_gpfs_pkg,
        $csm_ll_pkg,
        $csm_pessl_pkg,
	$csm_pe_pkg,
        $csm_bluegen_pkg,
        $rsct_64bit_pkg
    );
    
    $ms_update_only_pkgs->setSearchingStyle( 'OPTIONAL');
	$ms_update_only_pkgs->setUpdatingStyle( 'UPDATE_ONLY', 'INDIVIDUAL');
    $ms_update_only_pkgs->setFastParsing( $::TRUE);
    $::pkgdefs{'pkgs'}{$_server_}{$::UPDATE_ONLY_PKGS} = $ms_update_only_pkgs;
    $::pkgdefs{'pkgs'}{$_server_}{$::UPDATE_ONLY_PKGS}->setToBeUninstall( $::TRUE);

    my $node_update_only_pkgs = new RpmList(
        'Managed Node Update Only Packages',
        $csm_bluegen_pkg,
        $rsct_64bit_pkg
    );    
    $node_update_only_pkgs->setSearchingStyle( 'OPTIONAL');
    $node_update_only_pkgs->setUpdatingStyle( 'UPDATE_ONLY', 'INDIVIDUAL');
    $node_update_only_pkgs->setToBeUninstall( $::TRUE);
    $node_update_only_pkgs->setFastParsing( $::TRUE);
    $::pkgdefs{'pkgs'}{$_node_}{$::UPDATE_ONLY_PKGS} = $node_update_only_pkgs;
}

#--------------------------------------------------------------------------------

=head3	csm_bin_copy_csm

	CSM binaries copied to /csminstall/csm directory

	Notes :

=cut

#--------------------------------------------------------------------------------
{

	my $a_ref = [
				 # files
				 '/opt/csm/csmbin/updatenode.client',
				 '/opt/csm/csmbin/nodestatus.client',
				 '/opt/csm/csmbin/nodestat.awk',
				 '/opt/csm/csmbin/syncServers.client',
				 '/opt/csm/csmbin/write_status',
				 '/opt/csm/msgmaps/csmInstall.csminstall.map',
				 '/opt/csm/pm/MessageUtils.pm',
				 '/opt/csm/pm/NodeUtils.pm',
				 '/opt/csm/pm/ApacheUtils.pm',
				 '/opt/csm/pm/ArchiveUtils.pm',
				 '/opt/csm/pm/InstallKRB5Utils.pm',
				 '/opt/csm/msgmaps/csmKRB5p.csmKRB5p_msg.map',
				 '/opt/csm/pm/NetworkUtils.pm',
				 '/opt/csm/pm/ServerUtils.pm',
				 '/opt/csm/pm/CSMDefs.pm',
				 '/opt/csm/msgmaps/nodecmds.NodeUtils.map',
				 '/opt/csm/csmbin/rmnode_client',
				 '/opt/csm/bin/setupconsole',
				 '/opt/csm/csmbin/makenode',
				 '/opt/csm/csmbin/csmprereboot',
				 '/opt/csm/csmbin/csmfirstboot',
				 '/opt/csm/csmbin/osfirstboot',
				 '/opt/csm/csmbin/setbootdisk',
				 '/opt/csm/csmbin/cfm_local',
				 '/opt/csm/csmbin/sms_local',
				 '/opt/csm/csmbin/updateRDMdserver',
				 '/opt/csm/csmbin/get_RDMdserver_config',
				 '/opt/csm/msgmaps/csmCFMlocal.cfm_local.map',
				 '/opt/csm/msgmaps/csmSMSlocal.sms_local.map',
                                 '/opt/csm/csmbin/getcloneimage.client',
				'/opt/csm/csmbin/csmfirstbootstrap',

				 # directories
				 '/opt/csm/install/defs',
				 '/opt/csm/install/pkgdefs',
				 '/opt/csm/pm/Rpm'
				];

	my $b_ref = [
				 # files
				 '/opt/csm/csmbin/nodestatus.client',
				 '/opt/csm/csmbin/nodestat.awk',
				 '/opt/csm/csmbin/syncServers.client',
				 '/opt/csm/csmbin/updateRDMdserver',
				 '/opt/csm/csmbin/get_RDMdserver_config',
				 '/opt/csm/csmbin/write_status',
				 '/opt/csm/msgmaps/csmInstall.csminstall.map',
				 '/opt/csm/pm/MessageUtils.pm',
				 '/opt/csm/pm/NodeUtils.pm',
				 '/opt/csm/pm/ApacheUtils.pm',
				 '/opt/csm/pm/ArchiveUtils.pm',
				 '/opt/csm/pm/InstallKRB5Utils.pm',
				 '/opt/csm/msgmaps/csmKRB5p.csmKRB5p_msg.map',
				 '/opt/csm/pm/NetworkUtils.pm',
				 '/opt/csm/pm/ServerUtils.pm',
				 '/opt/csm/pm/CSMDefs.pm',
				 '/opt/csm/msgmaps/nodecmds.NodeUtils.map',
				 '/opt/csm/csmbin/rmnode_client',
				 '/opt/csm/bin/setupconsole',
				 '/opt/csm/csmbin/csmprereboot',
				 '/opt/csm/csmbin/csmfirstboot',
				 '/opt/csm/csmbin/osfirstboot',
				 '/opt/csm/csmbin/setbootdisk',
				'/opt/csm/csmbin/csmfirstbootstrap',

				 # directories
				 '/opt/csm/install/defs',
				 '/opt/csm/install/pkgdefs',
				 '/opt/csm/pm/Rpm'
				];

	my $c_ref = [
				 # files
				 '/opt/csm/csmbin/updatenode.client',
				 '/opt/csm/csmbin/nodestatus.client',
				 '/opt/csm/csmbin/nodestat.awk',
				 '/opt/csm/csmbin/syncServers.client',
				 '/opt/csm/csmbin/write_status',
				 '/opt/csm/msgmaps/csmInstall.csminstall.map',
				 '/opt/csm/pm/MessageUtils.pm',
				 '/opt/csm/pm/NodeUtils.pm',
				 '/opt/csm/pm/ApacheUtils.pm',
				 '/opt/csm/pm/ArchiveUtils.pm',
				 '/opt/csm/pm/InstallKRB5Utils.pm',
				 '/opt/csm/msgmaps/csmKRB5p.csmKRB5p_msg.map',
				 '/opt/csm/pm/NetworkUtils.pm',
				 '/opt/csm/pm/ServerUtils.pm',
				 '/opt/csm/pm/CSMDefs.pm',
				 '/opt/csm/msgmaps/nodecmds.NodeUtils.map',
				 '/opt/csm/csmbin/rmnode_client',
				 '/opt/csm/bin/setupconsole',
				 '/opt/csm/csmbin/makenode',
				 '/opt/csm/csmbin/csmprereboot',
				 '/opt/csm/csmbin/csmfirstboot',
				 '/opt/csm/csmbin/osfirstboot',
				 '/opt/csm/csmbin/setbootdisk',
				 '/opt/csm/csmbin/cfm_local',
				 '/opt/csm/csmbin/sms_local',
				 '/opt/csm/csmbin/updateRDMdserver',
				 '/opt/csm/csmbin/get_RDMdserver_config',
				 '/opt/csm/msgmaps/csmCFMlocal.cfm_local.map',
				 '/opt/csm/msgmaps/csmSMSlocal.sms_local.map',
				'/opt/csm/csmbin/csmfirstbootstrap',
				 # directories
				 '/opt/csm/install/defs',
				 '/opt/csm/install/pkgdefs',
				 '/opt/csm/pm/Rpm'
				];

	# exceptions  - must follow the default assignments.
	$cbin_ref{'1.2.0'} = [
						  '/opt/csm/csmbin/updatenode.client',
						  '/opt/csm/csmbin/write_status',
						  '/opt/csm/msgmaps/csmInstall.csminstall.map',
						  '/opt/csm/pm/MessageUtils.pm',
						  '/opt/csm/pm/NodeUtils.pm',
						  '/opt/csm/pm/ApacheUtils.pm',
						  '/opt/csm/pm/ArchiveUtils.pm',
						  '/opt/csm/pm/InstallUtils.pm',
						  '/opt/csm/pm/NetworkUtils.pm',
						  '/opt/csm/pm/ServerUtils.pm',
						  '/opt/csm/pm/CSMDefs.pm',
						  '/opt/csm/msgmaps/nodecmds.NodeUtils.map',
						  '/opt/csm/csmbin/rmnode_client',
						  '/opt/csm/bin/setupconsole',
						  '/opt/csm/csmbin/makenode',
						  '/opt/csm/csmbin/csmprereboot',
						  '/opt/csm/csmbin/osprereboot',
						  '/opt/csm/csmbin/osfirstboot',
						  '/opt/csm/csmbin/csmfirstboot',
						  '/usr/bin/tftp',
						  '/opt/csm/install/defs',
						  '/opt/csm/install/pkgdefs'
						 ];

	$cbin_ref{'1.3.0'} = [
						  '/opt/csm/csmbin/updatenode.client',
						  '/opt/csm/csmbin/write_status',
						  '/opt/csm/msgmaps/csmInstall.csminstall.map',
						  '/opt/csm/pm/MessageUtils.pm',
						  '/opt/csm/pm/NodeUtils.pm',
						  '/opt/csm/pm/ApacheUtils.pm',
						  '/opt/csm/pm/ArchiveUtils.pm',
						  '/opt/csm/pm/InstallUtils.pm',
						  '/opt/csm/pm/NetworkUtils.pm',
						  '/opt/csm/pm/ServerUtils.pm',
						  '/opt/csm/pm/CSMDefs.pm',
						  '/opt/csm/msgmaps/nodecmds.NodeUtils.map',
						  '/opt/csm/csmbin/rmnode_client',
						  '/opt/csm/bin/setupconsole',
						  '/opt/csm/csmbin/makenode',
						  '/opt/csm/csmbin/csmprereboot',
						  '/opt/csm/csmbin/osprereboot',
						  '/opt/csm/csmbin/osfirstboot',
						  '/opt/csm/csmbin/csmfirstboot',
						  '/usr/bin/tftp',
						  '/opt/csm/install/defs',
						  '/opt/csm/install/pkgdefs'
						 ];

	$cbin_ref{'1.3.1'} = [
						  '/opt/csm/csmbin/updatenode.client',
						  '/opt/csm/csmbin/write_status',
						  '/opt/csm/msgmaps/csmInstall.csminstall.map',
						  '/opt/csm/pm/MessageUtils.pm',
						  '/opt/csm/pm/NodeUtils.pm',
						  '/opt/csm/pm/ApacheUtils.pm',
						  '/opt/csm/pm/ArchiveUtils.pm',
						  '/opt/csm/pm/InstallUtils.pm',
						  '/opt/csm/pm/NetworkUtils.pm',
						  '/opt/csm/pm/ServerUtils.pm',
						  '/opt/csm/pm/CSMDefs.pm',
						  '/opt/csm/msgmaps/nodecmds.NodeUtils.map',
						  '/opt/csm/csmbin/rmnode_client',
						  '/opt/csm/bin/setupconsole',
						  '/opt/csm/csmbin/makenode',
						  '/opt/csm/csmbin/setbootdisk',
						  '/opt/csm/csmbin/csmprereboot',
						  '/opt/csm/csmbin/osprereboot',
						  '/opt/csm/csmbin/osfirstboot',
						  '/opt/csm/csmbin/csmfirstboot',
						  '/usr/bin/tftp',
						  '/opt/csm/install/defs',
						  '/opt/csm/install/pkgdefs'
						 ];

	$cbin_ref{'1.3.2'} = [
						  '/opt/csm/csmbin/updatenode.client',
						  '/opt/csm/csmbin/write_status',
						  '/opt/csm/msgmaps/csmInstall.csminstall.map',
						  '/opt/csm/pm/MessageUtils.pm',
						  '/opt/csm/pm/NodeUtils.pm',
						  '/opt/csm/pm/ApacheUtils.pm',
						  '/opt/csm/pm/ArchiveUtils.pm',
						  '/opt/csm/pm/InstallUtils.pm',
						  '/opt/csm/pm/NetworkUtils.pm',
						  '/opt/csm/pm/ServerUtils.pm',
						  '/opt/csm/pm/CSMDefs.pm',
						  '/opt/csm/msgmaps/nodecmds.NodeUtils.map',
						  '/opt/csm/csmbin/rmnode_client',
						  '/opt/csm/bin/setupconsole',
						  '/opt/csm/csmbin/makenode',
						  '/opt/csm/csmbin/setbootdisk',
						  '/opt/csm/csmbin/csmprereboot',
						  '/opt/csm/csmbin/osprereboot',
						  '/opt/csm/csmbin/osfirstboot',
						  '/opt/csm/csmbin/csmfirstboot',
						  '/opt/csm/install/defs',
						  '/opt/csm/install/pkgdefs',
						  '/usr/sbin/rsct/cfg/ctsec.cfg',
						  '/usr/sbin/rsct/bin/runact-api',
						  '/opt/csm/csmbin/nodestatus.client'
						 ];
	$cbin_ref{'1.4.0'} = [
				 # files
				 '/opt/csm/csmbin/updatenode.client',
				 '/opt/csm/csmbin/nodestatus.client',
				 '/opt/csm/csmbin/nodestat.awk',
				 '/opt/csm/csmbin/syncServers.client',
				 '/opt/csm/csmbin/updateRDMdserver',
				 '/opt/csm/csmbin/get_RDMdserver_config',
				 '/opt/csm/csmbin/write_status',
				 '/opt/csm/msgmaps/csmInstall.csminstall.map',
				 '/opt/csm/pm/MessageUtils.pm',
				 '/opt/csm/pm/NodeUtils.pm',
				 '/opt/csm/pm/ApacheUtils.pm',
				 '/opt/csm/pm/ArchiveUtils.pm',
				 '/opt/csm/pm/InstallKRB5Utils.pm',
				 '/opt/csm/msgmaps/csmKRB5p.csmKRB5p_msg.map',
				 '/opt/csm/pm/NetworkUtils.pm',
				 '/opt/csm/pm/ServerUtils.pm',
				 '/opt/csm/pm/CSMDefs.pm',
				 '/opt/csm/msgmaps/nodecmds.NodeUtils.map',
				 '/opt/csm/csmbin/rmnode_client',
				 '/opt/csm/bin/setupconsole',
				 '/opt/csm/csmbin/makenode',
				 '/opt/csm/csmbin/csmprereboot',
				 '/opt/csm/csmbin/csmfirstboot',
				 '/opt/csm/csmbin/osfirstboot',
				 '/opt/csm/csmbin/setbootdisk',
				 # directories
				 '/opt/csm/install/defs',
				 '/opt/csm/install/pkgdefs',
				];

	$cbin_ref{'1.4.1'} = [
				 # files
				 '/opt/csm/csmbin/updatenode.client',
				 '/opt/csm/csmbin/nodestatus.client',
				 '/opt/csm/csmbin/nodestat.awk',
				 '/opt/csm/csmbin/syncServers.client',
				 '/opt/csm/csmbin/updateRDMdserver',
				 '/opt/csm/csmbin/get_RDMdserver_config',
				 '/opt/csm/csmbin/write_status',
				 '/opt/csm/msgmaps/csmInstall.csminstall.map',
				 '/opt/csm/pm/MessageUtils.pm',
				 '/opt/csm/pm/NodeUtils.pm',
				 '/opt/csm/pm/ApacheUtils.pm',
				 '/opt/csm/pm/ArchiveUtils.pm',
				 '/opt/csm/pm/InstallKRB5Utils.pm',
				 '/opt/csm/msgmaps/csmKRB5p.csmKRB5p_msg.map',
				 '/opt/csm/pm/NetworkUtils.pm',
				 '/opt/csm/pm/ServerUtils.pm',
				 '/opt/csm/pm/CSMDefs.pm',
				 '/opt/csm/msgmaps/nodecmds.NodeUtils.map',
				 '/opt/csm/csmbin/rmnode_client',
				 '/opt/csm/bin/setupconsole',
				 '/opt/csm/csmbin/makenode',
				 '/opt/csm/csmbin/csmprereboot',
				 '/opt/csm/csmbin/csmfirstboot',
				 '/opt/csm/csmbin/osfirstboot',
				 '/opt/csm/csmbin/setbootdisk',
				 # directories
				 '/opt/csm/install/defs',
				 '/opt/csm/install/pkgdefs',
				];

	$cbin_ref{'1.5.0'} = [
				 # files
				 '/opt/csm/csmbin/updatenode.client',
				 '/opt/csm/csmbin/nodestatus.client',
				 '/opt/csm/csmbin/nodestat.awk',
				 '/opt/csm/csmbin/syncServers.client',
				 '/opt/csm/csmbin/updateRDMdserver',
				 '/opt/csm/csmbin/get_RDMdserver_config',
				 '/opt/csm/csmbin/write_status',
				 '/opt/csm/msgmaps/csmInstall.csminstall.map',
				 '/opt/csm/pm/MessageUtils.pm',
				 '/opt/csm/pm/NodeUtils.pm',
				 '/opt/csm/pm/ApacheUtils.pm',
				 '/opt/csm/pm/ArchiveUtils.pm',
				 '/opt/csm/pm/InstallKRB5Utils.pm',
				 '/opt/csm/msgmaps/csmKRB5p.csmKRB5p_msg.map',
				 '/opt/csm/pm/NetworkUtils.pm',
				 '/opt/csm/pm/ServerUtils.pm',
				 '/opt/csm/pm/CSMDefs.pm',
				 '/opt/csm/msgmaps/nodecmds.NodeUtils.map',
				 '/opt/csm/csmbin/rmnode_client',
				 '/opt/csm/bin/setupconsole',
				 '/opt/csm/csmbin/makenode',
				 '/opt/csm/csmbin/csmprereboot',
				 '/opt/csm/csmbin/csmfirstboot',
				 '/opt/csm/csmbin/osfirstboot',
				 '/opt/csm/csmbin/setbootdisk',
				 # directories
				 '/opt/csm/install/defs',
				 '/opt/csm/install/pkgdefs',
				];

	$cbin_ref{'1.5.1'} = [
				 # files
				 '/opt/csm/csmbin/updatenode.client',
				 '/opt/csm/csmbin/nodestatus.client',
				 '/opt/csm/csmbin/nodestat.awk',
				 '/opt/csm/csmbin/syncServers.client',
				 '/opt/csm/csmbin/updateRDMdserver',
				 '/opt/csm/csmbin/get_RDMdserver_config',
				 '/opt/csm/csmbin/write_status',
				 '/opt/csm/msgmaps/csmInstall.csminstall.map',
				 '/opt/csm/pm/MessageUtils.pm',
				 '/opt/csm/pm/NodeUtils.pm',
				 '/opt/csm/pm/ApacheUtils.pm',
				 '/opt/csm/pm/ArchiveUtils.pm',
				 '/opt/csm/pm/InstallKRB5Utils.pm',
				 '/opt/csm/msgmaps/csmKRB5p.csmKRB5p_msg.map',
				 '/opt/csm/pm/NetworkUtils.pm',
				 '/opt/csm/pm/ServerUtils.pm',
				 '/opt/csm/pm/CSMDefs.pm',
				 '/opt/csm/msgmaps/nodecmds.NodeUtils.map',
				 '/opt/csm/csmbin/rmnode_client',
				 '/opt/csm/bin/setupconsole',
				 '/opt/csm/csmbin/makenode',
				 '/opt/csm/csmbin/csmprereboot',
				 '/opt/csm/csmbin/csmfirstboot',
				 '/opt/csm/csmbin/osfirstboot',
				 '/opt/csm/csmbin/setbootdisk',
				 # directories
				 '/opt/csm/install/defs',
				 '/opt/csm/install/pkgdefs',
				 #
				 '/usr/sbin/rsct/cfg/ctsec.cfg',
				 '/usr/sbin/rsct/bin/runact-api',
				];

	if ($cbin_ref{$::csm_version})
	{
		$::pkgdefs{csm_bin_copy_csm} = $cbin_ref{$::csm_version};
	}
	elsif(!defined($ENV{'DC_ENVIRONMENT'}) || $ENV{'DC_ENVIRONMENT'} eq "CSM" )
	{
		# CSM on HMC use separate csm_bin_copy_csm hash
		if (NodeUtils->isHMC())
		{
			$::pkgdefs{csm_bin_copy_csm} = $c_ref;
		}
		else
		{
			$::pkgdefs{csm_bin_copy_csm} = $a_ref;
		}
	}
	else
	{
		$::pkgdefs{csm_bin_copy_csm} = $b_ref;
	}
}

#--------------------------------------------------------------------------------

=head3	csm_bin_copy_tftpboot

	CSM binaries copied to /tftpboot directory
	Notes :

=cut

#--------------------------------------------------------------------------------
{

	my $a_ref = ['/usr/lib/syslinux/pxelinux.0'];

	$::pkgdefs{csm_bin_copy_tftpboot} = $a_ref;

}

#--------------------------------------------------------------------------------

=head3	logfiles

	CSM Log files ( used while uninstalling)

	Notes :

=cut

#--------------------------------------------------------------------------------
{

	my %lf_ref;

	$lf_ref{$_server_} = [
						  '/var/log/csm/csmsetupks.log*',
						  '/var/log/csm/installnode.log*',
						  '/var/log/csm/updatenode.log*',
						  '/var/log/csm/installms.log*'
						 ];

	$lf_ref{$_node_} = ['/var/log/csm/install.log*', '/var/opt/csm/cfmlocal*'];

	$::pkgdefs{logfiles} = $lf_ref{$::mgmt_type};

}

#--------------------------------------------------------------------------------

=head3	preinstall_execs

	files needed for the nodes during pre-install


	Notes :

=cut

#--------------------------------------------------------------------------------
{
	my %a_ref;
	$a_ref{$::csm_version} = [
							  "/opt/csm/csmbin/asu",
							  "/opt/csm/csmbin/lnxbios"
							  ];
	
	$::pkgdefs{preinstall_execs} = $a_ref{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	preinstall_libs

	files needed for the nodes during pre-install


	Notes :

=cut
#--------------------------------------------------------------------------------
{
	my $hl_ref = [
					'/lib/libc.so.6',
					'/lib/libNoVersion.so.1',
					'/usr/lib/libstdc++.so.5',
					'/lib/libm.so.6',
					'/lib/libdl.so.2',
					'/lib/libgcc_s.so.1',
					'/usr/lib/libstdc++-libc6.1-1.so.2',
					'/usr/lib/libstdc++-libc6.2-2.so.3',
				 ];

	$::pkgdefs{preinstall_libs} = $hl_ref;

}

#--------------------------------------------------------------------------------

=head3  pkgdefs defaults

        some requred support is not defined for all platforms and archs;
        these defaults are here to ensure that the data coming out of
        pkgdefs is consistent, regardless of the specific distributiion


        Notes :

=cut

#--------------------------------------------------------------------------------
{
	my $empty_ref = [];

	$::pkgdefs{getmacs_Exec}         = $empty_ref;    # getmacs
	$::pkgdefs{getmacs_Lib}          = $empty_ref;
	$::pkgdefs{getmacs_ReqLibs}      = $empty_ref;
	$::pkgdefs{getmacs_DirStructure} = $empty_ref;

	#$::pkgdefs{sp_disks}{QU1}        = $empty_ref;      # sp_disks
	#$::pkgdefs{sp_disks}{QU2}        = $empty_ref;

}

#--------------------------------------------------------------------------------

=head3	linux_diskid_match_prog

	default sub routine for matching linux distribution CD

	Notes :

=cut

#--------------------------------------------------------------------------------

sub linux_diskid_match_prog
{

	my ($base_dir, $ref) = @_;
	my ($hash_key, $hash_value, $key, $file_seq, $file, $orig_dir);

	foreach $hash_key (keys %$ref)
	{
		# Get the file sequence and its key
		# for example, 
		#	file1 => "media.1/products
		#	key1  => "/ SUSE-Linux-Enterprise-Server-i386 10"
		#	file2 => "ls-lR.gz"
		#	key2  => '\./DVD1:'
		if (my ($num) = ($hash_key =~ /^file(\d*)$/))
		{
			$file = $ref->{$hash_key};
			$key = $ref->{"key$num"};

			if (!$key) {return 0; }
			if (!-e "$base_dir/$file") { return 0; }

			my $cmd = "$::GREP \"$key\" $base_dir/$file";

			# Use ls-lR.gz to recognize SuSE CDs/DVDs
			if ($file =~ /\.gz$/)
			{
				$cmd = "$::GUNZIP -c $base_dir/$file | $::GREP \"$key\"";
			}
			NodeUtils->runcmd($cmd, -1);
			if ($::RUNCMD_RC) { return 0; }

		}
	}
		
	return 1;
}

#--------------------------------------------------------------------------------

=head3	rhel_diskid_match_prog

	Notes :

=cut

#--------------------------------------------------------------------------------

sub rhel_diskid_match_prog
{
	my ($base_dir, $ref) = @_;
	my ($orig_dir, $cmd, $file, $num, $rpm, $arch, $key);

	$file = $ref->{file};
	$key  = $ref->{key};
	$num  = $ref->{num};
	$arch = $ref->{arch};
	$rpm  = $ref->{rpm};

	if (!-e "$base_dir/$file") { return 0; }

	NodeUtils->runcmd("$::GREP \"$arch\" $base_dir/$file", -1);
	if ($::RUNCMD_RC) { return 0; }

	NodeUtils->runcmd("$::GREP \"$key\" $base_dir/$file", -1);
	if ($::RUNCMD_RC) { return 0; }

	$cmd = "$::HEAD -n 4 $base_dir/$file|$::TAIL -n 1";
	my $disknum = NodeUtils->runcmd($cmd, -1);
	# for DVD support, we need to compare the exact disk number
	if ($disknum ne $num) { return 0; }
	if ($rpm ne "")
	{
		NodeUtils->runcmd("$::LS $base_dir/$rpm", -1);
		if ($::RUNCMD_RC) { return 0; }
	}

	return 1;
}

#--------------------------------------------------------------------------------

=head3  csm_nouninstall_pkgs - Packages to NOT uninstall

        Notes:

=cut

#--------------------------------------------------------------------------------

{
	my $cnip_ref;

	$cnip_ref{$_server_}{$::csm_version}  = ['csm.core'];
	$cnip_ref{$_iserver_}{$::csm_version} = [];
	$cnip_ref{$_node_}{$::csm_version}    = [];
	$::pkgdefs{csm_nouninstall_pkgs} = $cnip_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	csm_uninstall_dirs - Directories to uninstall from the management server

        Notes:

=cut

#--------------------------------------------------------------------------------
{
	my %ocp_ref;

	# defaults
	$cud_ref{$_server_}{$::csm_version} = ['/csminstall', '/cfmroot'];

	$cud_ref{$_iserver_}{$::csm_version} = [];

	$cud_ref{$_node_}{$::csm_version} = [];

	# exceptions  - must follow the default assignments.
	# none

	$::pkgdefs{csm_uninstall_dirs} = $cud_ref{$::mgmt_type}{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	Diskless common information -
			Prerequisite directory in VNFS
			Necessary    service   in VNFS
        Notes:

=cut

#--------------------------------------------------------------------------------
{
	my %dir_ref;

	# Prerequisite directory in VNFS
	$dir_ref = ['/etc/sysconfig', '/etc/warewulf' , '/var/lib/rpm', '/dev' ,
				'/var/log', '/var/lock/rpm' ,'/var/run/hotplug', '/var/run/dbus'];


	$::pkgdefs{lx_diskless_dirs} = $dir_ref;
    # Warewulf initrd size
    # (get this vaule from warewulf command /usr/sbin/wwmkinitrd

    $::pkgdefs{ww_ramdisk_size} = "15360";

}

1; #end


