#!/usr/bin/perl
# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2000,2008 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
# -*- perl -*-
#
# @(#)29   1.147.1.192   src/csm/core/pm/NodeUtils.pm.perl, csmcore, csm_rgar2h, rgar2hs001a 3/15/08 11:46:02
#--------------------------------------------------------------------------------

package NodeUtils;

use strict;

#     locale tells perl to honor locale for sorting, dates, etc.
#     More info about locale.pm and perl handling of locales can be found in
#     /usr/lib/perl5/5.6.0/locale.pm and the man page for perllocale.
use locale;
use Socket;
use File::Basename;
use File::Path;    # Provides mkpath() and rmtree();
use POSIX ":sys_wait_h";    #for createAutoupdateDB
require MessageUtils;
require NetworkUtils;
require ServerUtils;
require ArchiveUtils;
if ( !$ENV{'RUNNING_DSH'}){
	require CSMDefs;
}
if ( -r $::csmpm . '/dsh/DSHCLI.pm')
{
    require $::csmpm . '/dsh/DSHCLI.pm';
}
my $msgs;
my $distro;
my $useTranslatedMsg;
my %catHashes;
my $csmroot;
my ($MSGCAT, $MSGMAPPATH, $MSGSET);
my $NO_NODERANGES;
my $NODEGROUPEXPMEM_WARNING = 1;

# $NodeUtils::NO_MESSAGES;    # Set this to 1 if you do not want NodeUtils to
# print any error msgs

# $NodeUtils::errno;          # Will be set if an error occurs.  You must zero
# this out before calling a NodeUtils function,
# if you want to check it afterwards.

BEGIN
{
	$::progname = basename $0;

	#    This enables us to redirect where it looks for other CSM files during development
	$csmroot = $ENV{'CSM_ROOT'} ? $ENV{'CSM_ROOT'} : '/opt/csm';

	$MSGCAT = 'nodecmds.cat';
	if (defined $NodeUtils::MSGMAPPATH)
	{
		$MSGMAPPATH = $ENV{'CSM_ROOT'} ? "$csmroot/msgmaps" : $NodeUtils::MSGMAPPATH;
	}
	else
	{
		$MSGMAPPATH = "$csmroot/msgmaps";
	}
	$MSGSET = 'NodeUtils';

	# set LD_ASSUME_KERNEL if effective distro is RHEL4 QU
	my $rh_relfile = "/etc/redhat-release";
	my $rh_vers    = 'Nahant Update';
	my $effective_vers = '4.1';
	if (-f $rh_relfile)
	{
		my $return = open FILE, "<$rh_relfile";
		if ($return)
		{
			my @contents = <FILE>;
			close FILE;
			my $lines = join '', @contents;
			if ($lines =~ m/$rh_vers/ || $lines =~ m/$effective_vers/)
			{
				$ENV{'LD_ASSUME_KERNEL'} = "2.4.19";
			}
		}
	}

    if ( ( $^O eq 'aix' || $^O eq 'AIX') &&
            ( $ENV{'MALLOCTYPE'} || $ENV{'MALLOCDEBUG'}))
    {
        delete $ENV{'MALLOCTYPE'};
        delete $ENV{'MALLOCDEBUG'};
    }

}

# Generally, we don't allow CSM commands to be run on a backup management server.
# However we do allow certain commands, and if the CSM_HAMS_CONTROL environment
# variable is set, we allow 'em all.
if (
	($::progname ne "nodestatus"
	)    # We have to allow nodestatus and write_status because they are
	&& ($::progname ne "write_status"
	)    # used by DMSRM, and the call to lsrsrc-api below would deadlock.
	     #
	&& ($::progname ne "csmconfig")  # You need to be able to install a license.
	&& ($::progname ne "dsh")  # You need to be able to dsh.
	&& ($::progname ne "dcp")  # You need to be able to dcp.
	&& ($::progname ne "ha_daemon_start") 
    && (!$ENV{'CSM_HAMS_CONTROL'})
    && (-f "/opt/csm/bin/hams")
   )    # You can run any CSM command if env var is set.
{
	my $hamode =
	  `CT_MANAGEMENT_SCOPE=1 lsrsrc-api -i -s IBM.DmsCtrl::::HAMode 2>/dev/null`;
	if (($hamode != 0) && ($hamode != 1))
	{
		MessageUtils->messageFromCat($MSGCAT, $MSGMAPPATH, $MSGSET, 'E1',
									 'EMsgCannotRunCSMCommands');
	}
}

umask(0022);   #  This sets umask for all CSM files so that group and world only
               #  have read permissions.
               #  To change it, simply use the umask call in your script, after
               #  the "use NodeUtils;" line

#--------------------------------------------------------------------------------

=head1    NodeUtils

=head2    Package Description

This program module file, supports the CSM/install Node dependencies, and
provides general utilities used by the node commands and a few other parts of
CSM.

If adding to this file, please take a moment to ensure that:

    1.  Your contrib has a readable pod header describing the purpose and use of
         your contrib.

    2. Your contrib is under the correct heading and is in alphabetical order
    under that heading.

    3. You test your contribution by running from the command line:  

       pod2html  --verbose --title=NodeUtils NodeUtils.pm.perl --outfile=NodeUtils.html
       
       and examining the ./NodeUtils.html file in a browser.

=cut

#--------------------------------------------------------------------------------

=head2    Package Dependancies

    package NodeUtils;


    use strict;

    locale tells perl to honor locale for sorting, dates, etc.
    More info about locale.pm and perl handling of locales can be found in
    /usr/lib/perl5/5.6.0/locale.pm and the man page for perllocale.

    use locale;
    use Socket;
    use MessageUtils;
    use NetworkUtils;


=cut

#--------------------------------------------------------------------------------

=head2    Global "umask" Setting


    umask(0022);

    umask  sets umask for all CSM files so that group and world
    only have read permissions.  To change it, simply use the
    umask call in your script, after the "use NodeUtils;" line

=cut

#--------------------------------------------------------------------------------

=head1  Subroutines by Functional Group

=cut

#--------------------------------------------------------------------------------

=head2    Misc Tools

=cut

#--------------------------------------------------------------------------------

=head3    csm_license_valid

    Check the status of a CSM License.

    Arguments:
        none
    Returns:
          1 -    a CSM license exists & is not expired
          0 -    no license exists or it has expired
    Globals:
        none
    Error:
        see returns
    Example:
        not used
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub csm_license_valid
{
	my $output =
	  NodeUtils->runcmd("/usr/bin/runact-api -c IBM.DmsCtrl::::isLicenseValid", -1);

	if ($::RUNCMD_RC || !$output || $output =~ /::0$/)
	{
		return 0;
	}
	else
	{
		return 1;
	}
}

#--------------------------------------------------------------------------------

=head3    equalArrays

    Compares 2 arrays and returns true if they are the same length and all
    of their elements are equal.  Both arrays are references.

    Arguments:
        ref_array1
        ref_array2
    Returns:
        bool_ret - 1 or 0
    Globals:
        none
    Error:
        none
    Example:
        unused
    Comments:
        unused

=cut

#--------------------------------------------------------------------------------

sub equalArrays
{
	my ($class, $a1, $a2) = @_;
	my $len1 = scalar(@$a1);
	if ($len1 != scalar(@$a2)) { return 0; }
	for (my $i = 0 ; $i < $len1 ; $i++)
	{
		if ($$a1[$i] ne $$a2[$i]) { return 0; }
	}
	return 1;
}

#--------------------------------------------------------------------------------

=head3    isAIX

    returns 1 if localHost is AIX

    Arguments:
        none
    Returns:
        1 - localHost is AIX
        0 - localHost is some other platform
    Globals:
        none
    Error:
        none
    Example:
         if (NodeUtils->isAIX()) { blah; }
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub isAIX
{
	if ($^O =~ /^aix/i) { return 1; }
	else { return 0; }
}

#--------------------------------------------------------------------------------

=head3    isLinux

    returns 1 if localHost is Linux

    Arguments:
        none
    Returns:
        1 - localHost is Linux
        0 - localHost is some other platform
    Globals:
        none
    Error:
        none
    Example:
         if (NodeUtils->isLinux()) { blah; }
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub isLinux
{
	if ($^O =~ /^linux/i) { return 1; }
	else { return 0; }
}

#--------------------------------------------------------------------------------

=head3    ispLinux

    returns 1 if localHost is pLinux

    Arguments:
        none
    Returns:
        1 - localHost is pLinux
        0 - localHost is some other platform
    Globals:
        none
    Error:
        none
    Example:
         if (NodeUtils->ispLinux()) { blah; }
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub isPLinux
{
	my $arch = `/bin/uname -m`;
	chomp($arch);
	if ($arch eq "ppc64") { return 1; }
	else { return 0; }
}

#--------------------------------------------------------------------------------

#--------------------------------------------------------------------------------

=head3    isSELinux

    returns 1 if localHost is SELinux

    Arguments:
        none
    Returns:
        1 - localHost is SELinux
        0 - localHost is some other platform
    Globals:
        none
    Error:
        none
    Example:
         if (NodeUtils->isSELinux()) { blah; }
    Comments:
        none

=cut
#-------------------------------------------------------------------------------
sub isSELinux
{

	 # if # If the chcon (change context)
	 #command exists, then this OS supports SELInux
	 if (-f "/usr/bin/chcon")
	 {
        # Now check to see if SELinux is active
		#in this kernel
		# (Don't show errors, just get rc)
		# Since $::LS --context doesn't work in RHEL5 , so we use selinuxenabled command
		# instead of it.
		# NodeUtils->runcmd("$::LS --context", -1);
		# the pathname of selinuxenabled command is /usr/sbin/selinuxenabled in RedHat
		# /usr/bin/selinuxenabled in SLES.
		NodeUtils->runcmd("$::SELINUXENABLED", -1);
		if (!$::RUNCMD_RC)
		{    # yes we are in SElinux
			return 1;
		}
		else
		{
		  return 0;
		}
     }
	 return 0; 
}


#--------------------------------------------------------------------------------

=head3    isMgmtSvr

    returns 1 if localHost is a CSM Management Server

    Arguments:
        none
    Returns:
        1 - localHost is a Managment Sever
        0 - localHost is not
    Globals:
        none
    Error:
        none
    Example:
         if (NodeUtils->isMgmtSvr()) { blah; }
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub isMgmtSvr
{

	# Note: we could check for the csm.server, but that check is slower and OS dependent.
	#  checks for deployment component running, cannot be an ms with DC active 
	if (   -f '/usr/bin/lsrsrc-api'
		&& -f '/usr/sbin/rsct/bin/IBM.DMSRMd'
		&& ($ENV{'DC_ENVIRONMENT'} ne 1))
	{
		return 1;
	}
	else { return 0; }
}

#--------------------------------------------------------------------------------

=head3    isNode

    returns 1 if localHost is CSM node or Management Server.

    Arguments:
        none
    Returns:
        1 - localHost is a CSM Node or Management Sever
        0 - localHost is neither
    Globals:
        none
    Error:
        none
    Example:
         if (NodeUtils->isNode()) { blah; }
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub isNode
{

	# Note: we could check for the csm.client, but that check is slower and OS dependent.
	if (-f '/usr/bin/lsrsrc-api' && -f '/usr/sbin/rsct/bin/IBM.CSMAgentRMd')
	{
		return 1;
	}
	else { return 0; }
}

#--------------------------------------------------------------------------------

=head3    isRoot

    returns 1 if the effective user running this subroutine is the root user.

    Arguments:
        none
    Returns:
        1 - effective user is root
        0 - effective user is not root.
    Globals:
        none
    Error:
        none
    Example:
         if (NodeUtils->isRoot()) { blah; }
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub isRoot { return $> == 0; }

#--------------------------------------------------------------------------------

#--------------------------------------------------------------------------------

=head3	setServiceLevel

        Notes:
		Set the InstallServiceLevel attribute of each node in the nodelist argument.
		for example, NodeUtils->setServiceLevel(\@::NODELIST, $service_level);
		Return:
		Returns 1 on success, 0 on failure.
=cut

#--------------------------------------------------------------------------------

sub setServiceLevel
{
	my ($class, $nodelist, $svclevel) = @_;

	my ($res2unres, $attrvals);
	my $where = '';  # when we do not specify a where string, we get everything.

	if ($svclevel eq undef)
	{
		return 0;
	}

	($nodelist, $res2unres) = NodeUtils->resolveAndUndup($nodelist);
	$where = qq/"Hostname IN ('XXX')"/;
	$attrvals = "InstallServiceLevel::$svclevel";
	foreach my $node (@$nodelist)
	{
		$::NODEHASH{$node}{InstallServiceLevel} = $svclevel;
	}
	NodeUtils->runrmccmd('chrsrc-api', '-i',
						 qq(-s IBM.ManagedNode::${where}::$attrvals),
						 undef, $nodelist);
	return 1;
}

#--------------------------------------------------------------------------------

=head3	getServiceLevel

        Notes:
		Qeury the database for the InstallServiceLevel attribute of each node in the nodelist argument.
		Returns the array containing different InstallServiceLevel attribute of these nodes.
		for example, NodeUtils->getServiceLevel(\@::NODELIST);
		Return:
		Arrary of different service levels.
=cut

#--------------------------------------------------------------------------------

sub getServiceLevel
{
	my ($class, $nodelist) = @_;

	my @service_levels = ();

	# Check whether it's already in the list.
	foreach my $node (@$nodelist)
	{
		if (!$::NODEHASH{$node}{InstallServiceLevel}) { next; }
		my $f = 1;
		foreach my $s (@service_levels)
		{
			if ($s eq $::NODEHASH{$node}{InstallServiceLevel})
			{
				$f = 0;
				last;
			}
		}
		if ($f)
		{
			push @service_levels, $::NODEHASH{$node}{InstallServiceLevel};
		}
	}

	return @service_levels;
}

#--------------------------------------------------------------------------------

=head3	getNodeServiceLevel

        Notes:
		Get InstallServiceLevel attribute of the specified node by querying database.
		Just a wrapper around getServiceLevel().
		Return:
		service level of the node.
=cut

#--------------------------------------------------------------------------------
sub getNodeServiceLevel
{
	my ($class, $node) = @_;
	return $::NODEHASH{$node}{InstallServiceLevel};
}

#--------------------------------------------------------------------------------

=head3	checkServiceLevelCase

        Notes:
			Check the InstallServiceLevel value. If it is lower case, return -1. Otherwise return 0.
=cut

#--------------------------------------------------------------------------------

sub checkServiceLevelCase
{
	my ($class, $svclevel) = @_;
	my $ret = 0;

	if (   ($svclevel ne "GA")
		&& ($svclevel !~ /^QU[1-9]$/)
		&& ($svclevel !~ /^SP[1-9]$/)
		&& ($svclevel !~ /^SP[1-9]A$/))
	{
		$svclevel = uc($svclevel);
		if (   ($svclevel eq "GA")
			|| ($svclevel =~ /^QU[1-9]$/)
			|| ($svclevel =~ /^SP[1-9]$/)
			|| ($svclevel =~ /^SP[1-9]A$/))
		{
			$ret = -1;
		}
	}
	return $ret;
}

#--------------------------------------------------------------------------------

=head3    programName

     Return the name of the perl script currently being executed, w/o the path.

    Arguments:
        none
    Returns:
        program name without the path
    Globals:
        none
    Error:
        none
    Example:
         return NodeUtils->programName() . ":  Houstin , we have a problem.\n";
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub programName
{
	my $progname = $0;
	$progname =~ s|.*/([^/]+?)$|$1|;    # on linux we have to strip the path
	return $progname;
}

#--------------------------------------------------------------------------------

=head3    quote

    Quote a string, taking into account embedded quotes.  This function is most
    useful when passing string through the shell to another cmd.  It handles one
    level of embedded double quotes, single quotes, and dollar signs.

    Arguments:
        string to quote
    Returns:
        quoted string
    Globals:
        none
    Error:
        none
    Example:
         if (defined($$opthashref{'WhereStr'})) {
            $where = NodeUtils->quote($$opthashref{'WhereStr'});
        }
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub quote
{
	my ($class, $str) = @_;

	# if the value has imbedded double quotes, use single quotes.  If it also has
	# single quotes, escape the double quotes.
	if (!($str =~ /\"/))    # no embedded double quotes
	{
		$str =~ s/\$/\\\$/sg;    # escape the dollar signs
		$str =~ s/\`/\\\`/sg;
		$str = qq("$str");
	}
	elsif (!($str =~ /\'/))
	{
		$str = qq('$str');
	}       # no embedded single quotes
	else    # has both embedded double and single quotes
	{

		# Escape the double quotes.  (Escaping single quotes does not seem to work
		# in the shells.)
		$str =~ s/\"/\\\"/sg;    #" this comment helps formating
		$str =~ s/\$/\\\$/sg;    # escape the dollar signs
		$str =~ s/\`/\\\`/sg;
		$str = qq("$str");
	}
}

#--------------------------------------------------------------------------------

=head3    readFile

    Read a file and return its content.

    Arguments:
        filename
    Returns:
        file contents or undef
    Globals:
        none
    Error:
        undef
    Example:
        my $blah = NodeUtils->readFile('/etc/redhat-release');
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub readFile
{
	my ($class, $filename) = @_;
	open(FILE, "<$filename") or return undef;
	my @contents;
	@contents = <FILE>;
	close(FILE);
	if (wantarray) { return @contents; }
	else { return join('', @contents); }
}
#--------------------------------------------------------------------------------

=head3    checkWarewulf

    Check the following warewulf installation prerequisite:
        1. Disable SELinux .
        2. YUM open source packages installed.
        3. Warewulf open source packages installed.

    Arguments:
        filename
    Returns:
        1 -- all needed conditions match
        0 -- at least one condition miss
    Globals:
        none
    Error:
        undef
    Example:
        $ret = NodeUtils->checkWarewulf();
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub checkWarewulf
{
	my ($class) = @_;
    my $ret;
    $ret = 1;
    # Avoid repeated query.
    if ($::WarewulfEnvCheck)
    {
        return $::WarewulfEnv;
    }
    # Creating VNFS need disabling SELinux
 	if (NodeUtils->isSELinux)
    {
        MessageUtils->messageFromCat(
            'csmInstall.cat',
            $::MSGMAPPATH,
            'csminstall',
            'E',
            'EMsgDisableSELinux',
        );
        $ret = 0;
    }
    # Yum needed to create VNFS on install server
    if (!NodeUtils->isYumInstalled())
    {
         MessageUtils->messageFromCat(
            'csmInstall.cat',
            $::MSGMAPPATH,
            'csminstall',
            'E',
            'EMsgYumNotInstalled'
        );
        $ret = 0;
    }
    if (!NodeUtils->isWarewulfInstalled())
    {
        $ret = 0;
    }
    # Set query flag, check has been done.
    $::WarewulfEnvCheck = 1;
    $::WarewulfEnv = $ret;
    NodeUtils->runcmd("$::RM -f /var/tmp/warewulf-ready");
    if ($ret)
    {
        NodeUtils->runcmd("$::TOUCH  /var/tmp/warewulf-ready");
    }  
    return $ret;
}
#--------------------------------------------------------------------------------

=head3    isWarewulfInstalled

    Check whether warewulf packages (warewulf and warewulf-tools) 
    are installed or not on install server:
    
    Arguments:
    Returns:
        1 -- installed
        0 -- not installed
    Globals:
        none
    Error:
        undef
    Example:
        $ret = NodeUtils->isWarewulfInstalled();
    Comments:
        The version of Warewulf packages should be more than 2.6.2

=cut

#--------------------------------------------------------------------------------

sub isWarewulfInstalled
{
	my ($class) = @_;
    my $ret;
    my $lost_pkgs = "";
    $ret = 1;
    my ($cmd, $output, $rpm, $version, $release, $v1, $v2, $v3, $v4, $rest);
    foreach my $package ("warewulf", "warewulf-tools")
    {
        $cmd = "$::RPMCMD -q $package";
        $output = NodeUtils->runcmd($cmd,-1);
        chomp($output);
        if ($::RUNCMD_RC != 0)
        {
            $lost_pkgs.= "$package ";
            $ret = 0;
        }
        ($rpm, $version, $release) = split(/-/, $output);
        if ( $version ne "" 
           && 
            (  ($version < 2.6.2)
             || ($version >= 3.0)
             )
         )
        {
            $ret =  0;
        }
    }
    if (!$ret)
    {
        # Warewulf packages are not installed or version mismatchs (2.6.2<=version<3.0)
        MessageUtils->messageFromCat(
            'csmInstall.cat',
            $::MSGMAPPATH,
            'csminstall',
            'E',
            'EMsgWarewulfNotInstalled',
            $lost_pkgs
        );
    }
    return $ret;
}
#--------------------------------------------------------------------------------

=head3    isYumInstalled

    Check whether yum package be installed or not on install server
    
    Arguments:
    Returns:
        1 -- installed
        0 -- not installed
    Globals:
        none
    Error:
        undef
    Example:
        $ret = NodeUtils->isYumInstalled();
    Comments:
        None.
=cut

#--------------------------------------------------------------------------------

sub isYumInstalled
{
	my ($class) = @_;
    my ($ret, $cmd, $output);
    $ret = 1;
    my ( $distro_name, $distro_ver, undef, $arch)
         = NodeUtils->getDistroAndSvcLevel;
    # In SLES9/10 x86_64, yum need PYTHONPATH environment variable
    # We need to add special case .

    if (  $distro_name =~ /SLES/
        && $distro_ver eq '9'
        && $arch =~ /x86_64/)
    {
        $ENV{'PYTHONPATH'} ="/usr/lib/python2.3/site-packages/";
    }
    if (  $distro_name =~ /SLES/
        && $distro_ver eq '10'
        && $arch =~ /x86_64/)
    {
        $ENV{'PYTHONPATH'} ="/usr/lib/python2.4/site-packages/";
    } 

    if (-e "$::YUM")
    {
        $cmd = "$::YUM --version";
        $output = NodeUtils->runcmd($cmd,-1);
        if ($::RUNCMD_RC != 0)
        {
            print "$output\n";
            $ret = 0;
        }
    }
    else
    {
        $ret = 0;
    }
    return $ret;
}


#-------------------------------------------------------------------------------

=head3

    isRMrunning

        Check whether the resource manager is running 

    Arguments:
        $resMan  -  resource manager name, such as "IBM.DMSRM" 

    Returns:
        1 - the resource manager is running
        0 - the resource manager is not running

    Example:
        if (!NodeUtils->isRMrunning($dmsrm))

=cut

#-------------------------------------------------------------------------------
sub isRMrunning()
{
	my ($class, $resMan) = @_;
	my $rc = 0;
	my $className;

    if (!grep(/^$resMan$/, @::WILLDOWNRM))
    {
        # $resMan will not be down gracefully, follow the original logic
        my @output = NodeUtils->runcmd("LANG=C /usr/bin/lssrc -s $resMan", -1);
        if ($::RUNCMD_RC) { return 0; }   # maybe we should try to catch real errors here
        my ($subsys, $group, $pid, $status) = split(' ', $output[1]);
        if (defined($status) && $status eq 'active') {
        #now check to see if the RM is up
        return 1;
        }
        return 0;
    }

    # $resMan will be down gracefully, use new api command
    # Since lsrsrc-api needs the ClassName as the input parameter
    # So we pick one class name per RM.
    $className = NodeUtils->getClassNamebyRM($resMan);
    if (!$className)
    {
        # fail to get Class Name
        return 0;
    }

	my $para = "$className"."::Variety";
	my $output = NodeUtils->runcmd("LANG=C /usr/bin/lsrsrc-api -c $para", -1);
	if ($::RUNCMD_RC)
	{
	    my @errmsg = split /:+/, $output;
	    my $errcode = $errmsg[3];
	    my $function = $errmsg[2];
	    # RMC is down
	    # for example: "ERROR::::5::mc_start_session::2::lsrsrc-api: 2612-022 A session could not be established with the RMC daemon on "local_node""
	    if ($errcode == 2 && $function eq "mc_start_session")
	    {
	        # start RMC
	        NodeUtils->runcmd("/usr/bin/rmcctrl -s", -1);
	        if ($::RUNCMD_RC)
	        {
	            return 0; # Can not start RMC
	        }
	        sleep 5;
	        # RMC is running now
	        $output = NodeUtils->runcmd("LANG=C /usr/bin/lsrsrc-api -c $para", -1);
	        if ($::RUNCMD_RC ==0)
	        {
	            $rc = 1;
	        }
	        else
	        {
	            # RM does not start
     	        # maybe the RM is down by user
	            $rc = 0;
	        }
	    }
	    else
	    {
	        # some other error than RMC down
	        # maybe the RM is down by user
	        # for example: "ERROR::IBM.Host::1::mc_class_query_p_bp::262154::2610-415 Cannot execute the command. The resource manager IBM.HostRM is not available."
	        $rc = 0;
	    }
	}
    else
    {
        $rc = 1;
    }
    return $rc;
}
  
#-------------------------------------------------------------------------------

=head3

    checkFilesetExist

        Check whether the file set exist or not 

    Arguments:
        @fileset  -  the array of the file set.

    Returns:
        1 - the file set exists
        0 - at least one file missing

    Example:
        my $all_exist = NodeUtils->checkFilesetExist(@image_check_list);

=cut

#-------------------------------------------------------------------------------
sub checkFilesetExist
{
  my $class = shift;
  my @fileset = @_;
  my $all_exist = 1;
  foreach my $file (@fileset)
  {
      if (! -f $file)
      {
          $all_exist = 0;
          last;
      }
  }
  return $all_exist;
      
}
#--------------------------------------------------------------------------------

=head2    Attribute Layer

=cut

#--------------------------------------------------------------------------------

=head3    checkForNotFound

        Checks to see if listnodeattrs couldn't find some nodes.

        Arguments:
                $nodeList

        Returns:
                none.
        Globals:
            $::LISTNODEATTRS_NUMNOTFOUND
        Error:
                E12
        Example:
                NodeUtils->checkForNotFound($refnodes);
        Comments:
                none

=cut

#-------------------------------------------------------------------------#

sub checkForNotFound
{
	my ($class, $nodelist) = @_;
	if ($::LISTNODEATTRS_NUMNOTFOUND)
	{
		if (scalar(@$nodelist) == 1)
		{
			MessageUtils->messageFromCat('nodecmds.cat', $::MSGMAPPATH,
						  'lsnode', 'E12', 'EMsgNODE_NOT_FOUND', $$nodelist[0]);
		}
		elsif (scalar(@$nodelist) <= 10)
		{
			MessageUtils->messageFromCat('nodecmds.cat', $::MSGMAPPATH,
									 'lsnode', 'W12', 'EMsgSOME_NOT_FOUND_LIST',
									 join(', ', @$nodelist));
		}
		else
		{
			MessageUtils->messageFromCat('nodecmds.cat', $::MSGMAPPATH,
										 'lsnode', 'W12', 'EMsgSOME_NOT_FOUND');
		}
	}
}

#--------------------------------------------------------------------------------

=head3    check_valid_install_distros

        Check whether current node's InstallDistributionName and
        InstallDistributionVersion is valid for full installation 

        Arguments:
                $installMethod
                $distro
        Returns:
                -1 - couldn't find valid install distro
                 0 - found valid install distro
        Globals:
                none
        Error:
                -1 - on failure
        Example:
                 my $rc =
                   NodeUtils->check_valid_install_distros("autoyast",$distro);
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub check_valid_install_distros
{
	my ($class, $installmethod, $distro) = @_;
	my @VALID_AUTOYAST_DISTROS = ('SLES8.1', 'SLES9', 'SLES10');

	if (!grep(/^$distro$/, @VALID_AUTOYAST_DISTROS))
	{
		return -1;
	}
	return 0;
}

#--------------------------------------------------------------------------------

=head3	common_install_method

        Test that the install method attribute is identical
	across all the nodes in the global %::NODEHASH.

        Arguments:
                uses global below
        Returns:
                a scalar value of the InstallMethod node attribute held in
		common by all nodes in the %::NODEHASH ( "kickstart" || "yast" ).
        Globals:
                %::NODEHASH - input list of nodes to check
        Error:
                Exits with an error if the InstallMethod attribute is not
                the same on all the nodes. 
        Example:
                $::INSTALL_METHOD  = NodeUtils->common_install_method();
        Comments:

		May be used in conjuction with "NodeUtils->get_common_attrs()"
		but this routine exists to handle an idiosyncracy in installnode().

		NOTE:  **** THIS SUBROUTINE IS CURRENTLY UNUSED ****

=cut

#--------------------------------------------------------------------------------

sub common_install_method
{

	my $const_attr = 0;                   # the InstallMethod value
	my @hosts      = keys %::NODEHASH;    # all hosts
	my $test_host  = @hosts[0];           # just get the first one

	if ($test_host)                       # not empty
	{

		# constant value to test against
		$const_attr = $::NODEHASH{$test_host}{'InstallMethod'};

	}
	else
	{
		MessageUtils->messageFromCat(
									 'csmInstall.cat', $::MSGMAPPATH,
									 'csminstall',     'E',
									 'EMsgNO_ATTR',    'InstallMethod'
									);
	}

	# go through all hosts and compare InstallMethod to $const_attr

	foreach $test_host (@hosts)
	{
		my $next_hash_value = $::NODEHASH{$test_host}{'InstallMethod'};

		if ($next_hash_value ne $const_attr)
		{
			MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
					 'csminstall', 'E1', 'EMsgDIFFERENT_ATTR', 'InstallMethod');
		}
	}

	return $const_attr;
}

#-------------------------------------------------------------------------#

=head3    getBladeStatus

        Returns a reference to a hash of nodeName/[yes|no].  Determines whether each
    node in the array is or is not a blade.

        Arguments:
                @node_list  -  an array of nodesNames.
        Returns:
                A hash ref of { node => yes or no }
        Error:
                none
        Example:
                $ref_bladeStatus = NodeUtils->getBladeStatus(@goodNodes);
        Comments:
                getBladeStatus will not verify that the nodes are defined in
        the Database.

=cut

#--------------------------------------------------------------------------------

sub getBladeStatus
{

	# local variables.
	my ($node, $nodes, %nodes, $rc, $rv, $cmd, @stdout, $line);

	# first strip the class name:
	shift;

	# need to do 50 at a time so that we don't have scaling problems.
	$nodes = join(',', @_);

	# the command to find out whether we have a blade or not is this:
	$cmd = "/opt/csm/bin/lshwstat -n $nodes blade";

	# do runcmd, but do not exit if there is an error.  Just
	# set the return code.
	@stdout = NodeUtils->runcmd("$cmd");
	foreach $line (@stdout)
	{
		($node, $rv) = split(': ', $line);
		$nodes{$node} = $rv;
	}
	return \%nodes;
}

#--------------------------------------------------------------------------------

=head3    get_common_attrs

        Get the common attributes across all the nodes for the follwoing attrs:

                InstallDistributionName 
                InstallDistributionVersion 
                InstallPkgArchitecture 
                InstallCSMVersion 

        Arguments:
		$nodelist_ref - The node list to get attributes. If it did not 
		set, uses global variable %::NODEHASH.
        Returns:
		Array of common attribute values on success

        Globals:
                %::NODEHASH - input list of nodes to check
        Error:
                Exits with an error if one of the attributes is not
                the same on all the nodes in %::NODEHASH 
        Example:
                ($::DISTRO_NAME,
                $::DISTRO_VERSION,
                $::ARCH,
                $::CSM_VERSION ) = NodeUtils->get_common_attrs();
        Comments:


=cut

#--------------------------------------------------------------------------------

sub get_common_attrs
{
	my ($class, $nodelist_ref) = @_;

	my @nodelist;
	if ($nodelist_ref)
	{
		@nodelist = @$nodelist_ref;
	}
	else
	{
		@nodelist = (keys %::NODEHASH);
	}

	my ($hostname, $distro_name, $distro_version, $arch, $csm_version);

	my ($InstallDistributionName);
	my ($InstallDistributionVersion);
	my ($InstallPkgArchitecture);
	my ($InstallCSMVersion);

	my ($errors)                           = 0;
	my $InstallCSMVersion_Err_Flg          = 0;
	my $InstallPkgArchitecture_Err_Flg     = 0;
	my $InstallDistributionVersion_Err_Flg = 0;
	my $InstallDistributionName_Err_Flg    = 0;
	my $DistributionName_Err_Flg           = 0;
	my $DistributionVersion_Err_Flg        = 0;
	my $PkgArchitecture_Err_Flg            = 0;
	my $CSMVersion_Err_Flg                 = 0;

	foreach $hostname (@nodelist)
	{
		$InstallDistributionName =
		  $::NODEHASH{$hostname}{'InstallDistributionName'};
		$InstallDistributionVersion =
		  $::NODEHASH{$hostname}{'InstallDistributionVersion'};
		$InstallPkgArchitecture =
		  $::NODEHASH{$hostname}{'InstallPkgArchitecture'};
		$InstallCSMVersion = $::NODEHASH{$hostname}{'InstallCSMVersion'};

		if (!$distro_name)    { $distro_name    = $InstallDistributionName; }
		if (!$distro_version) { $distro_version = $InstallDistributionVersion; }
		if (!$csm_version)    { $csm_version    = $InstallCSMVersion; }
		if (!$arch)           { $arch           = $InstallPkgArchitecture; }

		if ("$distro_name" and ($InstallDistributionName ne $distro_name))
		{
			$errors++;
			$InstallDistributionName_Err_Flg++;
		}

		if ("$distro_version"
			and ($InstallDistributionVersion ne $distro_version))
		{
			$errors++;
			$InstallDistributionVersion_Err_Flg++;
		}

		if ("$arch"
			and ($InstallPkgArchitecture ne $arch))
		{
			$errors++;
			$InstallPkgArchitecture_Err_Flg++;
		}

		if ("$csm_version"
			and ($InstallCSMVersion ne $csm_version) and !$::HWMAINT)
		{
			$errors++;
			$InstallCSMVersion_Err_Flg++;
		}
	}

	if (!$distro_name)
	{
		$errors++;
		$DistributionName_Err_Flg++;
	}
	if (!$distro_version)
	{
		$errors++;
		$DistributionVersion_Err_Flg++;
	}
	if (!$arch)
	{
		$errors++;
		$PkgArchitecture_Err_Flg++;
	}
	if (!$csm_version && !$::HWMAINT)
	{
		$errors++;
		$CSMVersion_Err_Flg++;
	}

	if ($InstallDistributionName_Err_Flg > 0)
	{
		MessageUtils->messageFromCat(
									 'csmInstall.cat',
									 $::MSGMAPPATH,
									 'csminstall',
									 'E',
									 'EMsgDIFFERENT_ATTR',
									 'InstallDistributionName'
									);
	}
	if ($InstallDistributionVersion_Err_Flg > 0)
	{
		MessageUtils->messageFromCat(
									 'csmInstall.cat',
									 $::MSGMAPPATH,
									 'csminstall',
									 'E',
									 'EMsgDIFFERENT_ATTR',
									 'InstallDistributionVersion'
									);
	}
	if ($InstallPkgArchitecture_Err_Flg > 0)
	{
		MessageUtils->messageFromCat(
									 'csmInstall.cat',
									 $::MSGMAPPATH,
									 'csminstall',
									 'E',
									 'EMsgDIFFERENT_ATTR',
									 'InstallPkgArchitecture'
									);
	}
	if ($InstallCSMVersion_Err_Flg > 0)
	{
		MessageUtils->messageFromCat(
									 'csmInstall.cat',
									 $::MSGMAPPATH,
									 'csminstall',
									 'E',
									 'EMsgDIFFERENT_ATTR',
									 'InstallCSMVersion'
									);
	}
	if ($DistributionName_Err_Flg > 0)
	{
		MessageUtils->messageFromCat(
									 'csmInstall.cat',
									 $::MSGMAPPATH,
									 'csminstall',
									 'E',
									 'EMsgNO_ATTR',
									 'InstallDistributionName'
									);
	}
	if ($DistributionVersion_Err_Flg > 0)
	{
		MessageUtils->messageFromCat(
									 'csmInstall.cat',
									 $::MSGMAPPATH,
									 'csminstall',
									 'E',
									 'EMsgNO_ATTR',
									 'InstallDistributionVersion'
									);
	}
	if ($PkgArchitecture_Err_Flg > 0)
	{
		MessageUtils->messageFromCat(
									 'csmInstall.cat',
									 $::MSGMAPPATH,
									 'csminstall',
									 'E',
									 'EMsgNO_ATTR',
									 'InstallPkgArchitecture'
									);
	}
	if ($CSMVersion_Err_Flg > 0)
	{
		MessageUtils->messageFromCat(
									 'csmInstall.cat', $::MSGMAPPATH,
									 'csminstall',     'E',
									 'EMsgNO_ATTR',    'InstallCSMVersion'
									);
	}

	exit $errors if ($errors);

	my @return_array = ($distro_name, $distro_version, $arch, $csm_version);

	return (@return_array);
}

#--------------------------------------------------------------------------------

=head3    get_CSMVersion

        Get the version of csm component that is installed on the 
        management server.

        Arguments:
                $component
                $showfixlevel
        Returns:
                the csm version as a string.
        Globals:
                $::PLTFRM
                $::RPMCMD
        Error:
                Undefined
        Example:
                 $ret_code=NodeUtils->get_CSMVersion("rpm");
        Comments:
                The version should be in the form "V.R.M" (e.g. 1.2.0).
                If showfixlevel parameter == true (1),  the version will be
                in the form "V.R.M.F" (e.g. 1.2.0.0). 

=cut

#--------------------------------------------------------------------------------

sub get_CSMVersion
{
	my ($class, $component, $showfixlevel) = @_;
	my ($cmd, $output, $rpm, $version, $release, $v1, $v2, $v3, $v4, $rest);

	if ($::PLTFRM eq "Linux")
	{
		$cmd    = "$::RPMCMD -q $component";
		$output = NodeUtils->runcmd($cmd);
		chomp($output);
		($rpm, $version, $release) = split(/-/, $output);

		($v1, $v2, $v3, $v4, $rest) = split(/\./, $version);
		if ($showfixlevel) { $version = join(".", $v1, $v2, $v3, $v4); }
		else { $version = join(".", $v1, $v2, $v3); }
	}
	elsif ($::PLTFRM eq "AIX")
	{
		$cmd    = "$::LSLPP -cLq $component";
		$output = NodeUtils->runcmd($cmd);
		chomp($output);

		# The third field in the lslpp output is the VRMF
		($version) = (split(/:/, $output))[2];

		($v1, $v2, $v3, $v4, $rest) = split(/\./, $version);
		if ($showfixlevel) { $version = join(".", $v1, $v2, $v3, $v4); }
		else { $version = join(".", $v1, $v2, $v3); }
	}
	else
	{
		MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
									 'csminstall', 'E2', 'EMsgINVALID_OSTYPE');
	}

	return (length($version) ? $version : undef);
}

#--------------------------------------------------------------------------------

=head3  get_default_attributes   

        Set these default values for attributes not on command line:

           InstallOSName                OS Name of management server ("Linux" or "AIX").
           InstallDistributionVersion   MS's operating system version.
           InstallDistributionName      MS's operating system distribution (Linux only)
           InstallPkgArchitecture       MS's architecture (Linux only).
                                             if MS's architecture=i?86:  set to i386..
           InstallCSMVersion            Version of csm.core installed on MS.
           ConsoleMethod                PowerMethod if PowerMethod=hmc.
           ConsoleServerName            Set to HWControlPoint if PowerMethod=hmc
                                             also set during -H and -C processing.
           ConsoleSerialDevice
           ConsolePortNum

        Arguments:
                none
        Returns:
               number of errors 
        Globals:
                $::ATTRS hash
        Error:
                error count
        Example:
                 NodeUtils->get_default_attributes;
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub get_default_attributes
{
	my ($errors) = 0;

	# Operating System Type (Linux or AIX). Use MS's InstallOSName by default
	if (!$::ATTRS{"InstallOSName"})
	{
		$::ATTRS{"InstallOSName"} = NodeUtils->get_OSName();
		MessageUtils->message('V', 'IMsgDEFAULT_ATTR_SET', "InstallOSName",
							  $::ATTRS{'InstallOSName'});
		if (!$::ATTRS{"InstallOSName"})
		{
			MessageUtils->message('W', 'EMsgCANT_GET_OSNAME');
			$errors++;
		}

	}

	# Operating System Version.  Use MS's Operating System Version
	if (!$::ATTRS{"InstallDistributionVersion"})
	{
		$::ATTRS{"InstallDistributionVersion"} =
		  NodeUtils->get_DistributionVersion();
		MessageUtils->message(
							  'V',
							  'IMsgDEFAULT_ATTR_SET',
							  "InstallDistributionVersion",
							  $::ATTRS{'InstallDistributionVersion'}
							 );
		unless ($::ATTRS{"InstallDistributionVersion"})
		{
			MessageUtils->message('W', 'EMsgCANT_GET_DISTROVERSION');
			$errors++;
		}
	}

	# Operating System Distribution.  Use MS's Operating System Distribution.
	# Only for Linux.
	if (!$::ATTRS{"InstallDistributionName"}
		&& ($::ATTRS{"InstallOSName"} eq "Linux"))
	{
		$::ATTRS{"InstallDistributionName"} = NodeUtils->get_DistributionName();
		MessageUtils->message('V', 'IMsgDEFAULT_ATTR_SET',
							  "InstallDistributionName",
							  $::ATTRS{'InstallDistributionName'});
		unless ($::ATTRS{"InstallDistributionName"})
		{
			MessageUtils->message('W', 'EMsgCANT_GET_DISTRONAME');
			$errors++;
		}
	}

	# Package Architecture.  Use MS's Architecture.
	# Only for Linux.
	if (!$::ATTRS{"InstallPkgArchitecture"}
		&& ($::ATTRS{"InstallOSName"} eq "Linux"))
	{
		$::ATTRS{"InstallPkgArchitecture"} =
		  ArchiveUtils->get_PkgArchitecture();

		# All x86 machine types map to i386 since all x86 rpms are stored in
		# the same directory.
		if ($::ATTRS{'InstallPkgArchitecture'} =~ /i.86/)    #SSS
		{
			$::ATTRS{'InstallPkgArchitecture'} = "i386";
		}

		MessageUtils->message('V', 'IMsgDEFAULT_ATTR_SET',
							  "InstallPkgArchitecture",
							  $::ATTRS{'InstallPkgArchitecture'});

		unless ($::ATTRS{"InstallPkgArchitecture"})
		{
			MessageUtils->message('W', 'EMsgCANT_GET_PKGARCH');
			$errors++;
		}
	}

	# InstallServiceLevel.  Use MS's service level if MS and node have the same DistributionName
	# and DistributionVersion, otherwise use "GA" as default. Only for Linux.
	if (!$::ATTRS{"InstallServiceLevel"}
		&& ($::ATTRS{"InstallOSName"} eq "Linux"))
	{
		my $msdistro    = NodeUtils->get_DistributionName();
		my $msdistrover = NodeUtils->get_DistributionVersion();
		if (   ($msdistro eq $::ATTRS{'InstallDistributionName'})
			&& ($msdistrover eq $::ATTRS{'InstallDistributionVersion'}))
		{

			# Read in the pkgdefs so that we can use function defined in pkgdefs file
			# to determine the default service level.
			%::pkgdefs =
			  ServerUtils->get_pkgdefs(
									   $::PLTFRM,
									   $::ATTRS{'InstallDistributionName'},
									   $::ATTRS{'InstallDistributionVersion'},
									   $::ATTRS{'InstallPkgArchitecture'}
									  );
			$::ATTRS{'InstallServiceLevel'} = NodeUtils->get_ServiceLevel;
		}
		else
		{
			$::ATTRS{'InstallServiceLevel'} = "GA";
		}

		MessageUtils->message('V', 'IMsgDEFAULT_ATTR_SET',
							  "InstallServiceLevel",
							  $::ATTRS{'InstallServiceLevel'});
		unless ($::ATTRS{"InstallServiceLevel"})
		{
			MessageUtils->message('W', 'EMsgCANT_GET_InstallSvcLevel');
			$errors++;
		}
	}

	# CSM Version.  Use version of csm.core installed on MS by default for Linux
	if (   (!$::ATTRS{"InstallCSMVersion"})
		&& ($::ATTRS{"InstallOSName"} eq "Linux"))
	{

		$::ATTRS{"InstallCSMVersion"} = NodeUtils->get_CSMVersion("csm.core");
		MessageUtils->message('V', 'IMsgDEFAULT_ATTR_SET', "InstallCSMVersion",
							  $::ATTRS{'InstallCSMVersion'});
		unless ($::ATTRS{"InstallCSMVersion"})
		{
			MessageUtils->message('W', 'EMsgCANT_GET_CSMVERSION');
			$errors++;
		}
	}

	# Console Serial Device.  For Linux, default to "ttyS0".
	if (   (!$::ATTRS{"ConsoleSerialDevice"})
		&& ($::ATTRS{"InstallOSName"} eq "Linux")
		&& ($::ATTRS{"PowerMethod"} ne "blade"))
	{
		$::ATTRS{"ConsoleSerialDevice"} = "ttyS0";
	}

	# set default hardware related attributes
	my @methods = ("hmc", "blade", "ivm", "csp", "fsp", "bmc2", "bmc");
	if (grep /^$::ATTRS{'PowerMethod'}$/, @methods)
	{
		if (!$::ATTRS{'ConsoleMethod'} and ($::ATTRS{'PowerMethod'}))
		{
			$::ATTRS{'ConsoleMethod'} = $::ATTRS{'PowerMethod'};
		}
		if (!$::ATTRS{'ConsoleServerName'} and ($::ATTRS{'HWControlPoint'}))
		{
			$::ATTRS{'ConsoleServerName'} = $::ATTRS{'HWControlPoint'};
		}
	}
	
	if ($::ATTRS{'PowerMethod'} eq "hmc")
	{
		if (!$::ATTRS{'ConsoleSerialDevice'})
		{
			$::ATTRS{'ConsoleSerialDevice'} = "ttyS0";
		}
		if (!$::ATTRS{'ConsoleSerialSpeed'})
		{
			$::ATTRS{'ConsoleSerialSpeed'} = "9600";
		}
	}elsif ($::ATTRS{'PowerMethod'} eq "blade")
	{
		if (!$::ATTRS{'ConsoleSerialDevice'})
		{
			$::ATTRS{'ConsoleSerialDevice'} = "ttyS1";
		}
		if (!$::ATTRS{'ConsoleSerialSpeed'})
		{
			$::ATTRS{'ConsoleSerialSpeed'} = "19200";
		}
		# for blade nodes, the default attribute should be SlotID
		# for hmc nodes, it is LParID
		# In the mapping file, SlotID or LParID is at the same location,
		# so here take the name $::ATTR{'LParID'},
		# it actually stores SlotID.
		if (!$::ATTRS{'ConsolePortNum'} and ($::ATTRS{'LParID'}))
		{
			$::ATTRS{'ConsolePortNum'} = $::ATTRS{'LParID'};
		}
		if (!$::ATTRS{'HWControlNodeId'} and ($::ATTRS{'LParID'}))
		{
			$::ATTRS{'HWControlNodeId'} = $::ATTRS{'LParID'};
		}
		delete $::ATTRS{'LParID'};
	}elsif ($::ATTRS{'PowerMethod'} eq "ivm")
	{
		if (!$::ATTRS{'ConsoleSerialDevice'})
		{
			$::ATTRS{'ConsoleSerialDevice'} = "ttyS0";
		}
		if (!$::ATTRS{'ConsoleSerialSpeed'})
		{
			$::ATTRS{'ConsoleSerialSpeed'} = "9600";
		}
		if (!$::ATTRS{'ConsolePortNum'} and ($::ATTRS{'LParID'}))
		{
			$::ATTRS{'ConsolePortNum'} = $::ATTRS{'LParID'};
		}
	}elsif ($::ATTRS{'PowerMethod'} eq "fsp" ||
		$::ATTRS{'PowerMethod'} eq "bmc2" ||
		$::ATTRS{'PowerMethod'} eq "bmc")
	{
		if (!$::ATTRS{'ConsoleSerialDevice'})
		{
			$::ATTRS{'ConsoleSerialDevice'} = "ttyS0";
		}
		if (!$::ATTRS{'ConsoleSerialSpeed'})
		{
			$::ATTRS{'ConsoleSerialSpeed'} = "19200";
		}
	}

	return ($errors);
}

#--------------------------------------------------------------------------------

=head3    get_DistributionName

        Linux only command
        
        Get the distribution name for Linux 

        Arguments:
                 $output
                 $rpm
                 $distro
        Returns:
                Linux distribution name as a string.
        Globals:
                $::PLTFRM
        Error:
                Exits with E2
        Example:
                $::ATTRS{'InstallDistributionName'} =
                        NodeUtils->get_DistributionName;
        Comments:
                returns nulls for AIX and exits on E2 for any
                other platform.

=cut

#--------------------------------------------------------------------------------

sub get_DistributionName
{
	my ($cmd, $output, $rpm, $distro);

	# IF LINUX
	if ($::PLTFRM eq "Linux")
	{
		$distro = (split ' ', (NodeUtils->distribution()))[0];
	}
	elsif ($::PLTFRM eq "AIX")
	{
		$distro = "";
	}
	else
	{
		MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
									 'csminstall', 'E2', 'EMsgINVALID_OSTYPE');
	}

	return (length($distro) ? $distro : undef);
}

#--------------------------------------------------------------------------------

=head3    get_DistributionVersion

        Returns the Operating System version that is installed on the
        management server.

        Arguments:
                none
        Returns:
                OS Version as a string.
        Globals:
                $::PLTFRM
        Error:
                undef
        Example:
                my $DistVersion = 
                        NodeUtils->get_DistributionVersion();
        Comments:
                For AIX, the version is in the V.R.M form ( e.g. 1.2.0 ).
                For Linux, the form reported in the /etc/redhat-release file
                (V.R) is used ( e.g. 1.2 )

=cut

#--------------------------------------------------------------------------------

sub get_DistributionVersion
{
	my ($cmd, $output, $rpm, $version, $release, $v1, $v2, $v3, $rest);

	if ($::PLTFRM eq "Linux")
	{

		$version = (split ' ', (NodeUtils->distribution()))[1];
	}
	elsif ($::PLTFRM eq "AIX")
	{
		$cmd    = "$::LSLPP -Lcq bos.rte | /usr/bin/cut -d: -f 3";
		$output = NodeUtils->runcmd($cmd);
		chomp($output);

		($v1, $v2, $v3, $rest) = split(/\./, $output);
		$version = join(".", $v1, $v2, $v3);
	}
	else
	{
		MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
									 'csminstall', 'E2', 'EMsgINVALID_OSTYPE');
	}

	return (length($version) ? $version : undef);
}

#--------------------------------------------------------------------------------

=head3    get_OSName

        Returns the OS Name i.e. Linux, AIX or undef.

        Arguments:
                none
        Returns:
                OS Name as a string.
        Globals:
                none
        Error:
                undef
        Example:
                $::ATTRS{'InstallOSName'}=NodeUtils->get_OSName;
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub get_OSName
{
	if (NodeUtils->isLinux() == 1)
	{
		return "Linux";
	}
	elsif (NodeUtils->isAIX() == 1)
	{
		return "AIX";
	}
	return undef;
}

#--------------------------------------------------------------------------------

=head3    get_PkgArchitecture

        Linux only routine.

        Returns the rpm package architure for the OS in $::PLTFRM
        i.e. i386 for linux

        Arguments:
                $output,
                $osarch
        Returns:
                none
        Globals:
                $::PLTFRM
        Error:
                messageFromCat E2
        Example:
                $::ATTRS{'InstallPkgArchitecture'} =
                        NodeUtils->get_PkgArchitecture;
        Comments:
                Works for Linux.  Returns null values $::PLTFRM
                is AIX, and exits with E2 for any other $::PLTFRM. 

=cut

#--------------------------------------------------------------------------------

sub get_PkgArchitecture
{
	my ($cmd, $output, $osarch);
	if ($::PLTFRM eq "Linux")
	{
		(undef,undef,undef,undef,$osarch)=POSIX::uname();
		return (length($osarch) ? $osarch : undef);
	}
	elsif ($::PLTFRM eq "AIX")
	{
		$osarch = "";
		return (length($osarch) ? $osarch : undef);
	}
	else
	{
		MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
									 'csminstall', 'E2', 'EMsgINVALID_OSTYPE');
	}
}

#--------------------------------------------------------------------------------

=head3    get_pkgVersion

        AIX only routine.

        Returns the installp image version from Installp command which,
        looks into the .toc file.

        Arguments:
                $installpPackage
        Returns:
                AIX installp image version as a string
        Globals:
                $::PLTFRM
                $::LSLPP
        Error:
                messageFromCat E2
        Example:
                not used outside NodeUtils
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub get_pkgVersion
{
	my ($class, $pkg) = @_;
	my ($cmd, $output, $version);

	if ($::PLTFRM eq "Linux")
	{
		$version = "";
		return (length($version) ? $version : undef);
	}
	elsif ($::PLTFRM eq "AIX")
	{
		$cmd    = qq($::LSLPP -Lcq  $pkg 2>&1);
		$output = NodeUtils->runcmd($cmd);
		chomp($output);
		(undef, undef, $version, undef) = split(/:/, $output);
		return (length($version) ? $version : undef);
	}
	else
	{
		MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
									 'csminstall', 'E2', 'EMsgINVALID_OSTYPE');
	}

}

#--------------------------------------------------------------------------------

=head3    getSetupKRB5                                                       #

        Gets or sets up KRB5 for a Management Server Node. 

        Arguments:
               none
        Returns:
                1 on failure
        value of attribute on success
        Globals:
                none
        Error:
                none
        Example:
                 my $krb5setup = NetworkUtils->getSetupKRB5();
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub getSetupKRB5
{

	# set local scope because we only want classes on the mgmt svr
	$ENV{'CT_MANAGEMENT_SCOPE'} = 1;

	# todo: remove when lsrsrc-api converts to above
	$ENV{'CT_SESSION_SCOPE'} = 1;
	if (NodeUtils->isMgmtSvr())
	{    #only defined on managment server
		my $outref =
		  NodeUtils->runrmccmd('lsrsrc-api', "-i",
							   "-s IBM.DmsCtrl::::SetupKRB5");
		return $$outref[0];
	}
	return 1;
}

#--------------------------------------------------------------------------------

=head3    listNodeAttrs


        Return attribute values for a given array of node names.

        Before calling this function, you can optionally call gatherNodeList()
        to build the array of node names from user input.

        You can also optionally call resolveAndUndup() separately, if you need
        access to the resolved list.

        Arguments:
           arrayref    A reference to the array containing the list of nodes.
                       If the list is empty and the WhereStr option is not
                       specified, all the nodes in the ManagedNode class 
                       will be selected.
           attrs       list of attributes that should be returned.
                       Multiple attribute names can be separate by spaces
                       and/or commas.
           opthashref  A reference to a hash with the following options:

                WhereStr:          A where string to use instead of a nodeList.
                IncludeAttrNames:  set to 1 if you want the attribute name to
                                   precede each attribute value.
                SkipResolve:       set to 1 if this function should not do name
                                   resolution on the list of nodes and remove
                                   duplicates.  If you set this to 1, you must
                                   also pass in Res2Unres below.
                Res2Unres:         reference to the hash returned by
                                   resolveAndUndup().
                ResourceClass:     resource class to get the node info from.
                                   Default is IBM.ManagedNode.  Make sure the
                                   environment variable CT_MANAGEMENT_SCOPE is
                                   set appropriately for the class being used
                                   (for IBM.ManagedNode it should be 1).
        Returns:
         Returns a reference to an array in which each line will contain
         the attributes for 1 node, separated by :|:

         Also $::LISTNODEATTRS_NUMNOTFOUND will be set to the number of nodes that
         were specified, but not found.
        Globals:
         $::LISTNODEATTRS_NUMNOTFOUND will be set to the number of nodes specified
        Error:
                none
        Example:
                none 
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub listNodeAttrs
{
	my ($class, $arrayref, $attrs, $opthashref) = @_;

	# Process the select argument
	if (length($attrs))
	{
		$attrs =~ s/[, ]+/::/g;
	}    # lsrsrc-api needs the attrs separated by ::
	else
	{
		$attrs = "'*b0x0020'";
	}    # this means return all public attributes

	# Set up where string
	my ($where, $whereattr, $ar2, $res2unres, $dontstripnameattr);

	if ($$opthashref{'ResourceClass'} eq 'IBM.Host')
	{
		$whereattr = 'NodeNameList';
	}
	elsif ($$opthashref{'ResourceClass'} eq 'IBM.DeviceHwCtrl')
	{
		$whereattr = 'Name';
	}
	else { $whereattr = 'Name'; }

	my $numtobefound = 0;    # 0 means we do not know, i.e. a where string
	if (defined($$opthashref{'WhereStr'}))
	{
		$where = NodeUtils->quote($$opthashref{'WhereStr'});
	}
	elsif (defined($arrayref) && scalar(@$arrayref))
	{
		if ($$opthashref{'SkipResolve'})
		{
			$ar2 = $arrayref;
			if (!defined($$opthashref{'Res2Unres'}))
			{
				if (!$NodeUtils::NO_MESSAGES)
				{
					MessageUtils->messageFromCat($MSGCAT, $MSGMAPPATH, $MSGSET,
												 'W', 'EMsgNO_RES2UNRES');
				}
				$NodeUtils::errno = 33;
				$res2unres        = {};
			}
			else { $res2unres = $$opthashref{'Res2Unres'}; }
		}
		else
		{
			($ar2, $res2unres) = NodeUtils->resolveAndUndup($arrayref);
		}
		$where             = qq/"$whereattr IN ('XXX')"/;
		$numtobefound      = scalar(@$ar2);
		$dontstripnameattr = $attrs =~ /(^|::)$whereattr(::|$)/;
		if (!$dontstripnameattr) { $dontstripnameattr = $attrs =~ /\*(b|p)/; }

		# prepend the Name attr so we can tell which ones were found
		$attrs = "${whereattr}::$attrs";
	}
	else { $where = ''; }    # this will pick up everything

	# Process other options and run lsrsrc-api cmd
	my $outputFormat = "-D ':|:'";
	my $longFormat   = 0;
	if ($$opthashref{'IncludeAttrNames'})
	{
		$outputFormat .= ' -n';
		$longFormat = 1;
	}
	my $resclass = $$opthashref{'ResourceClass'}    || 'IBM.ManagedNode';
	my $exitcode = $$opthashref{'ExitCodeBehavior'} || -2;
	my $numfound = 0;
	my $outref   =
	  NodeUtils->runrmccmd('lsrsrc-api',
						   "$outputFormat -i",
						   "-s ${resclass}::${where}::$attrs",
						   $exitcode, $ar2);

	# $exitcode defines exitcode behavior if cmd encounters error
	# Values are the same as defined for runcmd
	# Default is -2 (runrmccmd will exit if the cmd fails)
	$numfound = scalar(@$outref);
	my $somenotfound = ($numtobefound && $numfound < $numtobefound);

	# Strip the Name attr from the front and figure out which nodes were not found (if applicable)
	if ($numtobefound)
	{
		my $namefound = 0;    #looking for Name attribute,
		                      # lsrsrc-api only returns 1 value per attribute,
		     # even if attribute apears more than once in the string.
		if ($dontstripnameattr)
		{ #locate the Name attribute in the string, so we can put it back in the right place
			my @vals = split /::/, $attrs;
			my $i = 0;
			shift @vals;    #Name is the first one
			foreach my $v (@vals)
			{
				if ($v eq $whereattr)
				{
					$namefound = $i;
					last;
				}
				$i++;
			}
		}
		foreach my $l (@$outref)
		{

			# Get the Name attribute and strip it from the beginning of the line
			my ($junk, $name, $rest);
			if ($longFormat) { ($junk, $name, $rest) = split(/:\|:/, $l, 3); }
			else { ($name, $rest) = split(/:\|:/, $l, 2); }
			if (!$dontstripnameattr) { $l = $rest; }    #this strips the Name
			elsif (($namefound != 0) && (!$longFormat))
			{    #found the Name attribute
				my @values = split /:\|:/, $rest;
				splice @values, $namefound, 0, $name;
				$l = join ":|:", @values;
			}

			# Remove this node from the hash so we do not try to get it again
			if ($somenotfound) { delete $$res2unres{$name}; }
		}
	}

	if ($somenotfound)    # some of the specified nodes were not found
	{

		# The only thing left in the hash are the nodes we did not find.  Build
		# the array of unresolved node names and try those
		my @a;
		foreach my $k (keys %$res2unres)
		{
			if ($k ne "")
			{
				@{$$res2unres{$k}} = grep { !/$k/ } @{$$res2unres{$k}};
				push @a, @{$$res2unres{$k}};
			}
		}
		if (scalar(@a))
		{
			$where = qq/"$whereattr IN ('XXX')"/;
			$attrs =~ s/^${whereattr}:://;
			my $outref2 =
			  NodeUtils->runrmccmd('lsrsrc-api',
								   "$outputFormat -i",
								   "-s ${resclass}::${where}::$attrs",
								   undef, \@a);
			$numfound += scalar(@$outref2);
			push @$outref, @$outref2;    # append this to the 1st
		}
		$::LISTNODEATTRS_NUMNOTFOUND = $numtobefound - $numfound;
	}
	else                                 # everything found
	{
		$::LISTNODEATTRS_NUMNOTFOUND = 0;
	}

	return $outref;
}

#--------------------------------------------------------------------------------

=head3    SetAllowRequest

        Make sure the management server can update the node information.

        Arguments:
                $ref_DestNodeHash
                $value
        Returns:
                0 - All was successful
                1 - An error occured.
        Error:
                $::NOK
        Example:
                # Turn on ability of a node to request itself managed.
                NodeUtils->SetAllowRequest(\%nodehash, '1');
        Comments:
                Value should be set to 3 by installnode and by updatenode if
                the Mode is not managed.   Otherwise it should be set to 2 by
                updatenode.  During updatenode exit, it should be set to 0. 

=cut

#--------------------------------------------------------------------------------

sub SetAllowRequest
{

	my ($class, $ref_DestNodeHash, $value) = @_;
	my %DestNodeHash = %$ref_DestNodeHash;
	if (!$value)
	{
		$value = "0 ";
	}
	if (keys %DestNodeHash)
	{

		# DestNodeHash is a hash containing attribute values for
		# each node that was provided on the command line.
		my ($cmd, $rc);

		# check each node on our list and set the AllowManageRequest
		# attribute if needed.
		my @nodelist = (keys %DestNodeHash);
		
		my %attrs = (
			AllowManageRequest => "$value",
		);
		my $where = NodeUtils->quote("Hostname IN ('XXX')");
		my $chstr = 
		  "-s IBM.ManagedNode##${where}##" . NodeUtils->quote(join('##', %attrs));
		NodeUtils->runrmccmd('chrsrc-api', "-i -I'##'", $chstr, 1, \@nodelist);
		
		return $::RUNCMD_RC;

	}
	else
	{
		return 1;    #a value and nodes must be specified.
	}
}

#--------------------------------------------------------------------------------

=head3    SetControlFlag

        Set the ControlFlag attribute.  Currently, this is used to
        determine whether the node is allowed to write to the status
        log in /csminstall/csm/status/<nodename>.

        Arguments:
                $ref_DestNodeHash
                $value
        Returns:
                $::OK
                1 on error
        Error:
                1 on error
        Example:
                # Turn on ability of a node to write to status file
                NodeUtils->SetControlFlag(\%nodehash, '1');
        Comments:
                $value should be set to 1 by installnode, and then  csmfirstboot
                will run an RMC action to set it back to 0 when the node install is
                complete and no more status messages need to be written to the MS.

=cut

#--------------------------------------------------------------------------------

sub SetControlFlag
{

	my ($class, $ref_DestNodeHash, $value) = @_;
	my %DestNodeHash = %$ref_DestNodeHash;
	if (!$value)
	{
		$value = "0 ";
	}
	if (keys %DestNodeHash)
	{

		# DestNodeHash is a hash containing attribute values for
		# each node that was provided on the command line.
		my ($cmd, $rc);
		my @nodelist = (keys %DestNodeHash);
		
		my %attrs = (
			ControlFlag => "$value",
		);
		my $where = NodeUtils->quote("Hostname IN ('XXX')");
		my $chstr = 
		  "-s IBM.ManagedNode##${where}##" . NodeUtils->quote(join('##', %attrs));
		NodeUtils->runrmccmd('chrsrc-api', "-i -I'##'", $chstr, 1, \@nodelist);
		
		return $::RUNCMD_RC;
	}
	else
	{
		return 1;    #a value and nodes must be specified.
	}
}

#--------------------------------------------------------------------------------

=head3    SetMode

        Set a node's Mode attribute to PreManaged, Installing or Managed.

        Arguments:
                $node,
                $mode
        Returns:
                Status code from chnode()
        Globals:
                $::CSMLITE
        Example:
                $rc = NodeUtils->SetMode($node, $mode);_
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub SetMode
{
	my ($class, $node, $mode) = @_;
	my ($cmd, $rc, $fstatus);

	my $CSMLITE = $::CSMLITE;
	if (    ($mode ne "PreManaged")
		and ($mode ne "Installing")
		and ($mode ne "Managed")
		and ($mode ne $CSMLITE)
		and ($mode ne "${CSMLITE}-Installing"))
	{
		MessageUtils->messageFromCat(
			  'csmInstall.cat',
			  $::MSGMAPPATH,
			  'csminstall',
			  'E1',
			  'EMsgINVALID_MODE',
			  $mode,
			  "PreManaged, Installing, Managed, $CSMLITE, ${CSMLITE}-Installing"
		);
	}

	my %attrs = (
		Mode => "$mode",
	);
	my $where = NodeUtils->quote("Hostname IN ('XXX')");
	my @nodeslist = ($node);
	my $chstr = 
	  "-s IBM.ManagedNode##${where}##" . NodeUtils->quote(join('##', %attrs));
	NodeUtils->runrmccmd('chrsrc-api', "-i -I'##'", $chstr, 1, \@nodeslist);
	
	return $::RUNCMD_RC;
}

#--------------------------------------------------------------------------------

=head3    testvalidconsole

        Checks for the valid Console Method attributes. This subroutine 
        compares the given Console method against the list in the
        /opt/csm/bin/*_console Console methods.

        Arguments:
                ConsoleMethod attribute value as a string
        Returns:
                0 - valid console
                1 - not a valid console
                2 - error running ls on /opt/csm/bin
        Globals:
                none
        Error:
                1 or 2
        Example:
                 $retCode =
                    NodeUtils->testvalidconsole($::ATTRS{"ConsoleMethod"});
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub testvalidconsole
{
	my ($class, $my_console) = @_;
	my @temp_console = ();
	@::valid_console = ();
	my $console     = "";
	my $tmp_console = "";
	@temp_console = NodeUtils->runcmd("$::LS \/opt\/csm\/bin\/\*_console", -1);
	if ($::RUNCMD_RC != 0)
	{
		return 2;
	}
	foreach $tmp_console (@temp_console)
	{
		(undef, undef, undef, undef, $console) = split("/", $tmp_console);
		($console, undef) = split("_", $console);
		push(@::valid_console, $console);
	}
	if (!grep(/^$my_console$/, @::valid_console))
	{
		return 1;
	}
	else
	{
		return 0;
	}
}

#--------------------------------------------------------------------------------

=head3    testvalidpowermethod

        Checks for the valid Power Method attributes.

        Arguments:
                $powerMethod as a string
        Returns:
                0 - valid power method
                1 - not valid
        Globals:
                none
        Error:
                1
        Example:
                $retCode =
                   NodeUtils->testvalidpowermethod($::ATTRS{"PowerMethod"});
        Comments:
                This subroutine  compares the given Power method against the one in
                the /opt/csm/lib/lib+<given Power Method>+_power.so. If this Method
                is not found then it checks against the value in  /opt/csm/bin/*_power
                for a power command shipped with csm. If not found there then it
                checks against the value in  /opt/local/*_power.

=cut

#--------------------------------------------------------------------------------

sub testvalidpowermethod
{
	my ($class, $my_powermethod) = @_;
	my @temp_powermethod = ();
	@::valid_powermethod = ();
	my $powermethod     = "";
	my $tmp_powermethod = "";
	my $exit_code       = 0;
	@temp_powermethod = ();
	@temp_powermethod =
	  NodeUtils->runcmd("$::LS \/opt\/csm\/lib\/\*_power\.so", -1);

	if ($::RUNCMD_RC != 0)
	{
		$exit_code = 2;
	}
	else
	{
		foreach $tmp_powermethod (@temp_powermethod)
		{
			if (-z $tmp_powermethod)
			{
				next;
			}
			$powermethod = basename($tmp_powermethod);
			$powermethod =~ s/^lib(.*)_power.*$/$1/;
			push(@::valid_powermethod, $powermethod);
		}
		if (!grep(/^$my_powermethod$/, @::valid_powermethod))
		{
			$exit_code = 1;
		}
		else
		{
			$exit_code = 0;
		}
	}
	if (($exit_code == 1) || ($exit_code == 2))
	{
		@temp_powermethod = ();
		@temp_powermethod =
		  NodeUtils->runcmd("$::LS \/opt\/csm\/bin\/\*_power", -1);
		if ($::RUNCMD_RC != 0)
		{
		}
		else
		{
			foreach $tmp_powermethod (@temp_powermethod)
			{
				if (-z $tmp_powermethod)
				{
					next;
				}
				$powermethod = basename($tmp_powermethod);
				$powermethod =~ s/(.*)_power.*$/$1/;
				push(@::valid_powermethod, $powermethod);
			}

			if (!grep(/^$my_powermethod$/, @::valid_powermethod))
			{
				$exit_code = 1;
			}
			else
			{
				$exit_code = 0;
			}
		}
	}
	if (($exit_code == 1) || ($exit_code == 2))
	{
		@temp_powermethod = ();
		@temp_powermethod =
		  NodeUtils->runcmd("$::LS \/opt\/local\/\*_power", -1);
		if ($::RUNCMD_RC != 0)
		{
		}
		else
		{
			foreach $tmp_powermethod (@temp_powermethod)
			{
				if (-z $tmp_powermethod)
				{
					next;
				}
				$powermethod = basename($tmp_powermethod);
				$powermethod =~ s/(.*)_power.*$/$1/;
				push(@::valid_powermethod, $powermethod);
			}

			if (!grep(/^$my_powermethod$/, @::valid_powermethod))
			{
				$exit_code = 1;
			}
			else
			{
				$exit_code = 0;
			}
		}
	}
	return $exit_code;
}

#--------------------------------------------------------------------------------

=head3	verify_linux_attribute_definitions

	Linux only.

    	Check if all the attributes are there, if not defined then get the default
	from Management Server.  Does a fairly loose test of the values that the 
	attributes have been assigned and will generate an error if it finds
	an incorrect value.  


	Attributes tested are:

	.  InstallOSName
	.  InstallCSMVersion
	.  InstallDistributionName
	.  InstallDistributionVersion
	.  InstallPkgArchetecture
	
	Arguments:
        	none
	Returns:
		undef
	Globals:
		$::ATTRS
		$::PLTFRM
		@::DISTRO
	Error:
		Multiple E1 error messages
	Example:
		NodeUtils->verify_linux_attribute_definitions();
	Comments:
		rewritten for defect 10100

=cut

#--------------------------------------------------------------------------------

sub verify_linux_attribute_definitions
{

	#  Get defaults if the attributes aren't defined

	if (!($::ATTRS{'InstallOSName'}))
	{
		$::ATTRS{'InstallOSName'} = NodeUtils->get_OSName;
	}
	if (!($::ATTRS{'InstallCSMVersion'}))
	{
		$::ATTRS{'InstallCSMVersion'} = NodeUtils->get_CSMVersion("csm\.core");
	}
	if (!($::ATTRS{'InstallDistributionName'}))
	{
		$::ATTRS{'InstallDistributionName'} = NodeUtils->get_DistributionName;
	}
	if (!($::ATTRS{'InstallDistributionVersion'}))
	{
		$::ATTRS{'InstallDistributionVersion'} =
		  NodeUtils->get_DistributionVersion;
	}
	if (!($::ATTRS{'InstallPkgArchitecture'}))
	{
		$::ATTRS{'InstallPkgArchitecture'} = ArchiveUtils->get_PkgArchitecture;
	}

	# Test InstallCSMVersion
	if (length($::ATTRS{'InstallCSMVersion'}) == 0)
	{
		MessageUtils->message('E2', 'EMsgNO_CORE_COPY');
	}
	if (!grep(/^$::ATTRS{'InstallCSMVersion'}$/, @::VALID_CSM_DISTROS))
	{
		MessageUtils->message(
							  'E5',
							  'EMsgUNSUPPORTED_CSM_DISTRO',
							  "CSM" . $::ATTRS{'InstallCSMVersion'},
							  join(', ', @::VALID_CSM_DISTROS)
							 );
	}
	else
	{
		MessageUtils->message(
							  'V',
							  'IMsgDETECTED_CSM_DISTRO',
							  "CSM" . $::ATTRS{'InstallCSMVersion'}
							 );
	}
}

#--------------------------------------------------------------------------------

=head2    Run Command Tools

=head3    filterRmcApiOutput

    filter RMC Api Output

    Arguments:
        RMC command
        Output reference
    Returns:
        none
    Globals:
        none
    Error:
        none
    Example:
         NodeUtils->filterRmcApiOutput($cmd, $outref); 
    Comments:
        The error msgs from the RPM -api cmds are pretty messy.
        This routine cleans them up a little bit.

=cut

#--------------------------------------------------------------------------------

sub filterRmcApiOutput
{
	my ($class, $cmd, $outref) = @_;
	if ($::VERBOSE || !($cmd =~ m|^/usr/bin/\S+-api |))
	{
		return;
	}    # give as much info as possible, if verbose

	# Figure out the output delimiter
	my ($d) = $cmd =~ / -D\s+(\S+)/;
	if (length($d))
	{
		$d =~ s/^(\'|\")(.*)(\"|\')$/$2/;    # remove any surrounding quotes
		  # escape any chars perl pattern matching would intepret as special chars
		$d =~ s/([\|\^\*\+\?\.])/\\$1/g;
	}
	else
	{
		$d = '::';
	}    # this is the default output delimiter for the -api cmds
	$$outref[0] =~ s/^ERROR${d}.*${d}.*${d}.*${d}.*${d}//;
}

#--------------------------------------------------------------------------------

=head3    runcmd

    Run the given cmd and return the output in an array (already chopped).  Alternatively,
    if this function is used in a scalar context, the output is joined into a single string
    with the newlines separating the lines.  

    Arguments:
        command, exitcode and reference to output
    Returns:
        see below
    Globals:
        $::RUNCMD_RC
    Error:
        Normally, if there is an error running the cmd, it will display the error msg
        and exit with the cmds exit code, unless exitcode is given one of the
        following values:
             0:     display error msg, DO NOT exit on error, but set
                $::RUNCMD_RC to the exit code.
            -1:     DO NOT display error msg and DO NOT exit on error, but set
                $::RUNCMD_RC to the exit code.
            -2:    DO the default behavior (display error msg and exit with cmds
                exit code.
        number > 0:    Display error msg and exit with the given code
    Example:
        my $outref = NodeUtils->runcmd($cmd, -2, 1);     
    Comments:
        If refoutput is true, then the output will be returned as a reference to
        an array for efficiency.

=cut

#--------------------------------------------------------------------------------

sub runcmd
{
	my ($class, $cmd, $exitcode, $refoutput) = @_;
	$::RUNCMD_RC = 0;
	if (!$NodeUtils::NO_STDERR_REDIRECT)
	{
		if (!($cmd =~ /2>&1$/)) { $cmd .= ' 2>&1'; }
	}
	if (!$NodeUtils::NO_MESSAGES)
	{
		MessageUtils->messageFromCat($MSGCAT, $MSGMAPPATH, $MSGSET, 'V',
									 'IMsgCMD', $cmd);
	}
	my $outref = [];
	@$outref = `$cmd`;
	if ($?)
	{
		$::RUNCMD_RC = $? >> 8;
		my $displayerror = 1;
		my $rc;
		if (defined($exitcode) && length($exitcode) && $exitcode != -2)
		{
			if ($exitcode > 0)
			{
				$rc = $exitcode;
			}    # if not zero, exit with specified code
			elsif ($exitcode <= 0)
			{
				$rc = '';    # if zero or negative, do not exit
				if ($exitcode < 0) { $displayerror = 0; }
			}
		}
		else
		{
			$rc = $::RUNCMD_RC;
		}    # if exitcode not specified, use cmd exit code
		if ($displayerror)
		{
			my $errmsg = '';
			if (NodeUtils->isLinux() && $::RUNCMD_RC == 139)
			{
				$errmsg = "Segmentation fault  $errmsg";
			}
			else
			{

				# The error msgs from the -api cmds are pretty messy.  Clean them up a little.
				NodeUtils->filterRmcApiOutput($cmd, $outref);
				$errmsg = join('', @$outref);
				chomp $errmsg;
			}
			if (!$NodeUtils::NO_MESSAGES)
			{
				MessageUtils->messageFromCat($MSGCAT, $MSGMAPPATH, $MSGSET,
						 "E$rc", 'EMsgCMD_FAILED', $::RUNCMD_RC, $cmd, $errmsg);
			}
			$NodeUtils::errno = 29;
		}
	}
	if ($refoutput)
	{
		chomp(@$outref);
		return $outref;
	}
	elsif (wantarray)
	{
		chomp(@$outref);
		return @$outref;
	}
	else
	{
		my $line = join('', @$outref);
		chomp $line;
		return $line;
	}
}

#--------------------------------------------------------------------------------

=head3    run_cmd

        Run a system command

        Arguments:
               
            The first argument is a string containing the command to run.

            The second argument is the type of message that should be printed.
                Valid values for msgtype are:  E, W, I, etc.  (same as the msg
                    routine) If msgtype is "E" (the default), the command exits
                    the program with the return code of the command.

                The third argument specifies how the command will run.

        Returns:
                Return code from the shell executing the commmand.
        Globals:
                none
        Error:
            If msgtype is "E" (the default), the command exits the program
        with the return code of the command.

                If runtype is "show_errors" or not specified, stdout will be captured
                and displayed in a message as specified by msgtype.

                If runtype is "show_all", all output will go be sent to stdout or
                wherever the command sends it.  Any errors will be displayed as a
                message as specified by msgtype.

                If runtype is "ignore_errors", all output will go be sent to the
                screen or wherever the command sends it.  Any errors will be ignored.

        Example:
                 NodeUtils->run_cmd($cmd, "W", "ignore_errors");
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub run_cmd
{
	my ($class, $cmd, $msgtype, $runtype) = @_;
	my ($rc, @cmdout, $msgtypestr);

	$msgtype = "E"           if (!$msgtype);
	$runtype = "show_errors" if (!$runtype);

    MessageUtils->messageFromCat($MSGCAT, $MSGMAPPATH, $MSGSET, 'V', 'IMsgCMD', $cmd);

	if ($runtype eq "show_all")
	{
		$rc = system("$cmd") >> 8;
		if ($rc)
		{

			# Only exit with a return code if msgtype = "E" (Error)
			$msgtypestr = $msgtype;
			$msgtypestr = "$msgtype$rc" if ($msgtype eq "E");
			MessageUtils->message("$msgtypestr", 'EMsgCMD_FAILED_RC', $cmd,
								  $rc);
		}
	}
	elsif ($runtype eq "show_errors")
	{
		@cmdout = `$cmd 2>&1`;
		chomp(@cmdout);    # take the newline off
		$rc = $? >> 8;

		if ($rc)
		{

			# Only exit with a return code if msgtype = "E" (Error)
			$msgtypestr = $msgtype;
			$msgtypestr = "$msgtype$rc" if ($msgtype eq "E");

			MessageUtils->message(         "$msgtypestr", 'EMsgCMD_FAILED',
								  $cmd, join('', @cmdout));
		}
	}
	elsif ($runtype eq "ignore_errors")
	{
		$rc = system("$cmd") >> 8;
	}
	else
	{
		MessageUtils->message('E1', 'EMsgRUN_CMD_INVALID', $runtype);
	}

	return $rc;
}

#--------------------------------------------------------------------------------

=head3    runrmccmd

    Runs an RMC commmand

    Arguments:
        $rmccmd, $resclass, $options, $select, $exitcode, $nodelist_ref
    Returns:
        the output from  NodeUtils->runcmd($cmd, -2, 1)
        as a ref to the output array.
    Globals:
        $::notCheckLicense: This global variable indicates whether the CSM license should be checked in this
                            subroutine. This global variable should only be used in this subroutine and csmconfig.
                    =1 CSM license will not be checked
                    =0 CSM license will be checked in this subroutine
    Error:
        none
    Example:
         my $outref =
            NodeUtils->runrmccmd('lsrsrc-api', "-i -D ':|:'", $where);
    Comments:
        When $nodelist_ref is not null, break it up into smaller slices
		and run RMC commands seperately for each slice. 
		Otherwise just run RMC commands with the arguments passed in.

=cut

#--------------------------------------------------------------------------------

sub runrmccmd
{
	my ($class, $rmccmd, $options, $select, $exitcode, $nodelist_ref) = @_;
	if (!$::notCheckLicense && NodeUtils->isRoot() && $select =~ /IBM\.ManagedNode::::Hostname/)
	{
		if (! NodeUtils->csm_license_valid())
		{
			MessageUtils->messageFromCat($MSGCAT, $MSGMAPPATH, $MSGSET,
					'E1', 'EMsgInvalidCSMLicense');
		}
		$::notCheckLicense = 1;
	}
	my @nodelist;
	my $return_ref = [];

	if (!defined($exitcode))
	{
		$exitcode = -2;
	}
	
	if(! grep /usr\/bin/, $rmccmd)
	{
		# add absolute path
		$rmccmd = "/usr/bin/$rmccmd";
	}

	if ($nodelist_ref)
	{

		# check whether to break up nodelist for better scalability.
		@nodelist = @$nodelist_ref;
		my $divide = 500;    # max number of nodes for each division
		my @sublist;
		my @newarray;
		my ($start_index, $end_index, $nodestring);

		my $count = 0;
		my $times = int(scalar(@nodelist) / $divide);
		while ($count <= $times)
		{
			$start_index = $count * $divide;
			$end_index   =
			    ((scalar(@nodelist) - 1) < (($count + 1) * $divide - 1))
			  ? (scalar(@nodelist) - 1)
			  : (($count + 1) * $divide - 1);
			@sublist  = @nodelist[$start_index .. $end_index];
			@newarray = ();
			foreach my $node (@sublist)
			{
				my @vals = split ',|\s', $node;
				push @newarray, @vals;
			}
			$nodestring = join("','", @newarray);

			# replace the pattern in select string with the broken up node string
			my $select_new = $select;
			$select_new =~ s/XXX/$nodestring/;
			my $cmd = "$rmccmd $options $select_new";
			my $outref = NodeUtils->runcmd($cmd, $exitcode, 1);
			push @$return_ref, @$outref;

			$count++;
		}
	}
	else
	{
		my $cmd = "$rmccmd $options $select";
		$return_ref = NodeUtils->runcmd($cmd, $exitcode, 1);
	}

	# returns a reference to the output array
	return $return_ref;

}

#--------------------------------------------------------------------------------

=head2    Node & Group Support


=cut

#--------------------------------------------------------------------------------

=head3    add_cluster_nl

    Get hosts currently in CSM and adds to the node list.  
    Routine uses $main::lsnodes_opt as the flag to lsnodes command.

    This description doesn't make much sense.  Maybe someone will
    rewrite it.

    Arguments:
        none
    Returns:
        none
    Globals:
        $main::lsnodes_opt
    Error:
        Prints to STDERR.
    Example:
        not used
    Comments:
        not used??

=cut

#--------------------------------------------------------------------------------

sub add_cluster_nl
{

	my ($hostname, @hostnames);
	my $optcsmdir = "/opt/csm/bin";

	if (!-x "$optcsmdir/lsnode")
	{
		print STDERR
		  "Cluster System Management (csm.server) lsnode command not installed\n";
		exit(-1);
	}

	# get the long hostname from CSM lsnode
	chop(@hostnames = `$optcsmdir/lsnode $::lsnodes_opt 2>/dev/null`);

	# user specified -a and lsnode failed then exit
	if ($? != 0)
	{
		print STDERR "Cluster System Management lsnodes command error\n";
		exit(-1);
	}

	foreach $hostname (@hostnames)
	{
		NodeUtils->add_nl($hostname);
	}
}

#--------------------------------------------------------------------------------

=head3    add_nl

    Add a host to the node list. Don't add a hostname if it is already there or
    if the is contained in another name which resolves to the same  host.

    Arguments:
        hostName
    Returns:
        none
    Globals:
        @main::nl;
    Error:
        Prints to STDERR.
    Example:
        none
    Comments:
        none

=cut

#-----------------------------------------------------------------------------

sub add_nl
{

	shift;    # get rid of the class
	my $host = shift;
	my ($hostname, @hostnames);
	my ($newname, $name, $aliases, $addtype, $length, @addrs);
	$host =~ s/\s//g;

	# Now loop through hosts and return if the host is found
	foreach $hostname (@::nl)
	{

		# before adding-  check to see if either hostnames are a shortname
		# for the same host
		if ($hostname =~ /^$host.*/ | $host =~ /^$hostname.*/)
		{

			# resolve hostname of new host to be added to list
			($name, $aliases, $addtype, $length, @addrs) = gethostbyname($host);
			unless ($name)
			{
				print STDERR "Could not resolve hostname $host\n";
				return (1);
			}
			$newname = $name;

			# resolve hostname of existing node list host
			($name, $aliases, $addtype, $length, @addrs) =
			  gethostbyname($hostname);
			unless ($name)
			{
				print STDERR "Could not resolve hostname $host\n";
				return (1);
			}

			# If both names resolve to the same hostname, then do not add the host
			if ($name eq $newname)
			{
				return;
			}
		}
	}

	# Did not already have this host - add it to node list @::nl
	push(@::nl, $host);
}

#--------------------------------------------------------------------------------

=head3    buildWhereInList

    Build a "where" list

    Arguments:
        reference to an array of nodeNames
        array of where attributes
    Returns:
        where list
    Globals:
        none
    Error:
        none
    Example:
         $where = NodeUtils->buildWhereInList($ar2, $whereattr);
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub buildWhereInList
{
	my ($class, $arrayref, $attrname) = @_;
	if (!defined($attrname) || !length($attrname)) { $attrname = 'Hostname'; }

	#todo: handle long cmd line
	my @newarray;
	foreach my $string (@$arrayref)
	{
		my @vals = split ',|\s', $string;
		push @newarray, @vals;
	}
	my $where = qq/"$attrname IN ('/ . join("','", @newarray) . q/')"/;

	return $where;
}

#--------------------------------------------------------------------------------

=head3    check_duplicate_nodes

          Make sure the nodes in @::Nodes are not already defined as CSM Nodes.

        Arguments:
                none
        Returns:
                0 - no duplicate nodes
                2 - duplicate nodes found
        Globals:
                none
        Error:
                returns 2 on error
        Example:
                 my $retCode = NodeUtils->check_duplicate_nodes;
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub check_duplicate_nodes
{
	my ($returncode) = 0;
	my ($n, $m, $p);
	my ($duplicate_ManagedNodes);

	for $n (0 .. $#::Nodes)
	{
		for $m (0 .. $#::ManagedNodes)
		{
			if ($::Nodes[$n]{"hostname"} eq $::ManagedNodes[$m]{"Hostname"})
			{
				$duplicate_ManagedNodes .=
				  $::ManagedNodes[$m]{"Hostname"} . " ";
			}
		}
	}

	if ($duplicate_ManagedNodes)
	{
		MessageUtils->message('E', 'EMsgALREADY_DEFINED_MANAGEDNODES',
							  $duplicate_ManagedNodes);
		$returncode = 2;
	}

	return ($returncode);
}

#--------------------------------------------------------------------------------

=head3    expandExclusionRange

    Expand exclusion ranges that start with a minus.

    Arguments:
        $nodeList
        $list of expended group nodes
    Returns:
        array of nodeNames
    Globals:
        none
    Error:
        none
    Example:
        _
        if ($node =~ /^-/) {
            push @nodes, NodeUtils->expandExclusionRange($node, $groupExpansion);
        }    
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub expandExclusionRange
{
	my ($class, $node, $groupExpansion) = @_;

	$node =~ s/^-//;    # get rid of the leading minus
	my @nodes = NodeUtils->expandRanges($groupExpansion, $node);

	# Prepend a minus on each name.  These names will be excluded later.
	foreach my $n (@nodes) { $n =~ s/^/-/; }
	return @nodes;
}

#--------------------------------------------------------------------------------

=head3    expandGroupRange

     Expand group ranges such as:  g or g1-g3 or 1-3 or g1+2

    Arguments:
        Expand range values over a group.
    Returns:
        array of expended goup ranges.
    Globals:
        none
    Error:
        none
    Example:
        if ($node =~ /^-/) {
            push @nodes, NodeUtils->expandGroupRange($node, $groupExpansion);
        }
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub expandGroupRange
{
	my ($class, $group, $groupExpansion) = @_;
	my (@groups, @nodes);

	# First expand into multiple groups if it is a range
	$group =~ s/^\+//;
	@groups = NodeUtils->expandNodeRange($group);

	if ($groupExpansion)
	{

		# Now get memberlist for each group
		my $outref = NodeUtils->listNodeGroupExpMem(@groups);
		foreach my $row (@$outref)
		{
			my ($name, $nodelist) = $row =~ /^(.+):\|:\{(.*)\}$/;
			if (!$nodelist)
			{
			    MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
			                          'csminstall', 'E2', 'EMsgNoNodesInGroup', $name);
			}
			
			push @nodes, split(/,/, $nodelist);
		}
		return @nodes;
	}
	else    # do not expand groups
	{

		# Put the plus sign back on the group names
		foreach my $g (@groups) { $g =~ s/^/\+/; }
		return @groups;
	}

}

#--------------------------------------------------------------------------------

=head3    expandNodeRange

    Expand node ranges such as :
        n1-n3 or
        1-3 or
        n1+2 or
        2 or
        n1.ibm.com-n3.ibm.com or
        n1.ibm.com+2.
        192.168.0.1-192.168.0.5
        192.168.0.1
    Arguments:
        node range string
    Returns:
        array of nodeNames representing the expansion
    Globals:
        none
    Error:
        none
    Example:
         @groups = NodeUtils->expandNodeRange($group);
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub expandNodeRange
{
	my ($class, $node) = @_;
	my (@nodes, $fRoot, $fDomain, $fNum, $eRoot, $eNum, $eDomain);
	if ($node =~ /\+/)    # a base node name plus an increment
	{
		my ($front, $increment) = split(/\+/, $node, 2);
		if(NetworkUtils->isIpaddr($front))
		{
			return $node if $increment !~ /^\d+$/;

			my ($fNetC,$fAddr) = $front =~ /^(.*)\.(\d+)$/;
			my $eAddr = $fAddr + $increment;
			$eAddr-- if $ENV{CSM_XCAT_COMPAT};
			return $node if $eAddr > 255;

			for my $addrNum ($fAddr..$eAddr)
			{
				push @nodes,"$fNetC.$addrNum";
			} 
				return @nodes;
		}
		($fRoot, $fNum, $fDomain) = $front =~ /^(.*?)(\d+)(\..+)?$/;
		if (!defined($fNum) || !($increment =~ /^\d+$/)) { return $node; }
		if ($ENV{CSM_XCAT_COMPAT} == 1) { $eNum = $fNum + $increment - 1; }
		else { $eNum = $fNum + $increment; }
	}
	elsif ($node =~ /-/)    # a range
	{
		my ($front, $end) = split('-', $node, 2);

		#support ip range
		if (NetworkUtils->isIpaddr($front) && NetworkUtils->isIpaddr($end))
		{
			my ($fNetC, $fAddr) = $front =~ /^(.*)\.(\d+)$/;
			my ($eNetC, $eAddr) = $end   =~ /^(.*)\.(\d+)$/;
			if (   $fNetC ne $eNetC
				|| $fAddr >= $eAddr
				|| $eAddr > 255)
			{
				return $node;
			}
			for my $addrNum ($fAddr .. $eAddr)
			{
				push @nodes, "$fNetC.$addrNum";
			}
			return @nodes;
		}

		# Get the roots of the front part of the range and the end.
		# If there is any problem in the form, assume it is not a range
		($fRoot, $fNum, $fDomain) = $front =~ /^(.*?)(\d+)(\..+)?$/;
		($eRoot, $eNum, $eDomain) = $end   =~ /^(.*?)(\d+)(\..+)?$/;

		if (   !defined($fNum)
			|| !defined($eNum)
			|| $fNum >= $eNum
			|| $eRoot   ne $fRoot
			|| $eDomain ne $fDomain)
		{
			return $node;
		}
	}
	elsif ($node =~ /^\d+$/)    # an all numeric node name
	{
		return $ENV{CSM_NODE_PREFIX} . $node;
	}
	else { return $node; }      # no range syntax at all

	# Handle 5-8 and 5+8 cases
	if (!length($fRoot) && !length($fDomain))
	{
		$fRoot = $ENV{CSM_NODE_PREFIX};
		if (!defined($fRoot)) { return $node; }
	}

	my $prefix;
	foreach my $suffix ($fNum .. $eNum)
	{
		my $numOfZeros = (length($fNum) - length($suffix));
		my $prefix     = '0' x $numOfZeros;
		push @nodes, "$fRoot$prefix$suffix$fDomain";
	}

	return @nodes;
}

#-------------------------------------------------------------------------------

=head3    expandBracketRange

    Expand node ranges with bracket such as :
        n[001-005].ibm.com or
        node[a-z]-cluster
        node[1,3,5].ibm.com
        rack[1-3]node[2,4].ibm.com
    Arguments:
        node range string
    Returns:
        array of nodeNames representing the expansion
    Globals:
        none
    Error:
        none
    Example:
         @groups = NodeUtils->expandBracketRange($group);
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub expandBracketRange
{
	my ($class, $node) = @_;
	my @nodes;

	my $bracketCount = 0;
	my (@range1, @range2);
	my ($front, $bracket1, $middle, $bracket2, $end) =
	  $node =~ /(.*)\[(.+)\](.*)\[(.+)\](.*)/;
	if ($bracket2)
	{
		$bracketCount = 2;
	}
	else
	{
		($front, $bracket1, $end) = $node =~ /(.*)\[(.+)\](.*)/;
		$bracketCount = 1 if $bracket1;
	}

	if ($bracketCount == 0) { return $node; }
	foreach (1 .. $bracketCount)
	{
		my $bracket = $_ == 1 ? \$bracket1 : \$bracket2;
		my $range   = $_ == 1 ? \@range1   : \@range2;
		my ($first, $last) = split('-', $$bracket);
		if (   ($first =~ /^(\d+\.?\d*|\.\d+)$/)
			&& ($last =~ /^(\d+\.?\d*|\.\d+)$/))
		{
			return $node if $first >= $last;
			foreach my $suffix ($first .. $last)
			{
				my $numOfZeros = (length($first) - length($suffix));
				my $prefix     = '0' x $numOfZeros;
				push @$range, "$prefix$suffix";
			}
		}
		elsif (($first =~ /[a-zA-Z]/) && ($last =~ /[a-zA-Z]/))
		{
			my $firstnum = ord($first);
			my $lastnum  = ord($last);
			return $node if $firstnum >= $lastnum;
			foreach my $num ($firstnum .. $lastnum)
			{
				my $ch = chr($num);
				push @$range, "$ch";
			}
		}
		elsif ($first =~ /(\d+\,)*\d+/)
		{
			my $posComma = 0;
			while ($posComma != -1)
			{
				$posComma = index($first, ",");
				if ($posComma != -1)
				{
					push @$range, substr($first, 0, $posComma);
					$first = substr($first, $posComma + 1);
				}
				else
				{
					push @$range, $first;
				}
			}
		}
		else
		{
			return $node;
		}
	}    #end foreach
	push @range2, "" if scalar(@range2) == 0;
	foreach my $fix1 (sort @range1)
	{
		foreach my $fix2 (sort @range2)
		{
			push @nodes, "$front$fix1$middle$fix2$end";
		}
	}

	return @nodes;
}

#--------------------------------------------------------------------------------

=head3    expandRanges

    Expands node and group entries if they use any of the node range syntax.

    EXAMPLES:
      node01-node05:  node01, node02, node03, node04, node05
      n8-n11:  n8, n9, n10, n11
      frame2n5-frame2n7:  frame2n5, frame2n6, frame2n7
      15-20:  n15, n16, n17, n18, n19, n20 (assuming CSM_NODE_PREFIX is set to n)
      n8+3:  n8, n9, n10
      8+3:  n8, n9, n10
      8:  n8
      +g1:  n1, n2, n3 (assuming g1 was a group containing n1, n2, n3)
      -n2:  exclude n2
      -n2-n4:  exclude n2, n3, n4
      -+g1:  exclude the members of g1
      n[01-05]: n01, n02, n03, n04, n05
      node[a-c]-cluster: nodea-cluster, nodeb-cluster, nodec-cluster

     SOME ADDITIONAL RULES:
      - no spaces in the entry
      - the roots of the 1st and last node names must match
      - a name that starts with plus, but is not a valid group will be interpreted as a node name (including the plus)
      - If the right format is not found, it just returns the whole entry as a
        node name.  This means that most hostnames with dashes in them will still be
        treated as a regular hostname.
      - The bracket node range syntax (as the last two examples above ) can not
        be used together with any other noderange syntax.
      - The bracket node range syntax can only accept the digits or single
        character in the bracket.
      - Only bracket node range syntax support the hostname with dashes in it.

     DIFFERENCES FROM XCAT NODE RANGES:
      - do not support non-numeric ranges based on definition order of nodes
      - file input with -f
      - regular expressions via dynamic nodegroups
      - suffix not supported in node ranges
      - groups specified with + operator or with -N
      - ranges not supported with hostnames that have dashes in them
      - n1+2 means n1,n2,n3 unless CSM_XCAT_COMPAT is 1, then n1+2 means n1,n2

    ENVIRONEMENT VARIABLES:
      CSM_NO_NODERANGES - disable expansion of node ranges
      CSM_NODE_PREFIX - text to prepend to ranges like 1-5
      CSM_XCAT_COMPAT - if set to 1, then n1+2 means n1,n2

=cut

#--------------------------------------------------------------------------------

sub expandRanges
{
	shift;    # get rid of class name
	my $groupExpansion = shift;

	# The rest of @_ are the node names
	if (!defined($NO_NODERANGES))
	{
		$NO_NODERANGES = defined($ENV{CSM_NO_NODERANGES});
	}
	if ($NO_NODERANGES) { return @_; }

	my @nodes;
	foreach my $node (@_)
	{
		if ($node =~ /\[/)
		{
			push @nodes, NodeUtils->expandBracketRange($node);
		}
		elsif ($node =~ /^-/)
		{
			push @nodes,
			  NodeUtils->expandExclusionRange($node, $groupExpansion);
		}
		elsif ($node =~ /^\+/)
		{
			push @nodes, NodeUtils->expandGroupRange($node, $groupExpansion);
		}
		elsif ($node =~ /-|\+/ || $node =~ /^\d+$/)
		{
			push @nodes, NodeUtils->expandNodeRange($node);
		}
		else { push @nodes, $node; }
	}

	return @nodes;
}

#--------------------------------------------------------------------------------

=head3 splitRange:

    Split noderange(grouprange) list to separated noderange(grouprange)
    For example:
          "node1, node2, node[3,5,7].cluster, rack[1-4]node[5,7,9]" will be splited to
          "node1","node2","node[3,5,7].cluster" and "rack[1-4]node[5,7,9]"
    Store these single noderange(grouprange) to an array and return this array.

    Argument:
          $rangeList
    Returns:
          @rangeArray

=cut

#
sub splitRange
{
	my ($class, $rangeList) = @_;
	my @rangeArray = ();

	#splited by blank
	my @tmpRangeList = split(/ /, $rangeList);

	#splited by comma
	foreach my $tmpList (@tmpRangeList)
	{
		while (1)
		{
			my $posLeft1  = index($tmpList, "[");
			my $posRight1 = index($tmpList, "]");
			my $posComma  = index($tmpList, ",");
			if ($posLeft1 == -1 || $posRight1 == -1 || $posComma == -1)
			{
				push @rangeArray, split(/,/, $tmpList);
				last;
			}
			my $posLeft2  = index($tmpList, "[", $posLeft1 + 1);
			my $posRight2 = index($tmpList, "]", $posRight1 + 1);
			my $haveSecond = ($posLeft2 == -1 || $posRight2 == -1) ? 0 : 1;
			while (
				   (
					($posComma > $posLeft1 && $posComma < $posRight1)
					&& !$haveSecond
				   )
				   || (
					   (
						   ($posComma > $posLeft1 && $posComma < $posRight1)
						|| ($posComma > $posLeft2 && $posComma < $posRight2)
					   )
					   && $haveSecond
					  )
				  )
			{
				$posComma = index($tmpList, ",", $posComma + 1);
				last if $posComma == -1;
			}    #end while
			if ($posComma != -1)
			{
				push @rangeArray, substr($tmpList, 0, $posComma);
				$tmpList = substr($tmpList, $posComma + 1);
			}
			else
			{
				push @rangeArray, substr($tmpList, 0);
				last;    #last while(1)
			}
		}    #end while
	}    #end foreach
	return @rangeArray;
}

#--------------------------------------------------------------------------------

=head3    gatherNodeList

    Processes all the ways a user can specify nodes to our commands and creates an
    array with the whole list.  The list is checked for duplicates.  A reference to
    the array is returned.  This function will process -n, -N, and -f.  If nodes can
    be passed in as positional args, pass a reference to ARGV (\@ARGV) into this function.

    Arguments:
           arrayref -    reference to ARGV (\@ARGV).  NOTE: If you are going to pass an opthashref,
                you need to also pass an arrayref before it (the arrayref can reference
                an empty array - use []).

           opthashref -    a optional reference to a hash with the following keys:

                NodeFile -    1 or name of file containing node list.
                If 1, it will not look in a file at all.
                If undefined, this function will look in the file specified by $::opt_f.

                NodeGrp -    string containing node groups separated by commas or spaces.
                If undefined, it will look in $::opt_N.

    Returns:
        reference to an array of nodeNames.
    Globals:
        opt_ globals
    Error:
        $NodeUtils::errno = 30;
    Example:
         my $refnodes =
            NodeUtils->gatherNodeList(\@nodelist, \%opthashref);
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub gatherNodeList
{
	my ($class, $arrayref, $opthashref) = @_;
	my $nodes = [];    # create a reference to an array
	my @range = ();
	if (defined($arrayref))
	{
		foreach my $e (@$arrayref)
		{
			@range = NodeUtils->splitRange($e);
			push @$nodes, NodeUtils->expandRanges(1, @range);
		}
	}
	if (defined($::opt_n))
	{
		@range = NodeUtils->splitRange($::opt_n);
		push @$nodes, NodeUtils->expandRanges(1, @range);
	}
	my $groups = $$opthashref{'NodeGrp'} ? $$opthashref{'NodeGrp'} : $::opt_N;
	if (defined($groups))    # they specified node groups
	{
		@range = NodeUtils->splitRange($groups);
		foreach my $tmpRange (@range)
		{
			my @tmpNodes = ();
			if ($tmpRange =~ /^-/)    #exclude mode
			{
				$tmpRange =~ s/^-/+/;
				@tmpNodes = NodeUtils->expandGroupRange($tmpRange, 1);
				map { s/^/-/; } @tmpNodes;
				push @$nodes, @tmpNodes;
			}
			else
			{
				$tmpRange =~ s/^/+/;
				@tmpNodes = NodeUtils->expandGroupRange($tmpRange, 1);
				push @$nodes, @tmpNodes;
			}
		}
	}
	if (!defined($$opthashref{'NodeFile'}) || $$opthashref{'NodeFile'} ne "1")
	{
		my $file =
		  $$opthashref{'NodeFile'} ? $$opthashref{'NodeFile'} : $::opt_f;
		if (defined($file))    # read the node list from the file
		{
			if (open(NODELIST, $file))
			{
				while (<NODELIST>)
				{
					chomp($_);
					@range = NodeUtils->splitRange($_);
					push @$nodes, NodeUtils->expandRanges(1, @range);

				}
				close(NODELIST);
			}
			else
			{
				if (!$NodeUtils::NO_MESSAGES)
				{
					MessageUtils->messageFromCat($MSGCAT, $MSGMAPPATH, $MSGSET,
										 'E', 'EMsgNODELIST_FILE', $file, "$!");
				}
				$NodeUtils::errno = 30;
			}
		}
	}
	return $nodes;
}

#--------------------------------------------------------------------------------

=head3    generate_node_range

          Generate the list of nodes to define.  If the starting IP address
          (or hostname) and the count are provided, generate all the IP addresses
          from the starting IP address up to the correct ending number.

        Arguments:
                none
        Returns:
               @Nodes  - an arrary of nodenames
        Globals:
                @::ClusterOptions
                @$::nodelist
        Error:
                E2 message if no nodes are available from @$::nodelist
        Example:
                 NodeUtils->generate_node_range;
        Comments:
                might be good to give more info on the globals

=cut

#--------------------------------------------------------------------------------

sub generate_node_range
{
	my (@Nodes);
	my $i = 0;
	my ($node, $hostname, $ipaddr, $shorthost);

	# Generate a range of IP addresses based on the starting_nodename
	# and the node_count
	if (    $::ClusterOptions{"starting_nodename"}
		and $::ClusterOptions{"node_count"})
	{

		# Set the first node to the starting nodename
		$node = $::ClusterOptions{"starting_nodename"};

		# Increment the IP Address up to the number in node_count
		while ($i < $::ClusterOptions{"node_count"})
		{

			# Get the IP Address and hostname for the node.
			# getHost can accept either an IP address or a hostname as its
			# input parameter.
			($hostname, $ipaddr) = NetworkUtils->getHost($node);
			$shorthost = NodeUtils->getShorthost($hostname);

			$Nodes[$i]{"name"}      = $shorthost;
			$Nodes[$i]{"shorthost"} = $shorthost;
			$Nodes[$i]{"hostname"}  = $hostname;
			$Nodes[$i]{"ipaddr"}    = $ipaddr;

			$node = NetworkUtils->inc_ip($ipaddr);    # Get the next IP Address
			$i++;
		}
	}
	elsif (@$::nodelist)
	{
		$i = 0;
		foreach my $node (@$::nodelist)
		{
			($hostname, $ipaddr) = NetworkUtils->getHost($node);
			$shorthost = NodeUtils->getShorthost($hostname);

			$Nodes[$i]{"name"}      = $shorthost;
			$Nodes[$i]{"shorthost"} = $shorthost;
			$Nodes[$i]{"hostname"}  = $hostname;
			$Nodes[$i]{"ipaddr"}    = $ipaddr;

			$i++;
		}
	}
	else
	{
		MessageUtils->message('E2', 'EMsgNoNodesProvided');
	}

	if ($::VERBOSE)
	{
		MessageUtils->message('V', 'IMsgNEW_NODES_TO_DEFINE');
		for $i (0 .. $#Nodes)
		{
			MessageUtils->messageFromCat('csmInstall.cat', $MSGMAPPATH,
				  'csminstall', 'I', 'IMsgShow_Output', $Nodes[$i]{"hostname"});
		}
	}

	return @Nodes;
}

#--------------------------------------------------------------------------------

=head3    get_target_nodes

        Get a list of target nodes from the command line 

        Arguments:
                (\@ARGV) either from @ARGV 
                $::opt_n ($node group string) 
                $::opt_N $file containing node list 1 -- skips the check for not
                        found nodes
        Returns:
                \@DestNode      = reference to list of all target nodes
                \@lsnode_info   = reference to a list of results from lsnode command
                                  (only for the nodes in @DestNode)
                \%DestNodeHash  = reference to a hash of hostnames and attributes
                                  (foreach node in @Destnode):
                                  $DestNodeHash{$hostname}{$attribute_name} = "attribute value"
                                  For the list of attributes see $lsnode_attr
        Globals:
                $::ALL          - Distribute to all nodes
                $::MANAGED      - Distribute to all nodes where Mode="Managed"
                $::PRE_MANAGED  - Distribute to all nodes where Mode="PreManaged"
        Error:
                None documented
        Example
                my ($ref_DestNode, $ref_lsnode_info, $ref_DestNodeHash) =
                        NodeUtils->get_target_nodes(\@ARGV, $::NODE_GRPS, $::FILE);
        Comments:
                Common method for getting node list from command line.

=cut

#--------------------------------------------------------------------------------

sub get_target_nodes
{
	my ($class, $ref_nodelist, $nodegrp_list, $file, $skipNFcheck) = @_;
	my @nodelist = @$ref_nodelist;
	if (my $a = pop(@nodelist)) { push @nodelist, $a; }
	my (
		@DestNode,   @DestGroup,   %DestKeyTemp,
		%all_groups, @lsnode_info, @empty_array
	   );

	#Get all available attributes   
	my $lsnode_attr ="";

	# These delimeters are used with the lsnode command.  A simple colon (:)
	# cannot be used since there are colons in InstallAdapterMacaddr.
	my $check_delim = ':\|:';    # Used when splitting the line apart
	my %opthash=(IncludeAttrNames => 1); 

	if (($::ALL || $::MANAGED || $::PRE_MANAGED)
		&& !(scalar(@nodelist) || $nodegrp_list || $file))
	{                            
		#distribute to all nodes of a certain set
		my $select_string;
		if ($::MANAGED)
		{
			$select_string = "Mode=\"Managed\"";
		}
		elsif ($::PRE_MANAGED)
		{
			$select_string = "Mode=\"PreManaged\"";
		}
		else
		{                        
			#just managednodes
			$select_string = "";
		}
		$opthash{'WhereStr'} = $select_string;
		my $ref_lsnode_info =
		  NodeUtils->listNodeAttrs(\@empty_array, $lsnode_attr, \%opthash);
		@lsnode_info = @$ref_lsnode_info;

		foreach my $line (@lsnode_info)
		{
			chomp $line;
			my $hostname = (split /$check_delim/, $line)[0];
			push @DestNode, $hostname;
		}
	}
	else
	{
		my %opthashref = ();
		if ($file)
		{
			%opthashref = (NodeFile => $file, NodeGrp => $nodegrp_list);
		}
		else
		{
			%opthashref = (NodeFile => 1, NodeGrp => $nodegrp_list);
		}
		my $refnodes = NodeUtils->gatherNodeList(\@nodelist, \%opthashref);
		if (scalar @$refnodes)
		{
			my $ref_lsnode_info =
			  NodeUtils->listNodeAttrs($refnodes, $lsnode_attr, \%opthash);
			@lsnode_info = @$ref_lsnode_info;
			if (!$skipNFcheck)
			{
				NodeUtils->checkForNotFound($refnodes);
			}
		}
		else
		{
			@lsnode_info = ();
		}
	}

	my %DestNodeHash;
	foreach my $line (@lsnode_info)
	{   #this only has node names in it from the cluster
		my %attributes = split /$check_delim/, $line;
		my $hostname = $attributes{'Hostname'};
		if ($hostname =~ /^\w+$/)
		{
			# This is a short name. CSM can't support resolvable short hostname.
			my @snodelist = ($hostname);
			my $lnodelist = NodeUtils->resolveAndUndup(\@snodelist);
			if (scalar(@$lnodelist))
			{
				my $lhostname = shift @$lnodelist;
				if ($lhostname ne $hostname)
				{
                    MessageUtils->messageFromCat('csmInstall.cat',
                                                 $::MSGMAPPATH,
                                                 'csminstall', 
                                                 'E1', 
                                                 'EMsgShortHostname',
                                                 $hostname);
				}
			}
		}
		chomp $line;
		foreach my $attr (keys %attributes)
		{
			$DestNodeHash{$hostname}{$attr} = $attributes{$attr};

			# If the ManagementServer is not set, set it to default value
			if ($attr eq "ManagementServer")
			{
				if ($DestNodeHash{$hostname}{$attr} eq "")
				{
					my $msip = NetworkUtils->get_MSip($hostname);
					if ($msip != -1)
					{
						$DestNodeHash{$hostname}{$attr} = $msip;
					}
				}
			}

			# should recognize both "none" and "NONE" for ConsoleSerialDevice
			if (   ($attr eq "ConsoleSerialDevice")
				&& (uc($DestNodeHash{$hostname}{$attr}) eq "NONE"))
			{
				$DestNodeHash{$hostname}{$attr} = "NONE";
			}
		}
	}

	my @tmpDestNode = keys %DestNodeHash;
	my @return_array = (\@tmpDestNode, \@lsnode_info, \%DestNodeHash);
	return @return_array;
}

#--------------------------------------------------------------------------------

=head3    listNodeGroupExpMem

    Return the expanded member list for each of the node group names passed in.

    Arguments:
        One or more node groups as parameters
    Returns:
        reference to an array:

        Each element of the array represents one (1) row and has the format:

                    nodegroupname:|:{node1,node2,node3}


    Globals:
        none
    Error:
        none
    Example:
         my $outref =
            NodeUtils->listNodeGroupExpMem(@groups);
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub listNodeGroupExpMem
{
	shift;    # get rid of the class arg - the rest of @_ are the group names
	my $where      = '';
	my $groupclass = $::NODEGROUP_CLASS || 'IBM.NodeGroup';
	my $isdev      = ($::NODEGROUP_CLASS eq 'IBM.DeviceGroup');
	if (scalar(@_))
	{

		# We do it this way instead of putting all the groups in one IN expression because
		# this way guarantees they will come back in the same order specified.
		foreach my $g (@_)
		{
			$where .= qq( -s ${groupclass}::"Name='$g'"::Name::ExpMemberList);
		}
	}
	else { $where = "-s ${groupclass}::::Name::ExpMemberList"; }

	# Get the data
	my $outref = NodeUtils->runrmccmd('lsrsrc-api', "-i -D ':|:'", $where);
	if ($::RUNCMD_RC)
	{
		$outref = [];
	}
	if (scalar(@_) && scalar(@$outref) < scalar(@_) && $NODEGROUPEXPMEM_WARNING)
	{
		if (scalar(@_) == 1)
		{
			if (!$NodeUtils::NO_MESSAGES)
			{
				MessageUtils->messageFromCat(
					 $MSGCAT,
					 $MSGMAPPATH,
					 $isdev ? 'DeviceUtils' : $MSGSET,
					 'W',
					 $isdev ? 'EMsgGROUP_NOT_FOUND_dev' : 'EMsgGROUP_NOT_FOUND',
					 $_[0]
				);
			}
			$NodeUtils::errno = 31;
		}
		else
		{
			if (!$NodeUtils::NO_MESSAGES)
			{
				MessageUtils->messageFromCat(
											 $MSGCAT,
											 $MSGMAPPATH,
											 $isdev ? 'DeviceUtils' : $MSGSET,
											 'W',
											 $isdev
											 ? 'EMsgSOME_GROUPS_NOT_FOUND_dev'
											 : 'EMsgSOME_GROUPS_NOT_FOUND',
											 join(',', @_)
											);
			}
			$NodeUtils::errno = 32;
		}
	}
	return $outref;
}

#--------------------------------------------------------------------------------

=head3    resolveAndUndup

    Take the reference to an array of node names and resolve each name to its
    primary hostname and then eliminate duplicates in the list.  Returns a reference
    to a new array.  This function is separate from gatherNodeList because it is
    rather expensive to do all the name resolutions, so this should only be called
    when necessary.  For example, if you are going to pass the node list to lsnode,
    lsnode will do this for you, so you do not need to call this.

    Arguments:
        reference to an array of nodeNames.
    Returns:
        Returns a reference to processed array. This function can also return a
        reference to a hash mapping each resolved name back to its original name.    
    Globals:
        none
    Error:
        none
    Example:
        _
    Comments:
        This function also processes exclusions (node names that start with minus),
        unless the CSM_NO_NODERANGES env var is set.

=cut

#--------------------------------------------------------------------------------

sub resolveAndUndup
{
	my ($class, $arrayref) = @_;
	if (!$NodeUtils::NO_MESSAGES)
	{
		MessageUtils->messageFromCat($MSGCAT, $MSGMAPPATH, $MSGSET, 'V',
									 'IMsgRESOLVING');
	}
	my $hash    = {};
	my $exclude = {};

	my $ar2 = [];
	if (!defined($NO_NODERANGES))
	{
		$NO_NODERANGES = defined($ENV{CSM_NO_NODERANGES});
	}

	# Go through the list once to find all the exlusions
	if (!$NO_NODERANGES)
	{
		foreach my $node (@$arrayref)
		{
			if ($node =~ /^-/)
			{
				my $n2 = substr($node, 1);
				my $hostname = NetworkUtils->tryHost($n2);
				$$exclude{$hostname}++;
			}
		}
	}

	my $numnodes = scalar @$arrayref;
	if ($numnodes > 15)
	{    #if there are more than 15 nodes
		NetworkUtils->cacheEtcHosts();    #cache /etc/hosts if used
	}

	# Now go through the list a 2nd time
	foreach my $node (@$arrayref)
	{
		if (!$NO_NODERANGES && $node =~ /^-/)
		{
			next;
		}    # we already put the exclusions in the exclude hash
		my $resolved;
		my $hostname = NetworkUtils->tryHost($node, \$resolved);
		if (!defined($$exclude{$hostname}))
		{

			# Hosts that are not resolved successfully
			# are placed under an empty key
			if (!$resolved)
			{
				$hostname = "";
				my $flagExist = 0;
				foreach (@$ar2)
				{
					if ($node eq $_)
					{
						$flagExist = 1;
						last;
					}
				}
				if (!$flagExist)
				{
					push @$ar2, $node;
				}
			}

			if (!defined($$hash{$hostname}))
			{
				$$hash{$hostname} = [$node];
				if ($resolved)
				{
					push @$ar2, $hostname;
				}
			}
			else
			{
				push(@{$$hash{$hostname}}, $node);    # record duplicates
			}
		}
	}

	if (wantarray) { return ($ar2, $hash, $exclude); }
	else { return $ar2; }
}

#--------------------------------------------------------------------------------

=head3    subtractOrIntersect

     Does @$g1-@$g2 and returns the resulting array. The arrays passed in
    and the array returned are all references.  If $intersect is 1, then
    it finds the intersection of @$g1 and @$g2 instead. g1 and g2 are 
    groups of nodeNames.

    Arguments:
        $ref_group1 
        $ref_group2 
        $bool_intersect.
    Returns:
        ref_array - result of subtraction or intersection.
    Globals:
        none
    Error:
        none
    Example:
        not used
    Comments:
        not used ??

=cut

#--------------------------------------------------------------------------------

sub subtractOrIntersect
{
	my ($class, $g1, $g2, $intersect) = @_;
	if ($intersect) { $intersect = 1; }    # we need it exactly 0 or 1
	else { $intersect = 0; }

	# make a hash out of g2
	my %g2hash;
	@g2hash{@$g2} = (1) x scalar(@$g2);

	# go through @g1 and only copy elements to the returned array that are not in
	my $out = [];

	# this cryptic line says: if the element of g1 is not in g2 and we are
	# doing a subtraction, then add it to the out arrary.  Or if the element
	# of g1 is in g2 and we are doing the intersection, then add it to out.
	foreach my $g (@$g1)
	{
		if (defined($g2hash{$g}) == $intersect) { push @$out, $g; }
	}
	return $out;
}

#--------------------------------------------------------------------------------

=head3  getNodegrp
    

        return a node list in the target node group

        Arguments:
        	$target_grp
        Returns:
                0; Nothing in the nodegrp or no this nodegrp
                $ref_nodelist; 
        Globals:
        
        Example:
                $ref_group = NodeUtils->getNodegrp($target_grp);
        Comments:
        	none

=cut

sub getNodegrp
{
	my ($class, $target) = @_;
	my @glist;
	if ($target !~ /^\+/)
	{
		return 0;
	}
	else
	{
		$target =~ s/^\+//;
	}

	if (!$NodeUtils::NodegrpCmd{$target})
	{
		$NodeUtils::NodegrpCmd{$target} = 1;
		my $cmd = "$::NODEGRP -p $target";
		@glist = NodeUtils->runcmd($cmd, -1);
		if ($::RUNCMD_RC)
		{
			return 0;
		}
		else
		{
			@{$NodeUtils::Nodegrp{$target}} = @glist;
		}
	}
	if (@{$NodeUtils::Nodegrp{$target}})
	{
		my $ref_grp = \@{$NodeUtils::Nodegrp{$target}};
		return $ref_grp;
	}
	else
	{
		return 0;    #nothing in the group
	}
}

#--------------------------------------------------------------------------------

=head3  getNodeFromGroup
    

        Choose one install server from a node group by round robin for a node.
        The result will be cached.

        Arguments:
        	$target_grp
        Returns:
                0; Nothing in the nodegrp or no this nodegrp
                $ref_nodelist; 
        Globals:
        
        Example:
                $node = NodeUtils->getNodeFromGroup($target_grp);
        Comments:
        	none

=cut

sub getNodeFromGroup
{
	my ($class, $target, $node) = @_;

	#if already cache it , return;
	if ($NodeUtils::NodegrpNode{$node})
	{
		return $NodeUtils::NodegrpNode{$node};
	}

	my $ref_group = NodeUtils->getNodegrp($target);

	if (!($ref_group)) { return 0; }

	my @glist = @$ref_group;
	if (!(defined $NodeUtils::NodegrpIndex{$target}))
	{
		my $rnd = int(rand($#glist));
		$NodeUtils::NodegrpIndex{$target} = $rnd;
	}
	else
	{
		$NodeUtils::NodegrpIndex{$target}++;
	}

	if ($NodeUtils::NodegrpIndex{$target} > $#glist)
	{
		$NodeUtils::NodegrpIndex{$target} -= $#glist;
	}

	$NodeUtils::NodegrpNode{$node} = $glist[$NodeUtils::NodegrpIndex{$target}];

	return $NodeUtils::NodegrpNode{$node};
}

#--------------------------------------------------------------------------------

=head3	seperateBlades

	Something to do with powermethods for blades?

	Notes:

=cut

#--------------------------------------------------------------------------------

sub seperateBlades
{
	my ($class, @nodes) = @_;
	unless (@nodes)
	{
		return;
	}

	# for now
	my @blades;
	my @nonBlades;
	my ($bladeStatusRef, $node, $v, $nodes);
	my (@xseriesNodes);

	# The PowerMethod of blades must be set to either "xseries" or "blade"
	# for xSeries Blades. The PowerMethod of blades must be set to "blade"
	# for JS20 (pSeries) Blades.

	# Sort out the nodes whose PowerMethod=xseries.
	# These nodes might be blades.

	foreach $node (@nodes)
	{
		if ($::NODEHASH{$node}{PowerMethod} eq "blade")
		{

			# PowerMethod=blade : definitely blades
			push @blades, $node;
		}
		elsif ($::NODEHASH{$node}{PowerMethod} eq "xseries")
		{

			# PowerMethod=xseries : might be blades, check below
			push @xseriesNodes, $node;
		}
		else
		{

			# PowerMethod=<something else> : not blades.
			push @nonBlades, $node;
		}
	}
	if (@xseriesNodes)
	{
		$bladeStatusRef = NodeUtils->getBladeStatus(@xseriesNodes);
		foreach $node (keys %$bladeStatusRef)
		{
			$v = $bladeStatusRef->{$node};    # set v to yes or no.
			                                  #print "$v\n" ;
			if ($v =~ /yes/)
			{
				push @blades, $node;          # These are our blades
			}
			else
			{
				push @nonBlades, $node;       # these are not blades.
			}
		}
	}

	return (\@blades, \@nonBlades);

}

#--------------------------------------------------------------------------------

=head3	seperateAIXandLinuxNodes

	Notes:

=cut

#--------------------------------------------------------------------------------

sub seperateAIXandLinuxNodes
{
	my ($class, @nodes) = @_;
	my $nodecond_count = 0;
	my $rc;
	my @plinuxNodes;
	my @linuxNodes;
	my @aixNodes;

	foreach my $node (@nodes)
	{

		# Check the type of the node.  If Linux, save the name in a list
		# for processing with getmacs later

		my $node_OS = $::NODEHASH{$node}{'InstallOSName'};

		chomp($node_OS);
		if ($node_OS eq "Linux")
		{
			my $node_Arch = $::NODEHASH{$node}{'InstallPkgArchitecture'};
			chomp($node_Arch);
			if ($node_Arch eq "ppc64")
			{
				push(@plinuxNodes, $node);
				next;
			}
			push(@linuxNodes, $node);
			next;    # skip to the next node
		}
		else
		{

			# Push this node to the list of AIX nodes
			push(@aixNodes, $node);
		}    #end of else
	}    #end of foreach
	return (\@linuxNodes, \@plinuxNodes, \@aixNodes);
}

#--------------------------------------------------------------------------------

=head3  getShorthost

        Notes:

=cut

#--------------------------------------------------------------------------------
sub getShorthost
{
	my ($class, $host) = @_;
	my $shorthost = $host;
	if (!NetworkUtils->isIpaddr($host))
	{
		$shorthost =~ s/\..*$//;
	}
	return $shorthost;
}

#--------------------------------------------------------------------------------

=head3  touchFile
    Arguments: $filename, $donotExit
    Returns: non zero return code indicates error
    Example:  NodeUtils->touchFile("/var/opt/csm/touch");
=cut

#--------------------------------------------------------------------------------
sub touchFile
{
	my ($class, $filename, $donotExit) = @_;

	my $fh;
	my $rc = 0;
	if (!-e $filename)
	{    #if the file doesn't exist we need to open and close it
		open($fh, ">>$filename") or $rc++;
		if ($rc > 0 && !$donotExit)
		{
			MessageUtils->messageFromCat($MSGCAT, $MSGMAPPATH, $MSGSET, 'E1',
										 'EMsgCannotTouchFile', $filename, $!);
			return $rc;
		}

		close($fh) or $rc++;
	}
	else
	{ #if the file does exist we can just utime it (see the perlfunc man page entry on utime)
		my $now = time;
		utime($now, $now, $filename);
	}
	if ($rc > 0 && !$donotExit)
	{
		MessageUtils->messageFromCat($MSGCAT, $MSGMAPPATH, $MSGSET, 'E1',
									 'EMsgCannotTouchFile', $filename, $!);
		return $rc;
	}
	return 0;

}

#--------------------------------------------------------------------------------

=head3  createAutoupdateDB
    Arguments: $rpmdir
    Returns: non zero return code indicates error
    Example: NodeUtils->createAutoupdateDB("rpmDIR");
=cut

#--------------------------------------------------------------------------------
sub createAutoupdateDB
{
	my ($class, $rpmdir) = @_;

	#spawing child
	my $pid = fork();
	if (!defined $pid)
	{
		MessageUtils->messageFromCat($MSGCAT, $MSGMAPPATH, $MSGSET, 'E1',
									 'EMsgCannotFork');
	}
	if ($pid == 0)
	{

		# Child - do some work
		exec
		  "$::AUTOUPD --noupdate --addtodb --updatedir $rpmdir --database /var/opt/csm/autoprovides.db --config /var/opt/csm/autoupdate.conf";
		exit 1;    #incase exec fails
	}
	local $| = 1;    #autoflush the periods
	my $kid   = 0;
	my $count = 0;
	while ($kid != $pid && $kid != -1)
	{
		sleep 5;
		$kid = waitpid($pid, WNOHANG);
		$count++;
		if ($count % 2 == 1)
		{
			if ( !$ENV{ 'SMSLOCAL_CALLED_BY_DSH'})
			{
				print ".";
			}
		}
	}
	print "\n";
}

############################################################################
#
#       get_common_network_attrs
#               get 4 node network related attributes from %::NODEHASH
#
#       Note:
#               This function is removed from csmsetupyast and csmsetupks
#               commands.
#
#       Arguments:
#               $nodelist_ref - The node list to get attributes. If it did not
#               set, uses global variable %::NODEHASH.
#
#       Globals:
#               %::NODEHASH
#               $::DEBUG
#               $::MSGMAPPATH
#
#       Returns:
#               one array containing InstallAdapterType, InstallAdapterSpeed,
#               InstallAdapterDuplex, InstallAdapterGateway
#
#############################################################################
sub get_common_network_attrs
{

	my $routine = " ";
	print "ENTERING: $routine\n" if $::DEBUG;

	my ($class, $nodelist_ref) = @_;

        my @nodelist;
        if ($nodelist_ref)
        {
                @nodelist = @$nodelist_ref;
        }
        else
        {
                @nodelist = (keys %::NODEHASH);
        }

	my ($type, $speed, $duplex, $gateway);
	my $errors = 0;
	my ($InstallAdapterType);
	my ($InstallAdapterSpeed);
	my ($InstallAdapterDuplex);
	my ($InstallAdapterGateway);
	my $InstallAdapterType_Err_Flg    = 0;
	my $InstallAdapterSpeed_Err_Flg   = 0;
	my $InstallAdapterDuplex_Err_Flg  = 0;
	my $InstallAdapterGateway_Err_Flg = 0;

	foreach my $hostname (@nodelist)
	{
		$InstallAdapterType    = $::NODEHASH{$hostname}{'InstallAdapterType'};
		$InstallAdapterSpeed   = $::NODEHASH{$hostname}{'InstallAdapterSpeed'};
		$InstallAdapterDuplex  = $::NODEHASH{$hostname}{'InstallAdapterDuplex'};
		$InstallAdapterGateway =
		  $::NODEHASH{$hostname}{'InstallAdapterGateway'};

		if (!$type)
		{
			$type = $InstallAdapterType;
		}
		if (!$speed)
		{
			$speed = $InstallAdapterSpeed;
		}
		if (!$duplex)
		{
			$duplex = $InstallAdapterDuplex;
		}
		if (!$gateway)
		{
			$gateway = $InstallAdapterGateway;
		}

		if (    ("$type" and "$InstallAdapterType")
			and ($InstallAdapterType ne $type))
		{
			$errors++;
			$InstallAdapterType_Err_Flg++;
		}
		if (    ("$speed" and "$InstallAdapterSpeed")
			and ($InstallAdapterSpeed ne $speed))
		{
			$errors++;
			$InstallAdapterSpeed_Err_Flg++;
		}

		if (    ("$duplex" and "$InstallAdapterDuplex")
			and ($InstallAdapterDuplex ne $duplex))
		{
			$errors++;
			$InstallAdapterDuplex_Err_Flg++;
		}

		if (    ("$gateway" and "$InstallAdapterGateway")
			and ($InstallAdapterGateway ne $gateway))
		{
			$errors++;
			$InstallAdapterGateway_Err_Flg++;
		}

	}

	if ($InstallAdapterType_Err_Flg > 0)
	{
		print "LEAVING: $routine\n" if $::DEBUG;
		MessageUtils->messageFromCat(
									 'csmInstall.cat',
									 $::MSGMAPPATH,
									 'csminstall',
									 'E',
									 'EMsgDIFFERENT_ATTR',
									 'InstallAdapterType'
									);
	}
	if ($InstallAdapterSpeed_Err_Flg > 0)
	{
		print "LEAVING: $routine\n" if $::DEBUG;
		MessageUtils->messageFromCat(
									 'csmInstall.cat',
									 $::MSGMAPPATH,
									 'csminstall',
									 'E',
									 'EMsgDIFFERENT_ATTR',
									 'InstallAdapterSpeed'
									);
	}
	if ($InstallAdapterDuplex_Err_Flg > 0)
	{
		print "LEAVING: $routine\n" if $::DEBUG;
		MessageUtils->messageFromCat(
									 'csmInstall.cat',
									 $::MSGMAPPATH,
									 'csminstall',
									 'E',
									 'EMsgDIFFERENT_ATTR',
									 'InstallAdapterDuplex'
									);
	}
	if ($InstallAdapterGateway_Err_Flg > 0)
	{
		print "LEAVING: $routine\n" if $::DEBUG;
		MessageUtils->messageFromCat(
									 'csmInstall.cat',
									 $::MSGMAPPATH,
									 'csminstall',
									 'E',
									 'EMsgDIFFERENT_ATTR',
									 'InstallAdapterGateway'
									);
	}

	exit $errors if ($errors);

	my @return_array = ($type, $speed, $duplex, $gateway);
	print "LEAVING: $routine\n" if $::DEBUG;
	return (@return_array);
}

############################################################################
#
#       get_default_net_attributes
#               get 3 network related attributes and verify their validity
#
#       Note:
#               This function is removed from csmsetupyast and csmsetupks
#               commands.
#
#       Arguments:
#               N/A
#
#       Globals:
#               $::ATTRS
#               $::PLTFRM
#               $::DEBUG
#               $::MSGMAPPATH
#
#       Returns:
#               N/A
#
#############################################################################
sub get_default_net_attributes
{
	my $routine = "get_default_net_attributes";
	print "ENTERING: $routine\n" if $::DEBUG;

	# If netmask is not provided, use the netmask of the management server
	if (!$::ATTRS{"Netmask"})
	{
		my $cmd = $::IFCONFIG;
		$cmd = $::IFCONFIG . " -a" if $::PLTFRM eq 'AIX';
		$cmd = $cmd . "|$::GREP inet";
		my @result = `$cmd`;
		if ($::PLTFRM eq 'Linux')
		{
			$result[0] =~ /Mask:(\d+.\d+.\d+.\d+)/;
			$::ATTRS{"Netmask"} = $1;
		}
		else
		{
			$result[0] =~ /netmask 0x(\w+)/;
			$::ATTRS{"Netmask"} = $1;
			$::ATTRS{"Netmask"} =
			  sprintf("%d.%d.%d.%d",
					  hex(substr($::ATTRS{"Netmask"}, 0, 2)),
					  hex(substr($::ATTRS{"Netmask"}, 2, 2)),
					  hex(substr($::ATTRS{"Netmask"}, 4, 2)),
					  hex(substr($::ATTRS{"Netmask"}, 6, 2)));
		}
	}

	# If Gateway is not provided, use the gateway of the management server
	if (!$::ATTRS{"Gateway"})
	{
		if ($::PLTFRM eq "Linux")
		{
			$::ATTRS{"Gateway"} =
			  (split(' ', `$::NETSTAT -rn | $::GREP 0.0.0.0 | $::TAIL -n 1`))
			  [1];
		}
		else
		{
			$::ATTRS{"Gateway"} =
			  (split(' ', `$::NETSTAT -rn | $::GREP default`))[1];
		}
		chomp $::ATTRS{"Gateway"};
	}

	# If Nameservers is not provided, use the nameservers of the
	# management server
	if (!$::ATTRS{"Nameservers"})
	{
		my $nameservers = "";
		my $filename    = "/etc/resolv.conf";
		if (-f $filename)
		{
        		open(RESOLV, "<$filename")
        		  || MessageUtils->message('E2', 'EMsgCANT_READ_FILE', $filename);

        		while (<RESOLV>)
        		{
        			my $line = $_;
        			chomp $line;

        			if ($line =~ /^nameserver/i)
        			{

        				$nameservers .= "," if ($nameservers);
        				$nameservers .= (split(' ', $line))[1];
        			}
        		}
        		close(RESOLV);
        		$::ATTRS{"Nameservers"} = $nameservers;
		}
		chomp $::ATTRS{"Gateway"};
	}

	print "LEAVING: $routine\n" if $::DEBUG;

}

############################################################################
#
#       set_InstallMethod
#               Set the InstallMethod attribute 
#               on all the nodes in the @::NODELIST
#
#       Note:
#               This function is taken from csmsetupks and csmsetupyast
#
#       Arguments:
#               install method. 
#
#       Globals:
#               @::NODELIST
#               $::DEBUG
#
#       Returns:
#               the return value of set command
#
#############################################################################
sub set_InstallMethod
{
	my ($class, $method) = @_;
	my $routine = "set_InstallMethod";
	print "ENTERING: $routine\n" if $::DEBUG;

	if ($::HWMAINT) { return 0; }

	unless (@::NODELIST)
	{
		return 0;
	}

	my %attrs = (
		InstallMethod => "$method",
	);

	my $where = NodeUtils->quote("Hostname IN ('XXX')");
	my $chstr = 
	  "-s IBM.ManagedNode##${where}##" . NodeUtils->quote(join('##', %attrs));
	NodeUtils->runrmccmd('chrsrc-api', "-i -I'##'", $chstr, 1, \@::NODELIST);
	
	print "LEAVING: $routine\n" if $::DEBUG;
	return $::RUNCMD_RC;
}

############################################################################
#
#       refresh_nodeattr
#
#       Note:
#               This function is taken from csmsetupks and csmsetupyast
#
#       Arguments:
#               N/A
#
#       Globals:
#               @::NODELIST
#               @::LSNODE_INFO
#               $::FILE
#               @::LSNODE_INFO
#               %::NODEHASH
#               %::NODE_ISVR_HASH
#       Environments:
#               $ENV{CSM_SKIP_ISVR}
#
#       Returns:
#               $::NOK or $::OK
#
#############################################################################
sub refresh_nodeattr
{
	my ($class, $ref_nodehash, $ref_ishash) = @_;
	my %NodeHash = %$ref_nodehash;
	my @nodelist = keys %NodeHash;

	if (!@nodelist)
	{
		return $::OK;
	}
	my ($ref_DestNode, $ref_lsnode_info, $ref_DestNodeHash) =
	  NodeUtils->get_target_nodes(\@nodelist);

	$ref_DestNodeHash = ServerUtils->validate_power_method($ref_DestNodeHash);

	# following codes could be deleted
	@::LSNODE_INFO = @{$ref_lsnode_info};     # All target nodes with attributes
	%::NODEHASH    = %{$ref_DestNodeHash};    # All target nodes with attributes

	# create configuration information files for each node
	if (
		ServerUtils->make_config_file(
									  \@nodelist, $ref_lsnode_info,
									  $ref_DestNodeHash
		) != 0
	   )
	{

		# Could not create configuration information files.
		MessageUtils->message('E', 'EMsgNO_ConfigFile');
		return $::NOK;
	}

	# Only node config files will be synced to IS.
	my $old_skip_isvr = $ENV{CSM_SKIP_ISVR};
	$ENV{CSM_SKIP_ISVR} = 1;
	ServerUtils->syncServers($ref_nodehash, $ref_ishash);
	$ENV{CSM_SKIP_ISVR} = $old_skip_isvr;

	return $::OK;
}

#--------------------------------------------------------------------------------

=head3    get_is_addrinfo_by_name

        Notes: 
        get address and dir of install server based on a specified node

=cut

#--------------------------------------------------------------------------------
sub get_is_addrinfo_by_name
{
	my ($class, $node) = @_;
	my ($addr,  $isaddr, $nfsaddr, $dir);

	my $akb_node = $::NODEHASH{$node}{"InstallServerAKBNode"};
	my $is       = $::NODEHASH{$node}{"InstallServer"};
	my $adp_name = $::NODEHASH{$node}{"InstallAdapterHostname"};
	my (undef, $ms_ip) =
	  NetworkUtils->getHost($::NODEHASH{$node}{"ManagementServer"});
	if (!$adp_name)
	{
		$adp_name = $node;
	}

    # split out IS addr and dir,
    # if IS is MS, default installdir to /csminstll; else to /csmserver
    ($is, $dir) = split(":", $is);
    if (!$dir)
    {
        $dir = $::SERVER_DIRECTORY;
    }

	my $ref_grp = NodeUtils->getNodegrp($is);
	if ($ref_grp)
	{
		$is = NodeUtils->getNodeFromGroup($is, $node);
	}

	if ($akb_node)
	{
		if ($is)
		{
			(undef, $addr) = NetworkUtils->getHost($is);
			$isaddr = $addr;
			if ($addr eq $ms_ip)
			{
				$dir = $::CSMINSTDIR;
			}

			# resolve InstallServerAKBNode
			$addr = ServerUtils->dshGetNodeAddr($akb_node, $addr);
			if ($addr == -1)
			{

				# if fails to resolve InstallServerAKBNode, default it
				# through "getsourceip2target InstallAdapterHostname"
				my @nodes     = ($is);
				my %options_api = ();
				$options_api{'nodes'} = join(',', @nodes);
				$options_api{'command'} = "$::GETSOURCEIP2TARGET $adp_name";
				$addr = NodeUtils->runDsh(\%options_api);
				chomp($addr);
				($addr) = $addr =~ /^$is:\s*(\d+\.\d+\.\d+\.\d+)$/;

				if (!$addr)
				{
					(undef, $addr) = NetworkUtils->getHost($addr);
				}
			}
			
			$nfsaddr = $addr;
		}
		else
		{

			# If InstallServerAKBNode is an IP address, just use it
			if (NetworkUtils->isIpaddr($akb_node))
			{
				$addr = NetworkUtils->validate_ip($akb_node);
				if ($addr == -1) { $addr = undef; }
			}
			else
			{

				# InstallServerAKBNode is not an IP address, try to
				# resolve it.
				(undef, $addr) = NetworkUtils->getHost_rveg($akb_node);
				if ($::GETHOST_RC != $::OK)
				{

					# if InstallServerAKBNode can not be resolved, default it
					# through "getsourceip2target InstallAdapterHostname"
					$addr =
					  NodeUtils->runcmd("$::GETSOURCEIP2TARGET $adp_name");
					($addr) = $addr =~ /(\d+\.\d+\.\d+\.\d+)/;
				}

			}
			$isaddr = $ms_ip;
			$nfsaddr = $addr;
			$dir = $::CSMINSTDIR;
		}
	}
	else
	{
		if ($is)
		{
			(undef, $addr) = NetworkUtils->getHost($is);
			$isaddr = $addr;
			$nfsaddr = $addr;

			if ($addr eq $ms_ip)
			{
				$dir = $::CSMINSTDIR;
			}
		}
		else
		{
			my $ns = $::NODEHASH{$node}{"NFSServer"};
			($ns, $dir) =split(/:/,$ns);
			if($ns){
				$ns = NetworkUtils->validate_ip($ns);
				if($ns == -1){
					$ns = $ms_ip;
					$dir = $::CSMINSTDIR;
				}else{
					$dir = $::CSMINSTDIR if($ns eq $ms_ip);
					$dir = $::SERVER_DIRECTORY if(!$dir); 
				}
			}else{
				$ns = $ms_ip;
				$dir = $::CSMINSTDIR;
			}
			$addr = $ms_ip;
			$isaddr = $ms_ip;
			$nfsaddr = $ns;
		}
	}

	return ($addr, $isaddr, $nfsaddr, $dir);
}

#--------------------------------------------------------------------------------

=head3    get_ns_addrinfo_by_name

        Notes: 
        get address and dir of nfs server based on a specified node 

=cut

#--------------------------------------------------------------------------------
sub get_ns_addrinfo_by_name
{
	my ($class, $node) = @_;

	my ($addr, $dir) = (undef, undef);

	my $ns = $::NODEHASH{$node}{"NFSServer"};
	my (undef, $ms_ip) =
	  NetworkUtils->getHost($::NODEHASH{$node}{"ManagementServer"});

	if ($ns)
	{
		($addr, $dir) = split(":", $ns);
		(undef, $addr) = NetworkUtils->getHost($addr);

		if ($addr eq $ms_ip)
		{
			$dir = $::CSMINSTDIR;
		}

		if (!$dir) { $dir = $::SERVER_DIRECTORY }
	}

	return ($addr, $dir);
}

#--------------------------------------------------------------------------------

=head3    get_node_addrinfo_by_name

        Notes: 
        get ip address for a target node

=cut

#--------------------------------------------------------------------------------
sub get_node_addrinfo_by_name
{
	my ($class, $node, $is) = @_;

	my $addr = undef;

	my $akb_node = $::NODEHASH{$node}{"InstallServerAKBNode"};
	my $adp_name = $::NODEHASH{$node}{"InstallAdapterHostname"};
	if (!$adp_name)
	{
		$adp_name = $node;
	}

	if ($is)
	{
		($is, undef) = NetworkUtils->getHost($is);
		$addr = ServerUtils->dshGetNodeAddr($adp_name, $is);
		if ($addr == -1)
		{
			(undef, $addr) = NetworkUtils->getHost($adp_name);
		}
	}
	else
	{
		(undef, $addr) = NetworkUtils->getHost($adp_name);
	}

	return $addr;
}

#--------------------------------------------------------------------------------

=head3    test_is_csmversion_greater_than

        Notes: 
        test whether the csm versions of specifed nodes are greater than a given 
        version

=cut

#--------------------------------------------------------------------------------

sub test_is_csmversion_greater_than
{
	my ($class, $version, $ref_nodehash, $ref_isvrhash) = @_;

	my %nodehash = %{$ref_nodehash};
	my %isvrhash = %{$ref_isvrhash};

	my ($ref_MgrAttr, $ref_ISAttr) = ServerUtils->getInstallServers(\%nodehash);

	my %ISAttr;
	if ($ref_ISAttr)
	{
		%ISAttr = %$ref_ISAttr;
	}

	my (@valid_is, @invalid_is);
	foreach my $is (keys %ISAttr)
	{
		if (exists $isvrhash{$is})
		{
			my $csmversion = $isvrhash{$is}{"InstallCSMVersion"};
			if ($csmversion ge $version)
			{
				push @valid_is, $is;
			}
			else
			{
				push @invalid_is, $is;
			}
		}
	}

	return (\@valid_is, \@invalid_is);

}

#------------------------------------------------------------------------

=head3	setNodeHash

	Notes: Set Node Attributes a new hash
	Arguments:
		$ref_nodelist:	Node List
		$lsnode_attr:	Attributes which will be put in the Hash
	Returns:
		NodeHash

=cut

#-------------------------------------------------------------------------
sub setNodeHash
{
	my ($class, $ref_nodelist, $lsnode_attr) = @_;
	my @nodelist = @$ref_nodelist;
	my %nodehash;
	my $check_delim     = ':\|:';
	my $ref_lsnode_info = NodeUtils->listNodeAttrs(\@nodelist, $lsnode_attr);

	foreach my $line (@$ref_lsnode_info)
	{
		my @attributes = split(/$check_delim/, $line);

		# Use the Hostname Attribute as the Key
		my $hostname   = $attributes[0];
		my @attr_names = split(',', $lsnode_attr);
		my $index      = 0;
		foreach my $attr (@attr_names)
		{
			$nodehash{$hostname}{$attr} = $attributes[$index];
			$index++;
		}
	}
	return %nodehash;
}

#------------------------------------------------------------------------

=head3	getInstallServerAttribute

	Notes: Get InstallServer Attribute of nodes
	Arguments:
		$ref_nodehash:	NodeHash
	Returns:
		$is:	InstallServer Attribute
		$nfs:	NFSServer Attribute
		$dir:	Directory
	Comments:
		If InstallServer is set, it will not return NFSServer attribute

=cut

#-------------------------------------------------------------------------
sub getInstallServerAttribute
{
	my ($class, $ref_nodehash) = @_;
	my ($is, $nfs, $dir);

	if ($$ref_nodehash{'InstallServer'})
	{
		$is = $$ref_nodehash{'InstallServer'};
	}
	elsif ($$ref_nodehash{'NFSServer'})
	{
		$nfs = $$ref_nodehash{'NFSServer'};
	}
	if ($is)
	{
		($is, $dir) = split ":", $is;
	}
	elsif ($nfs)
	{
		($nfs, $dir) = split ":", $nfs;
	}

	return ($is, $nfs, $dir);
}

#------------------------------------------------------------------------

=head3	setInstallServerAttribute

	Notes: Set InstallServer Attribute of nodes
	Arguments:
		$ref_nodehash:	NodeHash
		$value:			Attribute want to be set to InstallServer
	Returns:
		None
	Comments:
		If InstallServer is set, it will set NFSServer attribute to none

=cut

#-------------------------------------------------------------------------
sub setInstallServerAttribute
{
	my ($class, $ref_nodehash, $value) = @_;

	if ($$ref_nodehash{'InstallServer'})
	{

		# Cleanup NFSServer if InstallServer is set in NodeHash;
		$$ref_nodehash{'InstallServer'} = $value;
		$$ref_nodehash{'NFSServer'}     = "";
	}
	else
	{
		$$ref_nodehash{'NFSServer'} = $value;
	}
	return 1;
}

#------------------------------------------------------------------------

=head3  getTemplateDefaults 

        Notes:
                Get the values used to construct the default InstallTemplate
				based on the install method.
        Arguments:
                Node name, install method(kickstart, autoyast, etc.) 
        Returns:
                A hash containing default_tmpl, postfix and arch.
        Comments:
				Used by NodeUtils->getNodeTemplate & NodeUtils->setNodeTemplate

=cut

#-------------------------------------------------------------------------
sub getTemplateDefaults
{
	my ($class, $node, $method) = @_;
	my $routine = "getTemplateDefaults";
    print "ENTERING: $routine\n" if $::DEBUG;

	my %tmplDefaults;
	my ($default_tmpl, $postfix, $arch);
	my $node_arch = $::NODEHASH{$node}{'InstallPkgArchitecture'};
	
	# Handle the different InstallMethods
	if    ($method eq "kickstart")
	{
		$default_tmpl = $::DEFAULT_KSCFG_TMPL;
		$postfix = "";
		$arch = $node_arch =~ /i.86/ ? "" : "-$node_arch";
	}
	elsif ($method eq "kickstart-upgrade")
	{
		$default_tmpl = $::DEFAULT_KSCFG_TMPL;
		$postfix = ".upgrade";
		$arch = $node_arch =~ /i.86/ ? "" : "-$node_arch";
	}
	elsif ($method eq "autoyast")
	{
		$default_tmpl = $::DEFAULT_YASTCFG_TMPL;
		$postfix = ".xml";
		$arch = "-$node_arch";
	}
	elsif ($method eq "you")
	{
		$default_tmpl = "";
		$postfix = "";
		$arch = "";
	}
	elsif ($method eq "warewulf")
	{
		$default_tmpl = $::DEFAULT_WW_TMPL;
		$postfix = "";
		$arch = "-$node_arch";
	}
    elsif ($method eq "sis")
    {
        $default_tmpl = $::DEFAULT_SIS_TMPL;
        $postfix = "";
        $arch = "-$node_arch";
    }
	else
	{
		$default_tmpl = "";
		$postfix = "";
		$arch = "";
	}

	$tmplDefaults{default_tmpl} = $default_tmpl;
	$tmplDefaults{postfix} = $postfix;
	$tmplDefaults{arch} = $arch;

	print "LEAVING: $routine\n" if $::DEBUG;
	return %tmplDefaults;

}

#------------------------------------------------------------------------

=head3  findTemplate_KSUP

        Notes:
                Determine the install template filename for use when
				the InstallMethod=kickstart-upgrade.  This subroutine should
				only be called if InstallMethod=kickstart-upgrade.

				See the comments in the code for details on the rules this
				subroutine uses to determine the template filename.

        Arguments:
                Node name, %tmplDefaults(contains default_tmpl, postfix, arch)
        Returns:
				The install template filename.
        Comments:
				Used by NodeUtils->getNodeTemplate & NodeUtils->setNodeTemplate

=cut

#-------------------------------------------------------------------------
sub findTemplate_KSUP
{
	my ($class, $node, $ref_tmplDefaults) = @_;
	my $routine = "findTemplate_KSUP";
    print "ENTERING: $routine\n" if $::DEBUG;


	my $default_tmpl	= $$ref_tmplDefaults{default_tmpl};
	my $postfix			= $$ref_tmplDefaults{postfix};
	my $arch			= $$ref_tmplDefaults{arch};
	my $final_template;

	my $tmpl = $::NODEHASH{$node}{'InstallTemplate'};
	if (! $tmpl)
	{
		# If the InstallTemplate value is blank, then this implies to use
		# the default template file.
		$final_template = "";
	}

	# If the InstallTemplate value is filled in when 
	# InstallMethod=kickstart-upgrade, there are three cases to handle:

	# 1. Use tmpl if the string ".upgrade" appears at the end of the name.
	# This would happen if the user has explicitly changed the 
	# InstallTemplate to point to the .upgrade template file.
	elsif ($tmpl =~ /$postfix$/) 
	{
		$final_template = $tmpl;
	}

	# 2. Use tmpl.upgrade if the appended filename exists, and display a 
	# warning message indicating the template filename that was used.  
	# This would happen if the user has not changed the InstallTemplate
	# to point to an .upgrade file, but the .upgrade file exists in the
	# same directory.
	elsif (-f "$tmpl$postfix" )
	{
		my $hostname=$::NODEHASH{$node}{'Hostname'};
		$final_template = "$tmpl$postfix";
		MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
						'csminstall', 'W', 'IMsgUsingKSUpgradeTmpl', 
						$hostname, $tmpl, $final_template, $tmpl);
		print "InstallMethod='kickstart-upgrade' and InstallTemplate='$tmpl'.  Using $final_template instead of $tmpl\n" if $::DEBUG;
	}

	# 3. The provided template is not present, so use the default upgrade 
	# template and display a warning message indicating the template 
	# filename that was used.  This case might happen if the user has a
	# custom kickstart config template, but didn't create a 
	# corresponding upgrade version.  Using the default template 
	# because it will work in most cases.
	else
	{
		# Get the default kickstart-upgrade template value
		# Example:  /opt/csm/install/kscfg.tmpl.RedHatEL-AS3.upgrade
		# This value is only used for displaying the message below.  The
		# InstallTemplate attribute will be left blank.
		my $hostname=$::NODEHASH{$node}{'Hostname'};
		my $distro_name=$::NODEHASH{$node}{'InstallDistributionName'};
		my $distro_ver=$::NODEHASH{$node}{'InstallDistributionVersion'};
		my ($effective_distro_name, $effective_distro_ver) =
			NodeUtils->getEffectiveDistro($distro_name, $distro_ver);
		my $default_template_to_display =
			$default_tmpl . "."
		  . $effective_distro_name
		  . $effective_distro_ver
		  . $arch
		  . $postfix;

		MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
					'csminstall', 'W', 'IMsgUsingDefaultKSUpgradeTmpl', 
					$hostname, $tmpl, "$tmpl$postfix", 
					$default_template_to_display);
		print "InstallMethod='kickstart-upgrade' and InstallTemplate='$tmpl'.  However $tmpl$postfix cannot be found.  Using default template <TMPL>\n" if $::DEBUG;
		$final_template = "";
	}

	print "FINAL_TEMPLATE = $final_template\n" if $::DEBUG;
	print "LEAVING: $routine\n" if $::DEBUG;
	return $final_template;
}
#------------------------------------------------------------------------

=head3  findTemplate_WW

        Notes:
                Determine the install template filename for use when
				the InstallMethod=warewulf.  This subroutine should
				only be called if InstallMethod=warewulf

				See the comments in the code for details on the rules this
				subroutine uses to determine the template filename.
                 
        Arguments:
                Node name, %tmplDefaults(contains default_tmpl, postfix, arch)
        Returns:
				The install template filename.
        Comments:
				Used by NodeUtils->getNodeTemplate & NodeUtils->setNodeTemplate

=cut

#-------------------------------------------------------------------------
sub findTemplate_WW
{
	my ($class, $node, $ref_tmplDefaults) = @_;
	my $routine = "findTemplate_WW";
    print "ENTERING: $routine\n" if $::DEBUG;


	my $default_tmpl	= $$ref_tmplDefaults{default_tmpl};
	my $postfix			= $$ref_tmplDefaults{postfix};
	my $arch			= $$ref_tmplDefaults{arch};
	my $final_template;

	my $tmpl = $::NODEHASH{$node}{'InstallTemplate'};
	my $svclevel = NodeUtils->getNodeServiceLevel($node);
	my $distro_name=$::NODEHASH{$node}{'InstallDistributionName'};
	my $distro_ver=$::NODEHASH{$node}{'InstallDistributionVersion'};
	my ($effective_distro_name, $effective_distro_ver) =
			NodeUtils->getEffectiveDistro($distro_name, $distro_ver);
    $::DEFAULT_WWTEMPLECFGFILE = $default_tmpl . ".".$effective_distro_name 
								  ."$effective_distro_ver-$svclevel$arch";
	if (! $tmpl)
	{
		# If the InstallTemplate value is blank, then this implies to use
		# the default template file.
		
		$final_template = $::DEFAULT_WWTEMPLECFGFILE;
        goto OUT;
	}
    # Migrate templates from Fishkill
    # We detect if the template is current or not by defecting 
    # if some files (vnfsrpm, yum.conf) in template missing.
    if (   -d "$tmpl" 
		   && -f "$tmpl/$::WAREWULF_NODEGRP_CONF_TMPL"	
		   && -f "$tmpl/$::WAREWULF_NODE_CONF_TMPL"
		   && -f "$tmpl/$::WAREWULF_VNFS_INCLUDES_TMPL"
		   && -f "$tmpl/$::WAREWULF_VNFS_EXCLUDES_TMPL"
		   && -f "$tmpl/$::WAREWULF_VNFS_EXCLUDES_AGGRESSIVE_TMPL"
           && ( ! -f "$tmpl/$::WAREWULF_VNFS_VNFSRPM_TMPL")
           && ( ! -f "$tmpl/$::WAREWULF_YUMCONF_TMPL")
           && ( ! -f "$tmpl/$::WAREWULF_INITRD_CONF_TMPL")
	    	)
    {
        # If the template is an old style template, we do the following actions:
        #   DefaultWarewulfNodeGroupName = "$effective_distro_name$effective_distro_ver-$svclevel$arch"
        # 1. Copy <vnfs dir>/vnfsrpm.<DefaultWarewulfNodeGroupName> into the user defined template as vnfsrpm.
        # 2. Copy /etc/warewulf/wwinitrd.config.<DefaultWarewulfNodeGroupName> into user defined template as wwinitrd.config.
        # 3. Add the yum.conf file to the user defined template.
        # 4. Correct excludes and excludes-aggressive file: change "+ var/log/" to "+ var/log/*"
        #    so that "/var/log/csm" directory locates in ramdisk and writable.
        my $DefaultWarewulfNodeGroupName = "$effective_distro_name$effective_distro_ver-$svclevel$arch";
        my $vnfs_dir = NodeUtils->GetVnfsDIRFromWarewulf();
        # Step 1
        if (! -f "$vnfs_dir/$::WAREWULF_VNFS_VNFSRPM_TMPL.$DefaultWarewulfNodeGroupName")
        {
			MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
									'csminstall', 'E', 'EMsgErrorNoFoundTmplFile',
                                    "$vnfs_dir/$::WAREWULF_VNFS_VNFSRPM_TMPL.$DefaultWarewulfNodeGroupName"
									);
            MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                                    'csminstall','E1', 'EMsgWWTmplMigrateFail',
                                    $tmpl
                                    );
        }
        NodeUtils->runcmd("$::CP $vnfs_dir/$::WAREWULF_VNFS_VNFSRPM_TMPL.$DefaultWarewulfNodeGroupName ".
                           "$tmpl/$::WAREWULF_VNFS_VNFSRPM_TMPL");
        # Step 2
        if (! -f "/etc/warewulf/$::WAREWULF_INITRD_CONF_TMPL.$DefaultWarewulfNodeGroupName")
        {
			MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
									'csminstall', 'E', 'EMsgErrorNoFoundTmplFile',
                                    "/etc/warewulf/$::WAREWULF_INITRD_CONF_TMPL.$DefaultWarewulfNodeGroupName"
									);
            MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                                    'csminstall','E1', 'EMsgWWTmplMigrateFail',
                                    $tmpl
                                    );
        }
        NodeUtils->runcmd("$::CP /etc/warewulf/$::WAREWULF_INITRD_CONF_TMPL.$DefaultWarewulfNodeGroupName ".
                          "$tmpl/$::WAREWULF_INITRD_CONF_TMPL");
        # Step 3
        NodeUtils->runcmd("$::CP $::DEFAULT_WWTEMPLECFGFILE/$::WAREWULF_YUMCONF_TMPL ".
                          "$tmpl/$::WAREWULF_YUMCONF_TMPL");
        # Step 4
        my $cmd = "$::SED -i 's/^+\\\ var\\\/log\\\/".'$'."/+\\\ var\\\/log\\\/\\\*/g' ";

        NodeUtils->runcmd($cmd."$tmpl/$::WAREWULF_VNFS_EXCLUDES_TMPL");
        NodeUtils->runcmd($cmd."$tmpl/$::WAREWULF_VNFS_EXCLUDES_AGGRESSIVE_TMPL");

        MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                          'csminstall', 'I', 'IMsgWWMigTmplSucceed',
                          $tmpl);

    }

    
    # If the InstallTemplate value is filled , we need check whether the following files exists or not:
	#   1. template directory 
    #   2. config  disklessnodecfg  excludes  excludes-aggressive  includes files vnfsrpm yum.conf
	if (   -d "$tmpl" 
		   && -f "$tmpl/$::WAREWULF_NODEGRP_CONF_TMPL"	
		   && -f "$tmpl/$::WAREWULF_NODE_CONF_TMPL"
		   && -f "$tmpl/$::WAREWULF_VNFS_INCLUDES_TMPL"
		   && -f "$tmpl/$::WAREWULF_VNFS_EXCLUDES_TMPL"
		   && -f "$tmpl/$::WAREWULF_VNFS_EXCLUDES_AGGRESSIVE_TMPL"
           && -f "$tmpl/$::WAREWULF_VNFS_VNFSRPM_TMPL"
           && -f "$tmpl/$::WAREWULF_YUMCONF_TMPL"
           && -f "$tmpl/$::WAREWULF_INITRD_CONF_TMPL"
	    	)
	{
		my $basename = `$::BASENAME $tmpl`;
        chomp($basename);
		if ($basename !~ /warewulf-tmpl\./)
		{
			MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
									'csminstall', 'E1', 'EMsgErrorWWTmplName' ,$basename
									);		
		}
		# If user provieds diskless boot image  and 
		# provides kernel and initrd or zimage through DisklessBootImage, DisklessKernel and DisklessInitrd 
		# or DisklessZimage attributes in config files of the warewulf template.
		# We will do the following check:
		# 1. On system x, the DisklessKernel, DisklessInitrd and DisklessBootImage need to
		#	 be provided together with full path and name. If any of these files missed
		#	 while others are presented, displays an error message,but not exit.
		# 2. On system p, the DisklessZimage and DisklessBootImage need to be provided 
		#    together with full path and name. 

		my $ref_config_hash = NodeUtils->get_config("$tmpl/$::WAREWULF_NODEGRP_CONF_TMPL");
		if ($$ref_config_hash{'DEFAULT'}{'DisklessType'} =~ /user-ramdisk/
		   && !defined $::WW_TEMPLATE_CHECK{"$tmpl"})
		{
			my $DisklessKernel = $$ref_config_hash{'DEFAULT'}{'DisklessKernel'};
			my $DisklessInitrd = $$ref_config_hash{'DEFAULT'}{'DisklessInitrd'};
			my $DisklessZimage = $$ref_config_hash{'DEFAULT'}{'DisklessZimage'};
			my $DisklessBootImage = $$ref_config_hash{'DEFAULT'}{'DisklessBootImage'};
			my $config_file = $tmpl;
			# Remve trailing slash 
			$config_file =~ s/\/$//g;
			$config_file .="/config";
			if ($arch =~ /ppc64/)
			{
				# system p
				if ( !(   -e $DisklessZimage 
					  &&  -e $DisklessBootImage)
				   )	
				{
						(-e $DisklessZimage) 
							|| MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
															'csminstall', 'E', 'EMsgZimageNoFound', 
															$DisklessZimage
															);
						(-e $DisklessBootImage) 
							|| MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
															'csminstall', 'E', 'EMsgImageNoFound', 
															$DisklessBootImage
															);

						MessageUtils->messageFromCat('csmInstall.cat', $MSGMAPPATH,
				  							 'csminstall', 'I', 'IMsgWWUserImageForP',
											 $config_file);
				}

			}
			else
			{
				# system x
				if ( !(  -e $DisklessKernel
					  && -e $DisklessInitrd
					  && -e $DisklessBootImage
					  )
				   )
				{
						(-e $DisklessKernel) 
							|| MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
															'csminstall', 'E', 'EMsgKernelNoFound', 
															$DisklessKernel
															);
						(-e $DisklessInitrd) 
							|| MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
															'csminstall', 'E', 'EMsgInitrdNoFound', 
															$DisklessInitrd
															);
						(-e $DisklessBootImage) 
							|| MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
															'csminstall', 'E', 'EMsgImageNoFound', 
															$DisklessBootImage
															);


						MessageUtils->messageFromCat('csmInstall.cat', $MSGMAPPATH,
				  							 	'csminstall', 'I', 'IMsgWWUserImageForX',
												$config_file);

				}
			}
			# set flag
			$::WW_TEMPLATE_CHECK{"$tmpl"} = 1;
		}
		# Set user image attributes
		if ($$ref_config_hash{'DEFAULT'}{'DisklessType'} =~ /user-ramdisk/)
		{
			$::NODEHASH{$node}{"DisklessKernel"} = $$ref_config_hash{'DEFAULT'}{'DisklessKernel'};
			$::NODEHASH{$node}{"DisklessInitrd"} = $$ref_config_hash{'DEFAULT'}{'DisklessInitrd'};
			$::NODEHASH{$node}{"DisklessZimage"} = $$ref_config_hash{'DEFAULT'}{'DisklessZimage'};
            $::NODEHASH{$node}{"DisklessBootImage"} = $$ref_config_hash{'DEFAULT'}{'DisklessBootImage'};
		}

		$final_template = "$tmpl";
		print "InstallMethod='warewulf' and InstallTemplate='$tmpl'. \n" if $::DEBUG;
	}
	# Template files are not entire or error templatename. 
	else
	{
		MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
									'csminstall', 'E1', 'EMsgErrorWWTmpl', 
					 				$tmpl, 
									);
		print "InstallMethod='warewulf' and InstallTemplate='$tmpl'.  However $tmpl cannot be found.  Using default template <TMPL>\n" if $::DEBUG;
		
		$final_template = $::DEFAULT_WWTEMPLECFGFILE;
	}
    OUT:
    # The InstallImage attribute should be blank for warewulf install method.
    # So far, we don't use this attribute for linux diskless installation.
    if ($::NODEHASH{$node}{'InstallImage' ne ''}
        && !defined $::WW_InstallImage_CHECK{"$final_template"})
    {
        MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
            'csminstall', 'I', 'IMsgIstImageSetError4Diskless'
        );	
        $::WW_InstallImage_CHECK{"$final_template"} = 1;    
    }
    # Set DisklessType attribute
    my $ref_tmpl_hash = NodeUtils->get_config("$final_template/$::WAREWULF_NODEGRP_CONF_TMPL");
	$::NODEHASH{$node}{"DisklessType"} = $$ref_tmpl_hash{'DEFAULT'}{'DisklessType'};  
    chomp($::NODEHASH{$node}{"DisklessType"});
    # Check diskless type validity
    my @valid_type = ('user-ramdisk', 'ramdisk', 'hybrid');
    my $found = 0;
    foreach my $type (@valid_type)
    {
        $found = 1 if ( $::NODEHASH{$node}{"DisklessType"} eq $type)
    }
    if (!$found)
    {
        MessageUtils->message('E1', 'EMsgDisklessTypeBAD_ATTR', "$final_template/config");
        $::GLOBAL_EXIT = 1;
    }
	print "FINAL_TEMPLATE = $final_template\n" if $::DEBUG;
	print "LEAVING: $routine\n" if $::DEBUG;
	return $final_template;
}

#------------------------------------------------------------------------

=head3  getNodeTemplate 

        Notes:
                This sub routine is used to get the node InstallTemplate, 
        Arguments:
                Node name, method(kickstart, autoyast, etc.) 
        Returns:
                the InstallTemplate file name with full path, 
		if the InstallTemplate is blank, the default template file
		name will be returned.
				For InstallMethod=kickstart-upgrade, .upgrade will be
				appended to the end of the InstallTemplate attribute.
				See the comments in the subroutine for details.
        Comments:

=cut

#-------------------------------------------------------------------------
sub getNodeTemplate
{
    my ($class, $node, $method) = @_;
    my $routine = "getNodeTemplate";
    print "ENTERING: $routine\n" if $::DEBUG;

    my ($default_tmpl, $postfix, $arch, $node_arch, $distro_name, $distro_ver);
	my $final_template = "";

	my %tmplDefaults = NodeUtils->getTemplateDefaults($node, $method);
	$default_tmpl 	= $tmplDefaults{"default_tmpl"};
	$arch 			= $tmplDefaults{"arch"};
	$postfix 		= $tmplDefaults{"postfix"};

=head4  COMMENTED OUT CODE - USE getTemplateDefaults instead
	$node_arch=$::NODEHASH{$node}{'InstallPkgArchitecture'};

	# Handle the different InstallMethods
	if    ($method eq "kickstart")
	{
		$default_tmpl = $::DEFAULT_KSCFG_TMPL;
		$postfix = "";
		$arch = $node_arch =~ /i.86/ ? "" : "-$node_arch";
	}
	elsif ($method eq "kickstart-upgrade")
	{
		$default_tmpl = $::DEFAULT_KSCFG_TMPL;
		$postfix = ".upgrade";
		$arch = $node_arch =~ /i.86/ ? "" : "-$node_arch";
	}
	elsif ($method eq "autoyast")
	{
		$default_tmpl = $::DEFAULT_YASTCFG_TMPL;
		$postfix = ".xml";
		$arch = "-$node_arch";
	}
	elsif ($method eq "you")
	{
		$default_tmpl = "";
		$postfix = "";
		$arch = "";
	}
	elsif ($method eq "warewulf")
	{
		$default_tmpl = $::DEFAULT_WW_TMPL;
		$postfix = "";
		$arch = "-$node_arch";
	}
	else
	{
		$default_tmpl = "";
		$postfix = "";
		$arch = "";
	}
=cut

	if ($::NODEHASH{$node}{'InstallTemplate'})
	{
		if ($method eq "kickstart-upgrade")
		{

			$final_template = NodeUtils->findTemplate_KSUP($node, \%tmplDefaults);

=head4 COMMENTED OUT CODE - USE findTemplate_KSUP instead
			# If the InstallTemplate value is filled in when 
			# InstallMethod=kickstart-upgrade, there are three cases to handle:

			my $tmpl = $::NODEHASH{$node}{'InstallTemplate'};

			# Use tmpl if the string ".upgrade" appears at the end of the name.
			# This would happen if the user has explicitly changed the 
			# InstallTemplate to point to the .upgrade template file.
			if ($tmpl =~ /$postfix$/) 
			{
				$final_template = $tmpl;
			}

			# Use tmpl.upgrade if the appended filename exists, and display a 
			# warning message indicating the template filename that was used.  
			# This would happen if the user has not changed the InstallTemplate
			# to point to an .upgrade file, but the .upgrade file exists in the
			# same directory.
			elsif (-f "$tmpl$postfix" )
			{
				$final_template = "$tmpl$postfix";
				MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
								'csminstall', 'W', 'IMsgUsingKSUpgradeTmpl', 
								$tmpl, $final_template, $tmpl);
				print "InstallMethod='kickstart-upgrade' and InstallTemplate='$tmpl'.  Using $final_template instead of $tmpl\n" if $::DEBUG;
			}

			# The provided template is not present, so use the default upgrade 
			# template and display a warning message indicating the template 
			# filename that was used.  This case might happen if the user has a
			# custom kickstart config template, but didn't create a 
			# corresponding upgrade version.  Using the default template 
			# because it will work in most cases.
			else
			{
				MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
							'csminstall', 'W', 'IMsgUsingDefaultKSUpgradeTmpl', 
							$tmpl, "$tmpl$postfix");
				print "InstallMethod='kickstart-upgrade' and InstallTemplate='$tmpl'.  However $tmpl$postfix cannot be found.  Using default template <TMPL>\n" if $::DEBUG;
				$final_template = "";
			}
=cut

		}
		elsif ($method eq "warewulf")
		{
			$final_template = NodeUtils->findTemplate_WW($node, \%tmplDefaults);
		}

		else # InstallTemplate filled in, but InstallMethod != kickstart-upgrade
		{
			$final_template = $::NODEHASH{$node}{'InstallTemplate'};
		}
	}

	# If InstallTemplate is blank, or if InstallMethod=kickstart-upgrade and 
	# specified file does not exist.
	if (! $final_template) 
	{
		if ($method eq "warewulf")
		{
			$final_template = NodeUtils->findTemplate_WW($node, \%tmplDefaults);
		}
        elsif ($method eq "sis")
        {
            $final_template = $default_tmpl;
        }
		else
		{
			# Get the default install template value if InstallTemplate is blank
			# Example:  /opt/csm/install/kscfg.tmpl.RedHatEL-AS3
			$distro_name=$::NODEHASH{$node}{'InstallDistributionName'};
			$distro_ver=$::NODEHASH{$node}{'InstallDistributionVersion'};
			my ($effective_distro_name, $effective_distro_ver) =
				NodeUtils->getEffectiveDistro($distro_name, $distro_ver);
			$final_template =
				$default_tmpl . "."
			  . $effective_distro_name
			  . $effective_distro_ver
			  . $arch
			  . $postfix;
		}
	}

	print "FINAL VALUE OF template = $final_template\n" if $::DEBUG;
	print "LEAVING: $routine\n" if $::DEBUG;
	return $final_template;
}

#--------------------------------------------------------------------------------

=head3	setNodeTemplate

        Notes:
			Check that the install template file is valid, and set the
			InstallTemplate attribute if provided with csmsetupinstall -k.
			
			Do the following:
			  1. Make sure valid install method provided.
			  2. If user provided template file with csmsetupinstall -k flag:
			  		- set InstallTemplate attribute to provided value.
			  3. Compare the default template filename with the user-provided
			     template to make sure the user provided a compatible template.
			  4. If in a DC environment (non-CSM), and install template not 
			     provided, set it to the special "DC" default template.

=cut

#--------------------------------------------------------------------------------

sub setNodeTemplate
{
	my ($class, $method, $ref_node_hash) = @_;
	my $routine = "setNodeTemplate";
	print "ENTERING: $routine\n" if $::DEBUG;

    # Only 'autoyast' and 'kickstart' install methods are supported in DC environment.

    if (  $ENV{'DC_ENVIRONMENT'} ne 'CSM'
       && $ENV{'DC_ENVIRONMENT'})
    {
        if ($method ne "autoyast" &&
            $method ne "kickstart")
        {
            my @nodelist = keys(%$ref_node_hash);
            MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                                         'csminstall', 'E1', 'EMsgINVALID_INSTALL_METHOD',
                                         join(',',@nodelist ));
        }   
    }
    else
    {
        if ($method ne "autoyast" && 
            $method ne "kickstart" && 
            $method ne "kickstart-upgrade" &&
            $method ne "warewulf")
        {
            MessageUtils->message('E1', 'EMsgInvalidMethod');
        }
    }


	my (@nodeList, $ConfigTemplate, $compatibleTemplate);

	# LocalKscfg_tmpl is the argument of csmsetupinstall's -k flag
	if ($::LocalKscfg_tmpl ne '')
	{
		@nodeList       = keys(%$ref_node_hash);
		$ConfigTemplate = $::LocalKscfg_tmpl;
		foreach my $node (@nodeList)
		{
			$$ref_node_hash{$node}{'InstallTemplate'} = $ConfigTemplate;
		}
	}
	else
	{

		foreach my $node (keys(%$ref_node_hash))
		{
			# Get a hash containing default_tmpl, postfix and arch.
			my %tmplDefaults = NodeUtils->getTemplateDefaults($node, $method);
			my $default_tmpl = $tmplDefaults{"default_tmpl"};
			my $node_arch 	 = $tmplDefaults{"arch"};
			my $postfix 	 = $tmplDefaults{"postfix"};

			my $distro_name=$$ref_node_hash{$node}{'InstallDistributionName'};
			my $distro_ver=$$ref_node_hash{$node}{'InstallDistributionVersion'};

			if ($method eq "kickstart-upgrade")
			{
				$ConfigTemplate = NodeUtils->findTemplate_KSUP($node, \%tmplDefaults);
			}
			#
			# Add something here for warewulf to handle its 
			# template directories.
			#
			elsif ($method eq "warewulf" )
			{
				$ConfigTemplate = NodeUtils->findTemplate_WW($node, \%tmplDefaults);
			}
			else
			{
				my ($effective_distro_name, $effective_distro_ver) =
					NodeUtils->getEffectiveDistro(
							$$ref_node_hash{$node}{'InstallDistributionName'},
							$$ref_node_hash{$node}{'InstallDistributionVersion'}
							);

				# Example:  /opt/csm/install/kscfg.tmpl.RedHatEL-AS3
				$ConfigTemplate =
					$default_tmpl . "."
					. $effective_distro_name
					. $effective_distro_ver
					. $node_arch
					. $postfix;

				#For x86_64 RedHat nodes, 
				#the ia32e template can be used. 
				if (($node_arch eq 'x86_64')
					&& ($distro_name =~ /RedHat/))
				{
					$compatibleTemplate =
						$default_tmpl . "."
						. $distro_name
						. $distro_ver
						. "-ia32e" 
						. $postfix;
				}
			}
			if ( ($$ref_node_hash{$node}{'InstallTemplate'})
				&& ($$ref_node_hash{$node}{'InstallTemplate'} ne $ConfigTemplate)
				&& ($$ref_node_hash{$node}{'InstallTemplate'} ne $compatibleTemplate)
				&& !$::DEPLOY_ATTR_CHECKED)
			{
				MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
								'csminstall', 'W', 'IMsgTemplateNotMatch', 
								$$ref_node_hash{$node}{'InstallTemplate'}, 
								$node, $ConfigTemplate);
			}
			# If $final_template != $::DEFAULT_WWTEMPLECFGFILE , give a warning message

#			if ( ($method eq "warewulf" )
#				 && ($ConfigTemplate ne $::DEFAULT_WWTEMPLECFGFILE)
#				 && ($$ref_node_hash{$node}{'InstallTemplate'})
#				 && (!$::DEPLOY_ATTR_CHECKED)
#			   )
#			{
#					MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
#									'csminstall', 'W', 'IMsgTemplateNotMatch', 
#									$ConfigTemplate, 
#									$node, $::DEFAULT_WWTEMPLECFGFILE);	
#			}

                        # If the MS is RedHat and the target node is SLES, then use the DC yastcfg file.
                        my $ms_distro_name = NodeUtils->get_DistributionName();
                        my $ms_distro_ver = NodeUtils->get_DistributionVersion();
			if (((($::PLTFRM eq "AIX")
			       || (defined($ENV{'DC_ENVIRONMENT'}) && $ENV{'DC_ENVIRONMENT'} ne "CSM" )
			      )
			      && $node_arch =~/ppc64/
			      && $method eq "autoyast" ) || ((!defined($ENV{'DC_ENVIRONMENT'}) || $ENV{'DC_ENVIRONMENT'} eq "CSM") && $ms_distro_name =~ /RedHat/ && $ms_distro_ver >= 5 && $method eq "autoyast" && $node_arch =~ /ppc64/)
			      || ((!defined($ENV{'DC_ENVIRONMENT'}) || $ENV{'DC_ENVIRONMENT'} eq "CSM") && ($node_arch =~ /i.86/ || $node_arch =~ /x86_64/) && $ms_distro_name =~ /RedHat/ && $method eq "autoyast"))
			{
				$ConfigTemplate =  
					$default_tmpl . "."
      				. $distro_name
      				. $distro_ver
      				. $node_arch
      				. "-DC"
					. $postfix;

				$$ref_node_hash{$node}{'InstallTemplate'} = $ConfigTemplate;
				
			}
		}
	}
	
	# setuphwmaint should not set node attribute in database
	return if ($::HWMAINT);

	return if (!-f "/usr/bin/chrsrc-api");

	# If @nodeList is set, it means that the template file was provided with
	# the csmsetupinstall -k flag, so set the InstallTemplate attribute to 
	# the provided template filename.
	if (@nodeList)
	{

		my %attrs = (
			InstallTemplate => "$ConfigTemplate",
		);
		my $where = NodeUtils->quote("Hostname IN ('XXX')");
		my $chstr = 
		  "-s IBM.ManagedNode##${where}##" . NodeUtils->quote(join('##', %attrs));
		NodeUtils->runrmccmd('chrsrc-api', "-i -I'##'", $chstr, 1, \@nodeList);

		print "LEAVING: $routine\n" if $::DEBUG;
		return $::RUNCMD_RC;
	}
	print "LEAVING: $routine\n" if $::DEBUG;
}

#------------------------------------------------------------------------

=head3	arrangeNodeFromGroup

	Notes: 
	Given a fixed group of nodes and a fixed group of install servers,
	this subroutine will ensure getNodeFromGroup returns same install server for one node in different processes. 
	Arguments:
	
	Returns:
		None
	Comments:

=cut

#-------------------------------------------------------------------------
sub arrangeNodeFromGroup
{

	my ($ref_MgtNodes, $ref_InstallServers) =
	  ServerUtils->getInstallServers(\%::NODEHASH);
	my %InstallServers = %$ref_InstallServers;

	foreach my $is (keys %InstallServers)
	{
		if ($InstallServers{$is}{isGrp})
		{
			my $ref_group = NodeUtils->getNodegrp($is);

			if (!($ref_group)) { next; }
			my @glist = @$ref_group;

			my @nodelist = @{$InstallServers{$is}{nodelist}};
			my @sorted   = sort @nodelist;
			my $target   = 0;
			foreach my $node (@sorted)
			{
				$NodeUtils::NodegrpNode{$node} = $glist[$target++];
				if ($target > $#glist) { $target -= ($#glist + 1); }
			}
		}
	}

}

#------------------------------------------------------------------------

=head3	getUsingMSNodes

	Notes: 
		Get the nodes which don't use InstallServer
	Arguments:
		$ref_nodehash:	Reference to Node Hash
	Returns:
		@nodes:	Node List
	Comments:

=cut

#-------------------------------------------------------------------------
sub getUsingMSNodes
{
	my ($class, $ref_nodehash) = @_;

	my @nodes;

	if ($ref_nodehash)
	{
		foreach my $node (keys %$ref_nodehash)
		{
			if (! $$ref_nodehash{$node}{'InstallServer'} )
			{
				push @nodes, $node;
			}
		}
	}
	return @nodes;
}

#------------------------------------------------------------------------

=head3	get_file_realpath

	Notes: 
		This sub routine is used to get the absolute path of a file.
	Arguments:
		opposite path of a file	
	Returns:
		$realpath	Absolute path of the file
		"0" 		file doesn't exist
	Comments:

=cut

#-------------------------------------------------------------------------
sub get_file_realpath
{
	my ($class,$file)=@_;
	my ($dir,$realpath,$filename);
	if(! -f $file)
	{
		return 0;
	}
	if ( $file =~ /^(.*\/)([^\/]*)$/)
	{
		$dir = $1;
		$filename = $2;
	}
	else
	{
		$dir = ".";
		$filename = $file;
	}

	my $orig_dir = Cwd::getcwd();
	chdir($dir);
	$realpath = Cwd::getcwd();
	$realpath .= "/".$filename;

	chdir($orig_dir);
	return ($realpath);
}

#------------------------------------------------------------------------

=head3	filter_dhcp_output

	Notes: 
		This sub routine is used to get rid of the 
		"Added/Removed" lines from the makedhcp output.
	Arguments:
		reference to the original output	
	Returns:
		the processed output as a single string.  	
	Comments:

=cut

#-------------------------------------------------------------------------
sub filter_dhcp_output
{
	my ($class,$output_ref)=@_;
        my $output;
        my @output_lines;
        foreach my $line (@$output_ref)
        {
            next if(($line =~ /Added/)||($line =~ /Removed/));
            push @output_lines, $line."\n";
        }
        $output = join('', @output_lines);
        chomp($output);

	return ($output);
}

#------------------------------------------------------------------------

=head3 refresh_nodehash	

	Notes: 
		This sub routine is used to read the RSCT registry again
        to refresh the node hash attributes. 
	Arguments:
		reference to the original nodehash
	Returns:
		reference to the derived nodehash  	
	Comments:

=cut

#-------------------------------------------------------------------------
sub refresh_nodehash
{
    my ($class, $ref_nodehash) = @_;
    my %NodeHash = %$ref_nodehash;
    my @nodelist = keys %NodeHash;

    if (!@nodelist)
    {
        return;
    }

    # read in node attributes from RSCT registry.
    my ($ref_DestNode, $ref_lsnode_info, $ref_DestNodeHash) =
      NodeUtils->get_target_nodes(\@nodelist);

    $ref_DestNodeHash = ServerUtils->validate_power_method($ref_DestNodeHash);

    # regenerate the nodeinfo hash with more derived attributes.
    my $nodeinfo_hash = ServerUtils->make_nodeinfo_hash($ref_DestNodeHash );

    return $nodeinfo_hash;
}

################################################################################
#
# getFilePathListInDirList
#
#    return some files in some directories
#    It will NOT return dirctories or ruined links
#
# Argument:
#    $files         one scalcar which contains *. For example, *.rpm
#    @dirList       one array which contains all the target dirctories.
#                   If * is used, it must be placed at the end of one directory.
#                   For example, "/tmp/*" can be allowed as one directory argument
#                   But "/tmp/*/tmp" is not allowed.
#
# Return:
#    @fileList      All the files that match the requirement.
#                   These files have directories.
#    
################################################################################
sub getFilePathListInDirList
{
	shift;
	my $files = shift;
	my @dirList = @_;
	my @fileList = ();

	for my $dir (@dirList)
	{
		# use find to avoid the "too many args" error of ls on AIX
		my @fileListInOneDir = NodeUtils->runcmd("find $dir/ -name \"$files\" -print", -1);
		if ($::RUNCMD_RC)
		{
			# avoid empty error messages.
			if (scalar(@fileListInOneDir) && !$::SEARCH_ERROR{$dir})
			{
				my $errmsg = join(" ", @fileListInOneDir);
				MessageUtils->messageFromCat(
						 'csmInstall.cat', $::MSGMAPPATH,
						 'csminstall',     'I',
						 'IMsgSearchDirFailed', 
						 $dir,	 $errmsg); 
				$::SEARCH_ERROR{$dir} = 1;
			}
		}
		for my $fileInOneDir ( @fileListInOneDir)
		{
			if (-f $fileInOneDir)
			{
				push @fileList, $fileInOneDir;
			}
		}
	}
	
	return @fileList;
}

sub clearBlank
{
	shift;
	my $string = shift;
	$string =~ s/^\s*(.*?)\s*$/$1/;
	return $string;
}

sub getAbsolutePath
{
    shift;
    my $path = shift;
    my $currentDir;
    if ( $path !~ /^\s*\//)
    {
        $path = Cwd::getcwd() . '/' . $path;
    }
    my @dirNames = split( '/', $path);
    my @absDirNames;
    for my $dir (@dirNames)
    {
        next if ( $dir eq '.'  || $dir eq '');
        if ( $dir eq '..')
        {
            pop @absDirNames if ( scalar(@absDirNames) > 0);
            next;
        }
        push @absDirNames, $dir;
    }
    return '/' . join '/', @absDirNames;
}
        
sub getDistroAndSvcLevel
{
    # following 4 global variables are uesd as a internal static variable,
    # they should only be accessed in this subroutine
    
    # $::_DISTRO_NAME;
    # $::_DISTRO_VER;
    # $::_DISTRO_ARCH;
    # $::_DISTRO_SVC_LEVEL;
    
    if ( $::_DISTRO_NAME && $::_DISTRO_VER && $::_DISTRO_SVC_LEVEL && $::_DISTRO_ARCH)
    {
        return ( $::_DISTRO_NAME, $::_DISTRO_VER, $::_DISTRO_SVC_LEVEL, $::_DISTRO_ARCH);
    }
    
    if ( scalar(keys %::distro_id) <= 0)
    {
        if ( !NodeUtils->loadPkgdefsInDefaultPath( "distro_id.pm"))
        {
print "File distro_id.pm cannot be found in default directory!\n";
exit 1;
        }
        NodeUtils->supplementEffectiveDistro();
    }
    
    my $arch = NodeUtils->getLinuxArch;
    
    my %id_val_buf;
    foreach my $distro (keys %::distro_id)
    {
        #check if all attributes in %::distro_id have been set
        if ( !$::distro_id{$distro}{'distro_name'} ||
             !$::distro_id{$distro}{'distro_version'} ||
             !$::distro_id{$distro}{'svc_level'} ||
             !$::distro_id{$distro}{'arch'} ||
             !$::distro_id{$distro}{'id_name'} ||
             !$::distro_id{$distro}{'id_type'} ||
             !$::distro_id{$distro}{'id_val'}
           )
        {
print "Values for distribution $distro have not been set correctly in DistroIdntf.pm, this distribution will not be supported!\n";           
            next;
        }
        
        next if ( $::distro_id{$distro}{'arch'} ne $arch);
        
        my $id_name = $::distro_id{$distro}{'id_name'};
        if ( !$id_val_buf{$id_name})
        {
            if ( $::distro_id{$distro}{'id_type'} eq 'file')
            {
                if ( -f $::distro_id{$distro}{'id_name'})
                {
                    $id_val_buf{$id_name} = NodeUtils->readFile($::distro_id{$distro}{'id_name'});
                    if ( !$id_val_buf{$id_name})
                    {
                        $id_val_buf{$id_name} = '***Invalid Resource***';
                    }
                }
                else
                {
                    $id_val_buf{$id_name} = '***Invalid Resource***';
                }
            }
            elsif ( $::distro_id{$distro}{'id_type'} eq 'rpm_version')
            {
                if (NodeUtils->isHMC())
                {
                    $id_val_buf{$id_name} = '***Invalid Resource***';
                }else
                {
                    $id_val_buf{$id_name}=
                        NodeUtils->runcmd("rpm -q --qf '%{Version}-%{Release}' $::distro_id{$distro}{'id_name'}", -1);
                    if ( $::RUNCMD_RC != 0)
                    {
                        $id_val_buf{$id_name} = '***Invalid Resource***';
                    }
                }
            }
            elsif ( $::distro_id{$distro}{'id_type'} eq 'command')
            {
                $id_val_buf{$id_name}= NodeUtils->runcmd($::distro_id{$distro}{'id_name'}, -1);
                if ( $::RUNCMD_RC != 0)
                {
                    $id_val_buf{$id_name} = '***Invalid Resource***';
                }
            }
            else
            {
print "The resource type of distribution $distro is incorrect, the valid resource type are file,rpm_version and command!\n";
                next;
            }
        }
        if ( $id_val_buf{$id_name} eq '***Invalid Resource***')
        {
            next;
        }
        
        if ( $::distro_id{$distro}{'id_type'} eq 'rpm_version')
        {
            if ( $::distro_id{$distro}{'id_val'} =~ /^\s*(\S+)\s*,\s*(\S+)\s*$/)
            {
                my ( $low_version, $high_ver) = ( $1, $2);
                if ( !ArchiveUtils->isVersionInRange( $id_val_buf{$id_name},$low_version, $high_ver))
                {
                    next;
                }
            }elsif ($::distro_id{$distro}{'id_val'} =~ /^\s*(\S+)\s*$/)
            {
                my $version = $1;
                if ( !ArchiveUtils->isVersionInRange( $id_val_buf{$id_name},$version, $version))
                {
                    next;
                }
            }elsif ( $::distro_id{$distro}{'id_val'} !~ /\Q$id_val_buf{$id_name})\E/)
            {
                next;
            }
        }
        else
        {
            if ( $id_val_buf{$id_name} !~ /\Q$::distro_id{$distro}{'id_val'}\E/)
            {
                next;
            }
        }
        ( $::_DISTRO_NAME, $::_DISTRO_VER, $::_DISTRO_SVC_LEVEL, $::_DISTRO_ARCH) =
            ($::distro_id{$distro}{'distro_name'}, 
             $::distro_id{$distro}{'distro_version'},
             $::distro_id{$distro}{'svc_level'},
             $::distro_id{$distro}{'arch'});
        return ( $::_DISTRO_NAME, $::_DISTRO_VER, $::_DISTRO_SVC_LEVEL, $::_DISTRO_ARCH);
    }
    return ( $::UNSUPPORTED_DISTRO, 0, 0, $arch);
}

sub loadPkgdefsInDefaultPath
{
    shift;
    my $distroIdntfFile = shift;
    my $progdir = $0;
    $progdir =~ s/\/[^\/]*$/\//g;
    if (defined $::ENV{'CSM_MOUNT_POINT_ON_NODE'})
    {
        $progdir = "$::ENV{'CSM_MOUNT_POINT_ON_NODE'}/csm";
        do "$progdir/pkgdefs/$distroIdntfFile";
    }
    elsif (-f "$progdir/pkgdefs/$distroIdntfFile")
    {
        do "$progdir/pkgdefs/$distroIdntfFile";
    }
    elsif ( -f "/opt/csm/install/pkgdefs/$distroIdntfFile")
    {
        do "/opt/csm/install/pkgdefs/$distroIdntfFile";
    }
    elsif ( -f "/var/opt/csm/mnt/csm/pkgdefs/$distroIdntfFile")
    {
        do "/var/opt/csm/mnt/csm/pkgdefs/$distroIdntfFile";
    }
    else
    {
        return 0;
    }
    return 1;
}

sub getLinuxArch
{
use Switch;
    my $cmd    = "$::UNAME -m";
    my $output = NodeUtils->runcmd($cmd);
    chomp($output);
    if ( $output =~ /i.86/)
    {
        return "i386";
    }
    elsif( $output =~ /x86_64/)
    {
        return "x86_64";
    }
    elsif( $output =~ /ppc64/)
    {
        return "ppc64";
    }
    else
    {
        return undef;
    }
}

sub getDistroID
{
    shift;
    my $distro_name = shift;
    my $distro_ver = shift;
    my $svc_level = shift;
    my $arch = shift;
    if ( scalar(keys %::distro_id) <= 0)
    {
        if ( !NodeUtils->loadPkgdefsInDefaultPath( "distro_id.pm"))
        {
print "File DistroIdntf.pm cannot be found in default directory!\n";
exit 1;
        }
        NodeUtils->supplementEffectiveDistro();
    }
    for my $distro (keys %::distro_id)
    {
       if ( $::distro_id{ $distro}{ 'distro_name'} eq  $distro_name &&
            $::distro_id{ $distro}{ 'distro_version'} eq $distro_ver &&
            $::distro_id{ $distro}{ 'svc_level'} eq $svc_level &&
            $::distro_id{ $distro}{ 'arch'} eq $arch )
       {
           return %{$::distro_id{ $distro}};
       }
       next;
    }
    return undef;
}

sub getEffectiveDistro
{   
    shift;
    my $distro_name = shift;
    my $distro_ver = shift;
    my $svc_level = shift;
    if ( scalar(keys %::distro_id) <= 0)
    {
        if ( !NodeUtils->loadPkgdefsInDefaultPath( "distro_id.pm"))
        {
print "File DistroIdntf.pm cannot be found in default directory!\n";
exit 1;
        }
        NodeUtils->supplementEffectiveDistro();
    }
    
    if ( !$distro_name)
    {
        return undef;
    }
    elsif ( !$distro_ver) #only effective distro name is needed
    {
        for my $distro (keys %::distro_id)
        {
           if ( $::distro_id{ $distro}{ 'distro_name'} eq  $distro_name )
           {
               return ( $::distro_id{ $distro}{ 'effective_distro_name'});
           }
           next;
        }
    }
    elsif ( !$svc_level)
    {
        for my $distro (keys %::distro_id)
        {
           if ( $::distro_id{ $distro}{ 'distro_name'} eq  $distro_name &&
                $::distro_id{ $distro}{ 'distro_version'} eq $distro_ver) 
           {
               return ( $::distro_id{ $distro}{ 'effective_distro_name'},
                        $::distro_id{ $distro}{ 'effective_distro_ver'});
           }
           next;
        }
    }
    else
    {
        for my $distro (keys %::distro_id)
        {
           if ( $::distro_id{ $distro}{ 'distro_name'} eq  $distro_name &&
                $::distro_id{ $distro}{ 'distro_version'} eq $distro_ver &&
                $::distro_id{ $distro}{ 'svc_level'} eq $svc_level) 
           {
                return ( $::distro_id{ $distro}{ 'effective_distro_name'},
                         $::distro_id{ $distro}{ 'effective_distro_ver'},
                         $::distro_id{ $distro}{ 'effective_svc_level'});
           }
           next;
        }
    }
} 

    
sub supplementEffectiveDistro
{
    if ( scalar(keys %::distro_id) > 0)
    {
        for my $distro (keys %::distro_id)
        {
            if ( !$::distro_id{ $distro}{ 'effective_distro_name'})
            {
                $::distro_id{ $distro}{ 'effective_distro_name'} = $::distro_id{ $distro}{ 'distro_name'};
            }
            if ( !$::distro_id{ $distro}{ 'effective_distro_ver'})
            {
                $::distro_id{ $distro}{ 'effective_distro_ver'} = $::distro_id{ $distro}{ 'distro_version'};
            }
            if ( !$::distro_id{ $distro}{ 'effective_svc_level'})
            {
                $::distro_id{ $distro}{ 'effective_svc_level'} = $::distro_id{ $distro}{ 'svc_level'};
            }
        }
    }
}
                    
                    

#=============================Changed Subroutines================================

#--------------------------------------------------------------------------------

=head3    distribution

     Returns the distribution and version of the current machine in the
    form:
        <distro> <version>

    Arguments:
        none
    Returns:
        distro and version strings separated by a space.
    Globals:
        none
    Error:
        Returns undef if it is an unknown distro.
    Example:
         NodeUtils->distribution();
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub distribution
{
    my ( $distro_name, $distro_ver, $distro_svc_level, $distro_arch) 
        = NodeUtils->getDistroAndSvcLevel;
    return $distro_name . ' ' . $distro_ver;
}

#--------------------------------------------------------------------------------

=head3    getServiceLevelIS

        Linux only routine.

        Returns the service level of the Install Server.

        Arguments:
             $disable_warning_msg: Prevent warning message from being prompted. 
        Returns:
                
        Globals:
                $::PLTFRM
                $::INSTALLPCMD
        Error:
                messageFromCat E2
        Example:
                
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub get_ServiceLevel
{
    my ($class,$disable_warning_msg) = @_;
    
    my $sp = "";

    if ($::PLTFRM eq "Linux")
    {
        my ( $distro_name, $distro_ver, $distro_svc_level, $distro_arch) 
            = NodeUtils->getDistroAndSvcLevel;
        $sp = $distro_svc_level;
    }
    elsif($::PLTFRM eq "AIX")
    {
        $sp = '';
    }
    else
    {
        NodeUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH, 'csminstall',
                                  'E2', 'EMsgINVALID_OSTYPE');
    }
    return $sp;

}

#--------------------------------------------------------------------------------

=head3    isHMC

    returns 1 if localHost is an HMC 

    Arguments:
        none
    Returns:
        1 - localHost is HMC 
        0 - localHost is  not an HMC
    Globals:
        none
    Error:
        none
    Example:
         if (NodeUtils->isHMC()) { blah; }
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub isHMC
{
	my $hmcfile = "/opt/hsc/data/hmcType.properties";
	if (-e $hmcfile) { return 1; }
	else { return 0; }
}
#--------------------------------------------------------------------------------

=head3    isVIO
    Should be used only when on the HMC, run NodeUtils->isHMC before calling
    returns 1 if the node is a VIO server   

    Arguments:
        Node name or ip address 
    Returns:
        1 - Node is a VIO server 
        0 - Node is not a VIO server 
    Globals:
        none
    Error:
        none
    Example:
         if (NodeUtils->isVIO($nodeipaddr)) { more code; }
    Comments:
        none

=cut

#--------------------------------------------------------------------------------

sub isVIO

{
    my ($class,$node) = @_;
    my %opthash;
	my @node_array=$node;
	if (exists($::VIOhash{$node})) {  # already det VIO 
	 return 1; 
	} else {  # have not see this node

	  my $ref_lsnode_info =
	  NodeUtils->listNodeAttrs(\@node_array, "InstallOSName", \%opthash);
	    my @lsnode_info = @$ref_lsnode_info;
	    if (@lsnode_info) {

	     foreach my $line (@lsnode_info){
	       chomp $line;
	       if ($line eq "") {   # no InstallOSName then it is a VIO server
		    $::VIOhash{$node}=$node; # store the VIO server
		     return 1;
           } else {
		     return 0;
	       }
	     }
        } else {  # empty array, node not in DB,  must be HMC
         return 0;  
        }	   
   }	   
}

#--------------------------------------------------------------------------------

=head3    getSupportedDistro

        Get the currently supported distribution by CSM, as management server, install server, managed node or diskless node.

        Arguments:
           $officially_supported - if this argument is set, only return the distros that CSM officially supported. This argument can be used for CSM messages to indicate the distributions that CSM officially supported 
              
        Returns:
           A hash that contains all the supported distribution by CSM, the keys are 'MgmtServer', 'InstallServer', 'MgdNode' and 'diskless'. The distribution names are separated by commas.
           If get the supported distributions failed, returns null.

        Globals:
                $::pkgdefs

        Example:
                my %supported_distro = NodeUtils->getSupportedDistribution;
                
        Comments:
                none

=cut

#--------------------------------------------------------------------------------

sub getSupportedDistro 
{
    my ($class, $officially_supported) = @_;
    my %supported_distro = ();

    # Backup the %::pkgdefs
    my %old_pkgdefs    = %::pkgdefs;

    # If the distro_id.pm has not been loaded, load it.
    if ( scalar(keys %::distro_id) <= 0)
    {
        if ( !NodeUtils->loadPkgdefsInDefaultPath( "distro_id.pm"))
        {
            %::pkgdefs = %old_pkgdefs;
            return "";
        }
        NodeUtils->supplementEffectiveDistro();
    }
    
    foreach my $distro (keys %::distro_id)
    {
        my $distro_name_version = $::distro_id{$distro}{'distro_name'} . " " . $::distro_id{$distro}{'distro_version'};
        # MCP Linux is used internally.
        if (($distro_name_version =~ /MCP/) && !NodeUtils->isHMC())
        {
            next;
        }
        # ScientificLinux and CentOS are not supported formally.
        if ((($distro_name_version =~ /ScientificLinux/) || ($distro_name_version =~ /CentOS/))
            && $officially_supported)
        {
            next;
        }
				
        # if the distro_name_version is not in the hash
        if (!grep(/$distro_name_version/, %supported_distro))
        {
            my $os_name = "Linux";
            my ( $distro_name, $distro_version, $arch) =
                    ($::distro_id{$distro}{'distro_name'}, 
                      $::distro_id{$distro}{'distro_version'},
                      $::distro_id{$distro}{'arch'});
            my $csm_version = NodeUtils->get_CSMVersion("csm.core");
            my $mgmt_type = "MgmtServer";
            my %pkgdefs =
              ServerUtils->get_pkgdefs(
                      $os_name, $distro_name, $distro_version, 
                      $arch, $mgmt_type, $csm_version
                      );
            foreach my $location (@{$pkgdefs{'where_supported'}})
            {
                if (!defined($supported_distro{$location}) || ($supported_distro{$location} eq ""))
                { 
                    $supported_distro{$location} = $distro_name_version; 
                }
                else
                {
                    $supported_distro{$location} .= ",$distro_name_version";
                }
             }
        }
    }
    # Restore the %::pkgdefs
    %::pkgdefs = %old_pkgdefs;
    return %supported_distro;
}

# get installed packages from the passed group
# until now, this subroutine only handles AIX filesets
sub getInstalledPkgs
{
    my ($class, @groups) = @_;
    my @result_grps;

    my @output = NodeUtils->runcmd("$::LSLPP -l");
    foreach my $line (@output)
    {
        my ($nothing, $fileset, $nothing) = split /\s+/, $line;
        if ($fileset !~ m/^\w+\./)
        {
            next;
        }
        if ((grep /^$fileset$/, @groups) &&
            !(grep /^$fileset$/, @result_grps))
        {
            push @result_grps, $fileset; 
        }else
        {
            # if csm.gui is asked to be judged,
            # csm.gui.dcem has to be considered
            my ($pkg) = $fileset =~ m/^(\S+)\.\S+/;
            if ($pkg !~ m/^\w+\./)
            {
                next;
            }
	    if ((grep /^$pkg$/, @groups) &&
                !(grep /^$pkg$/, @result_grps))
            {
                push @result_grps, $pkg;
            }
        }
    }

    return @result_grps;
}
#-------------------------------------------------------------------------------

=head3 WhetherToModifyFile

        Check whether file need to be changed
		and Backup warewulf configuration files 

    Arguments:
        $file    file need to be checked. 

    Returns:
		0   --- Ignore this file
		1   --- Create this file or change it
    Note:
        If the file doesn't exist, 
				create new file, return 1 
		If the file exist and not created by csm, 
				add .precsm postfix, return 1
		If the file exist and contain "DO NOT ERASE THIS SECTION" string, 
        		ignore it, return 0 			

=cut

#-------------------------------------------------------------------------------

sub WhetherToModifyFile
{
	my ($pkg,$file) = @_;
	if (  -f "$file" ) 
	{
		my @output=`$::GREP \"DO\ NOT\ ERASE\ THIS\ SECTION\" $file`;
		if(!@output)
		{
			NodeUtils->runcmd("$::MV -f $file $file.precsm");
			print "Backup $file\n" if ($::DEBUG);
			return 1;
		}
		else
		{
			return 0;
		}
	}
	else
	{
		return 1;
	}

}
#-------------------------------------------------------------------------------

=head3 IsCreateByCSM

        Check whether this file is created by csm 

    Arguments:
        $file    file need to be checked. 

    Returns:
		0   --- no , not created by csm
		1   --- yes, created by csm
    Note:
        If the file doesn't exist, 
				return 0 
		If the file exist and not created by csm, 
				return 0
		If the file exist and contain "DO NOT ERASE THIS SECTION" string, 
        		ignore it, return 1 			

=cut

#-------------------------------------------------------------------------------

sub IsCreateByCSM
{
	my ($pkg,$file) = @_;
	if (  -f "$file" ) 
	{
		my @output=`$::GREP \"DO\ NOT\ ERASE\ THIS\ SECTION\" $file`;
		if(@output)
		{
			return 1;
		}
		else
		{
			return 0;
		}
	}
	else
	{
		return 0;
	}

}
#-------------------------------------------------------------------------------

=head3 GetVnfsDIRFromWarewulf

        Get the vnfs directory from /etc/warewulf/master.conf vnfs [section] 

    Arguments:

    Returns: vnfs directory
    Note:

=cut

#-------------------------------------------------------------------------------

sub GetVnfsDIRFromWarewulf
{
	my $pkg = shift;
	my $vnfsdir;
	my $isCSM;
	# Check whether generate this file by CSM
	$isCSM = 0;
	my ($entry, $value);
	if (open(MASTER, "/etc/warewulf/master.conf"))
	{
			while (<MASTER>)
			{
					chomp($_);
					if ($_ =~ /DO\ NOT\ ERASE\ THIS\ SECTION/)
					{
						$isCSM = 1;
					}
					$_ =~ s/#.*$//g;
					$_ =~ s/^\s+//g;
					$_ =~ s/\s+$//g;
					next unless $_;
					($entry, $value) = split(/\s+=\s+/, $_);
					$value =~ s/\s+$//g;
					if ($entry =~ /vnfs\ dir/)
					{
						$vnfsdir = $value;
					}
			}
			close(NODELIST);
	}
	print "vnfsdirfrom master=$vnfsdir\n" if ($::DEBUG);
	chomp($vnfsdir);
	if ($isCSM && $vnfsdir ne "")
	{
		return $vnfsdir;
	}
	else
	{
		return (defined $::CSMINSTDIR ? "$::CSMINSTDIR/diskless/vnfs" : "/csminstall/diskless/vnfs");
	}
}
#-------------------------------------------------------------------------------

=head3 GetDisklessType

        Get the DisklessType attribute  from 
		/CSMINSTALL_ROOT/csm/templates/warewulf/warewulf-tmpl.<NODEGRP>/config  

    Arguments:

    Returns: 
			Global variable $::DisklessType
    Note:
         DisklessType Specifies the type of diskless boot image. 
		 This value can be "hybrid" ,"ramdisk" or "user-ramdisk".
         If DisklessType is "hybrid", $::DisklessType = "hybrid".
 		 If DisklessType is "ramdisk", $::DisklessType = "ramdisk"
		 If DisklessType is "user-ramdisk", $::DisklessType = "user-ramdisk"

=cut

#-------------------------------------------------------------------------------

sub GetDisklessType
{
	my ($pkg,$nodegrp) = @_;
	my $type;
	my $csm_dir;
	my $config_file;
    if ($ENV{CSMINSTALL_ROOT})
	{	
		$csm_dir = $ENV{CSMINSTALL_ROOT};
	}
	else
	{
		# use default value
		$csm_dir = "/csminstall";
	}

	$config_file = "$csm_dir/csm/templates/warewulf/warewulf-tmpl.$nodegrp/config";
	my $ref_config_hash = NodeUtils->get_config("$config_file");
	$type = $$ref_config_hash{'DEFAULT'}{'DisklessType'};
	if (!$type)
	{
		# use default value
		$type = "hybrid";
	}
	
	$::DisklessType =  $type;
	print "DisklessType =$::DisklessType\n" if ($::DEBUG);
}
#-------------------------------------------------------------------------------

=head3 BackupWarewulfFile

        Check whether file need to be backuped
		and Backup warewulf configuration files if backup.

    Arguments:
        $file    file need to be checked. 

    Returns: None
	
    Note:

=cut

#-------------------------------------------------------------------------------

sub BackupWarewulfFile
{
	my ($pkg,$file) = @_;
	if (  -f "$file" ) 
	{
		my @output=`$::GREP \"DO\ NOT\ ERASE\ THIS\ SECTION\" $file`;
		if(!@output)
		{
			NodeUtils->runcmd("$::MV -f $file $file.precsm");
			print "Backup $file\n" if ($::DEBUG);
		}
	}

}

#-------------------------------------------------------------------------------------

=head3 findAndRm
        find files/directories in a directory and remove them
    Argument:
        $dir: the directory to be search
        $fileName: the files or directories to be removed
        $disableWarning: whether disable warning message, 1 to be disabled, 0 not
    Returns:
        none
    Globals:
        none
    Error:
        none
    Example:
        NodeUtils->findAndRm('/opt/csm', '*.pm', 1 );
    Comments:
        none
=cut
#-------------------------------------------------------------------------------------

sub findAndRm
{
    shift;
    my ( $dir, $fileName, $disableWarning) = @_;
    my $exitCode = 0;
    $exitCode = -1 if $disableWarning;
    my @files = NodeUtils->runcmd( qq(/usr/bin/find "$dir" -name "$fileName"), $exitCode);
    if (scalar( @files) > 0)
    {
        my $cmd = "$::RM -rf " . join( ' ', @files);
        NodeUtils->runcmd( $cmd, $exitCode);
    }
}
#-------------------------------------------------------------------------------

=head3   touchDirList

    Create some relative directories in specified place
        Arguments:
          $dirlist_ref  - reference to directory list
          $dest			- leading directory 
	Returns:
        	zero on success
		non-zero on failure
	Example:
        	NodeUtils->touchDirList(['/etc/warewulf', '/var/opt/csm'],'/vnfs/');
	Comments:

=cut

#--------------------------------------------------------------------------------
sub touchDirList
{
	my ($pkg, $dirlist_ref, $dest ) = @_;
	foreach my $dir (@$dirlist_ref)
	{
		if ( ! -d "$dest/.$dir")
		{
			mkpath("$dest/.$dir", $::VERBOSE, 0755);
		}
	}
}

#-------------------------------------------------------------------------------

=head3   substFile

    Substitute specific keywords in hash
        Arguments:
          $tmplfile      - template file  
          $destfile 	 - destination file
		  $hash_ref      - reference to hash structure	 
	Returns:
        	zero on success
		non-zero on failure
	Example:
        	NodeUtils->substFile('/csminstall/csm/templates/warewulf/master.conf', 
								 '//etc/warewulf/master.conf',
								 { '#CSMVAR:DistroVerPkg#' => 'sles-release',
								   '#CSMVAR:BaseName#'     => 'SLES9-GA-ppc64'	
								 });
	Comments:

=cut

#--------------------------------------------------------------------------------
sub substFile
{
	my ($pkg, $tmplfile , $destfile , $hash_ref) = @_;	
	open(DES_FILE, ">$destfile")
			|| MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
							'csminstall', 'E2', 'EMsgCANT_WRITE_FILE', $destfile);
	my @content = NodeUtils->readFile($tmplfile);
	foreach my $line (@content)
	{
			foreach my $keyword (keys %$hash_ref)
			{
				my $value = $$hash_ref{$keyword};
				$line =~ s/$keyword/$value/g;
			}
			print DES_FILE $line;
	}
	close(DES_FILE);
}
#-------------------------------------------------------------------------------

=head3   get_config

    Substitute specific keywords in hash
	e.g. config file:
	[main]
	cachedir=/var/cache/yum
	keepcache=1
	[base]
	name=Red Hat Linux $releasever - $basearch - Base
	baseurl=http://mirror.dulug.duke.edu/pub/yum-repository/redhat/$releasever/$basearch/

	%config = {
				main => {
					'cachedir'  => '/var/cache/yum',
					'keepcache' => '1'
						},
				bash => {
					'name' 		=> 'Red Hat Linux $releasever - $basearch - Base',
					'baseurl'	=> 'http://mirror.dulug.duke.edu/pub/yum-repository/redhat/$releasever/$basearch/'
						}
			  }

    Arguments:
          $configfile      - config file  
	Returns:
	      $config_ref    - reference to config hash		
	Example:
        	NodeUtils->get_config('/csminstall/csm/templates/warewulf/master.conf'); 
	Comments:

=cut

#--------------------------------------------------------------------------------
sub get_config
{
	my ($pkg, $configfile) = @_;
	my @content = NodeUtils->readFile($configfile);
	my $current_section = "DEFAULT";
	my %config;
	my $csm_use;
    $csm_use = 0;
	foreach my $line (@content)
	{
      my ($entry, $value);
	  chomp $line;
	  if ( $line =~ /\QDO NOT ERASE THIS SECTION\E/ )
	  {
		 # reverse flag
	  	 $csm_use = ! $csm_use;
	  }
	  if ($csm_use)
	  {
		 # Remove leading "#". This line is used by CSM
		 $line =~ s/^#//g;	
	  }  
	  else
	  {		
      	 # Remove comment line
		 $line =~ s/#.*$//g;
	  }
      $line =~ s/^\s+//g;
      $line =~ s/\s+$//g;
      next unless $line;
      if ( $line =~ /^\s*\[([\w+-\.]+)\]\s*$/ ) {
         $current_section = $1;
      } else {
	  		# Ignore line doesn't key/value pair.
	  		if ($line !~ /=/)
	  		{
				 next;
	  		}	
            $line =~ /^\s*([^=]*)\s*=\s*(.*)\s*$/;
            $entry = $1;
            $value = $2;    
            $entry =~ s/^#*//g;
            # Remove leading and trailing spaces
            $entry =~ s/^\s+//g;
            $entry =~ s/\s+$//g;
            $value =~ s/^\s+//g;
            $value =~ s/\s+$//g;
         	$config{$current_section}{"$entry"} = $value;
      }
		
	}
	return \%config;

}
#-------------------------------------------------------------------------------

=head3   searchHighestVersion

    Search the highest version 

    Arguments:
          $ref_versions         - the reference to version list  
	Returns:
	      $highest_version      - the highest version 		
	Example:
        	NodeUtils->searchHighestVersion(('2.6.34','2.6.35')); 
	Comments:

=cut

#--------------------------------------------------------------------------------

sub searchHighestVersion
{
    my ($class, $ref_version) 
        = @_;
    my @versions = @$ref_version;
    my ($highest_version, $highest_ver, $highest_release);
    $highest_version = $versions[0];
    ($highest_ver, $highest_release) = split(/-/, $highest_version);
    foreach my $version (@versions)
    {
        my ($ver, $release);
        ($ver, $release) = split(/-/, $version);
        print "ver=$ver release=$release\n" if ($::DEBUG);
        # Find the highest version
        if (ArchiveUtils->testVersion( $ver, '>', $highest_ver, $release, $highest_release))
        {
            $highest_version = $version;
            ($highest_ver, $highest_release) = ($ver, $release);
        }
    }
    return $highest_version;

}

#-------------------------------------------------------------------------------

=head3

    getDisklessNodeGrpName

        Get the DisklessNodeGroupName from 
		  node's InstallTemplate attribute
		  InstallTemplate format: 
				/path/warewulf-tmpl.DisklessNodeGroupName 	
          If InstallTemplate is blank,
		        default value is $distro$version-$svclevel-$arch
    Arguments:
			$ref_nodehash    - reference to $NODE_HASH
			$node            - hostname of the node  
    Returns: 
			DisklessNodeGroupName
    Note:
		This subroutine is only used when installmethod is warewulf
=cut

#-------------------------------------------------------------------------------

sub getDisklessNodeGrpName()
{
	my ($pkg,$ref_nodehash,$node) = @_;
	if ( $$ref_nodehash{$node}{"InstallMethod"} eq "warewulf")
	{
        my $DefaultDisklessNodeGrpName =
                "$$ref_nodehash{$node}{'InstallDistributionName'}".
                "$$ref_nodehash{$node}{'InstallDistributionVersion'}-".
                "$$ref_nodehash{$node}{'InstallServiceLevel'}-".
                "$$ref_nodehash{$node}{'InstallPkgArchitecture'}";

        my $DisklessNodeGrpName;
        if ($$ref_nodehash{$node}{'InstallTemplate'} eq "")
        {
            # In default
            $DisklessNodeGrpName = $DefaultDisklessNodeGrpName;
        }
        else
        {
            # Customization name
            $DisklessNodeGrpName = `$::BASENAME $$ref_nodehash{$node}{'InstallTemplate'}`;
            chomp($DisklessNodeGrpName);
        }
        # Get the postfix of dirtectory name as DisklessNodeGrpName
        $DisklessNodeGrpName =~ s/^.*warewulf-tmpl\.//g;
        return $DisklessNodeGrpName;

	}
	else
	{
		# we should not go here!
		print "getDisklessNodeGrpName is called wrongly!\n";
		exit 0;
	}
}

#----------------------------------------------------------------------

=head3  set_sis_conf_para

	Description:
	set sis configure info to systemimager.conf file
	such as default image dir, etc.
	
=cut

#----------------------------------------------------------------------
sub set_sis_conf_para()
{
    print "Configure the systemimager...\n" if $::DEBUG;
    my ($attribute, $dir);
    unless (open(SISCONF_ORG, "<$::SISCFGFILE"))
    {
        MessageUtils->message('E', 'EMsgCANT_READ_FILE', $::SISCFGFILE);
        return $::NOK;
    }
    unless (open(SISCONF_NEW, ">$::TMPSISCFG"))
    {
        MessageUtils->message('E', 'EMsgCANT_WRITE_FILE', $::TMPSISCFG);
        return $::NOK;
    }

    while (my $line = <SISCONF_ORG>)
    {
        if ($line =~ /^\#/ || $line =~ /^s*$/)
        {
            print SISCONF_NEW $line;
        }
        elsif ( $line =~ /^\s*(\S+)\s*=\s*(\S+)\s*$/)
        {
            ($attribute, $dir) = ( $1, $2);
            if ($attribute eq 'DEFAULT_IMAGE_DIR')
            {
                $dir =  $::CSMINSTALL_TOP . "/sis/images" ;
            }
            elsif ($attribute eq 'DEFAULT_OVERRIDE_DIR')
            {
                $dir = $::CSMINSTALL_TOP . "/sis/overrides";
            }
            elsif ($attribute eq 'AUTOINSTALL_SCRIPT_DIR')
            {
                $dir = $::CSMINSTALL_TOP . "/sis/scripts";
            }
            elsif ($attribute eq 'AUTOINSTALL_BOOT_DIR')
            {
                $dir = $::SISTFTPBOOTDIR;
            }
            elsif ($attribute eq 'NET_BOOT_DEFAULT')
            {
                $dir = 'local';
            }
            print SISCONF_NEW "$attribute = $dir\n";
        }
        else
        {
            print SISCONF_NEW $line;
        }
    }

    close(SISCONF_ORG);
    close(SISCONF_NEW);
    my $cp = "$::CP $::TMPSISCFG $::SISCFGFILE";
    my $output = NodeUtils->runcmd($cp, 0);
}

#-------------------------------------------------------------------------------------
=head3

  runDsh
  This subroutine provides a concise interface to run remote command on multiple nodes.
  Arguments:
      $optionRef: 
         Specifies a hash in which the dsh options are provided  
      $exitCode:
        Normally, if there is an error running the cmd, it will display the error msg
        and exit with the cmds exit code, unless exitcode is given one of the
        following values:
             0:     display error msg, DO NOT exit on error, but set
                $::RUNCMD_RC to the exit code.
            -1:     DO NOT display error msg and DO NOT exit on error, but set
	                   $::RUNCMD_RC to the exit code.
            -2:    DO the default behavior (display error msg and exit with cmds
                exit code.
        number > 0:    Display error msg and exit with the given code
        $refoutput:
                       if refoutput is true, then the output will be returned as a reference to 
                       an array for efficiency.
  Example:
      my @outref = NodeUtils->runDsh(\%options, -2);
 
=cut
#-------------------------------------------------------------------------------------


sub runDsh
{
    shift;
    my ( $origOptionsRef, $exitCode, $refoutput) = @_;

#To create a copy of options, to avoid DSHCLI->_execute_dsh changes %options
#internally.
    my %options = %$origOptionsRef;
    my $optionsRef = \%options;

#check HMC environment
    $ENV{'DSH_ON_HMC'} = DSHCLI->isHMC();
    $$optionsRef{'ishmc'} = $ENV{'DSH_ON_HMC'};
    if ( $$optionsRef{'ishmc'} )
    {
         DSHCLI->check_flag_env_on_hmc($optionsRef);
    }

#remove all dsh environment variables
    DSHCLI->ignoreEnv();
    my $cmd_line = NodeUtils->getDSHCmdLine($optionsRef);    
    if (!$NodeUtils::NO_MESSAGES)
    {
           MessageUtils->messageFromCat($MSGCAT, $MSGMAPPATH, $MSGSET, 'V',
                                       'IMsgCMD', $cmd_line);
    }

    $::DSH_API = 1;
    $::DSH_API_MESSAGE = "";
    my $verbose_old = $::VERBOSE;
    $::VERBOSE = 0;
    $::RUNCMD_RC = DSHCLI->execute_dsh( $optionsRef );
    $::DSH_API = 0;
    $::VERBOSE = $verbose_old;
    my $returnCode; #command will exit with this code
    if ( $::RUNCMD_RC)
    {
	my $dsh_api_displayerr = 1;
        if ( defined( $exitCode) && length( $exitCode) && $exitCode != -2)
        {
            if ( $exitCode > 0) {
		    $returnCode = $exitCode;
	    } elsif ( $exitCode <= 0) {
		    $returnCode = '';
		    if ( $exitCode < 0 ){
			    $dsh_api_displayerr = 0;
		    }
	    }
	}
        else
        {
            $returnCode = $::RUNCMD_RC;
        }
	if ($dsh_api_displayerr){
		 my $errmsg = '';
		 if (NodeUtils->isLinux() && $::RUNCMD_RC == 139) {
			 $errmsg = "Segmentation fault  $errmsg";
		 } else {
			 $errmsg = $::DSH_API_MESSAGE;
		 }
		 if (!$NodeUtils::NO_MESSAGES){
			 MessageUtils->messageFromCat(
				 'csmdsh.cat',
				 $MSGMAPPATH,
				 'dsh',
				 "E$returnCode",
				 'EMsgDshCmdFailed',
				 $$optionsRef{'command'},
				 $::DSH_API_NODES_FAILED);
		 }
	 }
	
    }
   
    if ($refoutput)
    {
	    my $outputRef = [];
	    @$outputRef = split "\n", $::DSH_API_MESSAGE;
	    chomp @$outputRef;
	    return $outputRef;
    } elsif ( wantarray )
    {
        my @outputLines = split "\n", $::DSH_API_MESSAGE;
        chomp @outputLines;
        return @outputLines;
    }
    else
    {
        return $::DSH_API_MESSAGE;
    }
}

sub dshOnNodes
{
    shift;
    my ( $nodeList, $commandLine, $timeout, $exitCode) = @_;
    my %options;

    $options{'command'} = $commandLine;
    $options{'nodes'} = $nodeList;
    $options{'timeout'} = $timeout;

    return NodeUtils->runDsh(\%options, $exitCode);
}

sub dshOnDevs
{
    shift;
    my ( $devList, $commandLine, $timeout, $exitCode) = @_;
    my %options;

    $options{'command'} = $commandLine;
    $options{'devices'} = $devList;
    $options{'timeout'} = $timeout;

    return NodeUtils->runDsh(\%options, $exitCode);
}

#-------------------------------------------------------------------------------------
=head3

  runDcp
    This subroutine provides a concise interface to run remote command on multiple nodes.
    Arguments:
           $optionRef:
               Specifies a hash in which the dsh options are provided
           $exitCode:
              Normally, if there is an error running the cmd, it will display the error msg
              and exit with the cmds exit code, unless exitcode is given one of the
              following values:
                       0:     display error msg, DO NOT exit on error, but set
                              $::RUNCMD_RC to the exit code.
                      -1:     DO NOT display error msg and DO NOT exit on error, but set
                              $::RUNCMD_RC to the exit code.
                      -2:    DO the default behavior (display error msg and exit with cmds
                             exit code.
              number > 0:    Display error msg and exit with the given code
              $refoutput:
                             if refoutput is true, then the output will be returned as a reference to 
                             an array for efficiency.
     Example:
            my @outref = NodeUtils->runDcp(\%options, -2);
=cut
#---------------------------------------------------------------------------------------
sub runDcp
{
    shift;
    my ( $origOptionsRef, $exitCode, $refoutput) = @_;

#To create a copy of options, to avoid DSHCLI->execute_dcp changes %options
#internally.
    my %options = %$origOptionsRef;
    my $optionsRef = \%options;

#check HMC environment
    $ENV{'DSH_ON_HMC'} = DSHCLI->isHMC();
    $$optionsRef{'ishmc'} = $ENV{'DSH_ON_HMC'};
    if ( $$optionsRef{'ishmc'} )
    {
         DSHCLI->check_flag_env_on_hmc($optionsRef);
    }

#remove all dsh environment variables
    DSHCLI->ignoreEnv();
    my $cmd_line = NodeUtils->getDCPCmdLine($optionsRef);    
    if (!$NodeUtils::NO_MESSAGES)
    {
           MessageUtils->messageFromCat($MSGCAT, $MSGMAPPATH, $MSGSET, 'V',
                                       'IMsgCMD', $cmd_line);
    }    
    $::DCP_API = 1;
    $::DCP_API_MESSAGE = "";
    my $verbose_old = $::VERBOSE;
    $::VERBOSE = 0;
    if ( ! ref($optionsRef->{'source'}))
    {
        $optionsRef->{'source'} =~ s/\s/$::__DCP_DELIM/g;
    }
    elsif ( ref($optionsRef->{'source'} eq "ARRAY"))
    {
        $optionsRef->{'source'} = join $::__DCP_DELIM, @{$optionsRef->{'source'}};
    }
            
    $::RUNCMD_RC = DSHCLI->execute_dcp( $optionsRef );
    $::DCP_API = 0;
    $::VERBOSE = $verbose_old;
    my $returnCode; #command will exit with this code
    if ( $::RUNCMD_RC)
    {
	my $dcp_api_displayerr = 1;
        if ( defined( $exitCode) && length( $exitCode) && $exitCode != -2)
        {
            if ( $exitCode > 0) {
		    $returnCode = $exitCode;
	    } elsif ( $exitCode <= 0) {
		    $returnCode = '';
		    if ( $exitCode < 0 ){
			    $dcp_api_displayerr = 0;
		    }
	    }
	}
        else
        {
            $returnCode = $::RUNCMD_RC;
        }
	if ($dcp_api_displayerr){
		 my $errmsg = '';
		 if (NodeUtils->isLinux() && $::RUNCMD_RC == 139) {
			 $errmsg = "Segmentation fault  $errmsg";
		 } else {
			 $errmsg = $::DCP_API_MESSAGE;
		 }
		 if (!$NodeUtils::NO_MESSAGES){
				MessageUtils->messageFromCat($MSGCAT, $MSGMAPPATH, $MSGSET,
						 "E$returnCode", 'EMsgCMD_FAILED', $::RUNCMD_RC, "dcp", $errmsg);
		 }
	 }
	
    }
    if ($refoutput)
    {
	    my $outputRef = [];
	    @$outputRef = split "\n", $::DCP_API_MESSAGE;
	    chomp @$outputRef;
	    return $outputRef;
    } elsif ( wantarray )
    {
        my @outputLines = split "\n", $::DCP_API_MESSAGE;
        chomp @outputLines;
        return @outputLines;
    }
    else
    {
        return $::DCP_API_MESSAGE;
    }
}

sub dcpOnNodes
{
    shift;
    my ( $nodeList, $commandLine, $timeout, $exitCode) = @_;
    my %options;

    $options{'command'} = $commandLine;
    $options{'nodes'} = $nodeList;
    $options{'timeout'} = $timeout;

    return NodeUtils->runDcp(\%options, $exitCode);
}

sub dcpOnDevs
{
    shift;
    my ( $devList, $commandLine, $timeout, $exitCode) = @_;
    my %options;

    $options{'command'} = $commandLine;
    $options{'devices'} = $devList;
    $options{'timeout'} = $timeout;

    return NodeUtils->runDcp(\%options, $exitCode);
}

sub getDSHCmdLine
{
    my ($class, $optionsRef) = @_;

    my $key;
    my $cmd_line = "$::DSH";
    foreach $key (sort keys %$optionsRef){
	    if ( $key eq 'timeout'){
		    $cmd_line .= ' -t ' . $$optionsRef{'timeout'};
	    } elsif ($key eq 'fanout'){
		    $cmd_line .= ' -f ' . $$optionsRef{'fanout'}; 
            } elsif ($key eq 'verify'){
		    $cmd_line .= ' -v';
	    } elsif ($key eq 'nodes'){
		    $cmd_line .= ' -n ' . $$optionsRef{'nodes'};
	    } elsif ($key eq 'nodegroups'){
		    $cmd_line .= ' -N ' . $$optionsRef{'nodegroups'};
	    } elsif ($key eq 'node-rsh'){
		    $cmd_line .= ' -r ' . $$optionsRef{'node-rsh'};
	    } elsif ($key eq 'monitor'){
		    $cmd_line .= ' -m';
	    } elsif ($key eq 'all-nodes'){
		    $cmd_line .= ' -a';
	    } elsif ($key eq 'continue'){
		    $cmd_line .= ' -c';
	    } elsif ($key eq 'devices'){
		    $cmd_line .= ' -d ' . $$optionsRef{'devices'};
	    } elsif ($key eq 'execute'){
		    $cmd_line .= ' -e';
	    } elsif ($key eq 'help'){
		    $cmd_line .= ' -h';
	    } elsif ($key eq 'notify'){
		    $cmd_line .= ' -i';
	    } elsif ($key eq 'user'){
		    $cmd_line .= ' -l ' . $$optionsRef{'user'};
	    } elsif ($key eq 'node-options'){
		    $cmd_line .= ' -o ' . $$optionsRef{'node-options'};
	    } elsif ($key eq 'show-config'){
		    $cmd_line .= ' -q';
	    } elsif ($key eq 'streaming'){
		    $cmd_line .= ' -s';
	    } elsif ($key eq 'exit-status'){
		    $cmd_line .= ' -z';
	    } elsif ($key eq 'all-devices'){
		    $cmd_line .= ' -A';
	    } elsif ($key eq 'context'){
		    $cmd_line .= ' -C ' . $$optionsRef{'context'};
	    } elsif ($key eq 'devicegroups'){
		    $cmd_line .= ' -D ' . $$optionsRef{'devicegroups'};
	    } elsif ($key eq 'environment'){
		    $cmd_line .= ' -E ' . $$optionsRef{'environment'};
	    } elsif ($key eq 'output-file'){
		    $cmd_line .= ' -F ' . $$optionsRef{'output-file'};
	    } elsif ($key eq 'ignore-signal'){
		    $cmd_line .= ' --ignoresig ' . $$optionsRef{'ignore-signal'};
	    } elsif ($key eq 'no-locale'){
		    $cmd_line .= ' -L';
	    } elsif ($key eq 'device-options'){
		    $cmd_line .= ' -O ' . $$optionsRef{'device-options'};
	    } elsif ($key eq 'silent'){
		    $cmd_line .= ' -Q';
	    } elsif ($key eq 'device-rsh'){
		    $cmd_line .= ' --device-rsh ' . $$optionsRef{'device-rsh'};
	    } elsif ($key eq 'syntax'){
		    $cmd_line .= ' -S ' . $$optionsRef{'syntax'};
	    } elsif ($key eq 'trace'){
		    $cmd_line .= ' -T';
	    } elsif ($key eq 'version'){
		    $cmd_line .= ' -V';
	    } elsif ($key eq 'command-name'){
		    $cmd_line .= ' --command-name ' . $$optionsRef{'command-name'};
	    } elsif ($key eq 'command-description'){
		    $cmd_line .= ' --command-description ' . $$optionsRef{'command-description'};
	    } elsif ($key eq 'log-file'){
		    $cmd_line .= ' --log ' . $$optionsRef{'log-file'};
	    } elsif ($key eq 'report'){
		    $cmd_line .= ' --report ' . $$optionsRef{'report'};
	    } elsif ($key eq 'reports'){
		    $cmd_line .= ' -R ' . $$optionsRef{'reports'};
	    } elsif ($key eq 'report-name'){
		    $cmd_line .= ' --report-name ' .$$optionsRef{'report-name'};
	    } elsif ($key eq 'wcoll'){
		    $cmd_line .= ' -W ' . $$optionsRef{'wcoll'};
	    } elsif ($key eq 'ignore_env'){
		    $cmd_line .= " -X \"" . $$optionsRef{'ignore_env'} . "\"";
	    }
    }
    $cmd_line .= ' \"' . $$optionsRef{'command'} . '\"';
    return $cmd_line;
}

sub getDCPCmdLine
{
    my ($class, $optionsRef) = @_;

    my $key;
    my $cmd_line ="";
    if ($ENV{'DSH_COPY_FILE_LIST'}){
	    $cmd_line .= "export DSH_COPY_FILE_LIST=$ENV{'DSH_COPY_FILE_LIST'};";
    }
    $cmd_line .= "$::DCP";
    foreach $key (sort keys %$optionsRef){
	    if ( $key eq 'timeout'){
		    $cmd_line .= ' -t ' . $$optionsRef{'timeout'};
	    } elsif ($key eq 'fanout'){
		    $cmd_line .= ' -f ' . $$optionsRef{'fanout'}; 
            } elsif ($key eq 'verify'){
		    $cmd_line .= ' -v';
	    } elsif ($key eq 'nodes'){
		    $cmd_line .= ' -n ' . $$optionsRef{'nodes'};
	    } elsif ($key eq 'nodegroups'){
		    $cmd_line .= ' -N ' . $$optionsRef{'nodegroups'};
	    } elsif ($key eq 'node-rcp'){
		    $cmd_line .= ' -r ' . $$optionsRef{'node-rcp'};
	    } elsif ($key eq 'all-nodes'){
		    $cmd_line .= ' -a';
	    } elsif ($key eq 'devices'){
		    $cmd_line .= ' -d ' . $$optionsRef{'devices'};
	    } elsif ($key eq 'help'){
		    $cmd_line .= ' -h';
	    } elsif ($key eq 'user'){
		    $cmd_line .= ' -l ' . $$optionsRef{'user'};
	    } elsif ($key eq 'node-options'){
		    $cmd_line .= ' -o \"' . $$optionsRef{'node-options'} . '\"';
	    } elsif ($key eq 'show-config'){
		    $cmd_line .= ' -q';
	    } elsif ($key eq 'rsync'){
		    $cmd_line .= ' -s';
	    } elsif ($key eq 'all-devices'){
		    $cmd_line .= ' -A';
	    } elsif ($key eq 'context'){
		    $cmd_line .= ' -C ' . $$optionsRef{'context'};
	    } elsif ($key eq 'devicegroups'){
		    $cmd_line .= ' -D ' . $$optionsRef{'devicegroups'};
	    } elsif ($key eq 'device-options'){
		    $cmd_line .= ' -O ' . $$optionsRef{'device-options'};
	    } elsif ($key eq 'silent'){
		    $cmd_line .= ' -Q';
	    } elsif ($key eq 'pull'){
                    $cmd_line .= ' -P';
            } elsif ($key eq 'recursive'){
		    $cmd_line .= ' -R';
	    } elsif ($key eq 'trace'){
                    $cmd_line .= ' -T';
            } elsif ($key eq 'version'){
		    $cmd_line .= ' -V';
	    } elsif ($key eq 'wcoll'){
		    $cmd_line .= ' -W ' . $$optionsRef{'wcoll'};
	    } elsif ($key eq 'ignore_env'){
		    $cmd_line .= " -X \"" . $$optionsRef{'ignore_env'} . "\"";
	    }
    }
    $cmd_line .= ' ' . $$optionsRef{'source'} . ' ' . $$optionsRef{'target'};
    return $cmd_line;
}

#--------------------------------------------------------------------------------

=head3   isCTRMCrunning 

    returns 1 if RMC is running and all RMs have been brought up

    Arguments:
        none
    Returns:
        1 - RMC is running and all RMs have been brought up
        0 - RMC is not running or some RMs have not been brought up
    Globals:
        none
    Error:
        none
    Example:
         if (NodeUtils->isCTRMCrunning()) { blah; }
    Comments:
        none

=cut

#--------------------------------------------------------------------------------
sub isCTRMCrunning
{
    NodeUtils->runcmd("LANG=C /usr/bin/lsrsrc", -1);
    if ( $::RUNCMD_RC == 5)
    {
            return 0;
    }
    return 1;
}

#--------------------------------------------------------------------------------

=head3   waitForCTRMC 

    wait RMC to be active, and all RMs to be brought up

    Arguments:
        timeout - seconds to be time out
    Returns:
        1 - RMC is OK
        0 - RMC is not OK
    Globals:
        none
    Error:
        none
    Example:
        NodeUtils->waitForCTRMC 
    Comments:
        none

=cut

#--------------------------------------------------------------------------------
sub waitForCTRMC
{
    shift;
    my $timeout = shift;
    if ( !$timeout)
    {
        $timeout = 30;
    }
    my $interval = shift;
    if ( !$interval)
    {
        $interval = 2;
    }
	my $i;
    my $looptime = $timeout/$interval;
	for ($i = 1 ; $i <= $looptime ; $i++)
	{
		if (NodeUtils->isCTRMCrunning())
		{
			return 1;
		}
		sleep $interval;
	}
    if ( NodeUtils->isCTRMCrunning( ))
    {
        return 1;
    }
    return 0;
}

#----------------------------------------------------------------------
=head3 sort_nodes_by_attrs

    Description:
    Sort $ref_node_hash to a new HASH $ref_sorted_node_hash
    by the attributes specified by the users as the new HASH KEY.

    Args:
    $ref_node_hash: the input HASH to be sorted
    $attributes   : one or more attributes of the $node, joined by ":", used as 
                    the new HASH KEY
    $ref_sorted_node_hash:
                    the new HASH

    Return:
    $ref_sorted_node_hash
    $::OK
    $::NOK
    
=cut
#----------------------------------------------------------------------
sub sort_nodes_by_attrs
{
    my ($class, $ref_node_hash, $attributes, $ref_sorted_node_hash) = @_;
    
    my @attrs = split ':', $attributes;
    if (!scalar(@attrs))
    {
        return $::NOK;
    }

    my $sorted_hash_key;
    my %node_hash = %$ref_node_hash;
    foreach my $node (keys %node_hash)
    {
        my $i = 1;
        foreach my $attr (@attrs)
        {
            if ($i == 1)
            {
                $sorted_hash_key = $node_hash{$node}{$attr};
                $i = $i +1;
                next;
            }
            $sorted_hash_key = "$sorted_hash_key:$node_hash{$node}{$attr}";
        }

	    foreach my $attr (@attrs)
	    {
	        $$ref_sorted_node_hash{$sorted_hash_key}{$attr} = $node_hash{$node}{$attr};
	    }
	    push @{$$ref_sorted_node_hash{$sorted_hash_key}{NodeList}}, $node;
    }

    return $::OK;
}

#-------------------------------------------------------------------------------

=head3

    getClassNamebyRM

        Get its Class Name from the Resource Manager
        
        IBM.ERRM -> IBM.Condition, IBM.EventResponse,IBM.Association
	    IBM.AuditRM -> IBM.AuditLog, IBM.AuditLogTemplate
    	IBM.SensorRM -> IBM.Sensor
	    IBM.LPRM -> IBM.LPCommands
        IBM.HostRM -> IBM.Host,IBM.HostPublic etc
	    IBM.FSRM -> IBM.FileSystem
	    IBM.CIMRM -> IBM.AssocQuery

    Arguments:
        $resMgr  -  resource manager name, such as "IBM.HostRM" 

    Returns:
        0 - failed
        $className - the Class Name for the RM, used as the input parameter for lsrsrc-api

    Example:
        $rc = NodeUtils->getClassNamebyRM($hostrm)

=cut

#-------------------------------------------------------------------------------

sub getClassNamebyRM()
{
    my ($class, $resMan) = @_;
    my $className;
    
    # pick one class name per RM.
    if ($resMan eq "IBM.ERRM")
    {
        $className = "IBM.Condition";
    }
    elsif ($resMan eq "IBM.AuditRM")
    {
        $className = "IBM.AuditLog";
    }
    elsif ($resMan eq "IBM.SensorRM")
    {
        $className = "IBM.Sensor";
    }
    elsif ($resMan eq "IBM.LPRM")
    {
        $className = "IBM.LPCommands";
    }
    elsif ($resMan eq "IBM.HostRM")
    {
        $className = "IBM.Host";
    }
    elsif ($resMan eq "IBM.FSRM")
    {
        $className = "IBM.FileSystem";
    }
    elsif ($resMan eq "IBM.CIMRM")
    {
        $className = "IBM.AssocQuery";
    }
    else
    {
        return 0;

    }
    return $className;
}

#-------------------------------------------------------------------------------

=head3

    uncompressFile

        Uncompress file to certain directory

    Arguments:
        $image_file  -  compressed file name
        $format      -  the extended name of compressed file
                        so far, only support '.tar.gz'
        $targetdir   -  destination directory

    Returns:
        non-zero  failed
        zero      success
    Example:
        NodeUtils->uncompressFile($image_tarball,'tar.gz',$tmpdir);
=cut

#-------------------------------------------------------------------------------
sub uncompressFile
{
    my ($class, $image_file, $format, $targetdir) = @_;
    my ($cmd, $output, $rc );
    if (! -d $targetdir)
    {
        mkpath("$targetdir", $::VERBOSE, 0755);
    }
    if ($format eq 'tar.gz' )
    {
        $cmd = "$::TAR -C $targetdir -xzf $image_file";
    }
    else
    # Please add corresponding codes for other archive file format below
    {
        # Null command
        $cmd = "echo";
    }
    $output = NodeUtils->runcmd($cmd, -1);
    $rc = 0;
    # There is a trailing grabage issue ( rc=2 ) when gunzip the initrd file.
    # Don't post any error message for the time being.
    if ($rc != 2 && $rc > 0)
    {
        MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                                     'csminstall', 'I', 'IMsgShow_Output', $output);
        $rc = $::RUNCMD_RC;
    }
    return $rc;
}
#-------------------------------------------------------------------------------

=head3

    compressFile

        Compress all files under a certain directory to a archive file

    Arguments:
        $image_file  -  compressed file name
        $format      -  the extended name of compressed file
                        so far, only support '.tar.gz'
        $sourcedir   -  source directory

    Returns:
        non-zero  failure
        zero      success
    Example:
        NodeUtils->compressFile($image_tarball,'tar.gz',$tmpdir);
=cut

#-------------------------------------------------------------------------------
sub compressFile
{
    my ($class, $image_file, $format, $sourcedir) = @_;
    my ($cmd, $output, $rc );
    # To avoid archive file existing
    if ( -e $image_file)
    {
        unlink("$image_file");
    }
    if (! -d "$sourcedir")
    {
        return $::NOK;
    }
    my $orig_dir = Cwd::getcwd();
    if ($format eq 'tar.gz' )
    {
        $cmd = "cd $sourcedir;$::TAR zcf $image_file *";
    }
    else
    # Please add corresponding codes for other archive format below
    {
        # Null command
        $cmd = "echo";
    }
    $output = NodeUtils->runcmd($cmd, -1);

    chdir($orig_dir);
    $rc = 0;
    # There is a trailing grabage issue ( rc=2 ) when gunzip the initrd file.
    # Don't post any error message for the time being.
    if ($rc != 2 && $rc > 0)
    {
        MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                                     'csminstall', 'I', 'IMsgShow_Output', $output);
        $rc = $::RUNCMD_RC;
    }
    return $rc;
}

#-------------------------------------------------------------------------------

=head3

    extractFilesFromArchive

        Extract files from certain directory

    Arguments:
        $image_file  -  compressed file name
        $file_list   -  file list to be extracted, separated with blank
                        e.g. "./etc/motd ./etc/profile"
        $format      -  the extended name of compressed file
                        so far, only support '.tar.gz'
        $targetdir   -  target directory

    Returns:
        non-zero  failure
        zero      success
    Example:
        NodeUtils->extractFilesFromArchive($vnfs_tarball,"./etc/motd ./etc/profile",'tar.gz',$tmpdir);
=cut

#-------------------------------------------------------------------------------
sub extractFilesFromArchive
{
    my ($class, $image_file,$file_list, $format, $targetdir) = @_;
    my ($cmd, $output, $rc );
    # To avoid archive file not existing
    if (! -e $image_file)
    {
        return $::NOK;
    }
    if (! -d "$targetdir")
    {
        mkpath("$targetdir", $::VERBOSE, 0755);    
    }
    if ($format eq 'tar.gz' )
    {
        $cmd = "$::TAR -C $targetdir -xzf $image_file $file_list";
    }
    else
    # Please add corresponding codes for other archive format below
    {
        # Null command
        $cmd = "echo";
    }
    $output = NodeUtils->runcmd($cmd, -1);

    $rc = 0;
    # There is a trailing grabage issue ( rc=2 ) when gunzip the initrd file.
    # Don't post any error message for the time being.
    if ($rc != 2 && $rc > 0)
    {
        MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                                     'csminstall', 'I', 'IMsgShow_Output', $output);
        $rc = $::RUNCMD_RC;
    }
    return $rc;
}

#----------------------------------------------------------------------
=head3 read_bootptab

    Description:
    Read bootptab from nimol_bootpreplyd daemon configuration file and
    return a HASH array for each entry. All attribute pair (separated with ':')
    consist of the key and value of each HASH.

    Args:
    $bootptab_file: the file name of bootp definition file

    Return:
    $ref_bootptab_array
    $::OK
    $::NOK
    
=cut
#----------------------------------------------------------------------
sub read_bootptab
{
    my ($class, $bootptab_file) = @_;
    # Read nimol_bootpreplyd configuration file into memory
    my @content = NodeUtils->readFile($::NIMOL_BOOTPREPLYD_CONFIG_FILE);
    my @field;
    my $ref_bootptab_array;
    my @pairs;
    foreach my $line (@content)
    {
        my %bootptab_entry= ();
        chomp $line;
        $line =~ s/#.*$//;
        if ($line)
        {
            @pairs = split /:/, $line;
            $bootptab_entry{hostname}= shift @pairs;
            foreach (@pairs)
            {
                @field= split /=/, $_;
                $field[1]= lc $field[1] if ($field[0] eq "ha");
                chomp $field[1];
                $field[1] =~ s/\ $//;
                $bootptab_entry{$field[0]}= $field[1];
            }
            # At least ip,ht,bf,sa fields existing
            if (  $bootptab_entry{ip} =~ /\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}/ 
               && $bootptab_entry{sa} =~ /\d{1,3}\.\d{1,3}\.\d{1,3}\.\d{1,3}/
               && $bootptab_entry{ht} 
               && $bootptab_entry{bf}
            )
            {
                push @$ref_bootptab_array, \%bootptab_entry;
            }
        }
    }
    return $ref_bootptab_array;               
        
}

#----------------------------------------------------------------------
=head3 isExistingBootpEntry

    Description:
        Check if there is an existing entry in nimol_bootpreplyd config file.

    Args:
        $ref_bootptab: the reference to bootp config hash
        $mac         : the hardware address of install adapter
    Return:
      1 - there is an existing entry for the mac
      0 - there is no existing entry for the mac
    Note:
        The reson we choose macaddr as primary key is that macaddr is unique 
        for install adapter. 
=cut
#----------------------------------------------------------------------
sub isExistingBootpEntry
{
    my ($class, $ref_bootptab, $mac) = @_;
    $mac = lc $mac;
    chomp $mac;
    # Remove colon
    $mac =~ s/://g;
    foreach my $bootp_entry (@$ref_bootptab)
    {
        if ($$bootp_entry{'ha'} eq $mac)
        {
            return 1;
        }
    }
    return 0;
}
#----------------------------------------------------------------------
=head3 rmBootpEntry

    Description:
        Remove the certain entry from bootp entry hash

    Args:
        $ref_bootptab: the reference to bootp config hash
        $mac         : the hardware address of install adapter

    Return:
        $ref_bootptab_array - new hash array for nimol_bootp config 
=cut
#----------------------------------------------------------------------
sub rmBootpEntry
{
    my ($class, $ref_bootptab, $mac) = @_;
    $mac = lc $mac;
    chomp $mac;
    # Remove colon
    $mac =~ s/://g;
    if (! $mac)
    {
        return undef;
    }
    my @new_bootptab_array;
    foreach my $bootp_entry (@$ref_bootptab)
    {
        if ($$bootp_entry{'ha'} ne $mac)
        {
            push @new_bootptab_array, $bootp_entry;
        }
    }
    return \@new_bootptab_array;
}
#----------------------------------------------------------------------
=head3 addBootpEntry

    Description:
        Add the certain entry to bootp entry hash
    Args:
        $ref_bootptab: the reference to bootp config hash
        $hostname    : the long host name of node
        $client_addr : ip address of node
        $gateway     : gateway of node
        $subnet_mask : netmask of subnet of node
        $zimage_name : zimage name of node
        $server_addr : ip address of install server
        $mac         : hardware address of install adapter

    Return:
        $ref_bootptab_array - new hash array for nimol_bootp config
=cut
#----------------------------------------------------------------------
sub addBootpEntry
{
    my ($class, $ref_bootptab, $hostname,
        $client_addr, $gateway, $subnet_mask,
        $zimage_name, $server_addr, $mac
       ) = @_;
    
    $mac = lc $mac;
    chomp $mac;
    # Remove colon
    $mac =~ s/://g;
    if (!$mac)
    {
        return $::NOK;
    }
    my @new_ref_bootptab;
    if  ($ref_bootptab)
    {
        @new_ref_bootptab = @$ref_bootptab;
    }
    my %new_bootp_entry;
    $new_bootp_entry{'ip'} = $client_addr if ($client_addr);
    $new_bootp_entry{'ht'} = 'etherent';
    $new_bootp_entry{'gw'} = $gateway     if ($gateway);
    $new_bootp_entry{'sm'} = $subnet_mask if ($subnet_mask);
    $new_bootp_entry{'bf'} = $zimage_name if ($zimage_name);
    $new_bootp_entry{'sa'} = $server_addr if ($server_addr);
    $new_bootp_entry{'ha'} = $mac        if ($mac);
    $new_bootp_entry{'hostname'} = $hostname if ($hostname);
    push @new_ref_bootptab, \%new_bootp_entry;
    return \@new_ref_bootptab;
}

#----------------------------------------------------------------------
=head3 commentBootpEntry

    Description:
       Comment bootp entry which has the same hardware address with hardware address
    of install adapter. It will make conflict if they exist together. 

    Args:
        $bootptab_file: the file name of bootp definition file
        $mac          : hardware address of install adapter
    Return:
    $::OK
    $::NOK
    
=cut
#----------------------------------------------------------------------
sub commentBootpEntry
{
    my ($class, $bootptab_file, $mac) = @_;
    $mac = lc $mac;
    chomp $mac;
    # Remove colon
    $mac =~ s/://g;
    if (!$mac)
    {
        return $::NOK;
    }
    # Read nimol_bootpreplyd configuration file into memory
    my @content = NodeUtils->readFile($bootptab_file);
    my @field;
    my @pairs;
    open(NEW_BOOTPTAB, ">$bootptab_file") 
          || MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                                          'csminstall', 'E2', 'EMsgCANT_READ_FILE', $bootptab_file);
    my $newline;
    foreach my $line (@content)
    {
        my $newline = $line;
        chomp $line;
        my $csm_set = 0;
        if ($line =~ /ADDED\ BY\ CSM/)
        {
           $csm_set = 1; 
        }
        $line =~ s/#.*$//;
        if ($line =~ /ha=$mac/ && !$csm_set)
        {
            # There is same mac in this entry and not written by CSM
            # add '#CSM DCAPI COMMENTED:' before this entry
            print NEW_BOOTPTAB '#CSM DCAPI COMMENTED:'.$newline; 
        }
        elsif ($line =~ /ha=$mac/ && $csm_set)
        {
            # Do nothing
        }
        else
        {
            # Add coment line 
            print NEW_BOOTPTAB $newline;
        }
    }
    close(NEW_BOOTPTAB);
    return $::OK;
        
}
#----------------------------------------------------------------------
=head3 appendBootpEntry

    Description:
       Append new bootp entry to nimol_bootpreplyd configuration file

    Args:
        $bootptab_file: the file name of bootp definition file
        $ref_bootptab: the reference to bootp config hash
    Return:
    $::OK
    $::NOK
    
=cut
#----------------------------------------------------------------------
sub appendBootpEntry
{
    my ($class, $bootptab_file, $ref_bootptab) = @_;
    # Read nimol_bootpreplyd configuration file into memory
    my @content = NodeUtils->readFile($bootptab_file);
    my @field;
    my @pairs;
    open(NEW_BOOTPTAB, ">$bootptab_file") 
          || MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                                          'csminstall', 'E2', 'EMsgCANT_READ_FILE', $bootptab_file);
    print NEW_BOOTPTAB @content;
    my $newline;   
    my $bootp_entry; 
    foreach  $bootp_entry (@$ref_bootptab)
    {
        $newline  = $$bootp_entry{'hostname'};
        $newline .= ":ip=$$bootp_entry{'ip'}" if ($$bootp_entry{'ip'}); 
        $newline .= ":ht=ethernet"; 
        $newline .= ":gw=$$bootp_entry{'gw'}" if ($$bootp_entry{'gw'});
        $newline .= ":sm=$$bootp_entry{'sm'}" if ($$bootp_entry{'sm'});
        $newline .= ":bf=$$bootp_entry{'bf'}" if ($$bootp_entry{'bf'});
        $newline .= ":sa=$$bootp_entry{'sa'}" if ($$bootp_entry{'sa'});
        $newline .= ":ha=$$bootp_entry{'ha'}" if ($$bootp_entry{'ha'});
        # Add CSM MARK
        $newline .= "# ADDED BY CSM";
        print NEW_BOOTPTAB "$newline\n";
    }
    #print NEW_BOOTPTAB 'test';
    close(NEW_BOOTPTAB);
    return $::OK;
}

#----------------------------------------------------------------------
=head3 isNimol_BootpRunning

    Description:
       Check if nimol_bootpreplyd daemon is running

    Args:
       NONE
    Return:
    1 - running
    0 - not running
    
=cut
#----------------------------------------------------------------------
sub isNimol_BootpRunning
{
    # Firstly check pid file
    if (! -e $::NIMOL_BOOTPREPLYD_PID_FILE)
    {
        return 0;
    }
    # Read pid from pid file
    my $pid = NodeUtils->runcmd("$::CAT $::NIMOL_BOOTPREPLYD_PID_FILE", -1);
    chomp $pid;
    NodeUtils->runcmd("$::HMC_PS -e | $::GREP $pid ",-1);
    if ($::RUNCMD_RC)
    {
       # This daemon is not running 
       return 0;
    }
    else
    {
       # This daemon is running
       return 1;
    }
}
1;
