# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2006,2008 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 

##############################################################
# @(#)28   1.7   src/csm/core/pm/Rpm/Child/RsctRpmList.pm.perl, setup, csm_rgar2h, rgar2hs001a 7/30/07 03:44:59
##############################################################
#!/usr/bin/perl
use strict;

use Rpm::Rpm;
use Rpm::RpmList;
package RsctRpmList;
@RsctRpmList::ISA = qw( RpmList);

# why do we have to handle rsct update only packages
#
# some rsct packages, for examples rsct.basic and rsct.opt.storagerm need to be updated 
# with other RSCT packages together. So we cannot put them into normal update only packages.
# And we cannot put them into RSCT packages, because these packages maybe installed by
# user manually, and in this case, these packages cannot be uninstalled when running uninstallms

sub addRsctUpdateOnlyRpm
{
    my $self = shift;
    my $rsctUpdateOnlyRpm = shift;
    if (! $self->{'_rsctUpdateOnlyRpm'})
    {
        $self->{'_rsctUpdateOnlyRpm'} = [];
    }
    if ( $rsctUpdateOnlyRpm)
    {
        push @{$self->{'_rsctUpdateOnlyRpm'}}, $rsctUpdateOnlyRpm;
        return $self->{'_rsctUpdateOnlyRpm'};
    }
    else
    {
        return undef;
    }
}

# why to overwrite this subrountine of father class:
#
# If rsct update-only packages can be found, we need copy them anyway.
#
sub searchAllRpmsInDirList
{
    my $self = shift;
    my $dirListRef = shift;
    my $destDir = shift;

    if ( $self->{'_rsctUpdateOnlyRpm'})
    {
        my @files = NodeUtils->getFilePathListInDirList("*.rpm", @$dirListRef);
        for my $rsctUpdateOnlyRpm ( @{$self->{'_rsctUpdateOnlyRpm'}})
        {
            if ( $rsctUpdateOnlyRpm->searchHighestVersionInFileList( \@files, $destDir, $self->needCompareVersionWithDest()))
            {
                $self->addRpm( $rsctUpdateOnlyRpm);
            }
        }
    }

    return $self->SUPER::searchAllRpmsInDirList($dirListRef, $destDir);
}

# why to overwrite this subrountine of father class:
# 
# If rsct update-only packages are installed on MS, IS or node,
# we need UPDATE them together with other RSCT packages.
sub installAll
{
    my $self = shift;
    my $options = shift;
    
    if ( $self->{'_rsctUpdateOnlyRpm'})
    {
        for my $rsctUpdateOnlyRpm ( @{$self->{'_rsctUpdateOnlyRpm'}})
        {
            if ( !$rsctUpdateOnlyRpm->isInstalled() || !$rsctUpdateOnlyRpm->isFound())
            {
                $self->removeRpm( $rsctUpdateOnlyRpm);
            }
        }
    }
    
    return $self->SUPER::installAll( $options);
}

# why to overwrite this subrountine of father class:
#
# If anyone of rsct update-only packages, as well as csm.client
# are installed, we should not uninstall RSCT packages
sub uninstallAll
{
    my $self = shift;
    my $options = shift;

    my $client_pkg = new Rpm('csm.client');
    
    return $::TRUE if ( $client_pkg->isInstalled());
    if ( $self->{'_rsctUpdateOnlyRpm'})
    {
        for my $rsctUpdateOnlyRpm ( @{$self->{'_rsctUpdateOnlyRpm'}})
        {
            return $::TRUE if ( $rsctUpdateOnlyRpm->isInstalled());
        }
    }

    return $self->SUPER::uninstallAll($options);
}

1;
