#!/bin/bash
hmcProvVersion=/opt/hsc/pegasus/codebase/hmcprovVersion
hmcProvVersionUpdated=/opt/hsc/pegasus/codebase/hmcprovVersion_updated

#default values
pegasus1=pegasus-2.6.1-12
schema1=2.12
prov1=IBMhmc.pegasus-1.0-ECL1_0713

pegasus2=pegasus-2.6.1-15
schema2=2.17
prov2=IBMhmc.pegasus-1.0-ECL1_0713

clearVariable()
{
	pegasus=""
	schema=""
	prov=""
}

getVersion()
{
        clearVariable
        while read -r LINE
        do
        case $LINE in
            pegasus*)
                pegasus=`echo $LINE | sed -e "s/pegasus[ ]*=//g"`
                ;;
            cim_schema*)
                schema=`echo $LINE | sed -e "s/cim_schema[ ]*=//g"`
                ;;
            hmcprov*)
                prov=`echo $LINE | sed -e "s/hmcprov[ ]*=//g"`
                ;;
            *) echo "not supported contents " $LINE
                ;;
        esac
        done <  $1
}

getVersionInfo()
{
	if [ -f ${hmcProvVersion} ]; then
		#get cim_schema1 from version file
		getVersion ${hmcProvVersion}
		if [[ $pegasus != "" ]] ; then pegasus1=$pegasus; fi
		if [[ $schema != "" ]]; then schema1=$schema; fi
		if [[ $prov != "" ]]; then prov1=$prov; fi
	fi

	if [ -f ${hmcProvVersionUpdated} ]; then
		#get cim_schema2 from version file ( this file is created by repository rebuild script
		getVersion ${hmcProvVersionUpdated}
		if [[ $pegasus != "" ]] ; then pegasus2=$pegasus; fi
		if [[ $schema != "" ]]; then schema2=$schema; fi
		if [[ $prov != "" ]]; then prov2=$prov; fi
	fi
}


doConvert()
{
	#currently, we only support 2.12 to 2.17 subscription upgrade
	echo $schema1 ";" $schema2
	if [[ $schema1 != "2.12" || $schema2 != "2.17" ]]; then exit 0; fi

	#convert old object to new format
	#for 2.12 to 2.17, we can ignore the properties changes 
	#because all added properties are experimental and not used in pegasus current
}

#convert old object to new format
#begin 

getVersionInfo
doConvert

mv /opt/hsc/pegasus/codebase/hmcprovVersion_updated /opt/hsc/pegasus/codebase/hmcprovVersion 2>/dev/null
