# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2003,2008 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
#
#
# @(#)33   1.39.1.44   src/csm/install/pkgdefs/Linux-RedHatEL-AS3-ppc64.pm.perl, setup, csm_rgar2h, rgar2hs001a 8/22/06 05:02:07

#--------------------------------------------------------------------------------

=head3	Linux-RedHatEL-AS3-ppc64.pm.perl

        Package Definition File:   RedHatEL-AS 3 ppc

        Notes:

        The following global variables must be initalized before including
        this file:

                $::mgmt_type    = [ MgmtServer | MgdNode ]
                $::csm_version  = [1.3.0 | 1.3.1 | 1.3.2 | ... ]


        exceptions:
        This file has been rewritten for csm 1.3.4 to rely on default values
        with support for release-specific exceptions.  This makes it much
        simpler to maintain the package defs across releases.

	The approach uses $::csm_version to set default values for both server and
	node defines.  It allows for execptions to these default values by defining
	specific csm versions assignments which overwrite the defaults when
	$::csm_version is equal to the execption's version number.

	ORDER IS IMPORTANT:
	As noted in the code, any excptions must follow the default assignments,
	otherwise the execption assignment will be overwriten by the default.

	OTHER DOCUMENTATION - see pkgdefs/Linux.pm

=cut

#--------------------------------------------------------------------------------

# houskeeping

package RedHatELAS3ppc64;

#do "/opt/csm/install/pkgdefs/Linux-ppc64.pm";
my $progdir = $0;
$progdir =~ s/\/[^\/]*$/\//g;
if (-e "$progdir/pkgdefs/Linux-RedHatEL3-ppc64.pm")
{
	do "$progdir/pkgdefs/Linux-RedHatEL3-ppc64.pm";
}
else
{
	do "/opt/csm/install/pkgdefs/Linux-RedHatEL3-ppc64.pm";
}

MessageUtils->messageFromCat(
						  'csmInstall.cat',
						  $::MSGMAPPATH,
						  'csminstall',
						  'V',
						  'IMsgLoading',
						  "/opt/csm/install/pkgdefs/Linux-RedHatEL-AS3-ppc64.pm"
);

my $_server_  = 'MgmtServer';
my $_node_    = 'MgdNode';
my $_iserver_ = 'InstallServer';

# where this distribution be supported
$::pkgdefs{'where_supported'} = ['MgdNode'];

#--------------------------------------------------------------------------------

=head3	DISTRO Defintions

	Notes :

=cut

#--------------------------------------------------------------------------------
{

	# distribution name
	$::pkgdefs{DISTRO_NAME} = "Red Hat Enterprise Linux AS 3 PPC";

	$::pkgdefs{DISTRO_DISKLIST}   = "1 2 3";            # TO BE REMOVED

	# directory on CDs which contains rpm packages
	$::pkgdefs{DISTRO_RPMDIR}     = "RedHat/RPMS";

	$::pkgdefs{DISTRO_UPDATESDIR} = "RedHat/Updates";

}

#--------------------------------------------------------------------------------

=head3  distro_disks - Distribution Disk Defines

        Distribution Disk descriptions used to prompt for the CD-ROMs
        during installation.

        One stanza per CDROM:

                num                     = the number on the CD-ROM's label
                name                    = the text string describing the CD-ROM
                diskid_searchargs       = the arguments be searched to identify the disk
                    file    - specific file on the disk
                    num
                    arch
                    key	    - specific contents of this file
                    rpm	    - specific rpm package on this disk

                diskid_searchprog       = the subroutine be used when identifying the disk
                diskid_target		    = the target this disk would be copied to

=cut

#--------------------------------------------------------------------------------

{
	my $dd_ref = [
		{
		 num               => '1',
		 name              => $::pkgdefs{DISTRO_NAME} . " (Update 1)",
		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '1',
							   arch => 'ppc',
							   key  => '1065571970.028067',
							   rpm  => 'RedHat/Updates/redhat-release-3AS*',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-AS3-ppc64',
		},
		{
		 num               => '2',
		 name              => $::pkgdefs{DISTRO_NAME},
		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '2',
							   arch => 'ppc',
							   key  => '1065571970.028067',
							   rpm  => '',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-AS3-ppc64',
		},
		{
		 num  => '3',
		 name => $::pkgdefs{DISTRO_NAME},

		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '3',
							   arch => 'ppc',
							   key  => '1065571970.028067',
							   rpm  => '',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-AS3-ppc64',
		},
		{
		 num               => '1',
		 name              => $::pkgdefs{DISTRO_NAME} . "(Update 1) Extras CD",
		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '1',
							   arch => 'ppc',
							   key  => '',
							   rpm  => 'images/iprdd.img',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-AS3-extra',
		},
		{
		 num                  => '4',
		 name                 => $::pkgdefs{DISTRO_NAME} . "(Update 2)",
		 not_for_full_install => 'TRUE',

		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '4',
							   arch => 'ppc',
							   key  => '1083779332.636875',
							   rpm  => 'RedHat/RPMS/sg3_utils-1.06-2.ppc.rpm',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-AS3-QU2-extra',
		}
	];

	$::pkgdefs{distro_disks} = $dd_ref;
}

#--------------------------------------------------------------------------------

=head3	Service Pack disks defination

        Distribution QU Disk descriptions used to prompt for the CD-ROMs
        during installation.

        One stanza per CDROM:

                num                     = the number on the CD-ROM's label
                name                    = the text string describing the CD-ROM
                diskid_searchargs       = the arguments be searched to identify the disk
                    file    - specific file on the disk
                    num
                    arch
                    key	    - specific contents of this file
                    rpm	    - specific rpm package on this disk

                diskid_searchprog       = the subroutine be used when identifying the disk
                diskid_target		    = the target this disk would be copied to

=cut

#--------------------------------------------------------------------------------
{

	# set to distro disks

	$::pkgdefs{sp_disks}{QU1} = $::pkgdefs{distro_disks};
}

#--------------------------------------------------------------------------------
{
	my $qu2_ref = [
				   {
					num  => '1',
					name => $::pkgdefs{DISTRO_NAME} . " (Update 2)",
					diskid_searchargs => {
									file => '.discinfo',
									num  => '1',
									arch => 'ppc',
									key  => '1083779332.636875',
									rpm => 'SRPMS/comps-3AS-0.20040505.src.rpm',
					},
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-AS3-QU2',
				   },
				   {
					num  => '2',
					name => $::pkgdefs{DISTRO_NAME} . " (Update 2)",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '2',
										  arch => 'ppc',
										  key  => '1083779332.636875',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-AS3-QU2',
				   },
				   {
					num  => '3',
					name => $::pkgdefs{DISTRO_NAME} . " (Update 2)",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '3',
										  arch => 'ppc',
										  key  => '1083779332.636875',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-AS3-QU2',
				   },
				   {
					num  => '4',
					name => $::pkgdefs{DISTRO_NAME} . " (Update 2)",
					diskid_searchargs => {
								  file => '.discinfo',
								  num  => '4',
								  arch => 'ppc',
								  key  => '1083779332.636875',
								  rpm => 'RedHat/RPMS/sg3_utils-1.06-2.ppc.rpm',
					},
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-AS3-QU2',
				   },
				  ];

	$::pkgdefs{sp_disks}{QU2} = $qu2_ref;
}

#--------------------------------------------------------------------------------

=head3	Service Pack disks defination

        Notes: RHEL3 QU3

=cut

#--------------------------------------------------------------------------------
{
	my $qu3_ref = [
				   {
					num  => '1',
					name => $::pkgdefs{DISTRO_NAME} . " (Update 3)",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '1',
										  arch => 'ppc',
										  key  => '1094179470.941761',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-AS3-QU3',
				   },
				   {
					num  => '2',
					name => $::pkgdefs{DISTRO_NAME} . " (Update 3)",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '2',
										  arch => 'ppc',
										  key  => '1094179470.941761',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-AS3-QU3',
				   },
				   {
					num  => '3',
					name => $::pkgdefs{DISTRO_NAME} . " (Update 3)",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '3',
										  arch => 'ppc',
										  key  => '1094179470.941761',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-AS3-QU3',
				   },
				   {
					num  => '4',
					name => $::pkgdefs{DISTRO_NAME} . " (Update 3)",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '4',
										  arch => 'ppc',
										  key  => '1094179470.941761',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-AS3-QU3',
				   },
				  ];

	$::pkgdefs{sp_disks}{QU3} = $qu3_ref;
}

#--------------------------------------------------------------------------------

=head3	Service Pack disks defination

        Notes: RHEL3 QU4

=cut

#--------------------------------------------------------------------------------
{
	my $qu4_ref = [
				   {
					num  => '1',
					name => $::pkgdefs{DISTRO_NAME} . " (Update 4)",
					diskid_searchargs => {
									file => '.discinfo',
									num  => '1',
									arch => 'ppc',
									key  => '1103066211.484334',
									rpm => 'SRPMS/comps-3AS-0.20041214.src.rpm',
					},
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-AS3-QU4',
				   },
				   {
					num  => '2',
					name => $::pkgdefs{DISTRO_NAME} . " (Update 4)",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '2',
										  arch => 'ppc',
										  key  => '1103066211.484334',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-AS3-QU4',
				   },
				   {
					num  => '3',
					name => $::pkgdefs{DISTRO_NAME} . " (Update 4)",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '3',
										  arch => 'ppc',
										  key  => '1103066211.484334',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-AS3-QU4',
				   },
				   {
					num  => '4',
					name => $::pkgdefs{DISTRO_NAME} . " (Update 4)",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '4',
										  arch => 'ppc',
										  key  => '1103066211.484334',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-AS3-QU4',
				   }
				  ];

	$::pkgdefs{sp_disks}{QU4} = $qu4_ref;
}

#--------------------------------------------------------------------------------
{
	my $qu5_ref = [
				   {
					num  => '1',
					name => $::pkgdefs{DISTRO_NAME} . " (Update 5)",
					diskid_searchargs => {
									file => '.discinfo',
									num  => '1',
									arch => 'ppc',
									key  => '1115875526.853979',
									rpm => 'SRPMS/comps-3AS-0.20050512.src.rpm',
					},
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-AS3-QU5',
				   },
				   {
					num  => '2',
					name => $::pkgdefs{DISTRO_NAME} . " (Update 5)",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '2',
										  arch => 'ppc',
										  key  => '1115875526.853979',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-AS3-QU5',
				   },
				   {
					num  => '3',
					name => $::pkgdefs{DISTRO_NAME} . " (Update 5)",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '3',
										  arch => 'ppc',
										  key  => '1115875526.853979',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-AS3-QU5',
				   },
				   {
					num  => '4',
					name => $::pkgdefs{DISTRO_NAME} . " (Update 5)",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '4',
										  arch => 'ppc',
										  key  => '1115875526.853979',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-AS3-QU5',
				   }
				  ];

	$::pkgdefs{sp_disks}{QU5} = $qu5_ref;
}

#--------------------------------------------------------------------------------
{
	my $qu6_ref = [
				   {
					num  => '1',
					name => $::pkgdefs{DISTRO_NAME} . " (Update 6)",
					diskid_searchargs => {
									file => '.discinfo',
									num  => '1',
									arch => 'ppc',
									key  => '1127325078.360525',
									rpm => 'SRPMS/comps-3AS-0.20050921.src.rpm',
					},
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-AS3-QU6',
				   },
				   {
					num  => '2',
					name => $::pkgdefs{DISTRO_NAME} . " (Update 6)",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '2',
										  arch => 'ppc',
										  key  => '1127325078.360525',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-AS3-QU6',
				   },
				   {
					num  => '3',
					name => $::pkgdefs{DISTRO_NAME} . " (Update 6)",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '3',
										  arch => 'ppc',
										  key  => '1127325078.360525',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-AS3-QU6',
				   },
				   {
					num  => '4',
					name => $::pkgdefs{DISTRO_NAME} . " (Update 6)",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '4',
										  arch => 'ppc',
										  key  => '1127325078.360525',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-AS3-QU6',
				   }
				  ];

	$::pkgdefs{sp_disks}{QU6} = $qu6_ref;
}
#--------------------------------------------------------------------------------
{
	my $qu7_ref = [
				   {
					num  => '1',
					name => $::pkgdefs{DISTRO_NAME} . " (Update 7)",
					diskid_searchargs => {
									file => '.discinfo',
									num  => '1',
									arch => 'ppc',
									key  => '1141667126.895099',
									rpm => 'SRPMS/comps-3AS-0.20060306.src.rpm',
					},
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-AS3-QU7',
				   },
				   {
					num  => '2',
					name => $::pkgdefs{DISTRO_NAME} . " (Update 7)",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '2',
										  arch => 'ppc',
										  key  => '1141667126.895099',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-AS3-QU7',
				   },
				   {
					num  => '3',
					name => $::pkgdefs{DISTRO_NAME} . " (Update 7)",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '3',
										  arch => 'ppc',
										  key  => '1141667126.895099',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-AS3-QU7',
				   },
				   {
					num  => '4',
					name => $::pkgdefs{DISTRO_NAME} . " (Update 7)",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '4',
										  arch => 'ppc',
										  key  => '1141667126.895099',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-AS3-QU7',
				   }
				  ];

	$::pkgdefs{sp_disks}{QU7} = $qu7_ref;
}

#-------------------------------------------------------------------------------

=head3	rdm_packages - RDM Packages to Install

        Notes:

=cut

#-------------------------------------------------------------------------------
{
	my %rdmpkgs_ref;

	# defaults
	$rdmpkgs_ref{$_server_}{$::csm_version} = [];

	$rdmpkgs_ref{$_iserver_}{$::csm_version} = [];

	$rdmpkgs_ref{$_node_}{$::csm_version} = [];

	# exceptions  - must follow the default assignments.
	# none

	$::pkgdefs{rdm_packages} = $rdmpkgs_ref{$::mgmt_type}{$::csm_version};
}

#-------------------------------------------------------------------------------

=head3	rdm_unpackages - RDM Packages to Uninstall

        Notes:

=cut

#-------------------------------------------------------------------------------
{
	my %rdmunpkgs_ref;

	# defaults
	$rdmunpkgs_ref{$_server_}{$::csm_version} = [];

	$rdmunpkgs_ref{$_iserver_}{$::csm_version} = [];

	$rdmunpkgs_ref{$_node_}{$::csm_version} = [];

	# exceptions  - must follow the default assignments.
	# none

	$::pkgdefs{rdm_unpackages} = $rdmunpkgs_ref{$::mgmt_type}{$::csm_version};
}

1;    # end

