# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2004,2008 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
#
# @(#)76   1.45   src/csm/install/pkgdefs/Linux-RedHatEL-AS4-ppc64.pm.perl, setup, csm_rgar2h, rgar2hs001a 11/23/06 11:08:19
#--------------------------------------------------------------------------------

=head3	Linux-RedHatEL-AS4-ppc64.pm.perl

        Package Definition File:   RedHatEL-AS 4 ppc

        Notes:

        The following global variables must be initalized before including
        this file:

                $::mgmt_type    = [ MgmtServer | MgdNode ]
                $::csm_version  = [1.3.0 | 1.3.1 | 1.3.2 | ... ]


        exceptions:
        This file has been rewritten for csm 1.3.4 to rely on default values
        with support for release-specific exceptions.  This makes it much
        simpler to maintain the package defs across releases.

	The approach uses $::csm_version to set default values for both server and
	node defines.  It allows for execptions to these default values by defining
	specific csm versions assignments which overwrite the defaults when
	$::csm_version is equal to the execption's version number.

	ORDER IS IMPORTANT:
	As noted in the code, any excptions must follow the default assignments,
	otherwise the execption assignment will be overwriten by the default.

	OTHER DOCUMENTATION - see pkgdefs/Linux.pm

=cut

#--------------------------------------------------------------------------------

# houskeeping

package RedHatELAS4ppc64;

#do "/opt/csm/install/pkgdefs/Linux-ppc64.pm";
my $progdir = $0;
$progdir =~ s/\/[^\/]*$/\//g;
if (-e "$progdir/pkgdefs/Linux-RedHatEL4-ppc64.pm")
{
	do "$progdir/pkgdefs/Linux-RedHatEL4-ppc64.pm";
}
else
{
	do "/opt/csm/install/pkgdefs/Linux-RedHatEL4-ppc64.pm";
}

MessageUtils->messageFromCat(
						  'csmInstall.cat',
						  $::MSGMAPPATH,
						  'csminstall',
						  'V',
						  'IMsgLoading',
						  "/opt/csm/install/pkgdefs/Linux-RedHatEL-AS4-ppc64.pm"
);

my $_server_  = 'MgmtServer';
my $_node_    = 'MgdNode';
my $_iserver_ = 'InstallServer';

# where this distribution be supported
$::pkgdefs{'where_supported'} = ['MgmtServer', 'InstallServer', 'MgdNode'];

#--------------------------------------------------------------------------------

=head3	DISTRO Defintions

	Notes :

=cut

#--------------------------------------------------------------------------------
{
	# distribution name
	$::pkgdefs{DISTRO_NAME} = "Red Hat Enterprise Linux AS 4 PPC";

	$::pkgdefs{DISTRO_DISKLIST}   = "1 2 3 4 5";        # TO BE REMOVED

	# directory on CDs which contains rpm packages
	$::pkgdefs{DISTRO_RPMDIR}     = "RedHat/RPMS";

	$::pkgdefs{DISTRO_UPDATESDIR} = "RedHat/Updates";

}

#--------------------------------------------------------------------------------

=head3  distro_disks - Distribution Disk Defines

        Distribution Disk descriptions used to prompt for the CD-ROMs
        during installation.

        One stanza per CDROM:

                num                     = the number on the CD-ROM's label
                name                    = the text string describing the CD-ROM
                diskid_searchargs       = the arguments be searched to identify the disk
                    file    - specific file on the disk
                    num
                    arch
                    key	    - specific contents of this file
                    rpm	    - specific rpm package on this disk

                diskid_searchprog       = the subroutine be used when identifying the disk
                diskid_target		    = the target this disk would be copied to

=cut

#--------------------------------------------------------------------------------

{
	my $dd_ref = [
		{
		 num               => '1',
		 name              => $::pkgdefs{DISTRO_NAME},
		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '1',
							   arch => 'ppc',
							   key  => '1105118085.390417',
							   rpm  => 'RedHat/RPMS/redhat-release-4AS*',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-AS4-ppc64',
		},
		{
		 num               => '2',
		 name              => $::pkgdefs{DISTRO_NAME},
		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '2',
							   arch => 'ppc',
							   key  => '1105118085.390417',
							   rpm  => '',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-AS4-ppc64',
		},
		{
		 num  => '3',
		 name => $::pkgdefs{DISTRO_NAME},

		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '3',
							   arch => 'ppc',
							   key  => '1105118085.390417',
							   rpm  => '',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-AS4-ppc64',
		},
		{
		 num  => '4',
		 name => $::pkgdefs{DISTRO_NAME},

		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '4',
							   arch => 'ppc',
							   key  => '1105118085.390417',
							   rpm  => '',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-AS4-ppc64',
		},
		{
		 num  => '5',
		 name => $::pkgdefs{DISTRO_NAME},

		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '5',
							   arch => 'ppc',
							   key  => '1105118085.390417',
							   rpm  => '',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-AS4-ppc64',
		}
	];

	$::pkgdefs{distro_disks} = $dd_ref;
}

#--------------------------------------------------------------------------------

{
	my $qu1_ref = [
		{
		 num               => '1',
		 name              => $::pkgdefs{DISTRO_NAME} . " QU1",
		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '1',
							   arch => 'ppc',
							   key  => '1117038026.913609',
							   rpm  => 'RedHat/RPMS/redhat-release-4AS*',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-AS4-QU1',
		},
		{
		 num               => '2',
		 name              => $::pkgdefs{DISTRO_NAME} . " QU1",
		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '2',
							   arch => 'ppc',
							   key  => '1117038026.913609',
							   rpm  => '',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-AS4-QU1',
		},
		{
		 num  => '3',
		 name => $::pkgdefs{DISTRO_NAME} . " QU1",

		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '3',
							   arch => 'ppc',
							   key  => '1117038026.913609',
							   rpm  => '',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-AS4-QU1',
		},
		{
		 num  => '4',
		 name => $::pkgdefs{DISTRO_NAME} . " QU1",

		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '4',
							   arch => 'ppc',
							   key  => '1117038026.913609',
							   rpm  => '',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-AS4-QU1',
		},
		{
		 num  => '5',
		 name => $::pkgdefs{DISTRO_NAME} . " QU1",

		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '5',
							   arch => 'ppc',
							   key  => '1117038026.913609',
							   rpm  => '',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-AS4-QU1',
		}
	];

	$::pkgdefs{sp_disks}{QU1} = $qu1_ref;
}

#--------------------------------------------------------------------------------

{
	my $qu2_ref = [
		{
		 num               => '1',
		 name              => $::pkgdefs{DISTRO_NAME} . " QU2",
		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '1',
							   arch => 'ppc',
							   key  => '1128186463.116395',
							   rpm  => 'RedHat/RPMS/redhat-release-4AS*',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-AS4-QU2',
		},
		{
		 num               => '2',
		 name              => $::pkgdefs{DISTRO_NAME} . " QU2",
		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '2',
							   arch => 'ppc',
							   key  => '1128186463.116395',
							   rpm  => '',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-AS4-QU2',
		},
		{
		 num  => '3',
		 name => $::pkgdefs{DISTRO_NAME} . " QU2",

		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '3',
							   arch => 'ppc',
							   key  => '1128186463.116395',
							   rpm  => '',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-AS4-QU2',
		},
		{
		 num  => '4',
		 name => $::pkgdefs{DISTRO_NAME} . " QU2",

		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '4',
							   arch => 'ppc',
							   key  => '1128186463.116395',
							   rpm  => '',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-AS4-QU2',
		},
		{
		 num  => '5',
		 name => $::pkgdefs{DISTRO_NAME} . " QU2",

		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '5',
							   arch => 'ppc',
							   key  => '1128186463.116395',
							   rpm  => '',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-AS4-QU2',
		}
	];

	$::pkgdefs{sp_disks}{QU2} = $qu2_ref;
}

#--------------------------------------------------------------------------------
{
	my $qu3_ref = [
		{
		 num               => '1',
		 name              => $::pkgdefs{DISTRO_NAME} . " QU3",
		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '1',
							   arch => 'ppc',
							   key  => '1141418721.121064',
							   rpm  => 'RedHat/RPMS/redhat-release-4AS*',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-AS4-QU3',
		},
		{
		 num               => '2',
		 name              => $::pkgdefs{DISTRO_NAME} . " QU3",
		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '2',
							   arch => 'ppc',
							   key  => '1141418721.121064',
							   rpm  => '',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-AS4-QU3',
		},
		{
		 num  => '3',
		 name => $::pkgdefs{DISTRO_NAME} . " QU3",

		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '3',
							   arch => 'ppc',
							   key  => '1141418721.121064',
							   rpm  => '',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-AS4-QU3',
		},
		{
		 num  => '4',
		 name => $::pkgdefs{DISTRO_NAME} . " QU3",

		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '4',
							   arch => 'ppc',
							   key  => '1141418721.121064',
							   rpm  => '',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-AS4-QU3',
		},
		{
		 num  => '5',
		 name => $::pkgdefs{DISTRO_NAME} . " QU3",

		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '5',
							   arch => 'ppc',
							   key  => '1141418721.121064',
							   rpm  => '',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-AS4-QU3',
		}
	];

	$::pkgdefs{sp_disks}{QU3} = $qu3_ref;
}
#--------------------------------------------------------------------------------
{
	my $qu4_ref = [
		{
		 num               => '1',
		 name              => $::pkgdefs{DISTRO_NAME} . " QU4",
		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '1',
							   arch => 'ppc',
							   key  => '1154572007.061296',
							   rpm  => 'RedHat/RPMS/redhat-release-4AS*',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-AS4-QU4',
		},
		{
		 num               => '2',
		 name              => $::pkgdefs{DISTRO_NAME} . " QU4",
		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '2',
							   arch => 'ppc',
							   key  => '1154572007.061296',
							   rpm  => '',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-AS4-QU4',
		},
		{
		 num  => '3',
		 name => $::pkgdefs{DISTRO_NAME} . " QU4",
		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '3',
							   arch => 'ppc',
							   key  => '1154572007.061296',
							   rpm  => '',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-AS4-QU4',
		},
		{
		 num  => '4',
		 name => $::pkgdefs{DISTRO_NAME} . " QU4",

		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '4',
							   arch => 'ppc',
							   key  => '1154572007.061296',
							   rpm  => '',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-AS4-QU4',
		},
		{
		 num  => '5',
		 name => $::pkgdefs{DISTRO_NAME} . " QU4",

		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '5',
							   arch => 'ppc',
							   key  => '1154572007.061296',
							   rpm  => '',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-AS4-QU4',
		}
	];

	$::pkgdefs{sp_disks}{QU4} = $qu4_ref;
}

=head3 ramdisk_size

        Notes: the ramdisk size
=cut

#---------------------------------------------------------------------------------
{
        $::pkgdefs{'ramdisk_size'} = 10240;
}
#--------------------------------------------------------------------------------

=head3 kernel_arch_dir

        Notes: the architecture directory for drivers

=cut

#--------------------------------------------------------------------------------
{
        my $kernel_arch_dir = {
                                                   'default'  => 'ppc64',
                                                  };
        $::pkgdefs{'kernel_arch_dir'} = $kernel_arch_dir;
}
1;    # end

