# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2008 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 

# @(#)59   1.3   src/csm/install/pkgdefs/Linux-RedHatEL-AS4.7-ppc64.pm.perl, setup, csm_rgar2h, rgar2hs001a 7/20/08 23:23:36

=head3	Linux-RedHatEL-AS4.7-ppc64.pm.perl

        Package Definition File:   RedHatEL-AS 4.7 ppc

        Notes:

        The following global variables must be initalized before including
        this file:

                $::mgmt_type    = [ MgmtServer | MgdNode ]
                $::csm_version  = [1.3.0 | 1.3.1 | 1.3.2 | ... ]


        exceptions:
        This file has been rewritten for csm 1.3.4 to rely on default values
        with support for release-specific exceptions.  This makes it much
        simpler to maintain the package defs across releases.

	The approach uses $::csm_version to set default values for both server and
	node defines.  It allows for execptions to these default values by defining
	specific csm versions assignments which overwrite the defaults when
	$::csm_version is equal to the execption's version number.

	ORDER IS IMPORTANT:
	As noted in the code, any excptions must follow the default assignments,
	otherwise the execption assignment will be overwriten by the default.

	OTHER DOCUMENTATION - see pkgdefs/Linux.pm

=cut

#--------------------------------------------------------------------------------

# houskeeping

package RedHatELAS47ppc64;

#do "/opt/csm/install/pkgdefs/Linux-ppc64.pm";
my $progdir = $0;
$progdir =~ s/\/[^\/]*$/\//g;
if (-e "$progdir/pkgdefs/Linux-RedHatEL4.7-ppc64.pm")
{
	do "$progdir/pkgdefs/Linux-RedHatEL4.7-ppc64.pm";
}
else
{
	do "/opt/csm/install/pkgdefs/Linux-RedHatEL4.7-ppc64.pm";
}

MessageUtils->messageFromCat(
						  'csmInstall.cat',
						  $::MSGMAPPATH,
						  'csminstall',
						  'V',
						  'IMsgLoading',
						  "/opt/csm/install/pkgdefs/Linux-RedHatEL-AS4.7-ppc64.pm"
);

my $_server_  = 'MgmtServer';
my $_node_    = 'MgdNode';
my $_iserver_ = 'InstallServer';

# where this distribution be supported
$::pkgdefs{'where_supported'} = ['MgmtServer', 'InstallServer', 'MgdNode'];

#--------------------------------------------------------------------------------

=head3	DISTRO Defintions

	Notes :

=cut

#--------------------------------------------------------------------------------
{
	# distribution name
	$::pkgdefs{DISTRO_NAME} = "Red Hat Enterprise Linux AS 4.7 PPC";

	$::pkgdefs{DISTRO_DISKLIST}   = "1 2 3 4 5";        # TO BE REMOVED

	# directory on CDs which contains rpm packages
	$::pkgdefs{DISTRO_RPMDIR}     = "RedHat/RPMS";

	$::pkgdefs{DISTRO_UPDATESDIR} = "RedHat/Updates";

}

#--------------------------------------------------------------------------------

=head3  distro_disks - Distribution Disk Defines

        Distribution Disk descriptions used to prompt for the CD-ROMs
        during installation.

        One stanza per CDROM:

                num                     = the number on the CD-ROM's label
                name                    = the text string describing the CD-ROM
                diskid_searchargs       = the arguments be searched to identify the disk
                    file    - specific file on the disk
                    num
                    arch
                    key	    - specific contents of this file
                    rpm	    - specific rpm package on this disk

                diskid_searchprog       = the subroutine be used when identifying the disk
                diskid_target		    = the target this disk would be copied to

=cut

#--------------------------------------------------------------------------------

{
	my $dd_ref = [
		{
		 num               => '1',
		 name              => $::pkgdefs{DISTRO_NAME},
		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '1',
							   arch => 'ppc',
							   key  => '1215760542.424147',
							   rpm  => 'RedHat/RPMS/redhat-release-4AS*',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-AS4.7-ppc64',
		},
		{
		 num               => '2',
		 name              => $::pkgdefs{DISTRO_NAME},
		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '2',
							   arch => 'ppc',
							   key  => '1215760542.424147',
							   rpm  => '',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-AS4.7-ppc64',
		},
		{
		 num  => '3',
		 name => $::pkgdefs{DISTRO_NAME},

		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '3',
							   arch => 'ppc',
							   key  => '1215760542.424147',
							   rpm  => '',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-AS4.7-ppc64',
		},
		{
		 num  => '4',
		 name => $::pkgdefs{DISTRO_NAME},

		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '4',
							   arch => 'ppc',
							   key  => '1215760542.424147',
							   rpm  => '',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-AS4.7-ppc64',
		},
		{
		 num  => '5',
		 name => $::pkgdefs{DISTRO_NAME},

		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '5',
							   arch => 'ppc',
							   key  => '1215760542.424147',
							   rpm  => '',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-AS4.7-ppc64',
		}
	];

	$::pkgdefs{distro_disks} = $dd_ref;
}

#--------------------------------------------------------------------------------

=head3  distro_disks - Distribution DVD Disk Defines

    Distribution Disk descriptions used to prompt for the CD-ROMs
    during installation.

    One stanza per DVD:
        type                    = the disk type, CD or DVD. default is CD

        num                     = the number on the CD-ROM's label
        name                    = the text string describing the CD-ROM
        diskid_searchargs       = the arguments be searched to identify the disk
            file<num>    - specific file on the disk
            key<num>    - specific contents of this file
			More than one file-key pair can be specified

        diskid_searchprog       = the subroutine be used when identifying the disk
        diskid_target		= the target this disk would be copied to

=cut

#--------------------------------------------------------------------------------
{

	my $ddvd_ref = [
		{
		 type              => 'DVD',
		 num               => '1',
		 name              => $::pkgdefs{DISTRO_NAME},
		 diskid_searchargs => {
							   file => '.discinfo',
							   num  => '1,2,3,4,5',
							   arch => 'ppc',
							   key  => '1215760542.424147',
							   rpm  => 'RedHat/RPMS/redhat-release-4AS*',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-AS4.7-ppc64',
		},
		];
	$::pkgdefs{distro_dvd_disks} = $ddvd_ref;
}
=cut

#---------------------------------------------------------------------------------
{
        $::pkgdefs{'ramdisk_size'} = 10240;
}
#--------------------------------------------------------------------------------

=head3 kernel_arch_dir

        Notes: the architecture directory for drivers

=cut

#--------------------------------------------------------------------------------
{
        my $kernel_arch_dir = {
                                                   'default'  => 'ppc64',
                                                  };
        $::pkgdefs{'kernel_arch_dir'} = $kernel_arch_dir;
}
1;    # end

