# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2004,2008 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
#
# @(#)66   1.51   src/csm/install/pkgdefs/Linux-RedHatEL-AS4.pm.perl, setup, csm_rgar2h, rgar2hs001a 8/22/06 05:02:21
#--------------------------------------------------------------------------------

=head3	Linux-RedHatEL-AS4.pm.perl

        Package Definition File:    RedHatEL 4

        Notes:

        The following global variables must be initalized before including
        this file:

                $::mgmt_type    = [ MgmtServer | MgdNode ]
                $::csm_version  = [ 1.3.0 | 1.3.1 | 1.3.2 | ... ]


        exceptions:
        This file has been rewritten for csm 1.3.4 to rely on default values
        with support for release-specific exceptions.  This makes it much
        simpler to maintain the package defs across releases.

	The approach uses $::csm_version to set default values for both server and
	node defines.  It allows for execptions to these default values by defining
	specific csm versions assignments which overwrite the defaults when
	$::csm_version is equal to the execption's version number.

	ORDER IS IMPORTANT:
	As noted in the code, any excptions must follow the default assignments,
	otherwise the execption assignment will be overwriten by the default.

	OTHER DOCUMENTATION - see pkgdefs/Linux.pm

=cut

#--------------------------------------------------------------------------------

# houskeeping

package RedHatELAS4;

my $progdir = $0;
$progdir =~ s/\/[^\/]*$/\//g;
if (-e "$progdir/pkgdefs/Linux-RedHatEL4.pm")
{
	do "$progdir/pkgdefs/Linux-RedHatEL4.pm";
}
else
{
	do "/opt/csm/install/pkgdefs/Linux-RedHatEL4.pm";
}

MessageUtils->messageFromCat(
							 'csmInstall.cat',
							 $::MSGMAPPATH,
							 'csminstall',
							 'V',
							 'IMsgLoading',
							 "/opt/csm/install/pkgdefs/Linux-RedHatEL-AS4.pm"
							);

my $_server_  = 'MgmtServer';
my $_node_    = 'MgdNode';
my $_iserver_ = 'InstallServer';

# where this distribution be supported
$::pkgdefs{'where_supported'} = ['MgmtServer', 'InstallServer', 'MgdNode'];

#--------------------------------------------------------------------------------

=head3	DISTRO Defintions

	Notes :

=cut

#--------------------------------------------------------------------------------
{

	# distribution name
	$::pkgdefs{DISTRO_NAME} = "Red Hat Enterprise Linux AS 4";

	$::pkgdefs{DISTRO_DISKLIST} = "1 2 3 4 5";     # TO BE REMOVED

	# directory on CDs which contains rpm packages
	$::pkgdefs{DISTRO_RPMDIR}   = "RedHat/RPMS";

}

#--------------------------------------------------------------------------------

=head3  distro_disks - Distribution Disk Defines

        Distribution Disk descriptions used to prompt for the CD-ROMs
        during installation.

        One stanza per CDROM:

                num                     = the number on the CD-ROM's label
                name                    = the text string describing the CD-ROM
                diskid_searchargs       = the arguments be searched to identify the disk
                    file    - specific file on the disk
                    num
                    arch
                    key	    - specific contents of this file
                    rpm	    - specific rpm package on this disk

                diskid_searchprog       = the subroutine be used when identifying the disk
                diskid_target		    = the target this disk would be copied to

=cut

#--------------------------------------------------------------------------------
{
	my $dd_ref = [
				  {
				   num               => '1',
				   name              => $::pkgdefs{DISTRO_NAME},
				   diskid_searchargs => {
									   file => '.discinfo',
									   num  => '1',
									   arch => 'i386',
									   key  => '1105116601.310480',
									   rpm => 'RedHat/RPMS/redhat-release-4AS*',
				   },
				   diskid_searchprog => \&Linux::rhel_diskid_match_prog,
				   diskid_target     => 'RedHatEL-AS4-i386',
				  },
				  {
				   num               => '2',
				   name              => $::pkgdefs{DISTRO_NAME},
				   diskid_searchargs => {
										 file => '.discinfo',
										 num  => '2',
										 arch => 'i386',
										 key  => '1105116601.310480',
										 rpm  => '',
										},
				   diskid_searchprog => \&Linux::rhel_diskid_match_prog,
				   diskid_target     => 'RedHatEL-AS4-i386',
				  },
				  {
				   num               => '3',
				   name              => $::pkgdefs{DISTRO_NAME},
				   diskid_searchargs => {
										 file => '.discinfo',
										 num  => '3',
										 arch => 'i386',
										 key  => '1105116601.310480',
										 rpm  => '',
										},
				   diskid_searchprog => \&Linux::rhel_diskid_match_prog,
				   diskid_target     => 'RedHatEL-AS4-i386',
				  },
				  {
				   num               => '4',
				   name              => $::pkgdefs{DISTRO_NAME},
				   diskid_searchargs => {
										 file => '.discinfo',
										 num  => '4',
										 arch => 'i386',
										 key  => '1105116601.310480',
										 rpm  => '',
										},
				   diskid_searchprog => \&Linux::rhel_diskid_match_prog,
				   diskid_target     => 'RedHatEL-AS4-i386',
				  }
				 ];

	$::pkgdefs{distro_disks} = $dd_ref;
}

#--------------------------------------------------------------------------------
{
	my $qu1_ref = [
				   {
					num               => '1',
					name              => $::pkgdefs{DISTRO_NAME} . " QU1",
					diskid_searchargs => {
									   file => '.discinfo',
									   num  => '1',
									   arch => 'i386',
									   key  => '1117037315.753040',
									   rpm => 'RedHat/RPMS/redhat-release-4AS*',
					},
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-AS4-QU1',
				   },
				   {
					num               => '2',
					name              => $::pkgdefs{DISTRO_NAME} . " QU1",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '2',
										  arch => 'i386',
										  key  => '1117037315.753040',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-AS4-QU1',
				   },
				   {
					num               => '3',
					name              => $::pkgdefs{DISTRO_NAME} . " QU1",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '3',
										  arch => 'i386',
										  key  => '1117037315.753040',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-AS4-QU1',
				   },
				   {
					num               => '4',
					name              => $::pkgdefs{DISTRO_NAME} . " QU1",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '4',
										  arch => 'i386',
										  key  => '1117037315.753040',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-AS4-QU1',
				   }
				  ];

	$::pkgdefs{sp_disks}{QU1} = $qu1_ref;
}

#--------------------------------------------------------------------------------
{
	my $qu2_ref = [
				   {
					num               => '1',
					name              => $::pkgdefs{DISTRO_NAME} . " QU2",
					diskid_searchargs => {
									   file => '.discinfo',
									   num  => '1',
									   arch => 'i386',
									   key  => '1128185472.900128',
									   rpm => 'RedHat/RPMS/redhat-release-4AS*',
					},
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-AS4-QU2',
				   },
				   {
					num               => '2',
					name              => $::pkgdefs{DISTRO_NAME} . " QU2",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '2',
										  arch => 'i386',
										  key  => '1128185472.900128',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-AS4-QU2',
				   },
				   {
					num               => '3',
					name              => $::pkgdefs{DISTRO_NAME} . " QU2",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '3',
										  arch => 'i386',
										  key  => '1128185472.900128',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-AS4-QU2',
				   },
				   {
					num               => '4',
					name              => $::pkgdefs{DISTRO_NAME} . " QU2",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '4',
										  arch => 'i386',
										  key  => '1128185472.900128',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-AS4-QU2',
				   }
				  ];

	$::pkgdefs{sp_disks}{QU2} = $qu2_ref;
}
#--------------------------------------------------------------------------------
{
	my $qu3_ref = [
				   {
					num               => '1',
					name              => $::pkgdefs{DISTRO_NAME} . " QU3",
					diskid_searchargs => {
									   file => '.discinfo',
									   num  => '1',
									   arch => 'i386',
									   key  => '1141417589.425945',
									   rpm => 'RedHat/RPMS/redhat-release-4AS*',
					},
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-AS4-QU3',
				   },
				   {
					num               => '2',
					name              => $::pkgdefs{DISTRO_NAME} . " QU3",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '2',
										  arch => 'i386',
										  key  => '1141417589.425945',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-AS4-QU3',
				   },
				   {
					num               => '3',
					name              => $::pkgdefs{DISTRO_NAME} . " QU3",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '3',
										  arch => 'i386',
										  key  => '1141417589.425945',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-AS4-QU3',
				   },
				   {
					num               => '4',
					name              => $::pkgdefs{DISTRO_NAME} . " QU3",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '4',
										  arch => 'i386',
										  key  => '1141417589.425945',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-AS4-QU3',
				   }
				  ];

	$::pkgdefs{sp_disks}{QU3} = $qu3_ref;
}
#--------------------------------------------------------------------------------
{
	my $qu4_ref = [
				   {
					num               => '1',
					name              => $::pkgdefs{DISTRO_NAME} . " QU4",
					diskid_searchargs => {
									   file => '.discinfo',
									   num  => '1',
									   arch => 'i386',
									   key  => '1154571842.370424',
									   rpm => 'RedHat/RPMS/redhat-release-4AS*',
					},
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-AS4-QU4',
				   },
				   {
					num               => '2',
					name              => $::pkgdefs{DISTRO_NAME} . " QU4",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '2',
										  arch => 'i386',
										  key  => '1154571842.370424',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-AS4-QU4',
				   },
				   {
					num               => '3',
					name              => $::pkgdefs{DISTRO_NAME} . " QU4",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '3',
										  arch => 'i386',
										  key  => '1154571842.370424',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-AS4-QU4',
				   },
				   {
					num               => '4',
					name              => $::pkgdefs{DISTRO_NAME} . " QU4",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '4',
										  arch => 'i386',
										  key  => '1154571842.370424',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-AS4-QU4',
				   },
				   {	
					num               => '5',
					name              => $::pkgdefs{DISTRO_NAME} . " QU4",
					diskid_searchargs => {
										  file => '.discinfo',
										  num  => '5',
										  arch => 'i386',
										  key  => '1154571842.370424',
										  rpm  => '',
										 },
					diskid_searchprog => \&Linux::rhel_diskid_match_prog,
					diskid_target     => 'RedHatEL-AS4-QU4',
				   }
				  ];

	$::pkgdefs{sp_disks}{QU4} = $qu4_ref;
}

1;    # end
