# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2007,2008 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 

# @(#)31   1.4   src/csm/install/pkgdefs/Linux-RedHatEL-WS4.5.pm.perl, setup, csm_rgar2h, rgar2hs001a 5/8/07 04:48:35

#--------------------------------------------------------------------------------

=head3	Linux-RedHatEL-WS4.5.pm.perl

        Package Definition File:     RedHatEL 4.5

        Notes:  - no server support for WS distros.

        The following global variables must be initalized before including
        this file:

                $::mgmt_type    = [ MgmtServer | MgdNode ]
                $::csm_version  = [ 1.3.0 | 1.3.1 | 1.3.2 | ... ]


        exceptions:
        This file has been rewritten for csm 1.3.4 to rely on default values
        with support for release-specific exceptions.  This makes it much
        simpler to maintain the package defs across releases.

	The approach uses $::csm_version to set default values for both server and
	node defines.  It allows for execptions to these default values by defining
	specific csm versions assignments which overwrite the defaults when
	$::csm_version is equal to the execption's version number.

	ORDER IS IMPORTANT:
	As noted in the code, any excptions must follow the default assignments,
	otherwise the execption assignment will be overwriten by the default.

=cut

#--------------------------------------------------------------------------------

# houskeeping

package RedHatELWS45;

my $progdir = $0;
$progdir =~ s/\/[^\/]*$/\//g;
if (-e "$progdir/pkgdefs/Linux-RedHatEL4.5.pm")
{
	do "$progdir/pkgdefs/Linux-RedHatEL4.5.pm";
}
else
{
	do "/opt/csm/install/pkgdefs/Linux-RedHatEL4.5.pm";
}

MessageUtils->messageFromCat(
							 'csmInstall.cat',
							 $::MSGMAPPATH,
							 'csminstall',
							 'V',
							 'IMsgLoading',
							 "/opt/csm/install/pkgdefs/Linux-RedHatEL-WS4.5.pm"
							);

my $_server_  = 'MgmtServer';
my $_node_    = 'MgdNode';
my $_iserver_ = 'InstallServer';
$::pkgdefs{'where_supported'} = ['MgdNode'];

#--------------------------------------------------------------------------------

=head3	DISTRO Defintions

	Notes :

=cut

#--------------------------------------------------------------------------------
{

	$::pkgdefs{DISTRO_NAME} = "Red Hat Enterprise Linux WS 4.5";
	$::pkgdefs{DISTRO_DISKLIST} = "1 2 3 4 5";     # TO BE REMOVED
	$::pkgdefs{DISTRO_RPMDIR}   = "RedHat/RPMS";

}

#--------------------------------------------------------------------------------

=head3  distro_disks - Distribution Disk Defines

        Distribution Disk descriptions used to prompt for the CD-ROMs
        during installation.

        One stanza per CDROM:

                num                     = the number on the CD-ROM's label
                name                    = the text string describing the CD-ROM
                diskid_filename         = the filename to search to identify the disk
                                          - supportsw shell wildcards.
                diskid_searchstring     = the string to search for in diskid_filename
                                          - supports perl regular expressions


=cut

#--------------------------------------------------------------------------------
{
	my $dd_ref = [
				  {
				   num               => '1',
				   name              => $::pkgdefs{DISTRO_NAME},
				   diskid_searchargs => {
									   file => '.discinfo',
									   num  => '1',
									   arch => 'i386',
									   key  => '1177148299.639333',
									   rpm => 'RedHat/RPMS/redhat-release-4WS*',
				   },
				   diskid_searchprog => \&Linux::rhel_diskid_match_prog,
				   diskid_target     => 'RedHatEL-WS4.5-i386',
				  },
				  {
				   num               => '2',
				   name              => $::pkgdefs{DISTRO_NAME},
				   diskid_searchargs => {
										 file => '.discinfo',
										 num  => '2',
										 arch => 'i386',
										 key  => '1177148299.639333',
										 rpm  => '',
										},
				   diskid_searchprog => \&Linux::rhel_diskid_match_prog,
				   diskid_target     => 'RedHatEL-WS4.5-i386',
				  },
				  {
				   num               => '3',
				   name              => $::pkgdefs{DISTRO_NAME},
				   diskid_searchargs => {
										 file => '.discinfo',
										 num  => '3',
										 arch => 'i386',
										 key  => '1177148299.639333',
										 rpm  => '',
										},
				   diskid_searchprog => \&Linux::rhel_diskid_match_prog,
				   diskid_target     => 'RedHatEL-WS4.5-i386',
				  },
				  {
				   num               => '4',
				   name              => $::pkgdefs{DISTRO_NAME},
				   diskid_searchargs => {
										 file => '.discinfo',
										 num  => '4',
										 arch => 'i386',
										 key  => '1177148299.639333',
										 rpm  => '',
										},
				   diskid_searchprog => \&Linux::rhel_diskid_match_prog,
				   diskid_target     => 'RedHatEL-WS4.5-i386',
				  }
				 ];

	$::pkgdefs{distro_disks} = $dd_ref;
}


#--------------------------------------------------------------------------------

=head3  distro_disks - Distribution DVD Disk Defines

    Distribution Disk descriptions used to prompt for the CD-ROMs
    during installation.

    One stanza per DVD:
        type                    = the disk type, CD or DVD. default is CD

        num                     = the number on the CD-ROM's label
        name                    = the text string describing the CD-ROM
        diskid_searchargs       = the arguments be searched to identify the disk
            file<num>    - specific file on the disk
            key<num>    - specific contents of this file
			More than one file-key pair can be specified

        diskid_searchprog       = the subroutine be used when identifying the disk
        diskid_target		= the target this disk would be copied to

=cut

#--------------------------------------------------------------------------------
{

	my $ddvd_ref = [
		{
		 type              => 'DVD',
		 num               => '1',
		 name              => $::pkgdefs{DISTRO_NAME},
		 diskid_searchargs => {
						 	   file => '.discinfo',
							   num  => '1,2,3,4,5',
							   arch => 'i386',
							   key  => '1177148299.639333',
							   rpm => 'RedHat/RPMS/redhat-release-4WS*',
							  },
		 diskid_searchprog => \&Linux::rhel_diskid_match_prog,
		 diskid_target     => 'RedHatEL-WS4.5-i386',
		},
		];
	$::pkgdefs{distro_dvd_disks} = $ddvd_ref;
}

for my $pkgs ( keys %{$::pkgdefs{'pkgs'}{$_server_}})
{
        $::pkgdefs{'pkgs'}{$_server_}{$pkgs} = undef;
        $::pkgdefs{'pkgs'}{$_iserver_}{$pkgs} = undef;
}

1;    # end
