# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2007,2008 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 

# @(#)86   1.5   src/csm/install/pkgdefs/Linux-RedHatEL4.5-x86_64.pm.perl, setup, csm_rgar2h, rgar2hs001a 4/6/07 01:04:21

#--------------------------------------------------------------------------------

=head3	Linux-RedHatEL4.5-x86_64.pm.perl

        Package Definition File:    RedHatEL 4.5 x86_64

        Notes:

        The following global variables must be initalized before including
        this file:

                $::mgmt_type    = [MgmtServer | MgdNode ]
                $::csm_version  = [1.3.0 | 1.3.1 | 1.3.2 | ... ]


        exceptions:
        This file has been rewritten for csm 1.3.4 to rely on default values
        with support for release-specific exceptions.  This makes it much
        simpler to maintain the package defs across releases.

	The approach uses $::csm_version to set default values for both server and
	node defines.  It allows for execptions to these default values by defining
	specific csm versions assignments which overwrite the defaults when
	$::csm_version is equal to the execption's version number.

	ORDER IS IMPORTANT:
	As noted in the code, any excptions must follow the default assignments,
	otherwise the execption assignment will be overwriten by the default.

	OTHER DOCUMENTATION - see pkgdefs/Linux.pm

=cut

#--------------------------------------------------------------------------------

package RedHatEL45;

#--------------------------------------------------------------------------------

=head3  simple common attributes

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    # install package architecture
    $::pkgdefs{'arch'} = 'x86_64';

    # the directory where kernel and initrd (or zImage) is placed is CD
    $::pkgdefs{'install_image_dir'} = "isolinux";

    # the file name of kernel in CD
    $::pkgdefs{'kernel_file_name'} = "vmlinuz";

    # the file name of initrd (or zImage) in CD
    $::pkgdefs{'initrd_file_name'} = "initrd.img";

    # the network installation method
    $::pkgdefs{'install_method'} = 'kickstart';

    # additional options for "rpm" command
    $::pkgdefs{'additionalRpmCmdOptions'} = '--nosignature';    
}

my $progdir = $0;
$progdir =~ s/\/[^\/]*$/\//g;
if (-e "$progdir/pkgdefs/Linux-RedHatEL4-x86_64.pm")
{
	do "$progdir/pkgdefs/Linux-RedHatEL4-x86_64.pm";
}
else
{
	do "/opt/csm/install/pkgdefs/Linux-RedHatEL4-x86_64.pm";
}

MessageUtils->messageFromCat(
						 'csmInstall.cat',
						 $::MSGMAPPATH,
						 'csminstall',
						 'V',
						 'IMsgLoading',
						 "/opt/csm/install/pkgdefs/Linux-RedHatEL4.5-x86_64.pm"
                         );

my $_server_  = 'MgmtServer';
my $_node_    = 'MgdNode';
my $_iserver_ = 'InstallServer';

#--------------------------------------------------------------------------------

#--------------------------------------------------------------------------------

=head3  hwmaint_ReqLibsFromRPM

        Notes: These are required libraries for hwmaint operations, but are not
        in the initrd used to build the hwmaint ramdisk.  They must be extracted
        from the rpm files and manually copied to the ramdisk.

        This hash contains the needed libraries and the RPMs where they are packaged.

 $::pkgdefs{'hwmaint_ReqLibsFromRPM'}{'/usr/lib64/libstdc++.so.5'} = "compat-libstdc++-33*.x86_64";
                      ^                       ^                                ^
                      |                       |                                |
                  hash name             required library                 source rpm

        Note that the required library may optionally also contain a second value, to be 
        used as the utilmate file name copied to the ramdisk.  Some applications may be 
        searching for a generic library name to load.  Usually, the source RPM will provide the
        actual, specific library as well as a symbolic link to the generic name.  However, if only
        the specific library is provided, the second value will contain the generic name
        that can be used in the ramdisk.  The syntax is:

        ...{'/usr/lib/libstdc++-2-libc6.1-1-2.9.0.so::libstdc++-libc6.1-1.so.2'} = ...
                              ^                     ^^            ^
                              |                     ||            |
                       required library          delimiter    generic name


=cut

#--------------------------------------------------------------------------------
{
    $::pkgdefs{'hwmaint_ReqLibsFromRPM'}{'/lib64/libcrypt.so.1'} = "glibc-2.3.4*.x86_64";
}

#--------------------------------------------------------------------------------

=head3  getmacs_ReqLibs

            Notes:  The libs needed by the extra programs that be used to get node's
            MAC address. They also would be copied from the preinstall ramdisk
            into the new ramdisk.

=cut

#--------------------------------------------------------------------------------
{
        my $gr_ref = [
				  '/lib64/ld-linux-x86-64.so.2', '/lib64/libc.so.6',
				  '/lib64/libdl.so.2',           '/lib64/libtermcap.so.2',
				  '/lib64/libselinux.so.1',      '/lib64/libsepol.so.1',
				  '/lib64/libm.so.6',            '/lib64/libcrypt.so.1'
                                 ];

        $::pkgdefs{getmacs_ReqLibs} = $gr_ref;
}

#--------------------------------------------------------------------------------

1; #end
