# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2004,2008 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
#  Package Definition File:  SLES 9 ppc64 
#
# The following variables must be set before including this file:
#  $::mgmt_type   = MgmtServer | MgdNode
#  $::csm_version = 1.2.0, 1.3.0, 1.3.1, 1.3.2, 1.3.3, etc.
# @(#)90   1.14.1.69   src/csm/install/pkgdefs/Linux-SLES9-ppc64.pm.perl, setup, csm_rgar2h, rgar2hs001a 10/9/07 00:34:05

#--------------------------------------------------------------------------------

=head3	 Linux-SLES9-ppc64.pm.perl

        Package Definition File:    SLES 9 ppc64

        Notes:

        The following global variables must be initalized before including
        this file:

                $::mgmt_type    = [ MgmtServer | MgdNode ]
                $::csm_version  = [ 1.3.0 | 1.3.1 | 1.3.2 | ... ]


        exceptions:
        This file has been rewritten for csm 1.4.0 to rely on default values
        with support for release-specific exceptions.  This makes it much
        simpler to maintain the package defs across releases.

	The approach uses $::csm_version to set default values for both server and
	node defines.  It allows for execptions to these default values by defining
	specific csm versions assignments which overwrite the defaults when
	$::csm_version is equal to the execption's version number.

	ORDER IS IMPORTANT:
	As noted in the code, any excptions must follow the default assignments,
	otherwise the execption assignment will be overwriten by the default.

	OTHER DOCUMENTATION - see pkgdefs/Linux.pm

=cut

#--------------------------------------------------------------------------------

# houskeeping

package  SLES9;

#--------------------------------------------------------------------------------

=head3  simple common attributes

        Notes:

=cut

#--------------------------------------------------------------------------------
{
    # install package architecture
    $::pkgdefs{'arch'} = 'ppc64';

    # the directory where kernel and initrd (or zImage) is placed is CD
    $::pkgdefs{'install_image_dir'} = ".";

    # the file name of kernel in CD
    $::pkgdefs{'kernel_file_name'} = "install";

    # the file name of initrd (or zImage) in CD
    $::pkgdefs{'initrd_file_name'} = "install";

    # the network installation method
    $::pkgdefs{'install_method'} = 'autoyast';

    # the installing ramdisk format
    $::pkgdefs{'ramdisk_format'} = 'ext';

    # where this distribution is supported
    $::pkgdefs{'where_supported'} = ['MgmtServer', 'InstallServer',
        'MgdNode', 'diskless'];
}

my $progdir = $0;
$progdir =~ s/\/[^\/]*$/\//g;
if (-e "$progdir/pkgdefs/Linux.pm")
{
	do "$progdir/pkgdefs/Linux.pm";
}
else
{
	do "/opt/csm/install/pkgdefs/Linux.pm";
}

MessageUtils->messageFromCat(
							 'csmInstall.cat',
							 $::MSGMAPPATH,
							 'csminstall',
							 'V',
							 'IMsgLoading',
							 "/opt/csm/install/pkgdefs/Linux-SLES9-ppc64.pm"
							);

my $_server_  = 'MgmtServer';
my $_node_    = 'MgdNode';
my $_iserver_ = 'InstallServer';

#--------------------------------------------------------------------------------

=head3	mkzimage	

	cmd to hack the zimage

        Notes:


=cut
#--------------------------------------------------------------------------------
{
	$::pkgdefs{mkzimage} = "/lib/lilo/chrp/mkzimage_cmdline";
}

#--------------------------------------------------------------------------------

=head3	DISTRO Defintions

	Notes :

=cut

#--------------------------------------------------------------------------------
{

	$::pkgdefs{DISTRO_NAME}     = "SuSE SLES 9 PPC";
	$::pkgdefs{DISTRO_DISKLIST} = "1 2 3";             # TO BE REMOVED
	$::pkgdefs{DISTRO_RPMDIR}   = "suse/*";

}

#--------------------------------------------------------------------------------

=head3  distro_disks - Distribution Disk Defines

        Distribution Disk descriptions used to prompt for the CD-ROMs
        during installation.

        One stanza per CDROM:

            num                     = the number on the CD-ROM's label
            name                    = the text string describing the CD-ROM
            diskid_searchargs       = the arguments be searched to identify the disk
                file    - specific file on the disk
                key	    - specific contents of this file

            diskid_searchprog       = the subroutine be used when identifying the disk
            diskid_target		= the target this disk would be copied to


=cut

#--------------------------------------------------------------------------------
{
	my $dd_ref = [
		{
		 num  => '1',
		 name => $::pkgdefs{DISTRO_NAME},

		 diskid_searchargs => {
							   file => 'media.1/products',
							   key  => '/ SUSE-Linux-SLES-PPC 9',
							  },
		 diskid_searchprog => \&Linux::linux_diskid_match_prog,
		 diskid_target     => "sles9-ppc64",
		},
		{
		 num  => '2',
		 name => $::pkgdefs{DISTRO_NAME},

		 diskid_searchargs => {
							   file => 'media.1/products',
							   key  => '/ SUSE-Linux-CORE-PPC 9',
							  },
		 diskid_searchprog => \&Linux::linux_diskid_match_prog,
		 diskid_target     => "sles9-core-ppc64",
		},
		{
		 num  => '3',
		 name => $::pkgdefs{DISTRO_NAME},

		 diskid_searchargs => {
							   file => 'media.2/products',
							   key  => '/ SUSE-Linux-CORE-PPC 9',
							  },
		 diskid_searchprog => \&Linux::linux_diskid_match_prog,
		 diskid_target     => "sles9-core-ppc64",
		},
		{
		 num        => '4',
		 name       => $::pkgdefs{DISTRO_NAME},

		 diskid_searchargs => {
							   file => 'media.3/products',
							   key  => '/ SUSE-Linux-CORE-PPC 9',
							  },
		 diskid_searchprog => \&Linux::linux_diskid_match_prog,
		 diskid_target     => "sles9-core-ppc64",
		},
		{
		 num        => '5',
		 name       => $::pkgdefs{DISTRO_NAME},
		 is_extracd => '1',

		 diskid_searchargs => {
							   file => 'media.4/products',
							   key  => '/ SUSE-Linux-CORE-PPC 9',
							  },
		 diskid_searchprog => \&Linux::linux_diskid_match_prog,
		 diskid_target     => "sles9-core-ppc64",
		},
		{
		 num        => '6',
		 name       => $::pkgdefs{DISTRO_NAME},
		 is_extracd => '1',

		 diskid_searchargs => {
							   file => 'media.5/products',
							   key  => '/ SUSE-Linux-CORE-PPC 9',
							  },
		 diskid_searchprog => \&Linux::linux_diskid_match_prog,
		 diskid_target     => "sles9-core-ppc64",
		},
	];

	$::pkgdefs{distro_disks} = $dd_ref;
}

#--------------------------------------------------------------------------------

=head3  Service Pack disks defination

        Distribution SP Disk descriptions used to prompt for the CD-ROMs
        during installation.

        One stanza per CDROM:

            num                     = the number on the CD-ROM's label
            name                    = the text string describing the CD-ROM
            diskid_searchargs       = the arguments be searched to identify the disk
                file    - specific file on the disk
                key	    - specific contents of this file

            diskid_searchprog       = the subroutine be used when identifying the disk
            diskid_target		= the target this disk would be copied to

=cut

#--------------------------------------------------------------------------------
{
	my $sp1_ref = [
				   {
					num               => '1',
					name              => "SuSE SLES 9 SP1 PPC",
					diskid_searchargs => {
										  file => 'media.1/products',
										  key  => '/ SUSE-Linux-SP-ppc 1',
										 },
					diskid_searchprog => \&Linux::linux_diskid_match_prog,
					diskid_target     => "unitedlinux-sp1",
				   },
				   {
					num               => '2',
					name              => "SuSE SLES 9 SP1 PPC",
					diskid_searchargs => {
										  file => 'media.2/products',
										  key  => '/ SUSE-Linux-SP-ppc 1',
										 },
					diskid_searchprog => \&Linux::linux_diskid_match_prog,
					diskid_target     => "unitedlinux-sp1",
				   },
				   {
					num               => '3',
					name              => "SuSE SLES 9 SP1 PPC",
					is_extracd        => '1',
					diskid_searchargs => {
										  file => 'media.2/products',
										  key  => '/ SUSE-Linux-SP-ppc 1',
										 },
					diskid_searchprog => \&Linux::linux_diskid_match_prog,
					diskid_target     => "unitedlinux-sp1",
				   }
				  ];

	$::pkgdefs{sp_disks}{SP1} = $sp1_ref;
}
#--------------------------------------------------------------------------------
{
    my $sp2_ref = [
                   {
                    num               => '1',
                    name              => "SuSE SLES 9 SP2 PPC",
                    diskid_searchargs => {
                                          file => 'media.1/products',
                                          key  => '/ SUSE-Linux-SP-ppc 2',
                    },
                    diskid_searchprog => \&Linux::linux_diskid_match_prog,
                    diskid_target => "unitedlinux-sp2",
                   },
                   {
                    num               => '2',
                    name              => "SuSE SLES 9 SP2 PPC",
                    diskid_searchargs => {
                                          file => 'media.2/products',
                                          key  => '/ SUSE-Linux-SP-ppc 2',
                    },
                    diskid_searchprog => \&Linux::linux_diskid_match_prog,
                    diskid_target => "unitedlinux-sp2",
                   },
		   {
                    num               => '3',
                    name              => "SuSE SLES 9 SP2 PPC",
		    is_extracd        => '1',
		    diskid_searchargs => {
                                          file => 'media.2/products',
                                          key  => '/ SUSE-Linux-SP-ppc 2',
                    },
                    diskid_searchprog => \&Linux::linux_diskid_match_prog,
                    diskid_target => "unitedlinux-sp2",
                   }
                   ];

    $::pkgdefs{sp_disks}{SP2} = $sp2_ref;
}
#--------------------------------------------------------------------------------
{
    my $sp3_ref = [
                   {
                    num               => '1',
                    name              => "SuSE SLES 9 SP3 PPC",
                    diskid_searchargs => {
                                          file => 'media.1/products',
                                          key  => '/ SUSE-Linux-SP-ppc 3',
                    },
                    diskid_searchprog => \&Linux::linux_diskid_match_prog,
                    diskid_target => "unitedlinux-sp3",
                   },
                   {
                    num               => '2',
                    name              => "SuSE SLES 9 SP3 PPC",
                    diskid_searchargs => {
                                          file => 'media.2/products',
                                          key  => '/ SUSE-Linux-SP-ppc 3',
                    },
                    diskid_searchprog => \&Linux::linux_diskid_match_prog,
                    diskid_target => "unitedlinux-sp3",
                   },
		   {
                    num               => '3',
                    name              => "SuSE SLES 9 SP3 PPC",
		    is_extracd        => '1',
		    diskid_searchargs => {
                                          file => 'media.2/products',
                                          key  => '/ SUSE-Linux-SP-ppc 3',
                    },
                    diskid_searchprog => \&Linux::linux_diskid_match_prog,
                    diskid_target => "unitedlinux-sp3",
                   }
                   ];

    $::pkgdefs{sp_disks}{SP3} = $sp3_ref;
}

#--------------------------------------------------------------------------------
{
    my $sp4_ref = [
                   {
                    num               => '1',
                    name              => "SuSE SLES 9 SP4 PPC",
                    diskid_searchargs => {
                                          file => 'media.1/products',
                                          key  => '/ SUSE-Linux-SP-ppc 4',
                    },
                    diskid_searchprog => \&Linux::linux_diskid_match_prog,
                    diskid_target => "unitedlinux-sp4",
                   },
                   {
                    num               => '2',
                    name              => "SuSE SLES 9 SP4 PPC",
                    diskid_searchargs => {
                                          file => 'media.2/products',
                                          key  => '/ SUSE-Linux-SP-ppc 4',
                    },
                    diskid_searchprog => \&Linux::linux_diskid_match_prog,
                    diskid_target => "unitedlinux-sp4",
                   },
		   {
                    num               => '3',
                    name              => "SuSE SLES 9 SP4 PPC",
		    diskid_searchargs => {
                                          file => 'media.3/products',
                                          key  => '/ SUSE-Linux-SP-ppc 4',
                    },
                    diskid_searchprog => \&Linux::linux_diskid_match_prog,
                    diskid_target => "unitedlinux-sp4",
                   },
		   {
                    num               => '4',
                    name              => "SuSE SLES 9 SP4 PPC",
		    diskid_searchargs => {
                                          file => 'media.4/products',
                                          key  => '/ SUSE-Linux-SP-ppc 4',
                    },
                    diskid_searchprog => \&Linux::linux_diskid_match_prog,
                    diskid_target => "unitedlinux-sp4",
                   }
                   ];

    $::pkgdefs{sp_disks}{SP4} = $sp4_ref;
}
#--------------------------------------------------------------------------------

=head3	csm_bin_copy_tftpboot	

	 CSM binaries copied to /tftpboot directory

        Notes:

	Overloads values in Linux.pm

=cut

#--------------------------------------------------------------------------------
{
	my %cbct_ref;

	# defaults
	$cbct_ref{$::csm_version} = [];

	# exceptions
	# none

	$::pkgdefs{csm_bin_copy_tftpboot} = $cbct_ref{$::csm_version};
}

#--------------------------------------------------------------------------------

=head3	os_prereqs - Operating System pre-requisites

        Notes:
            Packages of the OS that needed to install CSM. There are three classes:
            for CSM installed on MS, for CSM installed on IS and for CSM installed
            on MN. These packages will always get copied, but will only be installed
             in corresponding conditions. 

            The stepes to add a operating system pre-requisites:
            1. Create a Rpm object of the rpm package, such as:
                my $kernel_pkg = new Rpm('kernel', '2.8');
            2. Add this Rpm object to the corresponding RpmList object:
                $ospr_ref{$_server_} = new RpmList(
                        'Management Server Operating System Prerequisites Packages',
                        $perl_pkg,
                        $ksh_pkg,
                        .....
                        $kernel_pkg
                        );
            You must ensure the rpm package be added consisting in the 
            distribution's CD.

=cut

#--------------------------------------------------------------------------------
{
    my $svlLevel = $::ATTRS{"InstallServiceLevel"};
    if ($svlLevel eq "")
    {
        my $disable_warning_msg = 1;
        # disable waring msg from subroutine get_ServiceLevel 
        $svlLevel = NodeUtils->get_ServiceLevel($disable_warning_msg);
    }

    my %ospr_ref;
    my $perl_pkg = new Rpm( 'perl','5');
    my $pdksh_pkg = new KshRpm( 'pdksh');
    my $nfs_utils_pkg = new Rpm( 'nfs-utils');
    my $rdist_pkg = new Rpm( 'rdist','6.1.5');
    my $tcl_pkg = new Rpm( 'tcl','8');
    my $tk_pkg = new Rpm( 'tk','8');
    my $expect_pkg = new Rpm( 'expect','5.40');
    my $freetype2_pkg = new Rpm( 'freetype2');
    my $termcap_pkg = new Rpm( 'termcap');
    my $expat_pkg = new Rpm( 'expat');
    my $bootsplash_theme_pkg = new Rpm( 'bootsplash-theme-SuSE-SLES','3');
    my $bootsplash_pkg = new Rpm( 'bootsplash','3');
    my $mtools_pkg = new Rpm( 'mtools','3');
    my $perl_xml_parse_pkg = new Rpm( 'perl-XML-Parser');
    my $perl_xml_dom_pkg = new Rpm( 'perl-XML-DOM');
    my $perl_html_target_pkg = new Rpm( 'perl-HTML-Tagset');
    my $perl_html_parse_pkg = new Rpm( 'perl-HTML-Parser');
    my $perl_uri_pkg = new Rpm( 'perl-URI');
    my $perl_libwww_perl_pkg = new Rpm( 'perl-libwww-perl');
    my $perl_xml_regexp_pkg = new Rpm( 'perl-XML-RegExp');
    my $syslinux_pkg = new Rpm( 'syslinux', '2');
    my $rsh_server_pkg = new Rpm( 'rsh-server');
    my $dhcp_pkg = new Rpm( 'dhcp', '3');
    my $dhcp_server_pkg = new Rpm( 'dhcp-server');
    my $rsync_pkg = new Rpm( 'rsync');
    my $xinetd_pkg = new Rpm( 'xinetd');
    my $ppc64_utils_pkg = new Rpm('ppc64-utils', '0.9');
    my $librtas_pkg = new Rpm('librtas');
    my $snmp_pkg = new Rpm('net-snmp');
	my $perl_termreadykey_pkg = new Rpm( 'perl-TermReadKey');
	my $python_pkg = new Rpm('python');
	my $rpm_python_pkg = new Rpm('rpm-python');

    $ospr_ref{$_server_} = new RpmList(
        'Management Server Operating System Prerequisites Packages',
        $perl_pkg,
        $pdksh_pkg,
        $nfs_utils_pkg,
        $rdist_pkg,
        $tcl_pkg,
        $tk_pkg,
        $expect_pkg,
        $freetype2_pkg,
        $perl_xml_parse_pkg,
        $perl_html_target_pkg,
        $perl_html_parse_pkg,
        $perl_uri_pkg,
        $perl_libwww_perl_pkg,
        $perl_xml_regexp_pkg,
        $rsync_pkg,
        $xinetd_pkg
    );

    $ospr_ref{$_iserver_} = new RpmList(
        'Install Server Operating System Prerequisites Packages',
        $nfs_utils_pkg,
        $termcap_pkg,
        $expat_pkg,
        $perl_xml_dom_pkg,
        $perl_html_target_pkg,
        $perl_html_parse_pkg,
        $perl_uri_pkg,
        $perl_libwww_perl_pkg,
        $perl_xml_regexp_pkg,
        $dhcp_pkg,
        $dhcp_server_pkg,
        $xinetd_pkg,
        $snmp_pkg,
		$perl_termreadykey_pkg,
		new TftpRpm('tftp'),
		$python_pkg,
		$rpm_python_pkg
    );

    $ospr_ref{$_node_} = new RpmList(
        'Managed Node Operating System Prerequisites Packages',
        $perl_pkg,
        $nfs_utils_pkg,
        $pdksh_pkg,
        $dhcp_pkg,
        $dhcp_server_pkg,
        $rdist_pkg,
        $tcl_pkg,
        $tk_pkg,
        $expect_pkg,
        $freetype2_pkg,
	$rsync_pkg,
        $rsh_server_pkg,
	$ppc64_utils_pkg
    );

    if ($svlLevel eq 'SP3' || $svlLevel eq 'SP4')
    {
	$ospr_ref{$_node_}->addRpm( $librtas_pkg );
    }

    $ospr_ref{$_server_}->setContainedInCds(1);
    $ospr_ref{$_iserver_}->setContainedInCds(1);
    $ospr_ref{$_node_}->setContainedInCds(1);

    $::pkgdefs{'pkgs'}{$_server_}{$::OS_PREREQ_PKGS} = $ospr_ref{$_server_};
    $::pkgdefs{'pkgs'}{$_iserver_}{$::OS_PREREQ_PKGS} = $ospr_ref{$_iserver_};
    $::pkgdefs{'pkgs'}{$_node_}{$::OS_PREREQ_PKGS} = $ospr_ref{$_node_};

}

#-------------------------------------------------------------------------------

=head3	apache_packages

        Notes:  List of packages that comprise the Apache http server.
                These packages will always get copied, but will only be 
                installed if SetupNetworkInstallProtocol=1.

=cut

#-------------------------------------------------------------------------------
{
	my $apache_ref = new RpmList(
        'Install Server HTTP Server Packages',
	    new Rpm( 'libapr0'),
	    new Rpm( 'apache2', '2'),
	    new Rpm( 'apache2-worker')
	);
    $apache_ref->setContainedInCds(1);

	$::pkgdefs{'pkgs'}{$_iserver_}{20} = $apache_ref;
}

#--------------------------------------------------------------------------------

=head3	logfiles	

	CSM Log files ( used while uninstalling)

        Notes:

	Overloads values in Linux.pm

=cut

#--------------------------------------------------------------------------------
{
	my %lf_ref;

	$lf_ref{$_server_} = [
						  '/var/log/csm/csmsetupsis.log*',
						  '/var/log/csm/installnode.log*',
						  '/var/log/csm/updatenode.log*',
						  '/var/log/csm/installms.log*'
						 ];
	$lf_ref{$_node_} = ['/var/log/csm/install.log*', '/var/opt/csm/cfmlocal*'];

	$::pkgdefs{logfiles} = $lf_ref{$::mgmt_type};
}


#--------------------------------------------------------------------------------

=head3	Misc. global variables

	should be moved elsewhere...	

	definately move somewhere else!  - maybe the registry

        Notes:

=cut

#--------------------------------------------------------------------------------
{

	%::rpm_pkg_flag = ();
	$::rpm_pkg_flag{openCIMOM} = " --ignoreos";

	#default kernel path name based on SUSE_TOP
	#    $::kernel_path_name =
	#      "sles8-ppc64/suse/ppc/kernel-ppc64-2.4.19-108.ppc.rpm";

}

#--------------------------------------------------------------------------------

=head3  install_kernel_parameter

        Notes:  For some specific machines, installing some specific service 
            levels need adding some specific kernel parameters into the PXE config
            file. This parameter of %::pkgdefs be used for this purpose.

            The last three indices be used to specify for what machine and what
            sevice level you want to insert a string into the PXE config file.
            Their means is:

$::pkgdefs{'install_kernel_parameter'}{'8850'}{'all_models'}{'GA'} = "barrier=off";
                                         ^          ^         ^             ^
                                         |          |         |             |
                                        (1)        (2)       (3)           (4)
            (1) 'HWType' of the nodes, such as '8850'. 'all_types' means for all 
                hardware types.
            (2) 'HWModel' of the nodes, such as '61x'. 'all_models' means for all
                hardware models.
            (3) InstallServiceLevel of the nodes, such as 'GA' 'SP3'.'all_svclevels'
                means for all sevice levels.
            (4) The string will be inserted into pxe file

            For example, you want to install SLES 9 GA on a new machine, but the
            usb driver has some problems, and you want to disable usb device in the
            installation. The machine's HWType is '7283', then you could add a new
            one like this (suppose for all models of this machine):

$::pkgdefs{'install_kernel_parameter'}{'7283'}{'all_models'}{'GA'} = "nousb";

=cut

#--------------------------------------------------------------------------------
{
    # Append kernel parameters "barrier=off" for SLES9 GA nodes
    $::pkgdefs{'install_kernel_parameter'}{'all_types'}{'all_models'}{'GA'} = 'barrier=off';
}
#--------------------------------------------------------------------------------

=head3 ramdisk_size

        Notes: the ramdisk size

=cut

#---------------------------------------------------------------------------------
{
        $::pkgdefs{'ramdisk_size'} = 16384;
}
#-------------------------------------------------------------------------------

=head3	createrepo_packages

        Notes:  List of packages that comprise the createrepo utility.
				This utility will generate a common metadata repository 
				from a directory of rpm packages.
                These packages will always get copied, but will only be 
                installed on install server or node if InstallMethod = warewulf 
				or yum-upgrade.

=cut

#-------------------------------------------------------------------------------
{
	my $createrepo_ref = new RpmList(
        'Install Server createrepo Packages',
	    new Rpm( 'libxml2-python'),
	    new Rpm( 'createrepo')
	);

	$createrepo_ref->setContainedInCds(0);
 	$createrepo_ref->setSearchingStyle('OPTIONAL');
	$createrepo_ref->setUpdatingStyle('UPDATE_OR_INSTALL', 'GROUPED');
    $createrepo_ref->setDestDir('#BASE#/#OS#/#DISTRIBUTOR#/#VERSION#/#ARCH#/csm_addon');
	$::pkgdefs{'pkgs'}{$_iserver_}{$::CREATEREPO_PKGS} = $createrepo_ref;
	
}
#-------------------------------------------------------------------------------

=head3	yum_packages

        Notes:  List of packages that comprise the YUM utility.
                These packages will always get copied, but will only be 
                installed on install server or node if InstallMethod = warewulf 
				or yum-upgrade.

=cut

#-------------------------------------------------------------------------------
{
	my $yum_ref = new RpmList(
        'Install Server YUM Packages',
	    new NoDepsRpm( 'sqlite'),
		new NoDepsRpm( 'python-sqlite'),
		new Rpm( 'urlgrabber'),
		new NoDepsRpm( 'python-elementtree'),
	    new NoDepsScriptsRpm( 'yum')
	);

	$yum_ref->setContainedInCds(0);
 	$yum_ref->setSearchingStyle('OPTIONAL');
	$yum_ref->setUpdatingStyle('UPDATE_OR_INSTALL', 'GROUPED');
    $yum_ref->setDestDir('#BASE#/#OS#/#DISTRIBUTOR#/#VERSION#/#ARCH#/csm_addon');
	$::pkgdefs{'pkgs'}{$_iserver_}{$::YUM_PKGS} = $yum_ref;
}

#-------------------------------------------------------------------------------

=head3	warewulf_packages

        Notes:  List of packages that comprise the Warewulf utility.
                These packages will always get copied, but will only be 
                installed on install server  if InstallMethod = warewulf. 

=cut

#-------------------------------------------------------------------------------
{
	my $warewulf_ref = new RpmList(
        'Install Server Warewulf Packages',
	    new NoScriptsRpm( 'MAKEDEV'),
		new Rpm( 'perl-Term-Screen'),
		new Rpm( 'perl-Unix-Syslog'),
		new Rpm( 'warewulf-tools'),
	    new NoDepsScriptsRpm( 'warewulf')
	);

	$warewulf_ref->setContainedInCds(0);
 	$warewulf_ref->setSearchingStyle('OPTIONAL');
	$warewulf_ref->setUpdatingStyle('UPDATE_OR_INSTALL', 'GROUPED');
    $warewulf_ref->setDestDir('#BASE#/#OS#/#DISTRIBUTOR#/#VERSION#/#ARCH#/csm_addon');
	$::pkgdefs{'pkgs'}{$_iserver_}{$::WAREWULF_PKGS} = $warewulf_ref;
}

#-------------------------------------------------------------------------------

=head3	warewulf_client_packages

        Notes:  List of packages that comprise the Warewulf utility.
                These packages will always get copied, but will not 
                be installed on node. If install method is warewulf,
				warewulf-wulfd should be installed in 
				install server's VNFS.
=cut

#-------------------------------------------------------------------------------
{
	my $warewulf_ref = new RpmList(
        'Managed Node Warewulf Client Packages',
		new Rpm( 'warewulf-wulfd')
	);

	$warewulf_ref->setContainedInCds(0);
 	$warewulf_ref->setSearchingStyle('OPTIONAL');
	$warewulf_ref->setUpdatingStyle('UPDATE_ONLY', 'GROUPED');
    $warewulf_ref->setDestDir('#BASE#/#OS#/#DISTRIBUTOR#/#VERSION#/#ARCH#/csm_addon');
	$::pkgdefs{'pkgs'}{$_node_}{$::WAREWULF_PKGS} = $warewulf_ref;
}

1;    # end
