#!/usr/bin/perl
# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2003,2008 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
#"@(#)37   1.34   src/csm/krb5/cmds/InstallKRB5Utils.pm.perl, setup, csm_rgar2h, rgar2hs001a 7/5/05 22:20:20"

#------------------------------------------------------------------------------

=head1    InstallKRB5Utils

=head2    Package Description

This program module file supplies a set of utility programs for setting up and 
enabling Kerberos Remote Commands for CSM.

If adding to this file, please take a moment to ensure that:

	1.  Your contrib has a readable pod header describing the purpose and use
			 your contrib.

	2.  Your contrib is under the correct heading and is in alphabetical order under that heading. 

	3. You test your contribution by running from the command line:

		pod2html  --verbose --title=NodeUtils NodeUtils.pm.perl --outfile=NodeUls.html and examining the ./NodeUtils.html file in a browser.




=cut

#------------------------------------------------------------------------------

package InstallKRB5Utils;

use strict;
use File::Basename;
use File::Path;    # Provides mkpath()

#
# Subroutines
#

#$KRB5::MSGMAPPATH = '/opt/csm/msgmaps';
my $csmroot = $ENV{'CSM_ROOT'} ? $ENV{'CSM_ROOT'} : '/opt/csm';
if (defined $::MSGMAPPATH)
{
	$KRB5::MSGMAPPATH = $ENV{'CSM_ROOT'} ? "$csmroot/msgmaps" : $::MSGMAPPATH;
}
else
{
	$KRB5::MSGMAPPATH = "$csmroot/msgmaps";
}

#------------------------------------------------------------------------------

=head3   setupKRB5server   			    	 

  This routine will setup a KRB5 AIX server using the NAS
  function supplied by AIX.   This will only run on an
  AIX Management Server
  Input (None) 

=cut

#------------------------------------------------------------------------------
#  If /etc/krb5/krb5.conf exists then there is no need to setup the server
#     exit with message
#  else
#   if AIX
#      if NAS KRB5 installed  (config.krb5) exists
#         prompt user for admin id
#         if cannot figure out the domain name
#           prompt user for domain name
#           realm name is built from domain name (uppercase)
#         run config.krb5 -S -a admin id -d domain name -r realm name
#      else
#         Message need to install NAS KRB5
#    else
#       Message only runs on AIX
#    Copy the krb5.conf file in the /csminstall/csm/krb5 directory
###########################################################
sub setupKRB5server
{
	my $pname = "setupKRB5server";
	my $rc    = $::OK;
	my $rc2;
	my $NASCONFILE = "/etc/krb5/krb5.conf";
	my $KRB5CONF   = "/usr/krb5/sbin/config.krb5";
	my $time;
	my $mkservercmd;
	my $nodename;
	my $cmd;
	my ($ms_hostname, $ms_ipaddr);
	my $ms_realm   = "";
	my $ms_domain  = "";
	my $ms_adminid = "";
	$time = scalar localtime();
	chop($nodename = `/bin/hostname`);    # get the local hostname

	MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
								 'csmKRB5p_msg', 'LI', 'IMsgStartup', $pname,
								 $time);    # start message

	# check for AIX

	if (NodeUtils->isAIX())
	{

		# check to see if the KRB5 server is aleady installed, /etc/krb5/krb5.conf exists
		if (!-e $NASCONFILE)
		{    # if it does not exist then proceed to setup server

			if (-e $KRB5CONF)
			{    # check to see if NAS KRB5 is installed
				    #
				    # prompt the user for the admin id
				    #
				while ($ms_adminid eq "")
				{    # Prompt for admin id
					MessageUtils->messageFromCat('csmKRB5p.cat',
						  $KRB5::MSGMAPPATH, 'csmKRB5p_msg', 'lI',
						  'IMsgKRB5EnterAdminName'); #specify the principal name
					chop($ms_adminid = <STDIN>);
					if ($ms_adminid eq "")
					{
						MessageUtils->messageFromCat('csmKRB5p.cat',
										$KRB5::MSGMAPPATH, 'csmKRB5p_msg', 'lI',
										'IMsgKRB5NULLName');    # NULL invalid
					}
				}

				# Form the realm and domain names
				while ($ms_domain eq "")
				{    # NULL realm and domain, must prompt
					MessageUtils->messageFromCat('csmKRB5p.cat',
									 $KRB5::MSGMAPPATH, 'csmKRB5p_msg', 'lI',
									 'IMsgKRB5EnterDomain'); # Enter Domain Name
					chop($ms_domain = <STDIN>);
					if ($ms_domain eq "")
					{
						MessageUtils->messageFromCat('csmKRB5p.cat',
										$KRB5::MSGMAPPATH, 'csmKRB5p_msg', 'lI',
										'IMsgKRB5NULLName');    #Null invalid
					}
				}
				$ms_realm = uc($ms_domain); # realm name is upper case of domain
				$mkservercmd =
				  "$KRB5CONF -S -a $ms_adminid -d $ms_domain -r $ms_realm ";
				MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
							   'csmKRB5p_msg', 'I', 'IMsgKRB5CMD', $mkservercmd)
				  ;                         #Record command run

				####################################
				#  Now do the work, make the server
				####################################

				system "$mkservercmd";      # run the setup server command
				if ($? > 0)
				{
					$rc = $? / 256;
					MessageUtils->messageFromCat('csmKRB5p.cat',
						 $KRB5::MSGMAPPATH, 'csmKRB5p_msg', 'E', 'EMsgNASError',
						 $KRB5CONF, $rc);    # Record error return
					$rc = $::NOK;
				}

			}
			else
			{                                #  NAS executable missing
				MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
							   'csmKRB5p_msg', 'E', 'EMsgNASMissing', $KRB5CONF)
				  ;                          # Record error missing config.kr5
				$rc = $::NOK;

			}

		}
		else
		{

			InstallKRB5Utils->copyKRB5cfg; # go ahead and copy it in the install
			                               # directory
			MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
						'csmKRB5p_msg', 'I', 'IMsgKRB5ConfigFileExists', $pname,
						$NASCONFILE);      # /etc/krb5/krb5.conf exists
			$rc = $::OK;  # This just a warning, must have run the script twice.
		}

		#
		# and copy /etc/krb5.conf into it for the nodes.
		#
		InstallKRB5Utils->copyKRB5cfg;

	}
	else
	{                     # not AIX
		MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
									 'csmKRB5p_msg', 'E', 'EMsgNotAIXError',
									 $pname);    #  Not AIX error
		$rc = $::NOK;
	}

	$time = scalar localtime();
	MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
								 'csmKRB5p_msg', 'LI', 'IMsgEnd', $pname, $time,
								 $rc);           #end message
	return $rc;
}
##################  end of setupKRB5server#################

#------------------------------------------------------------------------------

=head3	 setupKRB5client


  This routine sets up a Kerberos V5 client  			    

  input \@attrvalues - reference to list of values of the SetupKRB5 attribute

=cut

#------------------------------------------------------------------------------
# If values indicate KRB5 client setup
#  If Linux
#    call processLinuxKRB5file
#  If AIX
#    call processAIXKRB5file
#    (csm principal generated)
#   Call popk5login to update the .k5login file with the
#      principal name
###########################################################
sub setupKRB5client
{
	my ($class, $attrvalue_list) = @_;
	my @attrvaluelist = @$attrvalue_list;
	my $pname         = "setupKRB5client";
	my $rc            = $::OK;
	my $time;
	my $n;
	my $cmd;
	my $setuprcmd         = 0;
	my $setupclient       = 0;
	my $CONFILE           = "/etc/krb5.conf";
	my $CONFILESAVE       = "/etc/krb5.conf.save";
	my $KRB5DIR           = "/etc/krb5";
	my $NASCONFILE        = "/etc/krb5/krb5.conf";
	my $NASCONFILESAVE    = "/etc/krb5/krb5.conf.save";
	my $CONFILEFROMSERVER = "$::CSMCLIENTMNTDIR/csm/krb5.conf";

	$time = scalar localtime();
	MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
								 'csmKRB5p_msg', 'LI', 'IMsgStartup', $pname,
								 $time);    # start message

	# determine setup remote command and setup client settings

	foreach my $n (@attrvaluelist)
	{
		if (   ($n == 4)
			|| ($n == 5)
			|| ($n == 6)
			|| ($n == 7)
			|| ($n == 12)
			|| ($n == 13)
			|| ($n == 14)
			|| ($n == 15))
		{
			$setuprcmd = 1;
		}
		if (   ($n == 2)
			|| ($n == 3)
			|| ($n == 6)
			|| ($n == 7)
			|| ($n == 10)
			|| ($n == 11)
			|| ($n == 14)
			|| ($n == 15))
		{
			$setupclient = 1;
		}
	}

	# check to see if any work to do
	#
	if (($setuprcmd == 0) && ($setupclient == 0))
	{
		MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
								   'csmKRB5p_msg', 'I', 'IMsgKRB5NoClientSetup',
								   $pname);    # No client setup requested
	}

	#
	# Check Do we setup the clients?
	#
	if ($setupclient)
	{                                          # if setup KV5 client
		    # copy the /etc/krb5.conf file from /mnt/csminstall/..
		MessageUtils->messageFromCat(
									 'csmKRB5p.cat',        $KRB5::MSGMAPPATH,
									 'csmKRB5p_msg',        'I',
									 'IMsgKRB5SetupClient', $pname
									);    # setup client message

		# if Linux and the /etc/krb5.conf does not exist then update it
		umask(0133);                      # ensure file perms are 644
		if (NodeUtils->isLinux())
		{
			InstallKRB5Utils->processLinuxKRB5file;

		}
		else
		{                                 # node is AIX
			InstallKRB5Utils->processAIXKRB5file;    # check and copy

		}
	}    # end setupclient
	     #
	     # Check Do we setup the remote commands
	     #
	if ($setuprcmd)
	{    # if a CSM principal was generated
		MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
								 'csmKRB5p_msg', 'I', 'IMsgKRB5SetupRemoteCmds',
								 $pname);    # setup remote command message
		$rc = `$::CSMCSMBIN/popk5login`;     # populate the .k5login with it
		if ($? != 0)
		{                                    # error updating .k5login
			$rc = ($? < 256 ? $? : ($? / 256));
			MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
							   'csmKRB5p_msg', 'E', 'EMsgUpdtk5loginError', $rc)
			  ;                              # popk5login error
			$rc = $::NOK;
		}
		else
		{
			MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
							  'csmKRB5p_msg', 'I', 'IMsgk5loginUpdated', $pname)
			  ;                              # k5login file updated
			$rc = $::OK;
		}

	}    # end setuprcmd

	$time = scalar localtime();
	MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
								 'csmKRB5p_msg', 'LI', 'IMsgEnd', $pname, $time,
								 $rc);    #end message
	return $rc;
}
##################  end of setupKRB5client#################

#------------------------------------------------------------------------------

=head3	 setupKRB5rcmdprincs 


  Sets up a Kerberos V5 remote command principal

  input \@attrvalueslist - value of the SetupKRB5 attribute

  input \@node_list - reference to list of managed nodes, null indicates

=cut

#------------------------------------------------------------------------------

#                    all managed nodes
# Check attrvalues list to see if we are going to create CSM principal and/or
#   host principals, if not get out
# Determine Management Server name
# if add CSM principal requested or add Host principal requested
#    Build a list of principals to create in the addprincipals.tmp file
#    if Heimdal Kerberos not installed then
#      call add_KRB5principals
#    else tell then they must manually create the principals and keys
###########################################################
sub setupKRB5rcmdprincs
{
	my ($class, $attrvalue_list, $node_list) = @_;
	my @attrvaluelist = @$attrvalue_list;
	my @nodelist      = @$node_list;
	my $pname         = "setupKRB5rcmdprincs";
	my $rc            = $::OK;
	my $time;
	my $n;
	my $n1;
	my $cmd;
	my $createcsmprincipal;
	my $createhostprincipal;
	my $principalname     = "";
	my $CSMKEYTAB         = "/var/ct/IW/sec/krb5/csm/k5keytabs/ctsrcmdp";
	my $KRB5DIR           = "/var/ct/IW/sec/krb5";
	my $SECDIR            = "/var/ct/IW/sec";
	my $KRB5CSMDIR        = "/var/ct/IW/sec/krb5/csm";
	my $KEYTABDIR         = "/var/ct/IW/sec/krb5/csm/k5keytabs";
	my $PRINCIPALNAMEFILE =
	  "/var/ct/IW/sec/krb5/csm/k5keytabs/CSMprincipalname";
	my $tmpfile    = "/var/ct/IW/sec/krb5/csm/k5keytabs/addprincipals.tmp";
	my $nodekeytab = "";
	my $index      = 1;
	my $principalcreated = 1;
	my $csmkeytabfile    = "";
	my $csmkeytab        = "";
	my $keytab           = "keytab";
	my $LS_INFO          = "";
	my $msname           = "";
	my $msname1          = "";
	my $msip             = "";
	my $localhost;
	my $heimdal;
	my $DUMMYKEY;
	my $CSMPRINCIPALFILE;
	my $ADDPRINC = "add_KRB5principal";
	my (@DestNode, @lsnode_info, @empty_array);

	#
	# Start message
	#
	$time    = scalar localtime();
	$heimdal = 0;
	MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
								 'csmKRB5p_msg', 'LI', 'IMsgStartup', $pname,
								 $time);    # start message
	    #
	    # determine create csm principal and create host principal settings
	    #
	    # Determine the Management Server node id
	$msname1 = NetworkUtils->getRSCThostname;
	$msname  = lc($msname1);                    # force to lower case
	                                            #
	                                            #

	foreach my $n (@attrvaluelist)
	{
		if (   ($n == 4)
			|| ($n == 5)
			|| ($n == 6)
			|| ($n == 7)
			|| ($n == 12)
			|| ($n == 13)
			|| ($n == 14)
			|| ($n == 15))
		{
			$createcsmprincipal = 1;
		}
		if (   ($n == 8)
			|| ($n == 9)
			|| ($n == 10)
			|| ($n == 11)
			|| ($n == 12)
			|| ($n == 13)
			|| ($n == 14)
			|| ($n == 15))
		{
			$createhostprincipal = 1;
		}
	}

	# if there is work to do
	#   Get the CSM principal name
	#   if createcsmprincipal
	#      Call add_KRB5principals and create the CSM principal
	#   if createhostprincipal
	#      for each node
	#        Call add_KRB5principals and create the host principal
	#

	if ($createcsmprincipal == 0 && $createhostprincipal == 0)
	{    # nothing to do
		$rc = $::OK;
		MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
								'csmKRB5p_msg', 'I', 'IMsgKRB5NoPrincipalSetup',
								$pname);    #No principals requested
		$time = scalar localtime();
		MessageUtils->messageFromCat(
									 'csmKRB5p.cat', $KRB5::MSGMAPPATH,
									 'csmKRB5p_msg', 'LI',
									 'IMsgEnd',      $pname,
									 $time,          $rc
									);      #end message
		return $rc;
	}

	#
	# setup the required directories to store keytabs
	#
	#
	if (!(-e $SECDIR))
	{    # if the sec directory  does not exist
		`$::MKDIR  -m 600 -p $SECDIR >/dev/null 2>&1`;
		if ($? != 0)
		{    # if error
			$rc = ($? < 256 ? $? : ($? / 256));
			MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
							'csmKRB5p_msg', 'E', 'EMsgmkdirError', $SECDIR, $rc)
			  ;    # Error from mkdir
			$time = scalar localtime();
			MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
							'csmKRB5p_msg', 'LI', 'IMsgEnd', $pname, $time, $rc)
			  ;    #end message
			return $rc;
		}
	}
	if (!(-e $KRB5DIR))
	{              # if the directory  does not exist
		`$::MKDIR  -m 600 -p $KRB5DIR >/dev/null 2>&1`;
		if ($? != 0)
		{          # if error
			$rc = ($? < 256 ? $? : ($? / 256));
			MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
						   'csmKRB5p_msg', 'E', 'EMsgmkdirError', $KRB5DIR, $rc)
			  ;    # Error from mkdir
			$time = scalar localtime();
			MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
							'csmKRB5p_msg', 'LI', 'IMsgEnd', $pname, $time, $rc)
			  ;    #end message
			return $rc;
		}
	}
	if (!(-e $KRB5CSMDIR))
	{              # if the directory  does not exist
		`$::MKDIR  -m 600 -p $KRB5CSMDIR >/dev/null 2>&1`;
		if ($? != 0)
		{          # if error
			$rc = ($? < 256 ? $? : ($? / 256));
			MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
						'csmKRB5p_msg', 'E', 'EMsgmkdirError', $KRB5CSMDIR, $rc)
			  ;    # Error from mkdir
			$time = scalar localtime();
			MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
							'csmKRB5p_msg', 'LI', 'IMsgEnd', $pname, $time, $rc)
			  ;    #end message
			return $rc;
		}
	}
	if (!(-e $KEYTABDIR))
	{              # if the directory  does not exist
		`$::MKDIR -m 755 -p $KEYTABDIR >/dev/null 2>&1`;
		if ($? != 0)
		{          # if error
			$rc = ($? < 256 ? $? : ($? / 256));
			MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
						 'csmKRB5p_msg', 'E', 'EMsgmkdirError', $KEYTABDIR, $rc)
			  ;    # Error from mkdir
			$time = scalar localtime();
			MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
							'csmKRB5p_msg', 'LI', 'IMsgEnd', $pname, $time, $rc)
			  ;    #end message
			return $rc;
		}
	}

	# open the temp file to build for add_principals routine
	# /var/ct/IW/sec/krb5/csm/k5keytabs/addprincipals.tmp
	#
	if (open(PRINCIPALLIST, ">$tmpfile") == 0)
	{              # open the file
		MessageUtils->messageFromCat(
									 'csmKRB5p.cat',       $KRB5::MSGMAPPATH,
									 'csmKRB5p_msg',       'E',
									 'EMsgKRB5OpenFailed', $tmpfile
									);
		$rc = $::NOK;
		return $rc;

	}
	$cmd = "$::CHMOD 600 $tmpfile";
	$rc  = system("$cmd");
	if ($rc >> 8)
	{
		MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
									 'csmKRB5p_msg', 'E', 'EMsgCHMOD', $rc)
		  ;    # chmod error
		$rc = $::OK;
	}

	#
	# if CSM principal key already exist, then ignore request to generate a new
	# CSM principal
	# else
	#  create the CSM principal  and keytab
	#  Create the principal name  ctsrcmdp.<Management Server Hostname>
	#  Store it in the var/ct/IW/sec/krb5/csm/CSMprincipalname file.
	#  Also put the name in the addprincipals.tmp file for add_principal
	#
	if ($createcsmprincipal == 1)
	{    # if requested

		if ((-e "$CSMKEYTAB.$msname.keytab")
			&& !(-z "$CSMKEYTAB.$msname.keytab"))
		{    # if exist and not empty don't create principal
			$createcsmprincipal = 0;    # don't need to
			MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
							 'csmKRB5p_msg', 'I', 'IMsgPrincipalExists', $pname,
							 "ctsrcmdp.$msname");    # principal already exists
		}
	}

	if ($createcsmprincipal == 1)
	{    # create a CSM remote command principal requested
		$principalname = "ctsrcmdp.$msname";
		if (open(CSMPRINCIPALFILE, ">$PRINCIPALNAMEFILE") != 0)
		{    # open the file
			print CSMPRINCIPALFILE $principalname;
			print CSMPRINCIPALFILE "\n";
			close(CSMPRINCIPALFILE);
			$cmd = "$::CHMOD 600 $PRINCIPALNAMEFILE";
			$rc  = system("$cmd");
			if ($rc >> 8)
			{
				MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
						   'csmKRB5p_msg', 'E', 'EMsgCHMOD', $rc); # chmod error
				$rc = $::OK;
			}

			# add the CSM principal and keytab name to file for add_KRB5principals
			$csmkeytab =
			  "$KEYTABDIR/$principalname.keytab";    # csm keytab file name
			print PRINCIPALLIST $principalname;
			print PRINCIPALLIST "\n";
			print PRINCIPALLIST $csmkeytab;
			print PRINCIPALLIST "\n";
		}
		else
		{
			MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
				 'csmKRB5p_msg', 'E', 'EMsgKRB5OpenFailed', $PRINCIPALNAMEFILE);
			$rc = $::NOK;
			return $rc;

		}

	}    # end createcsmprincipal

	#
	# Now build list of all the principals for the managed nodes
	#

	if ($createhostprincipal == 1)
	{    # create the host remote command principal
		if (!@nodelist)
		{    # NULL indicates do all managed nodes
			    # get list of all  nodes
			my $ref_lsnode_info = NodeUtils->listNodeAttrs([], "Hostname");
			my @lsnode_info = @$ref_lsnode_info;
			foreach my $hostname (@lsnode_info)
			{
				chomp $hostname;
				push @nodelist, $hostname;
			}
		}    # end null node list
		     #
		     #  if it does not already exist
		     #    add the principal to the file for add_KRB5principals
		     #
		     #  Determine managment server name
		my $msnode = NetworkUtils->determineMS(\@nodelist);
		foreach my $n1 (@nodelist)
		{    # for each node create a principal
			$n = lc($n1);

			$principalname = "host/$n";    # construct the host principal name
			$nodekeytab = "$KEYTABDIR/$n.keytab";  # Create the keytab file name

			if (!(-e $nodekeytab) || (-z $nodekeytab))
			{                                      # if the key does not exist
				                                   # or zero length
				MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
						 'csmKRB5p_msg', 'I', 'IMsgKRB5CreateNodePrinc', $pname,
						 $n1);                     # add Node principal(s)
				print PRINCIPALLIST $principalname;
				print PRINCIPALLIST "\n";

				#
				# if the node is the Management Server then
				# add the key to the default krb5.keytab file
				#
				my $msnodelower = lc($msnode);
				if ($n eq $msnodelower)
				{                                  # put key in default keytable
					print PRINCIPALLIST "defaultkeytable";
					print PRINCIPALLIST "\n";
				}
				else
				{    # put keytab in host keytab file
					print PRINCIPALLIST $nodekeytab;
					print PRINCIPALLIST "\n";
				}

				# If create CSM principal was requested
				#  If MS then update
				#    call popk5login to update the .k5login file
				if ($createcsmprincipal == 1)
				{
					if ($n eq $msname)
					{    # if Management server is a managed node
						$rc =
						  `/opt/csm/csmbin/popk5login`
						  ;    #populate the .k5login with it
						if ($? != 0)
						{      # error updating .k5login
							$rc = ($? < 256 ? $? : ($? / 256));
							MessageUtils->messageFromCat('csmKRB5p.cat',
								$KRB5::MSGMAPPATH, 'csmKRB5p_msg', 'E',
								'EMsgUpdtk5loginError', $rc); # popk5login error
							$rc = $::NOK;
						}
						else
						{
							MessageUtils->messageFromCat('csmKRB5p.cat',
										 $KRB5::MSGMAPPATH, 'csmKRB5p_msg', 'I',
										 'IMsgk5loginUpdated', $pname)
							  ;    # k5login file updated
							$rc = $::OK;
						}
					}    # end if CSM principal create request
				}    # end if MS
			}    # end check exists
		}    # end foreach node
	}    # end create host principal

	if (fileno(PRINCIPALLIST))
	{
		close(PRINCIPALLIST);
	}

	# If not Linux with Heimdal installed
	#   call add_KRB5principals to do all the work
	#   create the principal and keys
	# Else
	#   Tell them must create principals and keys manually.
	if (!(-z $tmpfile))
	{    # if there are some principals to add
		if (NodeUtils->isLinux())
		{
			$cmd = "$::RPMCMD -qa | $::GREP  heimdal";
			$rc  = system("$cmd");
			if ($rc == 0)
			{
				MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
					 'csmKRB5p_msg', 'I', 'IMsgNonSupportedKRB5', $pname, $time)
				  ;    # non supported Heimdal
				$heimdal = 1;
			}
			$rc = $::OK;

		}
		if ($heimdal == 0)
		{
			`/opt/csm/csmbin/add_KRB5principals `
			  ;        #create the principals and keys
			if ($? != 0)
			{          # error creating principals
				$rc = ($? < 256 ? $? : ($? / 256));
				MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
							'csmKRB5p_msg', 'E', 'EMsgUnableToCreatePrincipal');
				MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
									 'csmKRB5p_msg', 'E', 'EMsgKRB5ChkaddKRB5');
				$rc = $::NOK;
			}
		}
	}
	else
	{
		MessageUtils->messageFromCat(
									 'csmKRB5p.cat',     $KRB5::MSGMAPPATH,
									 'csmKRB5p_msg',     'I',
									 'IMsgNoPrincipals', $pname
									);    # no principals to create
	}

	# End message
	#
	$time = scalar localtime();
	MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
								 'csmKRB5p_msg', 'LI', 'IMsgEnd', $pname, $time,
								 $rc);    #end message
	return $rc;
}

#
##################  end of setupKRB5rcmdprincs#################

#------------------------------------------------------------------------------

=head3   getKRB5tgt 

Checks for KRB5 enabled and gets KRB5 ticket-granting-ticket        

=cut

#------------------------------------------------------------------------------
#         Message need to install NAS KRB5
#    else
#       Message only runs on AIX
###########################################################
sub getKRB5tgt
{
	my $KRB5CCNAME;
	$KRB5CCNAME = "";
	if (($ENV{'KRB5CCNAME'}) eq "")
	{
		if ($< == 0)
		{    # I am root
			chop($KRB5CCNAME = `$::CSMCSMBIN/k5rcmdtgt`);
		}
	}

	return ($KRB5CCNAME);
}

#------------------------------------------------------------------------------

=head3   xferKRB5Keys        

  Initiates the KRB5 key transfer 

=cut

#------------------------------------------------------------------------------

###########################################################
sub xferKRB5keys
{
	my ($class, $node_list) = @_;
	my @nodes      = @$node_list;
	my $SENDKEYTAB = $::CSMCSMBIN . "/sendkeytab";
	my $rc         = 0;

	if (@nodes)
	{
		foreach my $node (@nodes)
		{
			my $cmd = "$SENDKEYTAB -n $node";
			$rc = `$cmd`;
			if ($? != 0)
			{    # error
				MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
						   'csmKRB5p_msg', 'E ', 'EMsgKRB5XFERKEYError', $node);
			}
		}
	}

	return ($rc);
}

#------------------------------------------------------------------------------

=head3   copyKRB5cfg  

  Copies the KRB5 config file to the install directory 

=cut

#------------------------------------------------------------------------------

###########################################################
sub copyKRB5cfg
{
	my $NASCONFILE  = "/etc/krb5/krb5.conf";
	my $KRB5CONFILE = "/etc/krb5.conf";
	my $CONFILE;
	my $rc  = 0;
	my $rc2 = 0;

	#
	# Create the /csminstall/csm directory if it doesn't exist
	# and copy /etc/krb5.conf into it for the nodes.
	#
	my $INSTALLDIR_CSM = "/csminstall/csm";
	if (!-d "$INSTALLDIR_CSM")
	{
		mkpath($INSTALLDIR_CSM, $::VERBOSE, 0755);
	}
	if (-e "$NASCONFILE")
	{
		$CONFILE = $NASCONFILE;
	}
	else
	{
		if (-e "$KRB5CONFILE")
		{
			$CONFILE = $KRB5CONFILE;
		}
	}
	if ($CONFILE)
	{    # found one
		my $NEWCONFILE = "$INSTALLDIR_CSM/krb5.conf";
		$rc2 = `/bin/cp  $CONFILE $NEWCONFILE >/dev/null`;
		if ($? != 0)
		{    # error updating /etc/krb5.conf
			$rc = ($? < 256 ? $? : ($? / 256));
			MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
					'csmKRB5p_msg', 'E', 'EMsgKRB5CopyConfigError', $NEWCONFILE)
			  ;    #  error on copy
			$rc = $::NOK;
		}
	}
	return ($rc);
}
##################  end of copyKRB5cfg#################

#------------------------------------------------------------------------------

=head3	processLinuxKRB5file 


  This routine  copies the krb5.conf file on Linux  			    

  input none 

=cut

#------------------------------------------------------------------------------
#    If the /etc/krb5.conf file does not exist then
#      copy /mnt/csminstall/csm/krb5/krb5.conf file to /etc  (0644)
#  else
#     diff the two files and if they are different then
#      copy the one on the node to krb5.conf.save
#      copy /mnt/csminstall/csm/krb5/krb5.conf file to /etc  (0644)
#      put out a warning that made backup of krb5.conf
#------------------------------------------------------------------------------
sub processLinuxKRB5file
{
	my $pname = "setupKRB5client";
	my $rc    = $::OK;
	my $time;
	my $n;
	my $cmd;
	my $setuprcmd         = 0;
	my $setupclient       = 0;
	my $CONFILE           = "/etc/krb5.conf";
	my $CONFILESAVE       = "/etc/krb5.conf.save";
	my $KRB5DIR           = "/etc/krb5";
	my $NASCONFILE        = "/etc/krb5/krb5.conf";
	my $NASCONFILESAVE    = "/etc/krb5/krb5.conf.save";
	my $CONFILEFROMSERVER = "$::CSMCLIENTMNTDIR/csm/krb5.conf";

	# make the /etc/krb5 directory if it does not exist
	if (!(-e $KRB5DIR))
	{    # if the sec directory  does not exist
		`$::MKDIR  -m 755 -p $KRB5DIR >/dev/null 2>&1`;
		if ($? != 0)
		{    # if error
			$rc = ($? < 256 ? $? : ($? / 256));
			MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
						   'csmKRB5p_msg', 'E', 'EMsgmkdirError', $KRB5DIR, $rc)
			  ;    # Error from mkdir
			$time = scalar localtime();
			MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
							'csmKRB5p_msg', 'LI', 'IMsgEnd', $pname, $time, $rc)
			  ;    #end message
			return $rc;
		}
	}

	if (!-e $CONFILE)
	{              # if /etc/krb5.conf it does not exist then proceed
		$rc = `/bin/cp $CONFILEFROMSERVER $CONFILE >/dev/null`;
		if ($? != 0)
		{          # error updating /etc/krb5.conf
			$rc = ($? < 256 ? $? : ($? / 256));
			MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
								 'csmKRB5p_msg', 'E', 'EMsgCopyKRB5ConfigError',
								 $CONFILEFROMSERVER, $CONFILE, $rc); # copy fail
			$rc = $::NOK;

		}
		else
		{    # copy successful
			MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
					'csmKRB5p_msg', 'I', 'IMsgKRB5CfgCreated', $pname, $CONFILE)
			  ;    # /etc/krb5.conf created
			$rc = $::OK;
		}

	}
	else
	{              #  it exists  on Linux
		           #  check to see if different than the one from the MS
		           #  if different copy node krb5.conf file to backup
		           #  copy MS krb5.conf file to node
		           #  warn the admin
		`/usr/bin/diff $CONFILEFROMSERVER $CONFILE `;
		if ($? != 0)
		{          # differences found
			       # make backup
			$rc = `/bin/cp $CONFILE $CONFILESAVE >/dev/null`;
			if ($? != 0)
			{      # error saving
				$rc = ($? < 256 ? $? : ($? / 256));
				MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
					   'csmKRB5p_msg', 'E', 'EMsgCopyKRB5ConfigError', $CONFILE,
					   $CONFILESAVE, $rc);
				$rc = $::NOK;
				return $rc;

			}
			else
			{      # tell the admin saving
				MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
					  'csmKRB5p_msg', 'I', 'IMsgMadeKRB5Save', $pname, $CONFILE,
					  $CONFILESAVE);    # copy fail

			}

			# copy MS to node
			$rc = `/bin/cp $CONFILEFROMSERVER $CONFILE >/dev/null`;
			if ($? != 0)
			{                           # error updating /etc/krb5.conf
				$rc = ($? < 256 ? $? : ($? / 256));
				MessageUtils->messageFromCat(
								  'csmKRB5p.cat',            $KRB5::MSGMAPPATH,
								  'csmKRB5p_msg',            'E',
								  'EMsgCopyKRB5ConfigError', $CONFILEFROMSERVER,
								  $CONFILE,                  $rc
											);    # copy fail
				$rc = $::NOK;
				return $rc;

			}
			else
			{    # tell copying the krb5.conf file to the node
				MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
							  'csmKRB5p_msg', 'I', 'IMsgKRB5CfgCreated', $pname,
							  $CONFILE);    # /etc/krb5.conf created
				$rc = $::OK;
			}
		}

	}    # end diff found

	return ($rc);
}
##################  end of processLinuxKRB5file#################

#------------------------------------------------------------------------------

=head3	processAIXKRB5file 


  This routine  copies the krb5.conf file on AIX  			    

  input none 

=cut

#------------------------------------------------------------------------------
#    If the /etc/krb5.conf and /etc/krb5/krb5.conf file does not exist then
#      copy /mnt/csminstall/csm/krb5/krb5.conf file to
#        /etc/krb5/krb5.conf (644) and link it to /etc/krb5.conf
#    If the /etc/krb5.conf and /etc/krb5/krb5.conf file both exist then
#     diff the two files and if they are different then
#      copy the one on the node to krb5.conf.save
#      copy /mnt/csminstall/csm/krb5/krb5.conf file to /etc/krb5/krb5.conf(0644)
#      put out a warning that made backup of krb5.conf
#    If the /etc/krb5.conf exists and /etc/krb5/krb5.conf file does not exist
#      copy /mnt/csminstall/csm/krb5/krb5.conf file to  /etc/krb5/krb5.conf
#      record existence of /etc/krb5
#    If the /etc/krb5.conf does not exist and /etc/krb5/krb5.conf file
#         does exist, record a warning message but do nothing.
# If values indicate KRB5 remote command setup
#------------------------------------------------------------------------------
sub processAIXKRB5file
{
	my $pname = "setupKRB5client";
	my $rc    = $::OK;
	my $time;
	my $n;
	my $cmd;
	my $setuprcmd         = 0;
	my $setupclient       = 0;
	my $CONFILE           = "/etc/krb5.conf";
	my $CONFILESAVE       = "/etc/krb5.conf.save";
	my $KRB5DIR           = "/etc/krb5";
	my $NASCONFILE        = "/etc/krb5/krb5.conf";
	my $NASCONFILESAVE    = "/etc/krb5/krb5.conf.save";
	my $CONFILEFROMSERVER = "$::CSMCLIENTMNTDIR/csm/krb5.conf";

	# make the /etc/krb5 directory if it does not exist
	if (!(-e $KRB5DIR))
	{    # if the sec directory  does not exist
		`$::MKDIR  -m 755 -p $KRB5DIR >/dev/null 2>&1`;
		if ($? != 0)
		{    # if error
			$rc = ($? < 256 ? $? : ($? / 256));
			MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
						   'csmKRB5p_msg', 'E', 'EMsgmkdirError', $KRB5DIR, $rc)
			  ;    # Error from mkdir
			$time = scalar localtime();
			MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
							'csmKRB5p_msg', 'LI', 'IMsgEnd', $pname, $time, $rc)
			  ;    #end message
			return $rc;
		}
	}

	# if /etc/krb5.conf and /etc/krb5/krb5.conf do not exist then
	# update /etc/krb5/krb5.conf and link to /etc/krb5.conf

	if ((!-e $CONFILE) && (!-e $NASCONFILE))
	{
		$rc = `/bin/cp $CONFILEFROMSERVER $NASCONFILE >/dev/null`;
		if ($? != 0)
		{          # error updating /etc/krb/krb5.conf
			$rc = ($? < 256 ? $? : ($? / 256));
			MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
							  'csmKRB5p_msg', 'E', 'EMsgCopyKRB5ConfigError',
							  $CONFILEFROMSERVER, $NASCONFILE, $rc); # copy fail
			$rc = $::NOK;
			return $rc;

		}
		else
		{    # copy successful
			MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
				 'csmKRB5p_msg', 'I', 'IMsgKRB5CfgCreated', $pname, $NASCONFILE)
			  ;    # /etc/krb5/krb5.conf created
			$rc = $::OK;
		}
		if ($rc == $::OK)
		{          # if copy good, then link it to /etc/krb5.conf
			$rc = `/bin/ln -s $NASCONFILE $CONFILE > /dev/null`;
			if ($? != 0)
			{      # error linking
				$rc = ($? < 256 ? $? : ($? / 256));
				MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
					'csmKRB5p_msg', 'E', 'EMsgLinkKRB5ConfigError', $NASCONFILE,
					$CONFILE, $rc);
				$rc = $::NOK;
				return $rc;

			}
			else
			{      # link successful
				MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
							  'csmKRB5p_msg', 'I', 'IMsgKRB5CfgCreated', $pname,
							  $CONFILE);    # /etc/krb5.conf created
				$rc = $::OK;
			}
		}

	}
	else
	{    #  /etc/krb5.conf and  /etc/krb5/krb5.conf  exist
		    #  diff to see if different from MS krb5.conf
		    #  if different
		    #  copy the node krb5.conf to krb5.conf.save
		    #  copy the MS krb5.conf to krb5.conf
		    #  warn the admin
		if ((-e $CONFILE) && (-e $NASCONFILE))
		{    # if both exist check to see if different from MS
			`/usr/bin/diff $CONFILEFROMSERVER $NASCONFILE `;
			if ($? != 0)
			{    # differences found
				$rc = `/bin/cp $NASCONFILE $NASCONFILESAVE>/dev/null`;
				if ($? != 0)
				{    # error saving
					$rc = ($? < 256 ? $? : ($? / 256));
					MessageUtils->messageFromCat(
								   'csmKRB5p.cat',            $KRB5::MSGMAPPATH,
								   'csmKRB5p_msg',            'E',
								   'EMsgCopyKRB5ConfigError', $NASCONFILE,
								   $NASCONFILESAVE,           $rc
												);    # copy fail
					$rc = $::NOK;
					return $rc;

				}
				else
				{                                     # tell the admin saving
					MessageUtils->messageFromCat(
										  'csmKRB5p.cat',     $KRB5::MSGMAPPATH,
										  'csmKRB5p_msg',     'I',
										  'IMsgMadeKRB5Save', $pname,
										  $NASCONFILE,        $NASCONFILESAVE
												);    # copy fail

				}

				#  copy the MS krb5.conf file on the node
				$rc = `/bin/cp $CONFILEFROMSERVER $NASCONFILE >/dev/null`;
				if ($? != 0)
				{    # error updating /etc/krb5.conf
					$rc = ($? < 256 ? $? : ($? / 256));
					MessageUtils->messageFromCat(
								  'csmKRB5p.cat',            $KRB5::MSGMAPPATH,
								  'csmKRB5p_msg',            'E',
								  'EMsgCopyKRB5ConfigError', $CONFILEFROMSERVER,
								  $NASCONFILE,               $rc
												);    # copy fail
					$rc = $::NOK;
					return $rc;

				}
				else
				{    # tell copying the krb5.conf file to the node
					MessageUtils->messageFromCat('csmKRB5p.cat',
									  $KRB5::MSGMAPPATH, 'csmKRB5p_msg', 'I',
									  'IMsgKRB5CfgCreated', $pname, $NASCONFILE)
					  ;    # /etc/krb5.conf created
					$rc = $::OK;
				}
			}    # end if difference found

		}
		else
		{

			#if /etc/krb5.conf exists and /etc/krb5/krb5.conf does not
			# update only /etc/krb5/krb5.conf

			if ((-e $CONFILE) && (!-e $NASCONFILE))
			{

				# log that /etc/krb5.conf exist
				MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
						 'csmKRB5p_msg', 'I', 'IMsgKRB5ClientCfgExists', $pname,
						 $CONFILE, $CONFILE);

				# copy to /etc/krb5/krb5.conf
				$rc = `/bin/cp $CONFILEFROMSERVER $NASCONFILE >/dev/null`;
				if ($? != 0)
				{    # error updating /etc/krb/krb5.conf
					$rc = ($? < 256 ? $? : ($? / 256));
					MessageUtils->messageFromCat(
								  'csmKRB5p.cat',            $KRB5::MSGMAPPATH,
								  'csmKRB5p_msg',            'E',
								  'EMsgCopyKRB5ConfigError', $CONFILEFROMSERVER,
								  $NASCONFILE,               $rc
												);    # copy fail
					$rc = $::NOK;
					return $rc;

				}
				else
				{                                     # copy successful
					MessageUtils->messageFromCat('csmKRB5p.cat',
									  $KRB5::MSGMAPPATH, 'csmKRB5p_msg', 'I',
									  'IMsgKRB5CfgCreated', $pname, $NASCONFILE)
					  ;    # /etc/krb5/krb5.conf created
					$rc = $::OK;
				}

			}
			else
			{

				# /etc/krb5 does not exist and /etc/krb5/krb5.conf does put out a
				# warning in the log
				MessageUtils->messageFromCat('csmKRB5p.cat', $KRB5::MSGMAPPATH,
						'csmKRB5p_msg', 'E', 'EMsgKRB5ConfigError', $NASCONFILE,
						$CONFILE);    # missing /etc/krb5.conf
				$rc = $::OK;
			}
		}
		return ($rc);
	}
}
##################  end of processAIXKRB5file#################
1;
