# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2006,2008 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 

# @(#)47   1.1   src/csm/core/pm/Rpm/Child/StrictVerOpRpm.pm.perl, csmcore, csm_rgar2h, rgar2hs001a 12/27/06 04:01:46
#!/usr/bin/perl
use strict;

=head1 StrictVerOpRpm

=head2 Class Description
    The class used to handle one type of optional RPM pacakges.
    This type of optional packages should be handled in following logic:
    1. If it has been installed, but the version is not correct, and CSM cannot find an appropriate version, CSM will exit 
       with an error message
    2. If it has not been installed, and user does not provide a version of it, CSM will continue with other operations. (installms
       and copycsmpkgs will always give a warning message for those unfound optional RPM packages to indicate some CSM functions may not
       be able to provide.)

    Attributes:

=cut
    
use Rpm::Rpm;
package StrictVerOpRpm;
@StrictVerOpRpm::ISA = qw( Rpm);
sub searchHighestVersionInFileList
{
    my $self = shift;
    my $fileListRef = shift;
    my $destAbsDir = shift;
    my $needCompareVersionWithDest = shift;

    my @fileList = @$fileListRef;

	$self->SUPER::searchHighestVersionInFileList( $fileListRef, $destAbsDir, $needCompareVersionWithDest);
    if ( !$self->isFound() && $self->isOtherVerInstalled())
    {
        MessageUtils->messageFromCat('csmInstall.cat', $::MSGMAPPATH,
                'csminstall', 'E1', 'EMsgWrongVerOpRpmInstalled', $self->getShortName());
    }
    else
    {
        return $self->isFound();
    }
}

1;
