# @(#)74   1.5   src/csm/core/pm/Rpm/Child/TftpRpm.pm.perl, csmcore, csm_rgar2h, rgar2hs001a 8/14/06 04:51:32
# IBM_PROLOG_BEGIN_TAG 
# This is an automatically generated prolog. 
#  
#  
#  
# Licensed Materials - Property of IBM 
#  
# (C) COPYRIGHT International Business Machines Corp. 2006,2008 
# All Rights Reserved 
#  
# US Government Users Restricted Rights - Use, duplication or 
# disclosure restricted by GSA ADP Schedule Contract with IBM Corp. 
#  
# IBM_PROLOG_END_TAG 
#!/usr/bin/perl
use strict;

BEGIN 
{ 
    $::default_tftp_server_name = "";
}

use Rpm::Rpm;
package TftpRpm;
@TftpRpm::ISA = qw( Rpm);
$::TRUE = 1;
#$::DEBUG=1;
sub install
{
    my $self = shift;
    my $option = shift;
	my $shortname = $self->getShortName();
	print "tftpname=$shortname ::TFTPpackage=$::TFTPpackage.\n" if $::DEBUG;
    my $rc = &process_tftp($shortname);
    # FIXME force tftp-hpa 0.34 to be installed on sles10 x86_64
    if ($rc)
	{
		return $self->SUPER::install( "$option --nodeps");
	}
	else
	{
	    return $::TRUE;		
	}
}

#--------------------------------------------------------------------------------

=head3    process_tftp

	Handles the special-case installation of the tftp-hpa rpm 
	(or an alternative tftp rpm). 
	Judge whether this TFTPpackage should be installed.

        Arguments:
                $packagename - means which  call this subroutine. 
			       
        Returns:
                $installTftp - 1 means TFTPpackage must be installed
                               0 means TFTPpackage should not be installed
        Globals:
                $::TFTPpackage  - user defined value, get it from IBM.Dmsctrl(csmconfig)
				  run "csmconfig -t tftppackagename" 
				  to change it
                $::default_tftp_server_name - default defined in IBM.Dms 
					      It is blank current ,since 
					      native tftp package is used.
        Error:
                V & I Err mesages
                
	Comments:

	The TFTPpackage attribute in the Dmsctrl (csmconfig) class is set
	by default to the same value as $::default_tftp_server_name.  The
	value is the name of the TFTP RPM package (native tftp) to install.
	For SLES, native tftp package name is "tftp" , for RedHat "tftp-server"
	The user may change it to another RPM name if desired.

	Since $::default_tftp_server_name is blank (using native tftp 
	instead of tftp-hpa) , that is common for all scenario. 
	We judge whether install or not  only by $::TFTPpackage , $packagename
        and $HasTftpinstalled. 
	$HasTftpinstalled is a flag that shows whether there has been a tftp 
	package installed or not. 1 means installed. 0 means not installed yet. 
	We can call NetworkUtils->check4InstalledTftpServers subroutine to get its value.
	This is a scenario matrix below. 
	
	"N" represents non-install and set installTftp=0, 
	"TI" represents try to install, 
		       If there is a the same name tftp installed ($HasTftpinstalled=1)
				 do nothing, and set installTftp=0.
		       Otherwise, install it and set installTftp=1. 
	"W" represents printing warning mesage.
	"NATIVE" means using native tftp, which value could be "tftp" or "tftp-server".
	
                       Case1   	   Case2	  Case3	        Case4     Case5     Case6
			   
    $::TFTPpackage:   NATIVE       NATIVE     tftp-hpa      tftp-hpa  other     other
        
    $packagename  :   tftp or      tftp-hpa   tftp or      tftp-hpa   tftp or   tftp-hpa
                     tftp-server              tftp-server           tftp-server
	  						
    Operation     :    TI	     	N           N            TI       N and W    N
	
    For case5 and case6: 
	If TFTPpackage is set to something other than default_tftp_server_name or tftp-hpa,
	then CSM will just ensure that the specified tftp RPM is installed
	on the install server, or that a tftp process (maybe installed from a
	tarball) is running.  If nothing is installed or running, then inform
	the user to install tftp and exit.

	Note that this subroutine is only called by TftpRpm::install.
=cut

#--------------------------------------------------------------------------------

sub process_tftp
{
    my $installTftp = 0;                  # 0 means no, 1 means install it.
    my ($cmd, $output, $rc, $returncode);
    $returncode = 0;
    my $ans = "";
    my $packagename = shift;
	($::DEBUG) && print "pakname=$packagename\n";
	#Check which tftp package has been installed.
	my ($HasTftpinstalled, @tftpRpms) =
      NetworkUtils->check4InstalledTftpServers();
    if (   ($::TFTPpackage eq "tftp") 
	|| ($::TFTPpackage eq "tftp-server"))
    #Limit in case1 and case2
    {
			if ($packagename ne "tftp-hpa")
			{
				# Case1
				# We should try to install native tftppackage
				($::DEBUG) && print "Entering case1.\n";
				if ($HasTftpinstalled)
				{
					# The TFTPpackage RPM is alrady installed.
					# There is no need to install it again, 
					# so set installTftp to 0
					# so that TFTPpackage does not get installed.
					($::DEBUG) && print "TFTPpackage ($::TFTPpackage) already installed\n"; 
					$installTftp = 0;
				}
				else
				{
                    # The TFTPpackage RPM is not already installed, and we know how to
        			# install it since it is the same as the default_tftp_server_name.

        			# If any conflicting tftp RPMs are already installed, then remove
        			# them before installing TFTPpackage.
        			if ($#tftpRpms ne -1)
        			{
            			($::DEBUG) && print "Removing conflicting tftp rpms: @tftpRpms\n";
            			NetworkUtils->rmTftpRpms(@tftpRpms);
        			}

        			# Set installTftp to 1 so that TFTPpackage gets installed.
        			($::DEBUG) && print "TFTPpackage ($::TFTPpackage) not installed\n";
        			$installTftp = 1;
				}		
			}
			else
			{
				# Case2
				# Do nothing here ,since the package name is different from 
				# Dmsctrl (csmconfig) class.
				($::DEBUG) && print "Entering case2.\n";
				$installTftp = 0;
			}
    }
    elsif ($::TFTPpackage =~ /tftp-hpa/)
    #Limit in case3 and case4
    {
			if ($packagename =~ /tftp-hpa/)
			{
				# Case4
				# We should try to install tftp-hpa package
				($::DEBUG) && print "Entering case4.\n";
				if ($HasTftpinstalled)
				{
					# The TFTPpackage RPM is alrady installed.
					# There is no need to install it again, 
					# so set installTftp to 0
					# so that TFTPpackage does not get installed.
					($::DEBUG) && print "TFTPpackage ($::TFTPpackage) already installed\n"; 
					$installTftp = 0;
				}
				else
				{
                    # The TFTPpackage RPM is not already installed, and we know how to
        			# install it since it is the same as the default_tftp_server_name.

        			# If any conflicting tftp RPMs are already installed, then remove
        			# them before installing TFTPpackage.
        			if ($#tftpRpms ne -1)
        			{
            			($::DEBUG) && print "Removing conflicting tftp rpms: @tftpRpms\n";
            			NetworkUtils->rmTftpRpms(@tftpRpms);
        			}

        			# Set installTftp to 1 so that TFTPpackage gets installed.
        			($::DEBUG) && print "TFTPpackage ($::TFTPpackage) not installed\n";
        			$installTftp = 1;
				}		
			}
			else
			{
				# Case3
				# Do nothing here ,since the package name is different from 
				# Dmsctrl (csmconfig) class.
				($::DEBUG) && print "Entering case3.\n";
				$installTftp = 0;
			}

    }
    #Limit in case5 and case6
	else
    {
			if ($packagename !~ /tftp-hpa/)
			{
				# Case5
				($::DEBUG) && print "Entering case5.\n";
				# If there is unknown tftp package,
				# We don't know how to install it.
		        # Check if there is a TFTP process running
        		my $running = NetworkUtils->verifyTftp();
        		if ($running)
        		{

            		print "An unknown tftp server is running, but the $::TFTPpackage\n"
              		. "RPM is not installed.  Hopefully the running tftp server\n"
              		. "will work OK!\n";
            		MessageUtils->message('I', 'IMsgChangeTftpUser', 'tftpd');
            		$installTftp = 0;
        		}
        		else
        		{

            		print "The $::TFTPpackage RPM is not installed and no tftp\n"
              		. "server could be found on the system.\n"
              		. "A TFTP server must be installed for CSM to function\n";
            		MessageUtils->message('I', 'IMsgChangeTftpUser', 'tftpd');
            		exit 1;
        		}
				
			}
			else
			{
				# Case6
				# Do nothing here.
				($::DEBUG) && print "Entering case6.\n";
				$installTftp = 0;
			}

    }

    ($::DEBUG) && print "INSTALLTFTP = $installTftp\n";
    return $installTftp;
}
1;
