/* IBM_PROLOG_BEGIN_TAG                                                   */
/* This is an automatically generated prolog.                             */
/*                                                                        */
/*                                                                        */
/*                                                                        */
/* Licensed Materials - Property of IBM                                   */
/*                                                                        */
/* (C) COPYRIGHT International Business Machines Corp. 1996,2008          */
/* All Rights Reserved                                                    */
/*                                                                        */
/* US Government Users Restricted Rights - Use, duplication or            */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.      */
/*                                                                        */
/* IBM_PROLOG_END_TAG                                                     */
#ifndef _HA_GS_H_
#define _HA_GS_H_

static char *ha_gs_h_sccsid = "@(#)86   1.78   src/rsct/pgs/pgslib/ha_gs.h, gsapi, rsct_rfos, rfos0838a 4/17/08 09:33:26";

#include <inttypes.h>
#include <sys/types.h>
#include <rsct/ct_ffdc.h>
#include <netinet/in.h>

#ifdef __cplusplus
extern "C" {
#endif


#define HA_GS_RELEASE  21

typedef enum
{
    HA_GS_OK,                           /* 0 */
    HA_GS_OK_SO_FAR = HA_GS_OK,         /* 0 */
    HA_GS_NOT_OK,                       /* 1 */
    HA_GS_EXISTS,                       /* 2 */
    HA_GS_NO_INIT,                      /* 3 */
    HA_GS_NAME_TOO_LONG,                /* 4 */
    HA_GS_NO_MEMORY,                    /* 5 */
    HA_GS_NOT_A_MEMBER,                 /* 6 */
    HA_GS_BAD_CLIENT_TOKEN,             /* 7 */
    HA_GS_BAD_MEMBER_TOKEN,             /* 8 */
    HA_GS_BAD_PARAMETER,                /* 9 */
    HA_GS_UNKNOWN_GROUP,                /* 10 */
    HA_GS_INVALID_GROUP,                /* 11 */
    HA_GS_NO_SOURCE_GROUP_PROVIDER,     /* 12 */
    HA_GS_BAD_GROUP_ATTRIBUTES,         /* 13 */
    HA_GS_WRONG_OLD_STATE,              /* 14 */
    HA_GS_DUPLICATE_INSTANCE_NUMBER,    /* 15 */
    HA_GS_COLLIDE,                      /* 16 */
    HA_GS_SOCK_CREATE_FAILED,           /* 17 */
    HA_GS_SOCK_INIT_FAILED,             /* 18 */
    HA_GS_CONNECT_FAILED,               /* 19 */
    HA_GS_VOTE_NOT_EXPECTED,            /* 20 */
    HA_GS_NOT_SUPPORTED,                /* 21 */
    HA_GS_INVALID_SOURCE_GROUP,         /* 22 */
    HA_GS_UNKNOWN_PROVIDER,             /* 23 */
    HA_GS_INVALID_DEACTIVATE_PHASE,     /* 24 */
    HA_GS_PROVIDER_APPEARS_TWICE,       /* 25 */
    HA_GS_BACKLEVEL_PROVIDERS,          /* 26 */
    HA_GS_NULL_ADAPTER_INFO,            /* 27 */
    HA_GS_ADAPTER_INFO_NOT_FOUND,       /* 28 */
    HA_GS_ADAPTER_INFO_NOT_SENT,        /* 29 */
    HA_GS_NOT_ADAPTER_GROUP,            /* 30 */
    HA_GS_VOTE_VALUE_NOT_ALLOWED        /* 31 */

}ha_gs_rc_t;			/* Return Codes */

typedef enum
{
    HA_GS_NO_BATCHING		= 0x0000,
    HA_GS_BATCH_JOINS		= 0x0001,
    HA_GS_BATCH_LEAVES		= 0x0002,
    HA_GS_BATCH_BOTH		= HA_GS_BATCH_JOINS|HA_GS_BATCH_LEAVES, /*0x0003*/
    HA_GS_DEACTIVATE_ON_FAILURE = 0x0004,
    HA_GS_COLLECT_VOTE_RESULT   = 0x0008, /* collect only vote list */
    HA_GS_COLLECT_MSG_RESULT    = 0x0010, /* collect only msg list */
    HA_GS_COLLECT_STATEVALUE_RESULT   = 0x0020,/*collect only state value list*/
    HA_GS_COLLECT_ALL_RESULT    = HA_GS_COLLECT_VOTE_RESULT|HA_GS_COLLECT_MSG_RESULT|HA_GS_COLLECT_STATEVALUE_RESULT /* collect all lists */
} ha_gs_batch_ctrl_t;		/* Controls Batching of Requests */

typedef enum
{
    HA_GS_1_PHASE		= 0x0001,
    HA_GS_N_PHASE		= 0x0002
} ha_gs_num_phases_t;		/* Protocol number of Phases selection */

typedef enum
{
    HA_GS_FIRST_MERGE_TYPE, 			   /* 0 */
    HA_GS_DISSOLVE_MERGE = HA_GS_FIRST_MERGE_TYPE, /* 0 */
    HA_GS_LARGER_MERGE,                            /* 1 */
    HA_GS_SMALLER_MERGE,                           /* 2 */
    HA_GS_DONTCARE_MERGE,                          /* 3 */
    HA_GS_ANYORDER_MERGE,                          /* 4 */
    HA_GS_LAST_MERGE_TYPE = HA_GS_ANYORDER_MERGE
} ha_gs_merge_ctrl_t;		/* Controlling Merges */

typedef enum
{
    HA_GS_NULL_VOTE                        = 0x00,
    HA_GS_VOTE_APPROVE                     = 0x01,
    HA_GS_VOTE_CONTINUE                    = 0x02,
    HA_GS_VOTE_REJECT                      = 0x03,
    /* The following values are only meaningful for the merge protocol */
    HA_GS_VOTE_APPROVE_AND_SWITCH_ALPHA_OMEGA  = 0x81,
    HA_GS_VOTE_CONTINUE_AND_SWITCH_ALPHA_OMEGA = 0x82
} ha_gs_vote_value_t;           /* Allowable Vote Responses */

typedef enum
{
    HA_GS_SOCKET_NO_SIGNAL		= 0x0000000,
    HA_GS_SOCKET_SIGNAL			= 0x00000001,  /* not supported */
    HA_GS_ENABLE_ADAPTER_INFO		= 0x00000002,
    HA_GS_ENABLE_DOMAIN_EVENT           = 0x00001000,  /* to receive domain events */
    HA_GS_IMMEDIATE_DOMAIN_CONTROL	= 0x10000000  /* reserved for IBM use */
} ha_gs_socket_ctrl_t;		/* Socket Control */

typedef enum
{
    HA_GS_NON_BLOCKING,
    HA_GS_BLOCKING
} ha_gs_dispatch_flag_t;	/* Modify behavior of ha_gs_dispatch */

typedef enum
{
    HA_GS_RESPONSIVENESS_NOTIFICATION	= 0,
    HA_GS_QUERY_NOTIFICATION		= 1,
    HA_GS_DELAYED_ERROR_NOTIFICATION	= 2,
    HA_GS_N_PHASE_NOTIFICATION		= 3,
    HA_GS_APPROVED_NOTIFICATION		= 4,
    HA_GS_REJECTED_NOTIFICATION		= 5,
    HA_GS_ANNOUNCEMENT_NOTIFICATION	= 6,
    HA_GS_SUBSCRIPTION_NOTIFICATION	= 7,
    HA_GS_MERGE_NOTIFICATION		= 8,
    HA_GS_DOMAIN_NOTIFICATION           = 9,	
    HA_GS_NOTIFICATION_RESERVED_1 	= 99,
    HA_GS_NOTIFICATION_RESERVED_2 	= 100,
    HA_GS_NOTIFICATION_RESERVED_3 	= 101,
    HA_GS_NOTIFICATION_RESERVED_4 	= 102,
    HA_GS_NOTIFICATION_RESERVED_5 	= 103
} ha_gs_notification_type_t;            /* Identify types of notifications */

typedef enum
{
    HA_GS_RESPONSIVENESS		= 0,
    HA_GS_JOIN				= 1,
    HA_GS_FAILURE_LEAVE			= 2,
    HA_GS_LEAVE				= 3,
    HA_GS_EXPEL				= 4,
    HA_GS_STATE_VALUE_CHANGE		= 5,
    HA_GS_PROVIDER_MESSAGE		= 6,
    HA_GS_CAST_OUT			= 7,
    HA_GS_SOURCE_STATE_REFLECTION	= 8,
    HA_GS_MERGE				= 9,
    HA_GS_SUBSCRIPTION			= 10,
    HA_GS_GROUP_ATTRIBUTE_CHANGE	= 11,
    MAX_REQUEST = HA_GS_GROUP_ATTRIBUTE_CHANGE,	/* 11 */
    HA_GS_INTERNAL_REQUEST   = 99			/* internal request */
} ha_gs_request_t;		/* Type of request a notification was for */



/*
 *----------------------------------------------------------------------------
 * Note:
 * Responsiveness checks allow the Group Services subsystem to periodically 
 *   inspect the state of the GS client.
 *
 * The responsiveness type controls whether the client should be monitored,
 *   or what action should be taken in case of non-responsiveness.  The type 
 *   will consist of two fields which can be OR-ed; "protocol" and "action".
 *
 * The "Responsiveness protocol": Only of them can be selected.
 *    HA_GS_NO_RESPONSIVENESS
 *    HA_GS_PING_RESPONSIVENESS
 *    HA_GS_COUNTER_RESPONSIVENESS  - not supported at this moment.
 *
 * The "Action" for the non-responsive client: They can be OR-ed.
 *    HA_GS_KEEP_CHECK_RESPONSIVENESS
 *       This flag will make the responsiveness msgs to always be sent
 *       to the client even if the client is running a protocol (In default, 
 *       responsiveness msg will be only exchanged when the client is idle).
 *       Also note that this flag will work properly only under multi-threaded
 *       with dedicated ha_gs_dispatch() threads.
 *
 *    HA_GS_ANNOUNCEMENT_WHEN_SLOW
 *       The other providers will be notified if one of them is not responding.
 *       If no other option (e.g., script) is selected, this flag will be assumed.
 *
 *    HA_GS_EXEC_SCRIPT_WHEN_SLOW
 *       A script will be invoked when the corresponing client is not responding.
 *
 *   HA_GS_DAEMON_MUST_DIE_WHEN_SLOW
 *       This flag is reserved for IBM use.
 *       This flag will also be sliently ignored to the other clients.
 *----------------------------------------------------------------------------
 */

typedef enum
{
    /* responsiveness protocol type */
    HA_GS_NO_RESPONSIVENESS		= 0x00000000,
    HA_GS_PING_RESPONSIVENESS		= 0x00000001,
    HA_GS_COUNTER_RESPONSIVENESS	= 0x00000002,	/* not supported at this moment */

    /* responsiveness action type */
    HA_GS_KEEP_CHECK_RESPONSIVENESS	= 0x00010000,

    HA_GS_ANNOUNCEMENT_WHEN_SLOW	= 0x01000000,	/* default */
    HA_GS_EXEC_SCRIPT_WHEN_SLOW		= 0x02000000,
    HA_GS_DAEMON_MUST_DIE_WHEN_SLOW	= 0x04000000,   /* reserved for IBM use */
    HA_GS_CLOSE_CLIENT_SOCKET           = 0x08000000    /* close the socket if not responding */
} ha_gs_responsiveness_type_t;		/* Type of responsiveness checking */

typedef enum
{
    HA_GS_NO_CHANGE                     = 0x00000000, /* 0 */
    HA_GS_PROPOSED_MEMBERSHIP           = 0x00000001, /* 1 */
    HA_GS_ONGOING_MEMBERSHIP            = 0x00000002, /* 2 */
    HA_GS_PROPOSED_STATE_VALUE          = 0x00000004, /* 4 */
    HA_GS_ONGOING_STATE_VALUE           = 0x00000008, /* 8 */
    HA_GS_UPDATED_PROVIDER_MESSAGE      = 0x00000010, /* 16 */
    HA_GS_UPDATED_MEMBERSHIP            = 0x00000020, /* 32 */
    HA_GS_REJECTED_MEMBERSHIP           = 0x00000040, /* 64 */
    HA_GS_UPDATED_STATE_VALUE           = 0x00000080, /* 128 */
    HA_GS_REFLECTED_SOURCE_STATE_VALUE  = 0x00000100, /* 256 */
    HA_GS_EXPEL_INFORMATION             = 0x00000200, /* 512 */
    HA_GS_PROPOSED_GROUP_ATTRIBUTES     = 0x00000400, /* 1024 */
    HA_GS_ONGOING_GROUP_ATTRIBUTES      = 0x00000800, /* 2048 */
    HA_GS_UPDATED_GROUP_ATTRIBUTES      = 0x00001000, /* 4096 */
    HA_GS_REJECTED_GROUP_ATTRIBUTES     = 0x00002000, /* 8192 */
    HA_GS_CURRENT_STATE_VALUE           = 0x00004000, /* */
    HA_GS_MERGE_GROUP_INFO              = 0x00010000, /* merge info is reported */
    HA_GS_MERGE_ALPHA_OMEGA_SWITCHED     = 0x00020000
} ha_gs_updates_t;                                /* Whats Changed */

typedef enum
{
    HA_GS_EXPLICIT_APPROVE			= 0x0001, /* 1 */
    HA_GS_EXPLICIT_REJECT			= 0x0002, /* 2 */
    HA_GS_DEFAULT_APPROVE			= 0x0004, /* 4 */
    HA_GS_DEFAULT_REJECT			= 0x0008, /* 8 */
    HA_GS_TIME_LIMIT_EXCEEDED			= 0x0010, /* 16 */
    HA_GS_PROVIDER_FAILED			= 0x0020, /* 32 */
    HA_GS_RESPONSIVENESS_NO_RESPONSE		= 0x0040, /* 64 */
    HA_GS_RESPONSIVENESS_RESPONSE		= 0x0080, /* 128 */
    HA_GS_GROUP_DISSOLVED			= 0x0100, /* 256 */
    HA_GS_GROUP_SERVICES_HAS_DIED_HORRIBLY	= 0x0200, /* 512 */
    HA_GS_DEACTIVATE_UNSUCCESSFUL               = 0x0400, /* 1024 */
    HA_GS_DEACTIVATE_TIME_LIMIT_EXCEEDED        = 0x0800, /* 2048 */
    HA_GS_GROUP_ATTRIBUTES_CHANGED              = 0x1000, /* 4096 */

    HA_GS_MIN_SUMMARY_CODE		= HA_GS_EXPLICIT_APPROVE,
    HA_GS_MAX_SUMMARY_CODE		= HA_GS_GROUP_ATTRIBUTES_CHANGED
} ha_gs_summary_code_t;		/* Notification summary */

typedef enum
{
    HA_GS_CALLBACK_NOT_OK,
    HA_GS_CALLBACK_OK
} ha_gs_callback_rc_t;		/* Callback Return Codes */

typedef enum
{
    HA_GS_FAILURE_NONE          = 0x0000, /* 0 */
    HA_GS_VOLUNTARY_LEAVE	= 0x0001, /* 1 */
    HA_GS_PROVIDER_FAILURE	= 0x0002, /* 2 */
    HA_GS_HOST_FAILURE		= 0x0004, /* 4 */
    HA_GS_PROVIDER_EXPELLED	= 0x0008, /* 8 */
    HA_GS_SOURCE_PROVIDER_LEAVE = 0x0010, /* 16 */
    HA_GS_PROVIDER_SAID_GOODBYE = 0x0020, /* 32 */
    HA_GS_NETWORK_SUNDERED      = 0x0040  /* 64 */
} ha_gs_leave_reasons_t;

typedef enum
{
    HA_GS_QUERY_ALL,
    HA_GS_QUERY_GROUP
} ha_gs_query_type_t;

typedef enum
{
    HA_GS_SUBSCRIBE_STATE		= 0x01,
    HA_GS_SUBSCRIBE_DELTA_JOINS		= 0x02,
    HA_GS_SUBSCRIBE_DELTA_LEAVES	= 0x04,
    HA_GS_SUBSCRIBE_DELTAS_ONLY 	= 0x06,
    HA_GS_SUBSCRIBE_MEMBERSHIP  	= 0x08,
    HA_GS_SUBSCRIBE_ALL_MEMBERSHIP      = 0x0e,
    HA_GS_SUBSCRIBE_STATE_AND_MEMBERSHIP= 0x0f,
    HA_GS_SUBSCRIBE_ADAPTER_INFO        = 0x10,
    HA_GS_SUBSCRIBE_SPECIAL_DATA        = 0x40,
    HA_GS_SUBSCRIBE_PERSISTENCE         = 0x200
} ha_gs_subscription_ctrl_t;

typedef enum
{
    HA_GS_SUBSCRIPTION_STATE		= 0x01, /* 1 */
    HA_GS_SUBSCRIPTION_DELTA_JOIN	= 0x02, /* 2 */
    HA_GS_SUBSCRIPTION_DELTA_LEAVE	= 0x04, /* 4 */
    HA_GS_SUBSCRIPTION_MEMBERSHIP	= 0x08, /* 8 */
    HA_GS_SUBSCRIPTION_SPECIAL_DATA	= 0x40, /* 64 */
    HA_GS_SUBSCRIPTION_DISSOLVED	= 0x80, /* 128 */
    HA_GS_SUBSCRIPTION_GS_HAS_DIED      = 0x100, /* 256 */
    HA_GS_SUBSCRIPTION_PERSISTENT       = 0x200 
} ha_gs_subscription_type_t;

typedef int ha_gs_token_t;
typedef int ha_gs_descriptor_t;
typedef unsigned short ha_gs_time_limit_t;

#define HA_GS_MAX_GROUP_NAME_LENGTH	32
typedef char *ha_gs_group_name_t;

/* Use this name to subscribe to processor membership. */
#define HA_GS_HOST_MEMBERSHIP_GROUP 	"HostMembership"

#define HA_GS_ENET_MEMBERSHIP_GROUP	"enMembership"
#define HA_GS_CSSRAW_MEMBERSHIP_GROUP	"cssRawMembership"
#define HA_GS_ML0_MEMBERSHIP_GROUP	"ml0Membership"
#define HA_GS_TOKENRING_MEMBERSHIP_GROUP "trMembership"
#define HA_GS_FDDI_MEMBERSHIP_GROUP	"fddiMembership"
#define HA_GS_RS232_MEMBERSHIP_GROUP	"rs232Membership"
#define HA_GS_TMSCSI_MEMBERSHIP_GROUP	"tmscsiMembership"
#define HA_GS_TMSSA_MEMBERSHIP_GROUP	"tmssaMembership"
#define HA_GS_SLIP_MEMBERSHIP_GROUP	"slipMembership"
#define HA_GS_ATM_MEMBERSHIP_GROUP	"atmMembership"
#define HA_GS_MYRINET_MEMBERSHIP_GROUP	"myriMembership"
#define HA_GS_FC_MEMBERSHIP_GROUP       "fcMembership"
#define HA_GS_BOND_MEMBERSHIP_GROUP       "bondMembership"
#define HA_GS_EIP_MEMBERSHIP_GROUP       "eipMembership"
#define HA_GS_ALL_ADAPTER_MEMBERSHIP_GROUP  "allAdapterMembership"

/* Use this name to subscribe to switch membership. */
#define HA_GS_CSS_MEMBERSHIP_GROUP	"cssMembership"
#define HA_GS_CSS0_MEMBERSHIP_GROUP	HA_GS_CSS_MEMBERSHIP_GROUP
#define HA_GS_CSS1_MEMBERSHIP_GROUP	"css1Membership"
#define HA_GS_CSS2_MEMBERSHIP_GROUP	"css2Membership"
#define HA_GS_CSS3_MEMBERSHIP_GROUP	"css3Membership"
#define HA_GS_CSS4_MEMBERSHIP_GROUP	"css4Membership"
#define HA_GS_CSS5_MEMBERSHIP_GROUP	"css5Membership"
#define HA_GS_CSS6_MEMBERSHIP_GROUP	"css6Membership"
#define HA_GS_CSS7_MEMBERSHIP_GROUP	"css7Membership"
#define HA_GS_CSS8_MEMBERSHIP_GROUP	"css8Membership"
#define HA_GS_CSSALL_MEMBERSHIP_GROUP	"cssAllMembership"

#define HA_GS_SWNET0_MEMBERSHIP_GROUP	HA_GS_CSS0_MEMBERSHIP_GROUP
#define HA_GS_SWNET1_MEMBERSHIP_GROUP	HA_GS_CSS1_MEMBERSHIP_GROUP
#define HA_GS_SWNET2_MEMBERSHIP_GROUP	HA_GS_CSS2_MEMBERSHIP_GROUP
#define HA_GS_SWNET3_MEMBERSHIP_GROUP	HA_GS_CSS3_MEMBERSHIP_GROUP
#define HA_GS_SWNET4_MEMBERSHIP_GROUP	HA_GS_CSS4_MEMBERSHIP_GROUP
#define HA_GS_SWNET5_MEMBERSHIP_GROUP	HA_GS_CSS5_MEMBERSHIP_GROUP
#define HA_GS_SWNET6_MEMBERSHIP_GROUP	HA_GS_CSS6_MEMBERSHIP_GROUP
#define HA_GS_SWNET7_MEMBERSHIP_GROUP	HA_GS_CSS7_MEMBERSHIP_GROUP
#define HA_GS_SWNET8_MEMBERSHIP_GROUP	HA_GS_CSS8_MEMBERSHIP_GROUP
#define HA_GS_SWNETALL_MEMBERSHIP_GROUP	HA_GS_CSSALL_MEMBERSHIP_GROUP

typedef struct
{
    short		gs_version;
    short		gs_sizeof_group_attributes;
    short		gs_client_version;
    ha_gs_batch_ctrl_t	gs_batch_control;
    ha_gs_num_phases_t	gs_num_phases;
    ha_gs_num_phases_t	gs_source_reflection_num_phases;
    ha_gs_vote_value_t	gs_group_default_vote;
    ha_gs_merge_ctrl_t	gs_merge_control;
    ha_gs_time_limit_t	gs_time_limit;
    ha_gs_time_limit_t	gs_source_reflection_time_limit;
    ha_gs_group_name_t	gs_group_name;
    ha_gs_group_name_t	gs_source_group_name;
    ha_gs_vote_value_t  gs_merge_default_vote; /* for merge */
} ha_gs_group_attributes_t;		/* Identify Group Attributes */

#ifdef __cplusplus
const   short   HA_GS_node_number = -1;
const   short   HA_GS_instance_number = -1;
#else
#define HA_GS_node_number	((short)-1)
#define HA_GS_instance_number	((short)-1)
#endif

#define gs_node_number _gs_provider_info._gs_node_number
#define gs_instance_number _gs_provider_info._gs_instance_number

typedef union
{
    struct
    {
        short	_gs_instance_number;
        short	_gs_node_number;
    } _gs_provider_info;
    int gs_provider_id;
} ha_gs_provider_t;			/* Provider ID */


typedef struct
{
    int		gs_length;
    char	*gs_state;
} ha_gs_state_value_t;		/* State Vector */

typedef struct
{
    short		gs_version;
    ha_gs_state_value_t	gs_group_state_value;
} ha_gs_group_state_t;		/* encapsulation of state vector */

typedef struct
{
    int		gs_length;
    char	*gs_message;
} ha_gs_provider_message_t;	/* provider message */

typedef struct
{
    ha_gs_responsiveness_type_t	gs_responsiveness_type;
    unsigned int		gs_responsiveness_interval;
    ha_gs_time_limit_t		gs_responsiveness_response_time_limit;
    void			*gs_counter_location;
    unsigned int		gs_counter_length;
} ha_gs_responsiveness_t;		/* responsiveness attributes */

typedef union
{
    struct {
	ha_gs_state_value_t	*_gs_info_state;
	ha_gs_provider_t	*_gs_info_providers;
    } _gs_group_info;
    ha_gs_group_name_t	gs_groups;
} ha_gs_group_info_t;

#define gs_group_info_state     _gs_group_info._gs_info_state
#define gs_group_info_providers _gs_group_info._gs_info_providers

typedef struct
{
    ha_gs_query_type_t	gs_query_type;
    ha_gs_rc_t		gs_query_return_code;
    int			gs_number_of_groups;
    ha_gs_group_info_t	*gs_group_info;
} ha_gs_query_info_t;

typedef struct
{
    unsigned int 	gs_count;
    ha_gs_provider_t	*gs_providers;
} ha_gs_membership_t;		/* Membership List */

typedef struct {
    int			gs_deactivate_phase;
    int                 gs_expel_flag_length;
    char                *gs_expel_flag;
} ha_gs_expel_info_t;

typedef struct
{
    unsigned int	gs_voluntary_or_failure;
    unsigned int	gs_voluntary_leave_code;
} ha_gs_leave_info_t;

typedef struct
{
    unsigned int 	gs_count;
    ha_gs_leave_info_t	*gs_leave_codes;
} ha_gs_leave_array_t;

typedef struct {
    unsigned short	gs_num_phases;
    unsigned short	gs_phase_number;
} ha_gs_phase_info_t;

typedef struct {
    ha_gs_membership_t   *gs_alpha_providers;
    ha_gs_membership_t   *gs_omega_providers;
    ha_gs_group_state_t  gs_alpha_group_state;
    ha_gs_group_state_t  gs_omega_group_state;
} ha_gs_merge_info_t;

typedef struct
{
    ha_gs_provider_t        gs_voter;
    ha_gs_vote_value_t      gs_vote_value;
    ha_gs_summary_code_t    gs_summary_code;
    ha_gs_leave_reasons_t   gs_leave_code;
    ha_gs_state_value_t     *gs_proposed_state_value;
    ha_gs_provider_message_t *gs_provider_message;
} ha_gs_vote_result_t;

typedef ha_gs_vote_result_t    *ha_gs_vote_result_ptr_t;

typedef struct
{
    unsigned int               gs_count;
    ha_gs_vote_result_ptr_t    *gs_vote_results;
} ha_gs_vote_result_array_t;

typedef enum {
    HA_GS_ADAPTER_DEATH_ARRAY	= 0x01,
    HA_GS_CURRENT_ADAPTER_ALIAS_ARRAY 	= 0x02,
    HA_GS_CHANGING_ADAPTER_ALIAS_ARRAY 	= 0x04
} ha_gs_subscription_special_type_t;

typedef enum
{
    HA_GS_ADAPTER_DEAD		= 0x0001,
    HA_GS_ADAPTER_REMOVED	= 0x0002
} ha_gs_adapter_death_t;

typedef struct  {
    int                 gs_length;
    unsigned int        gs_flag;
    void                *gs_special_data;
} ha_gs_special_data_t;

typedef struct ha_gs_special_block_t {
    unsigned int        gs_special_flag;
    struct ha_gs_special_block_t        *gs_next_special_block;
    int			gs_special_num_entries;
    int			gs_special_length;
    void        	*gs_special;
} ha_gs_special_block_t;

/* maximum limits */
typedef struct {
    int max_provider_message_length;
    int max_state_value_length;
    int max_group_name_length;
} ha_gs_limits;

/* NOTE: at this moment, only IPv4 will be supported */
typedef union {
    struct in_addr      ip4;
    struct in6_addr     ip6;
} ha_gs_ip_addr;

typedef struct {
    ha_gs_ip_addr              ip_addr;
    short                      node_number;
    const char                 *interface_name;
    ha_gs_provider_t           gs_member_id; /* not used yet */
    const char 		       *gs_group_name; /* not used yet */
    const char                 *hb_network_name;
    const char                 *hb_network_type;
    void                       *__reserved_1__; /* do not reference this variable */
    void                       *__reserved_2__; /* do not reference this variable */
} ha_gs_adapter_info;

typedef struct
{
    unsigned int       gs_count;
    ha_gs_ip_addr      *gs_ip_members;
} ha_gs_adapter_ip_membership_t;


typedef struct
{
    ha_gs_phase_info_t		gs_phase_info;
    ha_gs_provider_t		gs_proposed_by;
    ha_gs_updates_t		gs_whats_changed;
    ha_gs_membership_t		*gs_current_providers;
    ha_gs_membership_t		*gs_changing_providers;
    ha_gs_leave_array_t		*gs_leave_info;
    ha_gs_expel_info_t		*gs_expel_info;
    ha_gs_state_value_t		*gs_current_state_value;
    ha_gs_state_value_t		*gs_proposed_state_value;
    ha_gs_state_value_t		*gs_source_state_value;
    ha_gs_provider_message_t	*gs_provider_message;
    ha_gs_group_attributes_t    *gs_new_group_attributes;
    ha_gs_merge_info_t          *gs_merge_info;
    ha_gs_vote_result_array_t   *gs_current_vote_results;
    ha_gs_vote_result_array_t   *gs_changing_vote_results;
} ha_gs_proposal_t;

typedef struct
{
    ha_gs_notification_type_t	gs_notification_type;
    ha_gs_responsiveness_t      gs_responsiveness_information;
} ha_gs_responsiveness_notification_t;

typedef struct
{
    ha_gs_notification_type_t	gs_notification_type;
    unsigned int		gs_number_of_queries;
    ha_gs_query_info_t		*gs_query_info;
} ha_gs_query_notification_t;

typedef struct
{
    ha_gs_notification_type_t	gs_notification_type;
    ha_gs_token_t		gs_provider_token;
    ha_gs_request_t		gs_protocol_type;
    ha_gs_summary_code_t	gs_summary_code;
    ha_gs_time_limit_t		gs_time_limit;
    ha_gs_proposal_t		*gs_proposal;
} ha_gs_n_phase_notification_t;

typedef struct
{
    ha_gs_notification_type_t	gs_notification_type;
    ha_gs_token_t		gs_provider_token;
    ha_gs_request_t		gs_protocol_type;
    ha_gs_summary_code_t	gs_summary_code;
    ha_gs_proposal_t		*gs_proposal;
} ha_gs_approved_notification_t;

typedef struct
{
    ha_gs_notification_type_t	gs_notification_type;
    ha_gs_token_t		gs_provider_token;
    ha_gs_request_t		gs_protocol_type;
    ha_gs_summary_code_t	gs_summary_code;
    ha_gs_proposal_t		*gs_proposal;
} ha_gs_rejected_notification_t;

typedef struct
{
    ha_gs_notification_type_t	gs_notification_type;
    ha_gs_token_t		gs_provider_token;
    ha_gs_summary_code_t	gs_summary_code;
    ha_gs_membership_t		*gs_announcement;
} ha_gs_announcement_notification_t;

typedef struct
{
    ha_gs_notification_type_t	gs_notification_type;
    ha_gs_token_t		gs_provider_token;
    ha_gs_request_t		gs_protocol_type;
    ha_gs_proposal_t		*gs_proposal;
    ha_gs_merge_ctrl_t		gs_merge_control;
    ha_gs_group_state_t		gs_alpha_group_state;
    ha_gs_group_state_t		gs_omega_group_state;
} ha_gs_merge_notification_t;

typedef struct
{
    ha_gs_notification_type_t	gs_notification_type;
    ha_gs_token_t		gs_subscriber_token;
    ha_gs_subscription_type_t	gs_subscription_type;
    ha_gs_state_value_t		*gs_state_value;
    ha_gs_membership_t		*gs_full_membership;
    ha_gs_membership_t		*gs_changing_membership;
    ha_gs_special_data_t        *gs_subscription_special_data;
    ha_gs_adapter_ip_membership_t  *gs_full_ip_membership;
    ha_gs_adapter_ip_membership_t  *gs_changing_ip_membership;
    ha_gs_adapter_death_t          *gs_reason_flags;
    ha_gs_merge_info_t             *gs_merge_info;
} ha_gs_subscription_notification_t;

/*
 *------------------------------------------------------------------
 *------------------------------------------------------------------
 */

typedef void (ha_gs_subscription_cb_t)(const ha_gs_subscription_notification_t*);

typedef void (ha_gs_query_cb_t)(const ha_gs_query_notification_t*);

typedef ha_gs_callback_rc_t (ha_gs_responsiveness_cb_t)(const ha_gs_responsiveness_notification_t*);

typedef void (ha_gs_n_phase_cb_t)(const ha_gs_n_phase_notification_t*);

typedef void (ha_gs_approved_cb_t)(const ha_gs_approved_notification_t*);

typedef void (ha_gs_rejected_cb_t)(const ha_gs_rejected_notification_t*);

typedef void (ha_gs_announcement_cb_t)(const ha_gs_announcement_notification_t*);

typedef void (ha_gs_merge_cb_t)(const ha_gs_merge_notification_t*);

typedef	struct {
    ha_gs_group_attributes_t	*gs_group_attributes;
    short       		gs_provider_instance;
    char			*gs_provider_local_name;
    ha_gs_n_phase_cb_t		*gs_n_phase_protocol_callback;
    ha_gs_approved_cb_t		*gs_protocol_approved_callback;
    ha_gs_rejected_cb_t		*gs_protocol_rejected_callback;
    ha_gs_announcement_cb_t	*gs_announcement_callback;
    ha_gs_merge_cb_t		*gs_merge_callback;
} ha_gs_join_request_t;

typedef struct {
    ha_gs_num_phases_t		gs_num_phases;
    ha_gs_time_limit_t		gs_time_limit;
    ha_gs_state_value_t		gs_new_state;
} ha_gs_state_change_request_t;

typedef	struct {
    ha_gs_num_phases_t		gs_num_phases;
    ha_gs_time_limit_t		gs_time_limit;
    ha_gs_provider_message_t	gs_message;
} ha_gs_message_request_t;

typedef struct {
    ha_gs_num_phases_t		gs_num_phases;
    ha_gs_time_limit_t		gs_time_limit;
    unsigned int		gs_leave_code;
} ha_gs_leave_request_t;

typedef	struct {
    ha_gs_num_phases_t		gs_num_phases;
    ha_gs_time_limit_t		gs_time_limit;
    ha_gs_membership_t		gs_expel_list;
    int         		gs_deactivate_phase;
    char                        *gs_deactivate_flag;
} ha_gs_expel_request_t;

typedef struct  {
    ha_gs_subscription_ctrl_t   gs_subscription_control;
    ha_gs_group_name_t          gs_subscription_group;
    ha_gs_subscription_cb_t     *gs_subscription_callback;
} ha_gs_subscribe_request_t;

typedef	struct {
    ha_gs_num_phases_t		gs_num_phases;
    ha_gs_time_limit_t		gs_time_limit;
    ha_gs_group_attributes_t	*gs_group_attributes;
    ha_gs_membership_t		*gs_backlevel_providers;
} ha_gs_attribute_change_request_t;

#define gs_join_request		_gs_protocol_info._gs_join_request
#define gs_state_change_request	_gs_protocol_info._gs_state_change_request
#define gs_message_request	_gs_protocol_info._gs_message_request
#define gs_leave_request	_gs_protocol_info._gs_leave_request
#define gs_expel_request	_gs_protocol_info._gs_expel_request
#define gs_subscribe_request	_gs_protocol_info._gs_subscribe_request
#define gs_attribute_change_request     _gs_protocol_info._gs_attribute_change_request

typedef struct {
    union {
    ha_gs_join_request_t		_gs_join_request;
    ha_gs_state_change_request_t	_gs_state_change_request;
    ha_gs_message_request_t		_gs_message_request;
    ha_gs_leave_request_t		_gs_leave_request;
    ha_gs_expel_request_t		_gs_expel_request;
    ha_gs_subscribe_request_t           _gs_subscribe_request;
    ha_gs_attribute_change_request_t    _gs_attribute_change_request;
    } 	_gs_protocol_info;
} ha_gs_proposal_info_t;

typedef struct
{
    ha_gs_notification_type_t	gs_notification_type;
    ha_gs_token_t		gs_request_token;
    ha_gs_request_t		gs_protocol_type;
    ha_gs_rc_t			gs_delayed_return_code;
    ha_gs_proposal_info_t	*gs_failing_request;
    ha_gs_group_attributes_t    *old_group_attributes;
} ha_gs_delayed_error_notification_t;

typedef void (ha_gs_delayed_error_cb_t)(const ha_gs_delayed_error_notification_t*);

/* The following macro is for the compatibility to the previous versions */
   ha_gs_rc_t ha_gs_setup(int compiled_version, int argcount, 
			ha_gs_descriptor_t *descriptor_addr,
                      const ha_gs_socket_ctrl_t socket_control,
                      const ha_gs_responsiveness_t *responsiveness_control,
                      const char *deactivate_script,
                      ha_gs_responsiveness_cb_t *responsiveness_cb_addr,
                      ha_gs_delayed_error_cb_t *delayed_error_cb_addr,
                      ha_gs_query_cb_t *query_cb_addr, ...);
#ifndef _HA_GS_BUILD_COMPATIBLE_FUNCTION_
   /* This section will always be included for the applications */
   #ifdef __cplusplus
       inline ha_gs_rc_t ha_gs_init(ha_gs_descriptor_t *descriptor_addr,
		      const ha_gs_socket_ctrl_t socket_control,
                      const ha_gs_responsiveness_t *responsiveness_control,
                      const char *deactivate_script,
                      ha_gs_responsiveness_cb_t *responsiveness_cb_addr,
                      ha_gs_delayed_error_cb_t *delayed_error_cb_addr,
                      ha_gs_query_cb_t *query_cb_addr)
        {
                return ha_gs_setup(HA_GS_RELEASE, 7,
                       descriptor_addr,
                       socket_control,
                       responsiveness_control,
                       deactivate_script,
                       responsiveness_cb_addr,
                       delayed_error_cb_addr,
                       query_cb_addr);
        }
  #else
     #define ha_gs_init(a,b,c,d,e,f,g) ha_gs_setup(HA_GS_RELEASE,7,a,b,c,d,e,f,g)
  #endif
#endif

ha_gs_rc_t ha_gs_get_node_number(int *node_number);
ha_gs_rc_t ha_gs_get_limits(ha_gs_limits *limits);
ha_gs_rc_t ha_gs_get_adapter_info(ha_gs_adapter_info *adapter);
ha_gs_rc_t ha_gs_get_adapter_info_by_addr(const ha_gs_ip_addr *ip, ha_gs_adapter_info *adapter);
ha_gs_rc_t ha_gs_get_adapter_info_by_id(ha_gs_token_t _subscriber_token, const ha_gs_provider_t *_id, ha_gs_adapter_info *adapter);

ha_gs_rc_t ha_gs_get_ipaddr_by_id(ha_gs_token_t _subscriber_token, const ha_gs_provider_t *_id, ha_gs_ip_addr *_ip);

/* to change the responsiveness parameter */
ha_gs_rc_t ha_gs_change_responsiveness(const ha_gs_responsiveness_t *resp);

ha_gs_rc_t ha_gs_dispatch(const ha_gs_dispatch_flag_t);
ha_gs_rc_t ha_gs_join(ha_gs_token_t *,
		      const ha_gs_proposal_info_t *);

ha_gs_rc_t ha_gs_change_state_value(ha_gs_token_t,
				    const ha_gs_proposal_info_t *);

ha_gs_rc_t ha_gs_send_message(ha_gs_token_t,
				       const ha_gs_proposal_info_t *);

ha_gs_rc_t ha_gs_leave(ha_gs_token_t,
		       const ha_gs_proposal_info_t *);

ha_gs_rc_t ha_gs_expel(ha_gs_token_t,
		       const ha_gs_proposal_info_t *);

ha_gs_rc_t ha_gs_change_attributes(ha_gs_token_t,
                                   const ha_gs_proposal_info_t *);

ha_gs_rc_t ha_gs_goodbye(ha_gs_token_t);

ha_gs_rc_t ha_gs_vote(ha_gs_token_t,
		      ha_gs_vote_value_t,
		      const ha_gs_state_value_t *,
		      const ha_gs_provider_message_t *,
		      ha_gs_vote_value_t);

ha_gs_rc_t ha_gs_quit(void);

ha_gs_rc_t ha_gs_query_group_list(void);

ha_gs_rc_t ha_gs_query_group_info(const ha_gs_group_name_t);

ha_gs_rc_t ha_gs_subscribe(ha_gs_token_t *,
                           const ha_gs_proposal_info_t *);

ha_gs_rc_t ha_gs_unsubscribe(ha_gs_token_t);

void    ha_gs_copy_group_attributes(ha_gs_group_attributes_t *gAttrsTarg,
                                    ha_gs_group_attributes_t *gAttrsSrc);

ha_gs_rc_t ha_gs_get_ffdc_id(fc_eid_t fcid);
/*
 *------------------------------------------------------------------
 * Domain Events Handling 
 *------------------------------------------------------------------
 */

/* Node identifier: only 'node_number' is used for now */
typedef struct
{
    int32_t            node_number;     /* -1 if not used */
    uint32_t           node_epoch;      /* reserved for the future use */
    uint64_t           node_id;         /* reserved for the future use */
} ha_gs_node_spec_t;

/* node membership */
typedef struct
{
    unsigned int         gs_count;
    ha_gs_node_spec_t    *gs_nodes;
} ha_gs_node_membership_t;           /* Node membership List */


/*
 *---------------------------------------------------------------------------
 * The following domain event notifications can be notified.
 *  HA_GS_DOMAIN_DISCOVER  -- Internal use (Not be sent to other application)
 *  HA_GS_DOMAIN_MERGE     -- Internal use (Not be sent to other application)
 *  HA_GS_DOMAIN_VERSION   -- Whenever RSCT active/install version changes
 *  HA_GS_DOMAIN_NODE_CONFIG -- Whenever nodes are added/deleted
 *----------------------------------------------------------------------------
 */

typedef enum {
    HA_GS_DOMAIN_DISCOVER	= 1,
    HA_GS_DOMAIN_MERGE		= 2,
    HA_GS_DOMAIN_VERSION        = 3,       /* Active/install version change */
    HA_GS_DOMAIN_NODE_CONFIG    = 4       /* configuration is changed */
} ha_gs_domain_event_type_t;

/* Domain specification */
typedef struct {
    uint32_t            node_number;       /* NS node number/id */
    uint32_t            instance_id;       /* NS instance number */
    uint32_t            size;
} ha_gs_domain_spec_t;


/* HA_GS_DOMAIN_DISCOVER */
typedef struct {
    ha_gs_domain_spec_t   gs_domain;            /* my domain */
    ha_gs_ip_addr         ip_addr;		/* IPv4 IP address */
    unsigned int          instance_id;		/* TS instance number */
} ha_gs_domain_discover_info_t;

/* HA_GS_DOMAIN_MERGE */
typedef struct {
    ha_gs_domain_spec_t     gs_domain;           /* my domain */
    ha_gs_domain_spec_t     other_domain;        /* other domain */
    ha_gs_node_membership_t *gs_domain_members;    /* my domain's nodes */
    ha_gs_node_membership_t *other_domain_members; /* other domain's nodes */
} ha_gs_domain_merge_info_t;

/* HA_GS_DOMAIN_VERSION */
typedef struct {
    struct {
          uint16_t      version;
          uint16_t      release;
          uint16_t      modlevel;
          uint16_t      fixlevel;
    } vrmf;
    uint32_t            quick_version;    /* combined VRMF */
} ha_gs_rsct_version_t;

/* HA_GS_DOMAIN_NODE_CONFIG (Node configuration change) */
typedef struct {
    ha_gs_node_membership_t *current;
    ha_gs_node_membership_t *added;
    ha_gs_node_membership_t *removed;
} ha_gs_domain_membership_info_t;

/* Domain event notification */
typedef struct {
    ha_gs_notification_type_t           notification_type;   /* HA_GS_DOMAIN_NOTIFICATION */
    ha_gs_domain_event_type_t           domain_event_type;   /* domain event type */
    union {
        ha_gs_domain_discover_info_t    discover;       /* HA_GS_DOMAIN_DISCOVER */
        ha_gs_domain_merge_info_t       merge;          /* HA_GS_DOMAIN_MERGE */
        ha_gs_rsct_version_t            vers;           /* HA_GS_DOMAIN_VERSION */
        ha_gs_domain_membership_info_t  nodes;          /* HA_GS_DOMAIN_NODE_CONFIG */
    } info;
} ha_gs_domain_control_notification_t;  /* keep the same name for the compatibility */

typedef ha_gs_domain_control_notification_t ha_gs_domain_event_notification_t;
/* an alias type name */

/* IBM internal use */
ha_gs_rc_t ha_gs_dissolve_domain(const ha_gs_domain_spec_t *domain);

typedef void (ha_gs_domain_control_cb_t)(const ha_gs_domain_control_notification_t *notification);

/*--------------------------------------------------------------
 * InstalledVersion: it will always be the local RSCT version.
 * ActiveVersion: This will provide the current Peer Domain Active Version.
 *                Therefore, this will be NULL on non-peer domain environment.
 * Return NULL if not available.
 *--------------------------------------------------------------
 */
ha_gs_rc_t ha_gs_get_rsct_active_version(ha_gs_rsct_version_t *avn);
ha_gs_rc_t ha_gs_get_rsct_installed_version(ha_gs_rsct_version_t *ivn);


#ifdef __cplusplus
}                                       /* end extern "C" */
#endif

#endif                                  /* _HA_GS_H_ */
