/* IBM_PROLOG_BEGIN_TAG                                                   */
/* This is an automatically generated prolog.                             */
/*                                                                        */
/*                                                                        */
/*                                                                        */
/* Licensed Materials - Property of IBM                                   */
/*                                                                        */
/* (C) COPYRIGHT International Business Machines Corp. 1996,2008          */
/* All Rights Reserved                                                    */
/*                                                                        */
/* US Government Users Restricted Rights - Use, duplication or            */
/* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.      */
/*                                                                        */
/* IBM_PROLOG_END_TAG                                                     */
#ifndef _SAMPLE_UTILITY_H
#define _SAMPLE_UTILITY_H

static char *sample_utility_sccsid = "@(#)96   1.23   src/rsct/pgs/samples/sample_utility.h, gssamples, rsct_rfos, rfos0838a 7/16/07 21:26:57";

/*********************************************************************/
/*
 * Name:  sample_utility.h
 *
 * This program provides the declarations for the set of callback
 * functions used by the "sample_test" program.
 *
 * Components:
 *   sample_test.c - contains the main() function, supports interaction
 *      with the user, and most calls to the Group Services interfaces.
 *
 *   sample_utility.c - provides the definitions for the
 *      utility functions used by the sample_test program.
 *
 *   sample_callbacks.c - provides the definitions for the callback
 *      functions used for the groups created by this program.
 *
 *   sample_callbacks.h - declarations for the callback functions
 *      contained in sample_callbacks.c.
 *
 *   sample_utility.h - declarations for the utility functions contained
 *      in sample_utility.c
 *
 * The information here assumes that you are familiar with the information
 * presented in the IBM RSCT Group Services Programming Guide and Reference
 * manual.
 *
 * This program is provided for illustrative purposes only, and is not
 * intended to be an authoritative description of the "best" methods to
 * use when writing a Group Services application.  It is intended to
 * demonstrate the various interfaces in a relatively verbose manner,
 * and to allow you to relatively easily manipulate groups and their
 * members.
 *
 * To this end, various aspects of this program (in particular its
 * handling of screen input and output) are neither robust nor
 * foolproof.  Therefore, you should take care when giving input to
 * this program.
 */
/*********************************************************************/

/*********************************************************************/
/*
 * Include the Group Services declarations file.
 */
/*********************************************************************/
#include <time.h>
#include <sys/time.h>
#include <ha_gs.h>

extern  char   *time_now( );
extern  time_t  time_since( struct timeval *event );
extern  float   randomp( );
extern  long    randomn( unsigned long max );

#define ARBITRARY_STATE_VALUE   1
#define ARBITRARY_PROV_MESSAGE  2
extern  void    write_arbitrary_value(int which, void *value);

extern  char   *write_leave_reason(ha_gs_leave_reasons_t why);
extern  void    write_join_information(int gIndex);
extern  void    write_the_notification(int groupIdx,
                                       void * addr,
                                       ha_gs_notification_type_t whatItBe);
extern  void    write_the_proposal(ha_gs_request_t eReq,
                                   ha_gs_token_t   eTok,
                                   ha_gs_proposal_info_t *prop);
extern  void    write_the_attributes(ha_gs_group_attributes_t *gAttrs);

extern  ha_gs_token_t   gid[];
extern  ha_gs_token_t   big_msg_grpgid[];
extern  ha_gs_group_attributes_t       *gattr[];
extern  int             voting_phase;
extern  int             handledResponsiveness;
extern  int             instance_numbers[];

#define NUM_GROUPS 10 
#define NUM_GROUPS_FOR_SUBSCRIBE 36

#ifdef  _SAMPLE_TEST                    /* _SAMPLE_TEST */

extern  void    write_instructions(int _verbose);
extern  void    init_membership_subscriptions();
extern  ha_gs_rc_t      subscribe_to_a_group();
extern  ha_gs_rc_t      unsubscribe_from_a_group();
extern  ha_gs_token_t   get_group_token(int *gAddr);
extern  ha_gs_group_attributes_t *build_group_attributes(int _offset, int _changing);
extern  ha_gs_socket_ctrl_t      build_socket_control();
extern  char    *build_deact_script(char *default_deact);
extern  ha_gs_responsiveness_t   *construct_responsiveness(int interactive, ha_gs_responsiveness_t *def_resp);
extern  ha_gs_callback_rc_t       get_response(ha_gs_time_limit_t _time);
extern  int     build_leave_request(ha_gs_token_t *gToken, ha_gs_proposal_info_t *proposal);
extern  int     build_expel_request(ha_gs_token_t *gToken, ha_gs_proposal_info_t *proposal);
extern  int     build_state_change(ha_gs_token_t *gToken, ha_gs_proposal_info_t *proposal);
extern  int     build_attributes_change(ha_gs_token_t *gToken, ha_gs_proposal_info_t *proposal);
extern  int     build_goodbye_request(ha_gs_token_t *gToken);
extern  void    told_group_goodbye(ha_gs_token_t gToken);
extern  int     build_pbm(ha_gs_token_t *gToken, ha_gs_proposal_info_t *proposal);

extern  void    write_the_vote(ha_gs_vote_value_t vote);
extern  void    copy_the_attributes(int groupIdx,
                                    ha_gs_group_attributes_t *gAttrsTarg,
                                    ha_gs_group_attributes_t *gAttrsSrc);
extern  ha_gs_vote_value_t get_a_vote(int phase);
extern  void    create_state_and_pbm(int index,
                                     ha_gs_state_value_t **_sValue,
                                     ha_gs_provider_message_t **_pValue,
                                     ha_gs_state_value_t *_srcState,
                                     ha_gs_provider_message_t *_srcPBM);

void free_state_and_pbm(ha_gs_state_value_t *_sValue, ha_gs_provider_message_t *_pValue);
extern ha_gs_rc_t get_local_node_number();
extern ha_gs_rc_t get_adapter_info();
extern ha_gs_rc_t get_adapter_info_by_addr();
extern ha_gs_rc_t get_adapter_info_by_id();
extern ha_gs_rc_t get_ipaddr_by_id();
extern char *write_adapter_down_reason( ha_gs_adapter_death_t reason );
extern ha_gs_rc_t get_rsct_active_version();
extern ha_gs_rc_t get_rsct_installed_version();
extern ha_gs_rc_t send_a_big_message();
extern void write_vote_results( ha_gs_proposal_t *_proposal );

extern  char           *group_names[];
extern  char           *source_group_names[];
extern  char           *subNames[];
extern  char           *prov_local_names[];
extern  int             instance_numbers2[];
extern  ha_gs_vote_value_t              default_vote_array[];
extern  int             in_group[];
extern  int             in_group_count;
extern  const   int     num_groups;

extern  int             sample_index;
extern  char           *sample_prefix;
extern  int             sample_prefix_len;

extern  char           *sample_pp;
extern  char           *sample_ee;

extern  char           *starz;
extern  int             verbose;
extern  int             interactiveInit;
extern  int             interactiveResponse;
extern  int		act_as_domain_master;

#define NUMBER_MSG_ENTRIES 8

extern char * getNumericStringSuffix(char * pBegin, uint32_t * pResult);
extern char * getFilename(char * pPath);

#endif                                  /* ifdef _SAMPLE_TEST */

#endif                                  /* _SAMPLE_UTILITY_H */
