/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.logging.ErrorManager;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.apache.harmony.logging.internal.nls.Messages;

public abstract class Handler {
    private static final Level DEFAULT_LEVEL = Level.ALL;
    private ErrorManager errorMan = new ErrorManager();
    private String encoding = null;
    private Level level = DEFAULT_LEVEL;
    private Formatter formatter = null;
    private Filter filter = null;
    private String prefix = this.getClass().getName();

    protected Handler() {
    }

    private Object getDefaultInstance(String string) {
        Object var2_2 = null;
        if (null == string) {
            return var2_2;
        }
        try {
            var2_2 = Class.forName(string).newInstance();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return var2_2;
    }

    private Object getCustomizeInstance(final String string) throws Exception {
        Class clazz = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

            @Override
            public Class<?> run() throws Exception {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (null == classLoader) {
                    classLoader = ClassLoader.getSystemClassLoader();
                }
                return classLoader.loadClass(string);
            }
        });
        return clazz.newInstance();
    }

    void printInvalidPropMessage(String string, String string2, Exception exception) {
        String string3 = Messages.getString("logging.12") + this.prefix + ":" + string + "/" + string2;
        this.errorMan.error(string3, exception, 0);
    }

    void initProperties(String string, String string2, String string3, String string4) {
        String string5;
        String string6;
        LogManager logManager = LogManager.getLogManager();
        String string7 = logManager.getProperty(this.prefix + ".filter");
        if (null != string7) {
            try {
                this.filter = (Filter)this.getCustomizeInstance(string7);
            }
            catch (Exception exception) {
                this.printInvalidPropMessage("filter", string7, exception);
                this.filter = (Filter)this.getDefaultInstance(string2);
            }
        } else {
            this.filter = (Filter)this.getDefaultInstance(string2);
        }
        if (null != (string6 = logManager.getProperty(this.prefix + ".level"))) {
            try {
                this.level = Level.parse(string6);
            }
            catch (Exception exception) {
                this.printInvalidPropMessage("level", string6, exception);
                this.level = Level.parse(string);
            }
        } else {
            this.level = Level.parse(string);
        }
        if (null != (string5 = logManager.getProperty(this.prefix + ".formatter"))) {
            try {
                this.formatter = (Formatter)this.getCustomizeInstance(string5);
            }
            catch (Exception exception) {
                this.printInvalidPropMessage("formatter", string5, exception);
                this.formatter = (Formatter)this.getDefaultInstance(string3);
            }
        } else {
            this.formatter = (Formatter)this.getDefaultInstance(string3);
        }
        String string8 = logManager.getProperty(this.prefix + ".encoding");
        try {
            this.internalSetEncoding(string8);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.printInvalidPropMessage("encoding", string8, unsupportedEncodingException);
        }
    }

    public abstract void close();

    public abstract void flush();

    public abstract void publish(LogRecord var1);

    public String getEncoding() {
        return this.encoding;
    }

    public ErrorManager getErrorManager() {
        LogManager.getLogManager().checkAccess();
        return this.errorMan;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public Formatter getFormatter() {
        return this.formatter;
    }

    public Level getLevel() {
        return this.level;
    }

    public boolean isLoggable(LogRecord logRecord) {
        if (null == logRecord) {
            throw new NullPointerException();
        }
        if (this.level.intValue() == Level.OFF.intValue()) {
            return false;
        }
        if (logRecord.getLevel().intValue() >= this.level.intValue()) {
            return null == this.filter || this.filter.isLoggable(logRecord);
        }
        return false;
    }

    protected void reportError(String string, Exception exception, int n) {
        this.errorMan.error(string, exception, n);
    }

    void internalSetEncoding(String string) throws UnsupportedEncodingException {
        if (null == string) {
            this.encoding = null;
        } else if (Charset.isSupported(string)) {
            this.encoding = string;
        } else {
            throw new UnsupportedEncodingException(Messages.getString("logging.13", string));
        }
    }

    public void setEncoding(String string) throws SecurityException, UnsupportedEncodingException {
        LogManager.getLogManager().checkAccess();
        this.internalSetEncoding(string);
    }

    public void setErrorManager(ErrorManager errorManager) {
        LogManager.getLogManager().checkAccess();
        if (null == errorManager) {
            throw new NullPointerException();
        }
        this.errorMan = errorManager;
    }

    public void setFilter(Filter filter) {
        LogManager.getLogManager().checkAccess();
        this.filter = filter;
    }

    void internalSetFormatter(Formatter formatter) {
        if (null == formatter) {
            throw new NullPointerException();
        }
        this.formatter = formatter;
    }

    public void setFormatter(Formatter formatter) {
        LogManager.getLogManager().checkAccess();
        this.internalSetFormatter(formatter);
    }

    public void setLevel(Level level) {
        if (null == level) {
            throw new NullPointerException();
        }
        LogManager.getLogManager().checkAccess();
        this.level = level;
    }
}

