/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.apache.harmony.logging.internal.nls.Messages;

public class MemoryHandler
extends Handler {
    private static final int DEFAULT_SIZE = 1000;
    private Handler target;
    private int size = 1000;
    private Level push = Level.SEVERE;
    private final LogManager manager = LogManager.getLogManager();
    private LogRecord[] buffer;
    private int cursor;

    public MemoryHandler() {
        String string;
        Object object;
        String string2 = this.getClass().getName();
        final String string3 = this.manager.getProperty(string2 + ".target");
        try {
            object = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction<Class<?>>(){

                @Override
                public Class<?> run() throws Exception {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    if (classLoader == null) {
                        classLoader = ClassLoader.getSystemClassLoader();
                    }
                    return classLoader.loadClass(string3);
                }
            });
            this.target = (Handler)((Class)object).newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException(Messages.getString("logging.10", string3));
        }
        object = this.manager.getProperty(string2 + ".size");
        if (null != object) {
            try {
                this.size = Integer.parseInt((String)object);
                if (this.size <= 0) {
                    this.size = 1000;
                }
            }
            catch (Exception exception) {
                this.printInvalidPropMessage(string2 + ".size", (String)object, exception);
            }
        }
        if (null != (string = this.manager.getProperty(string2 + ".push"))) {
            try {
                this.push = Level.parse(string);
            }
            catch (Exception exception) {
                this.printInvalidPropMessage(string2 + ".push", string, exception);
            }
        }
        this.initProperties("ALL", null, "java.util.logging.SimpleFormatter", null);
        this.buffer = new LogRecord[this.size];
    }

    public MemoryHandler(Handler handler, int n, Level level) {
        if (n <= 0) {
            throw new IllegalArgumentException(Messages.getString("logging.11"));
        }
        handler.getLevel();
        level.intValue();
        this.target = handler;
        this.size = n;
        this.push = level;
        this.initProperties("ALL", null, "java.util.logging.SimpleFormatter", null);
        this.buffer = new LogRecord[n];
    }

    @Override
    public void close() {
        this.manager.checkAccess();
        this.target.close();
        this.setLevel(Level.OFF);
    }

    @Override
    public void flush() {
        this.target.flush();
    }

    @Override
    public synchronized void publish(LogRecord logRecord) {
        if (!this.isLoggable(logRecord)) {
            return;
        }
        if (this.cursor >= this.size) {
            this.cursor = 0;
        }
        this.buffer[this.cursor++] = logRecord;
        if (logRecord.getLevel().intValue() >= this.push.intValue()) {
            this.push();
        }
    }

    public Level getPushLevel() {
        return this.push;
    }

    @Override
    public boolean isLoggable(LogRecord logRecord) {
        return super.isLoggable(logRecord);
    }

    public void push() {
        int n;
        for (n = this.cursor; n < this.size; ++n) {
            if (null != this.buffer[n]) {
                this.target.publish(this.buffer[n]);
            }
            this.buffer[n] = null;
        }
        for (n = 0; n < this.cursor; ++n) {
            if (null != this.buffer[n]) {
                this.target.publish(this.buffer[n]);
            }
            this.buffer[n] = null;
        }
        this.cursor = 0;
    }

    public void setPushLevel(Level level) {
        this.manager.checkAccess();
        level.intValue();
        this.push = level;
    }
}

