/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Date;
import java.util.ResourceBundle;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;

public class XMLFormatter
extends Formatter {
    private static final String lineSeperator = LogManager.getSystemLineSeparator();
    private static final String indent = "    ";

    @Override
    public String format(LogRecord logRecord) {
        long l = logRecord.getMillis();
        String string = MessageFormat.format("{0, date} {0, time}", new Date(l));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<record>").append(lineSeperator);
        stringBuilder.append(indent).append("<date>").append(string).append("</date>").append(lineSeperator);
        stringBuilder.append(indent).append("<millis>").append(l).append("</millis>").append(lineSeperator);
        stringBuilder.append(indent).append("<sequence>").append(logRecord.getSequenceNumber()).append("</sequence>").append(lineSeperator);
        if (null != logRecord.getLoggerName()) {
            stringBuilder.append(indent).append("<logger>").append(logRecord.getLoggerName()).append("</logger>").append(lineSeperator);
        }
        stringBuilder.append(indent).append("<level>").append(logRecord.getLevel().getName()).append("</level>").append(lineSeperator);
        if (null != logRecord.getSourceClassName()) {
            stringBuilder.append(indent).append("<class>").append(logRecord.getSourceClassName()).append("</class>").append(lineSeperator);
        }
        if (null != logRecord.getSourceMethodName()) {
            stringBuilder.append(indent).append("<method>").append(logRecord.getSourceMethodName()).append("</method>").append(lineSeperator);
        }
        stringBuilder.append(indent).append("<thread>").append(logRecord.getThreadID()).append("</thread>").append(lineSeperator);
        this.formatMessages(logRecord, stringBuilder);
        Object[] objectArray = logRecord.getParameters();
        if (objectArray != null) {
            for (Object object : objectArray) {
                stringBuilder.append(indent).append("<param>").append(object).append("</param>").append(lineSeperator);
            }
        }
        this.formatThrowable(logRecord, stringBuilder);
        stringBuilder.append("</record>").append(lineSeperator);
        return stringBuilder.toString();
    }

    private void formatMessages(LogRecord logRecord, StringBuilder stringBuilder) {
        ResourceBundle resourceBundle = logRecord.getResourceBundle();
        String string = logRecord.getMessage();
        if (null != resourceBundle && null != string) {
            String string2;
            try {
                string2 = resourceBundle.getString(string);
            }
            catch (Exception exception) {
                string2 = null;
            }
            if (string2 == null) {
                string2 = string;
                stringBuilder.append(indent).append("<message>").append(string2).append("</message>").append(lineSeperator);
            } else {
                stringBuilder.append(indent).append("<message>").append(string2).append("</message>").append(lineSeperator);
                stringBuilder.append(indent).append("<key>").append(string).append("</key>").append(lineSeperator);
                stringBuilder.append(indent).append("<catalog>").append(logRecord.getResourceBundleName()).append("</catalog>").append(lineSeperator);
            }
        } else if (null != string) {
            stringBuilder.append(indent).append("<message>").append(string).append("</message>").append(lineSeperator);
        } else {
            stringBuilder.append(indent).append("<message/>");
        }
    }

    private void formatThrowable(LogRecord logRecord, StringBuilder stringBuilder) {
        Throwable throwable = logRecord.getThrown();
        if (throwable != null) {
            StackTraceElement[] stackTraceElementArray;
            stringBuilder.append(indent).append("<exception>").append(lineSeperator);
            stringBuilder.append(indent).append(indent).append("<message>").append(throwable.toString()).append("</message>").append(lineSeperator);
            for (StackTraceElement stackTraceElement : stackTraceElementArray = throwable.getStackTrace()) {
                stringBuilder.append(indent).append(indent).append("<frame>").append(lineSeperator);
                stringBuilder.append(indent).append(indent).append(indent).append("<class>").append(stackTraceElement.getClassName()).append("</class>").append(lineSeperator);
                stringBuilder.append(indent).append(indent).append(indent).append("<method>").append(stackTraceElement.getMethodName()).append("</method>").append(lineSeperator);
                stringBuilder.append(indent).append(indent).append(indent).append("<line>").append(stackTraceElement.getLineNumber()).append("</line>").append(lineSeperator);
                stringBuilder.append(indent).append(indent).append("</frame>").append(lineSeperator);
            }
            stringBuilder.append(indent).append("</exception>").append(lineSeperator);
        }
    }

    @Override
    public String getHead(Handler handler) {
        String string = null;
        if (null != handler) {
            string = handler.getEncoding();
        }
        if (null == string) {
            string = XMLFormatter.getSystemProperty("file.encoding");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"").append(string).append("\" standalone=\"no\"?>").append(lineSeperator);
        stringBuilder.append("<!DOCTYPE log SYSTEM \"logger.dtd\">").append(lineSeperator);
        stringBuilder.append("<log>");
        return stringBuilder.toString();
    }

    @Override
    public String getTail(Handler handler) {
        return "</log>";
    }

    private static String getSystemProperty(final String string) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(string);
            }
        });
    }
}

