#!/bin/bash
# This is the script used to start the Console Trace
#
#  Module History:
#   -01  09/15/2006 K. Schroeder  Initial release.

# Check if the person is remotely logged in, if so set DISPLAY variable.
#
LOG_PTS=`tty | sed 's@/dev/@@'`

LOG_HOST=`who | grep "$LOG_PTS " | grep "(" | cut -f2 -d '(' | cut -f1 -d')' | cut -f1 -d':'`
if [[ -n $LOG_HOST && -z $DISPLAY ]]; then
 export DISPLAY=$LOG_HOST:0
fi

if [[ -z $DISPLAY ]]; then
 # if no value is set, use DISPLAY for regular mode, and do
 # not use hostname b/c its faster
 export DISPLAY=":0.0"
fi

# Add the CCFW code to the classpath
if [ -z "${CLASSPATH}" ]; then
   export CLASSPATH=/opt/ccfw/ccfw.jar;
else
   export CLASSPATH=${CLASSPATH}:/opt/ccfw/ccfw.jar
fi

# Change the current directory to /opt/ccfw and start trace.
cd /opt/ccfw
/opt/ccfw/runtask trace
