#!/bin/sh
#
# Purpose:
#   This script is used to run all of the registration scripts in the
#   current directory.
#
#   Registration will take place only if a marker file is present.  The
#   marker file will be removed during the registration process so that
#   registration occurs only once.
#
#   The base tower script is run first.  Then all other scripts in the
#   current directory (with the exception of this one and the preregistration
#   script) are run.
#****************************************************************************

marker="cimregister"
basescript="cimregisterbase.sh"

# If the marker file is not present, we don't have to do anything.
if [ -e ${marker} ]; then
  actzTrace "CIMOMRGT: -> cimregister.sh"
  # If there is a base tower script, run it first.
  if [ -e ${basescript} ]; then
    sh ${basescript} registration
  fi
  # Now run the rest of the scripts in this directory
  ls *.sh | grep -v cimregister.sh | grep -v cimpreregister.sh | grep -v ${basescript} | xargs -i+ sh + registration

  # Reenable the HTTPS and SLP ports
  cimconfig -pu enableHttpsConnection
  #cimconfig -ps slp=true

  # Restart Pegasus (To pick up new HTTPS and SLP definitions)
  echo "Stopping the CIM Server"
  cimserver -s
  echo "Starting the CIM Server"
  cimserver

  # Remove the marker file.
  rm -f ${marker}
  actzTrace "CIMOMRGT: <- cimregister.sh"
fi
