#!/bin/bash

# copymediafiles.sh
#
# Usage: copymediafiles.sh <mount point> <medium name> <tmploc>
#
# 00  10/06/2006  J. Kunz  Initial release, copy files off one piece of media to another

MOUNTPOINT=$1
MEDIUMNAME=$2
TMPLOC=$3
ANSWER="N"

# ensure we got all parameters
if [ -n "$TMPLOC" ]; then

   TMPLOC="$TMPLOC/copymediafiles"

	# look for the mount point in /etc/fstab
	PATTERN=`echo $MOUNTPOINT | sed -e 's?/?\\\/?g'`
	DEVICEFILE=`cat /etc/fstab | sed -e "/$PATTERN/!d" -e 's/ .*//1' `
	
	if [ -n "$DEVICEFILE" ]; then
	
		echo ""
		echo "You have requested to copy files from one piece of $MEDIUMNAME medium to"
		echo "another piece of $MEDIUMNAME medium at mount point $MOUNTPOINT,"
		echo "using $TMPLOC as the temporary staging area."
		echo "The files on the source piece of medium will be copied AS-IS to"
		echo "the target piece of medium, so if the files are corrupted on"
		echo "the source medium, they will still be corrupted on the target piece of medium."
		echo ""
		echo "The files will replace any files on the target medium with the same name"
		echo "and location, so for the target medium you may want to consider using"
		echo "a new piece of medium which you have recently formatted on this console."
		echo ""
		echo "Do you wish to proceed (Y/N)?"
		read ANSWER
		
		if [ "$ANSWER" == "y" ]; then
			ANSWER="Y"
		fi
		
		if [ "$ANSWER" == "Y" ]; then
		    echo "Please insert the source $MEDIUMNAME medium from which the files should be copied."
		    echo "Is the medium ready and do you wish to proceed (Y/N)?"
		    read ANSWER

		    if [ "$ANSWER" == "y" ]; then
        		 ANSWER="Y"
        	 fi


         if [ "$ANSWER" == "Y" ]; then

            # try to mount the source media
            if mount $MOUNTPOINT; then
               echo ""
               echo "Source $MEDIUMNAME medium successfully mounted,"
	            echo "copying files to temporary location $TMPLOC."

               # ensure there are no files out there from a previous attempt
               rm -Rf "$TMPLOC" > /dev/null 2>&1
               # ensure the folder exists
               mkdir $TMPLOC > /dev/null 2>&1

               if /bin/sh -c "cp -rvp $MOUNTPOINT/* $TMPLOC"; then
                  echo ""
                  echo "Copy from source $MEDIUMNAME to temporary location $TMPLOC succeeded."
                  ANSWER="Y"
               else
                  echo ""
                  echo "Copy from source $MEDIUMNAME to temporary location $TMPLOC failed,"
                  echo "but some files may have still copied."
                  echo "Here is what is in the temporary location:"
                  ls -al $TMPLOC

                  echo ""
                  echo "Do you wish to proceed to copy these to the target medium anyway (Y/N)?"
                  read ANSWER

                  if [ "$ANSWER" == "y" ]; then
                     ANSWER="Y"
                  fi
               fi

               if umount $MOUNTPOINT; then
                  if [ "$ANSWER" == "Y" ]; then
                     if [ "$MOUNTPOINT" == "/media/cdrom" ]; then
                        eject $mountpoint
                     fi
                     echo ""
                     echo "Please insert the target $MEDIUMNAME medium to which the files should be copied."
                     echo "Is the medium ready and do you wish to proceed (Y/N)?"
                     read ANSWER

                     if [ "$ANSWER" == "y" ]; then
                        ANSWER="Y"
                     fi

                     if [ "$ANSWER" == "Y" ]; then

                        # try to mount the source media
                        if mount $MOUNTPOINT; then
                           echo ""
                           echo "Target $MEDIUMNAME medium successfully mounted, copying files from temporary location $TMPLOC."

                           if ! /bin/sh -c "cp -rvp $TMPLOC/* $MOUNTPOINT"; then
                              echo ""
                              echo "Copy to target $MEDIUMNAME failed, but some files may have still copied."
                              echo "Here is what is on the target $MEDIUMNAME:"
                              ls -R $MOUNTPOINT
                           else
                              echo ""
                              echo "Copy to target $MEDIUMNAME succeeded, unmounting $MOUNTPOINT."
                           fi

                           if ! umount $MOUNTPOINT; then
                              echo ""
                              echo "unmount of $MOUNTPOINT with target $MEDIUMNAME failed."
                           fi
                           if [ "$MOUNTPOINT" == "/media/cdrom" ]; then
                              eject $mountpoint
                           fi
                        else
                           echo ""
                           echo "Mount $MOUNTPOINT for target $MEDIUMNAME failed, unable to proceed."
                        fi
                     fi
                  fi
               else
                     echo ""
                     echo "unmount of $MOUNTPOINT with source $MEDIUMNAME failed, unable to proceed."
               fi

               # ensure there are no files out there for next attempt
               rm -Rf "$TMPLOC" > /dev/null 2>&1

            else
               echo ""
               echo "Mount $MOUNTPOINT for source $MEDIUMNAME failed, unable to proceed."
            fi
         fi
       fi
		
	else
      echo ""
	   echo "Error, unable to determine the $MEDIUMNAME device location"
	   echo "from /etc/fstab using $MOUNTPOINT!"
	fi
else
   echo "Error, missing parameter(s)."
   echo "Usage is: copymediafiles <mount point> <medium name> <temp location for files>"
   echo " for example: copymediafiles /media/cdrom DVDRAM /console/ffdc"
fi
echo "Press Enter Key to exit"
read ANSWER
exit
