#!/bin/bash

actzTrace "XSETNETT: -> createFirewallChain $*"

if [ -x /sbin/iptables ]; then
    iptables=/sbin/iptables
elif [ -x /usr/sbin/iptables ]; then
    iptables=/usr/sbin/iptables
else
    actzTrace "XSETNETF: createFirewallChain: No 'iptables' executable found"
    exit 0
fi

if lsmod | grep -q "ipv6"; then
    if [ -x /sbin/ip6tables ]; then
        ip6tables=/sbin/ip6tables
    elif [ -x /usr/sbin/ip6tables ]; then
        ip6tables=/usr/sbin/ip6tables
    else
        actzTrace "XSETNETF: createFirewallChain: No 'ip6tables' executable found.. this is weird"
    fi
else
    actzTrace "XSETNETF: createFirewallChain: No IPv6 support"
fi


$iptables --new $1 && \
$iptables --insert INPUT --in-interface "$2" --jump $1
rc=$?

if [ -n "$ip6tables" ]; then
    actzTrace "XSETNETF: createFirewallChain: creating chain in ip6tables"
    $ip6tables --new $1 && \
    $ip6tables --insert INPUT --in-interface "$2" --jump $1
    src=$?
fi

if [ "$rc" = "0" ]; then
    rc="$src"
fi

actzTrace "XSETNETT: <- createFirewallChain: rc=$rc"

exit $rc
