#!/bin/bash

actzTrace "XSETNETT: editFirewallChain $*"

op=$1
chain=$2
ifname=$3
protocol=$4
sourceAddr=$5
sourceAddrMask=$6
port=$7
isIPv6=$8

if [ "$isIPv6" = "true" ]; then
    if ! lsmod | grep -q "ipv6"; then
        actzTrace "XSETNETF: editFirewallChain: no IPv6 support."
        exit 0
    fi

    if [ -x /sbin/ip6tables ]; then
        iptables=/sbin/ip6tables
    elif [ -x /usr/sbin/ip6tables ]; then
        iptables=/usr/sbin/ip6tables
    else
        actzTrace "XSETNETF: editFirewallChain: No ip6tables executable found."
        exit 0
    fi
else
    if [ -x /sbin/iptables ]; then
        iptables=/sbin/iptables
    elif [ -x /usr/sbin/iptables ]; then
        iptables=/usr/sbin/iptables
    else
        actzTrace "XSETNETF: editFirewallChain: No iptables executable found."
        exit 0
    fi
fi

if [ "$protocol" = "icmp" ]; then
    if [ "$isIPv6" != "true" ]; then
        cmd="$iptables $op $chain --in-interface \"$ifname\" --protocol $protocol --source $sourceAddr/$sourceAddrMask --icmp-type $port --jump ACCEPT --verbose"
        actzTrace "XSETNETF: executing cmd: '$cmd'"
        eval $cmd
        rc=$?
    else
        actzTrace "XSETNETF: editFirewallChain: ICMP is not valid for IPv6."
        rc=0
    fi
elif echo $port | grep ","; then
    ports=$(echo $port | sed -e "s/,/ /g")
    for port in $ports; do
        cmd="$iptables $op $chain --in-interface \"$ifname\" --protocol $protocol --source $sourceAddr/$sourceAddrMask --destination-port $port --jump ACCEPT --verbose"
        actzTrace "XSETNETF: executing cmd: '$cmd'"
        eval $cmd
        rc=$?
        if [ "$rc" != "0" ]; then
            exit $rc
        fi
    done
else
    cmd="$iptables $op $chain --in-interface \"$ifname\" --protocol $protocol --source $sourceAddr/$sourceAddrMask --destination-port $port --jump ACCEPT --verbose"
    actzTrace "XSETNETF: executing cmd: '$cmd'"
    eval $cmd
    rc=$?
fi

actzTrace "XSETNETF: <- editFirewallChain: rc=$rc"

exit $rc
