#!/bin/bash

actzTrace "XSETFWAT: -> flushFirewallChain"

if [ -x /sbin/iptables ]; then
    iptables=/sbin/iptables
elif [ -x /usr/sbin/iptables ]; then
    iptables=/usr/sbin/iptables
else
    actzTrace "XSETFWAF: flushFirewallChain: No iptables executable found."
    exit 0
fi

if lsmod | grep -q "ipv6"; then
    if [ -x /sbin/ip6tables ]; then
        ip6tables=/sbin/ip6tables
    elif [ -x /usr/sbin/ip6tables ]; then
        ip6tables=/usr/sbin/ip6tables
    else
        actzTrace "XSETNETF: flushFirewallChain: No 'ip6tables' executable found.. this is ok"
    fi
else
    actzTrace "XSETNETF: flushFirewallChain: No IPv6 support"
fi

$iptables --flush $1
rc=$?

if [ -n "$ip6tables" ]; then
    actzTrace "XSETNETF: flushFirewallChain: flushing chain in ip6tables"
    $ip6tables --flush $1
    src=$?
fi

if [ "$rc" = "0" ]; then
    rc="$src"
fi

actzTrace "XSETFWAT: <- flushFirewallChain: rc=$rc"

exit $rc
