#!/bin/bash
#
# Collect HMC EED
#
# Description: Issue to Collect HMC EED for the machinne
#
# Change Activity:
#   05/08/2006 Dovin       - initial version collect hmc eed code level and connected systems
#   10/19/2006 Dovin       - change lshmc to not go through command router 572913
#   12/07/2007 Brocious    - Remove unit-test type echo commands (they clutter up ccfw.out)
#
#STARTUSAGE
#
# Usage:
#   hmceed.sh -l palock
#
# Where:
#   -l   lock
#
#
#ENDUSAGE
#****************************************************************************
noopt=1
giveUsage=0

# Parse the options
while getopts 'l:?' optname; do
   case "$optname" in
      l) palock="$OPTARG";;
      \?) giveUsage=1; break;;
   esac
   noopt=0
done


if [ "$giveUsage" -eq 1 ]; then
   # Print out the prologue's usage comments as usage info
   sed -e '/STARTUSAGE/,/ENDUSAGE/ s/^#//' -e '1,/STARTUSAGE/ d' -e '/ENDUSAGE/,$ d' "$0"
   exit 0
fi

if [ "$noopt" -eq 1 ]; then
   # Print out all prologue comments
   sed -e '1 d' -e '2,/ENDUSAGE/ s/^#//' -e '/ENDUSAGE/,$ d' "$0"
   exit 0
fi

me=$(basename $0)  # Name of this script, with no path information

# ------------------------------------
# find necessary archiving directories
# ------------------------------------

# attempt to locate hmcfunctions script
if [ -z "$CONSOLE_PATH" ]; then
   CONSOLE_PATH="$HWMCAHOME/"
fi
FOUND=
for FUNCDIR in "" "$CONSOLE_PATH/" "$CONSOLE_PATH/native/scripts/"; do
   . ${FUNCDIR}hmcfunctions >/dev/null 2>&1 && FOUND=true && break 1
done
if [ -z "$FOUND" ]; then
   echo "$me: Error: Could not locate hmcfunctions script file!" >&2
   exit 2
fi

# find locations and names of archiving files
CONFIG_FILE="`queryFileLocation eeddirectory`"
if [ ! -e $CONFIG_FILE ]; then
   echo "$me: Error: Could not locate eeddirectory !" >&2
   exit 6
fi

# collect base information for hmc eed
tmpfile=${CONFIG_FILE}${palock}tmphmc.eed  # Temp work file
realfile=${CONFIG_FILE}hmc.eed             # Our real output file

echo "About to issue: /opt/hsc/bin/lshmc -V" > $tmpfile
/opt/hsc/bin/lshmc -V  >> $tmpfile 2>&1
echo "About to issue: /opt/hsc/bin/lssysconn -r all" >> $tmpfile
/opt/hsc/bin/lssysconn -r all >> $tmpfile 2>&1

# copy our temp file to its real name and location
echo "About to issue: mv $tmpfile $realfile" >> $tmpfile
mv $tmpfile $realfile >> $tmpfile 2>&1
rc=$?
if [ $rc -ne 0 ]; then
   echo "$me: mv failed with rc=$rc; see $tmpfile"
fi
exit $rc
