#!/bin/bash

# lockdevicedoor.sh
#
# Usage: lockdevicedoor.sh <command> <device file> <log file>
#
# Return Codes:
# 1 - Error locking the device door
#
# Author: C. Schuck
#
#  03/17/2005  P. Provost  Fixed tracing

COMMAND=$1
DEVICEFILE=$2
LOGFILE=$3

# Start log
echo "-> lockdevicedoor.sh" >> $LOGFILE
actzTrace "XMDA   T: -> lockdevicedoor.sh"

echo "lockdevicedoor.sh: (Un)locking device door for `date`" >> $LOGFILE
actzTrace "XMDA   F: lockdevicedoor.sh: (Un)locking device door for `date`"

# (Un)lock the device door
if ! $COMMAND $DEVICEFILE >> $LOGFILE 2>&1; then

    echo "lockdevicedoor.sh: Couldn't (un)lock the device door...exiting" >> $LOGFILE
    actzTrace "XMDA   F: lockdevicedoor.sh: Couldn't (un)lock the device door...exiting"

    echo "<- lockdevicedoor.sh for `date`" >> $LOGFILE
    echo "" >> $LOGFILE

    actzTrace "XMDA   T: <- lockdevicedoor.sh for `date`"

    exit 1
fi

echo "<- lockdevicedoor.sh for `date`" >> $LOGFILE
echo "" >> $LOGFILE

actzTrace "XMDA   T: <- lockdevicedoor.sh for `date`"

exit 0

