<%--
 This JSP is responsible for submitting client information that we might
 find useful on the server.  The information is as follows:

  1. Available screen width, the value of the JavaScript Screen.availWidth property.
  2. Available screen height, the value of the JavaScript Screen.availHeight property.
  3. A sample of the client's Date.toString() output, to help the server deduce
     what time zone the client is running in.
  4. A flag indicating whether or not the client appears to observe
     daylight-saving-time rules.
  5. Some information on the browser geometry that we deduce by opening a
     test window with known content and measuring the results.

 The "Connect" servlet dispatches to this page when the user is starting a new
 session with the HMC, but we have not retrieved client information yet.

 For determining whether or not the client appears to observe
 daylight-saving-time rules, we ask the browser what timezone offset would be
 used now, 3 months from now, 6 months from now, and 9 months from now.  If
 the current offset is different from any of those, we assume the client
 observes daylight-saving-time rules.  This should be a safe test for most
 locales.

 This is is also the first place that tries to open a new browser window, so is
 likely to be the first window.open() failure observed if a browser setting
 prevents the opening of "popup" windows.  We try to detect this by looking for
 a null response to window.open().  In this case, we modify the page so the
 user is informed about the failure and given the options to try again or
 cancel.
--%>

<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@taglib prefix="hmc" uri="/WEB-INF/hmc.tld"%>

<fmt:bundle basename="com.ibm.hwmca.fw.servlet.connect.res.connect">
<html>
<head>
   <hmc:title><fmt:message key="fetchingwindowtitle"/></hmc:title>
   <meta http-equiv="Cache-Control" content="no-cache">
   <link href='<%=application.getAttribute("hmcStyleSheet")%>' rel="stylesheet" type="text/css"/>
   <script type="text/javascript">
      var windowInfo = {};

      function sendInformation() {
         var now = new Date();
         var tzNow = now.getTimezoneOffset();
         var tz3months = new Date(now.getTime()+7889400000).getTimezoneOffset();    // 3 months from now
         var tz6months = new Date(now.getTime()+15778800000).getTimezoneOffset();   // 6 months from now
         var tz9months = new Date(now.getTime()+23668200000).getTimezoneOffset();   // 9 months from now
         var usesDST = tzNow != tz3months || tzNow != tz6months || tzNow != tz9months;

         var extras="";
         for (prop in windowInfo) {
            extras+="&"+prop+"="+encodeURIComponent(windowInfo[prop]);
         }

         window.location.replace("/hmc/connect?<c:out value='${reqparms}' escapeXml='false'/>availableScreenSize="+
                                 screen.availWidth+","+screen.availHeight+
                                 "&tzOffset="+tzNow+
                                 "&time="+now.getTime()+
                                 "&timeString="+encodeURIComponent(now.toTimeString())+
                                 "&usesDST="+usesDST+extras);
      }

      var timeoutTimer;

      function gatherInformation() {
         var measurementWin = window.open("/hmc/connects/measureWindowInfo.jsp",
                                          "measuring",
                                          "height=200,width=300,top=150,left=150,scrollbars,resizable");
         if (measurementWin == null) {
            // Probably popups are disabled.  Reveal the error message and
            // buttons that are on the page, but not currently visible to the
            // user.  Also hide the "fetching client info" message.
            try {
               document.getElementById("normalMsg").style.visibility = "hidden";
               document.getElementById("continueLink").style.visibility = "visible";
            } catch (e) {}
            return;
         }

         measurementWin.blur();     // Make it less noticeable

         // Wait for the answers.  If none received in 4 seconds, send our info.
         timeoutTimer = window.setTimeout(sendInformation, 4000);
      }

      function captureWindowInfo(name, value) {
         windowInfo[name] = value;
      }

      function measurementsComplete() {
         window.clearInterval(timeoutTimer);
         sendInformation();
      }

      function tryGatheringAgain() {
         try {
            document.getElementById("normalMsg").style.visibility = "visible";
            document.getElementById("continueLink").style.visibility = "hidden";
         } catch (e) {}

         gatherInformation();
      }

      function cancelLogon() {
         window.location.replace("/hmc/connect?proceed=no");
      }
   </script>
</head>
<body onload="gatherInformation()">
<p id="normalMsg">
<fmt:message key="sendingClientInfo"/>
</p>
<div id="continueLink" style="visibility: hidden;">
<%--
 This section will be made visible if it is discovered that popup windows are
 disabled.  It provides an error message and a button the user can use after
 enabling popups to continue, and a button that cancels the logon instead.
--%>
<p>
<fmt:message key='failedToOpenTestWindow'/>
</p>
<p>
<button type="button" onclick="tryGatheringAgain();"
        class="b1" onmouseout="className='b1'"
        onmouseover="className='b2'" />
<fmt:message key="continueButtonLabel"/>
</button>

<button type="button" onclick="cancelLogon();"
        class="b1" onmouseout="className='b1'"
        onmouseover="className='b2'" />
<fmt:message key="cancelButtonLabel"/>
</button>
</p>
</div>
</body>
</html>
</fmt:bundle>
