<%--
 This JSP is responsible for measuring certain elements of a browser window
 for the particular browser the user is using:

  1. The width of the vertical scrollbar.
  1. The height of the horizontal scrollbar.
  2. The total width of window decorations added by the browser/windowing system.
  2. The total height of window decorations added by the browser/windowing system.
  3. A scaling factor for the width indicating how much wider the window
     should be in order to view the text.  We use this to judge the difference
     between the fonts used by the user and the ones assumed for purposes of
     specifying window sizes in the markup.
  4. A scaling factor for the height.

 The fetchClientInfo.jsp opens a window containing this jsp in order to make
 measurements.  It's done in a new window so that we can know the location on
 the screen of the window and the size we specified on the window.open().
--%>

<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@taglib prefix="hmc" uri="/WEB-INF/hmc.tld"%>

<fmt:bundle basename="com.ibm.hwmca.fw.servlet.connect.res.connect">
<html>
<head>
   <hmc:title><fmt:message key="measuringWindowTitle"/></hmc:title>
   <meta http-equiv="Cache-Control" content="no-cache">
   <link href='<%=application.getAttribute("hmcStyleSheet")%>' rel="stylesheet" type="text/css"/>
   <script type="text/javascript">
      function doMeasurements() {
         var w = window.opener;

         try {
            if ("screenX" in window) {
               // This is a Firefox-like browser (includes Opera)
               w.captureWindowInfo("vScrollWidth", window.innerWidth - document.body.clientWidth);
               w.captureWindowInfo("hScrollHeight", window.innerHeight - document.body.clientHeight);
               w.captureWindowInfo("decorWidth", window.outerWidth - window.innerWidth);
               w.captureWindowInfo("decorHeight", window.outerHeight - window.innerHeight);
               w.captureWindowInfo("scaleWidth", document.body.scrollWidth+","+document.body.clientWidth);
               w.captureWindowInfo("scaleHeight", document.body.scrollHeight+","+document.body.clientHeight);

            } else if ("screenLeft" in window) {
               // This is an IE-like browser
               var vScrollWidth = 300 - document.body.clientWidth;
               var hScrollHeight = 200 - document.body.clientHeight;
               w.captureWindowInfo("vScrollWidth", vScrollWidth);
               w.captureWindowInfo("hScrollHeight", hScrollHeight);

               // IE requires some correction to these values.  Thus adjustments by 2.
               var leftDecoWidth = window.screenLeft - 150 + 2;
               var topDecoHeight = window.screenTop - 150 + 2;
               w.captureWindowInfo("contentAreaOffset", leftDecoWidth+","+topDecoHeight);
                  // We report this only on systems that don't support screenX and screenY

//             w.captureWindowInfo("decorWidth", leftDecoWidth * 2);
//             w.captureWindowInfo("decorHeight", topDecoHeight + leftDecoWidth);
               w.captureWindowInfo("scaleWidth", document.body.scrollWidth+","+document.body.clientWidth);
               w.captureWindowInfo("scaleHeight", document.body.scrollHeight+","+document.body.clientHeight);

               // Sadly, IE makes it hard to figure out the height of the bottom
               // decorations, so we go to the lengths of resizing the test
               // window and looking to see how much the client area shrunk.
               var oldWidth = document.body.clientWidth;
               var oldHeight = document.body.clientHeight;
               // The window.resizeTo() calls treats the specified sizes as
               // being what is desired for the outer window dimensions (as
               // opposed to window.open(), which treats the specified sizes
               // as being the size of the content area.  We can use this
               // difference to figure out the sizes of the decorations.
               window.resizeTo(oldWidth, oldHeight);
               w.captureWindowInfo("decorWidth", oldWidth - document.body.clientWidth - vScrollWidth);
               w.captureWindowInfo("decorHeight", oldHeight - document.body.clientHeight - hScrollHeight);

            } else {
               // This isn't a browser we recognize.  Send no info.  Defaults will be used.
            }

            w.measurementsComplete();

         } catch (e) {
            // Ignore any exceptions that occur processing this
         }

         window.close();
      }
   </script>
</head>
<body onload="doMeasurements()">
<fmt:message key="measuringWindowMessage"/>
<%--
 The following text is English, but does not need translation.
 It is used for measurement purposes only, and is not seen by the user.
 Note that changes to this text might require changes to any panel markup
 that already specifies a panel size, if
 TaskWindowPositionManager.SCALE_TASK_WINDOWS is true.
--%>
<span style="visibility: hidden;">
<hmc:banner bannerTitleIcon="/hmc.png" bannerTitle="Panel Title"/>
<pre class="txt">
The quick brown fox jumps over the lazy dog.&nbsp; The quick brown fox jumps over the lazy dog.
M
M
M
M
M
M
M
</pre>
</span>
</body>
</html>
</fmt:bundle>
