<%--
 This jsp is used by ActivityMonitor.java to "re-submit" a POST request.
 It's basically an HTTP redirect that includes re-submitting the form data
 that was submitted in the original HTTP POST request.  It is used in place of
 an actual HTTP redirect if the HTTP request being processed used a POST.
--%>

<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@taglib prefix="hmc" uri="/WEB-INF/hmc.tld"%>

<%@page session="false"%>   <%-- prevent a session from being created --%>

<%!
   // Encode each character as an HTML numeric character reference, to make
   // sure that UNICODE characters get sent back to the server properly when
   // the form is submitted.
   private String escapeValue(String value) {
     int len = value.length();
     StringBuilder result = new StringBuilder(len * 5);
     for (int i=0; i<len; ++i) {
        result.append("&#");
        result.append((int) value.charAt(i));
        result.append(";");
     }

     return result.toString();
   }
%>

<fmt:bundle basename="com.ibm.hwmca.fw.servlet.connect.res.connect">
<html>
<head>
   <meta http-equiv="Cache-Control" content="no-cache">
   <hmc:title><fmt:message key="resubmittingTitle"/></hmc:title>
   <link href='<%=application.getAttribute("hmcStyleSheet")%>' rel="stylesheet" type="text/css"/>

   <script type="text/javascript">
      function submitForm() {
         document.forms.resubmit.submit();
      }
   </script>
</head>
<body onload="submitForm()">
<fmt:message key="resubmittingMessage"/>
<%--
 The browsers we've tested all seem to ignore the enctype attribute (at least
 the charset part of it) and submit the form with just the
 application/x-www-form-urlencoded value, but we specify it anyway as it still
 seems like the right thing to do.
--%>
<form name="resubmit" action="${redirectURL}" method="post" enctype="application/x-www-form-urlencoded;charset=UTF-8">
   <c:forEach var="parmset" items="${pageContext.request.parameterMap}">
      <c:forEach var="parmValue" items="${parmset.value}">
         <input type="hidden" name="${parmset.key}" value="<%=escapeValue((String) pageContext.getAttribute("parmValue"))%>" />
      </c:forEach>
   </c:forEach>
</form>
</body>
</html>
</fmt:bundle>
