<%--
 This is the HMC Login page.  It is presented to the user when they try to
 access a protected resource.  We could have used the WCL library to produce
 this page, but since it's very simple, we choose not too.  However, in order
 to make the page look like a WCL page, we reference their style sheet and
 include <span> tags and "class" attributes that mimic their pages.
--%>

<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@taglib prefix="hmc" uri="/WEB-INF/hmc.tld"%>
<%@ page contentType="text/html; charset=UTF-8" %>

<fmt:bundle basename="com.ibm.hwmca.fw.servlet.login.res.login">
<html>
<head>
    <hmc:title>
      <%=request.getAttribute("title")%>
    </hmc:title>
   <link href='<%=application.getAttribute("hmcStyleSheet")%>' rel="stylesheet" type="text/css"/>
   <link rel="SHORTCUT ICON" href="/favicon.ico"/>
   <link rel="icon" href="/hmc.png" type="image/png"/>
    <style>
       .welcomeBodyClass {
           background-image: url(/preloginmonitor/welcomeBackground.png);
       }
    </style>
</head>
<%
  String bodyDir = java.awt.ComponentOrientation.getOrientation(request.getLocale()).isLeftToRight() ? "ltr" : "rtl";
  pageContext.setAttribute("bodyDir", bodyDir);
  String div1style="display: block";
  String div2style="display: none";
  String userAgent = request.getHeader("USER-AGENT");
  if ((userAgent != null) && (userAgent.toLowerCase().indexOf("opera") != -1 || userAgent.toLowerCase().indexOf("msie") != -1)) {
	  div1style="display: none";
	  div2style="display: block";	  
  }
%>
<body onload="if ('<%=div1style%>'=='display: block') {window.document.LoginForm.j_username.focus()};" class="welcomeBodyClass" dir="<c:out value='${bodyDir}'/>">
<span class="cont1">
<table width="100%" cellspacing="0" cellpadding="0"><tr><td>
<hmc:banner bannerTitleIcon="/images/fw/logon.gif" bannerTitle='<%= (String) request.getAttribute("title") %>'/>
</td></tr></table>
<div id="div1" style="<%=div1style%>">
<p><fmt:message key="introduction"/></p>

<c:if test="${!empty errorPage}">
<p>
<font color="red">
<c:out value="${customMessage}" escapeXml="false">
 <fmt:message key="loginErrorMessage"/>
</c:out>
</font>
</p>
</c:if>

<form name="LoginForm" method="POST" action="j_security_check" >
 <table>
  <tr>
   <td><fmt:message key="useridLabel"/>:</td>
   <td><input type="text" class="te1" name="j_username" maxlength="320"></td>
  </tr>
  <tr>
   <td><fmt:message key="passwordLabel"/>:</td>
   <td><input type="password" class="te1" name="j_password"></td>
  </tr>
 </table>
 <p>
 <input type="submit" value="<fmt:message key='loginButtonLabel'/>" name="j_security_check"
        class="b1" onmouseout="className='b1'"
        onmouseover="className='b2'" />
 <input type="submit" value="<fmt:message key='cancelButtonLabel'/>" name="j_security_check"
        class="b1" onmouseout="className='b1'"
        onmouseover="className='b2'" onclick="window.location.replace('/index.html'); return false;" />
 <hmc:helpButton book="base" topic="com/ibm/hwmca/base/logon/res/LogonRes/HMCLogonPanel"/>
 </p>
</form>
</div>
<div id="div2" style="<%=div2style%>">
<script type='text/javascript'>var jvmInfo="unknown";</script>
<p><fmt:message key="loading"/><applet archive="/applets/jvmapplet2.jar" code="com.ibm.hwmca.fw.servlet.preloginmonitor.applet.CheckJVMApplet2" width="1" height="1" MAYSCRIPT></applet>
</p>
<form name="LoginForm2" method="POST" action="j_security_check" >
 <p>
 <input type="submit" value="<fmt:message key='cancelButtonLabel'/>" name="j_security_check"
        class="b1" onmouseout="className='b1'"
        onmouseover="className='b2'" onclick="window.location.replace('/index.html'); return false;" />
 <hmc:helpButton book="base" topic="com/ibm/hwmca/base/logon/res/LogonRes/HMCLogonPanel"/>
 </p>
</form>
</div>
</span>
</body>

</html>
</fmt:bundle>
