<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN"
"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<!--<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">-->

<!--
/*********************************************************** {COPYRIGHT-TOP} ***
 * Licensed materials - Property of IBM
 * Tivoli Presentation Services
 *
 * (C) Copyright IBM Corp. 2003
 *
 * US Government Users Restricted Rights - Use, duplication, or
 * disclosure restricted by GSA ADP Schedule Contract with
 * IBM Corp.
<%--
 * Module History:
 * 06/19/2006  JMiller      Initial Release
 * 06/26/2006  JMiller      Added Table Resizing js
 * 08/03/2006  JMiller      Add viewOrder wui-config param support
 * 08/09/2006  JMiller      Error on invalid view_order param
 * 08/10/2006  JMiller      show/hide workarea icons support
 * 10/24/2006  JMiller      add asyncjsonrefresh.js to handle workarea refreshes for ajax updates
 * 01/09/2007  JMiller      Update BonsaiUserSettings through SettingsRetriever
 * 03/21/2007  J. Miller    Add js to set resize cursor when along nav/workarea frame border
 * 06/25/2007  J. Miller    Don't resize description column; let page scroll if needed
 * 06/25/2007  K Tong       Add version info popup
 * 11/07/2007  K Tong       Add show_workarea_icons parameter support
 * 05/30/2008  J. Miller    664120 - rename hmcversion css filename and class
--%> *
 ************************************************************ {COPYRIGHT-END} ****/
-->
<%@taglib prefix="wcl" uri="/WEB-INF/WCLTagLib.tld"%>
<%@taglib prefix="hmc" uri="/WEB-INF/hmc.tld"%>
<%@taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>

<%@ page import="java.util.Iterator,
                 java.util.HashSet,
                 java.util.List,
                 java.util.Map,
                 java.util.Set,

                 com.ibm.hwmca.fw.managed.User,
                 com.ibm.hwmca.fw.servlet.util.HMCSession,
                 com.ibm.hwmca.fw.settings.user.BonsaiUserSettings,
                 com.ibm.hwmca.fw.ui.UIInfo,
                 com.ibm.hwmca.fw.util.LocalizableText,
                 com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeManager,
                 com.ibm.hwmca.ui.bonsai.earth.BonsaiTreeNode,
                 com.ibm.hwmca.ui.bonsai.servlet.util.UserObject,
                 com.ibm.hwmca.ui.bonsai.taskscape.CategorizedTaskBean,
                 com.ibm.hwmca.ui.bonsai.taskscape.CategorizedTasksModel,
                 com.ibm.hwmca.ui.bonsai.taskscape.CategoryBean,
                 com.ibm.hwmca.ui.bonsai.util.GraphicsConstants,
                 com.ibm.hwmca.ui.bonsai.util.SettingsRetriever,
                 com.ibm.hwmca.ui.bonsai.servlet.ControllerServlet,
                 com.ibm.hwmca.ui.bonsai.servlet.WorkareaAction,
                 com.ibm.hwmca.fw.servlet.util.ServletRuntime"%>

<fmt:bundle basename="com.ibm.hwmca.ui.bonsai.res.bonsai">

<%!
    public static final String FRAME_NAME                     = "hmccattasks_frame";
    public static final String PARAM_NAME_VIEW                = "taskView";
    public static final String TASKS_VIEW_ORDER_ALPHABETICAL  = "alphabeticalView";
    public static final String TASKS_VIEW_ORDER_CATEGORIZED   = "categorizedView";

    private static final String BUNDLE_NAME = "com/ibm/hwmca/ui/bonsai/res/bonsai";
    private static final LocalizableText LINK_TEXT_ALPHABETICAL    = new LocalizableText( BUNDLE_NAME, "categorizedtasks.alphabeticalview.title" ),
                                         LINK_ALTTEXT_ALPHABETICAL = new LocalizableText( BUNDLE_NAME, "categorizedtasks.alphabeticalview.alt" ),
                                         LINK_TEXT_CATEGORIZED     = new LocalizableText( BUNDLE_NAME, "categorizedtasks.categorizedview.title" ),
                                         LINK_ALTTEXT_CATEGORIZED  = new LocalizableText( BUNDLE_NAME, "categorizedtasks.categorizedview.alt" );

    private static final Set supportedViewOrders;

    static {
      supportedViewOrders = new HashSet(2);
      supportedViewOrders.add(TASKS_VIEW_ORDER_ALPHABETICAL);
      supportedViewOrders.add(TASKS_VIEW_ORDER_CATEGORIZED);
    }
%>

<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">

<!-- ===========================================================================
  This JSP is a view.  That is, the WclFacade and all data is defined inside a
  controller Servlet.
  ========================================================================== -->

<%
    // attach the user context to this thread
    ServletRuntime.getRuntime().attachUserContextToServletThread(request);

    // get the user's session data
    HMCSession hmcSession = HMCSession.getHMCSession(session);
    UserObject userObj = UserObject.getUserObject(hmcSession);
    String id = userObj.getTreeSelection();
    BonsaiTreeNode node = null;
    String key = id;
    if ((node=BonsaiTreeManager.getBonsaiTreeManager().getTreeNode(id)) != null)
    {
       key = node.getWorkarea();
    }
    final String KEY = key;
%>

<%
  String bodyDir = java.awt.ComponentOrientation.getOrientation(request.getLocale()).isLeftToRight() ? "ltr" : "rtl";
  pageContext.setAttribute("bodyDir", bodyDir);
%>

<head>
<link href="/css/ui/bonsai/categorizedtasks.css" rel="stylesheet" type="text/css"/>
<link href="/css/ui/bonsai/hmcversion.css" rel="stylesheet" type="text/css"/>

<script src="/js/ui/bonsai/nodrag.js" type="text/javascript"></script>
<script src="/js/ui/bonsai/utilities.js" type="text/javascript"></script>
<script src="/js/ui/bonsai/navcursor.js" type="text/javascript"></script>
<script src="/js/ui/bonsai/categorizedtasks.js" type="text/javascript"></script>
<script src="/js/ui/bonsai/asyncjsonrefresh.js" type="text/javascript"></script>

</head>

<%
    // get the model, creating it if this is the first request by the session
    synchronized(session)
    {
        if (hmcSession.getSessionAttribute(KEY) == null)
        {
            CategorizedTasksModel ctModel = new CategorizedTasksModel( KEY, userObj );
            hmcSession.setSessionAttribute(KEY, ctModel);

            //add listeners
            userObj.addTreeSelectionListener(ctModel);
            userObj.addUserObjectListener(ctModel);
        }
    }

    Map params = WorkareaAction.getURIParams(node.getWorkarea());
    boolean paramError = false;

    //show HMC Version popup?
    String showHmcVersionParam = (String)params.get("hmc_version");
    boolean showHmcVersion = Boolean.valueOf(showHmcVersionParam).booleanValue();
    if ( showHmcVersionParam == null ) {
        showHmcVersion = false;
    } else if ( !( showHmcVersionParam.equals("true") || showHmcVersionParam.equals("false") ) ) {
        out.write("<p>The optional 'hmc_version' param must be 'true' or 'false' (not '" + showHmcVersionParam + "') for " + KEY + "!</p>");
        paramError = true;
    }

    //get jsp used to display popup (defined in wui-config)
    String showHmcVersionJspParam = null;
    if ( showHmcVersion ) {
        showHmcVersionJspParam = (String)params.get("hmc_version_jsp");
        if ( showHmcVersionJspParam == null ) {
            out.write("<p>The 'hmc_version_jsp' param is required and must define the JSP to be used to display the HMC Version Popup if hmc_version='true'.  Value is currently '" + showHmcVersionParam + "' for " + KEY + "!</p>");
            paramError = true;
        }
    }

    //show viewOrder toggle link?
    String viewOrderParam = (String)params.get("view_order");
    boolean showViewOrder = false;
    if ( viewOrderParam == null ) {
        showViewOrder = true;
    } else if ( !supportedViewOrders.contains(viewOrderParam) ) {
        out.write("<p>The optional 'view_order' param must be '" + TASKS_VIEW_ORDER_ALPHABETICAL + "' or '" + TASKS_VIEW_ORDER_CATEGORIZED + "' (not '" + viewOrderParam + "') for " + KEY + "!</p>");
        paramError = true;
    }

    //get/set view order
    BonsaiUserSettings bonsaiSettings = SettingsRetriever.getBonsaiUserSettings( hmcSession );
    String viewOrder = (String)request.getParameter(PARAM_NAME_VIEW);
    boolean newView = false;
    if ( showViewOrder == false ) {
        viewOrder = viewOrderParam;
    } else if ( !supportedViewOrders.contains(viewOrder) ) {
        viewOrder = bonsaiSettings.getCategorizedTasksView(KEY);
        if ( !supportedViewOrders.contains(viewOrder) ) {
            newView = true;
            viewOrder = TASKS_VIEW_ORDER_CATEGORIZED;
        }
    } else {
        newView = true;
    }
    if ( newView ) {
        bonsaiSettings.setCategorizedTasksView(KEY, viewOrder);
        SettingsRetriever.setBonsaiUserSettings(bonsaiSettings, hmcSession);
    }

    //show workarea icons?
    boolean showWorkareaIcons = false;
    if ( params.containsKey("show_workarea_icons") ) {
    	String showIconsParam = (String)params.get("show_workarea_icons");
    	if ( showIconsParam.equalsIgnoreCase("true") ) {
    		showWorkareaIcons = true;
    	} else if( showIconsParam.equalsIgnoreCase("false") ) {
    		showWorkareaIcons = false;
    	} else {
    		out.write("The 'show_workarea_icons' paramater must be set to either 'true' or 'false'");
            paramError = true;
    	}
    } else {
    	showWorkareaIcons = bonsaiSettings.isShowWorkareaIcons();
    }

    // retrieve the body style info
    StringBuffer bodyStyle = new StringBuffer();
    if ((node=BonsaiTreeManager.getBonsaiTreeManager().getTreeNode(id)) != null)
    {
        try
        {
            Map.Entry style = null;
            for (Iterator i = WorkareaAction.getURIStyle(node.getWorkarea()).entrySet().iterator(); i.hasNext(); )
            {
                style = (Map.Entry)i.next();
                bodyStyle.append((String)style.getKey());
                bodyStyle.append(": ");
                bodyStyle.append((String)style.getValue());
                if (i.hasNext())
                {
                    bodyStyle.append("; ");
                }
            }
        }
        catch (IllegalArgumentException iaEx)
        {
            // workarea must have changed since we were asked to render, so ignore
        }
    }


    if ( !paramError ) {
%>
        <body style="<%= bodyStyle.toString() %>" onmousemove="navOnMouseMove('west');" onmouseout="navOnMouseOut();" dir="<c:out value='${bodyDir}'/>">
        <div id="bodyOuterDiv">
        <div id="bodyInnerDiv">
        <c:set var="showIcons" scope="page"><%=showWorkareaIcons%></c:set>
<%
        CategorizedTasksModel ctModel = (CategorizedTasksModel)(HMCSession.getHMCSession(session).getSessionAttribute(KEY));

        //root tasks
        List rootTasks = null;
        if ( viewOrder.equals(TASKS_VIEW_ORDER_CATEGORIZED) ) {
            rootTasks = ctModel.getRootTasks();
        } else {
            rootTasks = ctModel.getAlphabeticalTaskList();
        }
        Iterator ctIter = (Iterator)rootTasks.iterator();

        // create the TitledLayout that contains the page title
        UIInfo uiInfo = BonsaiTreeManager.getBonsaiTreeManager().getTreeNode( userObj.getTreeSelection() ).getUIInfo();

        String linkText = null;
        String linkMo = null;
        if ( viewOrder.equals(TASKS_VIEW_ORDER_CATEGORIZED) ) {
            linkText = LINK_TEXT_ALPHABETICAL.toString(request.getLocale());
            linkMo = LINK_ALTTEXT_ALPHABETICAL.toString(request.getLocale());
        } else {
            linkText = LINK_TEXT_CATEGORIZED.toString(request.getLocale());
            linkMo = LINK_ALTTEXT_CATEGORIZED.toString(request.getLocale());
        }
%>
        <table width="100%">
            <tr>
<%
            if ( showHmcVersion ) {
%>
                <td><table><tr><td><span class="ct_title"><%= uiInfo.getName( userObj.getLocale() ).replace( '\n', ' ' ) %></span></td>
                <td>&nbsp;&nbsp;(&nbsp;<jsp:include page="<%= showHmcVersionJspParam %>"></jsp:include>&nbsp;)</td></tr></table>
                </td>
<%
            } else {
%>

                <td class="ct_title"><%= uiInfo.getName( userObj.getLocale() ).replace( '\n', ' ' ) %></td>


<%			}
            if ( showViewOrder ) {
%>
                <td class="ct_order"><span>[<a target="workarea_frame" href="workarea.do?<%= PARAM_NAME_VIEW %>=<%= viewOrder.equals(TASKS_VIEW_ORDER_CATEGORIZED) ? TASKS_VIEW_ORDER_ALPHABETICAL : TASKS_VIEW_ORDER_CATEGORIZED %>" title="<%= linkMo %>"><%= linkText %></a>]</span></td>
<%
            } else {
%>
                <td></td>
<%
            }
%>
            </tr>
        </table>

        <table class="ct_tbl" id="ct_tbl">
            <tr>
<%
        if ( rootTasks.size() > 0 ) {
%>
            <tr class="ct_rootspacer"><td colspan="2"><img src="<%= GraphicsConstants.getTransparentIcon() %>" /></td></tr>
<%
            CategorizedTaskBean ctBean = null;
            while( ctIter.hasNext() ) {
                ctBean = (CategorizedTaskBean)ctIter.next();
                if ( ctBean == null ) {
                    //spacer
%>
                        <tr class="ct_taskspacer"><td colspan="2"><img src="<%= GraphicsConstants.getTransparentIcon() %>" /></td></tr>
<%
                } else {
%>
                        <tr onmouseover="this.style.backgroundColor='#eee';" onmouseout="this.style.backgroundColor='';">
                        <td class="ct_taskname"><span><c:if test="${showIcons}"><a href="<%= ctBean.getUrl() %>" title="<%= ctBean.getName() %>" alt="<%= ctBean.getName() %>" ><img border="0" width="16" height="16" src="<%= ctBean.getIcon() %>" /></a></c:if><a href="<%= ctBean.getUrl() %>" title="<%= ctBean.getName() %>" alt="<%= ctBean.getName() %>" ><%= ctBean.getName() %></a></span></td>
                        <td class="ct_taskdesc"><span title="<%= ctBean.getCaption() %>"><img border="0" width="16" height="16" src="<%= GraphicsConstants.getMiddotImageIcon() %>" /><%= ctBean.getCaption() %></span></td>
                    </tr>
<%
                }//endIfElse
            }//endWhile
        }//endIf

        if ( viewOrder.equals(TASKS_VIEW_ORDER_CATEGORIZED) ) {
            //categories
            List categories = ctModel.getCategories();
            if ( categories.size() > 0 ) {
                Iterator catIter = categories.iterator();

                CategoryBean catBean = null;
                while( catIter.hasNext() ) {
                    catBean = (CategoryBean)catIter.next();

                    //append category tasks if they exist
                    if ( catBean.getTaskCount() > 0 ) {
%>
                        <tr class="ct_category"><td colspan="2" title="<%= catBean.getName() %>"><%= catBean.getName() %></td></tr>
                        <tr class="ct_catspacer"><td colspan="2"><img src="<%= GraphicsConstants.getTransparentIcon() %>" /></td></tr>
<%
                        ctIter = catBean.getTasks();
                        CategorizedTaskBean ctBean = null;
                        while( ctIter.hasNext() ) {
                            ctBean = (CategorizedTaskBean)ctIter.next();
                            if ( ctBean == null ) {
                                //spacer
%>
                                <tr class="ct_taskspacer"><td colspan="2"><img src="<%= GraphicsConstants.getTransparentIcon() %>" /></td></tr>
<%
                            } else {
%>
                                <tr onmouseover="this.style.backgroundColor='#eee';" onmouseout="this.style.backgroundColor='';">
                                    <td class="ct_taskname"><span><c:if test="${showIcons}"><a href="<%= ctBean.getUrl() %>" title="<%= ctBean.getName() %>" alt="<%= ctBean.getName() %>" ><img border="0" width="16" height="16" src="<%= ctBean.getIcon() %>" /></a></c:if><a href="<%= ctBean.getUrl() %>" title="<%= ctBean.getName() %>" alt="<%= ctBean.getName() %>" ><%= ctBean.getName() %></a></span></td>
                                    <td class="ct_taskdesc"><span title="<%= ctBean.getCaption() %>"><img border="0" width="16" height="16" src="<%= GraphicsConstants.getMiddotImageIcon() %>" /><%= ctBean.getCaption() %></span></td>
                                </tr>
<%
                            }//endIfElse
                        }//endWhile
                    }//endIf
                }//endWhile
            }//endIf
        }//endIf

%>
        </table>
<%
    }
%>
</div>
</div>
</body>

</html>

</fmt:bundle>
