/*
 * (c)  Copyright  IBM Corp.  1999, 2006  All Rights Reserved
 *
 *
 * US Government Users Restricted Rights - Use, duplication or
 * disclosure restricted by GSA ADP Schedule Contract with IBM Corp
 *
 * Notes:
 * js file used to persist tree style ui frame sizes
 *
 * Module History:
 *   08/30/2005   J. Miller    Properly submit tasks_frame size after initial resize
 *   08/30/2006   J. Miller    AJAX rowsPerView updating support
 *   09/18/2006   J. Miller    only set auto rpv if table was initally configured for auto table height
 *   11/13/2006   J. Miller    kick up frame size updates using AJAX
 */

var navFrameSize_ = null;
var tasksFrameSize_ = null;
var waFrameSize_ = null;

//setInitialFrameSizes - store initial frame dimensions, neded for IE workaround to limit frame size servlet calls
// -in: none
//-out: none, sets global frame size variables
function setInitialFrameSizes() {
  var userAgent = navigator.userAgent.toLowerCase();
  var isIE = ( userAgent.indexOf( "msie" ) != -1 ) && (!(( navigator.userAgent.indexOf("Opera") !=-1 ) && ( navigator.userAgent.indexOf("MSIE") !=-1)));

  //globals only used in IE
  if ( !isIE ) {
    return;
  }

  try {
    var frame  = window.top.hmcmainui.navigation_frame;
    if ( frame && frame.document && frame.document.body ) {
      navFrameSize_ = isIE ? frame.document.body.clientWidth : frame.innerWidth;
    }
  } catch (e) {
  }

  try {
    var frame = window.top.hmcmainui.workarea_frame.frames[0];
    if ( frame && frame.document && frame.document.body ) {
      waFrameSize_ = isIE ? frame.document.body.clientHeight : frame.innerHeight;
    }
  } catch (e) {
  }

  try {
    var frame = window.top.hmcmainui.workarea_frame.frames[1];
    if ( frame && frame.document && frame.document.body ) {
      tasksFrameSize_ = isIE ? frame.document.body.clientHeight : frame.innerHeight;
    }
  } catch (e) {
  }
}


//saveFrameDimensionsAjax - submit dimensions for known frames to server with ajax enabled
// -in: e           - event which triggered this method
//      ieOnly      - if true, only perform the action for IE Browser, otherwise
//                    perform the action for all browsers.  onResize events aren't
//                    thrown for our frames in IE due to the TaskController frame, so
//                    IE on load/unload events are generated to trigger frame size events
//-out: none, frame size form submitted if needed
function saveFrameDimensionsAjax(e, ieOnly) {
  var userAgent = navigator.userAgent.toLowerCase();
  var isIE = ( userAgent.indexOf( "msie" ) != -1 ) && (!(( navigator.userAgent.indexOf("Opera") !=-1 ) && ( navigator.userAgent.indexOf("MSIE") !=-1)));

  if ( ieOnly && !isIE ) {
    return;
  }

  var navFrameSize = null;
  var tasksFrameSize = null;
  var waFrameSize = null;
  e = window.event;

  var url = "/hmc/ui/bonsai/frames.do";
  var params = "";

  //navigation frame
  try {
    var inputName = "navigation_frame";
    var frame  = window.top.hmcmainui.navigation_frame;

    if ( frame && frame.document && frame.document.body && frame.document.body.clientWidth ) {
      navFrameSize = frame.document.body.clientWidth;
      params = addParam(params, inputName, navFrameSize);
    }
  } catch (e) {
  }

  //*_workarea_frame
  try {
    var inputName = "workarea_frame";
    var frame = window.top.hmcmainui.workarea_frame.frames[0];

    if ( frame && frame.document && frame.document.body && frame.document.body.clientHeight ) {
      waFrameSize = frame.document.body.clientHeight;
      params = addParam(params, inputName, waFrameSize);
    }
  } catch (e) {
  }

  //tasks_frame
  try {
    var inputName = "tasks_frame";
    var frame = window.top.hmcmainui.workarea_frame.frames[1];

    if ( frame && frame.document && frame.document.body && frame.document.body.clientHeight ) {
      tasksFrameSize = frame.document.body.clientHeight;
      params = addParam(params, inputName, tasksFrameSize);
    }
  } catch (e) {
  }

  //document.appendChild( form );
  if ( !isIE
    || navFrameSize_   != navFrameSize
    || waFrameSize_    != waFrameSize
    || tasksFrameSize_ != tasksFrameSize
     )
  {
    try {
      new AsyncJson( url + params,
                     function(json) {
                       return true;
                     }
      );
    } catch( e ) {
    }

    navFrameSize_   = navFrameSize;
    waFrameSize_    = waFrameSize;
    tasksFrameSize_ = tasksFrameSize;

    return true;
  }
}


//saveFrameDimensions - submit dimensions for known frames to server
// -in: e      - event which triggered this method
//      ieOnly - if true, only perform the action for IE Browser, otherwise
//               perform the action for all browsers.  onResize events aren't
//               thrown for our frames in IE due to the TaskController frame, so
//               IE on load/unload events are generated to trigger frame size events
//-out: none, frame size form submitted if needed
function saveFrameDimensions(e, ieOnly) {
  var userAgent = navigator.userAgent.toLowerCase();
  var isIE = ( userAgent.indexOf( "msie" ) != -1 ) && (!(( navigator.userAgent.indexOf("Opera") !=-1 ) && ( navigator.userAgent.indexOf("MSIE") !=-1)));

  if ( ieOnly && !isIE ) {
    return;
  }

  var navFrameSize = null;
  var tasksFrameSize = null;
  var waFrameSize = null;
  var submitMe = false;
  e = window.event;

  var formName = "frameSizeForm";
  var form = document.forms[formName];
  if ( form == null ) {
    form = document.createElement( "FORM" );
    with ( form ) {
      name   = formName;
      id     = formName;
//      action = "/hmc/frames";
      action = "/hmc/ui/bonsai/frames.do";
      method = "POST";
    }
  }

  //navigation frame
  try {
    var inputName = "navigation_frame";
    var frame  = window.top.hmcmainui.navigation_frame;
    var input  = document.getElementById( inputName );

    if ( frame && frame.document && frame.document.body && frame.document.body.clientWidth ) {
      navFrameSize = frame.document.body.clientWidth;
      if ( !input ) {
        input = document.createElement( "INPUT" );
        with ( input ) {
          type  = "hidden";
          id    = inputName;
          name  = inputName;
        }
        form.appendChild( input );
      }
      input.value = navFrameSize;
    } else if ( input ) {
      form.removeChild( input );
    }
  } catch (e) {
  }

  //*_workarea_frame
  try {
    var frame = window.top.hmcmainui.workarea_frame.frames[0];
    var inputName = "workarea_frame";
    var input  = document.getElementById( inputName );

    if ( frame && frame.document && frame.document.body && frame.document.body.clientHeight ) {
      waFrameSize = frame.document.body.clientHeight;
      if ( !input ) {
        input = document.createElement( "INPUT" );
        with ( input ) {
          type  = "hidden";
          id    = inputName;
          name  = inputName;
        }
        form.appendChild( input );
      }
      input.value = waFrameSize;
    } else if ( input ) {
      form.removeChild( input );
    }
  } catch (e) {
  }

  //tasks_frame
  try {
    var inputName = "tasks_frame";
    var frame = window.top.hmcmainui.workarea_frame.frames[1];
    var input  = document.getElementById( inputName );

    if ( frame && frame.document && frame.document.body && frame.document.body.clientHeight ) {
      tasksFrameSize = frame.document.body.clientHeight;
      if ( !input ) {
        input = document.createElement( "INPUT" );
        with ( input ) {
          type  = "hidden";
          id    = inputName;
          name  = inputName;
        }
        form.appendChild( input );
      }
      input.value = tasksFrameSize;
    } else if ( input ) {
      form.removeChild( input );
    }
  } catch (e) {
  }

  //document.appendChild( form );
  document.body.appendChild(form);
  if ( !isIE
    || navFrameSize_   != navFrameSize
    || waFrameSize_    != waFrameSize
    || tasksFrameSize_ != tasksFrameSize
     )
  {
    document.forms[formName].submit();

    //IE onbeforeunload timing issue fix
    if ( isIE ) {
      pause(250);
    }

    navFrameSize_   = navFrameSize;
    waFrameSize_    = waFrameSize;
    tasksFrameSize_ = tasksFrameSize;

    return true;
  }
}

//pause - wait for given number of milliseconds, not the most effective pause
//        routine since it eats CPU cycles while waiting
// -in: ms - number of milliseconds to wait
//-out: none
function pause(ms) {
  var date = new Date();
  var stopTime = date.getTime() + ms;
  while(true) {
    date = new Date();
    if ( date.getTime() > stopTime ) {
      return;
    }
  }
}
