//
// Requests:
//   To launch a task:
//     /hmc/ui/z/tas?request=open&open=taskId[&targetIds=targetids]
//        taskId:    the short identifier of the selected task to be launched
//        targetIds: the optional list of short identifiers of the work area selections
//   To refresh this frame:
//     /hmc/ui/z/tas?request=refresh&list=index[&sel=taskId]
//        index:  the index of the currently displayed task list
//        taskId: the short identifier of the selected task, if a task is selected
//
//

var tafInitialized = false;
var numTasksPerCol = 1;
var currentTaskIds = null;
var avgTaskHeight = 70;
var avgTitleHeight = 70;
var selectedIds = new Array();

// Cache the task and task group images.
// Without this something happens to IE (don't know what, no error is detected)
// to cause IE to stop displaying images.  Once this happens, all communications
// to the servlet is stopped.
var images = new Array();

//parent.displayTrace();

function init()
{
   parent.trace(3, '-> taf.init()');

   try
   {
      if (parent.isBrowserSupported() == true)
      {
         // Initialize the selected task ids array (one for each group).
         // Also, preload the images.  Without this some images may not
         // display in the Work Area when the Task List view is displayed.
         var next = 0;
         for (var i = 0; i < numTaskGroups; i++)
         {
            images[next] = new Image(32, 32);
            images[next].src = taskGroupImages[i];
            next++;

            var taskImages = eval('taskImageNames' + i);
            for (var j = 0; j < taskImages.length; j++)
            {
               images[next] = new Image();
               images[next].src = taskImages[j];
               next++;
            }

            selectedIds[i] = parent.NONE;
         }

         // Listener for keystrokes.
         if (document.addEventListener)
            // NN: Use the Netscape 4 event handler.
            document.captureEvents(Event.KEYPRESS);
         document.onkeypress = keyPressed;

         // IE does not allow function calls in the onunload handler
         // so use the onbeforeunload handler.
         if (parent.isIE)
            window.onbeforeunload = updateState;
         else
            window.onunload = updateState;

         if (numTaskGroups > 0)
         {
            numTasksPerCol = getNumTasksPerCol();
            setCurrentTaskIds();
            if (parent.isGecko)
               window.addEventListener("resize", handleResize, false);
            else if (parent.isIE)
               window.onresize = handleResize;

            clearTaskList();
            displayTaskList(false);
         }

         // we're initialized.
         tafInitialized = true;
      }
   }
   catch (e)
   {
      parent.handleError(e, "Error in init() (ui/z/tasksarea.js)");
   }

   parent.trace(3, '<- taf.init()');
}

function setCurrentTaskIds()
{
   currentTaskIds = eval('taskIds' + currentIndex);
}

function showTaskList(index)
{
   if (index < numTaskGroups)
   {
      //parent.message('in showTaskList(), index is ' + index);
      clearTaskList();

      currentIndex = index;
      setCurrentTaskIds();

      displayTaskList(true);

      if (window.parent.frames['zuimsg'].setText)
         window.parent.frames['zuimsg'].setText(messages[currentIndex]);
   }
}

function nextTaskList()
{
   if (numTaskGroups > 1)
   {
      clearTaskList();

      if (currentIndex == numTaskGroups - 1)
         currentIndex = 0;
      else
         currentIndex++;
      setCurrentTaskIds();

      displayTaskList(true);

      if (window.parent.frames['zuimsg'].setText)
         window.parent.frames['zuimsg'].setText(messages[currentIndex]);
   }
}

function prevTaskList()
{
   if (numTaskGroups > 1)
   {
      clearTaskList();

      if (currentIndex == 0)
         currentIndex = numTaskGroups - 1;
      else
         currentIndex--;
      setCurrentTaskIds();

      displayTaskList(true);

      if (window.parent.frames['zuimsg'].setText)
         window.parent.frames['zuimsg'].setText(messages[currentIndex]);
   }
}

function clearTaskList()
{
   //selectedIds[currentIndex] = parent.NONE;

   var body = document.getElementsByTagName("body").item(0);
   for (var i = body.childNodes.length - 1; i >= 0; i--)
   {
       body.removeChild(body.childNodes[i]);
   }

// var theParent = body.parentNode;
// theParent.removeChild(body);
// theParent.appendChild(document.createElement("body"));
}

function getTaskId(event)
{
   parent.trace(1, '-> taf.getTaskId()');
   var id;
   if (event.srcElement)
   {
      parent.trace(3, '   using IE');
      parent.trace(3, '   srcElement ' + event.srcElement);
      parent.trace(3, '   srcElement.id is ' + event.srcElement.id);
      var index = event.srcElement.id.indexOf('.');
      id = event.srcElement.id.substr(index+1);
   }
   else
   {
      var index = event.target.id.indexOf('.');
      id = event.target.id.substr(index+1);
   }
   parent.trace(1, '<- taf.getTaskId()');
   return id;
}

function setTaskSelected(event)
{
   parent.trace(1, '-> taf.setTaskSelected()');

   try
   {
      if (!event)
         event = window.event;
      var id = getTaskId(event);
      parent.trace(1, 'id is ' + id);
      var element = document.getElementById("SEL."+id);

      if (id == selectedIds[currentIndex])
      {
         setTaskSelectedById(id, false);
      }
      else
      {
         if (selectedIds[currentIndex] != "none")
            setTaskSelectedById(selectedIds[currentIndex], false);
         setTaskSelectedById(id, true);
      }
   }
   catch (e)
   {
      parent.handleError(e, "Error in setTaskSelected() (ui/z/tasksarea.js)");
   }

   parent.trace(1, '<- taf.setTaskSelected()');
}

function setTaskSelectedById(id, selected)
{
   var element = document.getElementById("SEL."+id);
   if (selected)
   {
      element.className = "taskselected";
      selectedIds[currentIndex] = id;
   }
   else
   {
      element.className = "taskunselected";
      selectedIds[currentIndex] = parent.NONE;
   }

   if (window.parent.frames['zuimsg'].setText)
      window.parent.frames['zuimsg'].setText(messages[currentIndex]);
}

function keyPressed(event)
{
   parent.trace(3, '-> taf.keyPressed()');
   var result = false;  // cancel, without this I'll get 2 keypressed events
   var key;

   if (event)
      key = event.which;           // NN event model
   else
      key = window.event.keyCode;  // IE event model

   parent.trace(3, 'key is ' + key);
   if (key == parent.ENTER_KEY)
      doOpenById(selectedIds[currentIndex]);
   else
      result = parent.handleKey(key);

   parent.trace(3, '<- taf.keyPressed()');
   return result;
}

function doOpen(event)
{
   if (!event)
      event = window.event;
   var id = getTaskId(event);

   // Task is unselected on the 2nd click of the
   // double click so reselect it.
   setTaskSelectedById(id, true);

   doOpenById(id);
}

// Launch the task.
// The id of the task to launch must be passed.
// Optionally the list of targets may be passed.
function doOpenById(id)
{
   parent.trace(3, '-> taf.doOpenById(), id is ' + id);

   try
   {
      var targetIds = '';
      if (arguments.length > 1)
      {
         targetIds = arguments[1];
      }
      else
      {
         if ((parent.frames['zuivaf'].activeViewId == parent.frames['zuivaf'].idGroups) ||
             (parent.frames['zuivaf'].activeViewId == parent.frames['zuivaf'].idExceptions))
            targetIds = parent.frames['zuiwaf'].getSelectedIds();
      }

      var launchTask = true;
      var taskRequiresTarget = requiresTarget(id);
      if (taskRequiresTarget == true)
      {
         if (targetIds.length == 0)
         {
            launchTask = false;
            parent.tell('Task Error',
                        'Please select one or more objects (icons) before selecting the task.',
                        'ACTZUIKY');
         }
      }

      if (launchTask == true)
      {
         // If the task does not require a target then the task can be launched from
         // any view.  If the task requires a target then the task can only be launched
         // from the Groups or Exceptions views.
         if ((taskRequiresTarget == false) ||
             (parent.frames['zuivaf'].activeViewId == parent.frames['zuivaf'].idGroups) ||
             (parent.frames['zuivaf'].activeViewId == parent.frames['zuivaf'].idExceptions))
         {
            parent.reloadTC();

            var s = parent.launchURI
                       + '?type=targetedtask'
                       + '&openid=' + id
                       + '&targetids=' + targetIds;

            // Add the parent shortId only if in the Groups view and there's a parent shortId.
            if (parent.frames['zuivaf'].activeViewId == parent.frames['zuivaf'].idGroups)
            {
               var parentTargetId = parent.frames['zuiwaf'].getParentId();
               if (parentTargetId != null)
                  s = s + '&parentid='  + parentTargetId;
            }

            var element = document.getElementById("TASKSTARTING."+id);
            if (element)
            {
               parent.trace(2, 'show task starting image');
               element.className = 'taskimg task-starting';
            }
            else
               parent.trace(2, '---> could not find element ' + "TASKSTARTING"+id);

            parent.message('tasksarea.doOpen(), href is ' + s);
            // change from GET to POST
            //window.parent.frames['zuiwaf'].location.href = s;
            top.window.frames['hmcmainui'].frames['zuimsg'].document.zuipostform.action = s;
            top.window.frames['hmcmainui'].frames['zuimsg'].document.zuipostform.submit();
         }
         else
         {
            parent.trace(2, '   ignoring request to open task because view is not Groups or Exceptions');
         }
      }
      else
      {
         parent.trace(2, '   ignoring request to open task task requiers a target and a target is not selected');
      }
   }
   catch (e)
   {
      parent.handleError(e, "Error in doOpenById() (ui/z/tasksarea.js)");
   }

   parent.trace(2, '<- taf.doOpenById()');
}

function requiresTarget(taskId)
{
   parent.trace(3, '-> taf.requiresTarget()');

   var result = true;
   for (var i = 0; i < allowNoTargetIds.length; i++)
   {
      if (allowNoTargetIds[i] == taskId)
      {
         result = false;
         break;
      }
   }

   parent.trace(3, '<- taf.requiresTarget(), result is ' + result);
   return result;
}

function getNumTasksPerCol()
{
   var result = 0;
   if (parent.isIE)
      result = (Math.floor((document.body.offsetHeight - avgTitleHeight) / avgTaskHeight)) -1;
   else
      result = Math.floor((window.innerHeight - avgTitleHeight) / avgTaskHeight);
   return result;
}

function handleResize(event)
{
   parent.trace(3, '-> taf.handleResize()');

// parent.trace(3, '   window.innerWidth is ' + window.innerWidth);
// parent.trace(3, '   window.innerHeight is ' + window.innerHeight);
// parent.trace(3, '   numTasksPerCol is ' + numTasksPerCol);
// parent.trace(3, '   currentTaskIds.length is ' + currentTaskIds.length);

   var numRows = getNumTasksPerCol();
   parent.trace(3, '   numRows is ' + numRows);
   if (numRows != numTasksPerCol)
   {
     numTasksPerCol = numRows;
     setCurrentTaskIds();
     clearTaskList();
     displayTaskList(false);
   }

   parent.trace(3, '<- taf.handleResize()');
}

// IE specific function.
function startDrag()
{
   var id = getTaskId(event);
   parent.trace(3, "<> startDrag(), id is " + id);
   parent.dragType = parent.DRAG_TYPE_TASK;
   parent.dragId = window.event.srcElement.id;
}

// IE specific function.
function endDrag()
{
   var id = getTaskId(event);
   parent.trace(3, "<> endDrag(), id is " + id);
   parent.dragType = parent.DRAG_TYPE_NONE;
   parent.dragId = parent.DRAG_TYPE_NONE;
}

// IE specific function.
function drop()
{
   var id = getTaskId(event);
   parent.trace(3, "-> drop(), id is " + id);
   if (parent.dragType == parent.DRAG_TYPE_MANAGED_OBJECT)
   {
      var textObj = parent.frames['zuiwaf'].document.getElementById("T"+parent.dragId);
      // If the object being dragged is selected then doOpenById()
      // will use all selections as the targets.
      // If the object being dragged is not selected then the target
      // is the id of the element being dragged, not the selections.
      if (textObj)
      {
         if (parent.isSelected(textObj))
            doOpenById(id);
         else
            doOpenById(id, parent.dragId);
      }
      else
         parent.trace(3, "   textObj not found, id is " + "T" + parent.dragId);
   }
   else
   {
      parent.trace(3, "   drop is not allowed");
      window.event.returnValue = false;
   }
   parent.trace(3, "<- drop(), id is " + id);
}

// IE specific function.
function enterDrag()
{
   // Need to cancel the operation or 'drop' is never called.
   window.event.returnValue = false;
}

// IE specific function.
function overDrag()
{
   // Need to cancel the operation or 'drop' is never called.
   window.event.returnValue = false;
}

// ----------------------------------------------------------------------------
// Create the DOM objects inside the <body> tag.
//
// The HTML for the table, not including the inner task selection
// tables, would like like the following:
//
// <div class="objtext title">Daily</div>
// <table>
//   <tbody>
//     <tr>
//       (task selection html inserted here)
//     </tr>
//   </tbody>
// </table
//
// ----------------------------------------------------------------------------
function displayTaskList(sendUpdate)
{
   parent.trace(1, '-> taf.displayTaskList(), currentIndex is ' + currentIndex);

   try
   {
      var body = document.getElementsByTagName("body").item(0);

      // Add the title to the <body>.
      var div = document.createElement("div");
      div.className = "objtext title";
      div.innerHTML = taskGroupNames[currentIndex];
      body.appendChild(div);

      // Add the tasks.
      var table = document.createElement("table");
      body.appendChild(table);
      var tbody = document.createElement("tbody");
      table.appendChild(tbody);

      //var idList = eval('taskIds' + currentIndex);
      var nameList = eval('taskNames' + currentIndex);
      var imageList = eval('taskImageNames' + currentIndex);

      var selRow;
      var nextId = 0;
      var numCols = Math.ceil(currentTaskIds.length / numTasksPerCol);
      var row = 0;

      //parent.trace(2, "numRows = " + numTasksPerCol);
      //parent.trace(2, "numCols = " + numCols);
      //parent.trace(2, "nextId = " + nextId);
      while ((row < numTasksPerCol) && (nextId < currentTaskIds.length))
      {
         var tr = document.createElement("tr");
         tbody.appendChild(tr);
         createSelection(currentTaskIds[nextId], nameList[nextId], imageList[nextId], tr);
         nextId++;

         var col = 1;
         var i = (numTasksPerCol * col) + row;
         //parent.trace(2, "i = " + i);
         while ((col < numCols) && (i < currentTaskIds.length))
         {
            createSelection(currentTaskIds[i], nameList[i], imageList[i], tr);
            col++;
            i = (numTasksPerCol * col) + row;
         }
         row++;
      }

      // If the work area is displaying the task lists then update
      // the work area to show the currently active task list.
      parent.trace(2, "check workarea");
      if (parent.frames['zuivaf'].activeViewId)
      {
          if (parent.frames['zuivaf'].activeViewId == parent.frames['zuivaf'].idList)
          {
             parent.trace(2, "update workarea");
             parent.frames['zuiwaf'].setSelected(currentIndex+1);
             parent.frames['zuiwaf'].setActiveTaskListById(currentIndex+1);
          }
      }

      // Tell the servlet of our new state.
      //parent.trace(2, "update state");
      //if (sendUpdate == true)
      //  updateState();

      //traceDomTree();
   }
   catch (e)
   {
      parent.handleError(e, "Error in displayTaskList() (ui/z/tasksarea.js)");
   }

   parent.trace(1, '<- taf.displayTaskList()');
}

// ----------------------------------------------------------------------------
// Create one task selection.
//
// The HTML for one task selection would be like the following:
//
// Var
// Name   HTML
// ------  -------------------------------------------------------------------
// td     <td ondblclick="doOpen()" onclick="setTaskSelected();">
// tbl      <table>
// tbody      <tbody>
// tr           <tr>
// td1            <td id="TASKSTARTING.00000001" class="taskimg">
// div1             <div id="SEL.00000001" class="taskunselected>
// img1               <img id="IMG.00000001" src="messages.gif" class="taskimg">
//                  </div>
//                </td>
// td2            <td>
// div2             <div id="DIV.00000001" class="objtext tasktxt">
//                    Hardware Messages
//                  </div>
//                </td>
//              </tr>
//            </tbody>
//          </table>
//        </td>
//
// Notes:
//   1) div2 has a border which is used to visually indicate the object is
//      selected.
//   2) img2 may contain a background image (Hardware Messages).
//
// ----------------------------------------------------------------------------
function createSelection(id, taskName, image, parentRow)
{
   parent.trace(1, '-> taf.createSelection(), id is ' + id);

   var td = document.createElement("td");
   if (parent.isGecko)
   {
      td.addEventListener("click", setTaskSelected, false);
      td.addEventListener("dblclick", doOpen, false);
   }
   else
   {
      td.attachEvent("onclick", setTaskSelected);
      td.attachEvent("ondblclick", doOpen);
   }
   parentRow.appendChild(td);
   var tbl = document.createElement("table");
   td.appendChild(tbl);
   var tbody = document.createElement("tbody");
   tbl.appendChild(tbody);
   var tr = document.createElement("tr");
   tbody.appendChild(tr);
   var td1 = document.createElement("td");
   td1.id = "TASKSTARTING."+id;
   tr.appendChild(td1);
   var div1 = document.createElement("div");
   div1.id = "SEL."+id;
   if (selectedIds[currentIndex] == id)
      div1.className = "taskselected";
   else
      div1.className = "taskunselected";
   td1.appendChild(div1);
   var img1 = document.createElement("img");
   img1.setAttribute("src", image);
   img1.id = "IMG."+id;
   img1.className = "taskimg";
   if (attnIds.length > 0)
   {
      for (var i = 0; i < attnIds.length; i++)
      {
         if ((attnIds[i] != null) && (attnIds[i] == id))
         {
            img1.style.backgroundImage = "url(" + attnImages[i] + ")";
            break;
         }
      }
   }
   div1.appendChild(img1);
   var td2 = document.createElement("td");
   tr.appendChild(td2);
   var div2 = document.createElement("div");
   div2.id = "DIV."+id;
   div2.className = "objtext tasktext";
   // 'innerHTML' is used instead of the more efficient createTextNode()
   // because the text may contain HTML (<br> tags).
   div2.innerHTML = taskName;
   td2.appendChild(div2);

   parent.trace(1, '<- taf.createSelection()');
}

function refresh()
{
   parent.trace(1, '-> taf.refresh()');

   try
   {
      // Don't want the unload handler to run on a refresh
      if (parent.isIE)
         window.onbeforeunload = null;
      else
         window.onunload = null;

      // Pass the request and the index of the displayed task list.
      request = parent.tasksURI + "?request=refresh&list=" + currentIndex;

      // If a task is selected then pass the shortId of the selected task.
      if (selectedIds[currentIndex] !=  parent.NONE)
         request = request + "&sel=" + selectedIds[currentIndex];

      // Send the request to refresh the tasks area frame.
      parent.trace(2, "request is [" + request + "]");
      location.href = request;
      //top.window.frames['hmcmainui'].frames['zuimsg'].document.zuipostform.action = request;
      //top.window.frames['hmcmainui'].frames['zuimsg'].document.zuipostform.submit();
   }
   catch (e)
   {
      parent.handleError(e, "Error in refresh() (ui/z/tasksarea.js)");
   }

   parent.trace(1, '<- taf.refresh()');
}


function updateState()
{
   parent.trace(1, '-> taf.updateState()');

   try
   {
      // Pass the request and the index of the displayed task list.
      request = parent.tasksURI + "?request=updatestate&list=" + currentIndex;

      // If a task is selected then pass the shortId of the selected task.
      //if (selectedTaskId !=  parent.NONE)
      //   request = request + "&sel=" + selectedTaskId;

      // Send the request to refresh the tasks area frame.
      parent.trace(2, "request is [" + request + "]");
      // change from GET to POST
      // location.href = request;
      top.window.frames['hmcmainui'].frames['zuimsg'].document.zuipostform.action = request;
      top.window.frames['hmcmainui'].frames['zuimsg'].document.zuipostform.submit();
   }
   catch (e)
   {
      parent.handleError(e, "Error in refresh() (ui/z/tasksarea.js)");
   }

   parent.trace(1, '<- taf.updateState()');
}


function setAttentionOff(id)
{
   parent.trace(1, '-> taf.setAttentionOff(' + id + ')');
   try
   {
      var theId = "IMG." + id;
      var element = document.getElementById(theId);
      if (element)
         element.style.backgroundImage = parent.NONE;
      else
         parent.trace(2, '   could not find element for id ' + theId);

      parent.trace(2, 'attnIds.length is ' + attnIds.length);
      for (var i = 0; i < attnIds.length; i++)
      {
         if (attnIds[i] == id)
         {
            attnIds[i] = null;
            attnImages[i] = null;
            break;
         }
      }
   }
   catch (e)
   {
      parent.handleError(e, "Error in setAttentionOff() (ui/z/tasksarea.js)");
   }
   parent.trace(1, '<- taf.setAttentionOff()');
}


function setAttentionOn(id, img)
{
   parent.trace(1, '-> taf.setAttentionOn(' + id + ',' + img + ')');
   try
   {
      var theId = "IMG." + id;
      var element = document.getElementById(theId);
      if (element)
         element.style.backgroundImage = "url(" + img + ")";
      else
         parent.trace(2, '   could not find element for id ' + theId);

      var added = false;
      parent.trace(2, 'attnIds.length is ' + attnIds.length);
      for (var i = 0; i < attnIds.length; i++)
      {
         if (attnIds[i] == null)
         {
            // Reuse a previously removed attention if possible.
            attnIds[i] = id;
            attnImages[i] = img;
            added = true;
            break;
         }
      }

      if (added == false)
      {
         // New attention is to be added to the end of the list.
         var next = attnIds.length;
         attnIds[next] = id;
         attnImages[next] = img;
      }
   }
   catch (e)
   {
      parent.handleError(e, "Error in setAttentionOn() (ui/z/tasksarea.js)");
   }
   parent.trace(1, '<- taf.setAttentionOn()');
}

function taskStarted(id)
{
   parent.trace(1, '-> taf.taskStarted(' + id + ')');
   try
   {
      var theId = "TASKSTARTING." + id;
      var element = document.getElementById(theId);
      if (element)
         element.className = 'taskimg';
      else
         parent.trace(2, '   could not find element for id ' + theId);
   }
   catch (e)
   {
      parent.handleError(e, "Error in setAttentionOn() (ui/z/tasksarea.js)");
   }
   parent.trace(1, '<- taf.setAttentionOn()');
}


function traceDomTree()
{
   //parent.trace(1, "dump the DOM tree starting from the body...");
   var body = document.getElementsByTagName("body").item(0);
   for (var i = 0; i < body.childNodes.length; i++)
   {
      var next = body.childNodes[i];
      //traceDomChildren(next);
   }
}

function traceDomChildren(nextElement)
{
   //parent.trace(1, "dump the DOM tree starting from the body...");
   for (var i = 0; i < nextElement.childNodes.length; i++)
   {
      var nextNode = nextElement.childNodes[i];
      if (nextNode.childNodes)
         traceDomChildren(nextNode.childNodes);
   }
}
