var TYPE_CONSOLE_TASK = 'consoletask';
var TYPE_DEFAULT_TASK = 'defaulttask';
var TYPE_ACTIVE_TASK = 'activetask';
var TYPE_TARGET_TASK = 'targettask';
var NO_ACTIVE_TASK_LIST = parent.NONE;
var NO_FOCUS = parent.NONE;
var activeTaskListId = NO_ACTIVE_TASK_LIST;
var idWithFocus = NO_FOCUS;
var NUM_OBJECTS_IN_ROW = 6;
var imageConsoleActions = '/res/com/ibm/hwmca/fw/images/consact.gif';
var imageGroups = '/res/com/ibm/hwmca/fw/images/groups.gif';

// Set this to false to dynamically add/remove the objects for
// inventory changes.  Dynamic changes is not yet working.
var REFRESH = true;

// ----------------------------------------------------------------------------
// Initialize this frame.
// ----------------------------------------------------------------------------
function init()
{
   parent.trace(3, "-> waf.init()");

   try
   {
      if (parent.isBrowserSupported() == true)
      {
         parent.trace(3, "browser is supported");
         idWithFocus = NO_FOCUS;
         activeTaskListId = NO_ACTIVE_TASK_LIST;

         parent.init(document);

         menuInit(myMenuCreator);
         parent.trace(2, "contextMenu is initialized");

         parent.trace(3, "add listeners");
         if (document.addEventListener)
            // NN: Use the Netscape 4 event handler.
            document.captureEvents(Event.KEYPRESS);

         document.onkeypress = keyPressed;

         if (getParentId() != null)
         {
            var msgIndex = window.parent.frames['zuivaf'].INDEX_MSG_EXCEPTIONS;
            var msg = window.parent.frames['zuivaf'].messages[msgIndex];
            window.parent.frames['zuimsg'].setText(msg);
         }

         traceDomTree();
      }
   }
   catch (e)
   {
      parent.handleError(e, "Error in init() (ui/z/worksarea.js)");
   }

   //parent.displayTrace();
   parent.trace(3, "<- waf.init()");
}

function myMenuCreator(event)
{
   parent.trace(3, "-> waf.myMenuCreator()");

   var myContextMenu = null;

   // ??? only managed objects and manage object groups are supported - need to fix this!
// if ((window.parent.frames['zuivaf'].activeViewId == window.parent.frames['zuivaf'].idGroups) ||
//     (window.parent.frames['zuivaf'].activeViewId == window.parent.frames['zuivaf'].idExceptions))
// {
   try
   {
      var id = parent.getIdFromEvent(event);
      if ((id != undefined) && (id != null) && (id.length > 0))
      {
         if (id.length > 8)
            id = id.substr(id.length-8);
      }

      parent.trace(3, "  id is " + id);

      var mainMenu = null;
      //parent.trace(3, " activeViewId is " + window.parent.frames['zuivaf'].activeViewId);
      //parent.trace(3, " idConsoleActions is " + window.parent.frames['zuivaf'].idConsoleActions);
      if (window.parent.frames['zuivaf'].activeViewId == parent.frames['zuivaf'].idConsoleActions)
      {
         if (id != null)
         {
            var caId = -1;
            var i = 0;
            for (var i = 0; i < caChildIds.length; i++)
            {
               if (id == caAllIds[i])
               {
                  caId = i;
                  break;
               }
            }
            if (caId != -1)
            {
               mainMenu = new Menu();
               var menuItemId = "task=" + id;
               mainMenu.add(new MenuItem(caAllNames[caId], null, myMenuSelectionHandler, menuItemId));
            }
            id = null;
         }
      }

      if ((id != undefined) && (id != null) && (id.length > 0))
      {
         if (id.length > 8)
            id = id.substr(id.length-8);
         parent.trace(3, "  id is " + id);

         // Add all the actions defined for the selected managed object.
         parent.trace(3, "  actionShortIds.length is " + actionShortIds.length);
         var actionNames = null;
         var actionIds = null;
         var actionTargetIds = null;
         for (var i = 0; i < actionShortIds.length; i++)
         {
            parent.trace(3, "   next id is " + actionShortIds[i]);
            if (actionShortIds[i] == id)
            {
               actionNames = eval('actionNames' + parseInt(i));
               actionIds = eval('actionIds' + parseInt(i));
               actionTargetIds = eval('actionTargetIds' + parseInt(i));
               break;
            }
         }

         if (actionNames != null)
         {
            parent.trace(3, "  actionNames.length is " + actionNames.length);
            mainMenu = new Menu();
            var nextItem = 0;
            var menuItemId;
            for (var i = 0; i < actionNames.length; i++)
            {
               //parent.trace(3, "   next name is " + actionNames[i]);
               if (actionTargetIds[i] != '')
                  menuItemId = "target=" + actionTargetIds[i] + ",action=" + actionIds[i] + ",index=" + i;
               else
                  menuItemId = "target=" + id + ",action=" + actionIds[i] + ",index=" + i;
               mainMenu.add(new MenuItem(actionNames[i], null, myMenuSelectionHandler, menuItemId));
            }
            mainMenu.addSeparator();
         }

         // Add all the tasks.
         var taskGroupNames = window.parent.frames['zuitaf'].taskGroupNames;
         //parent.trace(3, "  taskGroupNames.length is " + taskGroupNames.length);
         if (taskGroupNames.length > 0)
         {
            if (mainMenu == null)
               mainMenu = new Menu();
            for (var i = 0; i < taskGroupNames.length; i++)
            {
               var text = taskGroupNames[i].replace(/<BR>/ig, " ");
               var subMenu = new Menu(text);
               mainMenu.add(subMenu);
               var taskNames = eval("window.parent.frames['zuitaf'].taskNames" + parseInt(i));
               var taskIds = eval("window.parent.frames['zuitaf'].taskIds" + parseInt(i));
               var taskImages = eval("window.parent.frames['zuitaf'].taskImageNames" + parseInt(i));
               //parent.trace(3, "  taskNames.length is " + taskNames.length);
               for (var j = 0; j < taskNames.length; j++)
               {
                  text = taskNames[j].replace(/<BR>/ig, " ");
                  menuItemId = "target=" + id + ",task=" + taskIds[j] + ",index=" + j;
                  subMenu.add(new MenuItem(text, taskImages[j], myMenuSelectionHandler, menuItemId));
               }
            }
         }

         if (mainMenu != null)
            myContextMenu = new ContextMenu(mainMenu);
      }
      else
      {
         if (mainMenu == null)
            mainMenu = new Menu();

         parent.trace(3, "  add my actions to the context menu... ");
         for (var i = 0; i < myActionIds.length; i++)
         {
            mainMenu.add(new MenuItem(myActionNames[i], DEFAULT_IMAGE_URL,
                                      myMenuSelectionHandler, "action="+myActionIds[i]));
         }

         parent.trace(3, "  build console actions menu... ");
         var caSubMenu = new Menu(textConsoleActions, imageConsoleActions);
         mainMenu.add(caSubMenu);
         var nextItem = 0;
         var menuItemId;
         for (var i = 0; i < caChildIds.length; i++)
         {
            var subMenu = null;
            for (var j = 0; ((j < caSubMenuIds.length) && (subMenu == null)); j++)
            {
               if (caChildIds[i] == caSubMenuIds[j])
               {
                  parent.trace(3, "  found a submenu");

                  // Find this submenu item in the array of all ids.
                  // The index of the id in caAllIds is used to get the
                  // name and image in caAllnames and caAllImages.
                  var allIndex = -1;
                  for (var k = 0; k < caAllIds.length; k++)
                  {
                     if (caAllIds[k] == caSubMenuIds[j])
                     {
                        allIndex = k;
                        break;
                     }
                  }

                  if (allIndex != -1)
                  {
                     // This menu item is a task group, add a submenu.
                     var text = caAllNames[allIndex].replace(/<BR>/ig, " ");
                     subMenu = new Menu(text, caAllImages[allIndex]);
                     caSubMenu.add(subMenu);
                     parent.trace(3, "  j is " + j);
                     var subMenuIds = eval('caSubMenuIds' + parseInt(j));
                     parent.trace(3, "  number of items in submenu is " + subMenuIds.length);
                     for (var k = 0; k < subMenuIds.length; k++)
                     {
                        // Find this submenu item in the array of all ids.
                        for (var l = 0; l < caAllIds.length; l++)
                        {
                           if (caAllIds[l] == subMenuIds[k])
                           {
                              text = caAllNames[l].replace(/<BR>/ig, " ");
                              menuItemId = "task=" + caAllIds[l] + ",index=" + l;
                              subMenu.add(new MenuItem(text, caAllImages[l], myMenuSelectionHandler, menuItemId));
                              break;
                           }
                        }
                     }
                  }
               }
            }

            if (subMenu == null)
            {
               // Not a submenu, add a menu item
               menuItemId = "task=" + caAllIds[i] + ",index=" + i;
               caSubMenu.add(new MenuItem(caAllNames[i], caAllImages[i], myMenuSelectionHandler, menuItemId));
            }
         }

         parent.trace(3, "  build groups menu... ");
         var grpSubMenu = new Menu(textGroups, imageGroups);
         var numItemsInGrpSubMenu = 0;
         for (var i = 0; i < rootGroupIds.length; i++)
         {
            var isSubMenu = false;
            var j = 0;
            for ( ; j < allGroupIds.length; j++)
            {
               if (rootGroupIds[i] == allGroupIds[j])
               {
                  parent.trace(3, "  root group id is " + rootGroupIds[j]);
                  var subMenuIds = null;
                  try
                  {
                     subMenuIds = eval('allGroupChildren' + parseInt(j));

                     isSubMenu = true;
                     addGroupMenu(rootGroupIds[i], grpSubMenu, j);
                     numItemsInGrpSubMenu++;
                  }
                  catch (e)
                  {
                     // If a root group has no child group then 'allGroupChildren' is not
                     // defined and an exception is thrown from the eval() statement.
                     // Catch it and ignore it.
                  }

                  break;
               }
            }

            if ((isSubMenu == false) && (j < allGroupIds.length))
            {
               parent.trace(3, "  add menu item " + allGroupNames[j]);
               // This group has no child groups, add a menu item selection.
               grpSubMenu.add(new MenuItem(allGroupNames[j],
                                           allGroupImages[j],
                                           myMenuSelectionHandler,
                                           "target=" + allGroupIds[j] + ",action=children"));
               numItemsInGrpSubMenu++;
            }
         }

         if (numItemsInGrpSubMenu > 0)
           mainMenu.add(grpSubMenu);
         myContextMenu = new ContextMenu(mainMenu);
      }
   }
   catch (e)
   {
      parent.handleError(e, "Error in myMenuCreator() (ui/z/worksarea.js)");
   }
// }

   parent.trace(3, "<- waf.myMenuCreator()");
   return myContextMenu;
}

// ----------------------------------------------------------------------------
//
// Add a group submenu.
//
// Arguments:
//     parentId    The short id of the parent item.
//     parentMenu  Add the new menu to this menu.
//     index       The index into allGroupIds of the group to be added.
//
// ----------------------------------------------------------------------------
function addGroupMenu(parentId, parentMenu, index)
{
   parent.trace(3, "-> waf.addGroupMenu(), index is " + index);

   // Add a submenu.
   parent.trace(3, "  add menu " + allGroupNames[index]);
   var subMenu = new Menu(allGroupNames[index],
                          allGroupImages[index],
                          myMenuSelectionHandler,
                          "target=" + allGroupIds[index] + ",action=children");
   parentMenu.add(subMenu);

   try
   {
      // Add child of this submenu.
      var subMenuIds = eval('allGroupChildren' + parseInt(index));

      if (subMenuIds != null)
      {
         for (var i = 0; i < subMenuIds.length; i++)
         {
            for (var j = 0; j < allGroupIds.length; j++)
            {
               if (subMenuIds[i] == allGroupIds[j])
               {
                  parent.trace(3, "  found a matching group at index " + j);
                  try
                  {
                     eval('allGroupChildren' + parseInt(j));
                     addGroupMenu(allGroupIds[j], subMenu, j);
                  }
                  catch (e)
                  {
                     // This group has no child groups, add a menu item selection.
                     parent.trace(3, "  add menu item " + allGroupNames[j]);
                     subMenu.add(new MenuItem(allGroupNames[j],
                                              allGroupImages[j],
                                              myMenuSelectionHandler,
                                              "target=" + allGroupIds[j] + ",action=children"));
                  }
                  break;
               }
            }
         }
      }
   }
   catch (e) {}

   parent.trace(3, "<- waf.addGroupMenu()");
}

function myMenuSelectionHandler(menuItemId)
{
   parent.trace(3, "-> waf.myMenuSelectionHandler(), menuItemId is " + menuItemId);

   // Format of menuItemId is target=xxxxxxxx,task=zzzzzzzz,index=y, action=nnnn where
   // xxxxxxxx is the shortId of the target managed object (always 8 bytes)
   // zzzzzzz (optional) is the shortId of the task (always 8 bytes).
   // y is the index of the action for the selection (variable length).
   // nnnn is the name of the action (variable length).
   var target = parseMenuItemId(menuItemId, "target=");
   var task = parseMenuItemId(menuItemId, "task=");
   var index = parseMenuItemId(menuItemId, "index=");;
   var action = parseMenuItemId(menuItemId, "action=");

   parent.trace(3, "  target is " + target);
   parent.trace(3, "  index is " + index);
   parent.trace(3, "  task is " + task);
   parent.trace(3, "  action is " + action);

   // See if the selection was an action.
   if ((target == null) && (action == "selectall"))
   {
      selectAll();
   }
   else if ((target == null) && (action == "deselectall"))
   {
      unselectAll();
   }
   else if ((target != null) && (action != null))
   {
      if (action == "children")
      {
         if ((window.parent.frames['zuivaf'].activeViewId == parent.frames['zuivaf'].idConsoleActions) ||
             (window.parent.frames['zuivaf'].activeViewId == parent.frames['zuivaf'].idList))
            doOpen(target, parent.frames['zuivaf'].idGroups);
         else
            doOpen(target);
      }
      else if (action == "launch")
      {
         launchTask(target, TYPE_DEFAULT_TASK);
      }
      else if (action == "togglelock")
      {
         doToggleLock(target);
      }
   }
   else
   {
      // 'task' is null if a task menu item was not selected.
      if (task == null)
      {
         if (action == null)
         {
            parent.trace(3, "  actionShortIds.length is " + actionShortIds.length);
            var actionIds = null
            for (var i = 0; i < actionShortIds.length; i++)
            {
               parent.trace(3, "   next shortId is " + actionShortIds[i]);
               if (actionShortIds[i] == target)
               {
                  actionIds = eval('actionIds' + parseInt(i));
                  break;
               }
            }

            if (actionIds != null)
            {
               parent.trace(3, "  actionIds.length is " + actionIds.length);
               if ((actionIds[index] == "children") || (actionIds[index] == "launch"))
               {
                  doOpen(target);
               }
               else if (actionIds[index] == "togglelock")
               {
                  doToggleLock(target);
               }
            }
         }
         else
         {
            doOpen(target, window.parent.frames['zuivaf'].idGroups);
         }
      }
      else
      {
         var consoleAction = false;
         if ((caAllIds) && (caAllNames))
         {
            for (var i = 0; i < caAllIds.length; i++)
            {
               if (task == caAllIds[i])
               {
                  consoleAction = true;
                  break;
               }
            }
         }

         if (consoleAction == true)
            launchTask(task, TYPE_CONSOLE_TASK);
         else
            window.parent.frames['zuitaf'].doOpenById(task, target);
      }
   }

   parent.trace(3, "<- waf.myMenuSelectionHandler()");
}

function parseMenuItemId(menuItemId, text)
{
   var result = null;
   startOffset = menuItemId.indexOf(text);
   if (startOffset >= 0)
   {
      startOffset = startOffset + text.length;
      var endOffset = menuItemId.indexOf(",", startOffset);
      if (endOffset == -1)
         result = menuItemId.substring(startOffset);
      else
         result = menuItemId.substring(startOffset, endOffset);
   }
   return result;
}

// ----------------------------------------------------------------------------
// Unselect all objects in the work area.
// ----------------------------------------------------------------------------
function unselectAll()
{
   parent.unselectAll(document);
}

// ----------------------------------------------------------------------------
// Select all objects in the work area.
// ----------------------------------------------------------------------------
function selectAll()
{
   parent.selectAll(document);
}

// ----------------------------------------------------------------------------
// If the object is selected then unselect it, otherwise select it.
// ----------------------------------------------------------------------------
function toggleSelection(id)
{
   parent.toggleSelection(parent.getId(id), document, singleSelection)
   idWithFocus = id;
}

// ----------------------------------------------------------------------------
//
// ----------------------------------------------------------------------------
function setSelected(id)
{
   parent.trace(3, "-> waf.setSelected(), id is " + id);
   if (singleSelection)
      parent.unselectAll(document);
   parent.setSelected(parent.getId(id), document)
   idWithFocus = id;
   parent.trace(3, "<- waf.setSelected()");
}

// ----------------------------------------------------------------------------
// Return the short identifier for the displayed group.  If a group is
// no being displayed, return null.
// ----------------------------------------------------------------------------
function getParentId()
{
   if ((parentId) && (parentId != undefined))
      return parentId;
   return null;
}

// ----------------------------------------------------------------------------
// Return a string of the selected short identifiers separated with the
// plus sign (i.e. "01+02+03").
// ----------------------------------------------------------------------------
function getSelectedIds()
{
   var result = parent.EMPTY;
   var numSelections = 0;
   //var targets = new Array();
   var targets = parent.myGetElementsByName(parent.selectionName, document);
   parent.trace(3, 'number of selections is ' + targets.length);

   for (var i = 0; i < targets.length; i++)
   {
      var nextTarget = document.getElementById("T"+targets[i].id);
      if (nextTarget != null)
      // Is this the text element in the selection?
      //if (targets[i].id.charAt(0) == 'T')
        {
         //parent.trace(3, 'nextTarget.style.backgroundColor ' + targets[i].style.backgroundColor);
         // See if the text element is selected.
         if ((nextTarget.style.backgroundColor == parent.selectedColor) ||
             (nextTarget.style.backgroundColor == '#696969'))
         {
            if (numSelections > 0)
               result = result + '+' + nextTarget.id.substr(1);
            else
               result = result + nextTarget.id.substr(1);
            numSelections++;
         }
        }
   }

   parent.trace(3, "waf.getSelectedIds() returning selected ids: " + result);
   return result;
}

// ----------------------------------------------------------------------------
// The user pressed a key.  If the key is Enter then process it, otherwise
// pass the key to the frameset.
// ----------------------------------------------------------------------------
function keyPressed(event)
{
   parent.trace(3, "-> waf.keyPressed()");

   var result = true;   // don't cancel the key

   try
   {
      var key;

      if (event)
         key = event.which;           // NN event model
      else
         key = window.event.keyCode;  // IE event model

      if (key == parent.ENTER_KEY)
         result = enterKeyPressed();
      else
         result = parent.handleKey(key);
   }
   catch (e)
   {
      parent.handleError(e, "Error in keyPressed() (ui/z/worksarea.js)");
   }

   parent.trace(3, "<- waf.keyPressed()");

   return result;
}

function enterKeyPressed()
{
   if (idWithFocus != NO_FOCUS)
   {
      if (window.parent.frames['zuivaf'].activeViewId == window.parent.frames['zuivaf'].idList)
         displayTaskListById(idWithFocus);
      else if (window.parent.frames['zuivaf'].activeViewId == window.parent.frames['zuivaf'].idBooks)
         openBook(selectedBookUrl);
      else
      {
         var element = document.getElementById("TD"+idWithFocus);
         element.ondblclick();
      }
   }

   return false;   // cancel the key
}

function doOpen(theId)
{
   parent.trace(2, '-> waf.doOpen(), theId is ' + theId + ', idWithFocus is ' + idWithFocus);

   parent.reloadTC();

   var id = parent.getId(theId);

   var viewId = window.parent.frames['zuivaf'].activeViewId;
   if (arguments.length > 1)
      viewId = arguments[1];

   //var viewId = window.parent.frames['zuivaf'].idGroups;
   var s = parent.workareaURI + '?view=' + viewId + '&target=' + id;
   //if ((viewId == parent.frames['zuivaf'].idGroups) && (parentId != null))
   //   s = s + '&parentId='  + parentId;

   parent.trace(2, 'send to servlet [' + s + ']');

   // change from GET to POST
   //window.parent.frames['zuiwaf'].location.href = s;
   doPost(s);

   parent.trace(2, '<- waf.doOpen()');
}

function launchTask()
{
   parent.trace(2, '-> waf.launchTask()');

   parent.reloadTC();

   var argv = launchTask.arguments;
   var argc = argv.length;
   var theId = argv[0];
   var id = parent.getId(theId);

   var otherInfo = null;
   var type;
   if (argv.length > 1)
      type = argv[1];
   else
   {
      var viewId = window.parent.frames['zuivaf'].activeViewId;
      if (viewId == parent.frames['zuivaf'].idConsoleActions)
         type = TYPE_CONSOLE_TASK;
      else if (viewId == parent.frames['zuivaf'].idActiveTasks)
         type = TYPE_ACTIVE_TASK;
      else
         type = TYPE_DEFAULT_TASK;
   }

   var s = parent.launchURI + '?openid=' + id;
   s = s + '&type=' + type;

   if (getParentId() != null)
      s = s + '&parentid=' + getParentId();

   if (type == TYPE_DEFAULT_TASK)
   {
      var element = document.getElementById("TASKSTARTING"+id);
      if (element)
      {
         parent.trace(2, 'show task starting image');
         element.className = 'task-starting';
      }
      s = s + '&targetids=' + id;
   }
   else if (type == TYPE_CONSOLE_TASK)
   {
      var element = document.getElementById("TASKSTARTING"+id);
      if (element)
      {
         parent.trace(2, 'show task starting image');
         element.className = 'task-starting';
      }
      else
         parent.trace(2, '---> could not find element ' + "TASKSTARTING"+id);
   }

   parent.trace(2, 'send to servlet [' + s + ']');

   // change from GET to POST
   //window.parent.frames['zuiwaf'].location.href = s;
   doPost(s);

   /*
   var s = "Objects in Work Area:";

   var selections = parent.myGetElementsByName(parent.selectionName, document);
   var s = "The are " + selections.length+ " objects in work area:";
   for (var i = 0; i < selections.length; i++)
   {
      s = s + "\n" + selections[i].id;
   }

   parent.message(s);
   */
   parent.trace(2, '<- waf.launchTask()');
}

function doPost(s)
{
   top.window.frames['hmcmainui'].frames['zuimsg'].document.zuipostform.action = s;
   top.window.frames['hmcmainui'].frames['zuimsg'].document.zuipostform.target = 'zuiwaf';
   top.window.frames['hmcmainui'].frames['zuimsg'].document.zuipostform.submit();
}

function isGroup(id)
{
   parent.trace(2, '-> waf.isGroup(), id is ' + id);
   var result = false;
   parent.trace(2, '   number of allGroupIds is ' + allGroupIds.length);
   for (var i = 0; i < allGroupIds.length; i++)
   {
      parent.trace(2, '   allGroupIds[' + i + '] is ' + allGroupIds[i]);
      if (allGroupIds[i] == id)
      {
         result = true;
         break;
      }
   }
   parent.trace(2, '<- waf.isGroup(), result is ' + result);
   return result;
}

function doToggleLock(target)
{
   parent.trace(2, '-> waf.doToggleLock()');
   var viewId = window.parent.frames['zuivaf'].activeViewId;
   var s = parent.workareaURI + '?view=' + viewId + '&request=togglelock' + '&target=' + target;
   parent.trace(2, 'send to servlet [' + s + ']');
   //window.parent.frames['zuiwaf'].location.href = s;
   // change from GET to POST
   doPost(s);
   parent.trace(2, '<- waf.doToggleLock()');
}

// IE specific function.
function startDrag()
{
   var id = event.srcElement.id.substring(7);
   //var id = parent.getIdFromEvent(event);
   parent.trace(3, "<> startDrag(), id is " + id);
   parent.dragType = parent.DRAG_TYPE_MANAGED_OBJECT;
   parent.dragId = id;
}

// IE specific function.
function endDrag()
{
   var id = event.srcElement.id.substring(7);
   parent.trace(3, "<> endDrag(), id is " + id);
   parent.dragType = parent.DRAG_TYPE_NONE;
   parent.dragId = parent.DRAG_TYPE_NONE;
}

// IE specific function.
function drop()
{
   var id = event.srcElement.id.substring(7);
   parent.trace(3, "<> drop(), id is " + id);
   if (parent.dragType == parent.DRAG_TYPE_TASK)
      launchTask(id);
   else
   {
      parent.trace(3, "   drop is not allowed");
      window.event.returnValue = false;
   }
}

// IE specific function.
function enterDrag()
{
   // Need to cancel the operation or 'drop' is never called.
   window.event.returnValue = false;
}

// IE specific function.
function overDrag()
{
   // Need to cancel the operation or 'drop' is never called.
   window.event.returnValue = false;
}

function displayTaskLists(title)
{
   parent.trace(2, '-> waf.displayTaskLists()');

   try
   {
      // Get the selections.
      var names = window.parent.frames['zuitaf'].taskGroupNames;
      var images = window.parent.frames['zuitaf'].taskGroupImages;
      var selectedGroup = window.parent.frames['zuitaf'].currentIndex;

      // An id of 0 does not work???
      selectedGroup = selectedGroup + 1;

      // Get the <body> tag and remove all it's children.
      var body = document.getElementsByTagName("body").item(0);
      for (var i = body.childNodes.length - 1; i >= 0; i--)
      {
         body.removeChild(body.childNodes[i]);
      }

      // Replace all html break tags with a blank.
      //   'g' -> global (replace all)
      //   'i' -> ignore case
      var text = title.replace(/<br>/gi, " ");

      // Add the title to the <body>.
      var div = document.createElement('div');
      div.className = 'objtext title';
      div.innerHTML = text;
      body.appendChild(div);

      // Create a table to hold the selections.
      var tbl = document.createElement("table");
      body.appendChild(tbl);
      var tbody = document.createElement("tbody");
      tbl.appendChild(tbody);

      var tbl1;
      var tbody1;
      var tbl2;
      var tbody2;
      var tr1;
      var tr2;
      var td;
      var anchor;
      var img;
      var next;

      //
      // Each selection will have the following HTML:
      //
      // <td valign="top" onclick="" ondblclick="" align="center">
      //  <table class="asel">
      //   <tbody>
      //    <tr>
      //     <td>
      //      <table align="center">
      //       <tbody>
      //        <tr>
      //         <td id="id" name="SEL">
      //          <a>
      //           <img src="image.gif">
      //          </a>
      //         </td>
      //        </tr>
      //       </tbody>
      //      </table>
      //     </td>
      //    </tr>
      //    <tr>
      //     <td class="objtext" id="Tid" name="SEL">
      //      name
      //     </td>
      //    </tr>
      //   </tbody>
      //  </table>
      // </td>
      //

      // Create each selection
      var next = 0;
      // An id of 0 does not work???
      var nextId = 1;
      while (next < names.length)
      {
         tr1 = document.createElement("tr");
         tbody.appendChild(tr1);
         for (var j = 0; ((j < NUM_OBJECTS_IN_ROW) && (next < names.length)); j++, next++, nextId++)
         {
            parent.trace(2, '   nextId is ' + nextId);

            td = document.createElement("td");
            td.setAttribute("valign", "top");
            td.setAttribute("align", "center");
            td.id = "Z" + nextId;
            if (td.addEventListener)
            {
               // NN
               td.addEventListener("click", selectTaskList, false);
               td.addEventListener("dblclick", displayTaskList, false);
            }
            else
            {
               // IE
               td.attachEvent("onclick", selectTaskList);
               td.attachEvent("ondblclick", displayTaskList);
            }
            tr1.appendChild(td);
            tbl1 = document.createElement("table");
            tbl1.className = "asel";
            td.appendChild(tbl1);
            tbody1 = document.createElement("tbody");
            tbl1.appendChild(tbody1);
            tr2 = document.createElement("tr");
            tbody1.appendChild(tr2);
            td = document.createElement("td");
            tr2.appendChild(td);
            tbl2 = document.createElement("table");
            tbl2.setAttribute("align", "center");
            td.appendChild(tbl2);
            tbody2 = document.createElement("tbody");
            tbl2.appendChild(tbody2);
            tr2 = document.createElement("tr");
            tbody2.appendChild(tr2);
            td = document.createElement("td");
            td.id = "I" + nextId;
            td.setAttribute("name","SEL");
            tr2.appendChild(td);
            anchor = document.createElement("a");
            td.appendChild(anchor);
            img = document.createElement("img");
            img.setAttribute("src", images[next]);
            anchor.appendChild(img);
            tr2 = document.createElement("tr");
            tbody1.appendChild(tr2);
            td = document.createElement("td");
            td.id = "T" + nextId;
            td.setAttribute("name","SEL");
            td.className = "objtext";
            td.innerHTML = names[next];
            tr2.appendChild(td);
         }
      }

      singleSelection = true;

      parent.init(document);

      setSelected(selectedGroup);
      setActiveTaskListById(selectedGroup);
      //parent.setSelected(selectedGroup, document);
      //parent.setActive(selectedGroup, document);

      // The <TD> that contains the text and image has the click handler.  The id of
      // the <TD> is "Zxx" where "xx" is the index of the task group array of
      // a particular task group.  When a task group is selected from the
      // work area the parent functions, setUnseletced() and setSelected() are
      // called.  The parent functions prepend "I" and "T" to the id to find
      // the image and text nodes then these nodes are changed.  Therefore, the
      // id of the selected task group and the id of the active task group is
      // always stored as "xx", not as "Zxx".
      activeTaskListId = selectedGroup;
      idWithFocus = selectedGroup;

      if (document.addEventListener)
         // NN: Use the Netscape 4 event handler.
         document.captureEvents(Event.KEYPRESS);

      document.onkeypress = keyPressed;

      window.parent.frames['zuivaf'].changeDisplayedView(window.parent.frames['zuivaf'].idList);

      traceDomTree();
      //updateState();
   }
   catch (e)
   {
      parent.handleError(e, "Error in displayTaskLists() (ui/z/worksarea.js)");
   }

   parent.trace(2, '<- waf.displayTaskLists()');
}


function selectTaskList(event)
{
   parent.trace(2, '-> waf.selectTaskList()');
   if (!event)
      event = window.event;   // IE

   // getIdFromEvent() will remove the first character if that character
   // is not a valid hex number (an id of "Z01" is returned as "01").
   var id = parent.getIdFromEvent(event);
   if (idWithFocus != id)
   {
      // setUnselected() and setSelected() will prepend an "I" and a "T"
      // to the id to find the image and text nodes.
      parent.setUnselected(idWithFocus, document);
      parent.setSelected(id, document);
      idWithFocus = id;
   }
   parent.trace(2, '<- waf.selectTaskList()');
}

function displayTaskList(event)
{
   if (!event)
      event = window.event;   // IE

   var id = parent.getIdFromEvent(event);
   displayTaskListById(id);
}

function displayTaskListById(id)
{
   parent.trace(2, '-> waf.displayTaskListById(), id is ' + id);
   if (activeTaskListId != NO_ACTIVE_TASK_LIST)
   {
      parent.setInactive(activeTaskListId, document);
      parent.setUnselected(activeTaskListId, document);
   }

   activeTaskListId = id;
   parent.setSelected(activeTaskListId, document);
   parent.setActive(activeTaskListId, document);

   // An id of 0 does not work???
   window.parent.frames['zuitaf'].showTaskList(activeTaskListId - 1);

   parent.trace(2, '<- waf.displayTaskListById()');
}

//
// Set the background of a task list selection to reflect the task
// list is active.
//
function setActiveTaskListById(id)
{
   parent.setInactive(activeTaskListId, document);

   activeTaskListId = id;
   parent.setActive(id, document);
}

function clearActiveTaskList()
{
   parent.setInactive(activeTaskListId, document);
   activeTaskListId = NO_ACTIVE_TASK_LIST;
}

function changeBackgroundImages(id, img1, img2, img3, img4)
{
   parent.trace(2, "-> waf.changeBackgroundImages()");

   try
   {
      var element = document.getElementById("BGIMG1"+id);
      if (element)
         element.setAttribute("src", img1);
      element = document.getElementById("BGIMG2"+id);
      if (element)
         element.setAttribute("src", img2);
      element = document.getElementById("BGIMG3"+id);
      if (element)
         element.setAttribute("src", img3);
      element = document.getElementById("BGIMG4"+id);
      if (element)
         element.setAttribute("src", img4);
   }
   catch (e)
   {
      parent.handleError(e, "Error in changeBackgroundImages() (ui/z/workarea.js)");
   }

   parent.trace(2, "<- waf.changeBackgroundImages()");
}

function clearBackgroundImages(id)
{
   parent.trace(2, "-> waf.clearBackgroundImages()");

   try
   {
      var element = document.getElementById("BGIMG1"+id);
      if (element)
         element.setAttribute("src", parent.NONE);
      element = document.getElementById("BGIMG2"+id);
      if (element)
         element.setAttribute("src", parent.NONE);
      element = document.getElementById("BGIMG3"+id);
      if (element)
         element.setAttribute("src", parent.NONE);
      element = document.getElementById("BGIMG4"+id);
      if (element)
         element.setAttribute("src", parent.NONE);
   }
   catch (e)
   {
      parent.handleError(e, "Error in clearBackgroundImages() (ui/z/workarea.js)");
   }

   parent.trace(2, "<- waf.clearBackgroundImages()");
}

function changeImage(id, img)
{
   parent.trace(2, "-> waf.changeImage()");

   try
   {
      var element = document.getElementById("BASEIMG"+id);
      if (element)
      {
         parent.trace(2, "   changing src from [" + element.src + "] to [" + img + "]");
         element.setAttribute("src", img);
      }
   }
   catch (e)
   {
      parent.handleError(e, "Error in changeImage() (ui/z/workarea.js)");
   }

   parent.trace(2, "<- waf.changeImage()");
}


function sendRefresh()
{
   parent.trace(2, "-> waf.sendRefresh()");
   var request = getRequest();
   // change from GET to POST
   //location.href = request;
   doPost(request);
   parent.trace(2, "request is [" + request + "]");
   parent.trace(2, "<- waf.sendRefresh()");
}

function getRequest()
{
   var viewId = window.parent.frames['zuivaf'].activeViewId;
   var parentId = getParentId();
   parent.trace(2, "   parentId is " + parentId);
   var request = parent.workareaURI + "?view=" + viewId;
   if (parentId != null)
      request = request + "&target=" + parentId;
   return request;
}

function updateState()
{
   parent.trace(2, "-> waf.updateState()");
   var request = getRequest();
   request = request + "&request=updatestate";
   // change from GET to POST
   //location.href = request;
   doPost(request);
   parent.trace(2, "request is [" + request + "]");
   parent.trace(2, "<- waf.updateState()");
}

function setLock(id, lock)
{
   parent.trace(2, "-> waf.setLock()");

   try
   {
      var element = document.getElementById("LOCK"+id);
      if (element)
      {
         parent.trace(2, "   changing className for id " + id + ", lock is " + lock);
         if (lock == 0)
            element.className = "lockimg hide";
         else
            element.className = "lockimg";
      }
   }
   catch (e)
   {
      parent.handleError(e, "Error in setLock() (ui/z/workarea.js)");
   }

   parent.trace(2, "<- waf.setLock()");
}

function setActive(id, active)
{
   parent.trace(2, "-> waf.setActive()");

   try
   {
      var element = document.getElementById("TASKSTARTING"+id);
      if (element)
      {
         parent.trace(2, 'remove task starting image');
         element.className = '';
      }
      else
      {
         window.parent.frames['zuitaf'].taskStarted(id);
         parent.trace(2, '---> could not find element ' + "TASKSTARTING"+id);
      }

      var viewId = window.parent.frames['zuivaf'].activeViewId;
      if (viewId == parent.frames['zuivaf'].idConsoleActions)
      {
         element = document.getElementById("BASEIMG"+id);
         if (element)
         {
            parent.trace(2, "   changing className for id " + id + ", active is " + active);
           if (active == 0)
              element.className = "clearActiveUrl";
           else
             element.className = "setActiveUrl";
         }
      }
   }
   catch (e)
   {
      parent.handleError(e, "Error in setActive() (ui/z/workarea.js)");
   }

   parent.trace(2, "<- waf.setActive()");
}

function refresh(viewId)
{
   parent.trace(2, "-> waf.refresh(), viewid is " + viewId);

   try
   {
      parent.trace(3, "activeViewid is " + window.parent.frames['zuivaf'].activeViewId);
      //if (viewId == window.parent.frames['zuivaf'].activeViewId)
         sendRefresh();
   }
   catch (e)
   {
      parent.handleError(e, "Error in refresh() (ui/z/workarea.js)");
   }

   parent.trace(2, "<- waf.refresh()");
}

function traceDomTree()
{
   //parent.trace(1, "dump the DOM tree starting from the body...");
   var body = document.getElementsByTagName("body").item(0);
   for (var i = 0; i < body.childNodes.length; i++)
   {
      var nextNode = body.childNodes[i];
      //parent.trace(1, nextNode.toString());
   }
}
