/*********************************************************** {COPYRIGHT-TOP} ***
* Licensed Materials - Property of IBM
* Tivoli Presentation Services
*
* (C) Copyright IBM Corp. 2006  All Rights Reserved.
*
* US Government Users Restricted Rights - Use, duplication, or
* disclosure restricted by GSA ADP Schedule Contract with IBM Corp.
************************************************************ {COPYRIGHT-END} ***
*******************************************************************************/

/*******************************************************************************
* This file contains all of the javascript functions used by the WCL renderers
* when AJAX is being used.  The functions defined here must be stateless -- that
* is, no member variables can be defined, so all state information must be
* passed into the function as parameters.
*
* Module History:
* 08/30/2006  JMiller      AJAX rowsPerView updating support
*                          table/column resizing
*                          successive drag-n-drop for column resizing
* 09/18/2006  JMiller      remember if table was initally configured for auto table height
* 09/25/2006  JMiller      Empty column header rendering fix
* 10/03/2006  JMiller      Successive Drag-n-drop fix on Linux Firefox 1.5.0.7 (ODT I4965)
* 10/06/2006  JMiller      Shift-click support for doTblAjax
* 10/24/2006  JMiller      Allow column at index 0 to be resized (ODT I6157)
* 11/13/2006  JMiller      AJAX column width persistence fix
*                          last column resizing fix
* 03/01/2007  JMiller      remove table hoverTitle calls on resize
*                          fath path resize for tables returning after select table actions
*                          to decrease AJAX update time
* 03/02/2007  JMiller      adjust table height only when needed
* 03/08/2007  JMiller      fix to shrink table header/resizer height when needed
* 03/13/2007  JMiller      fix firefox for windows flash after ajax update
* 03/20/2007  JMiller      merge in patch 59824
* 04/17/2007  JMiller      ajax resize table on frame resize fixes
* 08/21/2008  JMiller      675267 - setupTableAjax timeout fix (prevent ajax update failure)
*******************************************************************************/

/** AWInputComponent **
 * action - the name of the action. do not encode because it is used as the
 *          value of a hidden input field.
 * formName - this encoded name of the form
 * wclhidden - the encoded name of the hidden field
 */
function frmActAjax(action, formName, wclhidden) {
   if (document != null && document.forms != null && formName != null) {
      var form = document.forms[formName];
      if (form != null) {
         eval( "form." + wclhidden + ".value = '" + action + "'" );
         startRequest(form, null);
         // Reset the form values.
         eval("form." + wclhidden + ".value = ''");
      }
   }
}

/**
 * formName - the encoded name of the form
 * actionName - the name of the action being performed
 * actionValue - the name of the component performing the action
 * anchorName - the name of the anchor used when the page is refreshed
 * actionNameEnc - the encoded name of the action being performed
 * wclhidden - the encoded name of the hidden field
 * wclanchor - the encoded name of the hidden field for the anchor
 */
function doWizButtonAjax(formName, actionName, actionValue, actionNameEnc, wclhidden) {
   if (document != null && document.forms != null && formName != null) {
      var form = document.forms[formName];
      if (form != null) {
         eval("form." + wclhidden + ".value = '" + wclhidden + "'");
         startRequest(form, actionName);
         // Reset the form values.
         eval("form." + wclhidden + ".value = ''");
      }
   }
   return false;
}

/** WNotebook **
 * formName - the encoded name of the form
 * actionName - the name of the action being performed
 * actionValue - the name of the component performing the action
 * actionNameEnc - the encoded name of the action being performed
 * wclhidden - the encoded name of the hidden field
 * wclanchor - the encoded name of the hidden field for the anchor
 */
function doNbAjax(formName, actionName, actionValue, actionNameEnc, wclhidden, wclanchor) {
   return doSubmitAjax(formName, actionName, actionValue, null, actionNameEnc, wclhidden, wclanchor);
}

/** WWizard **
 * formName - the encoded name of the form
 * actionName - the name of the action being performed
 * actionValue - the name of the component performing the action
 * actionNameEnc - the encoded name of the action being performed
 * wclhidden - the encoded name of the hidden field
 * wclanchor - the encoded name of the hidden field for the anchor
 */
function doWizAjax(formName, actionName, actionValue, actionNameEnc, wclhidden, wclanchor) {
   return doSubmitAjax(formName, actionName, actionValue, null, actionNameEnc, wclhidden, wclanchor);
}

/** WTree (for the expand/collapse events) **
 * formName - the encoded name of the form
 * actionName - the name of the action being performed
 * actionValue - the name of the component performing the action
 * anchorName - the name of the anchor used when the page is refreshed
 * actionNameEnc - the encoded name of the action being performed
 * wclhidden - the encoded name of the hidden field
 * wclanchor - the encoded name of the hidden field for the anchor
 * idName - the encoded name of the hidden field that specifies which tree in the form is performing the action
 */
function doTreeAjax(formName, actionName, actionValue, anchorName, actionNameEnc, wclhidden, wclanchor, idName){
   if (document != null && document.forms != null && formName != null) {
      var form = document.forms[formName];
      if (form != null) {
         if(idName != null){
             eval("form." + idName + ".value = '" + idName + "'");
         }
      }
   }
   return doSubmitAjax(formName, actionName, actionValue, anchorName, actionNameEnc, wclhidden, wclanchor);
}

/**
 * formName - the encoded name of the form
 * actionName - the name of the action being performed
 * actionValue - the name of the component performing the action
 * anchorName - the name of the anchor used when the page is refreshed
 * actionNameEnc - the encoded name of the action being performed
 * wclhidden - the encoded name of the hidden field
 * wclanchor - the encoded name of the hidden field for the anchor
 */
function doSubmitAjax(formName, actionName, actionValue, anchorName, actionNameEnc, wclhidden, wclanchor) {
   if (document != null && document.forms != null && formName != null) {
      var form = document.forms[formName];
      if (form != null) {
         if (actionName != null) {
            eval("form." + actionNameEnc + ".value = '" + actionValue + "'");
            eval("form." + wclhidden + ".value = '" + actionName + "'");
         }
         startRequest(form, null);
         // Reset the form values.
         eval("form." + actionNameEnc + ".value = ''");
         eval("form." + wclhidden + ".value = ''");
      }
   }
   return false;
}

/**
 * formName - the encoded name of the form
 * actionName - the name of the action being performed
 * actionValue - the name of the component performing the action
 * anchorName - the name of the anchor used when the page is refreshed
 * actionNameEnc - the encoded name of the action being performed
 * wclhidden - the encoded name of the hidden field
 * wclanchor - the encoded name of the hidden field for the anchor
 */
function doFormSubmitAjax(formName, actionName, actionValue, anchorName, actionNameEnc, wclhidden, wclanchor) {
   if (document != null && document.forms != null && formName != null) {
      var form = document.forms[formName];
      if (form != null) {
         if (actionName != null) {
            eval("form." + actionNameEnc + ".value = '" + actionValue + "'");
            eval("form." + wclhidden + ".value = '" + actionName + "'");
         }
         form.submit();
      }
   }
   return false;
}

/** WTable **
 * formName - the encoded name of the form
 * actionValue - the name of the component performing the action
 * anchorName - the name of the anchor used when the page is refreshed
 * wclhidden - the encoded name of the hidden field
 * wclanchor - the encoded name of the hidden field for the anchor
 * userActions - the userActions id to be used if the GO button is missing
 */
function doUserActionAjax(formName, actionValue, anchorName, wclhidden, wclanchor, userActions) {
   debug("-->doUserActionAjax");
   var result = false;
   // Get the name of the selection box (actionValue with an 's' inserted: userActions_id).
   var dropDownId = actionValue.substring(0, 10) + "s" + actionValue.substring(10);
   debug("dropDownId [" + dropDownId + "]");
   var dropDown = document.getElementById(dropDownId);
   var ajax = false;
   var skip = false;
   if (dropDown) {
      debug("got dropDown [" + dropDown.id + "]");
      // See if we can skip this action (the --- Select Action --- is selected).
      if (dropDown.selectedIndex == 0) {
         debug("skip");
         skip = true;
      }
      // See if this is a table action (not a user one).
      else if (dropDown.options[dropDown.selectedIndex].value.indexOf("user(") == -1) {
         debug("ajax");
         ajax = true;
      }
   }
   if (!skip) {
      if (ajax) {
         result = doAnchorAjax(formName, actionValue, anchorName, wclhidden, wclanchor, userActions);
      }
      else {
         result = doAnchor(formName, anchorName, wclanchor);
         if (userActions) {
            var form = document.forms[formName];
            form.submit();
         }
      }
   }
   debug("-->doUserActionAjax : " + result);
   return result;
}

/** WTable **
 * formName - the encoded name of the form
 * actionValue - the name of the component performing the action
 * anchorName - the name of the anchor used when the page is refreshed
 * wclhidden - the encoded name of the hidden field
 * wclanchor - the encoded name of the hidden field for the anchor
 * userActions - the optional userActions ID, will be used as hidden
 */
function doAnchorAjax(formName, actionValue, anchorName, wclhidden, wclanchor, userActions) {
   debug("-->doAnchorAjax");
   var form = document.forms[formName];
   if (form != null && anchorName != null && wclanchor != null) {
      var aDate = new Date().getTime();
      eval("form." + wclanchor + ".value = '" + aDate + "'");
      if (actionValue != null && actionValue.length > 0) {
         if (userActions) {
            eval("form." + wclhidden + ".value = '" + userActions + "'");
         }
         else {
            eval("form." + wclhidden + ".value = '" + wclhidden + "'");
         }
      }

      var inputName = "wclAnchorHash";
      var input  = document.getElementById( inputName );
      if ( !input )
      {
          input = document.createElement( "INPUT" );
          with ( input )
          {
              type  = "hidden";
              id    = inputName;
              name  = inputName;
          }
          form.appendChild( input );
      }
      input.value = anchorName;

      if (actionValue != null && actionValue.length > 0) {
         debug("doAnchorAjax calling startRequest...");
         startRequest(form, actionValue);
         // Reset the form values.
         eval("form." + wclanchor + ".value = ''");
         eval("form." + wclhidden + ".value = ''");
         return false;
      }
   }
   debug("<--doAnchorAjax");
   return true;
}

/** WTable **
 * formName - the encoded name of the form
 * actionName - the name of the action being performed
 * actionValue - the name of the component performing the action
 * anchorName - the name of the anchor used when the page is refreshed
 * actionNameEnc - the encoded name of the action being performed
 * wclhidden - the encoded name of the hidden field
 * wclanchor - the encoded name of the hidden field for the anchor
 */
function doTblAjax(formName, actionName, actionValue, anchorName, actionNameEnc, wclhidden, wclanchor, event) {
   if ( event != null ) {
      //if user ctrl-/shift-/alt-clicked for table action, prevent action from opening new tab/window/etc
      if ( event.ctrlKey || event.shiftKey || event.altKey ) {
         if ( event.preventDefault ) {
            //W3C Model, Mozilla/Opera
            event.preventDefault();
            event.stopPropagation();
         } else {
            //Microsoft Model, IE
            event.returnValue = false;
            event.cancelBubble = true;
         }

         //if shift-click, turn actionValue "select(n)" into "select(multi-n)"
         if ( event.shiftKey && actionValue.indexOf("select") != -1 ) {
            var re = /(select\()(\d*\))/;
            actionValue = actionValue.replace(re, "$1multi-$2");
         }
      }//endIf
   }//endIf

   if (document != null && document.forms != null && formName != null) {
      var form = document.forms[formName];
      if (form != null) {
         if (actionName != null) {
            eval("form." + actionNameEnc + ".value = '" + actionValue + "'");
            eval("form." + wclhidden + ".value = '" + actionName + "'");
         }

         debug("actionNameEnc = " + actionNameEnc);
         debug("actionValue = " + actionValue);

         debug("AJAX request with action = " + form.action);
         startRequest(form, null);
         // Reset the form values.
         eval("form." + actionNameEnc + ".value = ''");
         eval("form." + wclhidden + ".value = ''");
      }
      return false;
   }
}

/** WTable **
 * refreshes the portlet by adding a 1px column onto the end.
 */
function refreshAjaxContainer(dataBodyEnc)
{
   debug("refreshAjaxContainer");
   var ajaxComponent = document.getElementById(dataBodyEnc);
   var ajaxContainer = ajaxComponent.parentNode;
   // Search up the DOM until we find the AJAX page.
   while (ajaxContainer != null)
   {
      if (ajaxContainer.id)
      {
         //debug("refreshAjaxContainer : parent [" + ajaxContainer.id + "]");
         if ((ajaxContainer.id == "AJAX_CONTAINER") && (ajaxComponent.id.substring(0, 3) == "PG_"))
         {
            debug("refreshAjaxContainer : found AJAX page [" + ajaxComponent.id + "]");
            // Now look for the TD that has the class wpsPortletBorder.
            var addIt = false;
            var portlet = false;
            var parent = ajaxContainer.parentNode;
            while (parent != null)
            {
               if (parent.tagName && (parent.tagName == "TD") && parent.className && (parent.className == "wpsPortletBorder"))
               {
                  debug("refreshAjaxContainer : found wpsPortletBorder");
                  portlet = true;
               }
               parent = parent.parentNode;
               if (portlet && parent.tagName && (parent.tagName == "TR"))
               {
                  debug("refreshAjaxContainer : found TR containing portlet");
                  addIt = true;
                  break;
               }
            }
            if (addIt)
            {
               // Make sure we haven't already added the column.
               var componentId = ajaxComponent.id + "_AjaxRefresh";
               if (document.getElementById(componentId) == null)
               {
                  debug("refreshAjaxContainer : adding extra column");
                  var td = document.createElement('TD');
                  parent.appendChild(td);
                  td.id = componentId;
                  td.width = '1px';
                  setTimeout("finishRefreshAjaxContainer('" + componentId + "')", 0);
               }
            }
            break;
         }
      }
      // Keep searching up the DOM.
      ajaxComponent = ajaxContainer;
      ajaxContainer = ajaxContainer.parentNode;
   }
}

/** WTable **
 * removes the added column from to finish the refresh.
 */
function finishRefreshAjaxContainer(componentId)
{
   debug("finishRefreshAjaxContainer(" + componentId + ")");
   var component = document.getElementById(componentId);
   component.parentNode.removeChild(component);
}

/** WTable (scrolling)**
 * setup table for scrolling
 */
function setupTableAjax(dataBodyEnc, resetTable, actionName)
{
   debug("Running setupTableAjax [" + dataBodyEnc + "]");
   var dataBody = document.getElementById(dataBodyEnc);

   if (dataBody != null) {
      // Unhide any rows that we hide to keep Firefox from jiggling.
      if (dataBody.childNodes[dataBody.childNodes.length - 1].style.display == 'none') {
         for (var i = 0; i < dataBody.childNodes.length; ++i) {
            dataBody.childNodes[i].style.display = '';
         }
      }

      if (dataBody.offsetHeight > 0) {
         var scrollPaneEnc = dataBody.getAttribute('SPID');
         var scrollPane = document.getElementById(scrollPaneEnc);
         if ( scrollPane.onscroll != null ) {
            setScrollLock(scrollPaneEnc, "true");
         }

         if ( resetTable == null ) {
            resetTable = false;
         } else if ( resetTable ) {
            minimizeTable(dataBodyEnc);
         }

         // Get where we should scroll to.
         if (scrollPane.getAttribute('H1BID')) {
            if (isResizeNeeded(actionName)) {
               resizeDivAjax(scrollPaneEnc, resetTable);
            } else {
               resizeDivAjaxPostUpdate(scrollPaneEnc);
            }
         }

         adjustTableHeightAjax(dataBodyEnc);

         setScrollTopAjax(scrollPaneEnc);
         if ( scrollPane.onscroll != null ) {
            setTimeout("setScrollLock('" + scrollPaneEnc + "', 'false')", 500);
         }

         // Firefox won't shrink portlets after an embedded table dialog
         // closes so let's make it redraw the portlet.
         if (WClient.isBrowserMozilla()) {
            setTimeout("refreshAjaxContainer('" + dataBodyEnc + "')", 0);
         }
      }
      else {
         debugErr("Setting table timer");
         setTimeout("setupTableAjax('" + dataBodyEnc + "', " + resetTable + ", '" + actionName + "')", 10);
      }
   }
   else {
      debugErr("setupTableAjax: databody is null");
   }
}


//isResizeNeeded
//returns false if the given WTable actionName indicates an ajax update was
//performed that does not require the table div to be resized (toggleSort,
//select, clearSorts, toggleFilterRow, editSort, clearColumnConfig, editFilter)
// -in: actionName - WTable action name string
// -out: false if actionName indicates that a refresh is not needed, true otherwise
function isResizeNeeded(actionName) {
   if ( actionName == null ) {
      return true;
   }
   if ( actionName == 'toggleSort' || actionName == 'select'
     || actionName == 'clearSorts' || actionName == 'toggleFilterRow'
     || actionName == 'editSort'   || actionName == 'clearColumnConfig'
     || actionName == 'editFilter' )
   {
      return false;
   }
   return true;
}


//adjustTableHeaderHeight
//resize the table header row resizer images to the full height of their
//containing cell (needed if the table header text contains breakrules)
// -in: divId - table div id
// -out: none
function adjustTableHeaderHeight(divID) {
    debug("Running adjustTableHeaderHeight: " + divID);
    var div = document.getElementById(divID);
    if (div != null) {
        var headBody1 = document.getElementById(div.getAttribute('H1BID'));
        var headBody2 = document.getElementById(div.getAttribute('H2BID'));
        var cellCount = headBody2.rows[0].cells.length-1;

        //set header row/resizer height in case column headers contain breakrules
        try {
            //abort if header height was already adjusted, avoiding a flash in firefox on windows
            var head1 = headBody1.rows[0].cells[0];
            if ( head1.firstChild.rows[0].lastChild.height == head1.firstChild.rows[0].height
              && head1.firstChild.rows[0].lastChild.height == head1.firstChild.rows[0].lastChild.firstChild.height )
            {
                return;
            }

            for (var c = 0; c < cellCount; c++) {
                head1 = headBody1.rows[0].cells[c];
                head1.firstChild.rows[0].height = '100%';
                head1.firstChild.rows[0].lastChild.height = '100%';
                head1.firstChild.rows[0].lastChild.firstChild.height = '100%';
            }

            var clientHeightHb = headBody1.clientHeight - 2;
            var clientHeightTr = headBody1.rows[0].clientHeight - 2;
            var clientHeightTd = headBody1.rows[0].cells[0].clientHeight - 2;

            if ( WClient.isBrowserInternetExplorer() ) {
                clientHeightHb = clientHeightTr;
                clientHeightTr = clientHeightTr;
                clientHeightTd = clientHeightTr;
            }

            for (var c = 0; c < cellCount; c++) {
                head1 = headBody1.rows[0].cells[c];
                head1.firstChild.rows[0].height = clientHeightHb;
                head1.firstChild.rows[0].lastChild.height = clientHeightTr;
                head1.firstChild.rows[0].lastChild.firstChild.height = clientHeightTd;
            }
        } catch (e) {
        }
    }
}


/** WTable (scrolling)**
 * handles resize of div after an ajax refresh that does not require a complete
 * resize (toggleSort, select, clearSorts, toggleFilterRow, editSort,
 * clearColumnConfig, editFilter)
 */
function resizeDivAjaxPostUpdate(divID) {
   debug("Running resizeDivAjaxPostUpdate: " + divID);
   var div = document.getElementById(divID);
   if (div != null) {
      var headBody1 = document.getElementById(div.getAttribute('H1BID'));
      var headBody2 = document.getElementById(div.getAttribute('H2BID'));
      var tableStyle = headBody2.parentNode.style;

      if ( WClient.isBrowserInternetExplorer() ) {
         //disable autosizing
         tableStyle.display = 'none';
         tableStyle.tableLayout = 'fixed';
         tableStyle.display = '';
      }

      //increase header row height, in case column headers contain breakrules
      adjustTableHeaderHeight(divID);
   }
   else
      debugErr("resizeDivAjaxPostUpdate: div is null");
}


/** WTable (scrolling)**
 * handles resize of div
 */
function resizeDivAjax(divID, resetTable)
{
   debug("Running resizeDivAjax: " + divID + " " + resetTable);
   if ( resetTable == null ) {
      resetTable = false;
   }
   if ( WClient.isBrowserInternetExplorer() ) {
       resizeDivAjaxIE(divID, resetTable);
   } else {
       resizeDivAjaxMoz(divID, resetTable);
   }
}


/** WTable (scrolling)**
 * handles resize of div for IE
 */
function resizeDivAjaxIE(divID, resetTable)
{
   debug("Running resizeDivAjaxIE: " + divID + " " + resetTable);
   var div = document.getElementById(divID);
   var resizeOption = div.getAttribute("resizeOption") == null ? '' : div.getAttribute("resizeOption");
   var headBody1 = document.getElementById(div.getAttribute('H1BID'));
   var headBody2 = document.getElementById(div.getAttribute('H2BID'));
   var tableStyle = headBody2.parentNode.style;
   var cellCount = headBody2.rows[0].cells.length-1;
   var widths = new Array(cellCount);
   var init = ( headBody1.rows[0].cells[0].getAttribute("initWidth") == null );
   var preset =  ( !resetTable && init && headBody1.rows[0].cells[0].width != '' ) || ( resetTable && headBody1.rows[0].cells[0].getAttribute("prefWidth") != null );
   tableStyle.tableLayout = 'auto';

   var totalWidth = 0;
   var justifiedWidthShrink  = 0;    //width to play with when columns have to shrink
   var justifiedWidthEnlarge = 0;    //width to play with when columns have to enlarge

   if ( resetTable || init ) {
      for (var c = 0; c < cellCount; c++) {
         var head1 = headBody1.rows[0].cells[c];
         var head2 = headBody2.rows[0].cells[c];

         head1.style.tableLayout = 'auto';
         head2.firstChild.style.tableLayout = 'auto';

         if ( preset && head1.getAttribute("prefWidth") == null ) {
            head1.setAttribute("prefWidth", head1.width);
         }

         widths[c] = ( preset ) ? head1.width : parseInt(head2.offsetWidth);
         totalWidth += widths[c];

         var justify = head1.getAttribute("justify");
         if ( justify == "shrink"  || justify == "shrinkAndEnlarge" ) {
           justifiedWidthShrink += widths[c];
         }
         if ( justify == "enlarge" || justify == "shrinkAndEnlarge" ) {
           justifiedWidthEnlarge += widths[c];
         }

         //init column min/maxWidth values
         if ( init ) {
            head1.setAttribute("initWidth", widths[c]);
            initColumnMinMaxWidths(divID, c, widths[c]);
         }
      }
   } else {
      for (var c = 0; c < cellCount; c++) {
         var head1 = headBody1.rows[0].cells[c];
         var head2 = headBody2.rows[0].cells[c];
         head2.firstChild.style.tableLayout = 'fixed';
         widths[c] = head1.width;
      }
   }

   tableStyle.display = 'none';
   tableStyle.tableLayout = 'fixed';
   tableStyle.display = '';

   //width to play with (because this table is either shrinking or enlarging)
   var tableWidth = headBody1.offsetWidth;
   var justifiedWidth = ( tableWidth - totalWidth < 0 ) ? justifiedWidthShrink : justifiedWidthEnlarge;

   var misc = 0;
   var cellSum = 0;
   for (var c = 0; c < cellCount; c++) {
       var head1 = headBody1.rows[0].cells[c];
       var head2 = headBody2.rows[0].cells[c];
       var shrunk = false;

       //justify column
       if ( !preset && ( resetTable || init ) ) {
          if ( c == cellCount-1 && resizeOption == "WTableResizeLast" ) {
              shrunk = true;
              widths[c] = "100%";
          } else if ( c == cellCount-1 && resizeOption == "WTableResizeEndColumns" && tableWidth != totalWidth ) {
              widths[c] = Math.max(head1.offsetWidth,tableWidth-cellSum);
          } else if ( justifiedWidth > 0 && head1.getAttribute("justify") != "none" && tableWidth != totalWidth) {
              if ( ( tableWidth - totalWidth <  0  && head1.getAttribute("justify") != "enlarge" )
                || ( tableWidth - totalWidth >= 0  && head1.getAttribute("justify") != "shrink"  ) )
              {
                 widths[c] = widths[c] + Math.round( (tableWidth - totalWidth) * (widths[c] / justifiedWidth) );
                 if ( c == cellCount - 1 ) {
                    widths[c] = widths[c] - misc;
                 }
              }
              if ( widths[c] < getColumnMinWidth(head1) ) {
                 misc = misc + getColumnMinWidth(head1) - widths[c];
                 widths[c] = getColumnMinWidth(head1);
              }
          }
       }

       widths[c] = Math.max(MIN_COL_WIDTH, widths[c]);

       //head2.width = head1.width = widths[c];
       head2.width = head1.width = ( widths[c] != '' ) ? widths[c] : head1.width;
       cellSum = cellSum + parseInt(head2.width);

       // Send all column widths up to the server so the returned table
       // isn't completely different than the formatted one because that
       // causes the table to jiggle in Firefox. It also allows us to
       // keep the DOM table in synch with what the server generates so
       // that in portal we can tell if the table really changed.
       try {
           head1.firstChild.rows[0].lastChild.lastChild.value = widths[c];
       }
       catch (widthError) {
           debug("Error setting table column width: [" + widthError.name + "] [" + widthError.message + "]");
       }
   }

   if ( resetTable || init ) {
      headBody2.setAttribute("initWidth", tableWidth);
   }

   //set table background to table header width
   if ( cellSum <= headBody2.getAttribute("initWidth") ) {
      headBody2.parentNode.width = headBody2.getAttribute("initWidth");
   }

   //increase header row height, in case column headers contain breakrules
   adjustTableHeaderHeight(divID);
   debug("Exiting resizeDivAjaxIE: " + divID + " " + resetTable);
}

/** WTable (scrolling)**
 * handles resize of div for Mozilla
 */
function resizeDivAjaxMoz(divID, resetTable)
{
   debug("Running resizeDivAjaxMoz: " + divID + " " + resetTable);
   var div = document.getElementById(divID);
   var resizeOption = div.getAttribute("resizeOption") == null ? '' : div.getAttribute("resizeOption");
   var headBody1 = document.getElementById(div.getAttribute('H1BID'));
   var headBody2 = document.getElementById(div.getAttribute('H2BID'));
   var tableStyle  = headBody2.parentNode.style;
   var tableStyle1 = headBody1.style;
   var cellCount = headBody2.rows[0].cells.length-1;
   var widths = new Array(cellCount);
   var init = ( headBody1.rows[0].cells[0].getAttribute("initWidth") == null );
   var preset =  ( !resetTable && init && headBody1.rows[0].cells[0].width != '' ) || ( resetTable && headBody1.rows[0].cells[0].getAttribute("prefWidth") != null );
   var presetWidths = new Array(cellCount);

   var totalWidth = 0;

   div.style.width='0px';           //shrink div to content
   headBody1.style.width='0px';     //shrink header table to content
   headBody2.style.width='0px';     //shrink data table to content

   if ( resetTable || init ) {
      var justifiedWidthShrink  = 0;   //width to play with when columns have to shrink
      var justifiedWidthEnlarge = 0;   //width to play with when columns have to enlarge

      headBody2.setAttribute("initWidth", div.parentNode.clientWidth);

      for (var c = 0; c < cellCount; c++) {
         var head1 = headBody1.rows[0].cells[c];
         var head2 = headBody2.rows[0].cells[c];
         head2.firstChild.style.tableLayout = 'auto';

         if ( preset && head1.getAttribute("prefWidth") == null ) {
            head1.setAttribute("prefWidth", head1.width);
         }

         widths[c] = parseInt( ( preset ) ? head1.width
                                          : ( (resetTable) ? ( (head1.getAttribute("initWidth") == null) ? head1.width : head1.getAttribute("initWidth") )
                                                           : head2.offsetWidth ) );

         totalWidth += widths[c];
         var justify = head1.getAttribute("justify");
         if ( justify == "shrink"  || justify == "shrinkAndEnlarge" ) {
           justifiedWidthShrink += widths[c];
         }
         if ( justify == "enlarge" || justify == "shrinkAndEnlarge" ) {
           justifiedWidthEnlarge += widths[c];
         }

         //init column min/maxWidth values
         if ( init ) {
            head1.setAttribute("initWidth", widths[c]);
            initColumnMinMaxWidths(divID, c, widths[c]);
         }
      }
   } else {
      //drag and drop resizing going on
      for (var c = 0; c < cellCount; c++) {
         var head1 = headBody1.rows[0].cells[c];
         var head2 = headBody2.rows[0].cells[c];
         head2.firstChild.style.tableLayout = 'fixed';
         widths[c] = head1.width;
      }
   }

   //width to play with (because this table is either shrinking or enlarging)
   var justifiedWidth = ( headBody1.offsetWidth - totalWidth < 0 ) ? justifiedWidthShrink : justifiedWidthEnlarge;

   //disable autosizing
   tableStyle.tableLayout  = 'fixed';
   tableStyle1.tableLayout = 'fixed';
   tableStyle.overflow = 'hidden';
   div.style.width = '100%';
   headBody1.style.overflowX='hidden';
   headBody2.style.overflowX='hidden';

   //set fixed column widths
   var misc = 0;
   var cellSum = 0;
   for (var c = 0; c < cellCount; c++) {
      var head1 = headBody1.rows[0].cells[c];
      var head2 = headBody2.rows[0].cells[c];
      var shrunk = false;
      var cellPadding = ( WClient.isBrowserInternetExplorer() ) ? 0 : (parseInt(head1.style.borderLeftWidth) + parseInt(head1.style.borderRightWidth));

      //justify column
      if ( head1.getAttribute("justify") != "none" && !preset && ( resetTable || init ) ) {
         if ( c == cellCount-1 && resizeOption == "WTableResizeLast" ) {
            shrunk = true;
            widths[c] = "100%";
         } else if ( c == cellCount-1 && resizeOption == "WTableResizeEndColumns" && headBody1.offsetWidth != totalWidth ) {
            widths[c] = widths[c] + Math.round( (headBody1.offsetWidth - totalWidth) * (widths[c] / justifiedWidth) ) - cellPadding - misc;
         } else if ( justifiedWidth > 0 && headBody1.offsetWidth != totalWidth) {
            if ( ( headBody1.offsetWidth - totalWidth <  0  && head1.getAttribute("justify") != "enlarge" )
              || ( headBody1.offsetWidth - totalWidth >= 0  && head1.getAttribute("justify") != "shrink"  ) )
            {
               widths[c] = widths[c] + Math.round( (headBody1.offsetWidth - totalWidth) * (widths[c] / justifiedWidth) ) - cellPadding;
               if ( c == cellCount - 1 ) {
                   widths[c] = widths[c] - misc;
               }
            }
            if ( widths[c] < getColumnMinWidth(head1) ) {
               misc = misc + getColumnMinWidth(head1) - widths[c];
               widths[c] = getColumnMinWidth(head1);
            }
         }
      }

      widths[c] = Math.max(MIN_COL_WIDTH, widths[c]);
      cellSum = cellSum + parseInt(widths[c]) + parseInt(cellPadding);

      head1.width = widths[c];
      head2.width = head1.width;
      head2.firstChild.width = head1.width;

      // Send all column widths up to the server so the returned table
      // isn't completely different than the formatted one because that
      // causes the table to jiggle in Firefox. It also allows us to
      // keep the DOM table in synch with what the server generates so
      // that in portal we can tell if the table really changed.
      try {
          head1.firstChild.rows[0].lastChild.lastChild.value = widths[c];
      }
      catch (widthError) {
          debug("Error setting table column width: [" + widthError.name + "] [" + widthError.message + "]");
      }
   }

   //increase header row height, in case column headers contain breakrules
   adjustTableHeaderHeight(divID);

   headBody2.width = Math.max(cellSum, headBody2.getAttribute("initWidth"));
   headBody2.style.marginRight = "0px";
   headBody2.style.paddingRight = "0px";
   div.firstChild.border="0px";
   debug("Exiting resizeDivAjaxMoz: " + divID + " " + resetTable);
}


/** WTable (scrolling)**
 * handles scroll of table
 */
function setScrollPositionAjax(scroller)
{
   var scrollDiv = document.getElementById(scroller);
   if (scrollDiv != null) {
      var scrollPos = scrollDiv.scrollTop;
      scrollDiv.firstChild.value = scrollPos;
   }
}

/** WTable (scrolling)**
 * set scroll top value based on scroll position value
 */
function setScrollTopAjax(scroller)
{
   var scrollDiv = document.getElementById(scroller);
   if (scrollDiv != null) {
      var scrollPos = scrollDiv.firstChild.value;
      scrollDiv.scrollTop = scrollPos;
   }
}

/** WTableColumn (drag-n-drop)**
 * handles resize of table columns
 */
function tcDNDAjax(event, evtCode, columnId, divID)
{
   if (!isAJAXOutstanding) {
      debug("inside tcDNDAjax");
      var wevent = new WEvent(event);
      var column = document.getElementById(columnId);

      switch (evtCode) {
      case 1: // mouseDown (grab)
         if (!column.isDragging)
         {
            var cells = column.firstChild.rows[0].cells;
            column.isDragging = true;
            column.startPosition = column.currentPosition = wevent.getPagePosition();
            column.startWidth = WUtilities.getWidth(column);
            // save document's mouse handlers
            document._onselectstart = document.onselectstart;
            document._onmousemove = document.onmousemove;
            document._onmouseup = document.onmouseup;
            document.body._cursor = document.body.style.cursor;
            // temporarily override document's mouse handlers
            document.onselectstart = new Function("event", "return false;");
            document.onmousemove = new Function("event", "return tcDNDAjax(event, 2, '" + columnId + "', '" + divID + "');");
            document.onmouseup = new Function("event", "return tcDNDAjax(event, 3, '" + columnId + "', '');");
            document.body.style.cursor = "e-resize";

            return false;
         }
         break;
      case 2: // mouseMove (drag)
         if (column.isDragging)
         {
            var mousePosition = wevent.getPagePosition();
            var difference = mousePosition.getX() - column.startPosition.getX();
            var div = document.getElementById(divID);
            if(div != null){
              var bidi = div.getAttribute("BIDI");

              if (bidi)
                difference = -difference;
            }

            column.width = Math.min(Math.max(column.startWidth + difference, column.minWidth), column.maxWidth) + "px";
            column.currentPosition = mousePosition;

            if(div != null){
              resizeDivAjax(divID, column);
            }

            return false;
         }
         break;
      case 3: // mouseUp (drop)
         if (column.isDragging)
         {
            column.isDragging = false;
            // restore document's mouse handlers
            document.onselectstart = document._onselectstart;
            document.onmousemove = document._onmousemove;
            document.onmouseup = document._onmouseup;
            document.body.style.cursor = document.body._cursor;
            // save width
            var input = column.firstChild.rows[0].lastChild.lastChild;

            input.value = column.width ? column.width : "-1";

            return false;
         }
         break;
      }
   }
   return true;
}

/** WTableColumn (successive drag-n-drop)**
 * handles successive resize of table columns
 */
function tcSDNDAjax(event, evtCode, columnId, divID, colUrl)
{
   if (!isAJAXOutstanding) {
      debug("inside tcSDNDAjax");
      var wevent = new WEvent(event);
      var div = document.getElementById(divID);
      if( div == null ) {
         return;
      }
      var headBody1 = document.getElementById(div.getAttribute('H1BID'));
      var colCount = headBody1.rows[0].cells.length-1;

      //init tableColumn id -> columndIndex hash
      var tableColumns = new Array();
      for (var c = 0; c < colCount; c++) {
         var head1 = headBody1.rows[0].cells[c];
         tableColumns[head1.id] = c;
      }

      if ( tableColumns[columnId] == null ) {
         return;
      }

      //document.getElementById returns the head2 decendant with id=columnId after an AJAX update,
      //so get column from its tableColumns index into head1's first row
      var column = headBody1.rows[0].cells[tableColumns[columnId]];

      switch (evtCode) {
      case 1: // mouseDown (grab)
         if (!column.isDragging)
         {
            if ( div.onscroll != null ) {
               setScrollLock(divID, "true");
            }
            column.isDragging = true;
            column.startPosition = column.currentPosition = wevent.getPagePosition();
            column.startWidth = WUtilities.getWidth(column);
            // save document's mouse handlers
            document._onselectstart = document.onselectstart;
            document._onmousemove = document.onmousemove;
            document._onmouseup = document.onmouseup;
            document.body._cursor = document.body.style.cursor;
            // temporarily override document's mouse handlers
            document.onselectstart = new Function("event", "return false;");
            document.onmousemove = new Function("event", "return tcSDNDAjax(event, 2, '" + columnId + "', '" + divID + "', '" + colUrl + "');");
            document.onmouseup = new Function("event", "return tcSDNDAjax(event, 3, '" + columnId + "', '" + divID + "', '" + colUrl + "');");
            document.body.style.cursor = "e-resize";

            //loop over columns and ensure column's needed values are set
            for (var i=tableColumns[column.id]-1; i >= 0; i--) {
               var currColumn = headBody1.rows[0].cells[i];
               currColumn.startWidth = WUtilities.getWidth(currColumn);
            }

            return false;
         }
         break;
      case 2: // mouseMove (drag)
         if (column.isDragging)
         {
            var mousePosition = wevent.getPagePosition();
            var difference = mousePosition.getX() - column.startPosition.getX();
            var div = document.getElementById(divID);
            if(div != null){
              var bidi = div.getAttribute("BIDI");

              if (bidi)
                difference = -difference;
            }

            columnWidth = column.startWidth + difference;
            column.currentPosition = mousePosition;

            if ( columnWidth < MIN_COL_WIDTH && tableColumns != null && tableColumns[columnId] != null ) {
               //successive shrinking
               var columnIndex = tableColumns[columnId]; //get column index from table columns hash (init by setupTable)
               var i = 1;
               var done = false;
               var startWidth = column.startWidth;

               column.width = MIN_COL_WIDTH;
               var cellPadding = ( WClient.isBrowserInternetExplorer() ) ? 0 : (parseInt(column.style.borderLeftWidth) + parseInt(column.style.borderRightWidth));
               if ( column.startWidth - parseInt(column.width) > 0 ) {
                  column.startPosition = new Position(column.startPosition.getX() - (column.startWidth - parseInt(column.width) - cellPadding), column.startPosition.getY(), column.startPosition.getZ());
               }
               difference = difference + column.startWidth - parseInt(column.width);
               column.startWidth = parseInt(column.width);

               //may need to loop through columns if previous column is already minWidth
               while ( columnIndex-i >= 0 && !done ) {
                  var prevColumn = headBody1.rows[0].cells[columnIndex-i];
                  prevColumn.width = Math.max(prevColumn.startWidth + difference, MIN_COL_WIDTH);
                  prevColumn.isDragging = true;  //flag column as dragging, so that its width is properly stored by drop case (below)

                  //if prevColumn is already minWidth, skip to column preceeding it
                  if ( parseInt(prevColumn.width) <= MIN_COL_WIDTH ) {
                     if ( prevColumn.startWidth - parseInt(prevColumn.width) > 0 ) {
                        column.startPosition = new Position(column.startPosition.getX() - (prevColumn.startWidth - parseInt(prevColumn.width) - cellPadding), column.startPosition.getY(), column.startPosition.getZ());
                     }
                     difference = difference + prevColumn.startWidth - parseInt(prevColumn.width);
                     prevColumn.startWidth = parseInt(prevColumn.width);
                     i++;
                  } else {
                     done = true;
                  }
               }
            } else {
               column.width = columnWidth;
            }

            resizeDivAjax(divID, false);

            return false;
         }
         break;
      case 3: // mouseUp (drop)
         if (column.isDragging)
         {
            column.isDragging = false;
            // restore document's mouse handlers
            document.onselectstart = document._onselectstart;
            document.onmousemove = document._onmousemove;
            document.onmouseup = document._onmouseup;
            document.body.style.cursor = document.body._cursor;
            // save width
            var input = column.firstChild.rows[0].lastChild.lastChild;

            input.value = column.width ? column.width : "-1";
            column.startWidth = WUtilities.getWidth(column);

            //loop over all isDragging columns, saving their width
            var done = false;
            for (var i=tableColumns[columnId]-1; i >= 0 && !done; i--){
               var currColumn = headBody1.rows[0].cells[i];

               if (currColumn.isDragging) {
                  currColumn.isDragging = false;
                  // save width
                  var input = currColumn.firstChild.rows[0].lastChild.lastChild;

                  input.value = currColumn.width ? currColumn.width : "-1";
                  currColumn.startWidth = WUtilities.getWidth(currColumn);
               } else {
                  done = true;
               }

               currColumn.setAttribute("prefWidth", currColumn.width);
            }

            //save column widths if external method is defined
            if ( typeof saveColumnWidthsAjax == 'function' ) {
               saveColumnWidthsAjax(divID, colUrl);
            }
            setScrollTopAjax(divID);
            if ( div.onscroll != null ) {
               setTimeout("setScrollLock('" + divID + "', 'false')", 500);
            }
            return false;
         }
         break;
      }
   }
   return true;
}

/** WTable
 * set table height based on set rows per viewport value and update ajax value
 */
function adjustTableHeightAjax(dataBodyEnc) {
    var dataBody = document.getElementById(dataBodyEnc);
    if ( !dataBody ) {
       return;
    }
    var autosize = ( dataBody.getAttribute("autorpv") == "true" );

    var rpvArray = adjustTableHeight(dataBodyEnc);
    var viewRows = rpvArray[0];
    var rpvMax = rpvArray[1];

    if ( autosize ) {
        dataBody.setAttribute("rpv_init", "-1");  //initially flagged for autosize

        var scrollPaneEnc = dataBody.getAttribute('SPID');
        var scrollPane = document.getElementById(scrollPaneEnc);

        if (scrollPane != null) {
            scrollPane.childNodes[1].value = viewRows;
            scrollPane.childNodes[2].value = rpvMax;
        }
    }
}
