package OSInstall::Remote_Resource;

use strict;
use warnings;
use Carp;
use OSInstall::Common;
#use OSInstall::Platform_Tools;
our $AUTOLOAD;

my %modifiable_fields= (
		name => "",
		communication_method => "ssh",
		ready => "",
		clients_allocated => {}, # empty hash ref
	);

my %constant_fields= (
		server => "",
		type => "",
		remote_identifier => "",
	);

sub define
{
	my $class_name= shift;
	my $this; #empty % ref that we will bless into an object
	
	#the first four args are required
	confess "usage OSInstall::Remote_Resource->define(name, server, type, remote_identifier[, communication_method, clients_allocated])\n" unless (@_ >= 4);

	$modifiable_fields{name}= shift;
	$constant_fields{server}= shift;
	$constant_fields{type}= shift;
	$constant_fields{remote_identifier}= shift;
	$modifiable_fields{communication_method}= shift if (@_);
	$modifiable_fields{clients_allocated} = shift if (@_);

	$modifiable_fields{ready} = shift if (@_);
	
	# see AUTOLOAD below for what _modifiable does- it's not meant for direct external use
	$this= {
		_modifiable => \%modifiable_fields,
		_constant => \%constant_fields,
		%modifiable_fields,
		%constant_fields,
	};

	bless $this, $class_name;
	return $this;
}

sub AUTOLOAD
{
	my $this= shift; #ref to the class
	my $class_name= ref($this);
	my $param= shift; 

	#must take a reference to this class
	croak "Invalid reference type\n" unless ($class_name =~ /^(?:OSInstall::)?\w+_Remote$/);

	my $attr= $AUTOLOAD; #the field we're autoloading
	$attr =~ s/.*://; #strip out full package name

	#error if we don't have this field
	croak "The field \"$attr\" does not exist\n" unless (exists $this->{$attr});

	# if we have a parameter to set the attr to, make sure it's a modifiable attr
	if ($param)
	{
		# croak if this field is not modifiable
		croak "This field cannot be modified\n" unless (exists $this->{_modifiable}->{$attr});

		$this->{$attr}= $param; #damage is done
	}

	return $this->{$attr};
}

#########################################################################
# The functions below will be overridden by the implementing subclasses	#
# but will be empty here (kind of like pure virtual functions)		#
#########################################################################

sub allocate
{
	1;
}

sub verify
{
	1;
}

sub get_install_status
{
	1;
}

sub monitor
{
	1;
}

sub deallocate
{
	1;
}

sub destroy
{
	1;
}

1;

