// hottopics.js
// NLS_CHARSET=UTF-8
//
// (C) Copyright IBM Corporation, 2003, 2005                        //
// All rights reserved. Licensed Materials Property of IBM          //
// US Government Users Restricted Rights                            //
// Use, duplication or disclosure restricted by                     //
// GSA ADP Schedule Contract with IBM Corp.                         //

//START NON-TRANSLATABLE
//////////////////////////////////////////////////////////////////////
// define simple object.
function hotTopic() {
	args=hotTopic.arguments;
	this.text = args[0];
	this.stext = args[1] || "intentionally blank";
	this.url = args[2] || "";

   this.getText = getText;
   this.getBlurb = getBlurb;
   this.getURL = getURL;
}

function getText() {
	return this.text;
}
function getBlurb(){
	return this.stext;
}
function getURL(){
	return this.url;
}
//
//////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////
// redefine the 'push' function for all browsers.
//if (Array.prototype.push && ([0].push(true)==true))
//        Array.prototype.push = null;

if(!Array.prototype.push) {
    function array_push() {
        for(i=0;i<arguments.length;i++){
            this[this.length] = arguments[i];
        }
        return this.length;
    }

    Array.prototype.push = array_push;

}
//
//////////////////////////////////////////////////////////////////////
//END NON-TRANSLATABLE

//////////////////////////////////////////////////////////////////////
// initialize an array of objects.
var quotes = new Array;
//START QUOTE TRANSLATABLE 1 2
quotes.push(new hotTopic("您可以使用「引導式設定」精靈，來配置您的「硬體管理主控台 (HMC)」。", "使用「引導式設定」精靈配置 HMC", "./iphai/confighmcgs.htm"));
quotes.push(new hotTopic("您可以建立符合您要求所自訂的伺服器設定核對清單。", "建立自訂的起始伺服器設定核對清單", "./iphaf/issintwelcome.htm"));
quotes.push(new hotTopic("您可以安裝各種硬體功能，並置換您伺服器或擴充裝置中的許多組件。", "安裝功能", "./iphaj/installcifcio.htm"));
quotes.push(new hotTopic("您可使用易讀的圖表尋找現在位於 eServer 硬體資訊中心的 pSeries 文件。", "資訊中心的 pSeries 書籍對映圖", "./icpserieslist.htm"));
quotes.push(new hotTopic("您可使用工具列來自訂導覽、變更語言等。", "使用工具列", "./icfaq.htm#usetoolbar"));
quotes.push(new hotTopic("您可對特定的頁面標上書籤。", "標書籤", "./ichelp.htm#bookmark"));
quotes.push(new hotTopic("您可使用導覽追蹤來確認您的所在位置。", "導覽追蹤", "./icfaq.htm#navtrail"));
quotes.push(new hotTopic("您可複查資訊中心針對您的作業系統支援哪些瀏覽器與 J2RE。", "受支援的環境", "./ichelp.htm#browser"));
quotes.push(new hotTopic("您可列印每一項主要主題及其子主題。", "列印", "./ichelp.htm#print"));
//END QUOTE TRANSLATABLE
// end array of objects
//////////////////////////////////////////////////////////////////////

//START QUOTE TRANSLATABLE
var strDidYouKnowHeader = "<H2>您知道嗎？</H2>";
var sDidYouKnow = "&nbsp;&nbsp;您知道嗎？";
var sSeeAllTips = "查看所有要訣";
//END QUOTE TRANSLATABLE

//START NON-TRANSLATABLE
//////////////////////////////////////////////////////////////////////
// begin execution path
var HTid=top.getHTvalue(quotes);
// end execution path
//////////////////////////////////////////////////////////////////////


//////////////////////////////////////////////////////////////////////
// suport functions
//////////////////////////////////////////////////////////////////////
// functions to create formatted strings and write to document.
function getHotTopic(){
	result = '<A class="fbox" href="'+quotes[HTid].getURL()+'" target="text">'+quotes[HTid].getText()+'</A>';
	return result;
}
function getHotTopic2(){
	result = '<A class="fbox" href="'+quotes[HTid].getURL()+'" target="text"><IMG src="./images/fw.gif" width="16" height="17" vspace="0" hspace="0" border="0" alt=""/></A>';
	return result;

}
function getHotTopic3(){
	result = '<A class="fbox" href="'+quotes[HTid].getURL()+'" target="text">'+quotes[HTid].getBlurb()+'</A>';
	return result;

}
function dumpHotTopics(){
	document.writeln(strDidYouKnowHeader);
	document.writeln('<BLOCKQUOTE>');
	for ( ht in quotes ) {
		result = '<P class="hilightbarlink" style="width: 100%;"><A href="'+quotes[ht].url+'" target="text">'+quotes[ht].stext+'</A></P>';
		result += '<P>'+quotes[ht].text+'</P>';
		document.writeln(result);
	}
	document.writeln('</BLOCKQUOTE>');
}
//////////////////////////////////////////////////////////////////////
// This hideous function is a work around for Netscape 4.x.  The function 
// creates the WHOLE callout box. Since, we cannot call a function from within
// a TD in Netscape 4.x, we cannot do the getHotTopic() calls in a callout box
// within the HTML.  That would result in an empty callout box. So we have a
// 'parent' function call in the HTML that creates the whole callout box.
// This function is not executed in Netscape 4.x, so there is no empty calloutbox.  QED.
function doDidYouKnow(){
var result='<TABLE width="150px" border="0" cellspacing="0" cellpadding="0">';
	result+=' <TR><TD height="18" class="tblue">'+sDidYouKnow+'</TD></TR>';
	result+='</TABLE>';
	result+='<TABLE cellspacing="0" cellpadding="0" border="0" width="150px">';
	result+=' <TR><TD valign="top" class="tblue">';
	result+=' <TABLE cellspacing="1px" cellpadding="0px" border="0px" width="150px">';
	result+='  <TR><TD>';
	result+='    <TABLE width="100%" border="0px" cellspacing="0px" cellpadding="5px">';
	result+='     <TR valign="middle" align="left">';
	result+='      <TD height="100px" bgcolor="#FFFFFF">';
	result+=getHotTopic();
	result+='      </TD></TR></TABLE></TD></TR>';
	result+='   <TR bgcolor="#FFFFFF"><TD>';
	result+='     <TABLE width="100%" border="0" cellspacing="0" cellpadding="0">';
	result+='      <TR colspan="3">';
	result+='       <TD colspan="3" valign="top" align="right"><IMG src="./images/c.gif" width="1" height="6" alt=""></TD>';
	result+='      </TR>';
	result+='      <TR colspan="3">';
	result+='       <TD width="20" valign="top" align="right">';
	result+=getHotTopic2();
	result+='       </TD><TD width="3">&nbsp;</TD><TD width="127">';
	result+=getHotTopic3();
	result+='       </TD></TR>';
	result+='      <TR colspan="3">';
	result+='       <TD width="20" valign="top" align="right"><A href="./hottopics.htm"><IMG src="./images/fw.gif" width="16" height="17" vspace="0" hspace="0" border="0" alt=""></A></TD>';
	result+='       <TD width="3">&nbsp;</TD>';
	result+='       <TD width="127"><A href="./hottopics.htm" target="text" class="fbox">'+sSeeAllTips+'</A></TD>';
	result+='      </TR><TR colspan="3"><TD colspan="3" valign="top" align="right"><IMG src="./images/c.gif" width="1" height="6" alt=""></TD>';
	result+='      </TR></TABLE></TD></TR></TABLE></TD></TR></TABLE>';

	document.open();
	document.write(result);
	document.close();

}

//END NON-TRANSLATABLE

