// iccommon.js
// NLS_CHARSET=UTF-8
//
// (C) Copyright IBM Corporation, 2002, 2005                        //
// All rights reserved. Licensed Materials Property of IBM          //
// US Government Users Restricted Rights                            //
// Use, duplication or disclosure restricted by                     //
// GSA ADP Schedule Contract with IBM Corp.                         //

/* TRNOTE - BEGIN TRANSLATABLE VALUE */
/* Change this value to adjust the width of the frame that holds       */
/* the navigation applet.  Adjust the value to accomodate the          */
/* length of words in your language.  The value is measured in pixels  */
var nNavigationWidth = 200;
/* TRNOTE - END TRANSLATABLE VALUE */

//START NON-TRANSLATABLE

////////////////////////////////////////////////////////////////////////////////////////
// browser detection variables
////////////////////////////////////////////////////////////////////////////////////////
var detect = navigator.userAgent.toLowerCase();
var OS,browser,version,total,thestring;

if (checkIt('konqueror'))
{
	browser = "Konqueror";
	OS = "Linux";
}
else if (checkIt('omniweb')) browser = "OmniWeb"
else if (checkIt('opera')) browser = "Opera"
else if (checkIt('webtv')) browser = "WebTV";
else if (checkIt('icab')) browser = "iCab"
else if (checkIt('msie')) browser = "Internet Explorer"
else if (!checkIt('compatible'))
{
	browser = "Netscape Navigator"
	version = detect.charAt(8);
}
else browser = "An unknown browser";

if (!version) version = detect.charAt(place + thestring.length);

if (!OS)
{
	if (checkIt('linux')) OS = "Linux";
	else if (checkIt('x11')) OS = "Unix";
	else if (checkIt('mac')) OS = "Mac"
	else if (checkIt('win')) OS = "Windows"
	else OS = "an unknown operating system";
}

function checkIt(string)
{
	place = detect.indexOf(string) + 1;
	thestring = string;
	return place;
}

////////////////////////////////////////////////////////////////////////////////////////
// Define global environment variables
////////////////////////////////////////////////////////////////////////////////////////
var isNS, isNS6, isIE, isIE5, isOP5, isKhtml,isKonq, isSafari, isOmniweb45plus
function defineEnvVars(){
	////////////////////////////////////////
	// browser identification used for code branches in some places.
	isTESTING = true;
	isNS = (browser=='Netscape Navigator') ? true : false;
	isNS6 = (browser=='Netscape Navigator' && version>=5) ? true : false;
	isIE = (browser=='Internet Explorer') ? true : false;
	isIE5 = (browser=='Internet Explorer' && version>=5) ? true : false;
	isOP5 = (browser=='Opera' && version>=5) ? true : false;
	// top.dump("from rzahgcommon.js:\nbrowser="+browser+"\nisNS="+isNS+"\nisNS6="+isNS6+"\nisIE="+isIE+"\nisIE5="+isIE5+"\nisOP5="+isOP5);
	isNS = (isOP5)? true : isNS;

	// more opera
	isOP5 = (window.opera && !window.print) ? true : false;
	isOP6 = (window.opera && window.print && !document.childNodes) ? true : false;
	isOP7 = (window.opera && document.childNodes) ? true : false;

	// khtml-based browsers
	isKhtml = (navigator.vendor == 'KDE')?true:false;
	isKonq = (navigator.vendor == 'KDE')||(document.childNodes)&&(!document.all)&&(!navigator.taintEnabled)?true:false;
	isSafari = (document.childNodes)&&(!document.all)&&(!navigator.taintEnabled)&&(!navigator.accentColorName)?true:false;
	isOmniweb45plus = (document.childNodes)&&(!document.all)&&(!navigator.taintEnabled)&&(navigator.accentColorName)?true:false;

	////////////////////////////////////////
	// detect whether we are Pre-GA
	strHostname = top.location.hostname.toLowerCase( );
	isPreGA = ( (strHostname.indexOf('submit.boulder.ibm.com') != -1) ||
				(strHostname.indexOf('rchland.ibm.com') != -1)) ? true : false;
	strHostname = top.location.hostname.toLowerCase( );
	isCD = (top.location.protocol.toLowerCase().indexOf('file') != -1) ? true : false;
	delimiter = (top.location.pathname.toLowerCase().indexOf("/") != -1) ? "/" : (oldpath.indexOf("\\") != -1) ? "\\" : alert("error in filepath");
	// top.dump("top.location = "+top.location.href+"\nisPreGA = "+isPreGA+"\nisCD = "+isCD+"\ndelimiter = "+delimiter);
}

defineEnvVars();

////////////////////////////////////////////////////////////////////////////////////////
// ALTERNATIVE browser detection variables
////////////////////////////////////////////////////////////////////////////////////////
function wB() {
	var br="BR";
	if((navigator.userAgent.indexOf('Mozilla')!=-1)
	&&((navigator.userAgent.indexOf('Spoofer')==-1)
	&&(navigator.userAgent.indexOf('compatible')==-1))){
		br="NS"
	}
	return br
}

function wV(br) {
	var bv=0;
	bv=navigator.appVersion.substring(0,1);
	if(br=="IE") {
		(parseInt(bv));
	}
	if(br=="NS") {
		(parseInt(bv));
	}
	return bv;
}

function wP() {
	var os="OS";
	if(navigator.userAgent.indexOf("OS/2")!=-1) {
		os='os/2'
	}
	return os;
}

b=wB();
v=wV(b);
o=wP();

function change_bgColor() {
	if (b=="NS" && v==2 && o !="os/2"){
		document.bgColor="#999999";
	}
}

////////////////////////////////////////////////////////////////////////////////////////
// functions to manipulate layers from MacroMedia
////////////////////////////////////////////////////////////////////////////////////////
function MM_swapImgRestore() { //v3.0
  var i,x,a=document.MM_sr; for(i=0;a&&i<a.length&&(x=a[i])&&x.oSrc;i++) x.src=x.oSrc;
}

function MM_preloadImages() { //v3.0
  var d=document; if(d.images){ if(!d.MM_p) d.MM_p=new Array();
    var i,j=d.MM_p.length,a=MM_preloadImages.arguments; for(i=0; i<a.length; i++)
    if (a[i].indexOf("#")!=0){ d.MM_p[j]=new Image; d.MM_p[j++].src=a[i];}}
}

function MM_findObj(n, d) { //v4.0
  var p,i,x;  if(!d) d=document; if((p=n.indexOf("?"))>0&&parent.frames.length) {
    d=parent.frames[n.substring(p+1)].document; n=n.substring(0,p);}
  if(!(x=d[n])&&d.all) x=d.all[n]; for (i=0;!x&&i<d.forms.length;i++) x=d.forms[i][n];
  for(i=0;!x&&d.layers&&i<d.layers.length;i++) x=MM_findObj(n,d.layers[i].document);
  if(!x && document.getElementById) x=document.getElementById(n); return x;
}

function MM_swapImage() { //v3.0
  var i,j=0,x,a=MM_swapImage.arguments; document.MM_sr=new Array; for(i=0;i<(a.length-2);i+=3)
   if ((x=MM_findObj(a[i]))!=null){document.MM_sr[j++]=x; if(!x.oSrc) x.oSrc=x.src; x.src=a[i+2];}
}

function MM_showHideLayers() { //v3.1 bug fix by dvb
  var i,p,v,obj,args=MM_showHideLayers.arguments;
  for (i=0; i<(args.length-2); i+=3) if ((obj=MM_findObj(args[i]))!=null) { v=args[i+2];
    if (obj.style) { obj=obj.style; v=(v=='show')?'visible':(v=='hide')?'hidden':v; }
    obj.visibility=v; } else {if (bDebugMsgs) top.dump("MM_showHideLayers(): "+args[i]+" NOT found!");}	
} 

////////////////////////////////////////////////////////////////////////////////////////
// functions to be called by various interface files
////////////////////////////////////////////////////////////////////////////////////////
var icclient=null;
function setApplet(applet)
{
 top.dump("iccommon.js: setApplet(): running");
 icclient = applet;
}

function getApplet()
{
 return icclient;
}

function appletInitialized()
{
 top.dump("iccommon.js: appletInitialized(): running");
 
 var applet = top.navFrame.appletFrame.document.IcClient;
 top.setApplet(applet);
 
 // force sizing of navigation region 
 top.navFrame.appletFrame.resize();
 
 //update the preferences cookie
 var cookie_string = top.document.cookie;
 if (cookie_string != null || cookie_string != "" )
 {
  applet.setPreferences(cookie_string);
  applet.updatePreferences(); 
  top.document.cookie = applet.getPreferences();
 }
 else
  top.document.cookie = applet.getPreferences();

 // go to specified page if required.
 top.onLoaded();
 
// init navigation trail via appletUpdated
 appletUpdated();

 // do this last
 // store session info for Hot Topics
 setHTCookie();
}

function appletUpdated()
{
 top.dump("iccommon.js: appletUpdated(): running");
 var applet = top.getApplet();
 if (applet != null){
  top.dump("iccommon.js: appletUpdated():got applet pointer, setting nav trail.");
  top.breadcrumbs.writeToDiv(applet.getBreadcrumbs(), 'crumbs');
 } else {
  top.dump("iccommon.js: appletUpdated(): failed to get applet pointer.");
 }

 top.breadcrumbs.setButtonStates();
}

function writeToDiv(text,id)
{
	if (document.getElementById)
	{
//		top.dump("iccommon.js: writeToDiv(): using getElementById method.");
		x = document.getElementById(id);
		x.innerHTML = text;
	}
	else if (document.all)
	{
//		top.dump("iccommon.js: writeToDiv(): using document.all method.");
		x = document.all[id];
		x.innerHTML = text;
	}
	else if (document.layers)
	{
//		top.dump("iccommon.js: writeToDiv(): using document.layers method.");
		x = document.layers[id];
		text2 = '<P CLASS="testclass">' + text + '</P>';
		x.document.open();
		x.document.write(text2);
		x.document.close();
	}
}

function toggleTOC(state) {
	nWidth=top.nNavigationWidth;
	strTmp= String(nWidth)+", *";
	if (document.getElementById){
		top.dump("iccommon: using getElementById function for toggleTOC function. cool");
		if (state) 	top.document.getElementById("FSmain").cols = strTmp;
		else 		top.document.getElementById("FSmain").cols = "0, *";
	} else {
		top.dump("iccommon: no getElementById function for toggleTOC function.  ACK!");
	}
	top.dump("iccommon.js: toggleTOC(): working on repainting");
	var applet = top.getApplet();
	if (applet != null){
		top.dump("iccommon.js: toggleTOC(): got applet pointer, repainting.");
		applet.refreshDisplay();
	} else {
		top.dump("iccommon.js: toggleTOC(): failed to get applet pointer.");
	}
}
function showNavigationMaster(bShow) {
  switch (bShow){
    case false :
	  if (document.getElementById) {
	  	top.navFrame.buttonsFrame.MM_showHideLayers('TOCtoggleclose','','hide');
	  	top.searchbarFrame.MM_showHideLayers('TOCtoggleopen','','show');
	    toggleTOC(0);
	  }
      break;
    case true :
	  if (document.getElementById) {
	  	top.navFrame.buttonsFrame.MM_showHideLayers('TOCtoggleclose','','show');
	  	top.searchbarFrame.MM_showHideLayers('TOCtoggleopen','','hide');
	    toggleTOC(1);
	  }
      break;
    default : 
	  if (document.getElementById) {
	  	top.navFrame.buttonsFrame.MM_showHideLayers('TOCtoggleclose','','show');
	  	top.searchbarFrame.MM_showHideLayers('TOCtoggleopen','','hide');
	    toggleTOC(1);
	  }
  }
}
function initializeNavigation(sFrame){
// this function initializes the TOC toggle buttons in the search and nav frames.
// each frame will call this function when it is done loading.
// if non-DOM browser, then hide the controls irregardless.
	if (sFrame == 'nav'){
		if (document.getElementById){
			top.navFrame.buttonsFrame.MM_showHideLayers('TOCtoggleclose','','show');
		} else {
			top.navFrame.buttonsFrame.MM_showHideLayers('TOCtoggleclose','','hide');
		}
	} else if (sFrame == 'search'){
			top.searchbarFrame.MM_showHideLayers('TOCtoggleopen','','hide');
	} else {
		top.dump("initializeNavigation called with invalid value: "+sFrame);
	}
}
function exitHandler(){
    top.dump("iccommon.js: exitHandler executing");
    top.closeChildren();
}
////////////////////////////////////////////////////////////////////////////////////////
// Hot Topics A.K.A. Did You Know code & functions
////////////////////////////////////////////////////////////////////////////////////////
var masterHTid=null;
// This function sets the info as a session cookie.
// it called by top.appletInitialized() which executes once the icclient applet is available
function setHTCookie(){
  var applet = top.getApplet();
  if(!applet) {
    top.dump("iccommon.js: setHTCookie(): no applet");
    return;
  }
 
  if (applet!=null){
    applet.setPreference("v5r3ICHotTopicID",masterHTid);
    top.dump("iccommon.js: setHTCookie(): v5r3ICHotTopicID "+top.masterHTid);
  } else {
    top.dump("iccommon.js: setHTCookie(): failed");
  }

}
function getHTvalue(aQuotes){
  var applet = top.getApplet();
  if(!applet) {
    top.dump("iccommon.js: getHTvalue(): no applet");
    // fall through to backup method
  } else {
    masterHTid=applet.getPreference('v5r3ICHotTopicID');
    if(masterHTid==null || masterHTid=='') {
      top.dump("iccommon.js: getHTvalue(): no masterHTid from applet");
      // fall through to backup method
    } else {
      top.dump("iccommon.js: getHTvalue(): found Preference value: v5r3ICHotTopicID = "+masterHTid);
      return masterHTid;
    } 
  }
  // begin backup method
  masterHTid=getCookie('v5r3ICHotTopicID');
  top.dump("iccommon.js: getHTvalue(): found Cookie value: v5r3ICHotTopicID = "+masterHTid);
  if (!masterHTid) {
	// select random quote (integer).
	var numRand = Math.random();
	var numQuote = aQuotes.length - 1;
	masterHTid = Math.round((numQuote - 1) * numRand) + 1;
	top.dump("iccommon.js: getHTvalue(): generated masterHTid= "+masterHTid);
  }
  return masterHTid;
}
// NS 4 doesn't honor the try catch blocks
//function getHTvalue_old(aQuotes){
//  try { 
//    var applet = top.getApplet();
//    if(!applet) 
//      throw "Error 1" ;
//
//    masterHTid=applet.getPreference('v5r3ICHotTopicID');
//    if(masterHTid==null || masterHTid=='')
//      throw "Error 2";
//  
//    top.dump("iccommon.js: getHTvalue(): found Preference value: v5r3ICHotTopicID = "+masterHTid);
//    return masterHTid;
//  } 
//  catch(er) {
//    if(er == "Error 1") 
//      top.dump("iccommon.js: getHTvalue(): no applet");
//    if(er == "Error 2") 
//      top.dump("iccommon.js: getHTvalue(): no masterHTid from applet");
//  } 
//
//
//  masterHTid=getCookie('v5r3ICHotTopicID');
//  top.dump("iccommon.js: getHTvalue(): found Cookie value: v5r3ICHotTopicID = "+masterHTid);
//  if (!masterHTid) {
//	// select random quote (integer).
//	var numRand = Math.random();
//	var numQuote = aQuotes.length - 1;
//	masterHTid = Math.round((numQuote - 1) * numRand) + 1;
//	top.dump("iccommon.js: getHTvalue(): generated masterHTid= "+masterHTid);
//  }
//  return masterHTid;
//}

function getCookie(Name){
    var search = Name + "="
	if (top.document.cookie == "") return false;
    if (top.document.cookie.length > 0) { // if there are any cookies
      offset = top.document.cookie.indexOf(search)
      if (offset != -1) { // if cookie exists
        offset += search.length
        // set index of beginning of value
        end = top.document.cookie.indexOf(";", offset)
        // set index of end of cookie value
        if (end == -1)
          end = top.document.cookie.length
        return unescape(top.document.cookie.substring(offset, end))
      } else return null;
    } else return null;
}


////////////////////////////////////////////////////////////////////////////////////////
// debugging functions
////////////////////////////////////////////////////////////////////////////////////////
var bDebugMsgs = false;
var bShowErrors = false;
var nErrorCount = 0;
var wndError=null;
function errorHandler(sMsg, URL, nLine) {
	if (bShowErrors){
		//if (isNS6){
		if (false){
			dumpProperties(sMsg, "error");
		} else {
			msgArray = new Array();
			urlArray = new Array();
			lnoArray = new Array();
			
			msgArray[msgArray.length] = sMsg;
			urlArray[urlArray.length] = URL;
			lnoArray[lnoArray.length] = nLine;

			nErrorCount++;
			if (wndError != null && !wndError.closed) {
				wndError.focus();
			} else {
				wndError = window.open("","errors","height=400,width=650,scrollbars=yes,resizable=yes");
			}
			var strError = "<HTML><BODY>";
			strError += "<h2>An error has occurred on this page.</h2>";
			for (var i=0; i < msgArray.length; i++) {
				strError += "<table><tr><td style=\"background: #99CCFF;\">";
				strError += "<strong>Error:</strong> ";
				strError += "</td></tr><tr><td>";
				strError +=  msgArray[i];
				strError += "</td></tr><tr><td style=\"background: #99CCFF;\">";
				strError += "<strong>URL:</strong> ";
				strError += "</td></tr><tr><td>";
				strError +=  urlArray[i] + "&nbsp;&nbsp;";
				strError += "<strong>Line:</strong> " + lnoArray[i] + "<BR>";
				strError += "<strong>Error number:</strong> "+ nErrorCount;
				strError += "<FONT size=\"-2\">&nbsp;&nbsp;&nbsp;&nbsp;(use ALT+Left and ALT+Right to navigate errors)</FONT>";
				strError += "</td></tr><tr><td style=\"background: #99CCFF;\">";
				strError += "<strong>Client:</strong> ";
				strError += "</td></tr><tr><td>";
				strError +=  navigator.userAgent;
				strError += "</td></tr></table>";
			}
			strError += "<hr size=\"1px\">";
			strError += "<a href=\"javascript:self.close();\">close window</a>";
			strError += "</BODY></HTML>";
			wndError.document.write(strError);
			wndError.document.close();
		}
	} else {
		// do nothing.
	}
	
	// return true so that the browser doesn't also handle the error
	return true;
}
window.onError = errorHandler;	// for Netscape ??
window.onerror = errorHandler;	// for IE

function showProps(obj,objName) {
	if(!bDebugMsgs) return;
	var result = "";
	var count = 0;
	for (var i in obj) {
		result += objName + "." + i + " = " + obj[i] + "\n";
		count++;
		if (count == 25) {
			alert(result);
			result = "";
			count = 0;
		}
	}
	alert(result);
}

function dumpProperties(object,objectName){
	if(!bDebugMsgs) return;
	var newWindow = window.open("","","HEIGHT=400,WIDTH=400,status=1,resizable=1,scrollbars=1")  
	newWindow.document.write("<HTML><HEAD><TITLE>"+objectName+"</TITLE></HEAD></HTML>")
	newWindow.document.write(getProperties(object));  
	newWindow.document.close();
}        
function getProperties(obj) {   
	var properties = "";   
	properties = '<HTML><HEAD><script language="JavaScript" src="../iccommon.js"><\/script></HEAD><BODY><TABLE BORDER="2" WIDTH="90%" COLS="2">';  
	properties += '<TR ALIGN="left" BGCOLOR="lightgrey"><TH>Property</TH><TH>Value</TH></TR>';  

	for (var propName in obj) {   
		//if (typeof(obj[propName]) == 'object' ){
		//	strObj = obj[propName].toString();
		//	properties +='<TR><TD>'+propName+'</TD><TD>'+strObj+'&nbsp;</TD></TR>';  
		//} else 
		properties +="<TR><TD>"+propName+"</TD><TD>"+obj[propName]+"&nbsp;</TD></TR>";  
	}   
	properties +="<TR><TD>navigator.userAgent</TD><TD>"+navigator.userAgent+"&nbsp;</TD></TR>";  
	properties +="</TABLE></BODY></HTML>";  
	return properties;   
} 

var wndDump = null;
function dump(sText){
	if(!bDebugMsgs) return;
	if (isOP7) {
		opera.postError(sText);
		return;
	}
	var d = null;
	if (wndDump != null && !wndDump.closed) {
		wndDump.focus();
		d = wndDump.document;
	} else {
		wndDump = window.open("", "dumpwin","width=700,height=350,scrollbars,resizable");
		d = wndDump.document;
		d.open();
		dump.docopen=true;
		var defaultpage = "";   
		defaultpage = '<HTML><HEAD><TITLE>Dump</TITLE></HEAD><BODY bgcolor="Red"><FORM name="dumpform">';  
		defaultpage += '<span style="color: White; font-family: monospace; padding: 0 0 0 0; font-weight: bold;">Dump window</span><BR><textarea cols="80" rows="15" name="scrollarea" readonly wrap="off"></textarea>';
		defaultpage += '<table width=600px border="0"><tr><td width="30%">&nbsp;</td><td><input type="reset" value="Clear"></td>';
		defaultpage += '<td width="30%">&nbsp;</td><td><input type="button" name="close" value="Close" onClick="opener.top.bDebugMsgs=false; self.close()"></td>';
		defaultpage += '<td width="30%">&nbsp;</td></tr></table></FORM></BODY></HTML>'; 
		d.write(defaultpage); 
		d.close();
	}
	d.dumpform.scrollarea.value=d.dumpform.scrollarea.value+sText+"\n-------------------------\n";
	return;
}


//END NON-TRANSLATABLE

